<?php
namespace PHPMaker2020\intextdesign_proj_v0;

/**
 * Page class
 */
class tabemp4_delete extends tabemp4
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{D5394950-A905-4BDF-B7DA-D47F92A453D8}";

	// Table name
	public $TableName = 'tabemp4';

	// Page object name
	public $PageObjName = "tabemp4_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tabemp4)
		if (!isset($GLOBALS["tabemp4"]) || get_class($GLOBALS["tabemp4"]) == PROJECT_NAMESPACE . "tabemp4") {
			$GLOBALS["tabemp4"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tabemp4"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tabemp4');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tabemp4;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tabemp4);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['RN'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $TotalRecords = 0;
	public $RecordCount;
	public $RecKeys = [];
	public $StartRowCount = 1;
	public $RowCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canDelete()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tabemp4list.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->RN->setVisibility();
		$this->NO_EMP->setVisibility();
		$this->NOM_EMP->setVisibility();
		$this->SEXE->setVisibility();
		$this->ETAT_C->setVisibility();
		$this->DEPEND->setVisibility();
		$this->DTE_NAIS->setVisibility();
		$this->LIEU_NAIS->setVisibility();
		$this->NATION->setVisibility();
		$this->ADRESSE->setVisibility();
		$this->VILLE->setVisibility();
		$this->PAYS->setVisibility();
		$this->BOX->setVisibility();
		$this->PHONE->setVisibility();
		$this->REFERENCE->setVisibility();
		$this->QUALIF->setVisibility();
		$this->URGENCE->setVisibility();
		$this->PHONE_URG->setVisibility();
		$this->DATE_EMP->setVisibility();
		$this->SERVICE->setVisibility();
		$this->DEPT->setVisibility();
		$this->SECTION->setVisibility();
		$this->CATEGORIE->setVisibility();
		$this->FONCTION->setVisibility();
		$this->STATUT->setVisibility();
		$this->STA_DEBUT->setVisibility();
		$this->STA_FIN->setVisibility();
		$this->STA_MOTIF->setVisibility();
		$this->NO_NIF->setVisibility();
		$this->NO_ONA->setVisibility();
		$this->LIV_TRAV->setVisibility();
		$this->MT_SALAIRE->setVisibility();
		$this->MT_FRAIS->setVisibility();
		$this->MT_AUTRES->setVisibility();
		$this->MODE->setVisibility();
		$this->TYPE->setVisibility();
		$this->MT_IMPOT->setVisibility();
		$this->PER_IMPOT->setVisibility();
		$this->PRET_ONA->setVisibility();
		$this->PER_ONA->setVisibility();
		$this->RET_ASSUR->setVisibility();
		$this->PER_ASSUR->setVisibility();
		$this->PRET_SALAIRE->setVisibility();
		$this->PER_SALAIRE->setVisibility();
		$this->RET_PENSION->setVisibility();
		$this->PER_RETPENSION->setVisibility();
		$this->PRET_BANQUE->setVisibility();
		$this->PER_BANQUE->setVisibility();
		$this->RET_AVANC->setVisibility();
		$this->PER_AVANCE->setVisibility();
		$this->PRET_PENSION->setVisibility();
		$this->PER_PENSION->setVisibility();
		$this->RET_CAFET->setVisibility();
		$this->PER_CAFET->setVisibility();
		$this->RET_CITE->setVisibility();
		$this->PER_CITE->setVisibility();
		$this->RET_AUTRE->setVisibility();
		$this->PER_AUTRE->setVisibility();
		$this->ACQ_NB_CON->setVisibility();
		$this->ACC_MT_BRUT->setVisibility();
		$this->ACC_NB_CON->setVisibility();
		$this->ACC_NB_PCON->setVisibility();
		$this->ACC_MT_OVT->setVisibility();
		$this->ACQ_NB_MAL->setVisibility();
		$this->ACC_NB_MAL->setVisibility();
		$this->ACC_MT_CON->setVisibility();
		$this->ACC_NB_MAT->setVisibility();
		$this->ACC_MT_BONI->setVisibility();
		$this->ACC_NB_PER->setVisibility();
		$this->ACC_MT_AUT->setVisibility();
		$this->ACC_NB_COM->setVisibility();
		$this->ACC_BAL_SAL->setVisibility();
		$this->ACC_BAL_BAN->setVisibility();
		$this->ACC_NB_SUS->setVisibility();
		$this->ACC_BAL_ONA->setVisibility();
		$this->ACC_BAL_PENSION->setVisibility();
		$this->ACC_NB_ABS->setVisibility();
		$this->ACC_MT_QZ->setVisibility();
		$this->ACC_NB_TRA->setVisibility();
		$this->ACC_MT_AJST->setVisibility();
		$this->ACC_NB_TRA_ACT->setVisibility();
		$this->ACC1_MT_BRUT->setVisibility();
		$this->ACC_RENDEMENT->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Set up Breadcrumb

		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("tabemp4list.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecords <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("tabemp4list.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->RN->setDbValue($row['RN']);
		$this->NO_EMP->setDbValue($row['NO_EMP']);
		$this->NOM_EMP->setDbValue($row['NOM_EMP']);
		$this->SEXE->setDbValue($row['SEXE']);
		$this->ETAT_C->setDbValue($row['ETAT_C']);
		$this->DEPEND->setDbValue($row['DEPEND']);
		$this->DTE_NAIS->setDbValue($row['DTE_NAIS']);
		$this->LIEU_NAIS->setDbValue($row['LIEU_NAIS']);
		$this->NATION->setDbValue($row['NATION']);
		$this->ADRESSE->setDbValue($row['ADRESSE']);
		$this->VILLE->setDbValue($row['VILLE']);
		$this->PAYS->setDbValue($row['PAYS']);
		$this->BOX->setDbValue($row['BOX']);
		$this->PHONE->setDbValue($row['PHONE']);
		$this->REFERENCE->setDbValue($row['REFERENCE']);
		$this->QUALIF->setDbValue($row['QUALIF']);
		$this->URGENCE->setDbValue($row['URGENCE']);
		$this->PHONE_URG->setDbValue($row['PHONE_URG']);
		$this->DATE_EMP->setDbValue($row['DATE_EMP']);
		$this->SERVICE->setDbValue($row['SERVICE']);
		$this->DEPT->setDbValue($row['DEPT']);
		$this->SECTION->setDbValue($row['SECTION']);
		$this->CATEGORIE->setDbValue($row['CATEGORIE']);
		$this->FONCTION->setDbValue($row['FONCTION']);
		$this->STATUT->setDbValue($row['STATUT']);
		$this->STA_DEBUT->setDbValue($row['STA_DEBUT']);
		$this->STA_FIN->setDbValue($row['STA_FIN']);
		$this->STA_MOTIF->setDbValue($row['STA_MOTIF']);
		$this->NO_NIF->setDbValue($row['NO_NIF']);
		$this->NO_ONA->setDbValue($row['NO_ONA']);
		$this->LIV_TRAV->setDbValue($row['LIV_TRAV']);
		$this->MT_SALAIRE->setDbValue($row['MT_SALAIRE']);
		$this->MT_FRAIS->setDbValue($row['MT_FRAIS']);
		$this->MT_AUTRES->setDbValue($row['MT_AUTRES']);
		$this->MODE->setDbValue($row['MODE']);
		$this->TYPE->setDbValue($row['TYPE']);
		$this->MT_IMPOT->setDbValue($row['MT_IMPOT']);
		$this->PER_IMPOT->setDbValue($row['PER_IMPOT']);
		$this->PRET_ONA->setDbValue($row['PRET_ONA']);
		$this->PER_ONA->setDbValue($row['PER_ONA']);
		$this->RET_ASSUR->setDbValue($row['RET_ASSUR']);
		$this->PER_ASSUR->setDbValue($row['PER_ASSUR']);
		$this->PRET_SALAIRE->setDbValue($row['PRET_SALAIRE']);
		$this->PER_SALAIRE->setDbValue($row['PER_SALAIRE']);
		$this->RET_PENSION->setDbValue($row['RET_PENSION']);
		$this->PER_RETPENSION->setDbValue($row['PER_RETPENSION']);
		$this->PRET_BANQUE->setDbValue($row['PRET_BANQUE']);
		$this->PER_BANQUE->setDbValue($row['PER_BANQUE']);
		$this->RET_AVANC->setDbValue($row['RET_AVANC']);
		$this->PER_AVANCE->setDbValue($row['PER_AVANCE']);
		$this->PRET_PENSION->setDbValue($row['PRET_PENSION']);
		$this->PER_PENSION->setDbValue($row['PER_PENSION']);
		$this->RET_CAFET->setDbValue($row['RET_CAFET']);
		$this->PER_CAFET->setDbValue($row['PER_CAFET']);
		$this->RET_CITE->setDbValue($row['RET_CITE']);
		$this->PER_CITE->setDbValue($row['PER_CITE']);
		$this->RET_AUTRE->setDbValue($row['RET_AUTRE']);
		$this->PER_AUTRE->setDbValue($row['PER_AUTRE']);
		$this->ACQ_NB_CON->setDbValue($row['ACQ_NB_CON']);
		$this->ACC_MT_BRUT->setDbValue($row['ACC_MT_BRUT']);
		$this->ACC_NB_CON->setDbValue($row['ACC_NB_CON']);
		$this->ACC_NB_PCON->setDbValue($row['ACC_NB_PCON']);
		$this->ACC_MT_OVT->setDbValue($row['ACC_MT_OVT']);
		$this->ACQ_NB_MAL->setDbValue($row['ACQ_NB_MAL']);
		$this->ACC_NB_MAL->setDbValue($row['ACC_NB_MAL']);
		$this->ACC_MT_CON->setDbValue($row['ACC_MT_CON']);
		$this->ACC_NB_MAT->setDbValue($row['ACC_NB_MAT']);
		$this->ACC_MT_BONI->setDbValue($row['ACC_MT_BONI']);
		$this->ACC_NB_PER->setDbValue($row['ACC_NB_PER']);
		$this->ACC_MT_AUT->setDbValue($row['ACC_MT_AUT']);
		$this->ACC_NB_COM->setDbValue($row['ACC_NB_COM']);
		$this->ACC_BAL_SAL->setDbValue($row['ACC_BAL_SAL']);
		$this->ACC_BAL_BAN->setDbValue($row['ACC_BAL_BAN']);
		$this->ACC_NB_SUS->setDbValue($row['ACC_NB_SUS']);
		$this->ACC_BAL_ONA->setDbValue($row['ACC_BAL_ONA']);
		$this->ACC_BAL_PENSION->setDbValue($row['ACC_BAL_PENSION']);
		$this->ACC_NB_ABS->setDbValue($row['ACC_NB_ABS']);
		$this->ACC_MT_QZ->setDbValue($row['ACC_MT_QZ']);
		$this->ACC_NB_TRA->setDbValue($row['ACC_NB_TRA']);
		$this->ACC_MT_AJST->setDbValue($row['ACC_MT_AJST']);
		$this->ACC_NB_TRA_ACT->setDbValue($row['ACC_NB_TRA_ACT']);
		$this->ACC1_MT_BRUT->setDbValue($row['ACC1_MT_BRUT']);
		$this->ACC_RENDEMENT->setDbValue($row['ACC_RENDEMENT']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['RN'] = NULL;
		$row['NO_EMP'] = NULL;
		$row['NOM_EMP'] = NULL;
		$row['SEXE'] = NULL;
		$row['ETAT_C'] = NULL;
		$row['DEPEND'] = NULL;
		$row['DTE_NAIS'] = NULL;
		$row['LIEU_NAIS'] = NULL;
		$row['NATION'] = NULL;
		$row['ADRESSE'] = NULL;
		$row['VILLE'] = NULL;
		$row['PAYS'] = NULL;
		$row['BOX'] = NULL;
		$row['PHONE'] = NULL;
		$row['REFERENCE'] = NULL;
		$row['QUALIF'] = NULL;
		$row['URGENCE'] = NULL;
		$row['PHONE_URG'] = NULL;
		$row['DATE_EMP'] = NULL;
		$row['SERVICE'] = NULL;
		$row['DEPT'] = NULL;
		$row['SECTION'] = NULL;
		$row['CATEGORIE'] = NULL;
		$row['FONCTION'] = NULL;
		$row['STATUT'] = NULL;
		$row['STA_DEBUT'] = NULL;
		$row['STA_FIN'] = NULL;
		$row['STA_MOTIF'] = NULL;
		$row['NO_NIF'] = NULL;
		$row['NO_ONA'] = NULL;
		$row['LIV_TRAV'] = NULL;
		$row['MT_SALAIRE'] = NULL;
		$row['MT_FRAIS'] = NULL;
		$row['MT_AUTRES'] = NULL;
		$row['MODE'] = NULL;
		$row['TYPE'] = NULL;
		$row['MT_IMPOT'] = NULL;
		$row['PER_IMPOT'] = NULL;
		$row['PRET_ONA'] = NULL;
		$row['PER_ONA'] = NULL;
		$row['RET_ASSUR'] = NULL;
		$row['PER_ASSUR'] = NULL;
		$row['PRET_SALAIRE'] = NULL;
		$row['PER_SALAIRE'] = NULL;
		$row['RET_PENSION'] = NULL;
		$row['PER_RETPENSION'] = NULL;
		$row['PRET_BANQUE'] = NULL;
		$row['PER_BANQUE'] = NULL;
		$row['RET_AVANC'] = NULL;
		$row['PER_AVANCE'] = NULL;
		$row['PRET_PENSION'] = NULL;
		$row['PER_PENSION'] = NULL;
		$row['RET_CAFET'] = NULL;
		$row['PER_CAFET'] = NULL;
		$row['RET_CITE'] = NULL;
		$row['PER_CITE'] = NULL;
		$row['RET_AUTRE'] = NULL;
		$row['PER_AUTRE'] = NULL;
		$row['ACQ_NB_CON'] = NULL;
		$row['ACC_MT_BRUT'] = NULL;
		$row['ACC_NB_CON'] = NULL;
		$row['ACC_NB_PCON'] = NULL;
		$row['ACC_MT_OVT'] = NULL;
		$row['ACQ_NB_MAL'] = NULL;
		$row['ACC_NB_MAL'] = NULL;
		$row['ACC_MT_CON'] = NULL;
		$row['ACC_NB_MAT'] = NULL;
		$row['ACC_MT_BONI'] = NULL;
		$row['ACC_NB_PER'] = NULL;
		$row['ACC_MT_AUT'] = NULL;
		$row['ACC_NB_COM'] = NULL;
		$row['ACC_BAL_SAL'] = NULL;
		$row['ACC_BAL_BAN'] = NULL;
		$row['ACC_NB_SUS'] = NULL;
		$row['ACC_BAL_ONA'] = NULL;
		$row['ACC_BAL_PENSION'] = NULL;
		$row['ACC_NB_ABS'] = NULL;
		$row['ACC_MT_QZ'] = NULL;
		$row['ACC_NB_TRA'] = NULL;
		$row['ACC_MT_AJST'] = NULL;
		$row['ACC_NB_TRA_ACT'] = NULL;
		$row['ACC1_MT_BRUT'] = NULL;
		$row['ACC_RENDEMENT'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->id->FormValue == $this->id->CurrentValue && is_numeric(ConvertToFloatString($this->id->CurrentValue)))
			$this->id->CurrentValue = ConvertToFloatString($this->id->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RN->FormValue == $this->RN->CurrentValue && is_numeric(ConvertToFloatString($this->RN->CurrentValue)))
			$this->RN->CurrentValue = ConvertToFloatString($this->RN->CurrentValue);

		// Convert decimal values if posted back
		if ($this->NO_EMP->FormValue == $this->NO_EMP->CurrentValue && is_numeric(ConvertToFloatString($this->NO_EMP->CurrentValue)))
			$this->NO_EMP->CurrentValue = ConvertToFloatString($this->NO_EMP->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DEPEND->FormValue == $this->DEPEND->CurrentValue && is_numeric(ConvertToFloatString($this->DEPEND->CurrentValue)))
			$this->DEPEND->CurrentValue = ConvertToFloatString($this->DEPEND->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DEPT->FormValue == $this->DEPT->CurrentValue && is_numeric(ConvertToFloatString($this->DEPT->CurrentValue)))
			$this->DEPT->CurrentValue = ConvertToFloatString($this->DEPT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->NO_NIF->FormValue == $this->NO_NIF->CurrentValue && is_numeric(ConvertToFloatString($this->NO_NIF->CurrentValue)))
			$this->NO_NIF->CurrentValue = ConvertToFloatString($this->NO_NIF->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_SALAIRE->FormValue == $this->MT_SALAIRE->CurrentValue && is_numeric(ConvertToFloatString($this->MT_SALAIRE->CurrentValue)))
			$this->MT_SALAIRE->CurrentValue = ConvertToFloatString($this->MT_SALAIRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_FRAIS->FormValue == $this->MT_FRAIS->CurrentValue && is_numeric(ConvertToFloatString($this->MT_FRAIS->CurrentValue)))
			$this->MT_FRAIS->CurrentValue = ConvertToFloatString($this->MT_FRAIS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_AUTRES->FormValue == $this->MT_AUTRES->CurrentValue && is_numeric(ConvertToFloatString($this->MT_AUTRES->CurrentValue)))
			$this->MT_AUTRES->CurrentValue = ConvertToFloatString($this->MT_AUTRES->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_IMPOT->FormValue == $this->MT_IMPOT->CurrentValue && is_numeric(ConvertToFloatString($this->MT_IMPOT->CurrentValue)))
			$this->MT_IMPOT->CurrentValue = ConvertToFloatString($this->MT_IMPOT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_ONA->FormValue == $this->PRET_ONA->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_ONA->CurrentValue)))
			$this->PRET_ONA->CurrentValue = ConvertToFloatString($this->PRET_ONA->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_ASSUR->FormValue == $this->RET_ASSUR->CurrentValue && is_numeric(ConvertToFloatString($this->RET_ASSUR->CurrentValue)))
			$this->RET_ASSUR->CurrentValue = ConvertToFloatString($this->RET_ASSUR->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_SALAIRE->FormValue == $this->PRET_SALAIRE->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_SALAIRE->CurrentValue)))
			$this->PRET_SALAIRE->CurrentValue = ConvertToFloatString($this->PRET_SALAIRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PER_SALAIRE->FormValue == $this->PER_SALAIRE->CurrentValue && is_numeric(ConvertToFloatString($this->PER_SALAIRE->CurrentValue)))
			$this->PER_SALAIRE->CurrentValue = ConvertToFloatString($this->PER_SALAIRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_PENSION->FormValue == $this->RET_PENSION->CurrentValue && is_numeric(ConvertToFloatString($this->RET_PENSION->CurrentValue)))
			$this->RET_PENSION->CurrentValue = ConvertToFloatString($this->RET_PENSION->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_BANQUE->FormValue == $this->PRET_BANQUE->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_BANQUE->CurrentValue)))
			$this->PRET_BANQUE->CurrentValue = ConvertToFloatString($this->PRET_BANQUE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PER_BANQUE->FormValue == $this->PER_BANQUE->CurrentValue && is_numeric(ConvertToFloatString($this->PER_BANQUE->CurrentValue)))
			$this->PER_BANQUE->CurrentValue = ConvertToFloatString($this->PER_BANQUE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_AVANC->FormValue == $this->RET_AVANC->CurrentValue && is_numeric(ConvertToFloatString($this->RET_AVANC->CurrentValue)))
			$this->RET_AVANC->CurrentValue = ConvertToFloatString($this->RET_AVANC->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_PENSION->FormValue == $this->PRET_PENSION->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_PENSION->CurrentValue)))
			$this->PRET_PENSION->CurrentValue = ConvertToFloatString($this->PRET_PENSION->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_CAFET->FormValue == $this->RET_CAFET->CurrentValue && is_numeric(ConvertToFloatString($this->RET_CAFET->CurrentValue)))
			$this->RET_CAFET->CurrentValue = ConvertToFloatString($this->RET_CAFET->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_CITE->FormValue == $this->RET_CITE->CurrentValue && is_numeric(ConvertToFloatString($this->RET_CITE->CurrentValue)))
			$this->RET_CITE->CurrentValue = ConvertToFloatString($this->RET_CITE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_AUTRE->FormValue == $this->RET_AUTRE->CurrentValue && is_numeric(ConvertToFloatString($this->RET_AUTRE->CurrentValue)))
			$this->RET_AUTRE->CurrentValue = ConvertToFloatString($this->RET_AUTRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACQ_NB_CON->FormValue == $this->ACQ_NB_CON->CurrentValue && is_numeric(ConvertToFloatString($this->ACQ_NB_CON->CurrentValue)))
			$this->ACQ_NB_CON->CurrentValue = ConvertToFloatString($this->ACQ_NB_CON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_BRUT->FormValue == $this->ACC_MT_BRUT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_BRUT->CurrentValue)))
			$this->ACC_MT_BRUT->CurrentValue = ConvertToFloatString($this->ACC_MT_BRUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_CON->FormValue == $this->ACC_NB_CON->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_CON->CurrentValue)))
			$this->ACC_NB_CON->CurrentValue = ConvertToFloatString($this->ACC_NB_CON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_PCON->FormValue == $this->ACC_NB_PCON->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_PCON->CurrentValue)))
			$this->ACC_NB_PCON->CurrentValue = ConvertToFloatString($this->ACC_NB_PCON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_OVT->FormValue == $this->ACC_MT_OVT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_OVT->CurrentValue)))
			$this->ACC_MT_OVT->CurrentValue = ConvertToFloatString($this->ACC_MT_OVT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACQ_NB_MAL->FormValue == $this->ACQ_NB_MAL->CurrentValue && is_numeric(ConvertToFloatString($this->ACQ_NB_MAL->CurrentValue)))
			$this->ACQ_NB_MAL->CurrentValue = ConvertToFloatString($this->ACQ_NB_MAL->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_MAL->FormValue == $this->ACC_NB_MAL->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_MAL->CurrentValue)))
			$this->ACC_NB_MAL->CurrentValue = ConvertToFloatString($this->ACC_NB_MAL->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_CON->FormValue == $this->ACC_MT_CON->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_CON->CurrentValue)))
			$this->ACC_MT_CON->CurrentValue = ConvertToFloatString($this->ACC_MT_CON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_MAT->FormValue == $this->ACC_NB_MAT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_MAT->CurrentValue)))
			$this->ACC_NB_MAT->CurrentValue = ConvertToFloatString($this->ACC_NB_MAT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_BONI->FormValue == $this->ACC_MT_BONI->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_BONI->CurrentValue)))
			$this->ACC_MT_BONI->CurrentValue = ConvertToFloatString($this->ACC_MT_BONI->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_PER->FormValue == $this->ACC_NB_PER->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_PER->CurrentValue)))
			$this->ACC_NB_PER->CurrentValue = ConvertToFloatString($this->ACC_NB_PER->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_AUT->FormValue == $this->ACC_MT_AUT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_AUT->CurrentValue)))
			$this->ACC_MT_AUT->CurrentValue = ConvertToFloatString($this->ACC_MT_AUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_COM->FormValue == $this->ACC_NB_COM->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_COM->CurrentValue)))
			$this->ACC_NB_COM->CurrentValue = ConvertToFloatString($this->ACC_NB_COM->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_SAL->FormValue == $this->ACC_BAL_SAL->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_SAL->CurrentValue)))
			$this->ACC_BAL_SAL->CurrentValue = ConvertToFloatString($this->ACC_BAL_SAL->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_BAN->FormValue == $this->ACC_BAL_BAN->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_BAN->CurrentValue)))
			$this->ACC_BAL_BAN->CurrentValue = ConvertToFloatString($this->ACC_BAL_BAN->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_SUS->FormValue == $this->ACC_NB_SUS->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_SUS->CurrentValue)))
			$this->ACC_NB_SUS->CurrentValue = ConvertToFloatString($this->ACC_NB_SUS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_ONA->FormValue == $this->ACC_BAL_ONA->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_ONA->CurrentValue)))
			$this->ACC_BAL_ONA->CurrentValue = ConvertToFloatString($this->ACC_BAL_ONA->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_PENSION->FormValue == $this->ACC_BAL_PENSION->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_PENSION->CurrentValue)))
			$this->ACC_BAL_PENSION->CurrentValue = ConvertToFloatString($this->ACC_BAL_PENSION->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_ABS->FormValue == $this->ACC_NB_ABS->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_ABS->CurrentValue)))
			$this->ACC_NB_ABS->CurrentValue = ConvertToFloatString($this->ACC_NB_ABS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_QZ->FormValue == $this->ACC_MT_QZ->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_QZ->CurrentValue)))
			$this->ACC_MT_QZ->CurrentValue = ConvertToFloatString($this->ACC_MT_QZ->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_TRA->FormValue == $this->ACC_NB_TRA->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_TRA->CurrentValue)))
			$this->ACC_NB_TRA->CurrentValue = ConvertToFloatString($this->ACC_NB_TRA->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_AJST->FormValue == $this->ACC_MT_AJST->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_AJST->CurrentValue)))
			$this->ACC_MT_AJST->CurrentValue = ConvertToFloatString($this->ACC_MT_AJST->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_TRA_ACT->FormValue == $this->ACC_NB_TRA_ACT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_TRA_ACT->CurrentValue)))
			$this->ACC_NB_TRA_ACT->CurrentValue = ConvertToFloatString($this->ACC_NB_TRA_ACT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC1_MT_BRUT->FormValue == $this->ACC1_MT_BRUT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC1_MT_BRUT->CurrentValue)))
			$this->ACC1_MT_BRUT->CurrentValue = ConvertToFloatString($this->ACC1_MT_BRUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_RENDEMENT->FormValue == $this->ACC_RENDEMENT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_RENDEMENT->CurrentValue)))
			$this->ACC_RENDEMENT->CurrentValue = ConvertToFloatString($this->ACC_RENDEMENT->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// RN
		// NO_EMP
		// NOM_EMP
		// SEXE
		// ETAT_C
		// DEPEND
		// DTE_NAIS
		// LIEU_NAIS
		// NATION
		// ADRESSE
		// VILLE
		// PAYS
		// BOX
		// PHONE
		// REFERENCE
		// QUALIF
		// URGENCE
		// PHONE_URG
		// DATE_EMP
		// SERVICE
		// DEPT
		// SECTION
		// CATEGORIE
		// FONCTION
		// STATUT
		// STA_DEBUT
		// STA_FIN
		// STA_MOTIF
		// NO_NIF
		// NO_ONA
		// LIV_TRAV
		// MT_SALAIRE
		// MT_FRAIS
		// MT_AUTRES
		// MODE
		// TYPE
		// MT_IMPOT
		// PER_IMPOT
		// PRET_ONA
		// PER_ONA
		// RET_ASSUR
		// PER_ASSUR
		// PRET_SALAIRE
		// PER_SALAIRE
		// RET_PENSION
		// PER_RETPENSION
		// PRET_BANQUE
		// PER_BANQUE
		// RET_AVANC
		// PER_AVANCE
		// PRET_PENSION
		// PER_PENSION
		// RET_CAFET
		// PER_CAFET
		// RET_CITE
		// PER_CITE
		// RET_AUTRE
		// PER_AUTRE
		// ACQ_NB_CON
		// ACC_MT_BRUT
		// ACC_NB_CON
		// ACC_NB_PCON
		// ACC_MT_OVT
		// ACQ_NB_MAL
		// ACC_NB_MAL
		// ACC_MT_CON
		// ACC_NB_MAT
		// ACC_MT_BONI
		// ACC_NB_PER
		// ACC_MT_AUT
		// ACC_NB_COM
		// ACC_BAL_SAL
		// ACC_BAL_BAN
		// ACC_NB_SUS
		// ACC_BAL_ONA
		// ACC_BAL_PENSION
		// ACC_NB_ABS
		// ACC_MT_QZ
		// ACC_NB_TRA
		// ACC_MT_AJST
		// ACC_NB_TRA_ACT
		// ACC1_MT_BRUT
		// ACC_RENDEMENT

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, Config("DEFAULT_DECIMAL_PRECISION"));
			$this->id->ViewCustomAttributes = "";

			// RN
			$this->RN->ViewValue = $this->RN->CurrentValue;
			$this->RN->ViewValue = FormatNumber($this->RN->ViewValue, Config("DEFAULT_DECIMAL_PRECISION"));
			$this->RN->ViewCustomAttributes = "";

			// NO_EMP
			$this->NO_EMP->ViewValue = $this->NO_EMP->CurrentValue;
			$this->NO_EMP->ViewValue = FormatNumber($this->NO_EMP->ViewValue, 2, -2, -2, -2);
			$this->NO_EMP->ViewCustomAttributes = "";

			// NOM_EMP
			$this->NOM_EMP->ViewValue = $this->NOM_EMP->CurrentValue;
			$this->NOM_EMP->ViewCustomAttributes = "";

			// SEXE
			$this->SEXE->ViewValue = $this->SEXE->CurrentValue;
			$this->SEXE->ViewCustomAttributes = "";

			// ETAT_C
			$this->ETAT_C->ViewValue = $this->ETAT_C->CurrentValue;
			$this->ETAT_C->ViewCustomAttributes = "";

			// DEPEND
			$this->DEPEND->ViewValue = $this->DEPEND->CurrentValue;
			$this->DEPEND->ViewValue = FormatNumber($this->DEPEND->ViewValue, 2, -2, -2, -2);
			$this->DEPEND->ViewCustomAttributes = "";

			// DTE_NAIS
			$this->DTE_NAIS->ViewValue = $this->DTE_NAIS->CurrentValue;
			$this->DTE_NAIS->ViewValue = FormatDateTime($this->DTE_NAIS->ViewValue, 0);
			$this->DTE_NAIS->ViewCustomAttributes = "";

			// LIEU_NAIS
			$this->LIEU_NAIS->ViewValue = $this->LIEU_NAIS->CurrentValue;
			$this->LIEU_NAIS->ViewCustomAttributes = "";

			// NATION
			$this->NATION->ViewValue = $this->NATION->CurrentValue;
			$this->NATION->ViewCustomAttributes = "";

			// ADRESSE
			$this->ADRESSE->ViewValue = $this->ADRESSE->CurrentValue;
			$this->ADRESSE->ViewCustomAttributes = "";

			// VILLE
			$this->VILLE->ViewValue = $this->VILLE->CurrentValue;
			$this->VILLE->ViewCustomAttributes = "";

			// PAYS
			$this->PAYS->ViewValue = $this->PAYS->CurrentValue;
			$this->PAYS->ViewCustomAttributes = "";

			// BOX
			$this->BOX->ViewValue = $this->BOX->CurrentValue;
			$this->BOX->ViewCustomAttributes = "";

			// PHONE
			$this->PHONE->ViewValue = $this->PHONE->CurrentValue;
			$this->PHONE->ViewCustomAttributes = "";

			// REFERENCE
			$this->REFERENCE->ViewValue = $this->REFERENCE->CurrentValue;
			$this->REFERENCE->ViewCustomAttributes = "";

			// QUALIF
			$this->QUALIF->ViewValue = $this->QUALIF->CurrentValue;
			$this->QUALIF->ViewCustomAttributes = "";

			// URGENCE
			$this->URGENCE->ViewValue = $this->URGENCE->CurrentValue;
			$this->URGENCE->ViewCustomAttributes = "";

			// PHONE_URG
			$this->PHONE_URG->ViewValue = $this->PHONE_URG->CurrentValue;
			$this->PHONE_URG->ViewCustomAttributes = "";

			// DATE_EMP
			$this->DATE_EMP->ViewValue = $this->DATE_EMP->CurrentValue;
			$this->DATE_EMP->ViewValue = FormatDateTime($this->DATE_EMP->ViewValue, 0);
			$this->DATE_EMP->ViewCustomAttributes = "";

			// SERVICE
			$this->SERVICE->ViewValue = $this->SERVICE->CurrentValue;
			$this->SERVICE->ViewCustomAttributes = "";

			// DEPT
			$this->DEPT->ViewValue = $this->DEPT->CurrentValue;
			$this->DEPT->ViewValue = FormatNumber($this->DEPT->ViewValue, 2, -2, -2, -2);
			$this->DEPT->ViewCustomAttributes = "";

			// SECTION
			$this->SECTION->ViewValue = $this->SECTION->CurrentValue;
			$this->SECTION->ViewCustomAttributes = "";

			// CATEGORIE
			$this->CATEGORIE->ViewValue = $this->CATEGORIE->CurrentValue;
			$this->CATEGORIE->ViewCustomAttributes = "";

			// FONCTION
			$this->FONCTION->ViewValue = $this->FONCTION->CurrentValue;
			$this->FONCTION->ViewCustomAttributes = "";

			// STATUT
			$this->STATUT->ViewValue = $this->STATUT->CurrentValue;
			$this->STATUT->ViewCustomAttributes = "";

			// STA_DEBUT
			$this->STA_DEBUT->ViewValue = $this->STA_DEBUT->CurrentValue;
			$this->STA_DEBUT->ViewValue = FormatDateTime($this->STA_DEBUT->ViewValue, 0);
			$this->STA_DEBUT->ViewCustomAttributes = "";

			// STA_FIN
			$this->STA_FIN->ViewValue = $this->STA_FIN->CurrentValue;
			$this->STA_FIN->ViewValue = FormatDateTime($this->STA_FIN->ViewValue, 0);
			$this->STA_FIN->ViewCustomAttributes = "";

			// STA_MOTIF
			$this->STA_MOTIF->ViewValue = $this->STA_MOTIF->CurrentValue;
			$this->STA_MOTIF->ViewCustomAttributes = "";

			// NO_NIF
			$this->NO_NIF->ViewValue = $this->NO_NIF->CurrentValue;
			$this->NO_NIF->ViewValue = FormatNumber($this->NO_NIF->ViewValue, 2, -2, -2, -2);
			$this->NO_NIF->ViewCustomAttributes = "";

			// NO_ONA
			$this->NO_ONA->ViewValue = $this->NO_ONA->CurrentValue;
			$this->NO_ONA->ViewCustomAttributes = "";

			// LIV_TRAV
			$this->LIV_TRAV->ViewValue = $this->LIV_TRAV->CurrentValue;
			$this->LIV_TRAV->ViewCustomAttributes = "";

			// MT_SALAIRE
			$this->MT_SALAIRE->ViewValue = $this->MT_SALAIRE->CurrentValue;
			$this->MT_SALAIRE->ViewValue = FormatNumber($this->MT_SALAIRE->ViewValue, 2, -2, -2, -2);
			$this->MT_SALAIRE->ViewCustomAttributes = "";

			// MT_FRAIS
			$this->MT_FRAIS->ViewValue = $this->MT_FRAIS->CurrentValue;
			$this->MT_FRAIS->ViewValue = FormatNumber($this->MT_FRAIS->ViewValue, 2, -2, -2, -2);
			$this->MT_FRAIS->ViewCustomAttributes = "";

			// MT_AUTRES
			$this->MT_AUTRES->ViewValue = $this->MT_AUTRES->CurrentValue;
			$this->MT_AUTRES->ViewValue = FormatNumber($this->MT_AUTRES->ViewValue, 2, -2, -2, -2);
			$this->MT_AUTRES->ViewCustomAttributes = "";

			// MODE
			$this->MODE->ViewValue = $this->MODE->CurrentValue;
			$this->MODE->ViewCustomAttributes = "";

			// TYPE
			$this->TYPE->ViewValue = $this->TYPE->CurrentValue;
			$this->TYPE->ViewCustomAttributes = "";

			// MT_IMPOT
			$this->MT_IMPOT->ViewValue = $this->MT_IMPOT->CurrentValue;
			$this->MT_IMPOT->ViewValue = FormatNumber($this->MT_IMPOT->ViewValue, 2, -2, -2, -2);
			$this->MT_IMPOT->ViewCustomAttributes = "";

			// PER_IMPOT
			$this->PER_IMPOT->ViewValue = $this->PER_IMPOT->CurrentValue;
			$this->PER_IMPOT->ViewCustomAttributes = "";

			// PRET_ONA
			$this->PRET_ONA->ViewValue = $this->PRET_ONA->CurrentValue;
			$this->PRET_ONA->ViewValue = FormatNumber($this->PRET_ONA->ViewValue, 2, -2, -2, -2);
			$this->PRET_ONA->ViewCustomAttributes = "";

			// PER_ONA
			$this->PER_ONA->ViewValue = $this->PER_ONA->CurrentValue;
			$this->PER_ONA->ViewCustomAttributes = "";

			// RET_ASSUR
			$this->RET_ASSUR->ViewValue = $this->RET_ASSUR->CurrentValue;
			$this->RET_ASSUR->ViewValue = FormatNumber($this->RET_ASSUR->ViewValue, 2, -2, -2, -2);
			$this->RET_ASSUR->ViewCustomAttributes = "";

			// PER_ASSUR
			$this->PER_ASSUR->ViewValue = $this->PER_ASSUR->CurrentValue;
			$this->PER_ASSUR->ViewCustomAttributes = "";

			// PRET_SALAIRE
			$this->PRET_SALAIRE->ViewValue = $this->PRET_SALAIRE->CurrentValue;
			$this->PRET_SALAIRE->ViewValue = FormatNumber($this->PRET_SALAIRE->ViewValue, 2, -2, -2, -2);
			$this->PRET_SALAIRE->ViewCustomAttributes = "";

			// PER_SALAIRE
			$this->PER_SALAIRE->ViewValue = $this->PER_SALAIRE->CurrentValue;
			$this->PER_SALAIRE->ViewValue = FormatNumber($this->PER_SALAIRE->ViewValue, 2, -2, -2, -2);
			$this->PER_SALAIRE->ViewCustomAttributes = "";

			// RET_PENSION
			$this->RET_PENSION->ViewValue = $this->RET_PENSION->CurrentValue;
			$this->RET_PENSION->ViewValue = FormatNumber($this->RET_PENSION->ViewValue, 2, -2, -2, -2);
			$this->RET_PENSION->ViewCustomAttributes = "";

			// PER_RETPENSION
			$this->PER_RETPENSION->ViewValue = $this->PER_RETPENSION->CurrentValue;
			$this->PER_RETPENSION->ViewCustomAttributes = "";

			// PRET_BANQUE
			$this->PRET_BANQUE->ViewValue = $this->PRET_BANQUE->CurrentValue;
			$this->PRET_BANQUE->ViewValue = FormatNumber($this->PRET_BANQUE->ViewValue, 2, -2, -2, -2);
			$this->PRET_BANQUE->ViewCustomAttributes = "";

			// PER_BANQUE
			$this->PER_BANQUE->ViewValue = $this->PER_BANQUE->CurrentValue;
			$this->PER_BANQUE->ViewValue = FormatNumber($this->PER_BANQUE->ViewValue, 2, -2, -2, -2);
			$this->PER_BANQUE->ViewCustomAttributes = "";

			// RET_AVANC
			$this->RET_AVANC->ViewValue = $this->RET_AVANC->CurrentValue;
			$this->RET_AVANC->ViewValue = FormatNumber($this->RET_AVANC->ViewValue, 2, -2, -2, -2);
			$this->RET_AVANC->ViewCustomAttributes = "";

			// PER_AVANCE
			$this->PER_AVANCE->ViewValue = $this->PER_AVANCE->CurrentValue;
			$this->PER_AVANCE->ViewCustomAttributes = "";

			// PRET_PENSION
			$this->PRET_PENSION->ViewValue = $this->PRET_PENSION->CurrentValue;
			$this->PRET_PENSION->ViewValue = FormatNumber($this->PRET_PENSION->ViewValue, 2, -2, -2, -2);
			$this->PRET_PENSION->ViewCustomAttributes = "";

			// PER_PENSION
			$this->PER_PENSION->ViewValue = $this->PER_PENSION->CurrentValue;
			$this->PER_PENSION->ViewCustomAttributes = "";

			// RET_CAFET
			$this->RET_CAFET->ViewValue = $this->RET_CAFET->CurrentValue;
			$this->RET_CAFET->ViewValue = FormatNumber($this->RET_CAFET->ViewValue, 2, -2, -2, -2);
			$this->RET_CAFET->ViewCustomAttributes = "";

			// PER_CAFET
			$this->PER_CAFET->ViewValue = $this->PER_CAFET->CurrentValue;
			$this->PER_CAFET->ViewCustomAttributes = "";

			// RET_CITE
			$this->RET_CITE->ViewValue = $this->RET_CITE->CurrentValue;
			$this->RET_CITE->ViewValue = FormatNumber($this->RET_CITE->ViewValue, 2, -2, -2, -2);
			$this->RET_CITE->ViewCustomAttributes = "";

			// PER_CITE
			$this->PER_CITE->ViewValue = $this->PER_CITE->CurrentValue;
			$this->PER_CITE->ViewCustomAttributes = "";

			// RET_AUTRE
			$this->RET_AUTRE->ViewValue = $this->RET_AUTRE->CurrentValue;
			$this->RET_AUTRE->ViewValue = FormatNumber($this->RET_AUTRE->ViewValue, 2, -2, -2, -2);
			$this->RET_AUTRE->ViewCustomAttributes = "";

			// PER_AUTRE
			$this->PER_AUTRE->ViewValue = $this->PER_AUTRE->CurrentValue;
			$this->PER_AUTRE->ViewCustomAttributes = "";

			// ACQ_NB_CON
			$this->ACQ_NB_CON->ViewValue = $this->ACQ_NB_CON->CurrentValue;
			$this->ACQ_NB_CON->ViewValue = FormatNumber($this->ACQ_NB_CON->ViewValue, 2, -2, -2, -2);
			$this->ACQ_NB_CON->ViewCustomAttributes = "";

			// ACC_MT_BRUT
			$this->ACC_MT_BRUT->ViewValue = $this->ACC_MT_BRUT->CurrentValue;
			$this->ACC_MT_BRUT->ViewValue = FormatNumber($this->ACC_MT_BRUT->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_BRUT->ViewCustomAttributes = "";

			// ACC_NB_CON
			$this->ACC_NB_CON->ViewValue = $this->ACC_NB_CON->CurrentValue;
			$this->ACC_NB_CON->ViewValue = FormatNumber($this->ACC_NB_CON->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_CON->ViewCustomAttributes = "";

			// ACC_NB_PCON
			$this->ACC_NB_PCON->ViewValue = $this->ACC_NB_PCON->CurrentValue;
			$this->ACC_NB_PCON->ViewValue = FormatNumber($this->ACC_NB_PCON->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_PCON->ViewCustomAttributes = "";

			// ACC_MT_OVT
			$this->ACC_MT_OVT->ViewValue = $this->ACC_MT_OVT->CurrentValue;
			$this->ACC_MT_OVT->ViewValue = FormatNumber($this->ACC_MT_OVT->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_OVT->ViewCustomAttributes = "";

			// ACQ_NB_MAL
			$this->ACQ_NB_MAL->ViewValue = $this->ACQ_NB_MAL->CurrentValue;
			$this->ACQ_NB_MAL->ViewValue = FormatNumber($this->ACQ_NB_MAL->ViewValue, 2, -2, -2, -2);
			$this->ACQ_NB_MAL->ViewCustomAttributes = "";

			// ACC_NB_MAL
			$this->ACC_NB_MAL->ViewValue = $this->ACC_NB_MAL->CurrentValue;
			$this->ACC_NB_MAL->ViewValue = FormatNumber($this->ACC_NB_MAL->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_MAL->ViewCustomAttributes = "";

			// ACC_MT_CON
			$this->ACC_MT_CON->ViewValue = $this->ACC_MT_CON->CurrentValue;
			$this->ACC_MT_CON->ViewValue = FormatNumber($this->ACC_MT_CON->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_CON->ViewCustomAttributes = "";

			// ACC_NB_MAT
			$this->ACC_NB_MAT->ViewValue = $this->ACC_NB_MAT->CurrentValue;
			$this->ACC_NB_MAT->ViewValue = FormatNumber($this->ACC_NB_MAT->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_MAT->ViewCustomAttributes = "";

			// ACC_MT_BONI
			$this->ACC_MT_BONI->ViewValue = $this->ACC_MT_BONI->CurrentValue;
			$this->ACC_MT_BONI->ViewValue = FormatNumber($this->ACC_MT_BONI->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_BONI->ViewCustomAttributes = "";

			// ACC_NB_PER
			$this->ACC_NB_PER->ViewValue = $this->ACC_NB_PER->CurrentValue;
			$this->ACC_NB_PER->ViewValue = FormatNumber($this->ACC_NB_PER->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_PER->ViewCustomAttributes = "";

			// ACC_MT_AUT
			$this->ACC_MT_AUT->ViewValue = $this->ACC_MT_AUT->CurrentValue;
			$this->ACC_MT_AUT->ViewValue = FormatNumber($this->ACC_MT_AUT->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_AUT->ViewCustomAttributes = "";

			// ACC_NB_COM
			$this->ACC_NB_COM->ViewValue = $this->ACC_NB_COM->CurrentValue;
			$this->ACC_NB_COM->ViewValue = FormatNumber($this->ACC_NB_COM->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_COM->ViewCustomAttributes = "";

			// ACC_BAL_SAL
			$this->ACC_BAL_SAL->ViewValue = $this->ACC_BAL_SAL->CurrentValue;
			$this->ACC_BAL_SAL->ViewValue = FormatNumber($this->ACC_BAL_SAL->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_SAL->ViewCustomAttributes = "";

			// ACC_BAL_BAN
			$this->ACC_BAL_BAN->ViewValue = $this->ACC_BAL_BAN->CurrentValue;
			$this->ACC_BAL_BAN->ViewValue = FormatNumber($this->ACC_BAL_BAN->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_BAN->ViewCustomAttributes = "";

			// ACC_NB_SUS
			$this->ACC_NB_SUS->ViewValue = $this->ACC_NB_SUS->CurrentValue;
			$this->ACC_NB_SUS->ViewValue = FormatNumber($this->ACC_NB_SUS->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_SUS->ViewCustomAttributes = "";

			// ACC_BAL_ONA
			$this->ACC_BAL_ONA->ViewValue = $this->ACC_BAL_ONA->CurrentValue;
			$this->ACC_BAL_ONA->ViewValue = FormatNumber($this->ACC_BAL_ONA->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_ONA->ViewCustomAttributes = "";

			// ACC_BAL_PENSION
			$this->ACC_BAL_PENSION->ViewValue = $this->ACC_BAL_PENSION->CurrentValue;
			$this->ACC_BAL_PENSION->ViewValue = FormatNumber($this->ACC_BAL_PENSION->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_PENSION->ViewCustomAttributes = "";

			// ACC_NB_ABS
			$this->ACC_NB_ABS->ViewValue = $this->ACC_NB_ABS->CurrentValue;
			$this->ACC_NB_ABS->ViewValue = FormatNumber($this->ACC_NB_ABS->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_ABS->ViewCustomAttributes = "";

			// ACC_MT_QZ
			$this->ACC_MT_QZ->ViewValue = $this->ACC_MT_QZ->CurrentValue;
			$this->ACC_MT_QZ->ViewValue = FormatNumber($this->ACC_MT_QZ->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_QZ->ViewCustomAttributes = "";

			// ACC_NB_TRA
			$this->ACC_NB_TRA->ViewValue = $this->ACC_NB_TRA->CurrentValue;
			$this->ACC_NB_TRA->ViewValue = FormatNumber($this->ACC_NB_TRA->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_TRA->ViewCustomAttributes = "";

			// ACC_MT_AJST
			$this->ACC_MT_AJST->ViewValue = $this->ACC_MT_AJST->CurrentValue;
			$this->ACC_MT_AJST->ViewValue = FormatNumber($this->ACC_MT_AJST->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_AJST->ViewCustomAttributes = "";

			// ACC_NB_TRA_ACT
			$this->ACC_NB_TRA_ACT->ViewValue = $this->ACC_NB_TRA_ACT->CurrentValue;
			$this->ACC_NB_TRA_ACT->ViewValue = FormatNumber($this->ACC_NB_TRA_ACT->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_TRA_ACT->ViewCustomAttributes = "";

			// ACC1_MT_BRUT
			$this->ACC1_MT_BRUT->ViewValue = $this->ACC1_MT_BRUT->CurrentValue;
			$this->ACC1_MT_BRUT->ViewValue = FormatNumber($this->ACC1_MT_BRUT->ViewValue, 2, -2, -2, -2);
			$this->ACC1_MT_BRUT->ViewCustomAttributes = "";

			// ACC_RENDEMENT
			$this->ACC_RENDEMENT->ViewValue = $this->ACC_RENDEMENT->CurrentValue;
			$this->ACC_RENDEMENT->ViewValue = FormatNumber($this->ACC_RENDEMENT->ViewValue, 2, -2, -2, -2);
			$this->ACC_RENDEMENT->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// RN
			$this->RN->LinkCustomAttributes = "";
			$this->RN->HrefValue = "";
			$this->RN->TooltipValue = "";

			// NO_EMP
			$this->NO_EMP->LinkCustomAttributes = "";
			$this->NO_EMP->HrefValue = "";
			$this->NO_EMP->TooltipValue = "";

			// NOM_EMP
			$this->NOM_EMP->LinkCustomAttributes = "";
			$this->NOM_EMP->HrefValue = "";
			$this->NOM_EMP->TooltipValue = "";

			// SEXE
			$this->SEXE->LinkCustomAttributes = "";
			$this->SEXE->HrefValue = "";
			$this->SEXE->TooltipValue = "";

			// ETAT_C
			$this->ETAT_C->LinkCustomAttributes = "";
			$this->ETAT_C->HrefValue = "";
			$this->ETAT_C->TooltipValue = "";

			// DEPEND
			$this->DEPEND->LinkCustomAttributes = "";
			$this->DEPEND->HrefValue = "";
			$this->DEPEND->TooltipValue = "";

			// DTE_NAIS
			$this->DTE_NAIS->LinkCustomAttributes = "";
			$this->DTE_NAIS->HrefValue = "";
			$this->DTE_NAIS->TooltipValue = "";

			// LIEU_NAIS
			$this->LIEU_NAIS->LinkCustomAttributes = "";
			$this->LIEU_NAIS->HrefValue = "";
			$this->LIEU_NAIS->TooltipValue = "";

			// NATION
			$this->NATION->LinkCustomAttributes = "";
			$this->NATION->HrefValue = "";
			$this->NATION->TooltipValue = "";

			// ADRESSE
			$this->ADRESSE->LinkCustomAttributes = "";
			$this->ADRESSE->HrefValue = "";
			$this->ADRESSE->TooltipValue = "";

			// VILLE
			$this->VILLE->LinkCustomAttributes = "";
			$this->VILLE->HrefValue = "";
			$this->VILLE->TooltipValue = "";

			// PAYS
			$this->PAYS->LinkCustomAttributes = "";
			$this->PAYS->HrefValue = "";
			$this->PAYS->TooltipValue = "";

			// BOX
			$this->BOX->LinkCustomAttributes = "";
			$this->BOX->HrefValue = "";
			$this->BOX->TooltipValue = "";

			// PHONE
			$this->PHONE->LinkCustomAttributes = "";
			$this->PHONE->HrefValue = "";
			$this->PHONE->TooltipValue = "";

			// REFERENCE
			$this->REFERENCE->LinkCustomAttributes = "";
			$this->REFERENCE->HrefValue = "";
			$this->REFERENCE->TooltipValue = "";

			// QUALIF
			$this->QUALIF->LinkCustomAttributes = "";
			$this->QUALIF->HrefValue = "";
			$this->QUALIF->TooltipValue = "";

			// URGENCE
			$this->URGENCE->LinkCustomAttributes = "";
			$this->URGENCE->HrefValue = "";
			$this->URGENCE->TooltipValue = "";

			// PHONE_URG
			$this->PHONE_URG->LinkCustomAttributes = "";
			$this->PHONE_URG->HrefValue = "";
			$this->PHONE_URG->TooltipValue = "";

			// DATE_EMP
			$this->DATE_EMP->LinkCustomAttributes = "";
			$this->DATE_EMP->HrefValue = "";
			$this->DATE_EMP->TooltipValue = "";

			// SERVICE
			$this->SERVICE->LinkCustomAttributes = "";
			$this->SERVICE->HrefValue = "";
			$this->SERVICE->TooltipValue = "";

			// DEPT
			$this->DEPT->LinkCustomAttributes = "";
			$this->DEPT->HrefValue = "";
			$this->DEPT->TooltipValue = "";

			// SECTION
			$this->SECTION->LinkCustomAttributes = "";
			$this->SECTION->HrefValue = "";
			$this->SECTION->TooltipValue = "";

			// CATEGORIE
			$this->CATEGORIE->LinkCustomAttributes = "";
			$this->CATEGORIE->HrefValue = "";
			$this->CATEGORIE->TooltipValue = "";

			// FONCTION
			$this->FONCTION->LinkCustomAttributes = "";
			$this->FONCTION->HrefValue = "";
			$this->FONCTION->TooltipValue = "";

			// STATUT
			$this->STATUT->LinkCustomAttributes = "";
			$this->STATUT->HrefValue = "";
			$this->STATUT->TooltipValue = "";

			// STA_DEBUT
			$this->STA_DEBUT->LinkCustomAttributes = "";
			$this->STA_DEBUT->HrefValue = "";
			$this->STA_DEBUT->TooltipValue = "";

			// STA_FIN
			$this->STA_FIN->LinkCustomAttributes = "";
			$this->STA_FIN->HrefValue = "";
			$this->STA_FIN->TooltipValue = "";

			// STA_MOTIF
			$this->STA_MOTIF->LinkCustomAttributes = "";
			$this->STA_MOTIF->HrefValue = "";
			$this->STA_MOTIF->TooltipValue = "";

			// NO_NIF
			$this->NO_NIF->LinkCustomAttributes = "";
			$this->NO_NIF->HrefValue = "";
			$this->NO_NIF->TooltipValue = "";

			// NO_ONA
			$this->NO_ONA->LinkCustomAttributes = "";
			$this->NO_ONA->HrefValue = "";
			$this->NO_ONA->TooltipValue = "";

			// LIV_TRAV
			$this->LIV_TRAV->LinkCustomAttributes = "";
			$this->LIV_TRAV->HrefValue = "";
			$this->LIV_TRAV->TooltipValue = "";

			// MT_SALAIRE
			$this->MT_SALAIRE->LinkCustomAttributes = "";
			$this->MT_SALAIRE->HrefValue = "";
			$this->MT_SALAIRE->TooltipValue = "";

			// MT_FRAIS
			$this->MT_FRAIS->LinkCustomAttributes = "";
			$this->MT_FRAIS->HrefValue = "";
			$this->MT_FRAIS->TooltipValue = "";

			// MT_AUTRES
			$this->MT_AUTRES->LinkCustomAttributes = "";
			$this->MT_AUTRES->HrefValue = "";
			$this->MT_AUTRES->TooltipValue = "";

			// MODE
			$this->MODE->LinkCustomAttributes = "";
			$this->MODE->HrefValue = "";
			$this->MODE->TooltipValue = "";

			// TYPE
			$this->TYPE->LinkCustomAttributes = "";
			$this->TYPE->HrefValue = "";
			$this->TYPE->TooltipValue = "";

			// MT_IMPOT
			$this->MT_IMPOT->LinkCustomAttributes = "";
			$this->MT_IMPOT->HrefValue = "";
			$this->MT_IMPOT->TooltipValue = "";

			// PER_IMPOT
			$this->PER_IMPOT->LinkCustomAttributes = "";
			$this->PER_IMPOT->HrefValue = "";
			$this->PER_IMPOT->TooltipValue = "";

			// PRET_ONA
			$this->PRET_ONA->LinkCustomAttributes = "";
			$this->PRET_ONA->HrefValue = "";
			$this->PRET_ONA->TooltipValue = "";

			// PER_ONA
			$this->PER_ONA->LinkCustomAttributes = "";
			$this->PER_ONA->HrefValue = "";
			$this->PER_ONA->TooltipValue = "";

			// RET_ASSUR
			$this->RET_ASSUR->LinkCustomAttributes = "";
			$this->RET_ASSUR->HrefValue = "";
			$this->RET_ASSUR->TooltipValue = "";

			// PER_ASSUR
			$this->PER_ASSUR->LinkCustomAttributes = "";
			$this->PER_ASSUR->HrefValue = "";
			$this->PER_ASSUR->TooltipValue = "";

			// PRET_SALAIRE
			$this->PRET_SALAIRE->LinkCustomAttributes = "";
			$this->PRET_SALAIRE->HrefValue = "";
			$this->PRET_SALAIRE->TooltipValue = "";

			// PER_SALAIRE
			$this->PER_SALAIRE->LinkCustomAttributes = "";
			$this->PER_SALAIRE->HrefValue = "";
			$this->PER_SALAIRE->TooltipValue = "";

			// RET_PENSION
			$this->RET_PENSION->LinkCustomAttributes = "";
			$this->RET_PENSION->HrefValue = "";
			$this->RET_PENSION->TooltipValue = "";

			// PER_RETPENSION
			$this->PER_RETPENSION->LinkCustomAttributes = "";
			$this->PER_RETPENSION->HrefValue = "";
			$this->PER_RETPENSION->TooltipValue = "";

			// PRET_BANQUE
			$this->PRET_BANQUE->LinkCustomAttributes = "";
			$this->PRET_BANQUE->HrefValue = "";
			$this->PRET_BANQUE->TooltipValue = "";

			// PER_BANQUE
			$this->PER_BANQUE->LinkCustomAttributes = "";
			$this->PER_BANQUE->HrefValue = "";
			$this->PER_BANQUE->TooltipValue = "";

			// RET_AVANC
			$this->RET_AVANC->LinkCustomAttributes = "";
			$this->RET_AVANC->HrefValue = "";
			$this->RET_AVANC->TooltipValue = "";

			// PER_AVANCE
			$this->PER_AVANCE->LinkCustomAttributes = "";
			$this->PER_AVANCE->HrefValue = "";
			$this->PER_AVANCE->TooltipValue = "";

			// PRET_PENSION
			$this->PRET_PENSION->LinkCustomAttributes = "";
			$this->PRET_PENSION->HrefValue = "";
			$this->PRET_PENSION->TooltipValue = "";

			// PER_PENSION
			$this->PER_PENSION->LinkCustomAttributes = "";
			$this->PER_PENSION->HrefValue = "";
			$this->PER_PENSION->TooltipValue = "";

			// RET_CAFET
			$this->RET_CAFET->LinkCustomAttributes = "";
			$this->RET_CAFET->HrefValue = "";
			$this->RET_CAFET->TooltipValue = "";

			// PER_CAFET
			$this->PER_CAFET->LinkCustomAttributes = "";
			$this->PER_CAFET->HrefValue = "";
			$this->PER_CAFET->TooltipValue = "";

			// RET_CITE
			$this->RET_CITE->LinkCustomAttributes = "";
			$this->RET_CITE->HrefValue = "";
			$this->RET_CITE->TooltipValue = "";

			// PER_CITE
			$this->PER_CITE->LinkCustomAttributes = "";
			$this->PER_CITE->HrefValue = "";
			$this->PER_CITE->TooltipValue = "";

			// RET_AUTRE
			$this->RET_AUTRE->LinkCustomAttributes = "";
			$this->RET_AUTRE->HrefValue = "";
			$this->RET_AUTRE->TooltipValue = "";

			// PER_AUTRE
			$this->PER_AUTRE->LinkCustomAttributes = "";
			$this->PER_AUTRE->HrefValue = "";
			$this->PER_AUTRE->TooltipValue = "";

			// ACQ_NB_CON
			$this->ACQ_NB_CON->LinkCustomAttributes = "";
			$this->ACQ_NB_CON->HrefValue = "";
			$this->ACQ_NB_CON->TooltipValue = "";

			// ACC_MT_BRUT
			$this->ACC_MT_BRUT->LinkCustomAttributes = "";
			$this->ACC_MT_BRUT->HrefValue = "";
			$this->ACC_MT_BRUT->TooltipValue = "";

			// ACC_NB_CON
			$this->ACC_NB_CON->LinkCustomAttributes = "";
			$this->ACC_NB_CON->HrefValue = "";
			$this->ACC_NB_CON->TooltipValue = "";

			// ACC_NB_PCON
			$this->ACC_NB_PCON->LinkCustomAttributes = "";
			$this->ACC_NB_PCON->HrefValue = "";
			$this->ACC_NB_PCON->TooltipValue = "";

			// ACC_MT_OVT
			$this->ACC_MT_OVT->LinkCustomAttributes = "";
			$this->ACC_MT_OVT->HrefValue = "";
			$this->ACC_MT_OVT->TooltipValue = "";

			// ACQ_NB_MAL
			$this->ACQ_NB_MAL->LinkCustomAttributes = "";
			$this->ACQ_NB_MAL->HrefValue = "";
			$this->ACQ_NB_MAL->TooltipValue = "";

			// ACC_NB_MAL
			$this->ACC_NB_MAL->LinkCustomAttributes = "";
			$this->ACC_NB_MAL->HrefValue = "";
			$this->ACC_NB_MAL->TooltipValue = "";

			// ACC_MT_CON
			$this->ACC_MT_CON->LinkCustomAttributes = "";
			$this->ACC_MT_CON->HrefValue = "";
			$this->ACC_MT_CON->TooltipValue = "";

			// ACC_NB_MAT
			$this->ACC_NB_MAT->LinkCustomAttributes = "";
			$this->ACC_NB_MAT->HrefValue = "";
			$this->ACC_NB_MAT->TooltipValue = "";

			// ACC_MT_BONI
			$this->ACC_MT_BONI->LinkCustomAttributes = "";
			$this->ACC_MT_BONI->HrefValue = "";
			$this->ACC_MT_BONI->TooltipValue = "";

			// ACC_NB_PER
			$this->ACC_NB_PER->LinkCustomAttributes = "";
			$this->ACC_NB_PER->HrefValue = "";
			$this->ACC_NB_PER->TooltipValue = "";

			// ACC_MT_AUT
			$this->ACC_MT_AUT->LinkCustomAttributes = "";
			$this->ACC_MT_AUT->HrefValue = "";
			$this->ACC_MT_AUT->TooltipValue = "";

			// ACC_NB_COM
			$this->ACC_NB_COM->LinkCustomAttributes = "";
			$this->ACC_NB_COM->HrefValue = "";
			$this->ACC_NB_COM->TooltipValue = "";

			// ACC_BAL_SAL
			$this->ACC_BAL_SAL->LinkCustomAttributes = "";
			$this->ACC_BAL_SAL->HrefValue = "";
			$this->ACC_BAL_SAL->TooltipValue = "";

			// ACC_BAL_BAN
			$this->ACC_BAL_BAN->LinkCustomAttributes = "";
			$this->ACC_BAL_BAN->HrefValue = "";
			$this->ACC_BAL_BAN->TooltipValue = "";

			// ACC_NB_SUS
			$this->ACC_NB_SUS->LinkCustomAttributes = "";
			$this->ACC_NB_SUS->HrefValue = "";
			$this->ACC_NB_SUS->TooltipValue = "";

			// ACC_BAL_ONA
			$this->ACC_BAL_ONA->LinkCustomAttributes = "";
			$this->ACC_BAL_ONA->HrefValue = "";
			$this->ACC_BAL_ONA->TooltipValue = "";

			// ACC_BAL_PENSION
			$this->ACC_BAL_PENSION->LinkCustomAttributes = "";
			$this->ACC_BAL_PENSION->HrefValue = "";
			$this->ACC_BAL_PENSION->TooltipValue = "";

			// ACC_NB_ABS
			$this->ACC_NB_ABS->LinkCustomAttributes = "";
			$this->ACC_NB_ABS->HrefValue = "";
			$this->ACC_NB_ABS->TooltipValue = "";

			// ACC_MT_QZ
			$this->ACC_MT_QZ->LinkCustomAttributes = "";
			$this->ACC_MT_QZ->HrefValue = "";
			$this->ACC_MT_QZ->TooltipValue = "";

			// ACC_NB_TRA
			$this->ACC_NB_TRA->LinkCustomAttributes = "";
			$this->ACC_NB_TRA->HrefValue = "";
			$this->ACC_NB_TRA->TooltipValue = "";

			// ACC_MT_AJST
			$this->ACC_MT_AJST->LinkCustomAttributes = "";
			$this->ACC_MT_AJST->HrefValue = "";
			$this->ACC_MT_AJST->TooltipValue = "";

			// ACC_NB_TRA_ACT
			$this->ACC_NB_TRA_ACT->LinkCustomAttributes = "";
			$this->ACC_NB_TRA_ACT->HrefValue = "";
			$this->ACC_NB_TRA_ACT->TooltipValue = "";

			// ACC1_MT_BRUT
			$this->ACC1_MT_BRUT->LinkCustomAttributes = "";
			$this->ACC1_MT_BRUT->HrefValue = "";
			$this->ACC1_MT_BRUT->TooltipValue = "";

			// ACC_RENDEMENT
			$this->ACC_RENDEMENT->LinkCustomAttributes = "";
			$this->ACC_RENDEMENT->HrefValue = "";
			$this->ACC_RENDEMENT->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['RN'];
				if (Config("DELETE_UPLOADED_FILES")) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = "";
				if ($deleteRows === FALSE)
					break;
				if ($key != "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tabemp4list.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
} // End class
?>