<?php
namespace PHPMaker2020\intextdesign_proj_v0;

/**
 * Page class
 */
class policydp_add extends policydp
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{D5394950-A905-4BDF-B7DA-D47F92A453D8}";

	// Table name
	public $TableName = 'policydp';

	// Page object name
	public $PageObjName = "policydp_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (policydp)
		if (!isset($GLOBALS["policydp"]) || get_class($GLOBALS["policydp"]) == PROJECT_NAMESPACE . "policydp") {
			$GLOBALS["policydp"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["policydp"];
		}

		// Table object (detailpayroll)
		if (!isset($GLOBALS['detailpayroll']))
			$GLOBALS['detailpayroll'] = new detailpayroll();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'policydp');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $policydp;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($policydp);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "policydpview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idpdp'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idpdp->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("policydplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->idpdp->Visible = FALSE;
		$this->titlepo->setVisibility();
		$this->amountpo->setVisibility();
		$this->per->setVisibility();
		$this->typepo->setVisibility();
		$this->peramountpo->setVisibility();
		$this->iddp->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->iddp);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("idpdp") !== NULL) {
				$this->idpdp->setQueryStringValue(Get("idpdp"));
				$this->setKey("idpdp", $this->idpdp->CurrentValue); // Set up key
			} else {
				$this->setKey("idpdp", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("policydplist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "policydplist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "policydpview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->idpdp->CurrentValue = NULL;
		$this->idpdp->OldValue = $this->idpdp->CurrentValue;
		$this->titlepo->CurrentValue = NULL;
		$this->titlepo->OldValue = $this->titlepo->CurrentValue;
		$this->amountpo->CurrentValue = NULL;
		$this->amountpo->OldValue = $this->amountpo->CurrentValue;
		$this->per->CurrentValue = NULL;
		$this->per->OldValue = $this->per->CurrentValue;
		$this->typepo->CurrentValue = NULL;
		$this->typepo->OldValue = $this->typepo->CurrentValue;
		$this->peramountpo->CurrentValue = NULL;
		$this->peramountpo->OldValue = $this->peramountpo->CurrentValue;
		$this->iddp->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'titlepo' first before field var 'x_titlepo'
		$val = $CurrentForm->hasValue("titlepo") ? $CurrentForm->getValue("titlepo") : $CurrentForm->getValue("x_titlepo");
		if (!$this->titlepo->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->titlepo->Visible = FALSE; // Disable update for API request
			else
				$this->titlepo->setFormValue($val);
		}

		// Check field name 'amountpo' first before field var 'x_amountpo'
		$val = $CurrentForm->hasValue("amountpo") ? $CurrentForm->getValue("amountpo") : $CurrentForm->getValue("x_amountpo");
		if (!$this->amountpo->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->amountpo->Visible = FALSE; // Disable update for API request
			else
				$this->amountpo->setFormValue($val);
		}

		// Check field name 'per' first before field var 'x_per'
		$val = $CurrentForm->hasValue("per") ? $CurrentForm->getValue("per") : $CurrentForm->getValue("x_per");
		if (!$this->per->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->per->Visible = FALSE; // Disable update for API request
			else
				$this->per->setFormValue($val);
		}

		// Check field name 'typepo' first before field var 'x_typepo'
		$val = $CurrentForm->hasValue("typepo") ? $CurrentForm->getValue("typepo") : $CurrentForm->getValue("x_typepo");
		if (!$this->typepo->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->typepo->Visible = FALSE; // Disable update for API request
			else
				$this->typepo->setFormValue($val);
		}

		// Check field name 'peramountpo' first before field var 'x_peramountpo'
		$val = $CurrentForm->hasValue("peramountpo") ? $CurrentForm->getValue("peramountpo") : $CurrentForm->getValue("x_peramountpo");
		if (!$this->peramountpo->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->peramountpo->Visible = FALSE; // Disable update for API request
			else
				$this->peramountpo->setFormValue($val);
		}

		// Check field name 'iddp' first before field var 'x_iddp'
		$val = $CurrentForm->hasValue("iddp") ? $CurrentForm->getValue("iddp") : $CurrentForm->getValue("x_iddp");
		if (!$this->iddp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->iddp->Visible = FALSE; // Disable update for API request
			else
				$this->iddp->setFormValue($val);
		}

		// Check field name 'idpdp' first before field var 'x_idpdp'
		$val = $CurrentForm->hasValue("idpdp") ? $CurrentForm->getValue("idpdp") : $CurrentForm->getValue("x_idpdp");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->titlepo->CurrentValue = $this->titlepo->FormValue;
		$this->amountpo->CurrentValue = $this->amountpo->FormValue;
		$this->per->CurrentValue = $this->per->FormValue;
		$this->typepo->CurrentValue = $this->typepo->FormValue;
		$this->peramountpo->CurrentValue = $this->peramountpo->FormValue;
		$this->iddp->CurrentValue = $this->iddp->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->idpdp->setDbValue($row['idpdp']);
		$this->titlepo->setDbValue($row['titlepo']);
		$this->amountpo->setDbValue($row['amountpo']);
		$this->per->setDbValue($row['per']);
		$this->typepo->setDbValue($row['typepo']);
		$this->peramountpo->setDbValue($row['peramountpo']);
		$this->iddp->setDbValue($row['iddp']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['idpdp'] = $this->idpdp->CurrentValue;
		$row['titlepo'] = $this->titlepo->CurrentValue;
		$row['amountpo'] = $this->amountpo->CurrentValue;
		$row['per'] = $this->per->CurrentValue;
		$row['typepo'] = $this->typepo->CurrentValue;
		$row['peramountpo'] = $this->peramountpo->CurrentValue;
		$row['iddp'] = $this->iddp->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("idpdp")) != "")
			$this->idpdp->OldValue = $this->getKey("idpdp"); // idpdp
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->amountpo->FormValue == $this->amountpo->CurrentValue && is_numeric(ConvertToFloatString($this->amountpo->CurrentValue)))
			$this->amountpo->CurrentValue = ConvertToFloatString($this->amountpo->CurrentValue);

		// Convert decimal values if posted back
		if ($this->peramountpo->FormValue == $this->peramountpo->CurrentValue && is_numeric(ConvertToFloatString($this->peramountpo->CurrentValue)))
			$this->peramountpo->CurrentValue = ConvertToFloatString($this->peramountpo->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// idpdp
		// titlepo
		// amountpo
		// per
		// typepo
		// peramountpo
		// iddp

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// idpdp
			$this->idpdp->ViewValue = $this->idpdp->CurrentValue;
			$this->idpdp->ViewCustomAttributes = "";

			// titlepo
			$this->titlepo->ViewValue = $this->titlepo->CurrentValue;
			$this->titlepo->ViewCustomAttributes = "";

			// amountpo
			$this->amountpo->ViewValue = $this->amountpo->CurrentValue;
			$this->amountpo->ViewValue = FormatNumber($this->amountpo->ViewValue, 2, -2, -2, -2);
			$this->amountpo->ViewCustomAttributes = "";

			// per
			if (strval($this->per->CurrentValue) != "") {
				$this->per->ViewValue = $this->per->optionCaption($this->per->CurrentValue);
			} else {
				$this->per->ViewValue = NULL;
			}
			$this->per->ViewCustomAttributes = "";

			// typepo
			if (strval($this->typepo->CurrentValue) != "") {
				$this->typepo->ViewValue = $this->typepo->optionCaption($this->typepo->CurrentValue);
			} else {
				$this->typepo->ViewValue = NULL;
			}
			$this->typepo->ViewCustomAttributes = "";

			// peramountpo
			$this->peramountpo->ViewValue = $this->peramountpo->CurrentValue;
			$this->peramountpo->ViewValue = FormatNumber($this->peramountpo->ViewValue, 2, -2, -2, -2);
			$this->peramountpo->ViewCustomAttributes = "";

			// iddp
			$curVal = strval($this->iddp->CurrentValue);
			if ($curVal != "") {
				$this->iddp->ViewValue = $this->iddp->lookupCacheOption($curVal);
				if ($this->iddp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`iddp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->iddp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$this->iddp->ViewValue = $this->iddp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->iddp->ViewValue = $this->iddp->CurrentValue;
					}
				}
			} else {
				$this->iddp->ViewValue = NULL;
			}
			$this->iddp->ViewCustomAttributes = "";

			// titlepo
			$this->titlepo->LinkCustomAttributes = "";
			$this->titlepo->HrefValue = "";
			$this->titlepo->TooltipValue = "";

			// amountpo
			$this->amountpo->LinkCustomAttributes = "";
			$this->amountpo->HrefValue = "";
			$this->amountpo->TooltipValue = "";

			// per
			$this->per->LinkCustomAttributes = "";
			$this->per->HrefValue = "";
			$this->per->TooltipValue = "";

			// typepo
			$this->typepo->LinkCustomAttributes = "";
			$this->typepo->HrefValue = "";
			$this->typepo->TooltipValue = "";

			// peramountpo
			$this->peramountpo->LinkCustomAttributes = "";
			$this->peramountpo->HrefValue = "";
			$this->peramountpo->TooltipValue = "";

			// iddp
			$this->iddp->LinkCustomAttributes = "";
			$this->iddp->HrefValue = "";
			$this->iddp->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// titlepo
			$this->titlepo->EditAttrs["class"] = "form-control";
			$this->titlepo->EditCustomAttributes = "";
			if (!$this->titlepo->Raw)
				$this->titlepo->CurrentValue = HtmlDecode($this->titlepo->CurrentValue);
			$this->titlepo->EditValue = HtmlEncode($this->titlepo->CurrentValue);
			$this->titlepo->PlaceHolder = RemoveHtml($this->titlepo->caption());

			// amountpo
			$this->amountpo->EditAttrs["class"] = "form-control";
			$this->amountpo->EditCustomAttributes = "";
			$this->amountpo->EditValue = HtmlEncode($this->amountpo->CurrentValue);
			$this->amountpo->PlaceHolder = RemoveHtml($this->amountpo->caption());
			if (strval($this->amountpo->EditValue) != "" && is_numeric($this->amountpo->EditValue))
				$this->amountpo->EditValue = FormatNumber($this->amountpo->EditValue, -2, -2, -2, -2);
			

			// per
			$this->per->EditCustomAttributes = "";
			$this->per->EditValue = $this->per->options(FALSE);

			// typepo
			$this->typepo->EditCustomAttributes = "";
			$this->typepo->EditValue = $this->typepo->options(FALSE);

			// peramountpo
			$this->peramountpo->EditAttrs["class"] = "form-control";
			$this->peramountpo->EditCustomAttributes = "";
			$this->peramountpo->EditValue = HtmlEncode($this->peramountpo->CurrentValue);
			$this->peramountpo->PlaceHolder = RemoveHtml($this->peramountpo->caption());
			if (strval($this->peramountpo->EditValue) != "" && is_numeric($this->peramountpo->EditValue))
				$this->peramountpo->EditValue = FormatNumber($this->peramountpo->EditValue, -2, -2, -2, -2);
			

			// iddp
			$this->iddp->EditCustomAttributes = "";
			if ($this->iddp->getSessionValue() != "") {
				$this->iddp->CurrentValue = $this->iddp->getSessionValue();
				$curVal = strval($this->iddp->CurrentValue);
				if ($curVal != "") {
					$this->iddp->ViewValue = $this->iddp->lookupCacheOption($curVal);
					if ($this->iddp->ViewValue === NULL) { // Lookup from database
						$filterWrk = "`iddp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
						$sqlWrk = $this->iddp->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$this->iddp->ViewValue = $this->iddp->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->iddp->ViewValue = $this->iddp->CurrentValue;
						}
					}
				} else {
					$this->iddp->ViewValue = NULL;
				}
				$this->iddp->ViewCustomAttributes = "";
			} else {
				$curVal = trim(strval($this->iddp->CurrentValue));
				if ($curVal != "")
					$this->iddp->ViewValue = $this->iddp->lookupCacheOption($curVal);
				else
					$this->iddp->ViewValue = $this->iddp->Lookup !== NULL && is_array($this->iddp->Lookup->Options) ? $curVal : NULL;
				if ($this->iddp->ViewValue !== NULL) { // Load from cache
					$this->iddp->EditValue = array_values($this->iddp->Lookup->Options);
					if ($this->iddp->ViewValue == "")
						$this->iddp->ViewValue = $Language->phrase("PleaseSelect");
				} else { // Lookup from database
					if ($curVal == "") {
						$filterWrk = "0=1";
					} else {
						$filterWrk = "`iddp`" . SearchString("=", $this->iddp->CurrentValue, DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->iddp->Lookup->getSql(TRUE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode(FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2));
						$arwrk[3] = HtmlEncode(FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2));
						$this->iddp->ViewValue = $this->iddp->displayValue($arwrk);
					} else {
						$this->iddp->ViewValue = $Language->phrase("PleaseSelect");
					}
					$arwrk = $rswrk ? $rswrk->getRows() : [];
					if ($rswrk)
						$rswrk->close();
					$rowcnt = count($arwrk);
					for ($i = 0; $i < $rowcnt; $i++) {
						$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
						$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 0, -2, -2, -2);
						$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					}
					$this->iddp->EditValue = $arwrk;
				}
			}

			// Add refer script
			// titlepo

			$this->titlepo->LinkCustomAttributes = "";
			$this->titlepo->HrefValue = "";

			// amountpo
			$this->amountpo->LinkCustomAttributes = "";
			$this->amountpo->HrefValue = "";

			// per
			$this->per->LinkCustomAttributes = "";
			$this->per->HrefValue = "";

			// typepo
			$this->typepo->LinkCustomAttributes = "";
			$this->typepo->HrefValue = "";

			// peramountpo
			$this->peramountpo->LinkCustomAttributes = "";
			$this->peramountpo->HrefValue = "";

			// iddp
			$this->iddp->LinkCustomAttributes = "";
			$this->iddp->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->titlepo->Required) {
			if (!$this->titlepo->IsDetailKey && $this->titlepo->FormValue != NULL && $this->titlepo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->titlepo->caption(), $this->titlepo->RequiredErrorMessage));
			}
		}
		if ($this->amountpo->Required) {
			if (!$this->amountpo->IsDetailKey && $this->amountpo->FormValue != NULL && $this->amountpo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amountpo->caption(), $this->amountpo->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->amountpo->FormValue)) {
			AddMessage($FormError, $this->amountpo->errorMessage());
		}
		if ($this->per->Required) {
			if ($this->per->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->per->caption(), $this->per->RequiredErrorMessage));
			}
		}
		if ($this->typepo->Required) {
			if ($this->typepo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->typepo->caption(), $this->typepo->RequiredErrorMessage));
			}
		}
		if ($this->peramountpo->Required) {
			if (!$this->peramountpo->IsDetailKey && $this->peramountpo->FormValue != NULL && $this->peramountpo->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->peramountpo->caption(), $this->peramountpo->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->peramountpo->FormValue)) {
			AddMessage($FormError, $this->peramountpo->errorMessage());
		}
		if ($this->iddp->Required) {
			if (!$this->iddp->IsDetailKey && $this->iddp->FormValue != NULL && $this->iddp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->iddp->caption(), $this->iddp->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Check referential integrity for master table 'policydp'
		$validMasterRecord = TRUE;
		$masterFilter = $this->sqlMasterFilter_detailpayroll();
		if (strval($this->iddp->CurrentValue) != "") {
			$masterFilter = str_replace("@iddp@", AdjustSql($this->iddp->CurrentValue, "DB"), $masterFilter);
		} else {
			$validMasterRecord = FALSE;
		}
		if ($validMasterRecord) {
			if (!isset($GLOBALS["detailpayroll"]))
				$GLOBALS["detailpayroll"] = new detailpayroll();
			$rsmaster = $GLOBALS["detailpayroll"]->loadRs($masterFilter);
			$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
			$rsmaster->close();
		}
		if (!$validMasterRecord) {
			$relatedRecordMsg = str_replace("%t", "detailpayroll", $Language->phrase("RelatedRecordRequired"));
			$this->setFailureMessage($relatedRecordMsg);
			return FALSE;
		}
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// titlepo
		$this->titlepo->setDbValueDef($rsnew, $this->titlepo->CurrentValue, "", FALSE);

		// amountpo
		$this->amountpo->setDbValueDef($rsnew, $this->amountpo->CurrentValue, NULL, FALSE);

		// per
		$this->per->setDbValueDef($rsnew, $this->per->CurrentValue, NULL, FALSE);

		// typepo
		$this->typepo->setDbValueDef($rsnew, $this->typepo->CurrentValue, NULL, FALSE);

		// peramountpo
		$this->peramountpo->setDbValueDef($rsnew, $this->peramountpo->CurrentValue, NULL, FALSE);

		// iddp
		$this->iddp->setDbValueDef($rsnew, $this->iddp->CurrentValue, 0, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "detailpayroll") {
				$validMaster = TRUE;
				if (($parm = Get("fk_iddp", Get("iddp"))) !== NULL) {
					$GLOBALS["detailpayroll"]->iddp->setQueryStringValue($parm);
					$this->iddp->setQueryStringValue($GLOBALS["detailpayroll"]->iddp->QueryStringValue);
					$this->iddp->setSessionValue($this->iddp->QueryStringValue);
					if (!is_numeric($GLOBALS["detailpayroll"]->iddp->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "detailpayroll") {
				$validMaster = TRUE;
				if (($parm = Post("fk_iddp", Post("iddp"))) !== NULL) {
					$GLOBALS["detailpayroll"]->iddp->setFormValue($parm);
					$this->iddp->setFormValue($GLOBALS["detailpayroll"]->iddp->FormValue);
					$this->iddp->setSessionValue($this->iddp->FormValue);
					if (!is_numeric($GLOBALS["detailpayroll"]->iddp->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "detailpayroll") {
				if ($this->iddp->CurrentValue == "")
					$this->iddp->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("policydplist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_per":
					break;
				case "x_typepo":
					break;
				case "x_iddp":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_iddp":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[2] = FormatNumber($row[2], 0, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>