<?php namespace PHPMaker2020\intextdesign_proj_v0; ?>
<?php

/**
 * Table class for policy
 */
class policy extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $idpo;
	public $titlepo;
	public $amountpo;
	public $per;
	public $typepo;
	public $peramountpo;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'policy';
		$this->TableName = 'policy';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`policy`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// idpo
		$this->idpo = new DbField('policy', 'policy', 'x_idpo', 'idpo', '`idpo`', '`idpo`', 3, 11, -1, FALSE, '`idpo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->idpo->IsAutoIncrement = TRUE; // Autoincrement field
		$this->idpo->IsPrimaryKey = TRUE; // Primary key field
		$this->idpo->Sortable = TRUE; // Allow sort
		$this->idpo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idpo'] = &$this->idpo;

		// titlepo
		$this->titlepo = new DbField('policy', 'policy', 'x_titlepo', 'titlepo', '`titlepo`', '`titlepo`', 200, 150, -1, FALSE, '`titlepo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->titlepo->Nullable = FALSE; // NOT NULL field
		$this->titlepo->Required = TRUE; // Required field
		$this->titlepo->Sortable = TRUE; // Allow sort
		$this->fields['titlepo'] = &$this->titlepo;

		// amountpo
		$this->amountpo = new DbField('policy', 'policy', 'x_amountpo', 'amountpo', '`amountpo`', '`amountpo`', 131, 15, -1, FALSE, '`amountpo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amountpo->Sortable = TRUE; // Allow sort
		$this->amountpo->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amountpo'] = &$this->amountpo;

		// per
		$this->per = new DbField('policy', 'policy', 'x_per', 'per', '`per`', '`per`', 202, 1, -1, FALSE, '`per`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->per->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "en":
				$this->per->Lookup = new Lookup('per', 'policy', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->per->Lookup = new Lookup('per', 'policy', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->per->OptionCount = 3;
		$this->fields['per'] = &$this->per;

		// typepo
		$this->typepo = new DbField('policy', 'policy', 'x_typepo', 'typepo', '`typepo`', '`typepo`', 202, 1, -1, FALSE, '`typepo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->typepo->Required = TRUE; // Required field
		$this->typepo->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "en":
				$this->typepo->Lookup = new Lookup('typepo', 'policy', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->typepo->Lookup = new Lookup('typepo', 'policy', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->typepo->OptionCount = 2;
		$this->fields['typepo'] = &$this->typepo;

		// peramountpo
		$this->peramountpo = new DbField('policy', 'policy', 'x_peramountpo', 'peramountpo', '`peramountpo`', '`peramountpo`', 131, 15, -1, FALSE, '`peramountpo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->peramountpo->Sortable = TRUE; // Allow sort
		$this->peramountpo->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['peramountpo'] = &$this->peramountpo;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`policy`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->idpo->setDbValue($conn->insert_ID());
			$rs['idpo'] = $this->idpo->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('idpo', $rs))
				AddFilter($where, QuotedName('idpo', $this->Dbid) . '=' . QuotedValue($rs['idpo'], $this->idpo->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->idpo->DbValue = $row['idpo'];
		$this->titlepo->DbValue = $row['titlepo'];
		$this->amountpo->DbValue = $row['amountpo'];
		$this->per->DbValue = $row['per'];
		$this->typepo->DbValue = $row['typepo'];
		$this->peramountpo->DbValue = $row['peramountpo'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`idpo` = @idpo@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('idpo', $row) ? $row['idpo'] : NULL;
		else
			$val = $this->idpo->OldValue !== NULL ? $this->idpo->OldValue : $this->idpo->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@idpo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "policylist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "policyview.php")
			return $Language->phrase("View");
		elseif ($pageName == "policyedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "policyadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "policylist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("policyview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("policyview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "policyadd.php?" . $this->getUrlParm($parm);
		else
			$url = "policyadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("policyedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("policyadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("policydelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "idpo:" . JsonEncode($this->idpo->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->idpo->CurrentValue != NULL) {
			$url .= "idpo=" . urlencode($this->idpo->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("idpo") !== NULL)
				$arKeys[] = Param("idpo");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->idpo->CurrentValue = $key;
			else
				$this->idpo->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->idpo->setDbValue($rs->fields('idpo'));
		$this->titlepo->setDbValue($rs->fields('titlepo'));
		$this->amountpo->setDbValue($rs->fields('amountpo'));
		$this->per->setDbValue($rs->fields('per'));
		$this->typepo->setDbValue($rs->fields('typepo'));
		$this->peramountpo->setDbValue($rs->fields('peramountpo'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// idpo
		// titlepo
		// amountpo
		// per
		// typepo
		// peramountpo
		// idpo

		$this->idpo->ViewValue = $this->idpo->CurrentValue;
		$this->idpo->ViewCustomAttributes = "";

		// titlepo
		$this->titlepo->ViewValue = $this->titlepo->CurrentValue;
		$this->titlepo->ViewCustomAttributes = "";

		// amountpo
		$this->amountpo->ViewValue = $this->amountpo->CurrentValue;
		$this->amountpo->ViewValue = FormatNumber($this->amountpo->ViewValue, 2, -2, -2, -2);
		$this->amountpo->ViewCustomAttributes = "";

		// per
		if (strval($this->per->CurrentValue) != "") {
			$this->per->ViewValue = $this->per->optionCaption($this->per->CurrentValue);
		} else {
			$this->per->ViewValue = NULL;
		}
		$this->per->ViewCustomAttributes = "";

		// typepo
		if (strval($this->typepo->CurrentValue) != "") {
			$this->typepo->ViewValue = $this->typepo->optionCaption($this->typepo->CurrentValue);
		} else {
			$this->typepo->ViewValue = NULL;
		}
		$this->typepo->ViewCustomAttributes = "";

		// peramountpo
		$this->peramountpo->ViewValue = $this->peramountpo->CurrentValue;
		$this->peramountpo->ViewValue = FormatNumber($this->peramountpo->ViewValue, 2, -2, -2, -2);
		$this->peramountpo->ViewCustomAttributes = "";

		// idpo
		$this->idpo->LinkCustomAttributes = "";
		$this->idpo->HrefValue = "";
		$this->idpo->TooltipValue = "";

		// titlepo
		$this->titlepo->LinkCustomAttributes = "";
		$this->titlepo->HrefValue = "";
		$this->titlepo->TooltipValue = "";

		// amountpo
		$this->amountpo->LinkCustomAttributes = "";
		$this->amountpo->HrefValue = "";
		$this->amountpo->TooltipValue = "";

		// per
		$this->per->LinkCustomAttributes = "";
		$this->per->HrefValue = "";
		$this->per->TooltipValue = "";

		// typepo
		$this->typepo->LinkCustomAttributes = "";
		$this->typepo->HrefValue = "";
		$this->typepo->TooltipValue = "";

		// peramountpo
		$this->peramountpo->LinkCustomAttributes = "";
		$this->peramountpo->HrefValue = "";
		$this->peramountpo->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// idpo
		$this->idpo->EditAttrs["class"] = "form-control";
		$this->idpo->EditCustomAttributes = "";
		$this->idpo->EditValue = $this->idpo->CurrentValue;
		$this->idpo->ViewCustomAttributes = "";

		// titlepo
		$this->titlepo->EditAttrs["class"] = "form-control";
		$this->titlepo->EditCustomAttributes = "";
		if (!$this->titlepo->Raw)
			$this->titlepo->CurrentValue = HtmlDecode($this->titlepo->CurrentValue);
		$this->titlepo->EditValue = $this->titlepo->CurrentValue;
		$this->titlepo->PlaceHolder = RemoveHtml($this->titlepo->caption());

		// amountpo
		$this->amountpo->EditAttrs["class"] = "form-control";
		$this->amountpo->EditCustomAttributes = "";
		$this->amountpo->EditValue = $this->amountpo->CurrentValue;
		$this->amountpo->PlaceHolder = RemoveHtml($this->amountpo->caption());
		if (strval($this->amountpo->EditValue) != "" && is_numeric($this->amountpo->EditValue))
			$this->amountpo->EditValue = FormatNumber($this->amountpo->EditValue, -2, -2, -2, -2);
		

		// per
		$this->per->EditCustomAttributes = "";
		$this->per->EditValue = $this->per->options(FALSE);

		// typepo
		$this->typepo->EditCustomAttributes = "";
		$this->typepo->EditValue = $this->typepo->options(FALSE);

		// peramountpo
		$this->peramountpo->EditAttrs["class"] = "form-control";
		$this->peramountpo->EditCustomAttributes = "";
		$this->peramountpo->EditValue = $this->peramountpo->CurrentValue;
		$this->peramountpo->PlaceHolder = RemoveHtml($this->peramountpo->caption());
		if (strval($this->peramountpo->EditValue) != "" && is_numeric($this->peramountpo->EditValue))
			$this->peramountpo->EditValue = FormatNumber($this->peramountpo->EditValue, -2, -2, -2, -2);
		

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->idpo);
					$doc->exportCaption($this->titlepo);
					$doc->exportCaption($this->amountpo);
					$doc->exportCaption($this->per);
					$doc->exportCaption($this->typepo);
					$doc->exportCaption($this->peramountpo);
				} else {
					$doc->exportCaption($this->idpo);
					$doc->exportCaption($this->titlepo);
					$doc->exportCaption($this->amountpo);
					$doc->exportCaption($this->per);
					$doc->exportCaption($this->typepo);
					$doc->exportCaption($this->peramountpo);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->idpo);
						$doc->exportField($this->titlepo);
						$doc->exportField($this->amountpo);
						$doc->exportField($this->per);
						$doc->exportField($this->typepo);
						$doc->exportField($this->peramountpo);
					} else {
						$doc->exportField($this->idpo);
						$doc->exportField($this->titlepo);
						$doc->exportField($this->amountpo);
						$doc->exportField($this->per);
						$doc->exportField($this->typepo);
						$doc->exportField($this->peramountpo);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

	if ($rsnew["amountpo"] < $rsnew["peramountpo"]) {

			// To cancel, set return value to False
			 $this->CancelMessage = "The amount policy must be larger than the per amount policy .";
			 return FALSE;
		 }     
		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

	if ($rsnew["amountpo"] < $rsnew["peramountpo"]) {

			// To cancel, set return value to False
			 $this->CancelMessage = "The amount policy must be larger than the per amount policy .";
			 return FALSE;
		 }     
		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>