<?php namespace PHPMaker2020\intextdesign_proj_v0; ?>
<?php

/**
 * Table class for payroll
 */
class payroll extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $idpayroll;
	public $descrip;
	public $startdate;
	public $enddate;
	public $typequinz;
	public $tnetpay;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'payroll';
		$this->TableName = 'payroll';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`payroll`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// idpayroll
		$this->idpayroll = new DbField('payroll', 'payroll', 'x_idpayroll', 'idpayroll', '`idpayroll`', '`idpayroll`', 3, 11, -1, FALSE, '`idpayroll`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->idpayroll->IsAutoIncrement = TRUE; // Autoincrement field
		$this->idpayroll->IsPrimaryKey = TRUE; // Primary key field
		$this->idpayroll->IsForeignKey = TRUE; // Foreign key field
		$this->idpayroll->Sortable = TRUE; // Allow sort
		$this->idpayroll->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idpayroll'] = &$this->idpayroll;

		// descrip
		$this->descrip = new DbField('payroll', 'payroll', 'x_descrip', 'descrip', '`descrip`', '`descrip`', 200, 150, -1, FALSE, '`descrip`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->descrip->Nullable = FALSE; // NOT NULL field
		$this->descrip->Required = TRUE; // Required field
		$this->descrip->Sortable = TRUE; // Allow sort
		$this->fields['descrip'] = &$this->descrip;

		// startdate
		$this->startdate = new DbField('payroll', 'payroll', 'x_startdate', 'startdate', '`startdate`', CastDateFieldForLike("`startdate`", 0, "DB"), 135, 19, 0, FALSE, '`startdate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->startdate->Required = TRUE; // Required field
		$this->startdate->Sortable = TRUE; // Allow sort
		$this->startdate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['startdate'] = &$this->startdate;

		// enddate
		$this->enddate = new DbField('payroll', 'payroll', 'x_enddate', 'enddate', '`enddate`', CastDateFieldForLike("`enddate`", 0, "DB"), 135, 19, 0, FALSE, '`enddate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->enddate->Required = TRUE; // Required field
		$this->enddate->Sortable = TRUE; // Allow sort
		$this->enddate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['enddate'] = &$this->enddate;

		// typequinz
		$this->typequinz = new DbField('payroll', 'payroll', 'x_typequinz', 'typequinz', '`typequinz`', '`typequinz`', 202, 1, -1, FALSE, '`typequinz`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->typequinz->Required = TRUE; // Required field
		$this->typequinz->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "en":
				$this->typequinz->Lookup = new Lookup('typequinz', 'payroll', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->typequinz->Lookup = new Lookup('typequinz', 'payroll', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->typequinz->OptionCount = 2;
		$this->fields['typequinz'] = &$this->typequinz;

		// tnetpay
		$this->tnetpay = new DbField('payroll', 'payroll', 'x_tnetpay', 'tnetpay', '000000.00', '000000.00', 131, 8, -1, FALSE, '000000.00', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tnetpay->IsCustom = TRUE; // Custom field
		$this->tnetpay->Sortable = TRUE; // Allow sort
		$this->tnetpay->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tnetpay'] = &$this->tnetpay;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "detailpayroll") {
			$detailUrl = $GLOBALS["detailpayroll"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_idpayroll=" . urlencode($this->idpayroll->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "payrolllist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`payroll`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT *, 000000.00 AS `tnetpay` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->idpayroll->setDbValue($conn->insert_ID());
			$rs['idpayroll'] = $this->idpayroll->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();

		// Cascade Update detail table 'detailpayroll'
		$cascadeUpdate = FALSE;
		$rscascade = [];
		if ($rsold && (isset($rs['idpayroll']) && $rsold['idpayroll'] != $rs['idpayroll'])) { // Update detail field 'idpayroll'
			$cascadeUpdate = TRUE;
			$rscascade['idpayroll'] = $rs['idpayroll'];
		}
		if ($cascadeUpdate) {
			if (!isset($GLOBALS["detailpayroll"]))
				$GLOBALS["detailpayroll"] = new detailpayroll();
			$rswrk = $GLOBALS["detailpayroll"]->loadRs("`idpayroll` = " . QuotedValue($rsold['idpayroll'], DATATYPE_NUMBER, 'DB'));
			while ($rswrk && !$rswrk->EOF) {
				$rskey = [];
				$fldname = 'iddp';
				$rskey[$fldname] = $rswrk->fields[$fldname];
				$rsdtlold = &$rswrk->fields;
				$rsdtlnew = array_merge($rsdtlold, $rscascade);

				// Call Row_Updating event
				$success = $GLOBALS["detailpayroll"]->Row_Updating($rsdtlold, $rsdtlnew);
				if ($success)
					$success = $GLOBALS["detailpayroll"]->update($rscascade, $rskey, $rswrk->fields);
				if (!$success)
					return FALSE;

				// Call Row_Updated event
				$GLOBALS["detailpayroll"]->Row_Updated($rsdtlold, $rsdtlnew);
				$rswrk->moveNext();
			}
		}
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('idpayroll', $rs))
				AddFilter($where, QuotedName('idpayroll', $this->Dbid) . '=' . QuotedValue($rs['idpayroll'], $this->idpayroll->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();

		// Cascade delete detail table 'detailpayroll'
		if (!isset($GLOBALS["detailpayroll"]))
			$GLOBALS["detailpayroll"] = new detailpayroll();
		$rscascade = $GLOBALS["detailpayroll"]->loadRs("`idpayroll` = " . QuotedValue($rs['idpayroll'], DATATYPE_NUMBER, "DB"));
		$dtlrows = ($rscascade) ? $rscascade->getRows() : [];

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["detailpayroll"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["detailpayroll"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["detailpayroll"]->Row_Deleted($dtlrow);
		}
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->idpayroll->DbValue = $row['idpayroll'];
		$this->descrip->DbValue = $row['descrip'];
		$this->startdate->DbValue = $row['startdate'];
		$this->enddate->DbValue = $row['enddate'];
		$this->typequinz->DbValue = $row['typequinz'];
		$this->tnetpay->DbValue = $row['tnetpay'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`idpayroll` = @idpayroll@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('idpayroll', $row) ? $row['idpayroll'] : NULL;
		else
			$val = $this->idpayroll->OldValue !== NULL ? $this->idpayroll->OldValue : $this->idpayroll->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@idpayroll@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "payrolllist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "payrollview.php")
			return $Language->phrase("View");
		elseif ($pageName == "payrolledit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "payrolladd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "payrolllist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("payrollview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("payrollview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "payrolladd.php?" . $this->getUrlParm($parm);
		else
			$url = "payrolladd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("payrolledit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("payrolledit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("payrolladd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("payrolladd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("payrolldelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "idpayroll:" . JsonEncode($this->idpayroll->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->idpayroll->CurrentValue != NULL) {
			$url .= "idpayroll=" . urlencode($this->idpayroll->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("idpayroll") !== NULL)
				$arKeys[] = Param("idpayroll");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->idpayroll->CurrentValue = $key;
			else
				$this->idpayroll->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->idpayroll->setDbValue($rs->fields('idpayroll'));
		$this->descrip->setDbValue($rs->fields('descrip'));
		$this->startdate->setDbValue($rs->fields('startdate'));
		$this->enddate->setDbValue($rs->fields('enddate'));
		$this->typequinz->setDbValue($rs->fields('typequinz'));
		$this->tnetpay->setDbValue($rs->fields('tnetpay'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// idpayroll
		// descrip
		// startdate
		// enddate
		// typequinz
		// tnetpay
		// idpayroll

		$this->idpayroll->ViewValue = $this->idpayroll->CurrentValue;
		$this->idpayroll->ViewCustomAttributes = "";

		// descrip
		$this->descrip->ViewValue = $this->descrip->CurrentValue;
		$this->descrip->ViewCustomAttributes = "";

		// startdate
		$this->startdate->ViewValue = $this->startdate->CurrentValue;
		$this->startdate->ViewValue = FormatDateTime($this->startdate->ViewValue, 0);
		$this->startdate->ViewCustomAttributes = "";

		// enddate
		$this->enddate->ViewValue = $this->enddate->CurrentValue;
		$this->enddate->ViewValue = FormatDateTime($this->enddate->ViewValue, 0);
		$this->enddate->ViewCustomAttributes = "";

		// typequinz
		if (strval($this->typequinz->CurrentValue) != "") {
			$this->typequinz->ViewValue = $this->typequinz->optionCaption($this->typequinz->CurrentValue);
		} else {
			$this->typequinz->ViewValue = NULL;
		}
		$this->typequinz->ViewCustomAttributes = "";

		// tnetpay
		$this->tnetpay->ViewValue = $this->tnetpay->CurrentValue;
		$this->tnetpay->ViewValue = FormatNumber($this->tnetpay->ViewValue, 2, -2, -2, -2);
		$this->tnetpay->ViewCustomAttributes = "";

		// idpayroll
		$this->idpayroll->LinkCustomAttributes = "";
		$this->idpayroll->HrefValue = "";
		$this->idpayroll->TooltipValue = "";

		// descrip
		$this->descrip->LinkCustomAttributes = "";
		$this->descrip->HrefValue = "";
		$this->descrip->TooltipValue = "";

		// startdate
		$this->startdate->LinkCustomAttributes = "";
		$this->startdate->HrefValue = "";
		$this->startdate->TooltipValue = "";

		// enddate
		$this->enddate->LinkCustomAttributes = "";
		$this->enddate->HrefValue = "";
		$this->enddate->TooltipValue = "";

		// typequinz
		$this->typequinz->LinkCustomAttributes = "";
		$this->typequinz->HrefValue = "";
		$this->typequinz->TooltipValue = "";

		// tnetpay
		$this->tnetpay->LinkCustomAttributes = "";
		$this->tnetpay->HrefValue = "";
		$this->tnetpay->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// idpayroll
		$this->idpayroll->EditAttrs["class"] = "form-control";
		$this->idpayroll->EditCustomAttributes = "";
		$this->idpayroll->EditValue = $this->idpayroll->CurrentValue;
		$this->idpayroll->ViewCustomAttributes = "";

		// descrip
		$this->descrip->EditAttrs["class"] = "form-control";
		$this->descrip->EditCustomAttributes = "";
		if (!$this->descrip->Raw)
			$this->descrip->CurrentValue = HtmlDecode($this->descrip->CurrentValue);
		$this->descrip->EditValue = $this->descrip->CurrentValue;
		$this->descrip->PlaceHolder = RemoveHtml($this->descrip->caption());

		// startdate
		$this->startdate->EditAttrs["class"] = "form-control";
		$this->startdate->EditCustomAttributes = "";
		$this->startdate->EditValue = FormatDateTime($this->startdate->CurrentValue, 8);
		$this->startdate->PlaceHolder = RemoveHtml($this->startdate->caption());

		// enddate
		$this->enddate->EditAttrs["class"] = "form-control";
		$this->enddate->EditCustomAttributes = "";
		$this->enddate->EditValue = FormatDateTime($this->enddate->CurrentValue, 8);
		$this->enddate->PlaceHolder = RemoveHtml($this->enddate->caption());

		// typequinz
		$this->typequinz->EditCustomAttributes = "";
		$this->typequinz->EditValue = $this->typequinz->options(FALSE);

		// tnetpay
		$this->tnetpay->EditAttrs["class"] = "form-control";
		$this->tnetpay->EditCustomAttributes = "";
		$this->tnetpay->EditValue = $this->tnetpay->CurrentValue;
		$this->tnetpay->PlaceHolder = RemoveHtml($this->tnetpay->caption());
		if (strval($this->tnetpay->EditValue) != "" && is_numeric($this->tnetpay->EditValue))
			$this->tnetpay->EditValue = FormatNumber($this->tnetpay->EditValue, -2, -2, -2, -2);
		

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			$this->descrip->Count++; // Increment count
			if (is_numeric($this->tnetpay->CurrentValue))
				$this->tnetpay->Total += $this->tnetpay->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->descrip->CurrentValue = $this->descrip->Count;
			$this->descrip->ViewValue = $this->descrip->CurrentValue;
			$this->descrip->ViewCustomAttributes = "";
			$this->descrip->HrefValue = ""; // Clear href value
			$this->tnetpay->CurrentValue = $this->tnetpay->Total;
			$this->tnetpay->ViewValue = $this->tnetpay->CurrentValue;
			$this->tnetpay->ViewValue = FormatNumber($this->tnetpay->ViewValue, 2, -2, -2, -2);
			$this->tnetpay->ViewCustomAttributes = "";
			$this->tnetpay->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->idpayroll);
					$doc->exportCaption($this->descrip);
					$doc->exportCaption($this->startdate);
					$doc->exportCaption($this->enddate);
					$doc->exportCaption($this->typequinz);
					$doc->exportCaption($this->tnetpay);
				} else {
					$doc->exportCaption($this->idpayroll);
					$doc->exportCaption($this->descrip);
					$doc->exportCaption($this->startdate);
					$doc->exportCaption($this->enddate);
					$doc->exportCaption($this->typequinz);
					$doc->exportCaption($this->tnetpay);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->idpayroll);
						$doc->exportField($this->descrip);
						$doc->exportField($this->startdate);
						$doc->exportField($this->enddate);
						$doc->exportField($this->typequinz);
						$doc->exportField($this->tnetpay);
					} else {
						$doc->exportField($this->idpayroll);
						$doc->exportField($this->descrip);
						$doc->exportField($this->startdate);
						$doc->exportField($this->enddate);
						$doc->exportField($this->typequinz);
						$doc->exportField($this->tnetpay);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->idpayroll, '');
				$doc->exportAggregate($this->descrip, 'COUNT');
				$doc->exportAggregate($this->startdate, '');
				$doc->exportAggregate($this->enddate, '');
				$doc->exportAggregate($this->typequinz, '');
				$doc->exportAggregate($this->tnetpay, 'TOTAL');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	Execute("START TRANSACTION");

	//insertion des dp lies a chaque employe actif sur base de production et de temps pour la periode payroll indique
			$MyQuery1 = "INSERT INTO detailpayroll (idpayroll, idemp, salaryp) ";
			$MyQuery1 .= "SELECT '".$rsnew["idpayroll"]."', employee.idemp, if(employee.idtype=2, (select ifnull(sum(qtyprod*tauxprod),0)  from production where production.idemp=employee.idemp and employee.idtype=2 and dateprod between '".$rsnew["startdate"]."' and '".$rsnew["enddate"]."'),(select ifnull(sum(nbrheur*tauxh),0)  from datatemp where datatemp.idemp=employee.idemp and employee.idtype=1 and datejob between '".$rsnew["startdate"]."' and '".$rsnew["enddate"]."' ))";
			$MyQuery1 .= "FROM employee ";
				$MyQuery1 .= "WHERE employee.idstatus =1 ";

	//permet d inserer les policy lier a chaque employe pour le payroll detail dependant du 15zaine
				$MyQuery2 = "INSERT INTO policydp(iddp, titlepo, amountpo, per,typepo, peramountpo) ";
				$MyQuery2 .= "SELECT dp.iddp, pe.titlepo, if((ifnull(pe.peramountpo,0)>0) and (ifnull(pe.peramountpo,0)<=pe.amountpo),pe.peramountpo,pe.amountpo) as amount, pe.per, pe.typepo, if(ifnull(pe.peramountpo,0)<pe.amountpo,pe.peramountpo,pe.amountpo) as peramount ";
				$MyQuery2 .= "FROM detailpayroll dp, policyemp pe ";
				$MyQuery2 .= "WHERE dp.idemp = pe.idemp ";
				$MyQuery2 .= "AND dp.idpayroll =".$rsnew["idpayroll"];
				$MyQuery2 .= " AND pe.per in (".$rsnew["typequinz"].",3)";

	/*
	//permet de mettre a jour la somme des allowances et deduction du payrolldetaill pour chaque employe
				$MyQuery22 = "update detailpayroll ";
				$MyQuery22 .= "set ";
				$MyQuery22 .= "mtap=(SELECT sum(amountpo) from policydp where policydp.iddp=detailpayroll.iddp and policydp.typepo=1), ";
				$MyQuery22 .= "mtdp=(SELECT sum(amountpo) from policydp where policydp.iddp=detailpayroll.iddp and policydp.typepo=2) ";
				$MyQuery22 .= "where idpayroll=".$rsnew["idpayroll"];
	*/
	//gestion des policy employe qui sont en mode transaction( PER )

				$MyQuery3 = "update policyemp ";
			$MyQuery3 .= "set amountpo=amountpo - if(ifnull(peramountpo,0)<amountpo,peramountpo,amountpo) ";
				$MyQuery3 .= "where (ifnull(peramountpo,0)!=0) and (amountpo>0) ";
				$MyQuery3 .= "AND per in (".$rsnew["typequinz"].",3)";
				$MyQuery4 = "delete from policyemp where amountpo = 0";
	$a=Execute($MyQuery1);
	$b=Execute($MyQuery2);

	//$b2=Execute($MyQuery22);
	$c=Execute($MyQuery3);
	$d=Execute($MyQuery4);
	if ($a and $b and $c and $d ) {
			Execute("COMMIT");
		} else {        
			Execute("ROLLBACK");

			//$this->setSuccessMessage("Record Inserted. The ID of the new record is " . $$rsnew["ID"]); 
			Execute("delete from payroll where idpayroll=".$rsnew["idpayroll"]);		
		}
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	//calcul Total netpay for patyroll

	if($this->idpayroll->CurrentValue!=""){
	$rsqla="SELECT  sum(amountpo) from policydp,detailpayroll 
	where typepo=1 
	and policydp.iddp=detailpayroll.iddp 
	and detailpayroll.idpayroll=".$this->idpayroll->CurrentValue;
	$vala= ExecuteScalar($rsqla);
	$rsqld="SELECT  sum(amountpo) from policydp,detailpayroll 
	where typepo=2 
	and policydp.iddp=detailpayroll.iddp 
	and detailpayroll.idpayroll=".$this->idpayroll->CurrentValue;
	$vald= ExecuteScalar($rsqld);

	//$this->mtdp->CurrentValue=$vald;
	$rsqls="SELECT  sum(salaryp) from detailpayroll 
	where detailpayroll.idpayroll=".$this->idpayroll->CurrentValue;
	$vals= ExecuteScalar($rsqls);
	$this->tnetpay->CurrentValue=$vals+$vala-$vald;
	}

	//FIN calclul
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>