<?php
namespace PHPMaker2020\intextdesign_proj_v0;

/**
 * Page class
 */
class employee_view extends employee
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{D5394950-A905-4BDF-B7DA-D47F92A453D8}";

	// Table name
	public $TableName = 'employee';

	// Page object name
	public $PageObjName = "employee_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (employee)
		if (!isset($GLOBALS["employee"]) || get_class($GLOBALS["employee"]) == PROJECT_NAMESPACE . "employee") {
			$GLOBALS["employee"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["employee"];
		}
		$keyUrl = "";
		if (Get("idemp") !== NULL) {
			$this->RecKey["idemp"] = Get("idemp");
			$keyUrl .= "&amp;idemp=" . urlencode($this->RecKey["idemp"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'employee');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $employee;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($employee);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "employeeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idemp'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idemp->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecords = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $RecKey = [];
	public $IsModal = FALSE;
	public $policyemp_Count;
	public $detailpayroll_Count;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canView()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("employeelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->idemp->setVisibility();
		$this->noemp->setVisibility();
		$this->lastname->setVisibility();
		$this->firstname->setVisibility();
		$this->basicsalary->setVisibility();
		$this->nifcin->setVisibility();
		$this->gender->setVisibility();
		$this->civilstatus->setVisibility();
		$this->depend->setVisibility();
		$this->datenais->setVisibility();
		$this->lieunais->setVisibility();
		$this->adresse->setVisibility();
		$this->phone->setVisibility();
		$this->reference->setVisibility();
		$this->refphone->setVisibility();
		$this->urgence->setVisibility();
		$this->urgphone->setVisibility();
		$this->joindate->setVisibility();
		$this->leavingdate->setVisibility();
		$this->leavingmotif->setVisibility();
		$this->idtype->setVisibility();
		$this->idstatus->setVisibility();
		$this->idfct->setVisibility();
		$this->idsect->setVisibility();
		$this->iddep->setVisibility();
		$this->iddesig->setVisibility();
		$this->qualif->setVisibility();
		$this->listpolicy->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->idtype);
		$this->setupLookupOptions($this->idstatus);
		$this->setupLookupOptions($this->idfct);
		$this->setupLookupOptions($this->idsect);
		$this->setupLookupOptions($this->iddep);
		$this->setupLookupOptions($this->iddesig);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("idemp") !== NULL) {
				$this->idemp->setQueryStringValue(Get("idemp"));
				$this->RecKey["idemp"] = $this->idemp->QueryStringValue;
			} elseif (IsApi() && Key(0) !== NULL) {
				$this->idemp->setQueryStringValue(Key(0));
				$this->RecKey["idemp"] = $this->idemp->QueryStringValue;
			} elseif (Post("idemp") !== NULL) {
				$this->idemp->setFormValue(Post("idemp"));
				$this->RecKey["idemp"] = $this->idemp->FormValue;
			} elseif (IsApi() && Route(2) !== NULL) {
				$this->idemp->setFormValue(Route(2));
				$this->RecKey["idemp"] = $this->idemp->FormValue;
			} else {
				$loadCurrentRecord = TRUE;
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display
					$this->StartRecord = 1; // Initialize start position
					if ($this->Recordset = $this->loadRecordset()) // Load records
						$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
					if ($this->TotalRecords <= 0) { // No record found
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$this->terminate("employeelist.php"); // Return to list page
					} elseif ($loadCurrentRecord) { // Load current record position
						$this->setupStartRecord(); // Set up start record position

						// Point to current record
						if ($this->StartRecord <= $this->TotalRecords) {
							$matchRecord = TRUE;
							$this->Recordset->move($this->StartRecord - 1);
						}
					} else { // Match key values
						while (!$this->Recordset->EOF) {
							if (SameString($this->idemp->CurrentValue, $this->Recordset->fields('idemp'))) {
								$this->setStartRecordNumber($this->StartRecord); // Save record position
								$matchRecord = TRUE;
								break;
							} else {
								$this->StartRecord++;
								$this->Recordset->moveNext();
							}
						}
					}
					if (!$matchRecord) {
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "employeelist.php"; // No matching record, return to list
					} else {
						$this->loadRowValues($this->Recordset); // Load row values
					}
			}
		} else {
			$returnUrl = "employeelist.php"; // Not page request, return to list
		}
		if ($returnUrl != "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Set up detail parameters
		$this->setupDetailParms();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new NumericPager($this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", $this->RecordRange, $this->AutoHidePager);
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl != "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl != "" && $Security->canEdit());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"#\" onclick=\"return ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl != "" && $Security->canAdd());

		// Delete
		$item = &$option->add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew.confirmDelete(this);\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery($this->DeleteUrl, "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl != "" && $Security->canDelete());
		$option = $options["detail"];
		$detailTableLink = "";
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail_policyemp"
		$item = &$option->add("detail_policyemp");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("policyemp", "TblCaption");
		$body .= "&nbsp;" . str_replace("%c", $this->policyemp_Count, $Language->phrase("DetailCount"));
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("policyemplist.php?" . Config("TABLE_SHOW_MASTER") . "=employee&fk_idemp=" . urlencode(strval($this->idemp->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["policyemp_grid"]))
			$GLOBALS["policyemp_grid"] = new policyemp_grid();
		if ($GLOBALS["policyemp_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'employee')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=policyemp")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar != "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "policyemp";
		}
		if ($GLOBALS["policyemp_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'employee')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=policyemp")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar != "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "policyemp";
		}
		if ($GLOBALS["policyemp_grid"]->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'employee')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=policyemp")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			if ($detailCopyTblVar != "")
				$detailCopyTblVar .= ",";
			$detailCopyTblVar .= "policyemp";
		}
		if ($links != "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'policyemp');
		if ($item->Visible) {
			if ($detailTableLink != "")
				$detailTableLink .= ",";
			$detailTableLink .= "policyemp";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// "detail_detailpayroll"
		$item = &$option->add("detail_detailpayroll");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("detailpayroll", "TblCaption");
		$body .= "&nbsp;" . str_replace("%c", $this->detailpayroll_Count, $Language->phrase("DetailCount"));
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("detailpayrolllist.php?" . Config("TABLE_SHOW_MASTER") . "=employee&fk_idemp=" . urlencode(strval($this->idemp->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["detailpayroll_grid"]))
			$GLOBALS["detailpayroll_grid"] = new detailpayroll_grid();
		if ($GLOBALS["detailpayroll_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'employee')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=detailpayroll")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar != "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "detailpayroll";
		}
		if ($GLOBALS["detailpayroll_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'employee')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=detailpayroll")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar != "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "detailpayroll";
		}
		if ($GLOBALS["detailpayroll_grid"]->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'employee')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=detailpayroll")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			if ($detailCopyTblVar != "")
				$detailCopyTblVar .= ",";
			$detailCopyTblVar .= "detailpayroll";
		}
		if ($links != "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'detailpayroll');
		if ($item->Visible) {
			if ($detailTableLink != "")
				$detailTableLink .= ",";
			$detailTableLink .= "detailpayroll";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar != "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar != "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar != "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$item = &$option->add("details");
			$item->Body = $body;
		}

		// Set up detail default
		$option = $options["detail"];
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$ar = explode(",", $detailTableLink);
		$cnt = count($ar);
		$option->UseDropDownButton = ($cnt > 1);
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up action default
		$option = $options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->idemp->setDbValue($row['idemp']);
		$this->noemp->setDbValue($row['noemp']);
		$this->lastname->setDbValue($row['lastname']);
		$this->firstname->setDbValue($row['firstname']);
		$this->basicsalary->setDbValue($row['basicsalary']);
		$this->nifcin->setDbValue($row['nifcin']);
		$this->gender->setDbValue($row['gender']);
		$this->civilstatus->setDbValue($row['civilstatus']);
		$this->depend->setDbValue($row['depend']);
		$this->datenais->setDbValue($row['datenais']);
		$this->lieunais->setDbValue($row['lieunais']);
		$this->adresse->setDbValue($row['adresse']);
		$this->phone->setDbValue($row['phone']);
		$this->reference->setDbValue($row['reference']);
		$this->refphone->setDbValue($row['refphone']);
		$this->urgence->setDbValue($row['urgence']);
		$this->urgphone->setDbValue($row['urgphone']);
		$this->joindate->setDbValue($row['joindate']);
		$this->leavingdate->setDbValue($row['leavingdate']);
		$this->leavingmotif->setDbValue($row['leavingmotif']);
		$this->idtype->setDbValue($row['idtype']);
		$this->idstatus->setDbValue($row['idstatus']);
		$this->idfct->setDbValue($row['idfct']);
		$this->idsect->setDbValue($row['idsect']);
		$this->iddep->setDbValue($row['iddep']);
		$this->iddesig->setDbValue($row['iddesig']);
		$this->qualif->setDbValue($row['qualif']);
		$this->listpolicy->setDbValue($row['listpolicy']);
		if (!isset($GLOBALS["policyemp_grid"]))
			$GLOBALS["policyemp_grid"] = new policyemp_grid();
		$detailFilter = $GLOBALS["policyemp"]->sqlDetailFilter_employee();
		$detailFilter = str_replace("@idemp@", AdjustSql($this->idemp->DbValue, "DB"), $detailFilter);
		$GLOBALS["policyemp"]->setCurrentMasterTable("employee");
		$detailFilter = $GLOBALS["policyemp"]->applyUserIDFilters($detailFilter);
		$this->policyemp_Count = $GLOBALS["policyemp"]->loadRecordCount($detailFilter);
		if (!isset($GLOBALS["detailpayroll_grid"]))
			$GLOBALS["detailpayroll_grid"] = new detailpayroll_grid();
		$detailFilter = $GLOBALS["detailpayroll"]->sqlDetailFilter_employee();
		$detailFilter = str_replace("@idemp@", AdjustSql($this->idemp->DbValue, "DB"), $detailFilter);
		$GLOBALS["detailpayroll"]->setCurrentMasterTable("employee");
		$detailFilter = $GLOBALS["detailpayroll"]->applyUserIDFilters($detailFilter);
		$this->detailpayroll_Count = $GLOBALS["detailpayroll"]->loadRecordCount($detailFilter);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['idemp'] = NULL;
		$row['noemp'] = NULL;
		$row['lastname'] = NULL;
		$row['firstname'] = NULL;
		$row['basicsalary'] = NULL;
		$row['nifcin'] = NULL;
		$row['gender'] = NULL;
		$row['civilstatus'] = NULL;
		$row['depend'] = NULL;
		$row['datenais'] = NULL;
		$row['lieunais'] = NULL;
		$row['adresse'] = NULL;
		$row['phone'] = NULL;
		$row['reference'] = NULL;
		$row['refphone'] = NULL;
		$row['urgence'] = NULL;
		$row['urgphone'] = NULL;
		$row['joindate'] = NULL;
		$row['leavingdate'] = NULL;
		$row['leavingmotif'] = NULL;
		$row['idtype'] = NULL;
		$row['idstatus'] = NULL;
		$row['idfct'] = NULL;
		$row['idsect'] = NULL;
		$row['iddep'] = NULL;
		$row['iddesig'] = NULL;
		$row['qualif'] = NULL;
		$row['listpolicy'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->basicsalary->FormValue == $this->basicsalary->CurrentValue && is_numeric(ConvertToFloatString($this->basicsalary->CurrentValue)))
			$this->basicsalary->CurrentValue = ConvertToFloatString($this->basicsalary->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// idemp
		// noemp
		// lastname
		// firstname
		// basicsalary
		// nifcin
		// gender
		// civilstatus
		// depend
		// datenais
		// lieunais
		// adresse
		// phone
		// reference
		// refphone
		// urgence
		// urgphone
		// joindate
		// leavingdate
		// leavingmotif
		// idtype
		// idstatus
		// idfct
		// idsect
		// iddep
		// iddesig
		// qualif
		// listpolicy

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// idemp
			$this->idemp->ViewValue = $this->idemp->CurrentValue;
			$this->idemp->ViewCustomAttributes = "";

			// noemp
			$this->noemp->ViewValue = $this->noemp->CurrentValue;
			$this->noemp->ViewValue = FormatNumber($this->noemp->ViewValue, 0, -2, -2, -2);
			$this->noemp->ViewCustomAttributes = "";

			// lastname
			$this->lastname->ViewValue = $this->lastname->CurrentValue;
			$this->lastname->ViewCustomAttributes = "";

			// firstname
			$this->firstname->ViewValue = $this->firstname->CurrentValue;
			$this->firstname->ViewCustomAttributes = "";

			// basicsalary
			$this->basicsalary->ViewValue = $this->basicsalary->CurrentValue;
			$this->basicsalary->ViewValue = FormatNumber($this->basicsalary->ViewValue, 2, -2, -2, -2);
			$this->basicsalary->ViewCustomAttributes = "";

			// nifcin
			$this->nifcin->ViewValue = $this->nifcin->CurrentValue;
			$this->nifcin->ViewCustomAttributes = "";

			// gender
			if (strval($this->gender->CurrentValue) != "") {
				$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
			} else {
				$this->gender->ViewValue = NULL;
			}
			$this->gender->ViewCustomAttributes = "";

			// civilstatus
			if (strval($this->civilstatus->CurrentValue) != "") {
				$this->civilstatus->ViewValue = $this->civilstatus->optionCaption($this->civilstatus->CurrentValue);
			} else {
				$this->civilstatus->ViewValue = NULL;
			}
			$this->civilstatus->ViewCustomAttributes = "";

			// depend
			$this->depend->ViewValue = $this->depend->CurrentValue;
			$this->depend->ViewValue = FormatNumber($this->depend->ViewValue, 0, -2, -2, -2);
			$this->depend->ViewCustomAttributes = "";

			// datenais
			$this->datenais->ViewValue = $this->datenais->CurrentValue;
			$this->datenais->ViewValue = FormatDateTime($this->datenais->ViewValue, 0);
			$this->datenais->ViewCustomAttributes = "";

			// lieunais
			$this->lieunais->ViewValue = $this->lieunais->CurrentValue;
			$this->lieunais->ViewCustomAttributes = "";

			// adresse
			$this->adresse->ViewValue = $this->adresse->CurrentValue;
			$this->adresse->ViewCustomAttributes = "";

			// phone
			$this->phone->ViewValue = $this->phone->CurrentValue;
			$this->phone->ViewCustomAttributes = "";

			// reference
			$this->reference->ViewValue = $this->reference->CurrentValue;
			$this->reference->ViewCustomAttributes = "";

			// refphone
			$this->refphone->ViewValue = $this->refphone->CurrentValue;
			$this->refphone->ViewCustomAttributes = "";

			// urgence
			$this->urgence->ViewValue = $this->urgence->CurrentValue;
			$this->urgence->ViewCustomAttributes = "";

			// urgphone
			$this->urgphone->ViewValue = $this->urgphone->CurrentValue;
			$this->urgphone->ViewCustomAttributes = "";

			// joindate
			$this->joindate->ViewValue = $this->joindate->CurrentValue;
			$this->joindate->ViewValue = FormatDateTime($this->joindate->ViewValue, 0);
			$this->joindate->ViewCustomAttributes = "";

			// leavingdate
			$this->leavingdate->ViewValue = $this->leavingdate->CurrentValue;
			$this->leavingdate->ViewValue = FormatDateTime($this->leavingdate->ViewValue, 0);
			$this->leavingdate->ViewCustomAttributes = "";

			// leavingmotif
			$this->leavingmotif->ViewValue = $this->leavingmotif->CurrentValue;
			$this->leavingmotif->ViewCustomAttributes = "";

			// idtype
			$curVal = strval($this->idtype->CurrentValue);
			if ($curVal != "") {
				$this->idtype->ViewValue = $this->idtype->lookupCacheOption($curVal);
				if ($this->idtype->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idtype`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idtype->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->idtype->ViewValue = $this->idtype->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idtype->ViewValue = $this->idtype->CurrentValue;
					}
				}
			} else {
				$this->idtype->ViewValue = NULL;
			}
			$this->idtype->ViewCustomAttributes = "";

			// idstatus
			$curVal = strval($this->idstatus->CurrentValue);
			if ($curVal != "") {
				$this->idstatus->ViewValue = $this->idstatus->lookupCacheOption($curVal);
				if ($this->idstatus->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idstatus`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idstatus->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->idstatus->ViewValue = $this->idstatus->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idstatus->ViewValue = $this->idstatus->CurrentValue;
					}
				}
			} else {
				$this->idstatus->ViewValue = NULL;
			}
			$this->idstatus->ViewCustomAttributes = "";

			// idfct
			$curVal = strval($this->idfct->CurrentValue);
			if ($curVal != "") {
				$this->idfct->ViewValue = $this->idfct->lookupCacheOption($curVal);
				if ($this->idfct->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idfct`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idfct->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->idfct->ViewValue = $this->idfct->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idfct->ViewValue = $this->idfct->CurrentValue;
					}
				}
			} else {
				$this->idfct->ViewValue = NULL;
			}
			$this->idfct->ViewCustomAttributes = "";

			// idsect
			$curVal = strval($this->idsect->CurrentValue);
			if ($curVal != "") {
				$this->idsect->ViewValue = $this->idsect->lookupCacheOption($curVal);
				if ($this->idsect->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idsect`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idsect->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->idsect->ViewValue = $this->idsect->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idsect->ViewValue = $this->idsect->CurrentValue;
					}
				}
			} else {
				$this->idsect->ViewValue = NULL;
			}
			$this->idsect->ViewCustomAttributes = "";

			// iddep
			$curVal = strval($this->iddep->CurrentValue);
			if ($curVal != "") {
				$this->iddep->ViewValue = $this->iddep->lookupCacheOption($curVal);
				if ($this->iddep->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`iddep`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->iddep->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->iddep->ViewValue = $this->iddep->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->iddep->ViewValue = $this->iddep->CurrentValue;
					}
				}
			} else {
				$this->iddep->ViewValue = NULL;
			}
			$this->iddep->ViewCustomAttributes = "";

			// iddesig
			$curVal = strval($this->iddesig->CurrentValue);
			if ($curVal != "") {
				$this->iddesig->ViewValue = $this->iddesig->lookupCacheOption($curVal);
				if ($this->iddesig->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`iddesig`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->iddesig->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->iddesig->ViewValue = $this->iddesig->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->iddesig->ViewValue = $this->iddesig->CurrentValue;
					}
				}
			} else {
				$this->iddesig->ViewValue = NULL;
			}
			$this->iddesig->ViewCustomAttributes = "";

			// qualif
			$this->qualif->ViewValue = $this->qualif->CurrentValue;
			$this->qualif->ViewCustomAttributes = "";

			// listpolicy
			$this->listpolicy->ViewValue = $this->listpolicy->CurrentValue;
			$this->listpolicy->ViewCustomAttributes = "";

			// idemp
			$this->idemp->LinkCustomAttributes = "";
			$this->idemp->HrefValue = "";
			$this->idemp->TooltipValue = "";

			// noemp
			$this->noemp->LinkCustomAttributes = "";
			if (!EmptyValue($this->idemp->CurrentValue)) {
				$this->noemp->HrefValue = "detailpayrolllist.php?showmaster=employee&idemp=" . $this->idemp->CurrentValue; // Add prefix/suffix
				$this->noemp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport())
					$this->noemp->HrefValue = FullUrl($this->noemp->HrefValue, "href");
			} else {
				$this->noemp->HrefValue = "";
			}
			$this->noemp->TooltipValue = "";

			// lastname
			$this->lastname->LinkCustomAttributes = "";
			$this->lastname->HrefValue = "";
			$this->lastname->TooltipValue = "";

			// firstname
			$this->firstname->LinkCustomAttributes = "";
			$this->firstname->HrefValue = "";
			$this->firstname->TooltipValue = "";

			// basicsalary
			$this->basicsalary->LinkCustomAttributes = "";
			$this->basicsalary->HrefValue = "";
			$this->basicsalary->TooltipValue = "";

			// nifcin
			$this->nifcin->LinkCustomAttributes = "";
			$this->nifcin->HrefValue = "";
			$this->nifcin->TooltipValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";
			$this->gender->TooltipValue = "";

			// civilstatus
			$this->civilstatus->LinkCustomAttributes = "";
			$this->civilstatus->HrefValue = "";
			$this->civilstatus->TooltipValue = "";

			// depend
			$this->depend->LinkCustomAttributes = "";
			$this->depend->HrefValue = "";
			$this->depend->TooltipValue = "";

			// datenais
			$this->datenais->LinkCustomAttributes = "";
			$this->datenais->HrefValue = "";
			$this->datenais->TooltipValue = "";

			// lieunais
			$this->lieunais->LinkCustomAttributes = "";
			$this->lieunais->HrefValue = "";
			$this->lieunais->TooltipValue = "";

			// adresse
			$this->adresse->LinkCustomAttributes = "";
			$this->adresse->HrefValue = "";
			$this->adresse->TooltipValue = "";

			// phone
			$this->phone->LinkCustomAttributes = "";
			$this->phone->HrefValue = "";
			$this->phone->TooltipValue = "";

			// reference
			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";
			$this->reference->TooltipValue = "";

			// refphone
			$this->refphone->LinkCustomAttributes = "";
			$this->refphone->HrefValue = "";
			$this->refphone->TooltipValue = "";

			// urgence
			$this->urgence->LinkCustomAttributes = "";
			$this->urgence->HrefValue = "";
			$this->urgence->TooltipValue = "";

			// urgphone
			$this->urgphone->LinkCustomAttributes = "";
			$this->urgphone->HrefValue = "";
			$this->urgphone->TooltipValue = "";

			// joindate
			$this->joindate->LinkCustomAttributes = "";
			$this->joindate->HrefValue = "";
			$this->joindate->TooltipValue = "";

			// leavingdate
			$this->leavingdate->LinkCustomAttributes = "";
			$this->leavingdate->HrefValue = "";
			$this->leavingdate->TooltipValue = "";

			// leavingmotif
			$this->leavingmotif->LinkCustomAttributes = "";
			$this->leavingmotif->HrefValue = "";
			$this->leavingmotif->TooltipValue = "";

			// idtype
			$this->idtype->LinkCustomAttributes = "";
			$this->idtype->HrefValue = "";
			$this->idtype->TooltipValue = "";

			// idstatus
			$this->idstatus->LinkCustomAttributes = "";
			$this->idstatus->HrefValue = "";
			$this->idstatus->TooltipValue = "";

			// idfct
			$this->idfct->LinkCustomAttributes = "";
			$this->idfct->HrefValue = "";
			$this->idfct->TooltipValue = "";

			// idsect
			$this->idsect->LinkCustomAttributes = "";
			$this->idsect->HrefValue = "";
			$this->idsect->TooltipValue = "";

			// iddep
			$this->iddep->LinkCustomAttributes = "";
			$this->iddep->HrefValue = "";
			$this->iddep->TooltipValue = "";

			// iddesig
			$this->iddesig->LinkCustomAttributes = "";
			$this->iddesig->HrefValue = "";
			$this->iddesig->TooltipValue = "";

			// qualif
			$this->qualif->LinkCustomAttributes = "";
			$this->qualif->HrefValue = "";
			$this->qualif->TooltipValue = "";

			// listpolicy
			$this->listpolicy->LinkCustomAttributes = "";
			$this->listpolicy->HrefValue = "";
			$this->listpolicy->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("policyemp", $detailTblVar)) {
				if (!isset($GLOBALS["policyemp_grid"]))
					$GLOBALS["policyemp_grid"] = new policyemp_grid();
				if ($GLOBALS["policyemp_grid"]->DetailView) {
					$GLOBALS["policyemp_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["policyemp_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["policyemp_grid"]->setStartRecordNumber(1);
					$GLOBALS["policyemp_grid"]->idemp->IsDetailKey = TRUE;
					$GLOBALS["policyemp_grid"]->idemp->CurrentValue = $this->idemp->CurrentValue;
					$GLOBALS["policyemp_grid"]->idemp->setSessionValue($GLOBALS["policyemp_grid"]->idemp->CurrentValue);
				}
			}
			if (in_array("detailpayroll", $detailTblVar)) {
				if (!isset($GLOBALS["detailpayroll_grid"]))
					$GLOBALS["detailpayroll_grid"] = new detailpayroll_grid();
				if ($GLOBALS["detailpayroll_grid"]->DetailView) {
					$GLOBALS["detailpayroll_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["detailpayroll_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["detailpayroll_grid"]->setStartRecordNumber(1);
					$GLOBALS["detailpayroll_grid"]->idemp->IsDetailKey = TRUE;
					$GLOBALS["detailpayroll_grid"]->idemp->CurrentValue = $this->idemp->CurrentValue;
					$GLOBALS["detailpayroll_grid"]->idemp->setSessionValue($GLOBALS["detailpayroll_grid"]->idemp->CurrentValue);
					$GLOBALS["detailpayroll_grid"]->idpayroll->setSessionValue(""); // Clear session key
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("employeelist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_gender":
					break;
				case "x_civilstatus":
					break;
				case "x_idtype":
					break;
				case "x_idstatus":
					break;
				case "x_idfct":
					break;
				case "x_idsect":
					break;
				case "x_iddep":
					break;
				case "x_iddesig":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_idtype":
							break;
						case "x_idstatus":
							break;
						case "x_idfct":
							break;
						case "x_idsect":
							break;
						case "x_iddep":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_iddesig":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
} // End class
?>