<?php
namespace PHPMaker2020\intextdesign_proj_v0;

/**
 * Page class
 */
class employee_edit extends employee
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{D5394950-A905-4BDF-B7DA-D47F92A453D8}";

	// Table name
	public $TableName = 'employee';

	// Page object name
	public $PageObjName = "employee_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (employee)
		if (!isset($GLOBALS["employee"]) || get_class($GLOBALS["employee"]) == PROJECT_NAMESPACE . "employee") {
			$GLOBALS["employee"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["employee"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'employee');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $employee;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($employee);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "employeeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idemp'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idemp->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canEdit()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("employeelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->idemp->setVisibility();
		$this->noemp->setVisibility();
		$this->lastname->setVisibility();
		$this->firstname->setVisibility();
		$this->basicsalary->setVisibility();
		$this->nifcin->setVisibility();
		$this->gender->setVisibility();
		$this->civilstatus->setVisibility();
		$this->depend->setVisibility();
		$this->datenais->setVisibility();
		$this->lieunais->setVisibility();
		$this->adresse->setVisibility();
		$this->phone->setVisibility();
		$this->reference->setVisibility();
		$this->refphone->setVisibility();
		$this->urgence->setVisibility();
		$this->urgphone->setVisibility();
		$this->joindate->setVisibility();
		$this->leavingdate->setVisibility();
		$this->leavingmotif->setVisibility();
		$this->idtype->setVisibility();
		$this->idstatus->setVisibility();
		$this->idfct->setVisibility();
		$this->idsect->setVisibility();
		$this->iddep->setVisibility();
		$this->iddesig->setVisibility();
		$this->qualif->setVisibility();
		$this->listpolicy->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->idtype);
		$this->setupLookupOptions($this->idstatus);
		$this->setupLookupOptions($this->idfct);
		$this->setupLookupOptions($this->idsect);
		$this->setupLookupOptions($this->iddep);
		$this->setupLookupOptions($this->iddesig);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {

			// Load key values
			$loaded = TRUE;
			if (Get("idemp") !== NULL) {
				$this->idemp->setQueryStringValue(Get("idemp"));
				$this->idemp->setOldValue($this->idemp->QueryStringValue);
			} elseif (Key(0) !== NULL) {
				$this->idemp->setQueryStringValue(Key(0));
				$this->idemp->setOldValue($this->idemp->QueryStringValue);
			} elseif (Post("idemp") !== NULL) {
				$this->idemp->setFormValue(Post("idemp"));
				$this->idemp->setOldValue($this->idemp->FormValue);
			} elseif (Route(2) !== NULL) {
				$this->idemp->setQueryStringValue(Route(2));
				$this->idemp->setOldValue($this->idemp->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}

			// Load record
			if ($loaded)
				$loaded = $this->loadRow();
			if (!$loaded) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
				$this->terminate();
				return;
			}
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} else {
			if (Post("action") !== NULL) {
				$this->CurrentAction = Post("action"); // Get action code
				if (!$this->isShow()) // Not reload record, handle as postback
					$postBack = TRUE;

				// Load key from Form
				if ($CurrentForm->hasValue("x_idemp")) {
					$this->idemp->setFormValue($CurrentForm->getValue("x_idemp"));
				}
			} else {
				$this->CurrentAction = "show"; // Default action is display

				// Load key from QueryString / Route
				$loadByQuery = FALSE;
				if (Get("idemp") !== NULL) {
					$this->idemp->setQueryStringValue(Get("idemp"));
					$loadByQuery = TRUE;
				} elseif (Route(2) !== NULL) {
					$this->idemp->setQueryStringValue(Route(2));
					$loadByQuery = TRUE;
				} else {
					$this->idemp->CurrentValue = NULL;
				}
			}

			// Load current record
			$loaded = $this->loadRow();
		}

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values

			// Set up detail parameters
			$this->setupDetailParms();
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("employeelist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "update": // Update
				if ($this->getCurrentDetailTable() != "") // Master/detail edit
					$returnUrl = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
				else
					$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "employeelist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'idemp' first before field var 'x_idemp'
		$val = $CurrentForm->hasValue("idemp") ? $CurrentForm->getValue("idemp") : $CurrentForm->getValue("x_idemp");
		if (!$this->idemp->IsDetailKey)
			$this->idemp->setFormValue($val);

		// Check field name 'noemp' first before field var 'x_noemp'
		$val = $CurrentForm->hasValue("noemp") ? $CurrentForm->getValue("noemp") : $CurrentForm->getValue("x_noemp");
		if (!$this->noemp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->noemp->Visible = FALSE; // Disable update for API request
			else
				$this->noemp->setFormValue($val);
		}

		// Check field name 'lastname' first before field var 'x_lastname'
		$val = $CurrentForm->hasValue("lastname") ? $CurrentForm->getValue("lastname") : $CurrentForm->getValue("x_lastname");
		if (!$this->lastname->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->lastname->Visible = FALSE; // Disable update for API request
			else
				$this->lastname->setFormValue($val);
		}

		// Check field name 'firstname' first before field var 'x_firstname'
		$val = $CurrentForm->hasValue("firstname") ? $CurrentForm->getValue("firstname") : $CurrentForm->getValue("x_firstname");
		if (!$this->firstname->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->firstname->Visible = FALSE; // Disable update for API request
			else
				$this->firstname->setFormValue($val);
		}

		// Check field name 'basicsalary' first before field var 'x_basicsalary'
		$val = $CurrentForm->hasValue("basicsalary") ? $CurrentForm->getValue("basicsalary") : $CurrentForm->getValue("x_basicsalary");
		if (!$this->basicsalary->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->basicsalary->Visible = FALSE; // Disable update for API request
			else
				$this->basicsalary->setFormValue($val);
		}

		// Check field name 'nifcin' first before field var 'x_nifcin'
		$val = $CurrentForm->hasValue("nifcin") ? $CurrentForm->getValue("nifcin") : $CurrentForm->getValue("x_nifcin");
		if (!$this->nifcin->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->nifcin->Visible = FALSE; // Disable update for API request
			else
				$this->nifcin->setFormValue($val);
		}

		// Check field name 'gender' first before field var 'x_gender'
		$val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
		if (!$this->gender->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->gender->Visible = FALSE; // Disable update for API request
			else
				$this->gender->setFormValue($val);
		}

		// Check field name 'civilstatus' first before field var 'x_civilstatus'
		$val = $CurrentForm->hasValue("civilstatus") ? $CurrentForm->getValue("civilstatus") : $CurrentForm->getValue("x_civilstatus");
		if (!$this->civilstatus->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->civilstatus->Visible = FALSE; // Disable update for API request
			else
				$this->civilstatus->setFormValue($val);
		}

		// Check field name 'depend' first before field var 'x_depend'
		$val = $CurrentForm->hasValue("depend") ? $CurrentForm->getValue("depend") : $CurrentForm->getValue("x_depend");
		if (!$this->depend->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->depend->Visible = FALSE; // Disable update for API request
			else
				$this->depend->setFormValue($val);
		}

		// Check field name 'datenais' first before field var 'x_datenais'
		$val = $CurrentForm->hasValue("datenais") ? $CurrentForm->getValue("datenais") : $CurrentForm->getValue("x_datenais");
		if (!$this->datenais->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->datenais->Visible = FALSE; // Disable update for API request
			else
				$this->datenais->setFormValue($val);
			$this->datenais->CurrentValue = UnFormatDateTime($this->datenais->CurrentValue, 0);
		}

		// Check field name 'lieunais' first before field var 'x_lieunais'
		$val = $CurrentForm->hasValue("lieunais") ? $CurrentForm->getValue("lieunais") : $CurrentForm->getValue("x_lieunais");
		if (!$this->lieunais->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->lieunais->Visible = FALSE; // Disable update for API request
			else
				$this->lieunais->setFormValue($val);
		}

		// Check field name 'adresse' first before field var 'x_adresse'
		$val = $CurrentForm->hasValue("adresse") ? $CurrentForm->getValue("adresse") : $CurrentForm->getValue("x_adresse");
		if (!$this->adresse->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->adresse->Visible = FALSE; // Disable update for API request
			else
				$this->adresse->setFormValue($val);
		}

		// Check field name 'phone' first before field var 'x_phone'
		$val = $CurrentForm->hasValue("phone") ? $CurrentForm->getValue("phone") : $CurrentForm->getValue("x_phone");
		if (!$this->phone->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->phone->Visible = FALSE; // Disable update for API request
			else
				$this->phone->setFormValue($val);
		}

		// Check field name 'reference' first before field var 'x_reference'
		$val = $CurrentForm->hasValue("reference") ? $CurrentForm->getValue("reference") : $CurrentForm->getValue("x_reference");
		if (!$this->reference->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->reference->Visible = FALSE; // Disable update for API request
			else
				$this->reference->setFormValue($val);
		}

		// Check field name 'refphone' first before field var 'x_refphone'
		$val = $CurrentForm->hasValue("refphone") ? $CurrentForm->getValue("refphone") : $CurrentForm->getValue("x_refphone");
		if (!$this->refphone->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->refphone->Visible = FALSE; // Disable update for API request
			else
				$this->refphone->setFormValue($val);
		}

		// Check field name 'urgence' first before field var 'x_urgence'
		$val = $CurrentForm->hasValue("urgence") ? $CurrentForm->getValue("urgence") : $CurrentForm->getValue("x_urgence");
		if (!$this->urgence->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->urgence->Visible = FALSE; // Disable update for API request
			else
				$this->urgence->setFormValue($val);
		}

		// Check field name 'urgphone' first before field var 'x_urgphone'
		$val = $CurrentForm->hasValue("urgphone") ? $CurrentForm->getValue("urgphone") : $CurrentForm->getValue("x_urgphone");
		if (!$this->urgphone->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->urgphone->Visible = FALSE; // Disable update for API request
			else
				$this->urgphone->setFormValue($val);
		}

		// Check field name 'joindate' first before field var 'x_joindate'
		$val = $CurrentForm->hasValue("joindate") ? $CurrentForm->getValue("joindate") : $CurrentForm->getValue("x_joindate");
		if (!$this->joindate->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->joindate->Visible = FALSE; // Disable update for API request
			else
				$this->joindate->setFormValue($val);
			$this->joindate->CurrentValue = UnFormatDateTime($this->joindate->CurrentValue, 0);
		}

		// Check field name 'leavingdate' first before field var 'x_leavingdate'
		$val = $CurrentForm->hasValue("leavingdate") ? $CurrentForm->getValue("leavingdate") : $CurrentForm->getValue("x_leavingdate");
		if (!$this->leavingdate->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->leavingdate->Visible = FALSE; // Disable update for API request
			else
				$this->leavingdate->setFormValue($val);
			$this->leavingdate->CurrentValue = UnFormatDateTime($this->leavingdate->CurrentValue, 0);
		}

		// Check field name 'leavingmotif' first before field var 'x_leavingmotif'
		$val = $CurrentForm->hasValue("leavingmotif") ? $CurrentForm->getValue("leavingmotif") : $CurrentForm->getValue("x_leavingmotif");
		if (!$this->leavingmotif->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->leavingmotif->Visible = FALSE; // Disable update for API request
			else
				$this->leavingmotif->setFormValue($val);
		}

		// Check field name 'idtype' first before field var 'x_idtype'
		$val = $CurrentForm->hasValue("idtype") ? $CurrentForm->getValue("idtype") : $CurrentForm->getValue("x_idtype");
		if (!$this->idtype->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->idtype->Visible = FALSE; // Disable update for API request
			else
				$this->idtype->setFormValue($val);
		}

		// Check field name 'idstatus' first before field var 'x_idstatus'
		$val = $CurrentForm->hasValue("idstatus") ? $CurrentForm->getValue("idstatus") : $CurrentForm->getValue("x_idstatus");
		if (!$this->idstatus->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->idstatus->Visible = FALSE; // Disable update for API request
			else
				$this->idstatus->setFormValue($val);
		}

		// Check field name 'idfct' first before field var 'x_idfct'
		$val = $CurrentForm->hasValue("idfct") ? $CurrentForm->getValue("idfct") : $CurrentForm->getValue("x_idfct");
		if (!$this->idfct->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->idfct->Visible = FALSE; // Disable update for API request
			else
				$this->idfct->setFormValue($val);
		}

		// Check field name 'idsect' first before field var 'x_idsect'
		$val = $CurrentForm->hasValue("idsect") ? $CurrentForm->getValue("idsect") : $CurrentForm->getValue("x_idsect");
		if (!$this->idsect->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->idsect->Visible = FALSE; // Disable update for API request
			else
				$this->idsect->setFormValue($val);
		}

		// Check field name 'iddep' first before field var 'x_iddep'
		$val = $CurrentForm->hasValue("iddep") ? $CurrentForm->getValue("iddep") : $CurrentForm->getValue("x_iddep");
		if (!$this->iddep->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->iddep->Visible = FALSE; // Disable update for API request
			else
				$this->iddep->setFormValue($val);
		}

		// Check field name 'iddesig' first before field var 'x_iddesig'
		$val = $CurrentForm->hasValue("iddesig") ? $CurrentForm->getValue("iddesig") : $CurrentForm->getValue("x_iddesig");
		if (!$this->iddesig->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->iddesig->Visible = FALSE; // Disable update for API request
			else
				$this->iddesig->setFormValue($val);
		}

		// Check field name 'qualif' first before field var 'x_qualif'
		$val = $CurrentForm->hasValue("qualif") ? $CurrentForm->getValue("qualif") : $CurrentForm->getValue("x_qualif");
		if (!$this->qualif->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->qualif->Visible = FALSE; // Disable update for API request
			else
				$this->qualif->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->idemp->CurrentValue = $this->idemp->FormValue;
		$this->noemp->CurrentValue = $this->noemp->FormValue;
		$this->lastname->CurrentValue = $this->lastname->FormValue;
		$this->firstname->CurrentValue = $this->firstname->FormValue;
		$this->basicsalary->CurrentValue = $this->basicsalary->FormValue;
		$this->nifcin->CurrentValue = $this->nifcin->FormValue;
		$this->gender->CurrentValue = $this->gender->FormValue;
		$this->civilstatus->CurrentValue = $this->civilstatus->FormValue;
		$this->depend->CurrentValue = $this->depend->FormValue;
		$this->datenais->CurrentValue = $this->datenais->FormValue;
		$this->datenais->CurrentValue = UnFormatDateTime($this->datenais->CurrentValue, 0);
		$this->lieunais->CurrentValue = $this->lieunais->FormValue;
		$this->adresse->CurrentValue = $this->adresse->FormValue;
		$this->phone->CurrentValue = $this->phone->FormValue;
		$this->reference->CurrentValue = $this->reference->FormValue;
		$this->refphone->CurrentValue = $this->refphone->FormValue;
		$this->urgence->CurrentValue = $this->urgence->FormValue;
		$this->urgphone->CurrentValue = $this->urgphone->FormValue;
		$this->joindate->CurrentValue = $this->joindate->FormValue;
		$this->joindate->CurrentValue = UnFormatDateTime($this->joindate->CurrentValue, 0);
		$this->leavingdate->CurrentValue = $this->leavingdate->FormValue;
		$this->leavingdate->CurrentValue = UnFormatDateTime($this->leavingdate->CurrentValue, 0);
		$this->leavingmotif->CurrentValue = $this->leavingmotif->FormValue;
		$this->idtype->CurrentValue = $this->idtype->FormValue;
		$this->idstatus->CurrentValue = $this->idstatus->FormValue;
		$this->idfct->CurrentValue = $this->idfct->FormValue;
		$this->idsect->CurrentValue = $this->idsect->FormValue;
		$this->iddep->CurrentValue = $this->iddep->FormValue;
		$this->iddesig->CurrentValue = $this->iddesig->FormValue;
		$this->qualif->CurrentValue = $this->qualif->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->idemp->setDbValue($row['idemp']);
		$this->noemp->setDbValue($row['noemp']);
		$this->lastname->setDbValue($row['lastname']);
		$this->firstname->setDbValue($row['firstname']);
		$this->basicsalary->setDbValue($row['basicsalary']);
		$this->nifcin->setDbValue($row['nifcin']);
		$this->gender->setDbValue($row['gender']);
		$this->civilstatus->setDbValue($row['civilstatus']);
		$this->depend->setDbValue($row['depend']);
		$this->datenais->setDbValue($row['datenais']);
		$this->lieunais->setDbValue($row['lieunais']);
		$this->adresse->setDbValue($row['adresse']);
		$this->phone->setDbValue($row['phone']);
		$this->reference->setDbValue($row['reference']);
		$this->refphone->setDbValue($row['refphone']);
		$this->urgence->setDbValue($row['urgence']);
		$this->urgphone->setDbValue($row['urgphone']);
		$this->joindate->setDbValue($row['joindate']);
		$this->leavingdate->setDbValue($row['leavingdate']);
		$this->leavingmotif->setDbValue($row['leavingmotif']);
		$this->idtype->setDbValue($row['idtype']);
		$this->idstatus->setDbValue($row['idstatus']);
		$this->idfct->setDbValue($row['idfct']);
		$this->idsect->setDbValue($row['idsect']);
		$this->iddep->setDbValue($row['iddep']);
		$this->iddesig->setDbValue($row['iddesig']);
		$this->qualif->setDbValue($row['qualif']);
		$this->listpolicy->setDbValue($row['listpolicy']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['idemp'] = NULL;
		$row['noemp'] = NULL;
		$row['lastname'] = NULL;
		$row['firstname'] = NULL;
		$row['basicsalary'] = NULL;
		$row['nifcin'] = NULL;
		$row['gender'] = NULL;
		$row['civilstatus'] = NULL;
		$row['depend'] = NULL;
		$row['datenais'] = NULL;
		$row['lieunais'] = NULL;
		$row['adresse'] = NULL;
		$row['phone'] = NULL;
		$row['reference'] = NULL;
		$row['refphone'] = NULL;
		$row['urgence'] = NULL;
		$row['urgphone'] = NULL;
		$row['joindate'] = NULL;
		$row['leavingdate'] = NULL;
		$row['leavingmotif'] = NULL;
		$row['idtype'] = NULL;
		$row['idstatus'] = NULL;
		$row['idfct'] = NULL;
		$row['idsect'] = NULL;
		$row['iddep'] = NULL;
		$row['iddesig'] = NULL;
		$row['qualif'] = NULL;
		$row['listpolicy'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("idemp")) != "")
			$this->idemp->OldValue = $this->getKey("idemp"); // idemp
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->basicsalary->FormValue == $this->basicsalary->CurrentValue && is_numeric(ConvertToFloatString($this->basicsalary->CurrentValue)))
			$this->basicsalary->CurrentValue = ConvertToFloatString($this->basicsalary->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// idemp
		// noemp
		// lastname
		// firstname
		// basicsalary
		// nifcin
		// gender
		// civilstatus
		// depend
		// datenais
		// lieunais
		// adresse
		// phone
		// reference
		// refphone
		// urgence
		// urgphone
		// joindate
		// leavingdate
		// leavingmotif
		// idtype
		// idstatus
		// idfct
		// idsect
		// iddep
		// iddesig
		// qualif
		// listpolicy

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// idemp
			$this->idemp->ViewValue = $this->idemp->CurrentValue;
			$this->idemp->ViewCustomAttributes = "";

			// noemp
			$this->noemp->ViewValue = $this->noemp->CurrentValue;
			$this->noemp->ViewValue = FormatNumber($this->noemp->ViewValue, 0, -2, -2, -2);
			$this->noemp->ViewCustomAttributes = "";

			// lastname
			$this->lastname->ViewValue = $this->lastname->CurrentValue;
			$this->lastname->ViewCustomAttributes = "";

			// firstname
			$this->firstname->ViewValue = $this->firstname->CurrentValue;
			$this->firstname->ViewCustomAttributes = "";

			// basicsalary
			$this->basicsalary->ViewValue = $this->basicsalary->CurrentValue;
			$this->basicsalary->ViewValue = FormatNumber($this->basicsalary->ViewValue, 2, -2, -2, -2);
			$this->basicsalary->ViewCustomAttributes = "";

			// nifcin
			$this->nifcin->ViewValue = $this->nifcin->CurrentValue;
			$this->nifcin->ViewCustomAttributes = "";

			// gender
			if (strval($this->gender->CurrentValue) != "") {
				$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
			} else {
				$this->gender->ViewValue = NULL;
			}
			$this->gender->ViewCustomAttributes = "";

			// civilstatus
			if (strval($this->civilstatus->CurrentValue) != "") {
				$this->civilstatus->ViewValue = $this->civilstatus->optionCaption($this->civilstatus->CurrentValue);
			} else {
				$this->civilstatus->ViewValue = NULL;
			}
			$this->civilstatus->ViewCustomAttributes = "";

			// depend
			$this->depend->ViewValue = $this->depend->CurrentValue;
			$this->depend->ViewValue = FormatNumber($this->depend->ViewValue, 0, -2, -2, -2);
			$this->depend->ViewCustomAttributes = "";

			// datenais
			$this->datenais->ViewValue = $this->datenais->CurrentValue;
			$this->datenais->ViewValue = FormatDateTime($this->datenais->ViewValue, 0);
			$this->datenais->ViewCustomAttributes = "";

			// lieunais
			$this->lieunais->ViewValue = $this->lieunais->CurrentValue;
			$this->lieunais->ViewCustomAttributes = "";

			// adresse
			$this->adresse->ViewValue = $this->adresse->CurrentValue;
			$this->adresse->ViewCustomAttributes = "";

			// phone
			$this->phone->ViewValue = $this->phone->CurrentValue;
			$this->phone->ViewCustomAttributes = "";

			// reference
			$this->reference->ViewValue = $this->reference->CurrentValue;
			$this->reference->ViewCustomAttributes = "";

			// refphone
			$this->refphone->ViewValue = $this->refphone->CurrentValue;
			$this->refphone->ViewCustomAttributes = "";

			// urgence
			$this->urgence->ViewValue = $this->urgence->CurrentValue;
			$this->urgence->ViewCustomAttributes = "";

			// urgphone
			$this->urgphone->ViewValue = $this->urgphone->CurrentValue;
			$this->urgphone->ViewCustomAttributes = "";

			// joindate
			$this->joindate->ViewValue = $this->joindate->CurrentValue;
			$this->joindate->ViewValue = FormatDateTime($this->joindate->ViewValue, 0);
			$this->joindate->ViewCustomAttributes = "";

			// leavingdate
			$this->leavingdate->ViewValue = $this->leavingdate->CurrentValue;
			$this->leavingdate->ViewValue = FormatDateTime($this->leavingdate->ViewValue, 0);
			$this->leavingdate->ViewCustomAttributes = "";

			// leavingmotif
			$this->leavingmotif->ViewValue = $this->leavingmotif->CurrentValue;
			$this->leavingmotif->ViewCustomAttributes = "";

			// idtype
			$curVal = strval($this->idtype->CurrentValue);
			if ($curVal != "") {
				$this->idtype->ViewValue = $this->idtype->lookupCacheOption($curVal);
				if ($this->idtype->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idtype`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idtype->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->idtype->ViewValue = $this->idtype->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idtype->ViewValue = $this->idtype->CurrentValue;
					}
				}
			} else {
				$this->idtype->ViewValue = NULL;
			}
			$this->idtype->ViewCustomAttributes = "";

			// idstatus
			$curVal = strval($this->idstatus->CurrentValue);
			if ($curVal != "") {
				$this->idstatus->ViewValue = $this->idstatus->lookupCacheOption($curVal);
				if ($this->idstatus->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idstatus`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idstatus->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->idstatus->ViewValue = $this->idstatus->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idstatus->ViewValue = $this->idstatus->CurrentValue;
					}
				}
			} else {
				$this->idstatus->ViewValue = NULL;
			}
			$this->idstatus->ViewCustomAttributes = "";

			// idfct
			$curVal = strval($this->idfct->CurrentValue);
			if ($curVal != "") {
				$this->idfct->ViewValue = $this->idfct->lookupCacheOption($curVal);
				if ($this->idfct->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idfct`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idfct->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->idfct->ViewValue = $this->idfct->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idfct->ViewValue = $this->idfct->CurrentValue;
					}
				}
			} else {
				$this->idfct->ViewValue = NULL;
			}
			$this->idfct->ViewCustomAttributes = "";

			// idsect
			$curVal = strval($this->idsect->CurrentValue);
			if ($curVal != "") {
				$this->idsect->ViewValue = $this->idsect->lookupCacheOption($curVal);
				if ($this->idsect->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idsect`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idsect->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->idsect->ViewValue = $this->idsect->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idsect->ViewValue = $this->idsect->CurrentValue;
					}
				}
			} else {
				$this->idsect->ViewValue = NULL;
			}
			$this->idsect->ViewCustomAttributes = "";

			// iddep
			$curVal = strval($this->iddep->CurrentValue);
			if ($curVal != "") {
				$this->iddep->ViewValue = $this->iddep->lookupCacheOption($curVal);
				if ($this->iddep->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`iddep`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->iddep->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->iddep->ViewValue = $this->iddep->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->iddep->ViewValue = $this->iddep->CurrentValue;
					}
				}
			} else {
				$this->iddep->ViewValue = NULL;
			}
			$this->iddep->ViewCustomAttributes = "";

			// iddesig
			$curVal = strval($this->iddesig->CurrentValue);
			if ($curVal != "") {
				$this->iddesig->ViewValue = $this->iddesig->lookupCacheOption($curVal);
				if ($this->iddesig->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`iddesig`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->iddesig->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->iddesig->ViewValue = $this->iddesig->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->iddesig->ViewValue = $this->iddesig->CurrentValue;
					}
				}
			} else {
				$this->iddesig->ViewValue = NULL;
			}
			$this->iddesig->ViewCustomAttributes = "";

			// qualif
			$this->qualif->ViewValue = $this->qualif->CurrentValue;
			$this->qualif->ViewCustomAttributes = "";

			// idemp
			$this->idemp->LinkCustomAttributes = "";
			$this->idemp->HrefValue = "";
			$this->idemp->TooltipValue = "";

			// noemp
			$this->noemp->LinkCustomAttributes = "";
			if (!EmptyValue($this->idemp->CurrentValue)) {
				$this->noemp->HrefValue = "detailpayrolllist.php?showmaster=employee&idemp=" . $this->idemp->CurrentValue; // Add prefix/suffix
				$this->noemp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport())
					$this->noemp->HrefValue = FullUrl($this->noemp->HrefValue, "href");
			} else {
				$this->noemp->HrefValue = "";
			}
			$this->noemp->TooltipValue = "";

			// lastname
			$this->lastname->LinkCustomAttributes = "";
			$this->lastname->HrefValue = "";
			$this->lastname->TooltipValue = "";

			// firstname
			$this->firstname->LinkCustomAttributes = "";
			$this->firstname->HrefValue = "";
			$this->firstname->TooltipValue = "";

			// basicsalary
			$this->basicsalary->LinkCustomAttributes = "";
			$this->basicsalary->HrefValue = "";
			$this->basicsalary->TooltipValue = "";

			// nifcin
			$this->nifcin->LinkCustomAttributes = "";
			$this->nifcin->HrefValue = "";
			$this->nifcin->TooltipValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";
			$this->gender->TooltipValue = "";

			// civilstatus
			$this->civilstatus->LinkCustomAttributes = "";
			$this->civilstatus->HrefValue = "";
			$this->civilstatus->TooltipValue = "";

			// depend
			$this->depend->LinkCustomAttributes = "";
			$this->depend->HrefValue = "";
			$this->depend->TooltipValue = "";

			// datenais
			$this->datenais->LinkCustomAttributes = "";
			$this->datenais->HrefValue = "";
			$this->datenais->TooltipValue = "";

			// lieunais
			$this->lieunais->LinkCustomAttributes = "";
			$this->lieunais->HrefValue = "";
			$this->lieunais->TooltipValue = "";

			// adresse
			$this->adresse->LinkCustomAttributes = "";
			$this->adresse->HrefValue = "";
			$this->adresse->TooltipValue = "";

			// phone
			$this->phone->LinkCustomAttributes = "";
			$this->phone->HrefValue = "";
			$this->phone->TooltipValue = "";

			// reference
			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";
			$this->reference->TooltipValue = "";

			// refphone
			$this->refphone->LinkCustomAttributes = "";
			$this->refphone->HrefValue = "";
			$this->refphone->TooltipValue = "";

			// urgence
			$this->urgence->LinkCustomAttributes = "";
			$this->urgence->HrefValue = "";
			$this->urgence->TooltipValue = "";

			// urgphone
			$this->urgphone->LinkCustomAttributes = "";
			$this->urgphone->HrefValue = "";
			$this->urgphone->TooltipValue = "";

			// joindate
			$this->joindate->LinkCustomAttributes = "";
			$this->joindate->HrefValue = "";
			$this->joindate->TooltipValue = "";

			// leavingdate
			$this->leavingdate->LinkCustomAttributes = "";
			$this->leavingdate->HrefValue = "";
			$this->leavingdate->TooltipValue = "";

			// leavingmotif
			$this->leavingmotif->LinkCustomAttributes = "";
			$this->leavingmotif->HrefValue = "";
			$this->leavingmotif->TooltipValue = "";

			// idtype
			$this->idtype->LinkCustomAttributes = "";
			$this->idtype->HrefValue = "";
			$this->idtype->TooltipValue = "";

			// idstatus
			$this->idstatus->LinkCustomAttributes = "";
			$this->idstatus->HrefValue = "";
			$this->idstatus->TooltipValue = "";

			// idfct
			$this->idfct->LinkCustomAttributes = "";
			$this->idfct->HrefValue = "";
			$this->idfct->TooltipValue = "";

			// idsect
			$this->idsect->LinkCustomAttributes = "";
			$this->idsect->HrefValue = "";
			$this->idsect->TooltipValue = "";

			// iddep
			$this->iddep->LinkCustomAttributes = "";
			$this->iddep->HrefValue = "";
			$this->iddep->TooltipValue = "";

			// iddesig
			$this->iddesig->LinkCustomAttributes = "";
			$this->iddesig->HrefValue = "";
			$this->iddesig->TooltipValue = "";

			// qualif
			$this->qualif->LinkCustomAttributes = "";
			$this->qualif->HrefValue = "";
			$this->qualif->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// idemp
			$this->idemp->EditAttrs["class"] = "form-control";
			$this->idemp->EditCustomAttributes = "";
			$this->idemp->EditValue = $this->idemp->CurrentValue;
			$this->idemp->ViewCustomAttributes = "";

			// noemp
			$this->noemp->EditAttrs["class"] = "form-control";
			$this->noemp->EditCustomAttributes = "";
			$this->noemp->EditValue = HtmlEncode($this->noemp->CurrentValue);
			$this->noemp->PlaceHolder = RemoveHtml($this->noemp->caption());

			// lastname
			$this->lastname->EditAttrs["class"] = "form-control";
			$this->lastname->EditCustomAttributes = "";
			if (!$this->lastname->Raw)
				$this->lastname->CurrentValue = HtmlDecode($this->lastname->CurrentValue);
			$this->lastname->EditValue = HtmlEncode($this->lastname->CurrentValue);
			$this->lastname->PlaceHolder = RemoveHtml($this->lastname->caption());

			// firstname
			$this->firstname->EditAttrs["class"] = "form-control";
			$this->firstname->EditCustomAttributes = "";
			if (!$this->firstname->Raw)
				$this->firstname->CurrentValue = HtmlDecode($this->firstname->CurrentValue);
			$this->firstname->EditValue = HtmlEncode($this->firstname->CurrentValue);
			$this->firstname->PlaceHolder = RemoveHtml($this->firstname->caption());

			// basicsalary
			$this->basicsalary->EditAttrs["class"] = "form-control";
			$this->basicsalary->EditCustomAttributes = "";
			$this->basicsalary->EditValue = HtmlEncode($this->basicsalary->CurrentValue);
			$this->basicsalary->PlaceHolder = RemoveHtml($this->basicsalary->caption());
			if (strval($this->basicsalary->EditValue) != "" && is_numeric($this->basicsalary->EditValue))
				$this->basicsalary->EditValue = FormatNumber($this->basicsalary->EditValue, -2, -2, -2, -2);
			

			// nifcin
			$this->nifcin->EditAttrs["class"] = "form-control";
			$this->nifcin->EditCustomAttributes = "";
			if (!$this->nifcin->Raw)
				$this->nifcin->CurrentValue = HtmlDecode($this->nifcin->CurrentValue);
			$this->nifcin->EditValue = HtmlEncode($this->nifcin->CurrentValue);
			$this->nifcin->PlaceHolder = RemoveHtml($this->nifcin->caption());

			// gender
			$this->gender->EditCustomAttributes = "";
			$this->gender->EditValue = $this->gender->options(FALSE);

			// civilstatus
			$this->civilstatus->EditCustomAttributes = "";
			$this->civilstatus->EditValue = $this->civilstatus->options(FALSE);

			// depend
			$this->depend->EditAttrs["class"] = "form-control";
			$this->depend->EditCustomAttributes = "";
			$this->depend->EditValue = HtmlEncode($this->depend->CurrentValue);
			$this->depend->PlaceHolder = RemoveHtml($this->depend->caption());

			// datenais
			$this->datenais->EditAttrs["class"] = "form-control";
			$this->datenais->EditCustomAttributes = "";
			$this->datenais->EditValue = HtmlEncode(FormatDateTime($this->datenais->CurrentValue, 8));
			$this->datenais->PlaceHolder = RemoveHtml($this->datenais->caption());

			// lieunais
			$this->lieunais->EditAttrs["class"] = "form-control";
			$this->lieunais->EditCustomAttributes = "";
			if (!$this->lieunais->Raw)
				$this->lieunais->CurrentValue = HtmlDecode($this->lieunais->CurrentValue);
			$this->lieunais->EditValue = HtmlEncode($this->lieunais->CurrentValue);
			$this->lieunais->PlaceHolder = RemoveHtml($this->lieunais->caption());

			// adresse
			$this->adresse->EditAttrs["class"] = "form-control";
			$this->adresse->EditCustomAttributes = "";
			if (!$this->adresse->Raw)
				$this->adresse->CurrentValue = HtmlDecode($this->adresse->CurrentValue);
			$this->adresse->EditValue = HtmlEncode($this->adresse->CurrentValue);
			$this->adresse->PlaceHolder = RemoveHtml($this->adresse->caption());

			// phone
			$this->phone->EditAttrs["class"] = "form-control";
			$this->phone->EditCustomAttributes = "";
			if (!$this->phone->Raw)
				$this->phone->CurrentValue = HtmlDecode($this->phone->CurrentValue);
			$this->phone->EditValue = HtmlEncode($this->phone->CurrentValue);
			$this->phone->PlaceHolder = RemoveHtml($this->phone->caption());

			// reference
			$this->reference->EditAttrs["class"] = "form-control";
			$this->reference->EditCustomAttributes = "";
			if (!$this->reference->Raw)
				$this->reference->CurrentValue = HtmlDecode($this->reference->CurrentValue);
			$this->reference->EditValue = HtmlEncode($this->reference->CurrentValue);
			$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

			// refphone
			$this->refphone->EditAttrs["class"] = "form-control";
			$this->refphone->EditCustomAttributes = "";
			if (!$this->refphone->Raw)
				$this->refphone->CurrentValue = HtmlDecode($this->refphone->CurrentValue);
			$this->refphone->EditValue = HtmlEncode($this->refphone->CurrentValue);
			$this->refphone->PlaceHolder = RemoveHtml($this->refphone->caption());

			// urgence
			$this->urgence->EditAttrs["class"] = "form-control";
			$this->urgence->EditCustomAttributes = "";
			if (!$this->urgence->Raw)
				$this->urgence->CurrentValue = HtmlDecode($this->urgence->CurrentValue);
			$this->urgence->EditValue = HtmlEncode($this->urgence->CurrentValue);
			$this->urgence->PlaceHolder = RemoveHtml($this->urgence->caption());

			// urgphone
			$this->urgphone->EditAttrs["class"] = "form-control";
			$this->urgphone->EditCustomAttributes = "";
			if (!$this->urgphone->Raw)
				$this->urgphone->CurrentValue = HtmlDecode($this->urgphone->CurrentValue);
			$this->urgphone->EditValue = HtmlEncode($this->urgphone->CurrentValue);
			$this->urgphone->PlaceHolder = RemoveHtml($this->urgphone->caption());

			// joindate
			$this->joindate->EditAttrs["class"] = "form-control";
			$this->joindate->EditCustomAttributes = "";
			$this->joindate->EditValue = HtmlEncode(FormatDateTime($this->joindate->CurrentValue, 8));
			$this->joindate->PlaceHolder = RemoveHtml($this->joindate->caption());

			// leavingdate
			$this->leavingdate->EditAttrs["class"] = "form-control";
			$this->leavingdate->EditCustomAttributes = "";
			$this->leavingdate->EditValue = HtmlEncode(FormatDateTime($this->leavingdate->CurrentValue, 8));
			$this->leavingdate->PlaceHolder = RemoveHtml($this->leavingdate->caption());

			// leavingmotif
			$this->leavingmotif->EditAttrs["class"] = "form-control";
			$this->leavingmotif->EditCustomAttributes = "";
			if (!$this->leavingmotif->Raw)
				$this->leavingmotif->CurrentValue = HtmlDecode($this->leavingmotif->CurrentValue);
			$this->leavingmotif->EditValue = HtmlEncode($this->leavingmotif->CurrentValue);
			$this->leavingmotif->PlaceHolder = RemoveHtml($this->leavingmotif->caption());

			// idtype
			$this->idtype->EditAttrs["class"] = "form-control";
			$this->idtype->EditCustomAttributes = "";
			$curVal = trim(strval($this->idtype->CurrentValue));
			if ($curVal != "")
				$this->idtype->ViewValue = $this->idtype->lookupCacheOption($curVal);
			else
				$this->idtype->ViewValue = $this->idtype->Lookup !== NULL && is_array($this->idtype->Lookup->Options) ? $curVal : NULL;
			if ($this->idtype->ViewValue !== NULL) { // Load from cache
				$this->idtype->EditValue = array_values($this->idtype->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`idtype`" . SearchString("=", $this->idtype->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->idtype->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->idtype->EditValue = $arwrk;
			}

			// idstatus
			$this->idstatus->EditAttrs["class"] = "form-control";
			$this->idstatus->EditCustomAttributes = "";
			$curVal = trim(strval($this->idstatus->CurrentValue));
			if ($curVal != "")
				$this->idstatus->ViewValue = $this->idstatus->lookupCacheOption($curVal);
			else
				$this->idstatus->ViewValue = $this->idstatus->Lookup !== NULL && is_array($this->idstatus->Lookup->Options) ? $curVal : NULL;
			if ($this->idstatus->ViewValue !== NULL) { // Load from cache
				$this->idstatus->EditValue = array_values($this->idstatus->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`idstatus`" . SearchString("=", $this->idstatus->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->idstatus->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->idstatus->EditValue = $arwrk;
			}

			// idfct
			$this->idfct->EditCustomAttributes = "";
			$curVal = trim(strval($this->idfct->CurrentValue));
			if ($curVal != "")
				$this->idfct->ViewValue = $this->idfct->lookupCacheOption($curVal);
			else
				$this->idfct->ViewValue = $this->idfct->Lookup !== NULL && is_array($this->idfct->Lookup->Options) ? $curVal : NULL;
			if ($this->idfct->ViewValue !== NULL) { // Load from cache
				$this->idfct->EditValue = array_values($this->idfct->Lookup->Options);
				if ($this->idfct->ViewValue == "")
					$this->idfct->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`idfct`" . SearchString("=", $this->idfct->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->idfct->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->idfct->ViewValue = $this->idfct->displayValue($arwrk);
				} else {
					$this->idfct->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->idfct->EditValue = $arwrk;
			}

			// idsect
			$this->idsect->EditCustomAttributes = "";
			$curVal = trim(strval($this->idsect->CurrentValue));
			if ($curVal != "")
				$this->idsect->ViewValue = $this->idsect->lookupCacheOption($curVal);
			else
				$this->idsect->ViewValue = $this->idsect->Lookup !== NULL && is_array($this->idsect->Lookup->Options) ? $curVal : NULL;
			if ($this->idsect->ViewValue !== NULL) { // Load from cache
				$this->idsect->EditValue = array_values($this->idsect->Lookup->Options);
				if ($this->idsect->ViewValue == "")
					$this->idsect->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`idsect`" . SearchString("=", $this->idsect->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->idsect->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->idsect->ViewValue = $this->idsect->displayValue($arwrk);
				} else {
					$this->idsect->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->idsect->EditValue = $arwrk;
			}

			// iddep
			$this->iddep->EditCustomAttributes = "";
			$curVal = trim(strval($this->iddep->CurrentValue));
			if ($curVal != "")
				$this->iddep->ViewValue = $this->iddep->lookupCacheOption($curVal);
			else
				$this->iddep->ViewValue = $this->iddep->Lookup !== NULL && is_array($this->iddep->Lookup->Options) ? $curVal : NULL;
			if ($this->iddep->ViewValue !== NULL) { // Load from cache
				$this->iddep->EditValue = array_values($this->iddep->Lookup->Options);
				if ($this->iddep->ViewValue == "")
					$this->iddep->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`iddep`" . SearchString("=", $this->iddep->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->iddep->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->iddep->ViewValue = $this->iddep->displayValue($arwrk);
				} else {
					$this->iddep->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->iddep->EditValue = $arwrk;
			}

			// iddesig
			$this->iddesig->EditCustomAttributes = "";
			$curVal = trim(strval($this->iddesig->CurrentValue));
			if ($curVal != "")
				$this->iddesig->ViewValue = $this->iddesig->lookupCacheOption($curVal);
			else
				$this->iddesig->ViewValue = $this->iddesig->Lookup !== NULL && is_array($this->iddesig->Lookup->Options) ? $curVal : NULL;
			if ($this->iddesig->ViewValue !== NULL) { // Load from cache
				$this->iddesig->EditValue = array_values($this->iddesig->Lookup->Options);
				if ($this->iddesig->ViewValue == "")
					$this->iddesig->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`iddesig`" . SearchString("=", $this->iddesig->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->iddesig->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->iddesig->ViewValue = $this->iddesig->displayValue($arwrk);
				} else {
					$this->iddesig->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->iddesig->EditValue = $arwrk;
			}

			// qualif
			$this->qualif->EditAttrs["class"] = "form-control";
			$this->qualif->EditCustomAttributes = "";
			if (!$this->qualif->Raw)
				$this->qualif->CurrentValue = HtmlDecode($this->qualif->CurrentValue);
			$this->qualif->EditValue = HtmlEncode($this->qualif->CurrentValue);
			$this->qualif->PlaceHolder = RemoveHtml($this->qualif->caption());

			// Edit refer script
			// idemp

			$this->idemp->LinkCustomAttributes = "";
			$this->idemp->HrefValue = "";

			// noemp
			$this->noemp->LinkCustomAttributes = "";
			if (!EmptyValue($this->idemp->CurrentValue)) {
				$this->noemp->HrefValue = "detailpayrolllist.php?showmaster=employee&idemp=" . $this->idemp->CurrentValue; // Add prefix/suffix
				$this->noemp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport())
					$this->noemp->HrefValue = FullUrl($this->noemp->HrefValue, "href");
			} else {
				$this->noemp->HrefValue = "";
			}

			// lastname
			$this->lastname->LinkCustomAttributes = "";
			$this->lastname->HrefValue = "";

			// firstname
			$this->firstname->LinkCustomAttributes = "";
			$this->firstname->HrefValue = "";

			// basicsalary
			$this->basicsalary->LinkCustomAttributes = "";
			$this->basicsalary->HrefValue = "";

			// nifcin
			$this->nifcin->LinkCustomAttributes = "";
			$this->nifcin->HrefValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";

			// civilstatus
			$this->civilstatus->LinkCustomAttributes = "";
			$this->civilstatus->HrefValue = "";

			// depend
			$this->depend->LinkCustomAttributes = "";
			$this->depend->HrefValue = "";

			// datenais
			$this->datenais->LinkCustomAttributes = "";
			$this->datenais->HrefValue = "";

			// lieunais
			$this->lieunais->LinkCustomAttributes = "";
			$this->lieunais->HrefValue = "";

			// adresse
			$this->adresse->LinkCustomAttributes = "";
			$this->adresse->HrefValue = "";

			// phone
			$this->phone->LinkCustomAttributes = "";
			$this->phone->HrefValue = "";

			// reference
			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";

			// refphone
			$this->refphone->LinkCustomAttributes = "";
			$this->refphone->HrefValue = "";

			// urgence
			$this->urgence->LinkCustomAttributes = "";
			$this->urgence->HrefValue = "";

			// urgphone
			$this->urgphone->LinkCustomAttributes = "";
			$this->urgphone->HrefValue = "";

			// joindate
			$this->joindate->LinkCustomAttributes = "";
			$this->joindate->HrefValue = "";

			// leavingdate
			$this->leavingdate->LinkCustomAttributes = "";
			$this->leavingdate->HrefValue = "";

			// leavingmotif
			$this->leavingmotif->LinkCustomAttributes = "";
			$this->leavingmotif->HrefValue = "";

			// idtype
			$this->idtype->LinkCustomAttributes = "";
			$this->idtype->HrefValue = "";

			// idstatus
			$this->idstatus->LinkCustomAttributes = "";
			$this->idstatus->HrefValue = "";

			// idfct
			$this->idfct->LinkCustomAttributes = "";
			$this->idfct->HrefValue = "";

			// idsect
			$this->idsect->LinkCustomAttributes = "";
			$this->idsect->HrefValue = "";

			// iddep
			$this->iddep->LinkCustomAttributes = "";
			$this->iddep->HrefValue = "";

			// iddesig
			$this->iddesig->LinkCustomAttributes = "";
			$this->iddesig->HrefValue = "";

			// qualif
			$this->qualif->LinkCustomAttributes = "";
			$this->qualif->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->idemp->Required) {
			if (!$this->idemp->IsDetailKey && $this->idemp->FormValue != NULL && $this->idemp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idemp->caption(), $this->idemp->RequiredErrorMessage));
			}
		}
		if ($this->noemp->Required) {
			if (!$this->noemp->IsDetailKey && $this->noemp->FormValue != NULL && $this->noemp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->noemp->caption(), $this->noemp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->noemp->FormValue)) {
			AddMessage($FormError, $this->noemp->errorMessage());
		}
		if ($this->lastname->Required) {
			if (!$this->lastname->IsDetailKey && $this->lastname->FormValue != NULL && $this->lastname->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lastname->caption(), $this->lastname->RequiredErrorMessage));
			}
		}
		if ($this->firstname->Required) {
			if (!$this->firstname->IsDetailKey && $this->firstname->FormValue != NULL && $this->firstname->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->firstname->caption(), $this->firstname->RequiredErrorMessage));
			}
		}
		if ($this->basicsalary->Required) {
			if (!$this->basicsalary->IsDetailKey && $this->basicsalary->FormValue != NULL && $this->basicsalary->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->basicsalary->caption(), $this->basicsalary->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->basicsalary->FormValue)) {
			AddMessage($FormError, $this->basicsalary->errorMessage());
		}
		if ($this->nifcin->Required) {
			if (!$this->nifcin->IsDetailKey && $this->nifcin->FormValue != NULL && $this->nifcin->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nifcin->caption(), $this->nifcin->RequiredErrorMessage));
			}
		}
		if ($this->gender->Required) {
			if ($this->gender->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
			}
		}
		if ($this->civilstatus->Required) {
			if ($this->civilstatus->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->civilstatus->caption(), $this->civilstatus->RequiredErrorMessage));
			}
		}
		if ($this->depend->Required) {
			if (!$this->depend->IsDetailKey && $this->depend->FormValue != NULL && $this->depend->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->depend->caption(), $this->depend->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->depend->FormValue)) {
			AddMessage($FormError, $this->depend->errorMessage());
		}
		if ($this->datenais->Required) {
			if (!$this->datenais->IsDetailKey && $this->datenais->FormValue != NULL && $this->datenais->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datenais->caption(), $this->datenais->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->datenais->FormValue)) {
			AddMessage($FormError, $this->datenais->errorMessage());
		}
		if ($this->lieunais->Required) {
			if (!$this->lieunais->IsDetailKey && $this->lieunais->FormValue != NULL && $this->lieunais->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lieunais->caption(), $this->lieunais->RequiredErrorMessage));
			}
		}
		if ($this->adresse->Required) {
			if (!$this->adresse->IsDetailKey && $this->adresse->FormValue != NULL && $this->adresse->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->adresse->caption(), $this->adresse->RequiredErrorMessage));
			}
		}
		if ($this->phone->Required) {
			if (!$this->phone->IsDetailKey && $this->phone->FormValue != NULL && $this->phone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->phone->caption(), $this->phone->RequiredErrorMessage));
			}
		}
		if ($this->reference->Required) {
			if (!$this->reference->IsDetailKey && $this->reference->FormValue != NULL && $this->reference->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reference->caption(), $this->reference->RequiredErrorMessage));
			}
		}
		if ($this->refphone->Required) {
			if (!$this->refphone->IsDetailKey && $this->refphone->FormValue != NULL && $this->refphone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->refphone->caption(), $this->refphone->RequiredErrorMessage));
			}
		}
		if ($this->urgence->Required) {
			if (!$this->urgence->IsDetailKey && $this->urgence->FormValue != NULL && $this->urgence->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->urgence->caption(), $this->urgence->RequiredErrorMessage));
			}
		}
		if ($this->urgphone->Required) {
			if (!$this->urgphone->IsDetailKey && $this->urgphone->FormValue != NULL && $this->urgphone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->urgphone->caption(), $this->urgphone->RequiredErrorMessage));
			}
		}
		if ($this->joindate->Required) {
			if (!$this->joindate->IsDetailKey && $this->joindate->FormValue != NULL && $this->joindate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->joindate->caption(), $this->joindate->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->joindate->FormValue)) {
			AddMessage($FormError, $this->joindate->errorMessage());
		}
		if ($this->leavingdate->Required) {
			if (!$this->leavingdate->IsDetailKey && $this->leavingdate->FormValue != NULL && $this->leavingdate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->leavingdate->caption(), $this->leavingdate->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->leavingdate->FormValue)) {
			AddMessage($FormError, $this->leavingdate->errorMessage());
		}
		if ($this->leavingmotif->Required) {
			if (!$this->leavingmotif->IsDetailKey && $this->leavingmotif->FormValue != NULL && $this->leavingmotif->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->leavingmotif->caption(), $this->leavingmotif->RequiredErrorMessage));
			}
		}
		if ($this->idtype->Required) {
			if (!$this->idtype->IsDetailKey && $this->idtype->FormValue != NULL && $this->idtype->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idtype->caption(), $this->idtype->RequiredErrorMessage));
			}
		}
		if ($this->idstatus->Required) {
			if (!$this->idstatus->IsDetailKey && $this->idstatus->FormValue != NULL && $this->idstatus->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idstatus->caption(), $this->idstatus->RequiredErrorMessage));
			}
		}
		if ($this->idfct->Required) {
			if (!$this->idfct->IsDetailKey && $this->idfct->FormValue != NULL && $this->idfct->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idfct->caption(), $this->idfct->RequiredErrorMessage));
			}
		}
		if ($this->idsect->Required) {
			if (!$this->idsect->IsDetailKey && $this->idsect->FormValue != NULL && $this->idsect->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idsect->caption(), $this->idsect->RequiredErrorMessage));
			}
		}
		if ($this->iddep->Required) {
			if (!$this->iddep->IsDetailKey && $this->iddep->FormValue != NULL && $this->iddep->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->iddep->caption(), $this->iddep->RequiredErrorMessage));
			}
		}
		if ($this->iddesig->Required) {
			if (!$this->iddesig->IsDetailKey && $this->iddesig->FormValue != NULL && $this->iddesig->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->iddesig->caption(), $this->iddesig->RequiredErrorMessage));
			}
		}
		if ($this->qualif->Required) {
			if (!$this->qualif->IsDetailKey && $this->qualif->FormValue != NULL && $this->qualif->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qualif->caption(), $this->qualif->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("policyemp", $detailTblVar) && $GLOBALS["policyemp"]->DetailEdit) {
			if (!isset($GLOBALS["policyemp_grid"]))
				$GLOBALS["policyemp_grid"] = new policyemp_grid(); // Get detail page object
			$GLOBALS["policyemp_grid"]->validateGridForm();
		}
		if (in_array("detailpayroll", $detailTblVar) && $GLOBALS["detailpayroll"]->DetailEdit) {
			if (!isset($GLOBALS["detailpayroll_grid"]))
				$GLOBALS["detailpayroll_grid"] = new detailpayroll_grid(); // Get detail page object
			$GLOBALS["detailpayroll_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		if ($this->noemp->CurrentValue != "") { // Check field with unique index
			$filterChk = "(`noemp` = " . AdjustSql($this->noemp->CurrentValue, $this->Dbid) . ")";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = "";
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->noemp->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->noemp->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Begin transaction
			if ($this->getCurrentDetailTable() != "")
				$conn->beginTrans();

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// noemp
			$this->noemp->setDbValueDef($rsnew, $this->noemp->CurrentValue, 0, $this->noemp->ReadOnly);

			// lastname
			$this->lastname->setDbValueDef($rsnew, $this->lastname->CurrentValue, "", $this->lastname->ReadOnly);

			// firstname
			$this->firstname->setDbValueDef($rsnew, $this->firstname->CurrentValue, NULL, $this->firstname->ReadOnly);

			// basicsalary
			$this->basicsalary->setDbValueDef($rsnew, $this->basicsalary->CurrentValue, 0, $this->basicsalary->ReadOnly);

			// nifcin
			$this->nifcin->setDbValueDef($rsnew, $this->nifcin->CurrentValue, NULL, $this->nifcin->ReadOnly);

			// gender
			$this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, NULL, $this->gender->ReadOnly);

			// civilstatus
			$this->civilstatus->setDbValueDef($rsnew, $this->civilstatus->CurrentValue, NULL, $this->civilstatus->ReadOnly);

			// depend
			$this->depend->setDbValueDef($rsnew, $this->depend->CurrentValue, NULL, $this->depend->ReadOnly);

			// datenais
			$this->datenais->setDbValueDef($rsnew, UnFormatDateTime($this->datenais->CurrentValue, 0), NULL, $this->datenais->ReadOnly);

			// lieunais
			$this->lieunais->setDbValueDef($rsnew, $this->lieunais->CurrentValue, NULL, $this->lieunais->ReadOnly);

			// adresse
			$this->adresse->setDbValueDef($rsnew, $this->adresse->CurrentValue, NULL, $this->adresse->ReadOnly);

			// phone
			$this->phone->setDbValueDef($rsnew, $this->phone->CurrentValue, NULL, $this->phone->ReadOnly);

			// reference
			$this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, NULL, $this->reference->ReadOnly);

			// refphone
			$this->refphone->setDbValueDef($rsnew, $this->refphone->CurrentValue, NULL, $this->refphone->ReadOnly);

			// urgence
			$this->urgence->setDbValueDef($rsnew, $this->urgence->CurrentValue, NULL, $this->urgence->ReadOnly);

			// urgphone
			$this->urgphone->setDbValueDef($rsnew, $this->urgphone->CurrentValue, NULL, $this->urgphone->ReadOnly);

			// joindate
			$this->joindate->setDbValueDef($rsnew, UnFormatDateTime($this->joindate->CurrentValue, 0), NULL, $this->joindate->ReadOnly);

			// leavingdate
			$this->leavingdate->setDbValueDef($rsnew, UnFormatDateTime($this->leavingdate->CurrentValue, 0), NULL, $this->leavingdate->ReadOnly);

			// leavingmotif
			$this->leavingmotif->setDbValueDef($rsnew, $this->leavingmotif->CurrentValue, NULL, $this->leavingmotif->ReadOnly);

			// idtype
			$this->idtype->setDbValueDef($rsnew, $this->idtype->CurrentValue, 0, $this->idtype->ReadOnly);

			// idstatus
			$this->idstatus->setDbValueDef($rsnew, $this->idstatus->CurrentValue, 0, $this->idstatus->ReadOnly);

			// idfct
			$this->idfct->setDbValueDef($rsnew, $this->idfct->CurrentValue, 0, $this->idfct->ReadOnly);

			// idsect
			$this->idsect->setDbValueDef($rsnew, $this->idsect->CurrentValue, 0, $this->idsect->ReadOnly);

			// iddep
			$this->iddep->setDbValueDef($rsnew, $this->iddep->CurrentValue, 0, $this->iddep->ReadOnly);

			// iddesig
			$this->iddesig->setDbValueDef($rsnew, $this->iddesig->CurrentValue, 0, $this->iddesig->ReadOnly);

			// qualif
			$this->qualif->setDbValueDef($rsnew, $this->qualif->CurrentValue, NULL, $this->qualif->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew);
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}

				// Update detail records
				$detailTblVar = explode(",", $this->getCurrentDetailTable());
				if ($editRow) {
					if (in_array("policyemp", $detailTblVar) && $GLOBALS["policyemp"]->DetailEdit) {
						if (!isset($GLOBALS["policyemp_grid"]))
							$GLOBALS["policyemp_grid"] = new policyemp_grid(); // Get detail page object
						$editRow = $GLOBALS["policyemp_grid"]->gridUpdate();
					}
				}
				if ($editRow) {
					if (in_array("detailpayroll", $detailTblVar) && $GLOBALS["detailpayroll"]->DetailEdit) {
						if (!isset($GLOBALS["detailpayroll_grid"]))
							$GLOBALS["detailpayroll_grid"] = new detailpayroll_grid(); // Get detail page object
						$editRow = $GLOBALS["detailpayroll_grid"]->gridUpdate();
					}
				}

				// Commit/Rollback transaction
				if ($this->getCurrentDetailTable() != "") {
					if ($editRow) {
						$conn->commitTrans(); // Commit transaction
					} else {
						$conn->rollbackTrans(); // Rollback transaction
					}
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Clean upload path if any
		if ($editRow) {
		}

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("policyemp", $detailTblVar)) {
				if (!isset($GLOBALS["policyemp_grid"]))
					$GLOBALS["policyemp_grid"] = new policyemp_grid();
				if ($GLOBALS["policyemp_grid"]->DetailEdit) {
					$GLOBALS["policyemp_grid"]->CurrentMode = "edit";
					$GLOBALS["policyemp_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["policyemp_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["policyemp_grid"]->setStartRecordNumber(1);
					$GLOBALS["policyemp_grid"]->idemp->IsDetailKey = TRUE;
					$GLOBALS["policyemp_grid"]->idemp->CurrentValue = $this->idemp->CurrentValue;
					$GLOBALS["policyemp_grid"]->idemp->setSessionValue($GLOBALS["policyemp_grid"]->idemp->CurrentValue);
				}
			}
			if (in_array("detailpayroll", $detailTblVar)) {
				if (!isset($GLOBALS["detailpayroll_grid"]))
					$GLOBALS["detailpayroll_grid"] = new detailpayroll_grid();
				if ($GLOBALS["detailpayroll_grid"]->DetailEdit) {
					$GLOBALS["detailpayroll_grid"]->CurrentMode = "edit";
					$GLOBALS["detailpayroll_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["detailpayroll_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["detailpayroll_grid"]->setStartRecordNumber(1);
					$GLOBALS["detailpayroll_grid"]->idemp->IsDetailKey = TRUE;
					$GLOBALS["detailpayroll_grid"]->idemp->CurrentValue = $this->idemp->CurrentValue;
					$GLOBALS["detailpayroll_grid"]->idemp->setSessionValue($GLOBALS["detailpayroll_grid"]->idemp->CurrentValue);
					$GLOBALS["detailpayroll_grid"]->idpayroll->setSessionValue(""); // Clear session key
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("employeelist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_gender":
					break;
				case "x_civilstatus":
					break;
				case "x_idtype":
					break;
				case "x_idstatus":
					break;
				case "x_idfct":
					break;
				case "x_idsect":
					break;
				case "x_iddep":
					break;
				case "x_iddesig":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_idtype":
							break;
						case "x_idstatus":
							break;
						case "x_idfct":
							break;
						case "x_idsect":
							break;
						case "x_iddep":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_iddesig":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>