<?php
namespace PHPMaker2020\intextdesign_proj_v0;

/**
 * Page class
 */
class employee_delete extends employee
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{D5394950-A905-4BDF-B7DA-D47F92A453D8}";

	// Table name
	public $TableName = 'employee';

	// Page object name
	public $PageObjName = "employee_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (employee)
		if (!isset($GLOBALS["employee"]) || get_class($GLOBALS["employee"]) == PROJECT_NAMESPACE . "employee") {
			$GLOBALS["employee"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["employee"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'employee');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $employee;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($employee);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['idemp'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->idemp->Visible = FALSE;
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $TotalRecords = 0;
	public $RecordCount;
	public $RecKeys = [];
	public $StartRowCount = 1;
	public $RowCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canDelete()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("employeelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->idemp->Visible = FALSE;
		$this->noemp->setVisibility();
		$this->lastname->setVisibility();
		$this->firstname->setVisibility();
		$this->basicsalary->setVisibility();
		$this->nifcin->Visible = FALSE;
		$this->gender->Visible = FALSE;
		$this->civilstatus->Visible = FALSE;
		$this->depend->Visible = FALSE;
		$this->datenais->Visible = FALSE;
		$this->lieunais->Visible = FALSE;
		$this->adresse->Visible = FALSE;
		$this->phone->Visible = FALSE;
		$this->reference->Visible = FALSE;
		$this->refphone->Visible = FALSE;
		$this->urgence->Visible = FALSE;
		$this->urgphone->Visible = FALSE;
		$this->joindate->setVisibility();
		$this->leavingdate->Visible = FALSE;
		$this->leavingmotif->Visible = FALSE;
		$this->idtype->setVisibility();
		$this->idstatus->setVisibility();
		$this->idfct->Visible = FALSE;
		$this->idsect->Visible = FALSE;
		$this->iddep->setVisibility();
		$this->iddesig->Visible = FALSE;
		$this->qualif->Visible = FALSE;
		$this->listpolicy->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->idtype);
		$this->setupLookupOptions($this->idstatus);
		$this->setupLookupOptions($this->idfct);
		$this->setupLookupOptions($this->idsect);
		$this->setupLookupOptions($this->iddep);
		$this->setupLookupOptions($this->iddesig);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("employeelist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecords <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("employeelist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->idemp->setDbValue($row['idemp']);
		$this->noemp->setDbValue($row['noemp']);
		$this->lastname->setDbValue($row['lastname']);
		$this->firstname->setDbValue($row['firstname']);
		$this->basicsalary->setDbValue($row['basicsalary']);
		$this->nifcin->setDbValue($row['nifcin']);
		$this->gender->setDbValue($row['gender']);
		$this->civilstatus->setDbValue($row['civilstatus']);
		$this->depend->setDbValue($row['depend']);
		$this->datenais->setDbValue($row['datenais']);
		$this->lieunais->setDbValue($row['lieunais']);
		$this->adresse->setDbValue($row['adresse']);
		$this->phone->setDbValue($row['phone']);
		$this->reference->setDbValue($row['reference']);
		$this->refphone->setDbValue($row['refphone']);
		$this->urgence->setDbValue($row['urgence']);
		$this->urgphone->setDbValue($row['urgphone']);
		$this->joindate->setDbValue($row['joindate']);
		$this->leavingdate->setDbValue($row['leavingdate']);
		$this->leavingmotif->setDbValue($row['leavingmotif']);
		$this->idtype->setDbValue($row['idtype']);
		$this->idstatus->setDbValue($row['idstatus']);
		$this->idfct->setDbValue($row['idfct']);
		$this->idsect->setDbValue($row['idsect']);
		$this->iddep->setDbValue($row['iddep']);
		$this->iddesig->setDbValue($row['iddesig']);
		$this->qualif->setDbValue($row['qualif']);
		$this->listpolicy->setDbValue($row['listpolicy']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['idemp'] = NULL;
		$row['noemp'] = NULL;
		$row['lastname'] = NULL;
		$row['firstname'] = NULL;
		$row['basicsalary'] = NULL;
		$row['nifcin'] = NULL;
		$row['gender'] = NULL;
		$row['civilstatus'] = NULL;
		$row['depend'] = NULL;
		$row['datenais'] = NULL;
		$row['lieunais'] = NULL;
		$row['adresse'] = NULL;
		$row['phone'] = NULL;
		$row['reference'] = NULL;
		$row['refphone'] = NULL;
		$row['urgence'] = NULL;
		$row['urgphone'] = NULL;
		$row['joindate'] = NULL;
		$row['leavingdate'] = NULL;
		$row['leavingmotif'] = NULL;
		$row['idtype'] = NULL;
		$row['idstatus'] = NULL;
		$row['idfct'] = NULL;
		$row['idsect'] = NULL;
		$row['iddep'] = NULL;
		$row['iddesig'] = NULL;
		$row['qualif'] = NULL;
		$row['listpolicy'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->basicsalary->FormValue == $this->basicsalary->CurrentValue && is_numeric(ConvertToFloatString($this->basicsalary->CurrentValue)))
			$this->basicsalary->CurrentValue = ConvertToFloatString($this->basicsalary->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// idemp
		// noemp
		// lastname
		// firstname
		// basicsalary
		// nifcin
		// gender
		// civilstatus
		// depend
		// datenais
		// lieunais
		// adresse
		// phone
		// reference
		// refphone
		// urgence
		// urgphone
		// joindate
		// leavingdate
		// leavingmotif
		// idtype
		// idstatus
		// idfct
		// idsect
		// iddep
		// iddesig
		// qualif
		// listpolicy

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// idemp
			$this->idemp->ViewValue = $this->idemp->CurrentValue;
			$this->idemp->ViewCustomAttributes = "";

			// noemp
			$this->noemp->ViewValue = $this->noemp->CurrentValue;
			$this->noemp->ViewValue = FormatNumber($this->noemp->ViewValue, 0, -2, -2, -2);
			$this->noemp->ViewCustomAttributes = "";

			// lastname
			$this->lastname->ViewValue = $this->lastname->CurrentValue;
			$this->lastname->ViewCustomAttributes = "";

			// firstname
			$this->firstname->ViewValue = $this->firstname->CurrentValue;
			$this->firstname->ViewCustomAttributes = "";

			// basicsalary
			$this->basicsalary->ViewValue = $this->basicsalary->CurrentValue;
			$this->basicsalary->ViewValue = FormatNumber($this->basicsalary->ViewValue, 2, -2, -2, -2);
			$this->basicsalary->ViewCustomAttributes = "";

			// nifcin
			$this->nifcin->ViewValue = $this->nifcin->CurrentValue;
			$this->nifcin->ViewCustomAttributes = "";

			// gender
			if (strval($this->gender->CurrentValue) != "") {
				$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
			} else {
				$this->gender->ViewValue = NULL;
			}
			$this->gender->ViewCustomAttributes = "";

			// civilstatus
			if (strval($this->civilstatus->CurrentValue) != "") {
				$this->civilstatus->ViewValue = $this->civilstatus->optionCaption($this->civilstatus->CurrentValue);
			} else {
				$this->civilstatus->ViewValue = NULL;
			}
			$this->civilstatus->ViewCustomAttributes = "";

			// depend
			$this->depend->ViewValue = $this->depend->CurrentValue;
			$this->depend->ViewValue = FormatNumber($this->depend->ViewValue, 0, -2, -2, -2);
			$this->depend->ViewCustomAttributes = "";

			// datenais
			$this->datenais->ViewValue = $this->datenais->CurrentValue;
			$this->datenais->ViewValue = FormatDateTime($this->datenais->ViewValue, 0);
			$this->datenais->ViewCustomAttributes = "";

			// lieunais
			$this->lieunais->ViewValue = $this->lieunais->CurrentValue;
			$this->lieunais->ViewCustomAttributes = "";

			// adresse
			$this->adresse->ViewValue = $this->adresse->CurrentValue;
			$this->adresse->ViewCustomAttributes = "";

			// phone
			$this->phone->ViewValue = $this->phone->CurrentValue;
			$this->phone->ViewCustomAttributes = "";

			// reference
			$this->reference->ViewValue = $this->reference->CurrentValue;
			$this->reference->ViewCustomAttributes = "";

			// refphone
			$this->refphone->ViewValue = $this->refphone->CurrentValue;
			$this->refphone->ViewCustomAttributes = "";

			// urgence
			$this->urgence->ViewValue = $this->urgence->CurrentValue;
			$this->urgence->ViewCustomAttributes = "";

			// urgphone
			$this->urgphone->ViewValue = $this->urgphone->CurrentValue;
			$this->urgphone->ViewCustomAttributes = "";

			// joindate
			$this->joindate->ViewValue = $this->joindate->CurrentValue;
			$this->joindate->ViewValue = FormatDateTime($this->joindate->ViewValue, 0);
			$this->joindate->ViewCustomAttributes = "";

			// leavingdate
			$this->leavingdate->ViewValue = $this->leavingdate->CurrentValue;
			$this->leavingdate->ViewValue = FormatDateTime($this->leavingdate->ViewValue, 0);
			$this->leavingdate->ViewCustomAttributes = "";

			// leavingmotif
			$this->leavingmotif->ViewValue = $this->leavingmotif->CurrentValue;
			$this->leavingmotif->ViewCustomAttributes = "";

			// idtype
			$curVal = strval($this->idtype->CurrentValue);
			if ($curVal != "") {
				$this->idtype->ViewValue = $this->idtype->lookupCacheOption($curVal);
				if ($this->idtype->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idtype`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idtype->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->idtype->ViewValue = $this->idtype->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idtype->ViewValue = $this->idtype->CurrentValue;
					}
				}
			} else {
				$this->idtype->ViewValue = NULL;
			}
			$this->idtype->ViewCustomAttributes = "";

			// idstatus
			$curVal = strval($this->idstatus->CurrentValue);
			if ($curVal != "") {
				$this->idstatus->ViewValue = $this->idstatus->lookupCacheOption($curVal);
				if ($this->idstatus->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idstatus`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idstatus->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->idstatus->ViewValue = $this->idstatus->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idstatus->ViewValue = $this->idstatus->CurrentValue;
					}
				}
			} else {
				$this->idstatus->ViewValue = NULL;
			}
			$this->idstatus->ViewCustomAttributes = "";

			// idfct
			$curVal = strval($this->idfct->CurrentValue);
			if ($curVal != "") {
				$this->idfct->ViewValue = $this->idfct->lookupCacheOption($curVal);
				if ($this->idfct->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idfct`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idfct->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->idfct->ViewValue = $this->idfct->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idfct->ViewValue = $this->idfct->CurrentValue;
					}
				}
			} else {
				$this->idfct->ViewValue = NULL;
			}
			$this->idfct->ViewCustomAttributes = "";

			// idsect
			$curVal = strval($this->idsect->CurrentValue);
			if ($curVal != "") {
				$this->idsect->ViewValue = $this->idsect->lookupCacheOption($curVal);
				if ($this->idsect->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idsect`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idsect->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->idsect->ViewValue = $this->idsect->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idsect->ViewValue = $this->idsect->CurrentValue;
					}
				}
			} else {
				$this->idsect->ViewValue = NULL;
			}
			$this->idsect->ViewCustomAttributes = "";

			// iddep
			$curVal = strval($this->iddep->CurrentValue);
			if ($curVal != "") {
				$this->iddep->ViewValue = $this->iddep->lookupCacheOption($curVal);
				if ($this->iddep->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`iddep`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->iddep->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->iddep->ViewValue = $this->iddep->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->iddep->ViewValue = $this->iddep->CurrentValue;
					}
				}
			} else {
				$this->iddep->ViewValue = NULL;
			}
			$this->iddep->ViewCustomAttributes = "";

			// iddesig
			$curVal = strval($this->iddesig->CurrentValue);
			if ($curVal != "") {
				$this->iddesig->ViewValue = $this->iddesig->lookupCacheOption($curVal);
				if ($this->iddesig->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`iddesig`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->iddesig->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->iddesig->ViewValue = $this->iddesig->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->iddesig->ViewValue = $this->iddesig->CurrentValue;
					}
				}
			} else {
				$this->iddesig->ViewValue = NULL;
			}
			$this->iddesig->ViewCustomAttributes = "";

			// qualif
			$this->qualif->ViewValue = $this->qualif->CurrentValue;
			$this->qualif->ViewCustomAttributes = "";

			// listpolicy
			$this->listpolicy->ViewValue = $this->listpolicy->CurrentValue;
			$this->listpolicy->ViewCustomAttributes = "";

			// noemp
			$this->noemp->LinkCustomAttributes = "";
			if (!EmptyValue($this->idemp->CurrentValue)) {
				$this->noemp->HrefValue = "detailpayrolllist.php?showmaster=employee&idemp=" . $this->idemp->CurrentValue; // Add prefix/suffix
				$this->noemp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport())
					$this->noemp->HrefValue = FullUrl($this->noemp->HrefValue, "href");
			} else {
				$this->noemp->HrefValue = "";
			}
			$this->noemp->TooltipValue = "";

			// lastname
			$this->lastname->LinkCustomAttributes = "";
			$this->lastname->HrefValue = "";
			$this->lastname->TooltipValue = "";

			// firstname
			$this->firstname->LinkCustomAttributes = "";
			$this->firstname->HrefValue = "";
			$this->firstname->TooltipValue = "";

			// basicsalary
			$this->basicsalary->LinkCustomAttributes = "";
			$this->basicsalary->HrefValue = "";
			$this->basicsalary->TooltipValue = "";

			// joindate
			$this->joindate->LinkCustomAttributes = "";
			$this->joindate->HrefValue = "";
			$this->joindate->TooltipValue = "";

			// idtype
			$this->idtype->LinkCustomAttributes = "";
			$this->idtype->HrefValue = "";
			$this->idtype->TooltipValue = "";

			// idstatus
			$this->idstatus->LinkCustomAttributes = "";
			$this->idstatus->HrefValue = "";
			$this->idstatus->TooltipValue = "";

			// iddep
			$this->iddep->LinkCustomAttributes = "";
			$this->iddep->HrefValue = "";
			$this->iddep->TooltipValue = "";

			// listpolicy
			$this->listpolicy->LinkCustomAttributes = "";
			$this->listpolicy->HrefValue = "";
			$this->listpolicy->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['idemp'];
				if (Config("DELETE_UPLOADED_FILES")) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = "";
				if ($deleteRows === FALSE)
					break;
				if ($key != "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("employeelist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_gender":
					break;
				case "x_civilstatus":
					break;
				case "x_idtype":
					break;
				case "x_idstatus":
					break;
				case "x_idfct":
					break;
				case "x_idsect":
					break;
				case "x_iddep":
					break;
				case "x_iddesig":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_idtype":
							break;
						case "x_idstatus":
							break;
						case "x_idfct":
							break;
						case "x_idsect":
							break;
						case "x_iddep":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_iddesig":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
} // End class
?>