<?php namespace PHPMaker2020\intextdesign_proj_v0; ?>
<?php

/**
 * Table class for employee
 */
class employee extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $idemp;
	public $noemp;
	public $lastname;
	public $firstname;
	public $basicsalary;
	public $nifcin;
	public $gender;
	public $civilstatus;
	public $depend;
	public $datenais;
	public $lieunais;
	public $adresse;
	public $phone;
	public $reference;
	public $refphone;
	public $urgence;
	public $urgphone;
	public $joindate;
	public $leavingdate;
	public $leavingmotif;
	public $idtype;
	public $idstatus;
	public $idfct;
	public $idsect;
	public $iddep;
	public $iddesig;
	public $qualif;
	public $listpolicy;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'employee';
		$this->TableName = 'employee';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`employee`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// idemp
		$this->idemp = new DbField('employee', 'employee', 'x_idemp', 'idemp', '`idemp`', '`idemp`', 3, 11, -1, FALSE, '`idemp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->idemp->IsAutoIncrement = TRUE; // Autoincrement field
		$this->idemp->IsPrimaryKey = TRUE; // Primary key field
		$this->idemp->IsForeignKey = TRUE; // Foreign key field
		$this->idemp->Sortable = TRUE; // Allow sort
		$this->idemp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idemp'] = &$this->idemp;

		// noemp
		$this->noemp = new DbField('employee', 'employee', 'x_noemp', 'noemp', '`noemp`', '`noemp`', 3, 11, -1, FALSE, '`noemp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->noemp->Nullable = FALSE; // NOT NULL field
		$this->noemp->Required = TRUE; // Required field
		$this->noemp->Sortable = TRUE; // Allow sort
		$this->noemp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['noemp'] = &$this->noemp;

		// lastname
		$this->lastname = new DbField('employee', 'employee', 'x_lastname', 'lastname', '`lastname`', '`lastname`', 200, 150, -1, FALSE, '`lastname`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lastname->Nullable = FALSE; // NOT NULL field
		$this->lastname->Required = TRUE; // Required field
		$this->lastname->Sortable = TRUE; // Allow sort
		$this->fields['lastname'] = &$this->lastname;

		// firstname
		$this->firstname = new DbField('employee', 'employee', 'x_firstname', 'firstname', '`firstname`', '`firstname`', 200, 150, -1, FALSE, '`firstname`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->firstname->Sortable = TRUE; // Allow sort
		$this->fields['firstname'] = &$this->firstname;

		// basicsalary
		$this->basicsalary = new DbField('employee', 'employee', 'x_basicsalary', 'basicsalary', '`basicsalary`', '`basicsalary`', 131, 12, -1, FALSE, '`basicsalary`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->basicsalary->Nullable = FALSE; // NOT NULL field
		$this->basicsalary->Required = TRUE; // Required field
		$this->basicsalary->Sortable = TRUE; // Allow sort
		$this->basicsalary->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['basicsalary'] = &$this->basicsalary;

		// nifcin
		$this->nifcin = new DbField('employee', 'employee', 'x_nifcin', 'nifcin', '`nifcin`', '`nifcin`', 200, 200, -1, FALSE, '`nifcin`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nifcin->Sortable = TRUE; // Allow sort
		$this->fields['nifcin'] = &$this->nifcin;

		// gender
		$this->gender = new DbField('employee', 'employee', 'x_gender', 'gender', '`gender`', '`gender`', 202, 1, -1, FALSE, '`gender`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->gender->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "en":
				$this->gender->Lookup = new Lookup('gender', 'employee', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->gender->Lookup = new Lookup('gender', 'employee', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->gender->OptionCount = 2;
		$this->fields['gender'] = &$this->gender;

		// civilstatus
		$this->civilstatus = new DbField('employee', 'employee', 'x_civilstatus', 'civilstatus', '`civilstatus`', '`civilstatus`', 202, 1, -1, FALSE, '`civilstatus`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->civilstatus->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "en":
				$this->civilstatus->Lookup = new Lookup('civilstatus', 'employee', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->civilstatus->Lookup = new Lookup('civilstatus', 'employee', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->civilstatus->OptionCount = 3;
		$this->fields['civilstatus'] = &$this->civilstatus;

		// depend
		$this->depend = new DbField('employee', 'employee', 'x_depend', 'depend', '`depend`', '`depend`', 3, 11, -1, FALSE, '`depend`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->depend->Sortable = TRUE; // Allow sort
		$this->depend->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['depend'] = &$this->depend;

		// datenais
		$this->datenais = new DbField('employee', 'employee', 'x_datenais', 'datenais', '`datenais`', CastDateFieldForLike("`datenais`", 0, "DB"), 133, 10, 0, FALSE, '`datenais`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datenais->Sortable = TRUE; // Allow sort
		$this->datenais->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datenais'] = &$this->datenais;

		// lieunais
		$this->lieunais = new DbField('employee', 'employee', 'x_lieunais', 'lieunais', '`lieunais`', '`lieunais`', 200, 150, -1, FALSE, '`lieunais`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lieunais->Sortable = TRUE; // Allow sort
		$this->fields['lieunais'] = &$this->lieunais;

		// adresse
		$this->adresse = new DbField('employee', 'employee', 'x_adresse', 'adresse', '`adresse`', '`adresse`', 200, 200, -1, FALSE, '`adresse`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->adresse->Sortable = TRUE; // Allow sort
		$this->fields['adresse'] = &$this->adresse;

		// phone
		$this->phone = new DbField('employee', 'employee', 'x_phone', 'phone', '`phone`', '`phone`', 200, 50, -1, FALSE, '`phone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->phone->Sortable = TRUE; // Allow sort
		$this->fields['phone'] = &$this->phone;

		// reference
		$this->reference = new DbField('employee', 'employee', 'x_reference', 'reference', '`reference`', '`reference`', 200, 150, -1, FALSE, '`reference`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reference->Sortable = TRUE; // Allow sort
		$this->fields['reference'] = &$this->reference;

		// refphone
		$this->refphone = new DbField('employee', 'employee', 'x_refphone', 'refphone', '`refphone`', '`refphone`', 200, 50, -1, FALSE, '`refphone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->refphone->Sortable = TRUE; // Allow sort
		$this->fields['refphone'] = &$this->refphone;

		// urgence
		$this->urgence = new DbField('employee', 'employee', 'x_urgence', 'urgence', '`urgence`', '`urgence`', 200, 50, -1, FALSE, '`urgence`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->urgence->Sortable = TRUE; // Allow sort
		$this->fields['urgence'] = &$this->urgence;

		// urgphone
		$this->urgphone = new DbField('employee', 'employee', 'x_urgphone', 'urgphone', '`urgphone`', '`urgphone`', 200, 50, -1, FALSE, '`urgphone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->urgphone->Sortable = TRUE; // Allow sort
		$this->fields['urgphone'] = &$this->urgphone;

		// joindate
		$this->joindate = new DbField('employee', 'employee', 'x_joindate', 'joindate', '`joindate`', CastDateFieldForLike("`joindate`", 0, "DB"), 133, 10, 0, FALSE, '`joindate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->joindate->Required = TRUE; // Required field
		$this->joindate->Sortable = TRUE; // Allow sort
		$this->joindate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['joindate'] = &$this->joindate;

		// leavingdate
		$this->leavingdate = new DbField('employee', 'employee', 'x_leavingdate', 'leavingdate', '`leavingdate`', CastDateFieldForLike("`leavingdate`", 0, "DB"), 133, 10, 0, FALSE, '`leavingdate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->leavingdate->Sortable = TRUE; // Allow sort
		$this->leavingdate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['leavingdate'] = &$this->leavingdate;

		// leavingmotif
		$this->leavingmotif = new DbField('employee', 'employee', 'x_leavingmotif', 'leavingmotif', '`leavingmotif`', '`leavingmotif`', 200, 200, -1, FALSE, '`leavingmotif`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->leavingmotif->Sortable = TRUE; // Allow sort
		$this->fields['leavingmotif'] = &$this->leavingmotif;

		// idtype
		$this->idtype = new DbField('employee', 'employee', 'x_idtype', 'idtype', '`idtype`', '`idtype`', 3, 11, -1, FALSE, '`idtype`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->idtype->Nullable = FALSE; // NOT NULL field
		$this->idtype->Required = TRUE; // Required field
		$this->idtype->Sortable = TRUE; // Allow sort
		$this->idtype->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->idtype->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->idtype->Lookup = new Lookup('idtype', 'type', FALSE, 'idtype', ["ident","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->idtype->Lookup = new Lookup('idtype', 'type', FALSE, 'idtype', ["ident","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->idtype->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idtype'] = &$this->idtype;

		// idstatus
		$this->idstatus = new DbField('employee', 'employee', 'x_idstatus', 'idstatus', '`idstatus`', '`idstatus`', 3, 11, -1, FALSE, '`idstatus`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->idstatus->Nullable = FALSE; // NOT NULL field
		$this->idstatus->Required = TRUE; // Required field
		$this->idstatus->Sortable = TRUE; // Allow sort
		$this->idstatus->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->idstatus->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->idstatus->Lookup = new Lookup('idstatus', 'status', FALSE, 'idstatus', ["descrip","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->idstatus->Lookup = new Lookup('idstatus', 'status', FALSE, 'idstatus', ["descrip","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->idstatus->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idstatus'] = &$this->idstatus;

		// idfct
		$this->idfct = new DbField('employee', 'employee', 'x_idfct', 'idfct', '`idfct`', '`idfct`', 3, 11, -1, FALSE, '`idfct`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->idfct->Nullable = FALSE; // NOT NULL field
		$this->idfct->Required = TRUE; // Required field
		$this->idfct->Sortable = TRUE; // Allow sort
		$this->idfct->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->idfct->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->idfct->Lookup = new Lookup('idfct', 'fonction', FALSE, 'idfct', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->idfct->Lookup = new Lookup('idfct', 'fonction', FALSE, 'idfct', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->idfct->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idfct'] = &$this->idfct;

		// idsect
		$this->idsect = new DbField('employee', 'employee', 'x_idsect', 'idsect', '`idsect`', '`idsect`', 3, 11, -1, FALSE, '`idsect`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->idsect->Nullable = FALSE; // NOT NULL field
		$this->idsect->Required = TRUE; // Required field
		$this->idsect->Sortable = TRUE; // Allow sort
		$this->idsect->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->idsect->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->idsect->Lookup = new Lookup('idsect', 'section', FALSE, 'idsect', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->idsect->Lookup = new Lookup('idsect', 'section', FALSE, 'idsect', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->idsect->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idsect'] = &$this->idsect;

		// iddep
		$this->iddep = new DbField('employee', 'employee', 'x_iddep', 'iddep', '`iddep`', '`iddep`', 3, 11, -1, FALSE, '`iddep`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->iddep->Nullable = FALSE; // NOT NULL field
		$this->iddep->Required = TRUE; // Required field
		$this->iddep->Sortable = TRUE; // Allow sort
		$this->iddep->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->iddep->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->iddep->Lookup = new Lookup('iddep', 'deptement', FALSE, 'iddep', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->iddep->Lookup = new Lookup('iddep', 'deptement', FALSE, 'iddep', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->iddep->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['iddep'] = &$this->iddep;

		// iddesig
		$this->iddesig = new DbField('employee', 'employee', 'x_iddesig', 'iddesig', '`iddesig`', '`iddesig`', 3, 11, -1, FALSE, '`iddesig`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->iddesig->Nullable = FALSE; // NOT NULL field
		$this->iddesig->Required = TRUE; // Required field
		$this->iddesig->Sortable = TRUE; // Allow sort
		$this->iddesig->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->iddesig->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->iddesig->Lookup = new Lookup('iddesig', 'designation', FALSE, 'iddesig', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->iddesig->Lookup = new Lookup('iddesig', 'designation', FALSE, 'iddesig', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->iddesig->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['iddesig'] = &$this->iddesig;

		// qualif
		$this->qualif = new DbField('employee', 'employee', 'x_qualif', 'qualif', '`qualif`', '`qualif`', 200, 200, -1, FALSE, '`qualif`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qualif->Sortable = TRUE; // Allow sort
		$this->fields['qualif'] = &$this->qualif;

		// listpolicy
		$this->listpolicy = new DbField('employee', 'employee', 'x_listpolicy', 'listpolicy', '\'\'', '\'\'', 201, 65530, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->listpolicy->IsCustom = TRUE; // Custom field
		$this->listpolicy->Sortable = TRUE; // Allow sort
		$this->fields['listpolicy'] = &$this->listpolicy;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "policyemp") {
			$detailUrl = $GLOBALS["policyemp"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_idemp=" . urlencode($this->idemp->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "detailpayroll") {
			$detailUrl = $GLOBALS["detailpayroll"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_idemp=" . urlencode($this->idemp->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "employeelist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`employee`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT *, '' AS `listpolicy` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->idemp->setDbValue($conn->insert_ID());
			$rs['idemp'] = $this->idemp->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();

		// Cascade Update detail table 'policyemp'
		$cascadeUpdate = FALSE;
		$rscascade = [];
		if ($rsold && (isset($rs['idemp']) && $rsold['idemp'] != $rs['idemp'])) { // Update detail field 'idemp'
			$cascadeUpdate = TRUE;
			$rscascade['idemp'] = $rs['idemp'];
		}
		if ($cascadeUpdate) {
			if (!isset($GLOBALS["policyemp"]))
				$GLOBALS["policyemp"] = new policyemp();
			$rswrk = $GLOBALS["policyemp"]->loadRs("`idemp` = " . QuotedValue($rsold['idemp'], DATATYPE_NUMBER, 'DB'));
			while ($rswrk && !$rswrk->EOF) {
				$rskey = [];
				$fldname = 'idpe';
				$rskey[$fldname] = $rswrk->fields[$fldname];
				$rsdtlold = &$rswrk->fields;
				$rsdtlnew = array_merge($rsdtlold, $rscascade);

				// Call Row_Updating event
				$success = $GLOBALS["policyemp"]->Row_Updating($rsdtlold, $rsdtlnew);
				if ($success)
					$success = $GLOBALS["policyemp"]->update($rscascade, $rskey, $rswrk->fields);
				if (!$success)
					return FALSE;

				// Call Row_Updated event
				$GLOBALS["policyemp"]->Row_Updated($rsdtlold, $rsdtlnew);
				$rswrk->moveNext();
			}
		}
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('idemp', $rs))
				AddFilter($where, QuotedName('idemp', $this->Dbid) . '=' . QuotedValue($rs['idemp'], $this->idemp->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();

		// Cascade delete detail table 'policyemp'
		if (!isset($GLOBALS["policyemp"]))
			$GLOBALS["policyemp"] = new policyemp();
		$rscascade = $GLOBALS["policyemp"]->loadRs("`idemp` = " . QuotedValue($rs['idemp'], DATATYPE_NUMBER, "DB"));
		$dtlrows = ($rscascade) ? $rscascade->getRows() : [];

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["policyemp"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["policyemp"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["policyemp"]->Row_Deleted($dtlrow);
		}
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->idemp->DbValue = $row['idemp'];
		$this->noemp->DbValue = $row['noemp'];
		$this->lastname->DbValue = $row['lastname'];
		$this->firstname->DbValue = $row['firstname'];
		$this->basicsalary->DbValue = $row['basicsalary'];
		$this->nifcin->DbValue = $row['nifcin'];
		$this->gender->DbValue = $row['gender'];
		$this->civilstatus->DbValue = $row['civilstatus'];
		$this->depend->DbValue = $row['depend'];
		$this->datenais->DbValue = $row['datenais'];
		$this->lieunais->DbValue = $row['lieunais'];
		$this->adresse->DbValue = $row['adresse'];
		$this->phone->DbValue = $row['phone'];
		$this->reference->DbValue = $row['reference'];
		$this->refphone->DbValue = $row['refphone'];
		$this->urgence->DbValue = $row['urgence'];
		$this->urgphone->DbValue = $row['urgphone'];
		$this->joindate->DbValue = $row['joindate'];
		$this->leavingdate->DbValue = $row['leavingdate'];
		$this->leavingmotif->DbValue = $row['leavingmotif'];
		$this->idtype->DbValue = $row['idtype'];
		$this->idstatus->DbValue = $row['idstatus'];
		$this->idfct->DbValue = $row['idfct'];
		$this->idsect->DbValue = $row['idsect'];
		$this->iddep->DbValue = $row['iddep'];
		$this->iddesig->DbValue = $row['iddesig'];
		$this->qualif->DbValue = $row['qualif'];
		$this->listpolicy->DbValue = $row['listpolicy'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`idemp` = @idemp@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('idemp', $row) ? $row['idemp'] : NULL;
		else
			$val = $this->idemp->OldValue !== NULL ? $this->idemp->OldValue : $this->idemp->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@idemp@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "employeelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "employeeview.php")
			return $Language->phrase("View");
		elseif ($pageName == "employeeedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "employeeadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "employeelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("employeeview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("employeeview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "employeeadd.php?" . $this->getUrlParm($parm);
		else
			$url = "employeeadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("employeeedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("employeeedit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("employeeadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("employeeadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("employeedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "idemp:" . JsonEncode($this->idemp->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->idemp->CurrentValue != NULL) {
			$url .= "idemp=" . urlencode($this->idemp->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("idemp") !== NULL)
				$arKeys[] = Param("idemp");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->idemp->CurrentValue = $key;
			else
				$this->idemp->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->idemp->setDbValue($rs->fields('idemp'));
		$this->noemp->setDbValue($rs->fields('noemp'));
		$this->lastname->setDbValue($rs->fields('lastname'));
		$this->firstname->setDbValue($rs->fields('firstname'));
		$this->basicsalary->setDbValue($rs->fields('basicsalary'));
		$this->nifcin->setDbValue($rs->fields('nifcin'));
		$this->gender->setDbValue($rs->fields('gender'));
		$this->civilstatus->setDbValue($rs->fields('civilstatus'));
		$this->depend->setDbValue($rs->fields('depend'));
		$this->datenais->setDbValue($rs->fields('datenais'));
		$this->lieunais->setDbValue($rs->fields('lieunais'));
		$this->adresse->setDbValue($rs->fields('adresse'));
		$this->phone->setDbValue($rs->fields('phone'));
		$this->reference->setDbValue($rs->fields('reference'));
		$this->refphone->setDbValue($rs->fields('refphone'));
		$this->urgence->setDbValue($rs->fields('urgence'));
		$this->urgphone->setDbValue($rs->fields('urgphone'));
		$this->joindate->setDbValue($rs->fields('joindate'));
		$this->leavingdate->setDbValue($rs->fields('leavingdate'));
		$this->leavingmotif->setDbValue($rs->fields('leavingmotif'));
		$this->idtype->setDbValue($rs->fields('idtype'));
		$this->idstatus->setDbValue($rs->fields('idstatus'));
		$this->idfct->setDbValue($rs->fields('idfct'));
		$this->idsect->setDbValue($rs->fields('idsect'));
		$this->iddep->setDbValue($rs->fields('iddep'));
		$this->iddesig->setDbValue($rs->fields('iddesig'));
		$this->qualif->setDbValue($rs->fields('qualif'));
		$this->listpolicy->setDbValue($rs->fields('listpolicy'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// idemp
		// noemp
		// lastname
		// firstname
		// basicsalary
		// nifcin
		// gender
		// civilstatus
		// depend
		// datenais
		// lieunais
		// adresse
		// phone
		// reference
		// refphone
		// urgence
		// urgphone
		// joindate
		// leavingdate
		// leavingmotif
		// idtype
		// idstatus
		// idfct
		// idsect
		// iddep
		// iddesig
		// qualif
		// listpolicy
		// idemp

		$this->idemp->ViewValue = $this->idemp->CurrentValue;
		$this->idemp->ViewCustomAttributes = "";

		// noemp
		$this->noemp->ViewValue = $this->noemp->CurrentValue;
		$this->noemp->ViewValue = FormatNumber($this->noemp->ViewValue, 0, -2, -2, -2);
		$this->noemp->ViewCustomAttributes = "";

		// lastname
		$this->lastname->ViewValue = $this->lastname->CurrentValue;
		$this->lastname->ViewCustomAttributes = "";

		// firstname
		$this->firstname->ViewValue = $this->firstname->CurrentValue;
		$this->firstname->ViewCustomAttributes = "";

		// basicsalary
		$this->basicsalary->ViewValue = $this->basicsalary->CurrentValue;
		$this->basicsalary->ViewValue = FormatNumber($this->basicsalary->ViewValue, 2, -2, -2, -2);
		$this->basicsalary->ViewCustomAttributes = "";

		// nifcin
		$this->nifcin->ViewValue = $this->nifcin->CurrentValue;
		$this->nifcin->ViewCustomAttributes = "";

		// gender
		if (strval($this->gender->CurrentValue) != "") {
			$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
		} else {
			$this->gender->ViewValue = NULL;
		}
		$this->gender->ViewCustomAttributes = "";

		// civilstatus
		if (strval($this->civilstatus->CurrentValue) != "") {
			$this->civilstatus->ViewValue = $this->civilstatus->optionCaption($this->civilstatus->CurrentValue);
		} else {
			$this->civilstatus->ViewValue = NULL;
		}
		$this->civilstatus->ViewCustomAttributes = "";

		// depend
		$this->depend->ViewValue = $this->depend->CurrentValue;
		$this->depend->ViewValue = FormatNumber($this->depend->ViewValue, 0, -2, -2, -2);
		$this->depend->ViewCustomAttributes = "";

		// datenais
		$this->datenais->ViewValue = $this->datenais->CurrentValue;
		$this->datenais->ViewValue = FormatDateTime($this->datenais->ViewValue, 0);
		$this->datenais->ViewCustomAttributes = "";

		// lieunais
		$this->lieunais->ViewValue = $this->lieunais->CurrentValue;
		$this->lieunais->ViewCustomAttributes = "";

		// adresse
		$this->adresse->ViewValue = $this->adresse->CurrentValue;
		$this->adresse->ViewCustomAttributes = "";

		// phone
		$this->phone->ViewValue = $this->phone->CurrentValue;
		$this->phone->ViewCustomAttributes = "";

		// reference
		$this->reference->ViewValue = $this->reference->CurrentValue;
		$this->reference->ViewCustomAttributes = "";

		// refphone
		$this->refphone->ViewValue = $this->refphone->CurrentValue;
		$this->refphone->ViewCustomAttributes = "";

		// urgence
		$this->urgence->ViewValue = $this->urgence->CurrentValue;
		$this->urgence->ViewCustomAttributes = "";

		// urgphone
		$this->urgphone->ViewValue = $this->urgphone->CurrentValue;
		$this->urgphone->ViewCustomAttributes = "";

		// joindate
		$this->joindate->ViewValue = $this->joindate->CurrentValue;
		$this->joindate->ViewValue = FormatDateTime($this->joindate->ViewValue, 0);
		$this->joindate->ViewCustomAttributes = "";

		// leavingdate
		$this->leavingdate->ViewValue = $this->leavingdate->CurrentValue;
		$this->leavingdate->ViewValue = FormatDateTime($this->leavingdate->ViewValue, 0);
		$this->leavingdate->ViewCustomAttributes = "";

		// leavingmotif
		$this->leavingmotif->ViewValue = $this->leavingmotif->CurrentValue;
		$this->leavingmotif->ViewCustomAttributes = "";

		// idtype
		$curVal = strval($this->idtype->CurrentValue);
		if ($curVal != "") {
			$this->idtype->ViewValue = $this->idtype->lookupCacheOption($curVal);
			if ($this->idtype->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`idtype`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->idtype->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->idtype->ViewValue = $this->idtype->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->idtype->ViewValue = $this->idtype->CurrentValue;
				}
			}
		} else {
			$this->idtype->ViewValue = NULL;
		}
		$this->idtype->ViewCustomAttributes = "";

		// idstatus
		$curVal = strval($this->idstatus->CurrentValue);
		if ($curVal != "") {
			$this->idstatus->ViewValue = $this->idstatus->lookupCacheOption($curVal);
			if ($this->idstatus->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`idstatus`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->idstatus->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->idstatus->ViewValue = $this->idstatus->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->idstatus->ViewValue = $this->idstatus->CurrentValue;
				}
			}
		} else {
			$this->idstatus->ViewValue = NULL;
		}
		$this->idstatus->ViewCustomAttributes = "";

		// idfct
		$curVal = strval($this->idfct->CurrentValue);
		if ($curVal != "") {
			$this->idfct->ViewValue = $this->idfct->lookupCacheOption($curVal);
			if ($this->idfct->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`idfct`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->idfct->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->idfct->ViewValue = $this->idfct->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->idfct->ViewValue = $this->idfct->CurrentValue;
				}
			}
		} else {
			$this->idfct->ViewValue = NULL;
		}
		$this->idfct->ViewCustomAttributes = "";

		// idsect
		$curVal = strval($this->idsect->CurrentValue);
		if ($curVal != "") {
			$this->idsect->ViewValue = $this->idsect->lookupCacheOption($curVal);
			if ($this->idsect->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`idsect`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->idsect->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->idsect->ViewValue = $this->idsect->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->idsect->ViewValue = $this->idsect->CurrentValue;
				}
			}
		} else {
			$this->idsect->ViewValue = NULL;
		}
		$this->idsect->ViewCustomAttributes = "";

		// iddep
		$curVal = strval($this->iddep->CurrentValue);
		if ($curVal != "") {
			$this->iddep->ViewValue = $this->iddep->lookupCacheOption($curVal);
			if ($this->iddep->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`iddep`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->iddep->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->iddep->ViewValue = $this->iddep->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->iddep->ViewValue = $this->iddep->CurrentValue;
				}
			}
		} else {
			$this->iddep->ViewValue = NULL;
		}
		$this->iddep->ViewCustomAttributes = "";

		// iddesig
		$curVal = strval($this->iddesig->CurrentValue);
		if ($curVal != "") {
			$this->iddesig->ViewValue = $this->iddesig->lookupCacheOption($curVal);
			if ($this->iddesig->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`iddesig`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->iddesig->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->iddesig->ViewValue = $this->iddesig->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->iddesig->ViewValue = $this->iddesig->CurrentValue;
				}
			}
		} else {
			$this->iddesig->ViewValue = NULL;
		}
		$this->iddesig->ViewCustomAttributes = "";

		// qualif
		$this->qualif->ViewValue = $this->qualif->CurrentValue;
		$this->qualif->ViewCustomAttributes = "";

		// listpolicy
		$this->listpolicy->ViewValue = $this->listpolicy->CurrentValue;
		$this->listpolicy->ViewCustomAttributes = "";

		// idemp
		$this->idemp->LinkCustomAttributes = "";
		$this->idemp->HrefValue = "";
		$this->idemp->TooltipValue = "";

		// noemp
		$this->noemp->LinkCustomAttributes = "";
		if (!EmptyValue($this->idemp->CurrentValue)) {
			$this->noemp->HrefValue = "detailpayrolllist.php?showmaster=employee&idemp=" . $this->idemp->CurrentValue; // Add prefix/suffix
			$this->noemp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport())
				$this->noemp->HrefValue = FullUrl($this->noemp->HrefValue, "href");
		} else {
			$this->noemp->HrefValue = "";
		}
		$this->noemp->TooltipValue = "";

		// lastname
		$this->lastname->LinkCustomAttributes = "";
		$this->lastname->HrefValue = "";
		$this->lastname->TooltipValue = "";

		// firstname
		$this->firstname->LinkCustomAttributes = "";
		$this->firstname->HrefValue = "";
		$this->firstname->TooltipValue = "";

		// basicsalary
		$this->basicsalary->LinkCustomAttributes = "";
		$this->basicsalary->HrefValue = "";
		$this->basicsalary->TooltipValue = "";

		// nifcin
		$this->nifcin->LinkCustomAttributes = "";
		$this->nifcin->HrefValue = "";
		$this->nifcin->TooltipValue = "";

		// gender
		$this->gender->LinkCustomAttributes = "";
		$this->gender->HrefValue = "";
		$this->gender->TooltipValue = "";

		// civilstatus
		$this->civilstatus->LinkCustomAttributes = "";
		$this->civilstatus->HrefValue = "";
		$this->civilstatus->TooltipValue = "";

		// depend
		$this->depend->LinkCustomAttributes = "";
		$this->depend->HrefValue = "";
		$this->depend->TooltipValue = "";

		// datenais
		$this->datenais->LinkCustomAttributes = "";
		$this->datenais->HrefValue = "";
		$this->datenais->TooltipValue = "";

		// lieunais
		$this->lieunais->LinkCustomAttributes = "";
		$this->lieunais->HrefValue = "";
		$this->lieunais->TooltipValue = "";

		// adresse
		$this->adresse->LinkCustomAttributes = "";
		$this->adresse->HrefValue = "";
		$this->adresse->TooltipValue = "";

		// phone
		$this->phone->LinkCustomAttributes = "";
		$this->phone->HrefValue = "";
		$this->phone->TooltipValue = "";

		// reference
		$this->reference->LinkCustomAttributes = "";
		$this->reference->HrefValue = "";
		$this->reference->TooltipValue = "";

		// refphone
		$this->refphone->LinkCustomAttributes = "";
		$this->refphone->HrefValue = "";
		$this->refphone->TooltipValue = "";

		// urgence
		$this->urgence->LinkCustomAttributes = "";
		$this->urgence->HrefValue = "";
		$this->urgence->TooltipValue = "";

		// urgphone
		$this->urgphone->LinkCustomAttributes = "";
		$this->urgphone->HrefValue = "";
		$this->urgphone->TooltipValue = "";

		// joindate
		$this->joindate->LinkCustomAttributes = "";
		$this->joindate->HrefValue = "";
		$this->joindate->TooltipValue = "";

		// leavingdate
		$this->leavingdate->LinkCustomAttributes = "";
		$this->leavingdate->HrefValue = "";
		$this->leavingdate->TooltipValue = "";

		// leavingmotif
		$this->leavingmotif->LinkCustomAttributes = "";
		$this->leavingmotif->HrefValue = "";
		$this->leavingmotif->TooltipValue = "";

		// idtype
		$this->idtype->LinkCustomAttributes = "";
		$this->idtype->HrefValue = "";
		$this->idtype->TooltipValue = "";

		// idstatus
		$this->idstatus->LinkCustomAttributes = "";
		$this->idstatus->HrefValue = "";
		$this->idstatus->TooltipValue = "";

		// idfct
		$this->idfct->LinkCustomAttributes = "";
		$this->idfct->HrefValue = "";
		$this->idfct->TooltipValue = "";

		// idsect
		$this->idsect->LinkCustomAttributes = "";
		$this->idsect->HrefValue = "";
		$this->idsect->TooltipValue = "";

		// iddep
		$this->iddep->LinkCustomAttributes = "";
		$this->iddep->HrefValue = "";
		$this->iddep->TooltipValue = "";

		// iddesig
		$this->iddesig->LinkCustomAttributes = "";
		$this->iddesig->HrefValue = "";
		$this->iddesig->TooltipValue = "";

		// qualif
		$this->qualif->LinkCustomAttributes = "";
		$this->qualif->HrefValue = "";
		$this->qualif->TooltipValue = "";

		// listpolicy
		$this->listpolicy->LinkCustomAttributes = "";
		$this->listpolicy->HrefValue = "";
		$this->listpolicy->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// idemp
		$this->idemp->EditAttrs["class"] = "form-control";
		$this->idemp->EditCustomAttributes = "";
		$this->idemp->EditValue = $this->idemp->CurrentValue;
		$this->idemp->ViewCustomAttributes = "";

		// noemp
		$this->noemp->EditAttrs["class"] = "form-control";
		$this->noemp->EditCustomAttributes = "";
		$this->noemp->EditValue = $this->noemp->CurrentValue;
		$this->noemp->PlaceHolder = RemoveHtml($this->noemp->caption());

		// lastname
		$this->lastname->EditAttrs["class"] = "form-control";
		$this->lastname->EditCustomAttributes = "";
		if (!$this->lastname->Raw)
			$this->lastname->CurrentValue = HtmlDecode($this->lastname->CurrentValue);
		$this->lastname->EditValue = $this->lastname->CurrentValue;
		$this->lastname->PlaceHolder = RemoveHtml($this->lastname->caption());

		// firstname
		$this->firstname->EditAttrs["class"] = "form-control";
		$this->firstname->EditCustomAttributes = "";
		if (!$this->firstname->Raw)
			$this->firstname->CurrentValue = HtmlDecode($this->firstname->CurrentValue);
		$this->firstname->EditValue = $this->firstname->CurrentValue;
		$this->firstname->PlaceHolder = RemoveHtml($this->firstname->caption());

		// basicsalary
		$this->basicsalary->EditAttrs["class"] = "form-control";
		$this->basicsalary->EditCustomAttributes = "";
		$this->basicsalary->EditValue = $this->basicsalary->CurrentValue;
		$this->basicsalary->PlaceHolder = RemoveHtml($this->basicsalary->caption());
		if (strval($this->basicsalary->EditValue) != "" && is_numeric($this->basicsalary->EditValue))
			$this->basicsalary->EditValue = FormatNumber($this->basicsalary->EditValue, -2, -2, -2, -2);
		

		// nifcin
		$this->nifcin->EditAttrs["class"] = "form-control";
		$this->nifcin->EditCustomAttributes = "";
		if (!$this->nifcin->Raw)
			$this->nifcin->CurrentValue = HtmlDecode($this->nifcin->CurrentValue);
		$this->nifcin->EditValue = $this->nifcin->CurrentValue;
		$this->nifcin->PlaceHolder = RemoveHtml($this->nifcin->caption());

		// gender
		$this->gender->EditCustomAttributes = "";
		$this->gender->EditValue = $this->gender->options(FALSE);

		// civilstatus
		$this->civilstatus->EditCustomAttributes = "";
		$this->civilstatus->EditValue = $this->civilstatus->options(FALSE);

		// depend
		$this->depend->EditAttrs["class"] = "form-control";
		$this->depend->EditCustomAttributes = "";
		$this->depend->EditValue = $this->depend->CurrentValue;
		$this->depend->PlaceHolder = RemoveHtml($this->depend->caption());

		// datenais
		$this->datenais->EditAttrs["class"] = "form-control";
		$this->datenais->EditCustomAttributes = "";
		$this->datenais->EditValue = FormatDateTime($this->datenais->CurrentValue, 8);
		$this->datenais->PlaceHolder = RemoveHtml($this->datenais->caption());

		// lieunais
		$this->lieunais->EditAttrs["class"] = "form-control";
		$this->lieunais->EditCustomAttributes = "";
		if (!$this->lieunais->Raw)
			$this->lieunais->CurrentValue = HtmlDecode($this->lieunais->CurrentValue);
		$this->lieunais->EditValue = $this->lieunais->CurrentValue;
		$this->lieunais->PlaceHolder = RemoveHtml($this->lieunais->caption());

		// adresse
		$this->adresse->EditAttrs["class"] = "form-control";
		$this->adresse->EditCustomAttributes = "";
		if (!$this->adresse->Raw)
			$this->adresse->CurrentValue = HtmlDecode($this->adresse->CurrentValue);
		$this->adresse->EditValue = $this->adresse->CurrentValue;
		$this->adresse->PlaceHolder = RemoveHtml($this->adresse->caption());

		// phone
		$this->phone->EditAttrs["class"] = "form-control";
		$this->phone->EditCustomAttributes = "";
		if (!$this->phone->Raw)
			$this->phone->CurrentValue = HtmlDecode($this->phone->CurrentValue);
		$this->phone->EditValue = $this->phone->CurrentValue;
		$this->phone->PlaceHolder = RemoveHtml($this->phone->caption());

		// reference
		$this->reference->EditAttrs["class"] = "form-control";
		$this->reference->EditCustomAttributes = "";
		if (!$this->reference->Raw)
			$this->reference->CurrentValue = HtmlDecode($this->reference->CurrentValue);
		$this->reference->EditValue = $this->reference->CurrentValue;
		$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

		// refphone
		$this->refphone->EditAttrs["class"] = "form-control";
		$this->refphone->EditCustomAttributes = "";
		if (!$this->refphone->Raw)
			$this->refphone->CurrentValue = HtmlDecode($this->refphone->CurrentValue);
		$this->refphone->EditValue = $this->refphone->CurrentValue;
		$this->refphone->PlaceHolder = RemoveHtml($this->refphone->caption());

		// urgence
		$this->urgence->EditAttrs["class"] = "form-control";
		$this->urgence->EditCustomAttributes = "";
		if (!$this->urgence->Raw)
			$this->urgence->CurrentValue = HtmlDecode($this->urgence->CurrentValue);
		$this->urgence->EditValue = $this->urgence->CurrentValue;
		$this->urgence->PlaceHolder = RemoveHtml($this->urgence->caption());

		// urgphone
		$this->urgphone->EditAttrs["class"] = "form-control";
		$this->urgphone->EditCustomAttributes = "";
		if (!$this->urgphone->Raw)
			$this->urgphone->CurrentValue = HtmlDecode($this->urgphone->CurrentValue);
		$this->urgphone->EditValue = $this->urgphone->CurrentValue;
		$this->urgphone->PlaceHolder = RemoveHtml($this->urgphone->caption());

		// joindate
		$this->joindate->EditAttrs["class"] = "form-control";
		$this->joindate->EditCustomAttributes = "";
		$this->joindate->EditValue = FormatDateTime($this->joindate->CurrentValue, 8);
		$this->joindate->PlaceHolder = RemoveHtml($this->joindate->caption());

		// leavingdate
		$this->leavingdate->EditAttrs["class"] = "form-control";
		$this->leavingdate->EditCustomAttributes = "";
		$this->leavingdate->EditValue = FormatDateTime($this->leavingdate->CurrentValue, 8);
		$this->leavingdate->PlaceHolder = RemoveHtml($this->leavingdate->caption());

		// leavingmotif
		$this->leavingmotif->EditAttrs["class"] = "form-control";
		$this->leavingmotif->EditCustomAttributes = "";
		if (!$this->leavingmotif->Raw)
			$this->leavingmotif->CurrentValue = HtmlDecode($this->leavingmotif->CurrentValue);
		$this->leavingmotif->EditValue = $this->leavingmotif->CurrentValue;
		$this->leavingmotif->PlaceHolder = RemoveHtml($this->leavingmotif->caption());

		// idtype
		$this->idtype->EditAttrs["class"] = "form-control";
		$this->idtype->EditCustomAttributes = "";

		// idstatus
		$this->idstatus->EditAttrs["class"] = "form-control";
		$this->idstatus->EditCustomAttributes = "";

		// idfct
		$this->idfct->EditAttrs["class"] = "form-control";
		$this->idfct->EditCustomAttributes = "";

		// idsect
		$this->idsect->EditAttrs["class"] = "form-control";
		$this->idsect->EditCustomAttributes = "";

		// iddep
		$this->iddep->EditAttrs["class"] = "form-control";
		$this->iddep->EditCustomAttributes = "";

		// iddesig
		$this->iddesig->EditAttrs["class"] = "form-control";
		$this->iddesig->EditCustomAttributes = "";

		// qualif
		$this->qualif->EditAttrs["class"] = "form-control";
		$this->qualif->EditCustomAttributes = "";
		if (!$this->qualif->Raw)
			$this->qualif->CurrentValue = HtmlDecode($this->qualif->CurrentValue);
		$this->qualif->EditValue = $this->qualif->CurrentValue;
		$this->qualif->PlaceHolder = RemoveHtml($this->qualif->caption());

		// listpolicy
		$this->listpolicy->EditAttrs["class"] = "form-control";
		$this->listpolicy->EditCustomAttributes = "";
		$this->listpolicy->EditValue = $this->listpolicy->CurrentValue;
		$this->listpolicy->PlaceHolder = RemoveHtml($this->listpolicy->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->idemp);
					$doc->exportCaption($this->noemp);
					$doc->exportCaption($this->lastname);
					$doc->exportCaption($this->firstname);
					$doc->exportCaption($this->basicsalary);
					$doc->exportCaption($this->nifcin);
					$doc->exportCaption($this->gender);
					$doc->exportCaption($this->civilstatus);
					$doc->exportCaption($this->depend);
					$doc->exportCaption($this->datenais);
					$doc->exportCaption($this->lieunais);
					$doc->exportCaption($this->adresse);
					$doc->exportCaption($this->phone);
					$doc->exportCaption($this->reference);
					$doc->exportCaption($this->refphone);
					$doc->exportCaption($this->urgence);
					$doc->exportCaption($this->urgphone);
					$doc->exportCaption($this->joindate);
					$doc->exportCaption($this->leavingdate);
					$doc->exportCaption($this->leavingmotif);
					$doc->exportCaption($this->idtype);
					$doc->exportCaption($this->idstatus);
					$doc->exportCaption($this->idfct);
					$doc->exportCaption($this->idsect);
					$doc->exportCaption($this->iddep);
					$doc->exportCaption($this->iddesig);
					$doc->exportCaption($this->qualif);
					$doc->exportCaption($this->listpolicy);
				} else {
					$doc->exportCaption($this->idemp);
					$doc->exportCaption($this->noemp);
					$doc->exportCaption($this->lastname);
					$doc->exportCaption($this->firstname);
					$doc->exportCaption($this->basicsalary);
					$doc->exportCaption($this->nifcin);
					$doc->exportCaption($this->gender);
					$doc->exportCaption($this->civilstatus);
					$doc->exportCaption($this->depend);
					$doc->exportCaption($this->datenais);
					$doc->exportCaption($this->lieunais);
					$doc->exportCaption($this->adresse);
					$doc->exportCaption($this->phone);
					$doc->exportCaption($this->reference);
					$doc->exportCaption($this->refphone);
					$doc->exportCaption($this->urgence);
					$doc->exportCaption($this->urgphone);
					$doc->exportCaption($this->joindate);
					$doc->exportCaption($this->leavingdate);
					$doc->exportCaption($this->leavingmotif);
					$doc->exportCaption($this->idtype);
					$doc->exportCaption($this->idstatus);
					$doc->exportCaption($this->idfct);
					$doc->exportCaption($this->idsect);
					$doc->exportCaption($this->iddep);
					$doc->exportCaption($this->iddesig);
					$doc->exportCaption($this->qualif);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->idemp);
						$doc->exportField($this->noemp);
						$doc->exportField($this->lastname);
						$doc->exportField($this->firstname);
						$doc->exportField($this->basicsalary);
						$doc->exportField($this->nifcin);
						$doc->exportField($this->gender);
						$doc->exportField($this->civilstatus);
						$doc->exportField($this->depend);
						$doc->exportField($this->datenais);
						$doc->exportField($this->lieunais);
						$doc->exportField($this->adresse);
						$doc->exportField($this->phone);
						$doc->exportField($this->reference);
						$doc->exportField($this->refphone);
						$doc->exportField($this->urgence);
						$doc->exportField($this->urgphone);
						$doc->exportField($this->joindate);
						$doc->exportField($this->leavingdate);
						$doc->exportField($this->leavingmotif);
						$doc->exportField($this->idtype);
						$doc->exportField($this->idstatus);
						$doc->exportField($this->idfct);
						$doc->exportField($this->idsect);
						$doc->exportField($this->iddep);
						$doc->exportField($this->iddesig);
						$doc->exportField($this->qualif);
						$doc->exportField($this->listpolicy);
					} else {
						$doc->exportField($this->idemp);
						$doc->exportField($this->noemp);
						$doc->exportField($this->lastname);
						$doc->exportField($this->firstname);
						$doc->exportField($this->basicsalary);
						$doc->exportField($this->nifcin);
						$doc->exportField($this->gender);
						$doc->exportField($this->civilstatus);
						$doc->exportField($this->depend);
						$doc->exportField($this->datenais);
						$doc->exportField($this->lieunais);
						$doc->exportField($this->adresse);
						$doc->exportField($this->phone);
						$doc->exportField($this->reference);
						$doc->exportField($this->refphone);
						$doc->exportField($this->urgence);
						$doc->exportField($this->urgphone);
						$doc->exportField($this->joindate);
						$doc->exportField($this->leavingdate);
						$doc->exportField($this->leavingmotif);
						$doc->exportField($this->idtype);
						$doc->exportField($this->idstatus);
						$doc->exportField($this->idfct);
						$doc->exportField($this->idsect);
						$doc->exportField($this->iddep);
						$doc->exportField($this->iddesig);
						$doc->exportField($this->qualif);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	if($this->idemp->CurrentValue!=""){// METTRE CONDITION POUR DIRE IF ROWS
		$sql="SELECT titlepo,amountpo,per,typepo,ifnull(peramountpo,0)
			from policyemp
			where policyemp.idemp=".$this->idemp->CurrentValue ;

	//echo $sql;
		$rows = ExecuteRows($sql);
		foreach($rows as $x => $val)
		{
			$info= '<span class="text-info">'.$val[0].'</span>';
			if($val[3]==1) $info.= '<small class="text-success"> ('.$val[1].')</small><br>';
			else $info.=  '<small class="text-danger"> ('.$val[1].')</small><br>';
			$this->listpolicy->CurrentValue.= $info;
		}
	}
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>