<?php
namespace PHPMaker2020\intextdesign_proj_v0;

/**
 * Page class
 */
class detailpayroll_add extends detailpayroll
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{D5394950-A905-4BDF-B7DA-D47F92A453D8}";

	// Table name
	public $TableName = 'detailpayroll';

	// Page object name
	public $PageObjName = "detailpayroll_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (detailpayroll)
		if (!isset($GLOBALS["detailpayroll"]) || get_class($GLOBALS["detailpayroll"]) == PROJECT_NAMESPACE . "detailpayroll") {
			$GLOBALS["detailpayroll"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["detailpayroll"];
		}

		// Table object (employee)
		if (!isset($GLOBALS['employee']))
			$GLOBALS['employee'] = new employee();

		// Table object (payroll)
		if (!isset($GLOBALS['payroll']))
			$GLOBALS['payroll'] = new payroll();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'detailpayroll');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $detailpayroll;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($detailpayroll);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "detailpayrollview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['iddp'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->iddp->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("detailpayrolllist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->iddp->Visible = FALSE;
		$this->idpayroll->setVisibility();
		$this->idemp->setVisibility();
		$this->salaryp->setVisibility();
		$this->mtap->Visible = FALSE;
		$this->mtdp->Visible = FALSE;
		$this->netpay->Visible = FALSE;
		$this->listpolicy->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->idpayroll);
		$this->setupLookupOptions($this->idemp);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("iddp") !== NULL) {
				$this->iddp->setQueryStringValue(Get("iddp"));
				$this->setKey("iddp", $this->iddp->CurrentValue); // Set up key
			} else {
				$this->setKey("iddp", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Set up detail parameters
		$this->setupDetailParms();

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("detailpayrolllist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					if ($this->getCurrentDetailTable() != "") // Master/detail add
						$returnUrl = $this->getDetailUrl();
					else
						$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "detailpayrolllist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "detailpayrollview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->iddp->CurrentValue = NULL;
		$this->iddp->OldValue = $this->iddp->CurrentValue;
		$this->idpayroll->CurrentValue = NULL;
		$this->idpayroll->OldValue = $this->idpayroll->CurrentValue;
		$this->idemp->CurrentValue = NULL;
		$this->idemp->OldValue = $this->idemp->CurrentValue;
		$this->salaryp->CurrentValue = NULL;
		$this->salaryp->OldValue = $this->salaryp->CurrentValue;
		$this->mtap->CurrentValue = NULL;
		$this->mtap->OldValue = $this->mtap->CurrentValue;
		$this->mtdp->CurrentValue = NULL;
		$this->mtdp->OldValue = $this->mtdp->CurrentValue;
		$this->netpay->CurrentValue = NULL;
		$this->netpay->OldValue = $this->netpay->CurrentValue;
		$this->listpolicy->CurrentValue = NULL;
		$this->listpolicy->OldValue = $this->listpolicy->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'idpayroll' first before field var 'x_idpayroll'
		$val = $CurrentForm->hasValue("idpayroll") ? $CurrentForm->getValue("idpayroll") : $CurrentForm->getValue("x_idpayroll");
		if (!$this->idpayroll->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->idpayroll->Visible = FALSE; // Disable update for API request
			else
				$this->idpayroll->setFormValue($val);
		}

		// Check field name 'idemp' first before field var 'x_idemp'
		$val = $CurrentForm->hasValue("idemp") ? $CurrentForm->getValue("idemp") : $CurrentForm->getValue("x_idemp");
		if (!$this->idemp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->idemp->Visible = FALSE; // Disable update for API request
			else
				$this->idemp->setFormValue($val);
		}

		// Check field name 'salaryp' first before field var 'x_salaryp'
		$val = $CurrentForm->hasValue("salaryp") ? $CurrentForm->getValue("salaryp") : $CurrentForm->getValue("x_salaryp");
		if (!$this->salaryp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->salaryp->Visible = FALSE; // Disable update for API request
			else
				$this->salaryp->setFormValue($val);
		}

		// Check field name 'iddp' first before field var 'x_iddp'
		$val = $CurrentForm->hasValue("iddp") ? $CurrentForm->getValue("iddp") : $CurrentForm->getValue("x_iddp");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->idpayroll->CurrentValue = $this->idpayroll->FormValue;
		$this->idemp->CurrentValue = $this->idemp->FormValue;
		$this->salaryp->CurrentValue = $this->salaryp->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->iddp->setDbValue($row['iddp']);
		$this->idpayroll->setDbValue($row['idpayroll']);
		$this->idemp->setDbValue($row['idemp']);
		$this->salaryp->setDbValue($row['salaryp']);
		$this->mtap->setDbValue($row['mtap']);
		$this->mtdp->setDbValue($row['mtdp']);
		$this->netpay->setDbValue($row['netpay']);
		$this->listpolicy->setDbValue($row['listpolicy']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['iddp'] = $this->iddp->CurrentValue;
		$row['idpayroll'] = $this->idpayroll->CurrentValue;
		$row['idemp'] = $this->idemp->CurrentValue;
		$row['salaryp'] = $this->salaryp->CurrentValue;
		$row['mtap'] = $this->mtap->CurrentValue;
		$row['mtdp'] = $this->mtdp->CurrentValue;
		$row['netpay'] = $this->netpay->CurrentValue;
		$row['listpolicy'] = $this->listpolicy->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("iddp")) != "")
			$this->iddp->OldValue = $this->getKey("iddp"); // iddp
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->salaryp->FormValue == $this->salaryp->CurrentValue && is_numeric(ConvertToFloatString($this->salaryp->CurrentValue)))
			$this->salaryp->CurrentValue = ConvertToFloatString($this->salaryp->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// iddp
		// idpayroll
		// idemp
		// salaryp
		// mtap
		// mtdp
		// netpay
		// listpolicy

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// iddp
			$this->iddp->ViewValue = $this->iddp->CurrentValue;
			$this->iddp->ViewCustomAttributes = "";

			// idpayroll
			$curVal = strval($this->idpayroll->CurrentValue);
			if ($curVal != "") {
				$this->idpayroll->ViewValue = $this->idpayroll->lookupCacheOption($curVal);
				if ($this->idpayroll->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idpayroll`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idpayroll->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatDateTime($rswrk->fields('df2'), 0);
						$arwrk[3] = FormatDateTime($rswrk->fields('df3'), 0);
						$arwrk[4] = $rswrk->fields('df4');
						$this->idpayroll->ViewValue = $this->idpayroll->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idpayroll->ViewValue = $this->idpayroll->CurrentValue;
					}
				}
			} else {
				$this->idpayroll->ViewValue = NULL;
			}
			$this->idpayroll->ViewCustomAttributes = "";

			// idemp
			$curVal = strval($this->idemp->CurrentValue);
			if ($curVal != "") {
				$this->idemp->ViewValue = $this->idemp->lookupCacheOption($curVal);
				if ($this->idemp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idemp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idemp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->idemp->ViewValue = $this->idemp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idemp->ViewValue = $this->idemp->CurrentValue;
					}
				}
			} else {
				$this->idemp->ViewValue = NULL;
			}
			$this->idemp->ViewCustomAttributes = "";

			// salaryp
			$this->salaryp->ViewValue = $this->salaryp->CurrentValue;
			$this->salaryp->ViewValue = FormatNumber($this->salaryp->ViewValue, 2, -2, -2, -2);
			$this->salaryp->ViewCustomAttributes = "";

			// mtap
			$this->mtap->ViewValue = $this->mtap->CurrentValue;
			$this->mtap->ViewValue = FormatNumber($this->mtap->ViewValue, 2, -2, -2, -2);
			$this->mtap->ViewCustomAttributes = "";

			// mtdp
			$this->mtdp->ViewValue = $this->mtdp->CurrentValue;
			$this->mtdp->ViewValue = FormatNumber($this->mtdp->ViewValue, 2, -2, -2, -2);
			$this->mtdp->ViewCustomAttributes = "";

			// netpay
			$this->netpay->ViewValue = $this->netpay->CurrentValue;
			$this->netpay->ViewValue = FormatNumber($this->netpay->ViewValue, 2, -2, -2, -2);
			$this->netpay->ViewCustomAttributes = "";

			// idpayroll
			$this->idpayroll->LinkCustomAttributes = "";
			$this->idpayroll->HrefValue = "";
			$this->idpayroll->TooltipValue = "";

			// idemp
			$this->idemp->LinkCustomAttributes = "";
			$this->idemp->HrefValue = "";
			$this->idemp->TooltipValue = "";

			// salaryp
			$this->salaryp->LinkCustomAttributes = "";
			$this->salaryp->HrefValue = "";
			$this->salaryp->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// idpayroll
			$this->idpayroll->EditAttrs["class"] = "form-control";
			$this->idpayroll->EditCustomAttributes = "";
			if ($this->idpayroll->getSessionValue() != "") {
				$this->idpayroll->CurrentValue = $this->idpayroll->getSessionValue();
				$curVal = strval($this->idpayroll->CurrentValue);
				if ($curVal != "") {
					$this->idpayroll->ViewValue = $this->idpayroll->lookupCacheOption($curVal);
					if ($this->idpayroll->ViewValue === NULL) { // Lookup from database
						$filterWrk = "`idpayroll`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
						$sqlWrk = $this->idpayroll->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatDateTime($rswrk->fields('df2'), 0);
							$arwrk[3] = FormatDateTime($rswrk->fields('df3'), 0);
							$arwrk[4] = $rswrk->fields('df4');
							$this->idpayroll->ViewValue = $this->idpayroll->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->idpayroll->ViewValue = $this->idpayroll->CurrentValue;
						}
					}
				} else {
					$this->idpayroll->ViewValue = NULL;
				}
				$this->idpayroll->ViewCustomAttributes = "";
			} else {
				$curVal = trim(strval($this->idpayroll->CurrentValue));
				if ($curVal != "")
					$this->idpayroll->ViewValue = $this->idpayroll->lookupCacheOption($curVal);
				else
					$this->idpayroll->ViewValue = $this->idpayroll->Lookup !== NULL && is_array($this->idpayroll->Lookup->Options) ? $curVal : NULL;
				if ($this->idpayroll->ViewValue !== NULL) { // Load from cache
					$this->idpayroll->EditValue = array_values($this->idpayroll->Lookup->Options);
				} else { // Lookup from database
					if ($curVal == "") {
						$filterWrk = "0=1";
					} else {
						$filterWrk = "`idpayroll`" . SearchString("=", $this->idpayroll->CurrentValue, DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->idpayroll->Lookup->getSql(TRUE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					$arwrk = $rswrk ? $rswrk->getRows() : [];
					if ($rswrk)
						$rswrk->close();
					$rowcnt = count($arwrk);
					for ($i = 0; $i < $rowcnt; $i++) {
						$arwrk[$i][2] = FormatDateTime($arwrk[$i][2], 0);
						$arwrk[$i][3] = FormatDateTime($arwrk[$i][3], 0);
					}
					$this->idpayroll->EditValue = $arwrk;
				}
			}

			// idemp
			$this->idemp->EditAttrs["class"] = "form-control";
			$this->idemp->EditCustomAttributes = "";
			if ($this->idemp->getSessionValue() != "") {
				$this->idemp->CurrentValue = $this->idemp->getSessionValue();
				$curVal = strval($this->idemp->CurrentValue);
				if ($curVal != "") {
					$this->idemp->ViewValue = $this->idemp->lookupCacheOption($curVal);
					if ($this->idemp->ViewValue === NULL) { // Lookup from database
						$filterWrk = "`idemp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
						$sqlWrk = $this->idemp->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = $rswrk->fields('df3');
							$this->idemp->ViewValue = $this->idemp->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->idemp->ViewValue = $this->idemp->CurrentValue;
						}
					}
				} else {
					$this->idemp->ViewValue = NULL;
				}
				$this->idemp->ViewCustomAttributes = "";
			} else {
				$curVal = trim(strval($this->idemp->CurrentValue));
				if ($curVal != "")
					$this->idemp->ViewValue = $this->idemp->lookupCacheOption($curVal);
				else
					$this->idemp->ViewValue = $this->idemp->Lookup !== NULL && is_array($this->idemp->Lookup->Options) ? $curVal : NULL;
				if ($this->idemp->ViewValue !== NULL) { // Load from cache
					$this->idemp->EditValue = array_values($this->idemp->Lookup->Options);
				} else { // Lookup from database
					if ($curVal == "") {
						$filterWrk = "0=1";
					} else {
						$filterWrk = "`idemp`" . SearchString("=", $this->idemp->CurrentValue, DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->idemp->Lookup->getSql(TRUE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					$arwrk = $rswrk ? $rswrk->getRows() : [];
					if ($rswrk)
						$rswrk->close();
					$rowcnt = count($arwrk);
					for ($i = 0; $i < $rowcnt; $i++) {
						$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
					}
					$this->idemp->EditValue = $arwrk;
				}
			}

			// salaryp
			$this->salaryp->EditAttrs["class"] = "form-control";
			$this->salaryp->EditCustomAttributes = "";
			$this->salaryp->EditValue = HtmlEncode($this->salaryp->CurrentValue);
			$this->salaryp->PlaceHolder = RemoveHtml($this->salaryp->caption());
			if (strval($this->salaryp->EditValue) != "" && is_numeric($this->salaryp->EditValue))
				$this->salaryp->EditValue = FormatNumber($this->salaryp->EditValue, -2, -2, -2, -2);
			

			// Add refer script
			// idpayroll

			$this->idpayroll->LinkCustomAttributes = "";
			$this->idpayroll->HrefValue = "";

			// idemp
			$this->idemp->LinkCustomAttributes = "";
			$this->idemp->HrefValue = "";

			// salaryp
			$this->salaryp->LinkCustomAttributes = "";
			$this->salaryp->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->idpayroll->Required) {
			if (!$this->idpayroll->IsDetailKey && $this->idpayroll->FormValue != NULL && $this->idpayroll->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idpayroll->caption(), $this->idpayroll->RequiredErrorMessage));
			}
		}
		if ($this->idemp->Required) {
			if (!$this->idemp->IsDetailKey && $this->idemp->FormValue != NULL && $this->idemp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idemp->caption(), $this->idemp->RequiredErrorMessage));
			}
		}
		if ($this->salaryp->Required) {
			if (!$this->salaryp->IsDetailKey && $this->salaryp->FormValue != NULL && $this->salaryp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->salaryp->caption(), $this->salaryp->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->salaryp->FormValue)) {
			AddMessage($FormError, $this->salaryp->errorMessage());
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("policydp", $detailTblVar) && $GLOBALS["policydp"]->DetailAdd) {
			if (!isset($GLOBALS["policydp_grid"]))
				$GLOBALS["policydp_grid"] = new policydp_grid(); // Get detail page object
			$GLOBALS["policydp_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Check referential integrity for master table 'detailpayroll'
		$validMasterRecord = TRUE;
		$masterFilter = $this->sqlMasterFilter_payroll();
		if (strval($this->idpayroll->CurrentValue) != "") {
			$masterFilter = str_replace("@idpayroll@", AdjustSql($this->idpayroll->CurrentValue, "DB"), $masterFilter);
		} else {
			$validMasterRecord = FALSE;
		}
		if ($validMasterRecord) {
			if (!isset($GLOBALS["payroll"]))
				$GLOBALS["payroll"] = new payroll();
			$rsmaster = $GLOBALS["payroll"]->loadRs($masterFilter);
			$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
			$rsmaster->close();
		}
		if (!$validMasterRecord) {
			$relatedRecordMsg = str_replace("%t", "payroll", $Language->phrase("RelatedRecordRequired"));
			$this->setFailureMessage($relatedRecordMsg);
			return FALSE;
		}
		$conn = $this->getConnection();

		// Begin transaction
		if ($this->getCurrentDetailTable() != "")
			$conn->beginTrans();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// idpayroll
		$this->idpayroll->setDbValueDef($rsnew, $this->idpayroll->CurrentValue, 0, FALSE);

		// idemp
		$this->idemp->setDbValueDef($rsnew, $this->idemp->CurrentValue, 0, FALSE);

		// salaryp
		$this->salaryp->setDbValueDef($rsnew, $this->salaryp->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}

		// Add detail records
		if ($addRow) {
			$detailTblVar = explode(",", $this->getCurrentDetailTable());
			if (in_array("policydp", $detailTblVar) && $GLOBALS["policydp"]->DetailAdd) {
				$GLOBALS["policydp"]->iddp->setSessionValue($this->iddp->CurrentValue); // Set master key
				if (!isset($GLOBALS["policydp_grid"]))
					$GLOBALS["policydp_grid"] = new policydp_grid(); // Get detail page object
				$addRow = $GLOBALS["policydp_grid"]->gridInsert();
				if (!$addRow) {
					$GLOBALS["policydp"]->iddp->setSessionValue(""); // Clear master key if insert failed
				}
			}
		}

		// Commit/Rollback transaction
		if ($this->getCurrentDetailTable() != "") {
			if ($addRow) {
				$conn->commitTrans(); // Commit transaction
			} else {
				$conn->rollbackTrans(); // Rollback transaction
			}
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "payroll") {
				$validMaster = TRUE;
				if (($parm = Get("fk_idpayroll", Get("idpayroll"))) !== NULL) {
					$GLOBALS["payroll"]->idpayroll->setQueryStringValue($parm);
					$this->idpayroll->setQueryStringValue($GLOBALS["payroll"]->idpayroll->QueryStringValue);
					$this->idpayroll->setSessionValue($this->idpayroll->QueryStringValue);
					if (!is_numeric($GLOBALS["payroll"]->idpayroll->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "employee") {
				$validMaster = TRUE;
				if (($parm = Get("fk_idemp", Get("idemp"))) !== NULL) {
					$GLOBALS["employee"]->idemp->setQueryStringValue($parm);
					$this->idemp->setQueryStringValue($GLOBALS["employee"]->idemp->QueryStringValue);
					$this->idemp->setSessionValue($this->idemp->QueryStringValue);
					if (!is_numeric($GLOBALS["employee"]->idemp->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "payroll") {
				$validMaster = TRUE;
				if (($parm = Post("fk_idpayroll", Post("idpayroll"))) !== NULL) {
					$GLOBALS["payroll"]->idpayroll->setFormValue($parm);
					$this->idpayroll->setFormValue($GLOBALS["payroll"]->idpayroll->FormValue);
					$this->idpayroll->setSessionValue($this->idpayroll->FormValue);
					if (!is_numeric($GLOBALS["payroll"]->idpayroll->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "employee") {
				$validMaster = TRUE;
				if (($parm = Post("fk_idemp", Post("idemp"))) !== NULL) {
					$GLOBALS["employee"]->idemp->setFormValue($parm);
					$this->idemp->setFormValue($GLOBALS["employee"]->idemp->FormValue);
					$this->idemp->setSessionValue($this->idemp->FormValue);
					if (!is_numeric($GLOBALS["employee"]->idemp->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "payroll") {
				if ($this->idpayroll->CurrentValue == "")
					$this->idpayroll->setSessionValue("");
			}
			if ($masterTblVar != "employee") {
				if ($this->idemp->CurrentValue == "")
					$this->idemp->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("policydp", $detailTblVar)) {
				if (!isset($GLOBALS["policydp_grid"]))
					$GLOBALS["policydp_grid"] = new policydp_grid();
				if ($GLOBALS["policydp_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["policydp_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["policydp_grid"]->CurrentMode = "add";
					$GLOBALS["policydp_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["policydp_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["policydp_grid"]->setStartRecordNumber(1);
					$GLOBALS["policydp_grid"]->iddp->IsDetailKey = TRUE;
					$GLOBALS["policydp_grid"]->iddp->CurrentValue = $this->iddp->CurrentValue;
					$GLOBALS["policydp_grid"]->iddp->setSessionValue($GLOBALS["policydp_grid"]->iddp->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("detailpayrolllist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_idpayroll":
					break;
				case "x_idemp":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_idpayroll":
							$row[2] = FormatDateTime($row[2], 0);
							$row['df2'] = $row[2];
							$row[3] = FormatDateTime($row[3], 0);
							$row['df3'] = $row[3];
							break;
						case "x_idemp":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>