<?php namespace PHPMaker2020\intextdesign_proj_v0; ?>
<?php

/**
 * Table class for detailpayroll
 */
class detailpayroll extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $iddp;
	public $idpayroll;
	public $idemp;
	public $salaryp;
	public $mtap;
	public $mtdp;
	public $netpay;
	public $listpolicy;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'detailpayroll';
		$this->TableName = 'detailpayroll';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`detailpayroll`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// iddp
		$this->iddp = new DbField('detailpayroll', 'detailpayroll', 'x_iddp', 'iddp', '`iddp`', '`iddp`', 3, 11, -1, FALSE, '`iddp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->iddp->IsAutoIncrement = TRUE; // Autoincrement field
		$this->iddp->IsPrimaryKey = TRUE; // Primary key field
		$this->iddp->IsForeignKey = TRUE; // Foreign key field
		$this->iddp->Sortable = TRUE; // Allow sort
		$this->iddp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['iddp'] = &$this->iddp;

		// idpayroll
		$this->idpayroll = new DbField('detailpayroll', 'detailpayroll', 'x_idpayroll', 'idpayroll', '`idpayroll`', '`idpayroll`', 3, 11, -1, FALSE, '`idpayroll`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->idpayroll->IsForeignKey = TRUE; // Foreign key field
		$this->idpayroll->Nullable = FALSE; // NOT NULL field
		$this->idpayroll->Required = TRUE; // Required field
		$this->idpayroll->Sortable = TRUE; // Allow sort
		$this->idpayroll->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->idpayroll->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->idpayroll->Lookup = new Lookup('idpayroll', 'payroll', FALSE, 'idpayroll', ["descrip","startdate","enddate","typequinz"], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->idpayroll->Lookup = new Lookup('idpayroll', 'payroll', FALSE, 'idpayroll', ["descrip","startdate","enddate","typequinz"], [], [], [], [], [], [], '', '');
				break;
		}
		$this->idpayroll->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idpayroll'] = &$this->idpayroll;

		// idemp
		$this->idemp = new DbField('detailpayroll', 'detailpayroll', 'x_idemp', 'idemp', '`idemp`', '`idemp`', 3, 11, -1, FALSE, '`idemp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->idemp->IsForeignKey = TRUE; // Foreign key field
		$this->idemp->Nullable = FALSE; // NOT NULL field
		$this->idemp->Required = TRUE; // Required field
		$this->idemp->Sortable = TRUE; // Allow sort
		$this->idemp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->idemp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->idemp->Lookup = new Lookup('idemp', 'employee', FALSE, 'idemp', ["noemp","lastname","firstname",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->idemp->Lookup = new Lookup('idemp', 'employee', FALSE, 'idemp', ["noemp","lastname","firstname",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->idemp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idemp'] = &$this->idemp;

		// salaryp
		$this->salaryp = new DbField('detailpayroll', 'detailpayroll', 'x_salaryp', 'salaryp', '`salaryp`', '`salaryp`', 131, 15, -1, FALSE, '`salaryp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->salaryp->Sortable = TRUE; // Allow sort
		$this->salaryp->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['salaryp'] = &$this->salaryp;

		// mtap
		$this->mtap = new DbField('detailpayroll', 'detailpayroll', 'x_mtap', 'mtap', '`mtap`', '`mtap`', 131, 15, -1, FALSE, '`mtap`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mtap->Sortable = TRUE; // Allow sort
		$this->mtap->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['mtap'] = &$this->mtap;

		// mtdp
		$this->mtdp = new DbField('detailpayroll', 'detailpayroll', 'x_mtdp', 'mtdp', '`mtdp`', '`mtdp`', 131, 15, -1, FALSE, '`mtdp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mtdp->Sortable = TRUE; // Allow sort
		$this->mtdp->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['mtdp'] = &$this->mtdp;

		// netpay
		$this->netpay = new DbField('detailpayroll', 'detailpayroll', 'x_netpay', 'netpay', '`salaryp`+`mtap`-`mtdp`', '`salaryp`+`mtap`-`mtdp`', 131, 17, -1, FALSE, '`salaryp`+`mtap`-`mtdp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->netpay->IsCustom = TRUE; // Custom field
		$this->netpay->Sortable = TRUE; // Allow sort
		$this->netpay->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['netpay'] = &$this->netpay;

		// listpolicy
		$this->listpolicy = new DbField('detailpayroll', 'detailpayroll', 'x_listpolicy', 'listpolicy', '\'\'', '\'\'', 201, 65530, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->listpolicy->IsCustom = TRUE; // Custom field
		$this->listpolicy->Sortable = FALSE; // Allow sort
		$this->fields['listpolicy'] = &$this->listpolicy;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "payroll") {
			if ($this->idpayroll->getSessionValue() != "")
				$masterFilter .= "`idpayroll`=" . QuotedValue($this->idpayroll->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "employee") {
			if ($this->idemp->getSessionValue() != "")
				$masterFilter .= "`idemp`=" . QuotedValue($this->idemp->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "payroll") {
			if ($this->idpayroll->getSessionValue() != "")
				$detailFilter .= "`idpayroll`=" . QuotedValue($this->idpayroll->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		if ($this->getCurrentMasterTable() == "employee") {
			if ($this->idemp->getSessionValue() != "")
				$detailFilter .= "`idemp`=" . QuotedValue($this->idemp->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_payroll()
	{
		return "`idpayroll`=@idpayroll@";
	}

	// Detail filter
	public function sqlDetailFilter_payroll()
	{
		return "`idpayroll`=@idpayroll@";
	}

	// Master filter
	public function sqlMasterFilter_employee()
	{
		return "`idemp`=@idemp@";
	}

	// Detail filter
	public function sqlDetailFilter_employee()
	{
		return "`idemp`=@idemp@";
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "policydp") {
			$detailUrl = $GLOBALS["policydp"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_iddp=" . urlencode($this->iddp->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "detailpayrolllist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`detailpayroll`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT *, `salaryp`+`mtap`-`mtdp` AS `netpay`, '' AS `listpolicy` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->iddp->setDbValue($conn->insert_ID());
			$rs['iddp'] = $this->iddp->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();

		// Cascade Update detail table 'policydp'
		$cascadeUpdate = FALSE;
		$rscascade = [];
		if ($rsold && (isset($rs['iddp']) && $rsold['iddp'] != $rs['iddp'])) { // Update detail field 'iddp'
			$cascadeUpdate = TRUE;
			$rscascade['iddp'] = $rs['iddp'];
		}
		if ($cascadeUpdate) {
			if (!isset($GLOBALS["policydp"]))
				$GLOBALS["policydp"] = new policydp();
			$rswrk = $GLOBALS["policydp"]->loadRs("`iddp` = " . QuotedValue($rsold['iddp'], DATATYPE_NUMBER, 'DB'));
			while ($rswrk && !$rswrk->EOF) {
				$rskey = [];
				$fldname = 'idpdp';
				$rskey[$fldname] = $rswrk->fields[$fldname];
				$rsdtlold = &$rswrk->fields;
				$rsdtlnew = array_merge($rsdtlold, $rscascade);

				// Call Row_Updating event
				$success = $GLOBALS["policydp"]->Row_Updating($rsdtlold, $rsdtlnew);
				if ($success)
					$success = $GLOBALS["policydp"]->update($rscascade, $rskey, $rswrk->fields);
				if (!$success)
					return FALSE;

				// Call Row_Updated event
				$GLOBALS["policydp"]->Row_Updated($rsdtlold, $rsdtlnew);
				$rswrk->moveNext();
			}
		}
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('iddp', $rs))
				AddFilter($where, QuotedName('iddp', $this->Dbid) . '=' . QuotedValue($rs['iddp'], $this->iddp->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();

		// Cascade delete detail table 'policydp'
		if (!isset($GLOBALS["policydp"]))
			$GLOBALS["policydp"] = new policydp();
		$rscascade = $GLOBALS["policydp"]->loadRs("`iddp` = " . QuotedValue($rs['iddp'], DATATYPE_NUMBER, "DB"));
		$dtlrows = ($rscascade) ? $rscascade->getRows() : [];

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["policydp"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["policydp"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["policydp"]->Row_Deleted($dtlrow);
		}
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->iddp->DbValue = $row['iddp'];
		$this->idpayroll->DbValue = $row['idpayroll'];
		$this->idemp->DbValue = $row['idemp'];
		$this->salaryp->DbValue = $row['salaryp'];
		$this->mtap->DbValue = $row['mtap'];
		$this->mtdp->DbValue = $row['mtdp'];
		$this->netpay->DbValue = $row['netpay'];
		$this->listpolicy->DbValue = $row['listpolicy'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`iddp` = @iddp@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('iddp', $row) ? $row['iddp'] : NULL;
		else
			$val = $this->iddp->OldValue !== NULL ? $this->iddp->OldValue : $this->iddp->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@iddp@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "detailpayrolllist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "detailpayrollview.php")
			return $Language->phrase("View");
		elseif ($pageName == "detailpayrolledit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "detailpayrolladd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "detailpayrolllist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("detailpayrollview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("detailpayrollview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "detailpayrolladd.php?" . $this->getUrlParm($parm);
		else
			$url = "detailpayrolladd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("detailpayrolledit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("detailpayrolledit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("detailpayrolladd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("detailpayrolladd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("detailpayrolldelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "payroll" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_idpayroll=" . urlencode($this->idpayroll->CurrentValue);
		}
		if ($this->getCurrentMasterTable() == "employee" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_idemp=" . urlencode($this->idemp->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "iddp:" . JsonEncode($this->iddp->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->iddp->CurrentValue != NULL) {
			$url .= "iddp=" . urlencode($this->iddp->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("iddp") !== NULL)
				$arKeys[] = Param("iddp");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->iddp->CurrentValue = $key;
			else
				$this->iddp->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->iddp->setDbValue($rs->fields('iddp'));
		$this->idpayroll->setDbValue($rs->fields('idpayroll'));
		$this->idemp->setDbValue($rs->fields('idemp'));
		$this->salaryp->setDbValue($rs->fields('salaryp'));
		$this->mtap->setDbValue($rs->fields('mtap'));
		$this->mtdp->setDbValue($rs->fields('mtdp'));
		$this->netpay->setDbValue($rs->fields('netpay'));
		$this->listpolicy->setDbValue($rs->fields('listpolicy'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// iddp
		// idpayroll
		// idemp
		// salaryp
		// mtap
		// mtdp
		// netpay
		// listpolicy
		// iddp

		$this->iddp->ViewValue = $this->iddp->CurrentValue;
		$this->iddp->ViewCustomAttributes = "";

		// idpayroll
		$curVal = strval($this->idpayroll->CurrentValue);
		if ($curVal != "") {
			$this->idpayroll->ViewValue = $this->idpayroll->lookupCacheOption($curVal);
			if ($this->idpayroll->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`idpayroll`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->idpayroll->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = FormatDateTime($rswrk->fields('df2'), 0);
					$arwrk[3] = FormatDateTime($rswrk->fields('df3'), 0);
					$arwrk[4] = $rswrk->fields('df4');
					$this->idpayroll->ViewValue = $this->idpayroll->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->idpayroll->ViewValue = $this->idpayroll->CurrentValue;
				}
			}
		} else {
			$this->idpayroll->ViewValue = NULL;
		}
		$this->idpayroll->ViewCustomAttributes = "";

		// idemp
		$curVal = strval($this->idemp->CurrentValue);
		if ($curVal != "") {
			$this->idemp->ViewValue = $this->idemp->lookupCacheOption($curVal);
			if ($this->idemp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`idemp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->idemp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->idemp->ViewValue = $this->idemp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->idemp->ViewValue = $this->idemp->CurrentValue;
				}
			}
		} else {
			$this->idemp->ViewValue = NULL;
		}
		$this->idemp->ViewCustomAttributes = "";

		// salaryp
		$this->salaryp->ViewValue = $this->salaryp->CurrentValue;
		$this->salaryp->ViewValue = FormatNumber($this->salaryp->ViewValue, 2, -2, -2, -2);
		$this->salaryp->ViewCustomAttributes = "";

		// mtap
		$this->mtap->ViewValue = $this->mtap->CurrentValue;
		$this->mtap->ViewValue = FormatNumber($this->mtap->ViewValue, 2, -2, -2, -2);
		$this->mtap->ViewCustomAttributes = "";

		// mtdp
		$this->mtdp->ViewValue = $this->mtdp->CurrentValue;
		$this->mtdp->ViewValue = FormatNumber($this->mtdp->ViewValue, 2, -2, -2, -2);
		$this->mtdp->ViewCustomAttributes = "";

		// netpay
		$this->netpay->ViewValue = $this->netpay->CurrentValue;
		$this->netpay->ViewValue = FormatNumber($this->netpay->ViewValue, 2, -2, -2, -2);
		$this->netpay->ViewCustomAttributes = "";

		// listpolicy
		$this->listpolicy->ViewValue = $this->listpolicy->CurrentValue;
		$this->listpolicy->ViewCustomAttributes = "";

		// iddp
		$this->iddp->LinkCustomAttributes = "";
		$this->iddp->HrefValue = "";
		$this->iddp->TooltipValue = "";

		// idpayroll
		$this->idpayroll->LinkCustomAttributes = "";
		$this->idpayroll->HrefValue = "";
		$this->idpayroll->TooltipValue = "";

		// idemp
		$this->idemp->LinkCustomAttributes = "";
		$this->idemp->HrefValue = "";
		$this->idemp->TooltipValue = "";

		// salaryp
		$this->salaryp->LinkCustomAttributes = "";
		$this->salaryp->HrefValue = "";
		$this->salaryp->TooltipValue = "";

		// mtap
		$this->mtap->LinkCustomAttributes = "";
		$this->mtap->HrefValue = "";
		$this->mtap->TooltipValue = "";

		// mtdp
		$this->mtdp->LinkCustomAttributes = "";
		$this->mtdp->HrefValue = "";
		$this->mtdp->TooltipValue = "";

		// netpay
		$this->netpay->LinkCustomAttributes = "";
		$this->netpay->HrefValue = "";
		$this->netpay->TooltipValue = "";

		// listpolicy
		$this->listpolicy->LinkCustomAttributes = "";
		$this->listpolicy->HrefValue = "";
		$this->listpolicy->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// iddp
		$this->iddp->EditAttrs["class"] = "form-control";
		$this->iddp->EditCustomAttributes = "";
		$this->iddp->EditValue = $this->iddp->CurrentValue;
		$this->iddp->ViewCustomAttributes = "";

		// idpayroll
		$this->idpayroll->EditAttrs["class"] = "form-control";
		$this->idpayroll->EditCustomAttributes = "";
		if ($this->idpayroll->getSessionValue() != "") {
			$this->idpayroll->CurrentValue = $this->idpayroll->getSessionValue();
			$curVal = strval($this->idpayroll->CurrentValue);
			if ($curVal != "") {
				$this->idpayroll->ViewValue = $this->idpayroll->lookupCacheOption($curVal);
				if ($this->idpayroll->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idpayroll`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idpayroll->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatDateTime($rswrk->fields('df2'), 0);
						$arwrk[3] = FormatDateTime($rswrk->fields('df3'), 0);
						$arwrk[4] = $rswrk->fields('df4');
						$this->idpayroll->ViewValue = $this->idpayroll->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idpayroll->ViewValue = $this->idpayroll->CurrentValue;
					}
				}
			} else {
				$this->idpayroll->ViewValue = NULL;
			}
			$this->idpayroll->ViewCustomAttributes = "";
		} else {
		}

		// idemp
		$this->idemp->EditAttrs["class"] = "form-control";
		$this->idemp->EditCustomAttributes = "";
		if ($this->idemp->getSessionValue() != "") {
			$this->idemp->CurrentValue = $this->idemp->getSessionValue();
			$curVal = strval($this->idemp->CurrentValue);
			if ($curVal != "") {
				$this->idemp->ViewValue = $this->idemp->lookupCacheOption($curVal);
				if ($this->idemp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idemp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->idemp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->idemp->ViewValue = $this->idemp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idemp->ViewValue = $this->idemp->CurrentValue;
					}
				}
			} else {
				$this->idemp->ViewValue = NULL;
			}
			$this->idemp->ViewCustomAttributes = "";
		} else {
		}

		// salaryp
		$this->salaryp->EditAttrs["class"] = "form-control";
		$this->salaryp->EditCustomAttributes = "";
		$this->salaryp->EditValue = $this->salaryp->CurrentValue;
		$this->salaryp->PlaceHolder = RemoveHtml($this->salaryp->caption());
		if (strval($this->salaryp->EditValue) != "" && is_numeric($this->salaryp->EditValue))
			$this->salaryp->EditValue = FormatNumber($this->salaryp->EditValue, -2, -2, -2, -2);
		

		// mtap
		$this->mtap->EditAttrs["class"] = "form-control";
		$this->mtap->EditCustomAttributes = "";
		$this->mtap->EditValue = $this->mtap->CurrentValue;
		$this->mtap->PlaceHolder = RemoveHtml($this->mtap->caption());
		if (strval($this->mtap->EditValue) != "" && is_numeric($this->mtap->EditValue))
			$this->mtap->EditValue = FormatNumber($this->mtap->EditValue, -2, -2, -2, -2);
		

		// mtdp
		$this->mtdp->EditAttrs["class"] = "form-control";
		$this->mtdp->EditCustomAttributes = "";
		$this->mtdp->EditValue = $this->mtdp->CurrentValue;
		$this->mtdp->PlaceHolder = RemoveHtml($this->mtdp->caption());
		if (strval($this->mtdp->EditValue) != "" && is_numeric($this->mtdp->EditValue))
			$this->mtdp->EditValue = FormatNumber($this->mtdp->EditValue, -2, -2, -2, -2);
		

		// netpay
		$this->netpay->EditAttrs["class"] = "form-control";
		$this->netpay->EditCustomAttributes = "";
		$this->netpay->EditValue = $this->netpay->CurrentValue;
		$this->netpay->PlaceHolder = RemoveHtml($this->netpay->caption());
		if (strval($this->netpay->EditValue) != "" && is_numeric($this->netpay->EditValue))
			$this->netpay->EditValue = FormatNumber($this->netpay->EditValue, -2, -2, -2, -2);
		

		// listpolicy
		$this->listpolicy->EditAttrs["class"] = "form-control";
		$this->listpolicy->EditCustomAttributes = "";
		$this->listpolicy->EditValue = $this->listpolicy->CurrentValue;
		$this->listpolicy->PlaceHolder = RemoveHtml($this->listpolicy->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			$this->idpayroll->Count++; // Increment count
			$this->idemp->Count++; // Increment count
			if (is_numeric($this->salaryp->CurrentValue))
				$this->salaryp->Total += $this->salaryp->CurrentValue; // Accumulate total
			if (is_numeric($this->mtap->CurrentValue))
				$this->mtap->Total += $this->mtap->CurrentValue; // Accumulate total
			if (is_numeric($this->mtdp->CurrentValue))
				$this->mtdp->Total += $this->mtdp->CurrentValue; // Accumulate total
			if (is_numeric($this->netpay->CurrentValue))
				$this->netpay->Total += $this->netpay->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->idpayroll->CurrentValue = $this->idpayroll->Count;
			$this->idpayroll->ViewValue = $this->idpayroll->CurrentValue;
			$this->idpayroll->ViewCustomAttributes = "";
			$this->idpayroll->HrefValue = ""; // Clear href value
			$this->idemp->CurrentValue = $this->idemp->Count;
			$this->idemp->ViewValue = $this->idemp->CurrentValue;
			$this->idemp->ViewCustomAttributes = "";
			$this->idemp->HrefValue = ""; // Clear href value
			$this->salaryp->CurrentValue = $this->salaryp->Total;
			$this->salaryp->ViewValue = $this->salaryp->CurrentValue;
			$this->salaryp->ViewValue = FormatNumber($this->salaryp->ViewValue, 2, -2, -2, -2);
			$this->salaryp->ViewCustomAttributes = "";
			$this->salaryp->HrefValue = ""; // Clear href value
			$this->mtap->CurrentValue = $this->mtap->Total;
			$this->mtap->ViewValue = $this->mtap->CurrentValue;
			$this->mtap->ViewValue = FormatNumber($this->mtap->ViewValue, 2, -2, -2, -2);
			$this->mtap->ViewCustomAttributes = "";
			$this->mtap->HrefValue = ""; // Clear href value
			$this->mtdp->CurrentValue = $this->mtdp->Total;
			$this->mtdp->ViewValue = $this->mtdp->CurrentValue;
			$this->mtdp->ViewValue = FormatNumber($this->mtdp->ViewValue, 2, -2, -2, -2);
			$this->mtdp->ViewCustomAttributes = "";
			$this->mtdp->HrefValue = ""; // Clear href value
			$this->netpay->CurrentValue = $this->netpay->Total;
			$this->netpay->ViewValue = $this->netpay->CurrentValue;
			$this->netpay->ViewValue = FormatNumber($this->netpay->ViewValue, 2, -2, -2, -2);
			$this->netpay->ViewCustomAttributes = "";
			$this->netpay->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->iddp);
					$doc->exportCaption($this->idpayroll);
					$doc->exportCaption($this->idemp);
					$doc->exportCaption($this->salaryp);
					$doc->exportCaption($this->mtap);
					$doc->exportCaption($this->mtdp);
					$doc->exportCaption($this->netpay);
					$doc->exportCaption($this->listpolicy);
				} else {
					$doc->exportCaption($this->iddp);
					$doc->exportCaption($this->idpayroll);
					$doc->exportCaption($this->idemp);
					$doc->exportCaption($this->salaryp);
					$doc->exportCaption($this->mtap);
					$doc->exportCaption($this->mtdp);
					$doc->exportCaption($this->netpay);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->iddp);
						$doc->exportField($this->idpayroll);
						$doc->exportField($this->idemp);
						$doc->exportField($this->salaryp);
						$doc->exportField($this->mtap);
						$doc->exportField($this->mtdp);
						$doc->exportField($this->netpay);
						$doc->exportField($this->listpolicy);
					} else {
						$doc->exportField($this->iddp);
						$doc->exportField($this->idpayroll);
						$doc->exportField($this->idemp);
						$doc->exportField($this->salaryp);
						$doc->exportField($this->mtap);
						$doc->exportField($this->mtdp);
						$doc->exportField($this->netpay);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->iddp, '');
				$doc->exportAggregate($this->idpayroll, 'COUNT');
				$doc->exportAggregate($this->idemp, 'COUNT');
				$doc->exportAggregate($this->salaryp, 'TOTAL');
				$doc->exportAggregate($this->mtap, 'TOTAL');
				$doc->exportAggregate($this->mtdp, 'TOTAL');
				$doc->exportAggregate($this->netpay, 'TOTAL');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	if($this->iddp->CurrentValue!=""){// METTRE CONDITION POUR DIRE IF ROWS

	//affiche mtap
	$rsqla="SELECT  sum(amountpo) from policydp
	where typepo=1 and policydp.iddp=".$this->iddp->CurrentValue;
	$vala= ExecuteScalar($rsqla);
	$this->mtap->CurrentValue=$vala;

	//affiche mtdp
	$rsqld="SELECT  sum(amountpo) from policydp
	where typepo=2 and policydp.iddp=".$this->iddp->CurrentValue;
	$vald= ExecuteScalar($rsqld);
	$this->mtdp->CurrentValue=$vald;

	//affiche netpay
	$this->netpay->CurrentValue=$this->salaryp->CurrentValue+$vala-$vald;

	//affiche liste policydp
	$sql="SELECT titlepo,amountpo,per,typepo,ifnull(peramountpo,0)
	from policydp where policydp.iddp=".$this->iddp->CurrentValue ;
	$rows = ExecuteRows($sql); // METTRE CONDITION POUR DIRE IF ROWS
	foreach($rows as $x => $val)
		{
		$info= '<span class="text-info">'.$val[0].'</span>';
		if($val[3]==1) $info.= '<small class="text-success"> ('.$val[1].')</small><br>';
		else $info.=  '<small class="text-danger"> ('.$val[1].')</small><br>';
		$this->listpolicy->CurrentValue.= $info;
		}
	}
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>