<?php
namespace PHPMaker2020\intextdesign_proj_v0;

/**
 * Page class
 */
class datatemp_add extends datatemp
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{D5394950-A905-4BDF-B7DA-D47F92A453D8}";

	// Table name
	public $TableName = 'datatemp';

	// Page object name
	public $PageObjName = "datatemp_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (datatemp)
		if (!isset($GLOBALS["datatemp"]) || get_class($GLOBALS["datatemp"]) == PROJECT_NAMESPACE . "datatemp") {
			$GLOBALS["datatemp"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["datatemp"];
		}

		// Table object (attendance)
		if (!isset($GLOBALS['attendance']))
			$GLOBALS['attendance'] = new attendance();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'datatemp');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $datatemp;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($datatemp);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "datatempview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['iddt'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->iddt->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("datatemplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->iddt->Visible = FALSE;
		$this->datejob->setVisibility();
		$this->idemp->setVisibility();
		$this->dept->setVisibility();
		$this->type->setVisibility();
		$this->nbrheur->setVisibility();
		$this->tauxh->setVisibility();
		$this->SubTotal->setVisibility();
		$this->idatt->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->idemp);
		$this->setupLookupOptions($this->dept);
		$this->setupLookupOptions($this->type);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("iddt") !== NULL) {
				$this->iddt->setQueryStringValue(Get("iddt"));
				$this->setKey("iddt", $this->iddt->CurrentValue); // Set up key
			} else {
				$this->setKey("iddt", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("datatemplist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "datatemplist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "datatempview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->iddt->CurrentValue = NULL;
		$this->iddt->OldValue = $this->iddt->CurrentValue;
		$this->datejob->CurrentValue = CurrentDate();
		$this->idemp->CurrentValue = NULL;
		$this->idemp->OldValue = $this->idemp->CurrentValue;
		$this->dept->CurrentValue = NULL;
		$this->dept->OldValue = $this->dept->CurrentValue;
		$this->type->CurrentValue = NULL;
		$this->type->OldValue = $this->type->CurrentValue;
		$this->nbrheur->CurrentValue = 8;
		$this->tauxh->CurrentValue = NULL;
		$this->tauxh->OldValue = $this->tauxh->CurrentValue;
		$this->SubTotal->CurrentValue = NULL;
		$this->SubTotal->OldValue = $this->SubTotal->CurrentValue;
		$this->idatt->CurrentValue = NULL;
		$this->idatt->OldValue = $this->idatt->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'datejob' first before field var 'x_datejob'
		$val = $CurrentForm->hasValue("datejob") ? $CurrentForm->getValue("datejob") : $CurrentForm->getValue("x_datejob");
		if (!$this->datejob->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->datejob->Visible = FALSE; // Disable update for API request
			else
				$this->datejob->setFormValue($val);
			$this->datejob->CurrentValue = UnFormatDateTime($this->datejob->CurrentValue, 7);
		}

		// Check field name 'idemp' first before field var 'x_idemp'
		$val = $CurrentForm->hasValue("idemp") ? $CurrentForm->getValue("idemp") : $CurrentForm->getValue("x_idemp");
		if (!$this->idemp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->idemp->Visible = FALSE; // Disable update for API request
			else
				$this->idemp->setFormValue($val);
		}

		// Check field name 'dept' first before field var 'x_dept'
		$val = $CurrentForm->hasValue("dept") ? $CurrentForm->getValue("dept") : $CurrentForm->getValue("x_dept");
		if (!$this->dept->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->dept->Visible = FALSE; // Disable update for API request
			else
				$this->dept->setFormValue($val);
		}

		// Check field name 'type' first before field var 'x_type'
		$val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
		if (!$this->type->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->type->Visible = FALSE; // Disable update for API request
			else
				$this->type->setFormValue($val);
		}

		// Check field name 'nbrheur' first before field var 'x_nbrheur'
		$val = $CurrentForm->hasValue("nbrheur") ? $CurrentForm->getValue("nbrheur") : $CurrentForm->getValue("x_nbrheur");
		if (!$this->nbrheur->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->nbrheur->Visible = FALSE; // Disable update for API request
			else
				$this->nbrheur->setFormValue($val);
		}

		// Check field name 'tauxh' first before field var 'x_tauxh'
		$val = $CurrentForm->hasValue("tauxh") ? $CurrentForm->getValue("tauxh") : $CurrentForm->getValue("x_tauxh");
		if (!$this->tauxh->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->tauxh->Visible = FALSE; // Disable update for API request
			else
				$this->tauxh->setFormValue($val);
		}

		// Check field name 'SubTotal' first before field var 'x_SubTotal'
		$val = $CurrentForm->hasValue("SubTotal") ? $CurrentForm->getValue("SubTotal") : $CurrentForm->getValue("x_SubTotal");
		if (!$this->SubTotal->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->SubTotal->Visible = FALSE; // Disable update for API request
			else
				$this->SubTotal->setFormValue($val);
		}

		// Check field name 'iddt' first before field var 'x_iddt'
		$val = $CurrentForm->hasValue("iddt") ? $CurrentForm->getValue("iddt") : $CurrentForm->getValue("x_iddt");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->datejob->CurrentValue = $this->datejob->FormValue;
		$this->datejob->CurrentValue = UnFormatDateTime($this->datejob->CurrentValue, 7);
		$this->idemp->CurrentValue = $this->idemp->FormValue;
		$this->dept->CurrentValue = $this->dept->FormValue;
		$this->type->CurrentValue = $this->type->FormValue;
		$this->nbrheur->CurrentValue = $this->nbrheur->FormValue;
		$this->tauxh->CurrentValue = $this->tauxh->FormValue;
		$this->SubTotal->CurrentValue = $this->SubTotal->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->iddt->setDbValue($row['iddt']);
		$this->datejob->setDbValue($row['datejob']);
		$this->idemp->setDbValue($row['idemp']);
		$this->dept->setDbValue($row['dept']);
		$this->type->setDbValue($row['type']);
		$this->nbrheur->setDbValue($row['nbrheur']);
		$this->tauxh->setDbValue($row['tauxh']);
		$this->SubTotal->setDbValue($row['SubTotal']);
		$this->idatt->setDbValue($row['idatt']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['iddt'] = $this->iddt->CurrentValue;
		$row['datejob'] = $this->datejob->CurrentValue;
		$row['idemp'] = $this->idemp->CurrentValue;
		$row['dept'] = $this->dept->CurrentValue;
		$row['type'] = $this->type->CurrentValue;
		$row['nbrheur'] = $this->nbrheur->CurrentValue;
		$row['tauxh'] = $this->tauxh->CurrentValue;
		$row['SubTotal'] = $this->SubTotal->CurrentValue;
		$row['idatt'] = $this->idatt->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("iddt")) != "")
			$this->iddt->OldValue = $this->getKey("iddt"); // iddt
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->tauxh->FormValue == $this->tauxh->CurrentValue && is_numeric(ConvertToFloatString($this->tauxh->CurrentValue)))
			$this->tauxh->CurrentValue = ConvertToFloatString($this->tauxh->CurrentValue);

		// Convert decimal values if posted back
		if ($this->SubTotal->FormValue == $this->SubTotal->CurrentValue && is_numeric(ConvertToFloatString($this->SubTotal->CurrentValue)))
			$this->SubTotal->CurrentValue = ConvertToFloatString($this->SubTotal->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// iddt
		// datejob
		// idemp
		// dept
		// type
		// nbrheur
		// tauxh
		// SubTotal
		// idatt

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// iddt
			$this->iddt->ViewValue = $this->iddt->CurrentValue;
			$this->iddt->ViewCustomAttributes = "";

			// datejob
			$this->datejob->ViewValue = $this->datejob->CurrentValue;
			$this->datejob->ViewValue = FormatDateTime($this->datejob->ViewValue, 7);
			$this->datejob->ViewCustomAttributes = "";

			// idemp
			$curVal = strval($this->idemp->CurrentValue);
			if ($curVal != "") {
				$this->idemp->ViewValue = $this->idemp->lookupCacheOption($curVal);
				if ($this->idemp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idemp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`idtype`=1 and `idstatus`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->idemp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->idemp->ViewValue = $this->idemp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idemp->ViewValue = $this->idemp->CurrentValue;
					}
				}
			} else {
				$this->idemp->ViewValue = NULL;
			}
			$this->idemp->ViewCustomAttributes = "";

			// dept
			$this->dept->ViewValue = $this->dept->CurrentValue;
			$curVal = strval($this->dept->CurrentValue);
			if ($curVal != "") {
				$this->dept->ViewValue = $this->dept->lookupCacheOption($curVal);
				if ($this->dept->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`iddep`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->dept->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->dept->ViewValue = $this->dept->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dept->ViewValue = $this->dept->CurrentValue;
					}
				}
			} else {
				$this->dept->ViewValue = NULL;
			}
			$this->dept->ViewCustomAttributes = "";

			// type
			$this->type->ViewValue = $this->type->CurrentValue;
			$curVal = strval($this->type->CurrentValue);
			if ($curVal != "") {
				$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
				if ($this->type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idtype`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->type->ViewValue = $this->type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->type->ViewValue = $this->type->CurrentValue;
					}
				}
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->CellCssStyle .= "text-align: center;";
			$this->type->ViewCustomAttributes = "";

			// nbrheur
			$this->nbrheur->ViewValue = $this->nbrheur->CurrentValue;
			$this->nbrheur->ViewValue = FormatNumber($this->nbrheur->ViewValue, 0, -2, -2, -2);
			$this->nbrheur->CellCssStyle .= "text-align: center;";
			$this->nbrheur->ViewCustomAttributes = "";

			// tauxh
			$this->tauxh->ViewValue = $this->tauxh->CurrentValue;
			$this->tauxh->ViewValue = FormatCurrency($this->tauxh->ViewValue, 2, -2, -2, -2);
			$this->tauxh->ViewCustomAttributes = "";

			// SubTotal
			$this->SubTotal->ViewValue = $this->SubTotal->CurrentValue;
			$this->SubTotal->ViewValue = FormatNumber($this->SubTotal->ViewValue, 2, -2, -2, -2);
			$this->SubTotal->ViewCustomAttributes = "";

			// idatt
			$this->idatt->ViewValue = $this->idatt->CurrentValue;
			$this->idatt->ViewValue = FormatNumber($this->idatt->ViewValue, 0, -2, -2, -2);
			$this->idatt->ViewCustomAttributes = "";

			// datejob
			$this->datejob->LinkCustomAttributes = "";
			$this->datejob->HrefValue = "";
			$this->datejob->TooltipValue = "";

			// idemp
			$this->idemp->LinkCustomAttributes = "";
			$this->idemp->HrefValue = "";
			$this->idemp->TooltipValue = "";

			// dept
			$this->dept->LinkCustomAttributes = "";
			$this->dept->HrefValue = "";
			$this->dept->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// nbrheur
			$this->nbrheur->LinkCustomAttributes = "";
			$this->nbrheur->HrefValue = "";
			$this->nbrheur->TooltipValue = "";

			// tauxh
			$this->tauxh->LinkCustomAttributes = "";
			$this->tauxh->HrefValue = "";
			$this->tauxh->TooltipValue = "";

			// SubTotal
			$this->SubTotal->LinkCustomAttributes = "";
			$this->SubTotal->HrefValue = "";
			$this->SubTotal->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// datejob
			$this->datejob->EditAttrs["class"] = "form-control";
			$this->datejob->EditCustomAttributes = "";
			$this->datejob->EditValue = HtmlEncode(FormatDateTime($this->datejob->CurrentValue, 7));
			$this->datejob->PlaceHolder = RemoveHtml($this->datejob->caption());

			// idemp
			$this->idemp->EditCustomAttributes = "";
			$curVal = trim(strval($this->idemp->CurrentValue));
			if ($curVal != "")
				$this->idemp->ViewValue = $this->idemp->lookupCacheOption($curVal);
			else
				$this->idemp->ViewValue = $this->idemp->Lookup !== NULL && is_array($this->idemp->Lookup->Options) ? $curVal : NULL;
			if ($this->idemp->ViewValue !== NULL) { // Load from cache
				$this->idemp->EditValue = array_values($this->idemp->Lookup->Options);
				if ($this->idemp->ViewValue == "")
					$this->idemp->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`idemp`" . SearchString("=", $this->idemp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`idtype`=1 and `idstatus`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->idemp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
					$this->idemp->ViewValue = $this->idemp->displayValue($arwrk);
				} else {
					$this->idemp->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->idemp->EditValue = $arwrk;
			}

			// dept
			$this->dept->EditAttrs["class"] = "form-control";
			$this->dept->EditCustomAttributes = "";
			$this->dept->EditValue = HtmlEncode($this->dept->CurrentValue);
			$curVal = strval($this->dept->CurrentValue);
			if ($curVal != "") {
				$this->dept->EditValue = $this->dept->lookupCacheOption($curVal);
				if ($this->dept->EditValue === NULL) { // Lookup from database
					$filterWrk = "`iddep`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->dept->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->dept->EditValue = $this->dept->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dept->EditValue = HtmlEncode($this->dept->CurrentValue);
					}
				}
			} else {
				$this->dept->EditValue = NULL;
			}
			$this->dept->PlaceHolder = RemoveHtml($this->dept->caption());

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$this->type->EditValue = HtmlEncode($this->type->CurrentValue);
			$curVal = strval($this->type->CurrentValue);
			if ($curVal != "") {
				$this->type->EditValue = $this->type->lookupCacheOption($curVal);
				if ($this->type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`idtype`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->type->EditValue = $this->type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->type->EditValue = HtmlEncode($this->type->CurrentValue);
					}
				}
			} else {
				$this->type->EditValue = NULL;
			}
			$this->type->PlaceHolder = RemoveHtml($this->type->caption());

			// nbrheur
			$this->nbrheur->EditAttrs["class"] = "form-control";
			$this->nbrheur->EditCustomAttributes = "";
			$this->nbrheur->EditValue = HtmlEncode($this->nbrheur->CurrentValue);
			$this->nbrheur->PlaceHolder = RemoveHtml($this->nbrheur->caption());

			// tauxh
			$this->tauxh->EditAttrs["class"] = "form-control";
			$this->tauxh->EditCustomAttributes = "";
			$this->tauxh->EditValue = HtmlEncode($this->tauxh->CurrentValue);
			$this->tauxh->PlaceHolder = RemoveHtml($this->tauxh->caption());
			if (strval($this->tauxh->EditValue) != "" && is_numeric($this->tauxh->EditValue))
				$this->tauxh->EditValue = FormatNumber($this->tauxh->EditValue, -2, -2, -2, -2);
			

			// SubTotal
			$this->SubTotal->EditAttrs["class"] = "form-control";
			$this->SubTotal->EditCustomAttributes = "";
			$this->SubTotal->EditValue = HtmlEncode($this->SubTotal->CurrentValue);
			$this->SubTotal->PlaceHolder = RemoveHtml($this->SubTotal->caption());
			if (strval($this->SubTotal->EditValue) != "" && is_numeric($this->SubTotal->EditValue))
				$this->SubTotal->EditValue = FormatNumber($this->SubTotal->EditValue, -2, -2, -2, -2);
			

			// Add refer script
			// datejob

			$this->datejob->LinkCustomAttributes = "";
			$this->datejob->HrefValue = "";

			// idemp
			$this->idemp->LinkCustomAttributes = "";
			$this->idemp->HrefValue = "";

			// dept
			$this->dept->LinkCustomAttributes = "";
			$this->dept->HrefValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";

			// nbrheur
			$this->nbrheur->LinkCustomAttributes = "";
			$this->nbrheur->HrefValue = "";

			// tauxh
			$this->tauxh->LinkCustomAttributes = "";
			$this->tauxh->HrefValue = "";

			// SubTotal
			$this->SubTotal->LinkCustomAttributes = "";
			$this->SubTotal->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->datejob->Required) {
			if (!$this->datejob->IsDetailKey && $this->datejob->FormValue != NULL && $this->datejob->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datejob->caption(), $this->datejob->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->datejob->FormValue)) {
			AddMessage($FormError, $this->datejob->errorMessage());
		}
		if ($this->idemp->Required) {
			if (!$this->idemp->IsDetailKey && $this->idemp->FormValue != NULL && $this->idemp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->idemp->caption(), $this->idemp->RequiredErrorMessage));
			}
		}
		if ($this->dept->Required) {
			if (!$this->dept->IsDetailKey && $this->dept->FormValue != NULL && $this->dept->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dept->caption(), $this->dept->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->dept->FormValue)) {
			AddMessage($FormError, $this->dept->errorMessage());
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->type->FormValue)) {
			AddMessage($FormError, $this->type->errorMessage());
		}
		if ($this->nbrheur->Required) {
			if (!$this->nbrheur->IsDetailKey && $this->nbrheur->FormValue != NULL && $this->nbrheur->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nbrheur->caption(), $this->nbrheur->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->nbrheur->FormValue)) {
			AddMessage($FormError, $this->nbrheur->errorMessage());
		}
		if ($this->tauxh->Required) {
			if (!$this->tauxh->IsDetailKey && $this->tauxh->FormValue != NULL && $this->tauxh->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tauxh->caption(), $this->tauxh->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->tauxh->FormValue)) {
			AddMessage($FormError, $this->tauxh->errorMessage());
		}
		if ($this->SubTotal->Required) {
			if (!$this->SubTotal->IsDetailKey && $this->SubTotal->FormValue != NULL && $this->SubTotal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SubTotal->caption(), $this->SubTotal->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->SubTotal->FormValue)) {
			AddMessage($FormError, $this->SubTotal->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Check referential integrity for master table 'datatemp'
		$validMasterRecord = TRUE;
		$masterFilter = $this->sqlMasterFilter_attendance();
		if ($this->idatt->getSessionValue() != "") {
			$masterFilter = str_replace("@idatt@", AdjustSql($this->idatt->getSessionValue(), "DB"), $masterFilter);
		} else {
			$validMasterRecord = FALSE;
		}
		if ($validMasterRecord) {
			if (!isset($GLOBALS["attendance"]))
				$GLOBALS["attendance"] = new attendance();
			$rsmaster = $GLOBALS["attendance"]->loadRs($masterFilter);
			$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
			$rsmaster->close();
		}
		if (!$validMasterRecord) {
			$relatedRecordMsg = str_replace("%t", "attendance", $Language->phrase("RelatedRecordRequired"));
			$this->setFailureMessage($relatedRecordMsg);
			return FALSE;
		}
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// datejob
		$this->datejob->setDbValueDef($rsnew, UnFormatDateTime($this->datejob->CurrentValue, 7), NULL, FALSE);

		// idemp
		$this->idemp->setDbValueDef($rsnew, $this->idemp->CurrentValue, 0, FALSE);

		// dept
		$this->dept->setDbValueDef($rsnew, $this->dept->CurrentValue, 0, FALSE);

		// type
		$this->type->setDbValueDef($rsnew, $this->type->CurrentValue, 0, FALSE);

		// nbrheur
		$this->nbrheur->setDbValueDef($rsnew, $this->nbrheur->CurrentValue, 0, FALSE);

		// tauxh
		$this->tauxh->setDbValueDef($rsnew, $this->tauxh->CurrentValue, 0, FALSE);

		// SubTotal
		$this->SubTotal->setDbValueDef($rsnew, $this->SubTotal->CurrentValue, 0, FALSE);

		// idatt
		if ($this->idatt->getSessionValue() != "") {
			$rsnew['idatt'] = $this->idatt->getSessionValue();
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "attendance") {
				$validMaster = TRUE;
				if (($parm = Get("fk_idatt", Get("idatt"))) !== NULL) {
					$GLOBALS["attendance"]->idatt->setQueryStringValue($parm);
					$this->idatt->setQueryStringValue($GLOBALS["attendance"]->idatt->QueryStringValue);
					$this->idatt->setSessionValue($this->idatt->QueryStringValue);
					if (!is_numeric($GLOBALS["attendance"]->idatt->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "attendance") {
				$validMaster = TRUE;
				if (($parm = Post("fk_idatt", Post("idatt"))) !== NULL) {
					$GLOBALS["attendance"]->idatt->setFormValue($parm);
					$this->idatt->setFormValue($GLOBALS["attendance"]->idatt->FormValue);
					$this->idatt->setSessionValue($this->idatt->FormValue);
					if (!is_numeric($GLOBALS["attendance"]->idatt->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "attendance") {
				if ($this->idatt->CurrentValue == "")
					$this->idatt->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("datatemplist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_idemp":
					$lookupFilter = function() {
						return "`idtype`=1 and `idstatus`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_dept":
					break;
				case "x_type":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_idemp":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_dept":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_type":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

		$this->tauxh->ReadOnly = TRUE;
		$this->nbrheur->ReadOnly = TRUE;
		$this->dept->ReadOnly = TRUE;
		$this->type->ReadOnly = TRUE;
		$this->SubTotal->ReadOnly = TRUE;
	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>