<?php namespace PHPMaker2020\intextdesign_proj_v0; ?>
<?php

/**
 * Table class for datatemp
 */
class datatemp extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $iddt;
	public $datejob;
	public $idemp;
	public $dept;
	public $type;
	public $nbrheur;
	public $tauxh;
	public $SubTotal;
	public $idatt;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'datatemp';
		$this->TableName = 'datatemp';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`datatemp`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = TRUE; // Allow detail add
		$this->DetailEdit = TRUE; // Allow detail edit
		$this->DetailView = TRUE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// iddt
		$this->iddt = new DbField('datatemp', 'datatemp', 'x_iddt', 'iddt', '`iddt`', '`iddt`', 3, 11, -1, FALSE, '`iddt`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->iddt->IsAutoIncrement = TRUE; // Autoincrement field
		$this->iddt->IsPrimaryKey = TRUE; // Primary key field
		$this->iddt->Sortable = TRUE; // Allow sort
		$this->iddt->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['iddt'] = &$this->iddt;

		// datejob
		$this->datejob = new DbField('datatemp', 'datatemp', 'x_datejob', 'datejob', '`datejob`', CastDateFieldForLike("`datejob`", 7, "DB"), 133, 10, 7, FALSE, '`datejob`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datejob->Required = TRUE; // Required field
		$this->datejob->Sortable = TRUE; // Allow sort
		$this->datejob->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['datejob'] = &$this->datejob;

		// idemp
		$this->idemp = new DbField('datatemp', 'datatemp', 'x_idemp', 'idemp', '`idemp`', '`idemp`', 3, 11, -1, FALSE, '`idemp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->idemp->Nullable = FALSE; // NOT NULL field
		$this->idemp->Required = TRUE; // Required field
		$this->idemp->Sortable = TRUE; // Allow sort
		$this->idemp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->idemp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->idemp->Lookup = new Lookup('idemp', 'employee', FALSE, 'idemp', ["noemp","lastname","firstname",""], [], [], [], [], ["basicsalary","iddep","idtype"], ["x_tauxh","x_dept","x_type"], '', '');
				break;
			default:
				$this->idemp->Lookup = new Lookup('idemp', 'employee', FALSE, 'idemp', ["noemp","lastname","firstname",""], [], [], [], [], ["basicsalary","iddep","idtype"], ["x_tauxh","x_dept","x_type"], '', '');
				break;
		}
		$this->idemp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idemp'] = &$this->idemp;

		// dept
		$this->dept = new DbField('datatemp', 'datatemp', 'x_dept', 'dept', '`dept`', '`dept`', 3, 11, -1, FALSE, '`dept`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dept->Nullable = FALSE; // NOT NULL field
		$this->dept->Required = TRUE; // Required field
		$this->dept->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "en":
				$this->dept->Lookup = new Lookup('dept', 'deptement', FALSE, 'iddep', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->dept->Lookup = new Lookup('dept', 'deptement', FALSE, 'iddep', ["ident","descrip","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->dept->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['dept'] = &$this->dept;

		// type
		$this->type = new DbField('datatemp', 'datatemp', 'x_type', 'type', '`type`', '`type`', 3, 11, -1, FALSE, '`type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->type->Nullable = FALSE; // NOT NULL field
		$this->type->Required = TRUE; // Required field
		$this->type->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "en":
				$this->type->Lookup = new Lookup('type', 'type', FALSE, 'idtype', ["ident","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->type->Lookup = new Lookup('type', 'type', FALSE, 'idtype', ["ident","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['type'] = &$this->type;

		// nbrheur
		$this->nbrheur = new DbField('datatemp', 'datatemp', 'x_nbrheur', 'nbrheur', '`nbrheur`', '`nbrheur`', 3, 11, -1, FALSE, '`nbrheur`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nbrheur->Nullable = FALSE; // NOT NULL field
		$this->nbrheur->Required = TRUE; // Required field
		$this->nbrheur->Sortable = TRUE; // Allow sort
		$this->nbrheur->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['nbrheur'] = &$this->nbrheur;

		// tauxh
		$this->tauxh = new DbField('datatemp', 'datatemp', 'x_tauxh', 'tauxh', '`tauxh`', '`tauxh`', 131, 15, -1, FALSE, '`tauxh`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tauxh->Nullable = FALSE; // NOT NULL field
		$this->tauxh->Required = TRUE; // Required field
		$this->tauxh->Sortable = TRUE; // Allow sort
		$this->tauxh->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tauxh'] = &$this->tauxh;

		// SubTotal
		$this->SubTotal = new DbField('datatemp', 'datatemp', 'x_SubTotal', 'SubTotal', '`nbrheur` * `tauxh`', '`nbrheur` * `tauxh`', 131, 25, -1, FALSE, '`nbrheur` * `tauxh`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SubTotal->IsCustom = TRUE; // Custom field
		$this->SubTotal->Sortable = TRUE; // Allow sort
		$this->SubTotal->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['SubTotal'] = &$this->SubTotal;

		// idatt
		$this->idatt = new DbField('datatemp', 'datatemp', 'x_idatt', 'idatt', '`idatt`', '`idatt`', 3, 11, -1, FALSE, '`idatt`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idatt->IsForeignKey = TRUE; // Foreign key field
		$this->idatt->Nullable = FALSE; // NOT NULL field
		$this->idatt->Required = TRUE; // Required field
		$this->idatt->Sortable = TRUE; // Allow sort
		$this->idatt->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idatt'] = &$this->idatt;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "attendance") {
			if ($this->idatt->getSessionValue() != "")
				$masterFilter .= "`idatt`=" . QuotedValue($this->idatt->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "attendance") {
			if ($this->idatt->getSessionValue() != "")
				$detailFilter .= "`idatt`=" . QuotedValue($this->idatt->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_attendance()
	{
		return "`idatt`=@idatt@";
	}

	// Detail filter
	public function sqlDetailFilter_attendance()
	{
		return "`idatt`=@idatt@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`datatemp`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT *, `nbrheur` * `tauxh` AS `SubTotal` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->iddt->setDbValue($conn->insert_ID());
			$rs['iddt'] = $this->iddt->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('iddt', $rs))
				AddFilter($where, QuotedName('iddt', $this->Dbid) . '=' . QuotedValue($rs['iddt'], $this->iddt->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->iddt->DbValue = $row['iddt'];
		$this->datejob->DbValue = $row['datejob'];
		$this->idemp->DbValue = $row['idemp'];
		$this->dept->DbValue = $row['dept'];
		$this->type->DbValue = $row['type'];
		$this->nbrheur->DbValue = $row['nbrheur'];
		$this->tauxh->DbValue = $row['tauxh'];
		$this->SubTotal->DbValue = $row['SubTotal'];
		$this->idatt->DbValue = $row['idatt'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`iddt` = @iddt@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('iddt', $row) ? $row['iddt'] : NULL;
		else
			$val = $this->iddt->OldValue !== NULL ? $this->iddt->OldValue : $this->iddt->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@iddt@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "datatemplist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "datatempview.php")
			return $Language->phrase("View");
		elseif ($pageName == "datatempedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "datatempadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "datatemplist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("datatempview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("datatempview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "datatempadd.php?" . $this->getUrlParm($parm);
		else
			$url = "datatempadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("datatempedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("datatempadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("datatempdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "attendance" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_idatt=" . urlencode($this->idatt->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "iddt:" . JsonEncode($this->iddt->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->iddt->CurrentValue != NULL) {
			$url .= "iddt=" . urlencode($this->iddt->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("iddt") !== NULL)
				$arKeys[] = Param("iddt");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->iddt->CurrentValue = $key;
			else
				$this->iddt->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->iddt->setDbValue($rs->fields('iddt'));
		$this->datejob->setDbValue($rs->fields('datejob'));
		$this->idemp->setDbValue($rs->fields('idemp'));
		$this->dept->setDbValue($rs->fields('dept'));
		$this->type->setDbValue($rs->fields('type'));
		$this->nbrheur->setDbValue($rs->fields('nbrheur'));
		$this->tauxh->setDbValue($rs->fields('tauxh'));
		$this->SubTotal->setDbValue($rs->fields('SubTotal'));
		$this->idatt->setDbValue($rs->fields('idatt'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// iddt

		$this->iddt->CellCssStyle = "width: 4px;";

		// datejob
		$this->datejob->CellCssStyle = "width: 8px;";

		// idemp
		// dept

		$this->dept->CellCssStyle = "width: 30px;";

		// type
		$this->type->CellCssStyle = "width: 1px;";

		// nbrheur
		$this->nbrheur->CellCssStyle = "width: 2px;";

		// tauxh
		$this->tauxh->CellCssStyle = "width: 5px;";

		// SubTotal
		$this->SubTotal->CellCssStyle = "width: 5px;";

		// idatt
		// iddt

		$this->iddt->ViewValue = $this->iddt->CurrentValue;
		$this->iddt->ViewCustomAttributes = "";

		// datejob
		$this->datejob->ViewValue = $this->datejob->CurrentValue;
		$this->datejob->ViewValue = FormatDateTime($this->datejob->ViewValue, 7);
		$this->datejob->ViewCustomAttributes = "";

		// idemp
		$curVal = strval($this->idemp->CurrentValue);
		if ($curVal != "") {
			$this->idemp->ViewValue = $this->idemp->lookupCacheOption($curVal);
			if ($this->idemp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`idemp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`idtype`=1 and `idstatus`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->idemp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->idemp->ViewValue = $this->idemp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->idemp->ViewValue = $this->idemp->CurrentValue;
				}
			}
		} else {
			$this->idemp->ViewValue = NULL;
		}
		$this->idemp->ViewCustomAttributes = "";

		// dept
		$this->dept->ViewValue = $this->dept->CurrentValue;
		$curVal = strval($this->dept->CurrentValue);
		if ($curVal != "") {
			$this->dept->ViewValue = $this->dept->lookupCacheOption($curVal);
			if ($this->dept->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`iddep`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->dept->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->dept->ViewValue = $this->dept->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->dept->ViewValue = $this->dept->CurrentValue;
				}
			}
		} else {
			$this->dept->ViewValue = NULL;
		}
		$this->dept->ViewCustomAttributes = "";

		// type
		$this->type->ViewValue = $this->type->CurrentValue;
		$curVal = strval($this->type->CurrentValue);
		if ($curVal != "") {
			$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
			if ($this->type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`idtype`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->type->ViewValue = $this->type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->type->ViewValue = $this->type->CurrentValue;
				}
			}
		} else {
			$this->type->ViewValue = NULL;
		}
		$this->type->CellCssStyle .= "text-align: center;";
		$this->type->ViewCustomAttributes = "";

		// nbrheur
		$this->nbrheur->ViewValue = $this->nbrheur->CurrentValue;
		$this->nbrheur->ViewValue = FormatNumber($this->nbrheur->ViewValue, 0, -2, -2, -2);
		$this->nbrheur->CellCssStyle .= "text-align: center;";
		$this->nbrheur->ViewCustomAttributes = "";

		// tauxh
		$this->tauxh->ViewValue = $this->tauxh->CurrentValue;
		$this->tauxh->ViewValue = FormatCurrency($this->tauxh->ViewValue, 2, -2, -2, -2);
		$this->tauxh->ViewCustomAttributes = "";

		// SubTotal
		$this->SubTotal->ViewValue = $this->SubTotal->CurrentValue;
		$this->SubTotal->ViewValue = FormatNumber($this->SubTotal->ViewValue, 2, -2, -2, -2);
		$this->SubTotal->ViewCustomAttributes = "";

		// idatt
		$this->idatt->ViewValue = $this->idatt->CurrentValue;
		$this->idatt->ViewValue = FormatNumber($this->idatt->ViewValue, 0, -2, -2, -2);
		$this->idatt->ViewCustomAttributes = "";

		// iddt
		$this->iddt->LinkCustomAttributes = "";
		$this->iddt->HrefValue = "";
		$this->iddt->TooltipValue = "";

		// datejob
		$this->datejob->LinkCustomAttributes = "";
		$this->datejob->HrefValue = "";
		$this->datejob->TooltipValue = "";

		// idemp
		$this->idemp->LinkCustomAttributes = "";
		$this->idemp->HrefValue = "";
		$this->idemp->TooltipValue = "";

		// dept
		$this->dept->LinkCustomAttributes = "";
		$this->dept->HrefValue = "";
		$this->dept->TooltipValue = "";

		// type
		$this->type->LinkCustomAttributes = "";
		$this->type->HrefValue = "";
		$this->type->TooltipValue = "";

		// nbrheur
		$this->nbrheur->LinkCustomAttributes = "";
		$this->nbrheur->HrefValue = "";
		$this->nbrheur->TooltipValue = "";

		// tauxh
		$this->tauxh->LinkCustomAttributes = "";
		$this->tauxh->HrefValue = "";
		$this->tauxh->TooltipValue = "";

		// SubTotal
		$this->SubTotal->LinkCustomAttributes = "";
		$this->SubTotal->HrefValue = "";
		$this->SubTotal->TooltipValue = "";

		// idatt
		$this->idatt->LinkCustomAttributes = "";
		$this->idatt->HrefValue = "";
		$this->idatt->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// iddt
		$this->iddt->EditAttrs["class"] = "form-control";
		$this->iddt->EditCustomAttributes = "";
		$this->iddt->EditValue = $this->iddt->CurrentValue;
		$this->iddt->ViewCustomAttributes = "";

		// datejob
		$this->datejob->EditAttrs["class"] = "form-control";
		$this->datejob->EditCustomAttributes = "";
		$this->datejob->EditValue = FormatDateTime($this->datejob->CurrentValue, 7);
		$this->datejob->PlaceHolder = RemoveHtml($this->datejob->caption());

		// idemp
		$this->idemp->EditAttrs["class"] = "form-control";
		$this->idemp->EditCustomAttributes = "";

		// dept
		$this->dept->EditAttrs["class"] = "form-control";
		$this->dept->EditCustomAttributes = "";
		$this->dept->EditValue = $this->dept->CurrentValue;
		$this->dept->PlaceHolder = RemoveHtml($this->dept->caption());

		// type
		$this->type->EditAttrs["class"] = "form-control";
		$this->type->EditCustomAttributes = "";
		$this->type->EditValue = $this->type->CurrentValue;
		$this->type->PlaceHolder = RemoveHtml($this->type->caption());

		// nbrheur
		$this->nbrheur->EditAttrs["class"] = "form-control";
		$this->nbrheur->EditCustomAttributes = "";
		$this->nbrheur->EditValue = $this->nbrheur->CurrentValue;
		$this->nbrheur->PlaceHolder = RemoveHtml($this->nbrheur->caption());

		// tauxh
		$this->tauxh->EditAttrs["class"] = "form-control";
		$this->tauxh->EditCustomAttributes = "";
		$this->tauxh->EditValue = $this->tauxh->CurrentValue;
		$this->tauxh->PlaceHolder = RemoveHtml($this->tauxh->caption());
		if (strval($this->tauxh->EditValue) != "" && is_numeric($this->tauxh->EditValue))
			$this->tauxh->EditValue = FormatNumber($this->tauxh->EditValue, -2, -2, -2, -2);
		

		// SubTotal
		$this->SubTotal->EditAttrs["class"] = "form-control";
		$this->SubTotal->EditCustomAttributes = "";
		$this->SubTotal->EditValue = $this->SubTotal->CurrentValue;
		$this->SubTotal->PlaceHolder = RemoveHtml($this->SubTotal->caption());
		if (strval($this->SubTotal->EditValue) != "" && is_numeric($this->SubTotal->EditValue))
			$this->SubTotal->EditValue = FormatNumber($this->SubTotal->EditValue, -2, -2, -2, -2);
		

		// idatt
		$this->idatt->EditAttrs["class"] = "form-control";
		$this->idatt->EditCustomAttributes = "";
		if ($this->idatt->getSessionValue() != "") {
			$this->idatt->CurrentValue = $this->idatt->getSessionValue();
			$this->idatt->ViewValue = $this->idatt->CurrentValue;
			$this->idatt->ViewValue = FormatNumber($this->idatt->ViewValue, 0, -2, -2, -2);
			$this->idatt->ViewCustomAttributes = "";
		} else {
			$this->idatt->EditValue = $this->idatt->CurrentValue;
			$this->idatt->PlaceHolder = RemoveHtml($this->idatt->caption());
		}

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			$this->idemp->Count++; // Increment count
			if (is_numeric($this->SubTotal->CurrentValue))
				$this->SubTotal->Total += $this->SubTotal->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->idemp->CurrentValue = $this->idemp->Count;
			$this->idemp->ViewValue = $this->idemp->CurrentValue;
			$this->idemp->ViewCustomAttributes = "";
			$this->idemp->HrefValue = ""; // Clear href value
			$this->SubTotal->CurrentValue = $this->SubTotal->Total;
			$this->SubTotal->ViewValue = $this->SubTotal->CurrentValue;
			$this->SubTotal->ViewValue = FormatNumber($this->SubTotal->ViewValue, 2, -2, -2, -2);
			$this->SubTotal->ViewCustomAttributes = "";
			$this->SubTotal->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->iddt);
					$doc->exportCaption($this->datejob);
					$doc->exportCaption($this->idemp);
					$doc->exportCaption($this->dept);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->nbrheur);
					$doc->exportCaption($this->tauxh);
					$doc->exportCaption($this->SubTotal);
				} else {
					$doc->exportCaption($this->iddt);
					$doc->exportCaption($this->datejob);
					$doc->exportCaption($this->idemp);
					$doc->exportCaption($this->dept);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->nbrheur);
					$doc->exportCaption($this->tauxh);
					$doc->exportCaption($this->SubTotal);
					$doc->exportCaption($this->idatt);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->iddt);
						$doc->exportField($this->datejob);
						$doc->exportField($this->idemp);
						$doc->exportField($this->dept);
						$doc->exportField($this->type);
						$doc->exportField($this->nbrheur);
						$doc->exportField($this->tauxh);
						$doc->exportField($this->SubTotal);
					} else {
						$doc->exportField($this->iddt);
						$doc->exportField($this->datejob);
						$doc->exportField($this->idemp);
						$doc->exportField($this->dept);
						$doc->exportField($this->type);
						$doc->exportField($this->nbrheur);
						$doc->exportField($this->tauxh);
						$doc->exportField($this->SubTotal);
						$doc->exportField($this->idatt);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->iddt, '');
				$doc->exportAggregate($this->datejob, '');
				$doc->exportAggregate($this->idemp, 'COUNT');
				$doc->exportAggregate($this->dept, '');
				$doc->exportAggregate($this->type, '');
				$doc->exportAggregate($this->nbrheur, '');
				$doc->exportAggregate($this->tauxh, '');
				$doc->exportAggregate($this->SubTotal, 'TOTAL');
				$doc->exportAggregate($this->idatt, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

		 $this->Cyl->CellAttrs["style"] = "background-color: #ffcc99";
	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>