<?php namespace PHPMaker2020\intextdesign_proj_v0; ?>
<?php

/**
 * Table class for attendancedetail
 */
class attendancedetail extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $idattdetail;
	public $dateattdetail;
	public $idemp;
	public $type;
	public $dept;
	public $statut;
	public $idatt;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'attendancedetail';
		$this->TableName = 'attendancedetail';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`attendancedetail`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// idattdetail
		$this->idattdetail = new DbField('attendancedetail', 'attendancedetail', 'x_idattdetail', 'idattdetail', '`idattdetail`', '`idattdetail`', 3, 11, -1, FALSE, '`idattdetail`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->idattdetail->IsAutoIncrement = TRUE; // Autoincrement field
		$this->idattdetail->IsPrimaryKey = TRUE; // Primary key field
		$this->idattdetail->Sortable = TRUE; // Allow sort
		$this->idattdetail->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idattdetail'] = &$this->idattdetail;

		// dateattdetail
		$this->dateattdetail = new DbField('attendancedetail', 'attendancedetail', 'x_dateattdetail', 'dateattdetail', '`dateattdetail`', CastDateFieldForLike("`dateattdetail`", 7, "DB"), 133, 10, 7, FALSE, '`dateattdetail`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dateattdetail->Nullable = FALSE; // NOT NULL field
		$this->dateattdetail->Required = TRUE; // Required field
		$this->dateattdetail->Sortable = TRUE; // Allow sort
		$this->dateattdetail->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['dateattdetail'] = &$this->dateattdetail;

		// idemp
		$this->idemp = new DbField('attendancedetail', 'attendancedetail', 'x_idemp', 'idemp', '`idemp`', '`idemp`', 3, 11, -1, FALSE, '`EV__idemp`', TRUE, TRUE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->idemp->Nullable = FALSE; // NOT NULL field
		$this->idemp->Required = TRUE; // Required field
		$this->idemp->Sortable = TRUE; // Allow sort
		$this->idemp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->idemp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->idemp->Lookup = new Lookup('idemp', 'employee', FALSE, 'idemp', ["noemp","lastname","firstname","idtype"], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->idemp->Lookup = new Lookup('idemp', 'employee', FALSE, 'idemp', ["noemp","lastname","firstname","idtype"], [], [], [], [], [], [], '', '');
				break;
		}
		$this->idemp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idemp'] = &$this->idemp;

		// type
		$this->type = new DbField('attendancedetail', 'attendancedetail', 'x_type', 'type', '\'\'', '\'\'', 201, 65530, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->type->IsCustom = TRUE; // Custom field
		$this->type->Sortable = TRUE; // Allow sort
		$this->type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->type->Lookup = new Lookup('type', 'type', FALSE, 'idtype', ["ident","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->type->Lookup = new Lookup('type', 'type', FALSE, 'idtype', ["ident","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->fields['type'] = &$this->type;

		// dept
		$this->dept = new DbField('attendancedetail', 'attendancedetail', 'x_dept', 'dept', '\'\'', '\'\'', 201, 65530, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->dept->IsCustom = TRUE; // Custom field
		$this->dept->Sortable = TRUE; // Allow sort
		$this->dept->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->dept->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		switch ($CurrentLanguage) {
			case "en":
				$this->dept->Lookup = new Lookup('dept', 'deptement', FALSE, 'iddep', ["ident","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->dept->Lookup = new Lookup('dept', 'deptement', FALSE, 'iddep', ["ident","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->fields['dept'] = &$this->dept;

		// statut
		$this->statut = new DbField('attendancedetail', 'attendancedetail', 'x_statut', 'statut', '`statut`', '`statut`', 202, 1, -1, FALSE, '`statut`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->statut->Nullable = FALSE; // NOT NULL field
		$this->statut->Required = TRUE; // Required field
		$this->statut->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "en":
				$this->statut->Lookup = new Lookup('statut', 'attendancedetail', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->statut->Lookup = new Lookup('statut', 'attendancedetail', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->statut->OptionCount = 3;
		$this->fields['statut'] = &$this->statut;

		// idatt
		$this->idatt = new DbField('attendancedetail', 'attendancedetail', 'x_idatt', 'idatt', '`idatt`', '`idatt`', 3, 11, -1, FALSE, '`idatt`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idatt->IsForeignKey = TRUE; // Foreign key field
		$this->idatt->Nullable = FALSE; // NOT NULL field
		$this->idatt->Required = TRUE; // Required field
		$this->idatt->Sortable = TRUE; // Allow sort
		$this->idatt->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['idatt'] = &$this->idatt;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "attendance") {
			if ($this->idatt->getSessionValue() != "")
				$masterFilter .= "`idatt`=" . QuotedValue($this->idatt->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "attendance") {
			if ($this->idatt->getSessionValue() != "")
				$detailFilter .= "`idatt`=" . QuotedValue($this->idatt->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_attendance()
	{
		return "`idatt`=@idatt@";
	}

	// Detail filter
	public function sqlDetailFilter_attendance()
	{
		return "`idatt`=@idatt@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "`attendancedetail`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT *, '' AS `type`, '' AS `dept` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, '' AS `type`, '' AS `dept`, (SELECT CONCAT(COALESCE(`noemp`, ''),'" . ValueSeparator(1, $this->idemp) . "',COALESCE(`lastname`,''),'" . ValueSeparator(2, $this->idemp) . "',COALESCE(`firstname`,''),'" . ValueSeparator(3, $this->idemp) . "',COALESCE(`idtype`,'')) FROM `employee` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`idemp` = `attendancedetail`.`idemp` LIMIT 1) AS `EV__idemp` FROM `attendancedetail`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList != "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "`dateattdetail` ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where != "")
			$where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
		if ($orderBy != "")
			$orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() != "")
			return TRUE;
		if (ContainsString($orderBy, " " . $this->idemp->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->idattdetail->setDbValue($conn->insert_ID());
			$rs['idattdetail'] = $this->idattdetail->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('idattdetail', $rs))
				AddFilter($where, QuotedName('idattdetail', $this->Dbid) . '=' . QuotedValue($rs['idattdetail'], $this->idattdetail->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->idattdetail->DbValue = $row['idattdetail'];
		$this->dateattdetail->DbValue = $row['dateattdetail'];
		$this->idemp->DbValue = $row['idemp'];
		$this->type->DbValue = $row['type'];
		$this->dept->DbValue = $row['dept'];
		$this->statut->DbValue = $row['statut'];
		$this->idatt->DbValue = $row['idatt'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`idattdetail` = @idattdetail@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('idattdetail', $row) ? $row['idattdetail'] : NULL;
		else
			$val = $this->idattdetail->OldValue !== NULL ? $this->idattdetail->OldValue : $this->idattdetail->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@idattdetail@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "attendancedetaillist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "attendancedetailview.php")
			return $Language->phrase("View");
		elseif ($pageName == "attendancedetailedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "attendancedetailadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "attendancedetaillist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("attendancedetailview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("attendancedetailview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "attendancedetailadd.php?" . $this->getUrlParm($parm);
		else
			$url = "attendancedetailadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("attendancedetailedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("attendancedetailadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("attendancedetaildelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "attendance" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_idatt=" . urlencode($this->idatt->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "idattdetail:" . JsonEncode($this->idattdetail->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->idattdetail->CurrentValue != NULL) {
			$url .= "idattdetail=" . urlencode($this->idattdetail->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("idattdetail") !== NULL)
				$arKeys[] = Param("idattdetail");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->idattdetail->CurrentValue = $key;
			else
				$this->idattdetail->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->idattdetail->setDbValue($rs->fields('idattdetail'));
		$this->dateattdetail->setDbValue($rs->fields('dateattdetail'));
		$this->idemp->setDbValue($rs->fields('idemp'));
		$this->type->setDbValue($rs->fields('type'));
		$this->dept->setDbValue($rs->fields('dept'));
		$this->statut->setDbValue($rs->fields('statut'));
		$this->idatt->setDbValue($rs->fields('idatt'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// idattdetail
		// dateattdetail
		// idemp
		// type
		// dept
		// statut
		// idatt
		// idattdetail

		$this->idattdetail->ViewValue = $this->idattdetail->CurrentValue;
		$this->idattdetail->ViewCustomAttributes = "";

		// dateattdetail
		$this->dateattdetail->ViewValue = $this->dateattdetail->CurrentValue;
		$this->dateattdetail->ViewValue = FormatDateTime($this->dateattdetail->ViewValue, 7);
		$this->dateattdetail->ViewCustomAttributes = "";

		// idemp
		if ($this->idemp->VirtualValue != "") {
			$this->idemp->ViewValue = $this->idemp->VirtualValue;
		} else {
			$curVal = strval($this->idemp->CurrentValue);
			if ($curVal != "") {
				$this->idemp->ViewValue = $this->idemp->lookupCacheOption($curVal);
				if ($this->idemp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`idemp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`idstatus`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->idemp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2);
						$this->idemp->ViewValue = $this->idemp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idemp->ViewValue = $this->idemp->CurrentValue;
					}
				}
			} else {
				$this->idemp->ViewValue = NULL;
			}
		}
		$this->idemp->ViewCustomAttributes = "";

		// type
		$curVal = strval($this->type->CurrentValue);
		if ($curVal != "") {
			$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
			if ($this->type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`idtype`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->type->ViewValue = $this->type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->type->ViewValue = $this->type->CurrentValue;
				}
			}
		} else {
			$this->type->ViewValue = NULL;
		}
		$this->type->ViewCustomAttributes = "";

		// dept
		$curVal = strval($this->dept->CurrentValue);
		if ($curVal != "") {
			$this->dept->ViewValue = $this->dept->lookupCacheOption($curVal);
			if ($this->dept->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`iddep`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->dept->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$this->dept->ViewValue = $this->dept->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->dept->ViewValue = $this->dept->CurrentValue;
				}
			}
		} else {
			$this->dept->ViewValue = NULL;
		}
		$this->dept->ViewCustomAttributes = "";

		// statut
		if (strval($this->statut->CurrentValue) != "") {
			$this->statut->ViewValue = $this->statut->optionCaption($this->statut->CurrentValue);
		} else {
			$this->statut->ViewValue = NULL;
		}
		$this->statut->ViewCustomAttributes = "";

		// idatt
		$this->idatt->ViewValue = $this->idatt->CurrentValue;
		$this->idatt->ViewValue = FormatNumber($this->idatt->ViewValue, 0, -2, -2, -2);
		$this->idatt->ViewCustomAttributes = "";

		// idattdetail
		$this->idattdetail->LinkCustomAttributes = "";
		$this->idattdetail->HrefValue = "";
		$this->idattdetail->TooltipValue = "";

		// dateattdetail
		$this->dateattdetail->LinkCustomAttributes = "";
		$this->dateattdetail->HrefValue = "";
		$this->dateattdetail->TooltipValue = "";

		// idemp
		$this->idemp->LinkCustomAttributes = "";
		$this->idemp->HrefValue = "";
		$this->idemp->TooltipValue = "";

		// type
		$this->type->LinkCustomAttributes = "";
		$this->type->HrefValue = "";
		$this->type->TooltipValue = "";

		// dept
		$this->dept->LinkCustomAttributes = "";
		$this->dept->HrefValue = "";
		$this->dept->TooltipValue = "";

		// statut
		$this->statut->LinkCustomAttributes = "";
		$this->statut->HrefValue = "";
		$this->statut->TooltipValue = "";

		// idatt
		$this->idatt->LinkCustomAttributes = "";
		$this->idatt->HrefValue = "";
		$this->idatt->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// idattdetail
		$this->idattdetail->EditAttrs["class"] = "form-control";
		$this->idattdetail->EditCustomAttributes = "";
		$this->idattdetail->EditValue = $this->idattdetail->CurrentValue;
		$this->idattdetail->ViewCustomAttributes = "";

		// dateattdetail
		$this->dateattdetail->EditAttrs["class"] = "form-control";
		$this->dateattdetail->EditCustomAttributes = "";
		$this->dateattdetail->EditValue = FormatDateTime($this->dateattdetail->CurrentValue, 7);
		$this->dateattdetail->PlaceHolder = RemoveHtml($this->dateattdetail->caption());

		// idemp
		$this->idemp->EditAttrs["class"] = "form-control";
		$this->idemp->EditCustomAttributes = "";
		if ($this->idemp->VirtualValue != "") {
			$this->idemp->EditValue = $this->idemp->VirtualValue;
		} else {
			$curVal = strval($this->idemp->CurrentValue);
			if ($curVal != "") {
				$this->idemp->EditValue = $this->idemp->lookupCacheOption($curVal);
				if ($this->idemp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`idemp`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`idstatus`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->idemp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2);
						$this->idemp->EditValue = $this->idemp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->idemp->EditValue = $this->idemp->CurrentValue;
					}
				}
			} else {
				$this->idemp->EditValue = NULL;
			}
		}
		$this->idemp->ViewCustomAttributes = "";

		// type
		$this->type->EditAttrs["class"] = "form-control";
		$this->type->EditCustomAttributes = "";

		// dept
		$this->dept->EditAttrs["class"] = "form-control";
		$this->dept->EditCustomAttributes = "";

		// statut
		$this->statut->EditCustomAttributes = "";
		$this->statut->EditValue = $this->statut->options(FALSE);

		// idatt
		$this->idatt->EditAttrs["class"] = "form-control";
		$this->idatt->EditCustomAttributes = "";
		if ($this->idatt->getSessionValue() != "") {
			$this->idatt->CurrentValue = $this->idatt->getSessionValue();
			$this->idatt->ViewValue = $this->idatt->CurrentValue;
			$this->idatt->ViewValue = FormatNumber($this->idatt->ViewValue, 0, -2, -2, -2);
			$this->idatt->ViewCustomAttributes = "";
		} else {
			$this->idatt->EditValue = $this->idatt->CurrentValue;
			$this->idatt->PlaceHolder = RemoveHtml($this->idatt->caption());
		}

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->idattdetail);
					$doc->exportCaption($this->dateattdetail);
					$doc->exportCaption($this->idemp);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->dept);
					$doc->exportCaption($this->statut);
					$doc->exportCaption($this->idatt);
				} else {
					$doc->exportCaption($this->idattdetail);
					$doc->exportCaption($this->dateattdetail);
					$doc->exportCaption($this->idemp);
					$doc->exportCaption($this->statut);
					$doc->exportCaption($this->idatt);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->idattdetail);
						$doc->exportField($this->dateattdetail);
						$doc->exportField($this->idemp);
						$doc->exportField($this->type);
						$doc->exportField($this->dept);
						$doc->exportField($this->statut);
						$doc->exportField($this->idatt);
					} else {
						$doc->exportField($this->idattdetail);
						$doc->exportField($this->dateattdetail);
						$doc->exportField($this->idemp);
						$doc->exportField($this->statut);
						$doc->exportField($this->idatt);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	if($this->idemp->CurrentValue!=""){// METTRE CONDITION POUR DIRE IF ROWS

	//affiche type
	$rsqla1="SELECT idtype FROM employee WHERE  employee.idemp=".$this->idemp->CurrentValue; 
	$vala1= ExecuteScalar($rsqla1);
	$this->type->CurrentValue=$vala1;

	//affiche dept
	$rsqla="SELECT iddep FROM employee WHERE  employee.idemp=".$this->idemp->CurrentValue; 
	$vala= ExecuteScalar($rsqla);
	$this->dept->CurrentValue=$vala;
	}
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>