<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$category_view = new category_view();

// Run the page
$category_view->run();

// Setup login status
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$category_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$category_view->isExport()) { ?>
<script>
var fcategoryview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fcategoryview = currentForm = new ew.Form("fcategoryview", "view");
	loadjs.done("fcategoryview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$category_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $category_view->ExportOptions->render("body") ?>
<?php $category_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $category_view->showPageHeader(); ?>
<?php
$category_view->showMessage();
?>
<?php if (!$category_view->IsModal) { ?>
<?php if (!$category_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $category_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fcategoryview" id="fcategoryview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="category">
<input type="hidden" name="modal" value="<?php echo (int)$category_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($category_view->idcat->Visible) { // idcat ?>
	<tr id="r_idcat">
		<td class="<?php echo $category_view->TableLeftColumnClass ?>"><span id="elh_category_idcat"><?php echo $category_view->idcat->caption() ?></span></td>
		<td data-name="idcat" <?php echo $category_view->idcat->cellAttributes() ?>>
<span id="el_category_idcat">
<span<?php echo $category_view->idcat->viewAttributes() ?>><?php echo $category_view->idcat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($category_view->ident->Visible) { // ident ?>
	<tr id="r_ident">
		<td class="<?php echo $category_view->TableLeftColumnClass ?>"><span id="elh_category_ident"><?php echo $category_view->ident->caption() ?></span></td>
		<td data-name="ident" <?php echo $category_view->ident->cellAttributes() ?>>
<span id="el_category_ident">
<span<?php echo $category_view->ident->viewAttributes() ?>><?php echo $category_view->ident->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($category_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $category_view->TableLeftColumnClass ?>"><span id="elh_category_descrip"><?php echo $category_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $category_view->descrip->cellAttributes() ?>>
<span id="el_category_descrip">
<span<?php echo $category_view->descrip->viewAttributes() ?>><?php echo $category_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$category_view->IsModal) { ?>
<?php if (!$category_view->isExport()) { ?>
<?php echo $category_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$category_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$category_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$category_view->terminate();
?>