<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$attendance_view = new attendance_view();

// Run the page
$attendance_view->run();

// Setup login status
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attendance_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$attendance_view->isExport()) { ?>
<script>
var fattendanceview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fattendanceview = currentForm = new ew.Form("fattendanceview", "view");
	loadjs.done("fattendanceview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$attendance_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $attendance_view->ExportOptions->render("body") ?>
<?php $attendance_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $attendance_view->showPageHeader(); ?>
<?php
$attendance_view->showMessage();
?>
<?php if (!$attendance_view->IsModal) { ?>
<?php if (!$attendance_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $attendance_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fattendanceview" id="fattendanceview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="attendance">
<input type="hidden" name="modal" value="<?php echo (int)$attendance_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($attendance_view->idatt->Visible) { // idatt ?>
	<tr id="r_idatt">
		<td class="<?php echo $attendance_view->TableLeftColumnClass ?>"><span id="elh_attendance_idatt"><?php echo $attendance_view->idatt->caption() ?></span></td>
		<td data-name="idatt" <?php echo $attendance_view->idatt->cellAttributes() ?>>
<span id="el_attendance_idatt">
<span<?php echo $attendance_view->idatt->viewAttributes() ?>><?php echo $attendance_view->idatt->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($attendance_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $attendance_view->TableLeftColumnClass ?>"><span id="elh_attendance_descrip"><?php echo $attendance_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $attendance_view->descrip->cellAttributes() ?>>
<span id="el_attendance_descrip">
<span<?php echo $attendance_view->descrip->viewAttributes() ?>><?php echo $attendance_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($attendance_view->dateatt->Visible) { // dateatt ?>
	<tr id="r_dateatt">
		<td class="<?php echo $attendance_view->TableLeftColumnClass ?>"><span id="elh_attendance_dateatt"><?php echo $attendance_view->dateatt->caption() ?></span></td>
		<td data-name="dateatt" <?php echo $attendance_view->dateatt->cellAttributes() ?>>
<span id="el_attendance_dateatt">
<span<?php echo $attendance_view->dateatt->viewAttributes() ?>><?php echo $attendance_view->dateatt->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($attendance_view->note->Visible) { // note ?>
	<tr id="r_note">
		<td class="<?php echo $attendance_view->TableLeftColumnClass ?>"><span id="elh_attendance_note"><?php echo $attendance_view->note->caption() ?></span></td>
		<td data-name="note" <?php echo $attendance_view->note->cellAttributes() ?>>
<span id="el_attendance_note">
<span<?php echo $attendance_view->note->viewAttributes() ?>><?php echo $attendance_view->note->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$attendance_view->IsModal) { ?>
<?php if (!$attendance_view->isExport()) { ?>
<?php echo $attendance_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php
	if (in_array("datatemp", explode(",", $attendance->getCurrentDetailTable())) && $datatemp->DetailView) {
?>
<?php if ($attendance->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("datatemp", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $attendance_view->datatemp_Count, $Language->phrase("DetailCount")) ?></h4>
<?php } ?>
<?php include_once "datatempgrid.php" ?>
<?php } ?>
<?php
	if (in_array("attendancedetail", explode(",", $attendance->getCurrentDetailTable())) && $attendancedetail->DetailView) {
?>
<?php if ($attendance->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("attendancedetail", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $attendance_view->attendancedetail_Count, $Language->phrase("DetailCount")) ?></h4>
<?php } ?>
<?php include_once "attendancedetailgrid.php" ?>
<?php } ?>
<?php
	if (in_array("ej_datatemps", explode(",", $attendance->getCurrentDetailTable())) && $ej_datatemps->DetailView) {
?>
<?php if ($attendance->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("ej_datatemps", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $attendance_view->ej_datatemps_Count, $Language->phrase("DetailCount")) ?></h4>
<?php } ?>
<?php include_once "ej_datatempsgrid.php" ?>
<?php } ?>
</form>
<?php
$attendance_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$attendance_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$attendance_view->terminate();
?>