<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$attendance_list = new attendance_list();

// Run the page
$attendance_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attendance_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$attendance_list->isExport()) { ?>
<script>
var fattendancelist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fattendancelist = currentForm = new ew.Form("fattendancelist", "list");
	fattendancelist.formKeyCountName = '<?php echo $attendance_list->FormKeyCountName ?>';
	loadjs.done("fattendancelist");
});
var fattendancelistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fattendancelistsrch = currentSearchForm = new ew.Form("fattendancelistsrch");

	// Dynamic selection lists
	// Filters

	fattendancelistsrch.filterList = <?php echo $attendance_list->getFilterList() ?>;
	loadjs.done("fattendancelistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$attendance_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($attendance_list->TotalRecords > 0 && $attendance_list->ExportOptions->visible()) { ?>
<?php $attendance_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($attendance_list->ImportOptions->visible()) { ?>
<?php $attendance_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($attendance_list->SearchOptions->visible()) { ?>
<?php $attendance_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($attendance_list->FilterOptions->visible()) { ?>
<?php $attendance_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$attendance_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$attendance_list->isExport() && !$attendance->CurrentAction) { ?>
<form name="fattendancelistsrch" id="fattendancelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fattendancelistsrch-search-panel" class="<?php echo $attendance_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="attendance">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $attendance_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($attendance_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($attendance_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $attendance_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($attendance_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($attendance_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($attendance_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($attendance_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $attendance_list->showPageHeader(); ?>
<?php
$attendance_list->showMessage();
?>
<?php if ($attendance_list->TotalRecords > 0 || $attendance->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($attendance_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> attendance">
<?php if (!$attendance_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$attendance_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $attendance_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $attendance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fattendancelist" id="fattendancelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="attendance">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_attendance" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($attendance_list->TotalRecords > 0 || $attendance_list->isGridEdit()) { ?>
<table id="tbl_attendancelist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$attendance->RowType = ROWTYPE_HEADER;

// Render list options
$attendance_list->renderListOptions();

// Render list options (header, left)
$attendance_list->ListOptions->render("header", "left");
?>
<?php if ($attendance_list->idatt->Visible) { // idatt ?>
	<?php if ($attendance_list->SortUrl($attendance_list->idatt) == "") { ?>
		<th data-name="idatt" class="<?php echo $attendance_list->idatt->headerCellClass() ?>"><div id="elh_attendance_idatt" class="attendance_idatt"><div class="ew-table-header-caption"><?php echo $attendance_list->idatt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idatt" class="<?php echo $attendance_list->idatt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $attendance_list->SortUrl($attendance_list->idatt) ?>', 1);"><div id="elh_attendance_idatt" class="attendance_idatt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendance_list->idatt->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendance_list->idatt->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendance_list->idatt->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendance_list->descrip->Visible) { // descrip ?>
	<?php if ($attendance_list->SortUrl($attendance_list->descrip) == "") { ?>
		<th data-name="descrip" class="<?php echo $attendance_list->descrip->headerCellClass() ?>"><div id="elh_attendance_descrip" class="attendance_descrip"><div class="ew-table-header-caption"><?php echo $attendance_list->descrip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="descrip" class="<?php echo $attendance_list->descrip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $attendance_list->SortUrl($attendance_list->descrip) ?>', 1);"><div id="elh_attendance_descrip" class="attendance_descrip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendance_list->descrip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($attendance_list->descrip->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendance_list->descrip->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendance_list->dateatt->Visible) { // dateatt ?>
	<?php if ($attendance_list->SortUrl($attendance_list->dateatt) == "") { ?>
		<th data-name="dateatt" class="<?php echo $attendance_list->dateatt->headerCellClass() ?>"><div id="elh_attendance_dateatt" class="attendance_dateatt"><div class="ew-table-header-caption"><?php echo $attendance_list->dateatt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dateatt" class="<?php echo $attendance_list->dateatt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $attendance_list->SortUrl($attendance_list->dateatt) ?>', 1);"><div id="elh_attendance_dateatt" class="attendance_dateatt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendance_list->dateatt->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendance_list->dateatt->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendance_list->dateatt->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendance_list->note->Visible) { // note ?>
	<?php if ($attendance_list->SortUrl($attendance_list->note) == "") { ?>
		<th data-name="note" class="<?php echo $attendance_list->note->headerCellClass() ?>"><div id="elh_attendance_note" class="attendance_note"><div class="ew-table-header-caption"><?php echo $attendance_list->note->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="note" class="<?php echo $attendance_list->note->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $attendance_list->SortUrl($attendance_list->note) ?>', 1);"><div id="elh_attendance_note" class="attendance_note">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendance_list->note->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($attendance_list->note->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendance_list->note->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$attendance_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($attendance_list->ExportAll && $attendance_list->isExport()) {
	$attendance_list->StopRecord = $attendance_list->TotalRecords;
} else {

	// Set the last record to display
	if ($attendance_list->TotalRecords > $attendance_list->StartRecord + $attendance_list->DisplayRecords - 1)
		$attendance_list->StopRecord = $attendance_list->StartRecord + $attendance_list->DisplayRecords - 1;
	else
		$attendance_list->StopRecord = $attendance_list->TotalRecords;
}
$attendance_list->RecordCount = $attendance_list->StartRecord - 1;
if ($attendance_list->Recordset && !$attendance_list->Recordset->EOF) {
	$attendance_list->Recordset->moveFirst();
	$selectLimit = $attendance_list->UseSelectLimit;
	if (!$selectLimit && $attendance_list->StartRecord > 1)
		$attendance_list->Recordset->move($attendance_list->StartRecord - 1);
} elseif (!$attendance->AllowAddDeleteRow && $attendance_list->StopRecord == 0) {
	$attendance_list->StopRecord = $attendance->GridAddRowCount;
}

// Initialize aggregate
$attendance->RowType = ROWTYPE_AGGREGATEINIT;
$attendance->resetAttributes();
$attendance_list->renderRow();
while ($attendance_list->RecordCount < $attendance_list->StopRecord) {
	$attendance_list->RecordCount++;
	if ($attendance_list->RecordCount >= $attendance_list->StartRecord) {
		$attendance_list->RowCount++;

		// Set up key count
		$attendance_list->KeyCount = $attendance_list->RowIndex;

		// Init row class and style
		$attendance->resetAttributes();
		$attendance->CssClass = "";
		if ($attendance_list->isGridAdd()) {
		} else {
			$attendance_list->loadRowValues($attendance_list->Recordset); // Load row values
		}
		$attendance->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$attendance->RowAttrs->merge(["data-rowindex" => $attendance_list->RowCount, "id" => "r" . $attendance_list->RowCount . "_attendance", "data-rowtype" => $attendance->RowType]);

		// Render row
		$attendance_list->renderRow();

		// Render list options
		$attendance_list->renderListOptions();
?>
	<tr <?php echo $attendance->rowAttributes() ?>>
<?php

// Render list options (body, left)
$attendance_list->ListOptions->render("body", "left", $attendance_list->RowCount);
?>
	<?php if ($attendance_list->idatt->Visible) { // idatt ?>
		<td data-name="idatt" <?php echo $attendance_list->idatt->cellAttributes() ?>>
<span id="el<?php echo $attendance_list->RowCount ?>_attendance_idatt">
<span<?php echo $attendance_list->idatt->viewAttributes() ?>><?php echo $attendance_list->idatt->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attendance_list->descrip->Visible) { // descrip ?>
		<td data-name="descrip" <?php echo $attendance_list->descrip->cellAttributes() ?>>
<span id="el<?php echo $attendance_list->RowCount ?>_attendance_descrip">
<span<?php echo $attendance_list->descrip->viewAttributes() ?>><?php echo $attendance_list->descrip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attendance_list->dateatt->Visible) { // dateatt ?>
		<td data-name="dateatt" <?php echo $attendance_list->dateatt->cellAttributes() ?>>
<span id="el<?php echo $attendance_list->RowCount ?>_attendance_dateatt">
<span<?php echo $attendance_list->dateatt->viewAttributes() ?>><?php echo $attendance_list->dateatt->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attendance_list->note->Visible) { // note ?>
		<td data-name="note" <?php echo $attendance_list->note->cellAttributes() ?>>
<span id="el<?php echo $attendance_list->RowCount ?>_attendance_note">
<span<?php echo $attendance_list->note->viewAttributes() ?>><?php echo $attendance_list->note->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$attendance_list->ListOptions->render("body", "right", $attendance_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$attendance_list->isGridAdd())
		$attendance_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$attendance->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($attendance_list->Recordset)
	$attendance_list->Recordset->Close();
?>
<?php if (!$attendance_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$attendance_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $attendance_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $attendance_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($attendance_list->TotalRecords == 0 && !$attendance->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $attendance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$attendance_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$attendance_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$attendance_list->terminate();
?>