<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$attendance_edit = new attendance_edit();

// Run the page
$attendance_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attendance_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fattendanceedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fattendanceedit = currentForm = new ew.Form("fattendanceedit", "edit");

	// Validate form
	fattendanceedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($attendance_edit->idatt->Required) { ?>
				elm = this.getElements("x" + infix + "_idatt");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendance_edit->idatt->caption(), $attendance_edit->idatt->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($attendance_edit->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendance_edit->descrip->caption(), $attendance_edit->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($attendance_edit->dateatt->Required) { ?>
				elm = this.getElements("x" + infix + "_dateatt");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendance_edit->dateatt->caption(), $attendance_edit->dateatt->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dateatt");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($attendance_edit->dateatt->errorMessage()) ?>");
			<?php if ($attendance_edit->note->Required) { ?>
				elm = this.getElements("x" + infix + "_note");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendance_edit->note->caption(), $attendance_edit->note->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fattendanceedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fattendanceedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fattendanceedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $attendance_edit->showPageHeader(); ?>
<?php
$attendance_edit->showMessage();
?>
<form name="fattendanceedit" id="fattendanceedit" class="<?php echo $attendance_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="attendance">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$attendance_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($attendance_edit->idatt->Visible) { // idatt ?>
	<div id="r_idatt" class="form-group row">
		<label id="elh_attendance_idatt" class="<?php echo $attendance_edit->LeftColumnClass ?>"><?php echo $attendance_edit->idatt->caption() ?><?php echo $attendance_edit->idatt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendance_edit->RightColumnClass ?>"><div <?php echo $attendance_edit->idatt->cellAttributes() ?>>
<span id="el_attendance_idatt">
<span<?php echo $attendance_edit->idatt->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($attendance_edit->idatt->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="attendance" data-field="x_idatt" name="x_idatt" id="x_idatt" value="<?php echo HtmlEncode($attendance_edit->idatt->CurrentValue) ?>">
<?php echo $attendance_edit->idatt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($attendance_edit->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_attendance_descrip" for="x_descrip" class="<?php echo $attendance_edit->LeftColumnClass ?>"><?php echo $attendance_edit->descrip->caption() ?><?php echo $attendance_edit->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendance_edit->RightColumnClass ?>"><div <?php echo $attendance_edit->descrip->cellAttributes() ?>>
<span id="el_attendance_descrip">
<input type="text" data-table="attendance" data-field="x_descrip" name="x_descrip" id="x_descrip" size="50" maxlength="200" placeholder="<?php echo HtmlEncode($attendance_edit->descrip->getPlaceHolder()) ?>" value="<?php echo $attendance_edit->descrip->EditValue ?>"<?php echo $attendance_edit->descrip->editAttributes() ?>>
</span>
<?php echo $attendance_edit->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($attendance_edit->dateatt->Visible) { // dateatt ?>
	<div id="r_dateatt" class="form-group row">
		<label id="elh_attendance_dateatt" for="x_dateatt" class="<?php echo $attendance_edit->LeftColumnClass ?>"><?php echo $attendance_edit->dateatt->caption() ?><?php echo $attendance_edit->dateatt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendance_edit->RightColumnClass ?>"><div <?php echo $attendance_edit->dateatt->cellAttributes() ?>>
<span id="el_attendance_dateatt">
<input type="text" data-table="attendance" data-field="x_dateatt" data-format="7" name="x_dateatt" id="x_dateatt" maxlength="10" placeholder="<?php echo HtmlEncode($attendance_edit->dateatt->getPlaceHolder()) ?>" value="<?php echo $attendance_edit->dateatt->EditValue ?>"<?php echo $attendance_edit->dateatt->editAttributes() ?>>
<?php if (!$attendance_edit->dateatt->ReadOnly && !$attendance_edit->dateatt->Disabled && !isset($attendance_edit->dateatt->EditAttrs["readonly"]) && !isset($attendance_edit->dateatt->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fattendanceedit", "datetimepicker"], function() {
	ew.createDateTimePicker("fattendanceedit", "x_dateatt", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $attendance_edit->dateatt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($attendance_edit->note->Visible) { // note ?>
	<div id="r_note" class="form-group row">
		<label id="elh_attendance_note" for="x_note" class="<?php echo $attendance_edit->LeftColumnClass ?>"><?php echo $attendance_edit->note->caption() ?><?php echo $attendance_edit->note->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendance_edit->RightColumnClass ?>"><div <?php echo $attendance_edit->note->cellAttributes() ?>>
<span id="el_attendance_note">
<input type="text" data-table="attendance" data-field="x_note" name="x_note" id="x_note" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($attendance_edit->note->getPlaceHolder()) ?>" value="<?php echo $attendance_edit->note->EditValue ?>"<?php echo $attendance_edit->note->editAttributes() ?>>
</span>
<?php echo $attendance_edit->note->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("datatemp", explode(",", $attendance->getCurrentDetailTable())) && $datatemp->DetailEdit) {
?>
<?php if ($attendance->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("datatemp", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "datatempgrid.php" ?>
<?php } ?>
<?php
	if (in_array("ej_datatemps", explode(",", $attendance->getCurrentDetailTable())) && $ej_datatemps->DetailEdit) {
?>
<?php if ($attendance->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("ej_datatemps", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "ej_datatempsgrid.php" ?>
<?php } ?>
<?php
	if (in_array("attendancedetail", explode(",", $attendance->getCurrentDetailTable())) && $attendancedetail->DetailEdit) {
?>
<?php if ($attendance->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("attendancedetail", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "attendancedetailgrid.php" ?>
<?php } ?>
<?php if (!$attendance_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $attendance_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $attendance_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$attendance_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$attendance_edit->terminate();
?>