<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$attendancedetail_list = new attendancedetail_list();

// Run the page
$attendancedetail_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attendancedetail_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$attendancedetail_list->isExport()) { ?>
<script>
var fattendancedetaillist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fattendancedetaillist = currentForm = new ew.Form("fattendancedetaillist", "list");
	fattendancedetaillist.formKeyCountName = '<?php echo $attendancedetail_list->FormKeyCountName ?>';
	loadjs.done("fattendancedetaillist");
});
var fattendancedetaillistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fattendancedetaillistsrch = currentSearchForm = new ew.Form("fattendancedetaillistsrch");

	// Dynamic selection lists
	// Filters

	fattendancedetaillistsrch.filterList = <?php echo $attendancedetail_list->getFilterList() ?>;
	loadjs.done("fattendancedetaillistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$attendancedetail_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($attendancedetail_list->TotalRecords > 0 && $attendancedetail_list->ExportOptions->visible()) { ?>
<?php $attendancedetail_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($attendancedetail_list->ImportOptions->visible()) { ?>
<?php $attendancedetail_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($attendancedetail_list->SearchOptions->visible()) { ?>
<?php $attendancedetail_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($attendancedetail_list->FilterOptions->visible()) { ?>
<?php $attendancedetail_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$attendancedetail_list->isExport() || Config("EXPORT_MASTER_RECORD") && $attendancedetail_list->isExport("print")) { ?>
<?php
if ($attendancedetail_list->DbMasterFilter != "" && $attendancedetail->getCurrentMasterTable() == "attendance") {
	if ($attendancedetail_list->MasterRecordExists) {
		include_once "attendancemaster.php";
	}
}
?>
<?php } ?>
<?php
$attendancedetail_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$attendancedetail_list->isExport() && !$attendancedetail->CurrentAction) { ?>
<form name="fattendancedetaillistsrch" id="fattendancedetaillistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fattendancedetaillistsrch-search-panel" class="<?php echo $attendancedetail_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="attendancedetail">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $attendancedetail_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($attendancedetail_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($attendancedetail_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $attendancedetail_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($attendancedetail_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($attendancedetail_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($attendancedetail_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($attendancedetail_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $attendancedetail_list->showPageHeader(); ?>
<?php
$attendancedetail_list->showMessage();
?>
<?php if ($attendancedetail_list->TotalRecords > 0 || $attendancedetail->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($attendancedetail_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> attendancedetail">
<?php if (!$attendancedetail_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$attendancedetail_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $attendancedetail_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $attendancedetail_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fattendancedetaillist" id="fattendancedetaillist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="attendancedetail">
<input type="hidden" name="exporttype" id="exporttype" value="">
<?php if ($attendancedetail->getCurrentMasterTable() == "attendance" && $attendancedetail->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="attendance">
<input type="hidden" name="fk_idatt" value="<?php echo HtmlEncode($attendancedetail_list->idatt->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_attendancedetail" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($attendancedetail_list->TotalRecords > 0 || $attendancedetail_list->isGridEdit()) { ?>
<table id="tbl_attendancedetaillist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$attendancedetail->RowType = ROWTYPE_HEADER;

// Render list options
$attendancedetail_list->renderListOptions();

// Render list options (header, left)
$attendancedetail_list->ListOptions->render("header", "left");
?>
<?php if ($attendancedetail_list->dateattdetail->Visible) { // dateattdetail ?>
	<?php if ($attendancedetail_list->SortUrl($attendancedetail_list->dateattdetail) == "") { ?>
		<th data-name="dateattdetail" class="<?php echo $attendancedetail_list->dateattdetail->headerCellClass() ?>"><div id="elh_attendancedetail_dateattdetail" class="attendancedetail_dateattdetail"><div class="ew-table-header-caption"><?php echo $attendancedetail_list->dateattdetail->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dateattdetail" class="<?php echo $attendancedetail_list->dateattdetail->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $attendancedetail_list->SortUrl($attendancedetail_list->dateattdetail) ?>', 1);"><div id="elh_attendancedetail_dateattdetail" class="attendancedetail_dateattdetail">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_list->dateattdetail->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_list->dateattdetail->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_list->dateattdetail->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendancedetail_list->idemp->Visible) { // idemp ?>
	<?php if ($attendancedetail_list->SortUrl($attendancedetail_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $attendancedetail_list->idemp->headerCellClass() ?>"><div id="elh_attendancedetail_idemp" class="attendancedetail_idemp"><div class="ew-table-header-caption"><?php echo $attendancedetail_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $attendancedetail_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $attendancedetail_list->SortUrl($attendancedetail_list->idemp) ?>', 1);"><div id="elh_attendancedetail_idemp" class="attendancedetail_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendancedetail_list->type->Visible) { // type ?>
	<?php if ($attendancedetail_list->SortUrl($attendancedetail_list->type) == "") { ?>
		<th data-name="type" class="<?php echo $attendancedetail_list->type->headerCellClass() ?>"><div id="elh_attendancedetail_type" class="attendancedetail_type"><div class="ew-table-header-caption"><?php echo $attendancedetail_list->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $attendancedetail_list->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $attendancedetail_list->SortUrl($attendancedetail_list->type) ?>', 1);"><div id="elh_attendancedetail_type" class="attendancedetail_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_list->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_list->type->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_list->type->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendancedetail_list->dept->Visible) { // dept ?>
	<?php if ($attendancedetail_list->SortUrl($attendancedetail_list->dept) == "") { ?>
		<th data-name="dept" class="<?php echo $attendancedetail_list->dept->headerCellClass() ?>"><div id="elh_attendancedetail_dept" class="attendancedetail_dept"><div class="ew-table-header-caption"><?php echo $attendancedetail_list->dept->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dept" class="<?php echo $attendancedetail_list->dept->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $attendancedetail_list->SortUrl($attendancedetail_list->dept) ?>', 1);"><div id="elh_attendancedetail_dept" class="attendancedetail_dept">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_list->dept->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_list->dept->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_list->dept->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendancedetail_list->statut->Visible) { // statut ?>
	<?php if ($attendancedetail_list->SortUrl($attendancedetail_list->statut) == "") { ?>
		<th data-name="statut" class="<?php echo $attendancedetail_list->statut->headerCellClass() ?>"><div id="elh_attendancedetail_statut" class="attendancedetail_statut"><div class="ew-table-header-caption"><?php echo $attendancedetail_list->statut->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="statut" class="<?php echo $attendancedetail_list->statut->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $attendancedetail_list->SortUrl($attendancedetail_list->statut) ?>', 1);"><div id="elh_attendancedetail_statut" class="attendancedetail_statut">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_list->statut->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_list->statut->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_list->statut->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$attendancedetail_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($attendancedetail_list->ExportAll && $attendancedetail_list->isExport()) {
	$attendancedetail_list->StopRecord = $attendancedetail_list->TotalRecords;
} else {

	// Set the last record to display
	if ($attendancedetail_list->TotalRecords > $attendancedetail_list->StartRecord + $attendancedetail_list->DisplayRecords - 1)
		$attendancedetail_list->StopRecord = $attendancedetail_list->StartRecord + $attendancedetail_list->DisplayRecords - 1;
	else
		$attendancedetail_list->StopRecord = $attendancedetail_list->TotalRecords;
}
$attendancedetail_list->RecordCount = $attendancedetail_list->StartRecord - 1;
if ($attendancedetail_list->Recordset && !$attendancedetail_list->Recordset->EOF) {
	$attendancedetail_list->Recordset->moveFirst();
	$selectLimit = $attendancedetail_list->UseSelectLimit;
	if (!$selectLimit && $attendancedetail_list->StartRecord > 1)
		$attendancedetail_list->Recordset->move($attendancedetail_list->StartRecord - 1);
} elseif (!$attendancedetail->AllowAddDeleteRow && $attendancedetail_list->StopRecord == 0) {
	$attendancedetail_list->StopRecord = $attendancedetail->GridAddRowCount;
}

// Initialize aggregate
$attendancedetail->RowType = ROWTYPE_AGGREGATEINIT;
$attendancedetail->resetAttributes();
$attendancedetail_list->renderRow();
while ($attendancedetail_list->RecordCount < $attendancedetail_list->StopRecord) {
	$attendancedetail_list->RecordCount++;
	if ($attendancedetail_list->RecordCount >= $attendancedetail_list->StartRecord) {
		$attendancedetail_list->RowCount++;

		// Set up key count
		$attendancedetail_list->KeyCount = $attendancedetail_list->RowIndex;

		// Init row class and style
		$attendancedetail->resetAttributes();
		$attendancedetail->CssClass = "";
		if ($attendancedetail_list->isGridAdd()) {
		} else {
			$attendancedetail_list->loadRowValues($attendancedetail_list->Recordset); // Load row values
		}
		$attendancedetail->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$attendancedetail->RowAttrs->merge(["data-rowindex" => $attendancedetail_list->RowCount, "id" => "r" . $attendancedetail_list->RowCount . "_attendancedetail", "data-rowtype" => $attendancedetail->RowType]);

		// Render row
		$attendancedetail_list->renderRow();

		// Render list options
		$attendancedetail_list->renderListOptions();
?>
	<tr <?php echo $attendancedetail->rowAttributes() ?>>
<?php

// Render list options (body, left)
$attendancedetail_list->ListOptions->render("body", "left", $attendancedetail_list->RowCount);
?>
	<?php if ($attendancedetail_list->dateattdetail->Visible) { // dateattdetail ?>
		<td data-name="dateattdetail" <?php echo $attendancedetail_list->dateattdetail->cellAttributes() ?>>
<span id="el<?php echo $attendancedetail_list->RowCount ?>_attendancedetail_dateattdetail">
<span<?php echo $attendancedetail_list->dateattdetail->viewAttributes() ?>><?php echo $attendancedetail_list->dateattdetail->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attendancedetail_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $attendancedetail_list->idemp->cellAttributes() ?>>
<span id="el<?php echo $attendancedetail_list->RowCount ?>_attendancedetail_idemp">
<span<?php echo $attendancedetail_list->idemp->viewAttributes() ?>><?php echo $attendancedetail_list->idemp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attendancedetail_list->type->Visible) { // type ?>
		<td data-name="type" <?php echo $attendancedetail_list->type->cellAttributes() ?>>
<span id="el<?php echo $attendancedetail_list->RowCount ?>_attendancedetail_type">
<span<?php echo $attendancedetail_list->type->viewAttributes() ?>><?php echo $attendancedetail_list->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attendancedetail_list->dept->Visible) { // dept ?>
		<td data-name="dept" <?php echo $attendancedetail_list->dept->cellAttributes() ?>>
<span id="el<?php echo $attendancedetail_list->RowCount ?>_attendancedetail_dept">
<span<?php echo $attendancedetail_list->dept->viewAttributes() ?>><?php echo $attendancedetail_list->dept->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attendancedetail_list->statut->Visible) { // statut ?>
		<td data-name="statut" <?php echo $attendancedetail_list->statut->cellAttributes() ?>>
<span id="el<?php echo $attendancedetail_list->RowCount ?>_attendancedetail_statut">
<span<?php echo $attendancedetail_list->statut->viewAttributes() ?>><?php echo $attendancedetail_list->statut->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$attendancedetail_list->ListOptions->render("body", "right", $attendancedetail_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$attendancedetail_list->isGridAdd())
		$attendancedetail_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$attendancedetail->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($attendancedetail_list->Recordset)
	$attendancedetail_list->Recordset->Close();
?>
<?php if (!$attendancedetail_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$attendancedetail_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $attendancedetail_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $attendancedetail_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($attendancedetail_list->TotalRecords == 0 && !$attendancedetail->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $attendancedetail_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$attendancedetail_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$attendancedetail_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$attendancedetail_list->terminate();
?>