<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($attendancedetail_grid))
	$attendancedetail_grid = new attendancedetail_grid();

// Run the page
$attendancedetail_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attendancedetail_grid->Page_Render();
?>
<?php if (!$attendancedetail_grid->isExport()) { ?>
<script>
var fattendancedetailgrid, currentPageID;
loadjs.ready("head", function() {

	// Form object
	fattendancedetailgrid = new ew.Form("fattendancedetailgrid", "grid");
	fattendancedetailgrid.formKeyCountName = '<?php echo $attendancedetail_grid->FormKeyCountName ?>';

	// Validate form
	fattendancedetailgrid.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($attendancedetail_grid->dateattdetail->Required) { ?>
				elm = this.getElements("x" + infix + "_dateattdetail");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_grid->dateattdetail->caption(), $attendancedetail_grid->dateattdetail->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dateattdetail");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($attendancedetail_grid->dateattdetail->errorMessage()) ?>");
			<?php if ($attendancedetail_grid->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_grid->idemp->caption(), $attendancedetail_grid->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($attendancedetail_grid->type->Required) { ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_grid->type->caption(), $attendancedetail_grid->type->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($attendancedetail_grid->dept->Required) { ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_grid->dept->caption(), $attendancedetail_grid->dept->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($attendancedetail_grid->statut->Required) { ?>
				elm = this.getElements("x" + infix + "_statut");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_grid->statut->caption(), $attendancedetail_grid->statut->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		return true;
	}

	// Check empty row
	fattendancedetailgrid.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "dateattdetail", false)) return false;
		if (ew.valueChanged(fobj, infix, "idemp", false)) return false;
		if (ew.valueChanged(fobj, infix, "type", false)) return false;
		if (ew.valueChanged(fobj, infix, "dept", false)) return false;
		if (ew.valueChanged(fobj, infix, "statut", false)) return false;
		return true;
	}

	// Form_CustomValidate
	fattendancedetailgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fattendancedetailgrid.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fattendancedetailgrid.lists["x_idemp"] = <?php echo $attendancedetail_grid->idemp->Lookup->toClientList($attendancedetail_grid) ?>;
	fattendancedetailgrid.lists["x_idemp"].options = <?php echo JsonEncode($attendancedetail_grid->idemp->lookupOptions()) ?>;
	fattendancedetailgrid.lists["x_type"] = <?php echo $attendancedetail_grid->type->Lookup->toClientList($attendancedetail_grid) ?>;
	fattendancedetailgrid.lists["x_type"].options = <?php echo JsonEncode($attendancedetail_grid->type->lookupOptions()) ?>;
	fattendancedetailgrid.lists["x_dept"] = <?php echo $attendancedetail_grid->dept->Lookup->toClientList($attendancedetail_grid) ?>;
	fattendancedetailgrid.lists["x_dept"].options = <?php echo JsonEncode($attendancedetail_grid->dept->lookupOptions()) ?>;
	fattendancedetailgrid.lists["x_statut"] = <?php echo $attendancedetail_grid->statut->Lookup->toClientList($attendancedetail_grid) ?>;
	fattendancedetailgrid.lists["x_statut"].options = <?php echo JsonEncode($attendancedetail_grid->statut->options(FALSE, TRUE)) ?>;
	loadjs.done("fattendancedetailgrid");
});
</script>
<?php } ?>
<?php
$attendancedetail_grid->renderOtherOptions();
?>
<?php if ($attendancedetail_grid->TotalRecords > 0 || $attendancedetail->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($attendancedetail_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> attendancedetail">
<?php if ($attendancedetail_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $attendancedetail_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fattendancedetailgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_attendancedetail" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_attendancedetailgrid" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$attendancedetail->RowType = ROWTYPE_HEADER;

// Render list options
$attendancedetail_grid->renderListOptions();

// Render list options (header, left)
$attendancedetail_grid->ListOptions->render("header", "left");
?>
<?php if ($attendancedetail_grid->dateattdetail->Visible) { // dateattdetail ?>
	<?php if ($attendancedetail_grid->SortUrl($attendancedetail_grid->dateattdetail) == "") { ?>
		<th data-name="dateattdetail" class="<?php echo $attendancedetail_grid->dateattdetail->headerCellClass() ?>"><div id="elh_attendancedetail_dateattdetail" class="attendancedetail_dateattdetail"><div class="ew-table-header-caption"><?php echo $attendancedetail_grid->dateattdetail->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dateattdetail" class="<?php echo $attendancedetail_grid->dateattdetail->headerCellClass() ?>"><div><div id="elh_attendancedetail_dateattdetail" class="attendancedetail_dateattdetail">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_grid->dateattdetail->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_grid->dateattdetail->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_grid->dateattdetail->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendancedetail_grid->idemp->Visible) { // idemp ?>
	<?php if ($attendancedetail_grid->SortUrl($attendancedetail_grid->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $attendancedetail_grid->idemp->headerCellClass() ?>"><div id="elh_attendancedetail_idemp" class="attendancedetail_idemp"><div class="ew-table-header-caption"><?php echo $attendancedetail_grid->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $attendancedetail_grid->idemp->headerCellClass() ?>"><div><div id="elh_attendancedetail_idemp" class="attendancedetail_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_grid->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_grid->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_grid->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendancedetail_grid->type->Visible) { // type ?>
	<?php if ($attendancedetail_grid->SortUrl($attendancedetail_grid->type) == "") { ?>
		<th data-name="type" class="<?php echo $attendancedetail_grid->type->headerCellClass() ?>"><div id="elh_attendancedetail_type" class="attendancedetail_type"><div class="ew-table-header-caption"><?php echo $attendancedetail_grid->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $attendancedetail_grid->type->headerCellClass() ?>"><div><div id="elh_attendancedetail_type" class="attendancedetail_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_grid->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_grid->type->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_grid->type->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendancedetail_grid->dept->Visible) { // dept ?>
	<?php if ($attendancedetail_grid->SortUrl($attendancedetail_grid->dept) == "") { ?>
		<th data-name="dept" class="<?php echo $attendancedetail_grid->dept->headerCellClass() ?>"><div id="elh_attendancedetail_dept" class="attendancedetail_dept"><div class="ew-table-header-caption"><?php echo $attendancedetail_grid->dept->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dept" class="<?php echo $attendancedetail_grid->dept->headerCellClass() ?>"><div><div id="elh_attendancedetail_dept" class="attendancedetail_dept">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_grid->dept->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_grid->dept->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_grid->dept->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attendancedetail_grid->statut->Visible) { // statut ?>
	<?php if ($attendancedetail_grid->SortUrl($attendancedetail_grid->statut) == "") { ?>
		<th data-name="statut" class="<?php echo $attendancedetail_grid->statut->headerCellClass() ?>"><div id="elh_attendancedetail_statut" class="attendancedetail_statut"><div class="ew-table-header-caption"><?php echo $attendancedetail_grid->statut->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="statut" class="<?php echo $attendancedetail_grid->statut->headerCellClass() ?>"><div><div id="elh_attendancedetail_statut" class="attendancedetail_statut">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attendancedetail_grid->statut->caption() ?></span><span class="ew-table-header-sort"><?php if ($attendancedetail_grid->statut->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($attendancedetail_grid->statut->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$attendancedetail_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$attendancedetail_grid->StartRecord = 1;
$attendancedetail_grid->StopRecord = $attendancedetail_grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($attendancedetail->isConfirm() || $attendancedetail_grid->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($attendancedetail_grid->FormKeyCountName) && ($attendancedetail_grid->isGridAdd() || $attendancedetail_grid->isGridEdit() || $attendancedetail->isConfirm())) {
		$attendancedetail_grid->KeyCount = $CurrentForm->getValue($attendancedetail_grid->FormKeyCountName);
		$attendancedetail_grid->StopRecord = $attendancedetail_grid->StartRecord + $attendancedetail_grid->KeyCount - 1;
	}
}
$attendancedetail_grid->RecordCount = $attendancedetail_grid->StartRecord - 1;
if ($attendancedetail_grid->Recordset && !$attendancedetail_grid->Recordset->EOF) {
	$attendancedetail_grid->Recordset->moveFirst();
	$selectLimit = $attendancedetail_grid->UseSelectLimit;
	if (!$selectLimit && $attendancedetail_grid->StartRecord > 1)
		$attendancedetail_grid->Recordset->move($attendancedetail_grid->StartRecord - 1);
} elseif (!$attendancedetail->AllowAddDeleteRow && $attendancedetail_grid->StopRecord == 0) {
	$attendancedetail_grid->StopRecord = $attendancedetail->GridAddRowCount;
}

// Initialize aggregate
$attendancedetail->RowType = ROWTYPE_AGGREGATEINIT;
$attendancedetail->resetAttributes();
$attendancedetail_grid->renderRow();
if ($attendancedetail_grid->isGridAdd())
	$attendancedetail_grid->RowIndex = 0;
if ($attendancedetail_grid->isGridEdit())
	$attendancedetail_grid->RowIndex = 0;
while ($attendancedetail_grid->RecordCount < $attendancedetail_grid->StopRecord) {
	$attendancedetail_grid->RecordCount++;
	if ($attendancedetail_grid->RecordCount >= $attendancedetail_grid->StartRecord) {
		$attendancedetail_grid->RowCount++;
		if ($attendancedetail_grid->isGridAdd() || $attendancedetail_grid->isGridEdit() || $attendancedetail->isConfirm()) {
			$attendancedetail_grid->RowIndex++;
			$CurrentForm->Index = $attendancedetail_grid->RowIndex;
			if ($CurrentForm->hasValue($attendancedetail_grid->FormActionName) && ($attendancedetail->isConfirm() || $attendancedetail_grid->EventCancelled))
				$attendancedetail_grid->RowAction = strval($CurrentForm->getValue($attendancedetail_grid->FormActionName));
			elseif ($attendancedetail_grid->isGridAdd())
				$attendancedetail_grid->RowAction = "insert";
			else
				$attendancedetail_grid->RowAction = "";
		}

		// Set up key count
		$attendancedetail_grid->KeyCount = $attendancedetail_grid->RowIndex;

		// Init row class and style
		$attendancedetail->resetAttributes();
		$attendancedetail->CssClass = "";
		if ($attendancedetail_grid->isGridAdd()) {
			if ($attendancedetail->CurrentMode == "copy") {
				$attendancedetail_grid->loadRowValues($attendancedetail_grid->Recordset); // Load row values
				$attendancedetail_grid->setRecordKey($attendancedetail_grid->RowOldKey, $attendancedetail_grid->Recordset); // Set old record key
			} else {
				$attendancedetail_grid->loadRowValues(); // Load default values
				$attendancedetail_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$attendancedetail_grid->loadRowValues($attendancedetail_grid->Recordset); // Load row values
		}
		$attendancedetail->RowType = ROWTYPE_VIEW; // Render view
		if ($attendancedetail_grid->isGridAdd()) // Grid add
			$attendancedetail->RowType = ROWTYPE_ADD; // Render add
		if ($attendancedetail_grid->isGridAdd() && $attendancedetail->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$attendancedetail_grid->restoreCurrentRowFormValues($attendancedetail_grid->RowIndex); // Restore form values
		if ($attendancedetail_grid->isGridEdit()) { // Grid edit
			if ($attendancedetail->EventCancelled)
				$attendancedetail_grid->restoreCurrentRowFormValues($attendancedetail_grid->RowIndex); // Restore form values
			if ($attendancedetail_grid->RowAction == "insert")
				$attendancedetail->RowType = ROWTYPE_ADD; // Render add
			else
				$attendancedetail->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($attendancedetail_grid->isGridEdit() && ($attendancedetail->RowType == ROWTYPE_EDIT || $attendancedetail->RowType == ROWTYPE_ADD) && $attendancedetail->EventCancelled) // Update failed
			$attendancedetail_grid->restoreCurrentRowFormValues($attendancedetail_grid->RowIndex); // Restore form values
		if ($attendancedetail->RowType == ROWTYPE_EDIT) // Edit row
			$attendancedetail_grid->EditRowCount++;
		if ($attendancedetail->isConfirm()) // Confirm row
			$attendancedetail_grid->restoreCurrentRowFormValues($attendancedetail_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$attendancedetail->RowAttrs->merge(["data-rowindex" => $attendancedetail_grid->RowCount, "id" => "r" . $attendancedetail_grid->RowCount . "_attendancedetail", "data-rowtype" => $attendancedetail->RowType]);

		// Render row
		$attendancedetail_grid->renderRow();

		// Render list options
		$attendancedetail_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($attendancedetail_grid->RowAction != "delete" && $attendancedetail_grid->RowAction != "insertdelete" && !($attendancedetail_grid->RowAction == "insert" && $attendancedetail->isConfirm() && $attendancedetail_grid->emptyRow())) {
?>
	<tr <?php echo $attendancedetail->rowAttributes() ?>>
<?php

// Render list options (body, left)
$attendancedetail_grid->ListOptions->render("body", "left", $attendancedetail_grid->RowCount);
?>
	<?php if ($attendancedetail_grid->dateattdetail->Visible) { // dateattdetail ?>
		<td data-name="dateattdetail" <?php echo $attendancedetail_grid->dateattdetail->cellAttributes() ?>>
<?php if ($attendancedetail->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_dateattdetail" class="form-group">
<input type="text" data-table="attendancedetail" data-field="x_dateattdetail" data-format="7" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" maxlength="10" placeholder="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->getPlaceHolder()) ?>" value="<?php echo $attendancedetail_grid->dateattdetail->EditValue ?>"<?php echo $attendancedetail_grid->dateattdetail->editAttributes() ?>>
<?php if (!$attendancedetail_grid->dateattdetail->ReadOnly && !$attendancedetail_grid->dateattdetail->Disabled && !isset($attendancedetail_grid->dateattdetail->EditAttrs["readonly"]) && !isset($attendancedetail_grid->dateattdetail->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fattendancedetailgrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fattendancedetailgrid", "x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_dateattdetail" name="o<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="o<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->OldValue) ?>">
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_dateattdetail" class="form-group">
<input type="text" data-table="attendancedetail" data-field="x_dateattdetail" data-format="7" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" maxlength="10" placeholder="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->getPlaceHolder()) ?>" value="<?php echo $attendancedetail_grid->dateattdetail->EditValue ?>"<?php echo $attendancedetail_grid->dateattdetail->editAttributes() ?>>
<?php if (!$attendancedetail_grid->dateattdetail->ReadOnly && !$attendancedetail_grid->dateattdetail->Disabled && !isset($attendancedetail_grid->dateattdetail->EditAttrs["readonly"]) && !isset($attendancedetail_grid->dateattdetail->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fattendancedetailgrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fattendancedetailgrid", "x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_dateattdetail">
<span<?php echo $attendancedetail_grid->dateattdetail->viewAttributes() ?>><?php echo $attendancedetail_grid->dateattdetail->getViewValue() ?></span>
</span>
<?php if (!$attendancedetail->isConfirm()) { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_dateattdetail" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_dateattdetail" name="o<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="o<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_dateattdetail" name="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_dateattdetail" name="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="attendancedetail" data-field="x_idattdetail" name="x<?php echo $attendancedetail_grid->RowIndex ?>_idattdetail" id="x<?php echo $attendancedetail_grid->RowIndex ?>_idattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->idattdetail->CurrentValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_idattdetail" name="o<?php echo $attendancedetail_grid->RowIndex ?>_idattdetail" id="o<?php echo $attendancedetail_grid->RowIndex ?>_idattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->idattdetail->OldValue) ?>">
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_EDIT || $attendancedetail->CurrentMode == "edit") { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_idattdetail" name="x<?php echo $attendancedetail_grid->RowIndex ?>_idattdetail" id="x<?php echo $attendancedetail_grid->RowIndex ?>_idattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->idattdetail->CurrentValue) ?>">
<?php } ?>
	<?php if ($attendancedetail_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $attendancedetail_grid->idemp->cellAttributes() ?>>
<?php if ($attendancedetail->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_idemp" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $attendancedetail_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($attendancedetail_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $attendancedetail_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($attendancedetail_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($attendancedetail_grid->idemp->ReadOnly || $attendancedetail_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $attendancedetail_grid->RowIndex ?>_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $attendancedetail_grid->idemp->Lookup->getParamTag($attendancedetail_grid, "p_x" . $attendancedetail_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $attendancedetail_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo $attendancedetail_grid->idemp->CurrentValue ?>"<?php echo $attendancedetail_grid->idemp->editAttributes() ?>>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" name="o<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="o<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($attendancedetail_grid->idemp->OldValue) ?>">
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_idemp" class="form-group">
<span<?php echo $attendancedetail_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($attendancedetail_grid->idemp->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" name="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($attendancedetail_grid->idemp->CurrentValue) ?>">
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_idemp">
<span<?php echo $attendancedetail_grid->idemp->viewAttributes() ?>><?php echo $attendancedetail_grid->idemp->getViewValue() ?></span>
</span>
<?php if (!$attendancedetail->isConfirm()) { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" name="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($attendancedetail_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" name="o<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="o<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($attendancedetail_grid->idemp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" name="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($attendancedetail_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" name="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($attendancedetail_grid->idemp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($attendancedetail_grid->type->Visible) { // type ?>
		<td data-name="type" <?php echo $attendancedetail_grid->type->cellAttributes() ?>>
<?php if ($attendancedetail->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_type" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="attendancedetail" data-field="x_type" data-value-separator="<?php echo $attendancedetail_grid->type->displayValueSeparatorAttribute() ?>" id="x<?php echo $attendancedetail_grid->RowIndex ?>_type" name="x<?php echo $attendancedetail_grid->RowIndex ?>_type"<?php echo $attendancedetail_grid->type->editAttributes() ?>>
			<?php echo $attendancedetail_grid->type->selectOptionListHtml("x{$attendancedetail_grid->RowIndex}_type") ?>
		</select>
</div>
<?php echo $attendancedetail_grid->type->Lookup->getParamTag($attendancedetail_grid, "p_x" . $attendancedetail_grid->RowIndex . "_type") ?>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_type" name="o<?php echo $attendancedetail_grid->RowIndex ?>_type" id="o<?php echo $attendancedetail_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($attendancedetail_grid->type->OldValue) ?>">
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_type" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="attendancedetail" data-field="x_type" data-value-separator="<?php echo $attendancedetail_grid->type->displayValueSeparatorAttribute() ?>" id="x<?php echo $attendancedetail_grid->RowIndex ?>_type" name="x<?php echo $attendancedetail_grid->RowIndex ?>_type"<?php echo $attendancedetail_grid->type->editAttributes() ?>>
			<?php echo $attendancedetail_grid->type->selectOptionListHtml("x{$attendancedetail_grid->RowIndex}_type") ?>
		</select>
</div>
<?php echo $attendancedetail_grid->type->Lookup->getParamTag($attendancedetail_grid, "p_x" . $attendancedetail_grid->RowIndex . "_type") ?>
</span>
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_type">
<span<?php echo $attendancedetail_grid->type->viewAttributes() ?>><?php echo $attendancedetail_grid->type->getViewValue() ?></span>
</span>
<?php if (!$attendancedetail->isConfirm()) { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_type" name="x<?php echo $attendancedetail_grid->RowIndex ?>_type" id="x<?php echo $attendancedetail_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($attendancedetail_grid->type->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_type" name="o<?php echo $attendancedetail_grid->RowIndex ?>_type" id="o<?php echo $attendancedetail_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($attendancedetail_grid->type->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_type" name="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_type" id="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($attendancedetail_grid->type->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_type" name="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_type" id="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($attendancedetail_grid->type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($attendancedetail_grid->dept->Visible) { // dept ?>
		<td data-name="dept" <?php echo $attendancedetail_grid->dept->cellAttributes() ?>>
<?php if ($attendancedetail->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_dept" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="attendancedetail" data-field="x_dept" data-value-separator="<?php echo $attendancedetail_grid->dept->displayValueSeparatorAttribute() ?>" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dept" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dept"<?php echo $attendancedetail_grid->dept->editAttributes() ?>>
			<?php echo $attendancedetail_grid->dept->selectOptionListHtml("x{$attendancedetail_grid->RowIndex}_dept") ?>
		</select>
</div>
<?php echo $attendancedetail_grid->dept->Lookup->getParamTag($attendancedetail_grid, "p_x" . $attendancedetail_grid->RowIndex . "_dept") ?>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_dept" name="o<?php echo $attendancedetail_grid->RowIndex ?>_dept" id="o<?php echo $attendancedetail_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($attendancedetail_grid->dept->OldValue) ?>">
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_dept" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="attendancedetail" data-field="x_dept" data-value-separator="<?php echo $attendancedetail_grid->dept->displayValueSeparatorAttribute() ?>" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dept" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dept"<?php echo $attendancedetail_grid->dept->editAttributes() ?>>
			<?php echo $attendancedetail_grid->dept->selectOptionListHtml("x{$attendancedetail_grid->RowIndex}_dept") ?>
		</select>
</div>
<?php echo $attendancedetail_grid->dept->Lookup->getParamTag($attendancedetail_grid, "p_x" . $attendancedetail_grid->RowIndex . "_dept") ?>
</span>
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_dept">
<span<?php echo $attendancedetail_grid->dept->viewAttributes() ?>><?php echo $attendancedetail_grid->dept->getViewValue() ?></span>
</span>
<?php if (!$attendancedetail->isConfirm()) { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_dept" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dept" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($attendancedetail_grid->dept->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_dept" name="o<?php echo $attendancedetail_grid->RowIndex ?>_dept" id="o<?php echo $attendancedetail_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($attendancedetail_grid->dept->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_dept" name="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_dept" id="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($attendancedetail_grid->dept->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_dept" name="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_dept" id="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($attendancedetail_grid->dept->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($attendancedetail_grid->statut->Visible) { // statut ?>
		<td data-name="statut" <?php echo $attendancedetail_grid->statut->cellAttributes() ?>>
<?php if ($attendancedetail->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_statut" class="form-group">
<div id="tp_x<?php echo $attendancedetail_grid->RowIndex ?>_statut" class="ew-template"><input type="radio" class="custom-control-input" data-table="attendancedetail" data-field="x_statut" data-value-separator="<?php echo $attendancedetail_grid->statut->displayValueSeparatorAttribute() ?>" name="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="{value}"<?php echo $attendancedetail_grid->statut->editAttributes() ?>></div>
<div id="dsl_x<?php echo $attendancedetail_grid->RowIndex ?>_statut" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $attendancedetail_grid->statut->radioButtonListHtml(FALSE, "x{$attendancedetail_grid->RowIndex}_statut") ?>
</div></div>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_statut" name="o<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="o<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="<?php echo HtmlEncode($attendancedetail_grid->statut->OldValue) ?>">
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_statut" class="form-group">
<div id="tp_x<?php echo $attendancedetail_grid->RowIndex ?>_statut" class="ew-template"><input type="radio" class="custom-control-input" data-table="attendancedetail" data-field="x_statut" data-value-separator="<?php echo $attendancedetail_grid->statut->displayValueSeparatorAttribute() ?>" name="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="{value}"<?php echo $attendancedetail_grid->statut->editAttributes() ?>></div>
<div id="dsl_x<?php echo $attendancedetail_grid->RowIndex ?>_statut" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $attendancedetail_grid->statut->radioButtonListHtml(FALSE, "x{$attendancedetail_grid->RowIndex}_statut") ?>
</div></div>
</span>
<?php } ?>
<?php if ($attendancedetail->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $attendancedetail_grid->RowCount ?>_attendancedetail_statut">
<span<?php echo $attendancedetail_grid->statut->viewAttributes() ?>><?php echo $attendancedetail_grid->statut->getViewValue() ?></span>
</span>
<?php if (!$attendancedetail->isConfirm()) { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_statut" name="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="<?php echo HtmlEncode($attendancedetail_grid->statut->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_statut" name="o<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="o<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="<?php echo HtmlEncode($attendancedetail_grid->statut->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="attendancedetail" data-field="x_statut" name="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="fattendancedetailgrid$x<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="<?php echo HtmlEncode($attendancedetail_grid->statut->FormValue) ?>">
<input type="hidden" data-table="attendancedetail" data-field="x_statut" name="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="fattendancedetailgrid$o<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="<?php echo HtmlEncode($attendancedetail_grid->statut->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$attendancedetail_grid->ListOptions->render("body", "right", $attendancedetail_grid->RowCount);
?>
	</tr>
<?php if ($attendancedetail->RowType == ROWTYPE_ADD || $attendancedetail->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fattendancedetailgrid", "load"], function() {
	fattendancedetailgrid.updateLists(<?php echo $attendancedetail_grid->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$attendancedetail_grid->isGridAdd() || $attendancedetail->CurrentMode == "copy")
		if (!$attendancedetail_grid->Recordset->EOF)
			$attendancedetail_grid->Recordset->moveNext();
}
?>
<?php
	if ($attendancedetail->CurrentMode == "add" || $attendancedetail->CurrentMode == "copy" || $attendancedetail->CurrentMode == "edit") {
		$attendancedetail_grid->RowIndex = '$rowindex$';
		$attendancedetail_grid->loadRowValues();

		// Set row properties
		$attendancedetail->resetAttributes();
		$attendancedetail->RowAttrs->merge(["data-rowindex" => $attendancedetail_grid->RowIndex, "id" => "r0_attendancedetail", "data-rowtype" => ROWTYPE_ADD]);
		$attendancedetail->RowAttrs->appendClass("ew-template");
		$attendancedetail->RowType = ROWTYPE_ADD;

		// Render row
		$attendancedetail_grid->renderRow();

		// Render list options
		$attendancedetail_grid->renderListOptions();
		$attendancedetail_grid->StartRowCount = 0;
?>
	<tr <?php echo $attendancedetail->rowAttributes() ?>>
<?php

// Render list options (body, left)
$attendancedetail_grid->ListOptions->render("body", "left", $attendancedetail_grid->RowIndex);
?>
	<?php if ($attendancedetail_grid->dateattdetail->Visible) { // dateattdetail ?>
		<td data-name="dateattdetail">
<?php if (!$attendancedetail->isConfirm()) { ?>
<span id="el$rowindex$_attendancedetail_dateattdetail" class="form-group attendancedetail_dateattdetail">
<input type="text" data-table="attendancedetail" data-field="x_dateattdetail" data-format="7" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" maxlength="10" placeholder="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->getPlaceHolder()) ?>" value="<?php echo $attendancedetail_grid->dateattdetail->EditValue ?>"<?php echo $attendancedetail_grid->dateattdetail->editAttributes() ?>>
<?php if (!$attendancedetail_grid->dateattdetail->ReadOnly && !$attendancedetail_grid->dateattdetail->Disabled && !isset($attendancedetail_grid->dateattdetail->EditAttrs["readonly"]) && !isset($attendancedetail_grid->dateattdetail->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fattendancedetailgrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fattendancedetailgrid", "x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_attendancedetail_dateattdetail" class="form-group attendancedetail_dateattdetail">
<span<?php echo $attendancedetail_grid->dateattdetail->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($attendancedetail_grid->dateattdetail->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_dateattdetail" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="attendancedetail" data-field="x_dateattdetail" name="o<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" id="o<?php echo $attendancedetail_grid->RowIndex ?>_dateattdetail" value="<?php echo HtmlEncode($attendancedetail_grid->dateattdetail->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($attendancedetail_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<?php if (!$attendancedetail->isConfirm()) { ?>
<span id="el$rowindex$_attendancedetail_idemp" class="form-group attendancedetail_idemp">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $attendancedetail_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($attendancedetail_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $attendancedetail_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($attendancedetail_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($attendancedetail_grid->idemp->ReadOnly || $attendancedetail_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $attendancedetail_grid->RowIndex ?>_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $attendancedetail_grid->idemp->Lookup->getParamTag($attendancedetail_grid, "p_x" . $attendancedetail_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $attendancedetail_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo $attendancedetail_grid->idemp->CurrentValue ?>"<?php echo $attendancedetail_grid->idemp->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_attendancedetail_idemp" class="form-group attendancedetail_idemp">
<span<?php echo $attendancedetail_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($attendancedetail_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" name="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="x<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($attendancedetail_grid->idemp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" name="o<?php echo $attendancedetail_grid->RowIndex ?>_idemp" id="o<?php echo $attendancedetail_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($attendancedetail_grid->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($attendancedetail_grid->type->Visible) { // type ?>
		<td data-name="type">
<?php if (!$attendancedetail->isConfirm()) { ?>
<span id="el$rowindex$_attendancedetail_type" class="form-group attendancedetail_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="attendancedetail" data-field="x_type" data-value-separator="<?php echo $attendancedetail_grid->type->displayValueSeparatorAttribute() ?>" id="x<?php echo $attendancedetail_grid->RowIndex ?>_type" name="x<?php echo $attendancedetail_grid->RowIndex ?>_type"<?php echo $attendancedetail_grid->type->editAttributes() ?>>
			<?php echo $attendancedetail_grid->type->selectOptionListHtml("x{$attendancedetail_grid->RowIndex}_type") ?>
		</select>
</div>
<?php echo $attendancedetail_grid->type->Lookup->getParamTag($attendancedetail_grid, "p_x" . $attendancedetail_grid->RowIndex . "_type") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_attendancedetail_type" class="form-group attendancedetail_type">
<span<?php echo $attendancedetail_grid->type->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($attendancedetail_grid->type->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_type" name="x<?php echo $attendancedetail_grid->RowIndex ?>_type" id="x<?php echo $attendancedetail_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($attendancedetail_grid->type->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="attendancedetail" data-field="x_type" name="o<?php echo $attendancedetail_grid->RowIndex ?>_type" id="o<?php echo $attendancedetail_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($attendancedetail_grid->type->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($attendancedetail_grid->dept->Visible) { // dept ?>
		<td data-name="dept">
<?php if (!$attendancedetail->isConfirm()) { ?>
<span id="el$rowindex$_attendancedetail_dept" class="form-group attendancedetail_dept">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="attendancedetail" data-field="x_dept" data-value-separator="<?php echo $attendancedetail_grid->dept->displayValueSeparatorAttribute() ?>" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dept" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dept"<?php echo $attendancedetail_grid->dept->editAttributes() ?>>
			<?php echo $attendancedetail_grid->dept->selectOptionListHtml("x{$attendancedetail_grid->RowIndex}_dept") ?>
		</select>
</div>
<?php echo $attendancedetail_grid->dept->Lookup->getParamTag($attendancedetail_grid, "p_x" . $attendancedetail_grid->RowIndex . "_dept") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_attendancedetail_dept" class="form-group attendancedetail_dept">
<span<?php echo $attendancedetail_grid->dept->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($attendancedetail_grid->dept->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_dept" name="x<?php echo $attendancedetail_grid->RowIndex ?>_dept" id="x<?php echo $attendancedetail_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($attendancedetail_grid->dept->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="attendancedetail" data-field="x_dept" name="o<?php echo $attendancedetail_grid->RowIndex ?>_dept" id="o<?php echo $attendancedetail_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($attendancedetail_grid->dept->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($attendancedetail_grid->statut->Visible) { // statut ?>
		<td data-name="statut">
<?php if (!$attendancedetail->isConfirm()) { ?>
<span id="el$rowindex$_attendancedetail_statut" class="form-group attendancedetail_statut">
<div id="tp_x<?php echo $attendancedetail_grid->RowIndex ?>_statut" class="ew-template"><input type="radio" class="custom-control-input" data-table="attendancedetail" data-field="x_statut" data-value-separator="<?php echo $attendancedetail_grid->statut->displayValueSeparatorAttribute() ?>" name="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="{value}"<?php echo $attendancedetail_grid->statut->editAttributes() ?>></div>
<div id="dsl_x<?php echo $attendancedetail_grid->RowIndex ?>_statut" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $attendancedetail_grid->statut->radioButtonListHtml(FALSE, "x{$attendancedetail_grid->RowIndex}_statut") ?>
</div></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_attendancedetail_statut" class="form-group attendancedetail_statut">
<span<?php echo $attendancedetail_grid->statut->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($attendancedetail_grid->statut->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_statut" name="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="x<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="<?php echo HtmlEncode($attendancedetail_grid->statut->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="attendancedetail" data-field="x_statut" name="o<?php echo $attendancedetail_grid->RowIndex ?>_statut" id="o<?php echo $attendancedetail_grid->RowIndex ?>_statut" value="<?php echo HtmlEncode($attendancedetail_grid->statut->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$attendancedetail_grid->ListOptions->render("body", "right", $attendancedetail_grid->RowIndex);
?>
<script>
loadjs.ready(["fattendancedetailgrid", "load"], function() {
	fattendancedetailgrid.updateLists(<?php echo $attendancedetail_grid->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($attendancedetail->CurrentMode == "add" || $attendancedetail->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $attendancedetail_grid->FormKeyCountName ?>" id="<?php echo $attendancedetail_grid->FormKeyCountName ?>" value="<?php echo $attendancedetail_grid->KeyCount ?>">
<?php echo $attendancedetail_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($attendancedetail->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $attendancedetail_grid->FormKeyCountName ?>" id="<?php echo $attendancedetail_grid->FormKeyCountName ?>" value="<?php echo $attendancedetail_grid->KeyCount ?>">
<?php echo $attendancedetail_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($attendancedetail->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fattendancedetailgrid">
</div><!-- /.ew-list-form -->
<?php

// Close recordset
if ($attendancedetail_grid->Recordset)
	$attendancedetail_grid->Recordset->Close();
?>
<?php if ($attendancedetail_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $attendancedetail_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($attendancedetail_grid->TotalRecords == 0 && !$attendancedetail->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $attendancedetail_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if (!$attendancedetail_grid->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php
$attendancedetail_grid->terminate();
?>