<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$attendancedetail_edit = new attendancedetail_edit();

// Run the page
$attendancedetail_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attendancedetail_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fattendancedetailedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fattendancedetailedit = currentForm = new ew.Form("fattendancedetailedit", "edit");

	// Validate form
	fattendancedetailedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($attendancedetail_edit->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_edit->idemp->caption(), $attendancedetail_edit->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($attendancedetail_edit->statut->Required) { ?>
				elm = this.getElements("x" + infix + "_statut");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_edit->statut->caption(), $attendancedetail_edit->statut->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fattendancedetailedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fattendancedetailedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fattendancedetailedit.lists["x_statut"] = <?php echo $attendancedetail_edit->statut->Lookup->toClientList($attendancedetail_edit) ?>;
	fattendancedetailedit.lists["x_statut"].options = <?php echo JsonEncode($attendancedetail_edit->statut->options(FALSE, TRUE)) ?>;
	loadjs.done("fattendancedetailedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $attendancedetail_edit->showPageHeader(); ?>
<?php
$attendancedetail_edit->showMessage();
?>
<form name="fattendancedetailedit" id="fattendancedetailedit" class="<?php echo $attendancedetail_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="attendancedetail">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$attendancedetail_edit->IsModal ?>">
<?php if ($attendancedetail->getCurrentMasterTable() == "attendance") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="attendance">
<input type="hidden" name="fk_idatt" value="<?php echo HtmlEncode($attendancedetail_edit->idatt->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($attendancedetail_edit->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_attendancedetail_idemp" for="x_idemp" class="<?php echo $attendancedetail_edit->LeftColumnClass ?>"><?php echo $attendancedetail_edit->idemp->caption() ?><?php echo $attendancedetail_edit->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendancedetail_edit->RightColumnClass ?>"><div <?php echo $attendancedetail_edit->idemp->cellAttributes() ?>>
<span id="el_attendancedetail_idemp">
<span<?php echo $attendancedetail_edit->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($attendancedetail_edit->idemp->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" name="x_idemp" id="x_idemp" value="<?php echo HtmlEncode($attendancedetail_edit->idemp->CurrentValue) ?>">
<?php echo $attendancedetail_edit->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($attendancedetail_edit->statut->Visible) { // statut ?>
	<div id="r_statut" class="form-group row">
		<label id="elh_attendancedetail_statut" class="<?php echo $attendancedetail_edit->LeftColumnClass ?>"><?php echo $attendancedetail_edit->statut->caption() ?><?php echo $attendancedetail_edit->statut->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendancedetail_edit->RightColumnClass ?>"><div <?php echo $attendancedetail_edit->statut->cellAttributes() ?>>
<span id="el_attendancedetail_statut">
<div id="tp_x_statut" class="ew-template"><input type="radio" class="custom-control-input" data-table="attendancedetail" data-field="x_statut" data-value-separator="<?php echo $attendancedetail_edit->statut->displayValueSeparatorAttribute() ?>" name="x_statut" id="x_statut" value="{value}"<?php echo $attendancedetail_edit->statut->editAttributes() ?>></div>
<div id="dsl_x_statut" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $attendancedetail_edit->statut->radioButtonListHtml(FALSE, "x_statut") ?>
</div></div>
</span>
<?php echo $attendancedetail_edit->statut->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
	<input type="hidden" data-table="attendancedetail" data-field="x_idattdetail" name="x_idattdetail" id="x_idattdetail" value="<?php echo HtmlEncode($attendancedetail_edit->idattdetail->CurrentValue) ?>">
<?php if (!$attendancedetail_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $attendancedetail_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $attendancedetail_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$attendancedetail_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$attendancedetail_edit->terminate();
?>