<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$attendancedetail_add = new attendancedetail_add();

// Run the page
$attendancedetail_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attendancedetail_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fattendancedetailadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fattendancedetailadd = currentForm = new ew.Form("fattendancedetailadd", "add");

	// Validate form
	fattendancedetailadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($attendancedetail_add->dateattdetail->Required) { ?>
				elm = this.getElements("x" + infix + "_dateattdetail");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_add->dateattdetail->caption(), $attendancedetail_add->dateattdetail->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dateattdetail");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($attendancedetail_add->dateattdetail->errorMessage()) ?>");
			<?php if ($attendancedetail_add->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_add->idemp->caption(), $attendancedetail_add->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($attendancedetail_add->statut->Required) { ?>
				elm = this.getElements("x" + infix + "_statut");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_add->statut->caption(), $attendancedetail_add->statut->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($attendancedetail_add->idatt->Required) { ?>
				elm = this.getElements("x" + infix + "_idatt");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendancedetail_add->idatt->caption(), $attendancedetail_add->idatt->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idatt");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($attendancedetail_add->idatt->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fattendancedetailadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fattendancedetailadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fattendancedetailadd.lists["x_idemp"] = <?php echo $attendancedetail_add->idemp->Lookup->toClientList($attendancedetail_add) ?>;
	fattendancedetailadd.lists["x_idemp"].options = <?php echo JsonEncode($attendancedetail_add->idemp->lookupOptions()) ?>;
	fattendancedetailadd.lists["x_statut"] = <?php echo $attendancedetail_add->statut->Lookup->toClientList($attendancedetail_add) ?>;
	fattendancedetailadd.lists["x_statut"].options = <?php echo JsonEncode($attendancedetail_add->statut->options(FALSE, TRUE)) ?>;
	loadjs.done("fattendancedetailadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $attendancedetail_add->showPageHeader(); ?>
<?php
$attendancedetail_add->showMessage();
?>
<form name="fattendancedetailadd" id="fattendancedetailadd" class="<?php echo $attendancedetail_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="attendancedetail">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$attendancedetail_add->IsModal ?>">
<?php if ($attendancedetail->getCurrentMasterTable() == "attendance") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="attendance">
<input type="hidden" name="fk_idatt" value="<?php echo HtmlEncode($attendancedetail_add->idatt->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($attendancedetail_add->dateattdetail->Visible) { // dateattdetail ?>
	<div id="r_dateattdetail" class="form-group row">
		<label id="elh_attendancedetail_dateattdetail" for="x_dateattdetail" class="<?php echo $attendancedetail_add->LeftColumnClass ?>"><?php echo $attendancedetail_add->dateattdetail->caption() ?><?php echo $attendancedetail_add->dateattdetail->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendancedetail_add->RightColumnClass ?>"><div <?php echo $attendancedetail_add->dateattdetail->cellAttributes() ?>>
<span id="el_attendancedetail_dateattdetail">
<input type="text" data-table="attendancedetail" data-field="x_dateattdetail" data-format="7" name="x_dateattdetail" id="x_dateattdetail" maxlength="10" placeholder="<?php echo HtmlEncode($attendancedetail_add->dateattdetail->getPlaceHolder()) ?>" value="<?php echo $attendancedetail_add->dateattdetail->EditValue ?>"<?php echo $attendancedetail_add->dateattdetail->editAttributes() ?>>
<?php if (!$attendancedetail_add->dateattdetail->ReadOnly && !$attendancedetail_add->dateattdetail->Disabled && !isset($attendancedetail_add->dateattdetail->EditAttrs["readonly"]) && !isset($attendancedetail_add->dateattdetail->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fattendancedetailadd", "datetimepicker"], function() {
	ew.createDateTimePicker("fattendancedetailadd", "x_dateattdetail", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $attendancedetail_add->dateattdetail->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($attendancedetail_add->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_attendancedetail_idemp" for="x_idemp" class="<?php echo $attendancedetail_add->LeftColumnClass ?>"><?php echo $attendancedetail_add->idemp->caption() ?><?php echo $attendancedetail_add->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendancedetail_add->RightColumnClass ?>"><div <?php echo $attendancedetail_add->idemp->cellAttributes() ?>>
<span id="el_attendancedetail_idemp">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idemp"><?php echo EmptyValue(strval($attendancedetail_add->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $attendancedetail_add->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($attendancedetail_add->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($attendancedetail_add->idemp->ReadOnly || $attendancedetail_add->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $attendancedetail_add->idemp->Lookup->getParamTag($attendancedetail_add, "p_x_idemp") ?>
<input type="hidden" data-table="attendancedetail" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $attendancedetail_add->idemp->displayValueSeparatorAttribute() ?>" name="x_idemp" id="x_idemp" value="<?php echo $attendancedetail_add->idemp->CurrentValue ?>"<?php echo $attendancedetail_add->idemp->editAttributes() ?>>
</span>
<?php echo $attendancedetail_add->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($attendancedetail_add->statut->Visible) { // statut ?>
	<div id="r_statut" class="form-group row">
		<label id="elh_attendancedetail_statut" class="<?php echo $attendancedetail_add->LeftColumnClass ?>"><?php echo $attendancedetail_add->statut->caption() ?><?php echo $attendancedetail_add->statut->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendancedetail_add->RightColumnClass ?>"><div <?php echo $attendancedetail_add->statut->cellAttributes() ?>>
<span id="el_attendancedetail_statut">
<div id="tp_x_statut" class="ew-template"><input type="radio" class="custom-control-input" data-table="attendancedetail" data-field="x_statut" data-value-separator="<?php echo $attendancedetail_add->statut->displayValueSeparatorAttribute() ?>" name="x_statut" id="x_statut" value="{value}"<?php echo $attendancedetail_add->statut->editAttributes() ?>></div>
<div id="dsl_x_statut" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $attendancedetail_add->statut->radioButtonListHtml(FALSE, "x_statut") ?>
</div></div>
</span>
<?php echo $attendancedetail_add->statut->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($attendancedetail_add->idatt->Visible) { // idatt ?>
	<div id="r_idatt" class="form-group row">
		<label id="elh_attendancedetail_idatt" for="x_idatt" class="<?php echo $attendancedetail_add->LeftColumnClass ?>"><?php echo $attendancedetail_add->idatt->caption() ?><?php echo $attendancedetail_add->idatt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendancedetail_add->RightColumnClass ?>"><div <?php echo $attendancedetail_add->idatt->cellAttributes() ?>>
<?php if ($attendancedetail_add->idatt->getSessionValue() != "") { ?>
<span id="el_attendancedetail_idatt">
<span<?php echo $attendancedetail_add->idatt->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($attendancedetail_add->idatt->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x_idatt" name="x_idatt" value="<?php echo HtmlEncode($attendancedetail_add->idatt->CurrentValue) ?>">
<?php } else { ?>
<span id="el_attendancedetail_idatt">
<input type="text" data-table="attendancedetail" data-field="x_idatt" name="x_idatt" id="x_idatt" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($attendancedetail_add->idatt->getPlaceHolder()) ?>" value="<?php echo $attendancedetail_add->idatt->EditValue ?>"<?php echo $attendancedetail_add->idatt->editAttributes() ?>>
</span>
<?php } ?>
<?php echo $attendancedetail_add->idatt->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$attendancedetail_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $attendancedetail_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $attendancedetail_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$attendancedetail_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$attendancedetail_add->terminate();
?>