<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$attendance_delete = new attendance_delete();

// Run the page
$attendance_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attendance_delete->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fattendancedelete, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "delete";
	fattendancedelete = currentForm = new ew.Form("fattendancedelete", "delete");
	loadjs.done("fattendancedelete");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $attendance_delete->showPageHeader(); ?>
<?php
$attendance_delete->showMessage();
?>
<form name="fattendancedelete" id="fattendancedelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="attendance">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($attendance_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($attendance_delete->idatt->Visible) { // idatt ?>
		<th class="<?php echo $attendance_delete->idatt->headerCellClass() ?>"><span id="elh_attendance_idatt" class="attendance_idatt"><?php echo $attendance_delete->idatt->caption() ?></span></th>
<?php } ?>
<?php if ($attendance_delete->descrip->Visible) { // descrip ?>
		<th class="<?php echo $attendance_delete->descrip->headerCellClass() ?>"><span id="elh_attendance_descrip" class="attendance_descrip"><?php echo $attendance_delete->descrip->caption() ?></span></th>
<?php } ?>
<?php if ($attendance_delete->dateatt->Visible) { // dateatt ?>
		<th class="<?php echo $attendance_delete->dateatt->headerCellClass() ?>"><span id="elh_attendance_dateatt" class="attendance_dateatt"><?php echo $attendance_delete->dateatt->caption() ?></span></th>
<?php } ?>
<?php if ($attendance_delete->note->Visible) { // note ?>
		<th class="<?php echo $attendance_delete->note->headerCellClass() ?>"><span id="elh_attendance_note" class="attendance_note"><?php echo $attendance_delete->note->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$attendance_delete->RecordCount = 0;
$i = 0;
while (!$attendance_delete->Recordset->EOF) {
	$attendance_delete->RecordCount++;
	$attendance_delete->RowCount++;

	// Set row properties
	$attendance->resetAttributes();
	$attendance->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$attendance_delete->loadRowValues($attendance_delete->Recordset);

	// Render row
	$attendance_delete->renderRow();
?>
	<tr <?php echo $attendance->rowAttributes() ?>>
<?php if ($attendance_delete->idatt->Visible) { // idatt ?>
		<td <?php echo $attendance_delete->idatt->cellAttributes() ?>>
<span id="el<?php echo $attendance_delete->RowCount ?>_attendance_idatt" class="attendance_idatt">
<span<?php echo $attendance_delete->idatt->viewAttributes() ?>><?php echo $attendance_delete->idatt->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($attendance_delete->descrip->Visible) { // descrip ?>
		<td <?php echo $attendance_delete->descrip->cellAttributes() ?>>
<span id="el<?php echo $attendance_delete->RowCount ?>_attendance_descrip" class="attendance_descrip">
<span<?php echo $attendance_delete->descrip->viewAttributes() ?>><?php echo $attendance_delete->descrip->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($attendance_delete->dateatt->Visible) { // dateatt ?>
		<td <?php echo $attendance_delete->dateatt->cellAttributes() ?>>
<span id="el<?php echo $attendance_delete->RowCount ?>_attendance_dateatt" class="attendance_dateatt">
<span<?php echo $attendance_delete->dateatt->viewAttributes() ?>><?php echo $attendance_delete->dateatt->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($attendance_delete->note->Visible) { // note ?>
		<td <?php echo $attendance_delete->note->cellAttributes() ?>>
<span id="el<?php echo $attendance_delete->RowCount ?>_attendance_note" class="attendance_note">
<span<?php echo $attendance_delete->note->viewAttributes() ?>><?php echo $attendance_delete->note->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$attendance_delete->Recordset->moveNext();
}
$attendance_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $attendance_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$attendance_delete->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$attendance_delete->terminate();
?>