<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$attendance_add = new attendance_add();

// Run the page
$attendance_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attendance_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fattendanceadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fattendanceadd = currentForm = new ew.Form("fattendanceadd", "add");

	// Validate form
	fattendanceadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($attendance_add->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendance_add->descrip->caption(), $attendance_add->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($attendance_add->dateatt->Required) { ?>
				elm = this.getElements("x" + infix + "_dateatt");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendance_add->dateatt->caption(), $attendance_add->dateatt->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dateatt");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($attendance_add->dateatt->errorMessage()) ?>");
			<?php if ($attendance_add->note->Required) { ?>
				elm = this.getElements("x" + infix + "_note");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $attendance_add->note->caption(), $attendance_add->note->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fattendanceadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fattendanceadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fattendanceadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $attendance_add->showPageHeader(); ?>
<?php
$attendance_add->showMessage();
?>
<form name="fattendanceadd" id="fattendanceadd" class="<?php echo $attendance_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="attendance">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$attendance_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($attendance_add->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_attendance_descrip" for="x_descrip" class="<?php echo $attendance_add->LeftColumnClass ?>"><?php echo $attendance_add->descrip->caption() ?><?php echo $attendance_add->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendance_add->RightColumnClass ?>"><div <?php echo $attendance_add->descrip->cellAttributes() ?>>
<span id="el_attendance_descrip">
<input type="text" data-table="attendance" data-field="x_descrip" name="x_descrip" id="x_descrip" size="50" maxlength="200" placeholder="<?php echo HtmlEncode($attendance_add->descrip->getPlaceHolder()) ?>" value="<?php echo $attendance_add->descrip->EditValue ?>"<?php echo $attendance_add->descrip->editAttributes() ?>>
</span>
<?php echo $attendance_add->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($attendance_add->dateatt->Visible) { // dateatt ?>
	<div id="r_dateatt" class="form-group row">
		<label id="elh_attendance_dateatt" for="x_dateatt" class="<?php echo $attendance_add->LeftColumnClass ?>"><?php echo $attendance_add->dateatt->caption() ?><?php echo $attendance_add->dateatt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendance_add->RightColumnClass ?>"><div <?php echo $attendance_add->dateatt->cellAttributes() ?>>
<span id="el_attendance_dateatt">
<input type="text" data-table="attendance" data-field="x_dateatt" data-format="7" name="x_dateatt" id="x_dateatt" maxlength="10" placeholder="<?php echo HtmlEncode($attendance_add->dateatt->getPlaceHolder()) ?>" value="<?php echo $attendance_add->dateatt->EditValue ?>"<?php echo $attendance_add->dateatt->editAttributes() ?>>
<?php if (!$attendance_add->dateatt->ReadOnly && !$attendance_add->dateatt->Disabled && !isset($attendance_add->dateatt->EditAttrs["readonly"]) && !isset($attendance_add->dateatt->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fattendanceadd", "datetimepicker"], function() {
	ew.createDateTimePicker("fattendanceadd", "x_dateatt", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $attendance_add->dateatt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($attendance_add->note->Visible) { // note ?>
	<div id="r_note" class="form-group row">
		<label id="elh_attendance_note" for="x_note" class="<?php echo $attendance_add->LeftColumnClass ?>"><?php echo $attendance_add->note->caption() ?><?php echo $attendance_add->note->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $attendance_add->RightColumnClass ?>"><div <?php echo $attendance_add->note->cellAttributes() ?>>
<span id="el_attendance_note">
<input type="text" data-table="attendance" data-field="x_note" name="x_note" id="x_note" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($attendance_add->note->getPlaceHolder()) ?>" value="<?php echo $attendance_add->note->EditValue ?>"<?php echo $attendance_add->note->editAttributes() ?>>
</span>
<?php echo $attendance_add->note->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("datatemp", explode(",", $attendance->getCurrentDetailTable())) && $datatemp->DetailAdd) {
?>
<?php if ($attendance->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("datatemp", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "datatempgrid.php" ?>
<?php } ?>
<?php
	if (in_array("ej_datatemps", explode(",", $attendance->getCurrentDetailTable())) && $ej_datatemps->DetailAdd) {
?>
<?php if ($attendance->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("ej_datatemps", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "ej_datatempsgrid.php" ?>
<?php } ?>
<?php
	if (in_array("attendancedetail", explode(",", $attendance->getCurrentDetailTable())) && $attendancedetail->DetailAdd) {
?>
<?php if ($attendance->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("attendancedetail", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "attendancedetailgrid.php" ?>
<?php } ?>
<?php if (!$attendance_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $attendance_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $attendance_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$attendance_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$attendance_add->terminate();
?>