<?php

namespace PHPMaker2022\cfpb;

// Set up and run Grid object
$Grid = Container("PaiementGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fpaiementgrid;
loadjs.ready(["wrapper", "head"], function () {
    var $ = jQuery;
    // Form object
    fpaiementgrid = new ew.Form("fpaiementgrid", "grid");
    fpaiementgrid.formKeyCountName = "<?= $Grid->FormKeyCountName ?>";

    // Add fields
    var currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { paiement: currentTable } });
    var fields = currentTable.fields;
    fpaiementgrid.addFields([
        ["id_owner", [fields.id_owner.visible && fields.id_owner.required ? ew.Validators.required(fields.id_owner.caption) : null], fields.id_owner.isInvalid],
        ["id_immeuble", [fields.id_immeuble.visible && fields.id_immeuble.required ? ew.Validators.required(fields.id_immeuble.caption) : null], fields.id_immeuble.isInvalid],
        ["id_ex_fiscal", [fields.id_ex_fiscal.visible && fields.id_ex_fiscal.required ? ew.Validators.required(fields.id_ex_fiscal.caption) : null], fields.id_ex_fiscal.isInvalid],
        ["montant", [fields.montant.visible && fields.montant.required ? ew.Validators.required(fields.montant.caption) : null, ew.Validators.float], fields.montant.isInvalid],
        ["datepaie", [fields.datepaie.visible && fields.datepaie.required ? ew.Validators.required(fields.datepaie.caption) : null, ew.Validators.datetime(fields.datepaie.clientFormatPattern)], fields.datepaie.isInvalid]
    ]);

    // Check empty row
    fpaiementgrid.emptyRow = function (rowIndex) {
        var fobj = this.getForm(),
            fields = [["id_owner",false],["id_immeuble",false],["id_ex_fiscal",false],["montant",false],["datepaie",false]];
        if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
            return false;
        return true;
    }

    // Form_CustomValidate
    fpaiementgrid.customValidate = function(fobj) { // DO NOT CHANGE THIS LINE!
        // Your custom validation code here, return false if invalid.
        return true;
    }

    // Use JavaScript validation or not
    fpaiementgrid.validateRequired = ew.CLIENT_VALIDATE;

    // Dynamic selection lists
    fpaiementgrid.lists.id_owner = <?= $Grid->id_owner->toClientList($Grid) ?>;
    fpaiementgrid.lists.id_immeuble = <?= $Grid->id_immeuble->toClientList($Grid) ?>;
    fpaiementgrid.lists.id_ex_fiscal = <?= $Grid->id_ex_fiscal->toClientList($Grid) ?>;
    loadjs.done("fpaiementgrid");
});
</script>
<?php } ?>
<?php
$Grid->renderOtherOptions();
?>
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($Grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> paiement">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fpaiementgrid" class="ew-form ew-list-form">
<div id="gmp_paiement" class="<?= ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_paiementgrid" class="table table-bordered table-hover table-sm ew-table"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = ROWTYPE_HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id_owner->Visible) { // id_owner ?>
        <th data-name="id_owner" class="<?= $Grid->id_owner->headerCellClass() ?>"><div id="elh_paiement_id_owner" class="paiement_id_owner"><?= $Grid->renderFieldHeader($Grid->id_owner) ?></div></th>
<?php } ?>
<?php if ($Grid->id_immeuble->Visible) { // id_immeuble ?>
        <th data-name="id_immeuble" class="<?= $Grid->id_immeuble->headerCellClass() ?>"><div id="elh_paiement_id_immeuble" class="paiement_id_immeuble"><?= $Grid->renderFieldHeader($Grid->id_immeuble) ?></div></th>
<?php } ?>
<?php if ($Grid->id_ex_fiscal->Visible) { // id_ex_fiscal ?>
        <th data-name="id_ex_fiscal" class="<?= $Grid->id_ex_fiscal->headerCellClass() ?>"><div id="elh_paiement_id_ex_fiscal" class="paiement_id_ex_fiscal"><?= $Grid->renderFieldHeader($Grid->id_ex_fiscal) ?></div></th>
<?php } ?>
<?php if ($Grid->montant->Visible) { // montant ?>
        <th data-name="montant" class="<?= $Grid->montant->headerCellClass() ?>"><div id="elh_paiement_montant" class="paiement_montant"><?= $Grid->renderFieldHeader($Grid->montant) ?></div></th>
<?php } ?>
<?php if ($Grid->datepaie->Visible) { // datepaie ?>
        <th data-name="datepaie" class="<?= $Grid->datepaie->headerCellClass() ?>"><div id="elh_paiement_datepaie" class="paiement_datepaie"><?= $Grid->renderFieldHeader($Grid->datepaie) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody>
<?php
$Grid->StartRecord = 1;
$Grid->StopRecord = $Grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($Grid->isConfirm() || $Grid->EventCancelled)) {
    $CurrentForm->Index = -1;
    if ($CurrentForm->hasValue($Grid->FormKeyCountName) && ($Grid->isGridAdd() || $Grid->isGridEdit() || $Grid->isConfirm())) {
        $Grid->KeyCount = $CurrentForm->getValue($Grid->FormKeyCountName);
        $Grid->StopRecord = $Grid->StartRecord + $Grid->KeyCount - 1;
    }
}
$Grid->RecordCount = $Grid->StartRecord - 1;
if ($Grid->Recordset && !$Grid->Recordset->EOF) {
    // Nothing to do
} elseif ($Grid->isGridAdd() && !$Grid->AllowAddDeleteRow && $Grid->StopRecord == 0) {
    $Grid->StopRecord = $Grid->GridAddRowCount;
}

// Initialize aggregate
$Grid->RowType = ROWTYPE_AGGREGATEINIT;
$Grid->resetAttributes();
$Grid->renderRow();
while ($Grid->RecordCount < $Grid->StopRecord) {
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->RowCount++;
        if ($Grid->isAdd() || $Grid->isGridAdd() || $Grid->isGridEdit() || $Grid->isConfirm()) {
            $Grid->RowIndex++;
            $CurrentForm->Index = $Grid->RowIndex;
            if ($CurrentForm->hasValue($Grid->FormActionName) && ($Grid->isConfirm() || $Grid->EventCancelled)) {
                $Grid->RowAction = strval($CurrentForm->getValue($Grid->FormActionName));
            } elseif ($Grid->isGridAdd()) {
                $Grid->RowAction = "insert";
            } else {
                $Grid->RowAction = "";
            }
        }

        // Set up key count
        $Grid->KeyCount = $Grid->RowIndex;

        // Init row class and style
        $Grid->resetAttributes();
        $Grid->CssClass = "";
        if ($Grid->isGridAdd()) {
            if ($Grid->CurrentMode == "copy") {
                $Grid->loadRowValues($Grid->Recordset); // Load row values
                $Grid->OldKey = $Grid->getKey(true); // Get from CurrentValue
            } else {
                $Grid->loadRowValues(); // Load default values
                $Grid->OldKey = "";
            }
        } else {
            $Grid->loadRowValues($Grid->Recordset); // Load row values
            $Grid->OldKey = $Grid->getKey(true); // Get from CurrentValue
        }
        $Grid->setKey($Grid->OldKey);
        $Grid->RowType = ROWTYPE_VIEW; // Render view
        if ($Grid->isGridAdd()) { // Grid add
            $Grid->RowType = ROWTYPE_ADD; // Render add
        }
        if ($Grid->isGridAdd() && $Grid->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) { // Insert failed
            $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
        }
        if ($Grid->isGridEdit()) { // Grid edit
            if ($Grid->EventCancelled) {
                $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
            }
            if ($Grid->RowAction == "insert") {
                $Grid->RowType = ROWTYPE_ADD; // Render add
            } else {
                $Grid->RowType = ROWTYPE_EDIT; // Render edit
            }
        }
        if ($Grid->isGridEdit() && ($Grid->RowType == ROWTYPE_EDIT || $Grid->RowType == ROWTYPE_ADD) && $Grid->EventCancelled) { // Update failed
            $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
        }
        if ($Grid->RowType == ROWTYPE_EDIT) { // Edit row
            $Grid->EditRowCount++;
        }
        if ($Grid->isConfirm()) { // Confirm row
            $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
        }

        // Set up row attributes
        $Grid->RowAttrs->merge([
            "data-rowindex" => $Grid->RowCount,
            "id" => "r" . $Grid->RowCount . "_paiement",
            "data-rowtype" => $Grid->RowType,
            "class" => ($Grid->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($Grid->isAdd() && $Grid->RowType == ROWTYPE_ADD || $Grid->isEdit() && $Grid->RowType == ROWTYPE_EDIT) { // Inline-Add/Edit row
            $Grid->RowAttrs->appendClass("table-active");
        }

        // Render row
        $Grid->renderRow();

        // Render list options
        $Grid->renderListOptions();

        // Skip delete row / empty row for confirm page
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow())
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id_owner->Visible) { // id_owner ?>
        <td data-name="id_owner"<?= $Grid->id_owner->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_id_owner" class="el_paiement_id_owner">
<?php $Grid->id_owner->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
    <select
        id="x<?= $Grid->RowIndex ?>_id_owner"
        name="x<?= $Grid->RowIndex ?>_id_owner"
        class="form-control ew-select<?= $Grid->id_owner->isInvalidClass() ?>"
        data-select2-id="fpaiementgrid_x<?= $Grid->RowIndex ?>_id_owner"
        data-table="paiement"
        data-field="x_id_owner"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->id_owner->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->id_owner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->id_owner->getPlaceHolder()) ?>"
        <?= $Grid->id_owner->editAttributes() ?>>
        <?= $Grid->id_owner->selectOptionListHtml("x{$Grid->RowIndex}_id_owner") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->id_owner->getErrorMessage() ?></div>
<?= $Grid->id_owner->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_id_owner") ?>
<script>
loadjs.ready("fpaiementgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_id_owner", selectId: "fpaiementgrid_x<?= $Grid->RowIndex ?>_id_owner" };
    if (fpaiementgrid.lists.id_owner.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_id_owner", form: "fpaiementgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_id_owner", form: "fpaiementgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.paiement.fields.id_owner.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="paiement" data-field="x_id_owner" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id_owner" id="o<?= $Grid->RowIndex ?>_id_owner" value="<?= HtmlEncode($Grid->id_owner->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php $Grid->id_owner->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
    <select
        id="x<?= $Grid->RowIndex ?>_id_owner"
        name="x<?= $Grid->RowIndex ?>_id_owner"
        class="form-control ew-select<?= $Grid->id_owner->isInvalidClass() ?>"
        data-select2-id="fpaiementgrid_x<?= $Grid->RowIndex ?>_id_owner"
        data-table="paiement"
        data-field="x_id_owner"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->id_owner->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->id_owner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->id_owner->getPlaceHolder()) ?>"
        <?= $Grid->id_owner->editAttributes() ?>>
        <?= $Grid->id_owner->selectOptionListHtml("x{$Grid->RowIndex}_id_owner") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->id_owner->getErrorMessage() ?></div>
<?= $Grid->id_owner->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_id_owner") ?>
<script>
loadjs.ready("fpaiementgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_id_owner", selectId: "fpaiementgrid_x<?= $Grid->RowIndex ?>_id_owner" };
    if (fpaiementgrid.lists.id_owner.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_id_owner", form: "fpaiementgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_id_owner", form: "fpaiementgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.paiement.fields.id_owner.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
<input type="hidden" data-table="paiement" data-field="x_id_owner" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id_owner" id="o<?= $Grid->RowIndex ?>_id_owner" value="<?= HtmlEncode($Grid->id_owner->OldValue ?? $Grid->id_owner->CurrentValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_id_owner" class="el_paiement_id_owner">
<span<?= $Grid->id_owner->viewAttributes() ?>>
<?= $Grid->id_owner->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="paiement" data-field="x_id_owner" data-hidden="1" name="fpaiementgrid$x<?= $Grid->RowIndex ?>_id_owner" id="fpaiementgrid$x<?= $Grid->RowIndex ?>_id_owner" value="<?= HtmlEncode($Grid->id_owner->FormValue) ?>">
<input type="hidden" data-table="paiement" data-field="x_id_owner" data-hidden="1" name="fpaiementgrid$o<?= $Grid->RowIndex ?>_id_owner" id="fpaiementgrid$o<?= $Grid->RowIndex ?>_id_owner" value="<?= HtmlEncode($Grid->id_owner->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="paiement" data-field="x_id_owner" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id_owner" id="x<?= $Grid->RowIndex ?>_id_owner" value="<?= HtmlEncode($Grid->id_owner->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->id_immeuble->Visible) { // id_immeuble ?>
        <td data-name="id_immeuble"<?= $Grid->id_immeuble->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($Grid->id_immeuble->getSessionValue() != "") { ?>
<span id="el<?= $Grid->RowCount ?>_paiement_id_immeuble" class="el_paiement_id_immeuble">
<span<?= $Grid->id_immeuble->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->id_immeuble->getDisplayValue($Grid->id_immeuble->ViewValue) ?></span></span>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_id_immeuble" name="x<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode(FormatNumber($Grid->id_immeuble->CurrentValue, $Grid->id_immeuble->formatPattern())) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowCount ?>_paiement_id_immeuble" class="el_paiement_id_immeuble">
    <select
        id="x<?= $Grid->RowIndex ?>_id_immeuble"
        name="x<?= $Grid->RowIndex ?>_id_immeuble"
        class="form-control ew-select<?= $Grid->id_immeuble->isInvalidClass() ?>"
        data-select2-id="fpaiementgrid_x<?= $Grid->RowIndex ?>_id_immeuble"
        data-table="paiement"
        data-field="x_id_immeuble"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->id_immeuble->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->id_immeuble->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->id_immeuble->getPlaceHolder()) ?>"
        <?= $Grid->id_immeuble->editAttributes() ?>>
        <?= $Grid->id_immeuble->selectOptionListHtml("x{$Grid->RowIndex}_id_immeuble") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->id_immeuble->getErrorMessage() ?></div>
<?= $Grid->id_immeuble->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_id_immeuble") ?>
<script>
loadjs.ready("fpaiementgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_id_immeuble", selectId: "fpaiementgrid_x<?= $Grid->RowIndex ?>_id_immeuble" };
    if (fpaiementgrid.lists.id_immeuble.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_id_immeuble", form: "fpaiementgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_id_immeuble", form: "fpaiementgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.paiement.fields.id_immeuble.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="paiement" data-field="x_id_immeuble" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id_immeuble" id="o<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode($Grid->id_immeuble->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($Grid->id_immeuble->getSessionValue() != "") { ?>
<span id="el<?= $Grid->RowCount ?>_paiement_id_immeuble" class="el_paiement_id_immeuble">
<span<?= $Grid->id_immeuble->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->id_immeuble->getDisplayValue($Grid->id_immeuble->EditValue) ?></span></span>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_id_immeuble" name="x<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode($Grid->id_immeuble->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
    <select
        id="x<?= $Grid->RowIndex ?>_id_immeuble"
        name="x<?= $Grid->RowIndex ?>_id_immeuble"
        class="form-control ew-select<?= $Grid->id_immeuble->isInvalidClass() ?>"
        data-select2-id="fpaiementgrid_x<?= $Grid->RowIndex ?>_id_immeuble"
        data-table="paiement"
        data-field="x_id_immeuble"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->id_immeuble->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->id_immeuble->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->id_immeuble->getPlaceHolder()) ?>"
        <?= $Grid->id_immeuble->editAttributes() ?>>
        <?= $Grid->id_immeuble->selectOptionListHtml("x{$Grid->RowIndex}_id_immeuble") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->id_immeuble->getErrorMessage() ?></div>
<?= $Grid->id_immeuble->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_id_immeuble") ?>
<script>
loadjs.ready("fpaiementgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_id_immeuble", selectId: "fpaiementgrid_x<?= $Grid->RowIndex ?>_id_immeuble" };
    if (fpaiementgrid.lists.id_immeuble.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_id_immeuble", form: "fpaiementgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_id_immeuble", form: "fpaiementgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.paiement.fields.id_immeuble.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
<?php } ?>
<input type="hidden" data-table="paiement" data-field="x_id_immeuble" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id_immeuble" id="o<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode($Grid->id_immeuble->OldValue ?? $Grid->id_immeuble->CurrentValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_id_immeuble" class="el_paiement_id_immeuble">
<span<?= $Grid->id_immeuble->viewAttributes() ?>>
<?= $Grid->id_immeuble->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="paiement" data-field="x_id_immeuble" data-hidden="1" name="fpaiementgrid$x<?= $Grid->RowIndex ?>_id_immeuble" id="fpaiementgrid$x<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode($Grid->id_immeuble->FormValue) ?>">
<input type="hidden" data-table="paiement" data-field="x_id_immeuble" data-hidden="1" name="fpaiementgrid$o<?= $Grid->RowIndex ?>_id_immeuble" id="fpaiementgrid$o<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode($Grid->id_immeuble->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="paiement" data-field="x_id_immeuble" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id_immeuble" id="x<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode($Grid->id_immeuble->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->id_ex_fiscal->Visible) { // id_ex_fiscal ?>
        <td data-name="id_ex_fiscal"<?= $Grid->id_ex_fiscal->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_id_ex_fiscal" class="el_paiement_id_ex_fiscal">
    <select
        id="x<?= $Grid->RowIndex ?>_id_ex_fiscal"
        name="x<?= $Grid->RowIndex ?>_id_ex_fiscal"
        class="form-select ew-select<?= $Grid->id_ex_fiscal->isInvalidClass() ?>"
        data-select2-id="fpaiementgrid_x<?= $Grid->RowIndex ?>_id_ex_fiscal"
        data-table="paiement"
        data-field="x_id_ex_fiscal"
        data-value-separator="<?= $Grid->id_ex_fiscal->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->id_ex_fiscal->getPlaceHolder()) ?>"
        <?= $Grid->id_ex_fiscal->editAttributes() ?>>
        <?= $Grid->id_ex_fiscal->selectOptionListHtml("x{$Grid->RowIndex}_id_ex_fiscal") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->id_ex_fiscal->getErrorMessage() ?></div>
<?= $Grid->id_ex_fiscal->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_id_ex_fiscal") ?>
<script>
loadjs.ready("fpaiementgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_id_ex_fiscal", selectId: "fpaiementgrid_x<?= $Grid->RowIndex ?>_id_ex_fiscal" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpaiementgrid.lists.id_ex_fiscal.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_id_ex_fiscal", form: "fpaiementgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_id_ex_fiscal", form: "fpaiementgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.paiement.fields.id_ex_fiscal.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<input type="hidden" data-table="paiement" data-field="x_id_ex_fiscal" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id_ex_fiscal" id="o<?= $Grid->RowIndex ?>_id_ex_fiscal" value="<?= HtmlEncode($Grid->id_ex_fiscal->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
    <select
        id="x<?= $Grid->RowIndex ?>_id_ex_fiscal"
        name="x<?= $Grid->RowIndex ?>_id_ex_fiscal"
        class="form-select ew-select<?= $Grid->id_ex_fiscal->isInvalidClass() ?>"
        data-select2-id="fpaiementgrid_x<?= $Grid->RowIndex ?>_id_ex_fiscal"
        data-table="paiement"
        data-field="x_id_ex_fiscal"
        data-value-separator="<?= $Grid->id_ex_fiscal->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->id_ex_fiscal->getPlaceHolder()) ?>"
        <?= $Grid->id_ex_fiscal->editAttributes() ?>>
        <?= $Grid->id_ex_fiscal->selectOptionListHtml("x{$Grid->RowIndex}_id_ex_fiscal") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->id_ex_fiscal->getErrorMessage() ?></div>
<?= $Grid->id_ex_fiscal->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_id_ex_fiscal") ?>
<script>
loadjs.ready("fpaiementgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_id_ex_fiscal", selectId: "fpaiementgrid_x<?= $Grid->RowIndex ?>_id_ex_fiscal" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpaiementgrid.lists.id_ex_fiscal.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_id_ex_fiscal", form: "fpaiementgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_id_ex_fiscal", form: "fpaiementgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.paiement.fields.id_ex_fiscal.selectOptions);
    ew.createSelect(options);
});
</script>
<input type="hidden" data-table="paiement" data-field="x_id_ex_fiscal" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id_ex_fiscal" id="o<?= $Grid->RowIndex ?>_id_ex_fiscal" value="<?= HtmlEncode($Grid->id_ex_fiscal->OldValue ?? $Grid->id_ex_fiscal->CurrentValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_id_ex_fiscal" class="el_paiement_id_ex_fiscal">
<span<?= $Grid->id_ex_fiscal->viewAttributes() ?>>
<?= $Grid->id_ex_fiscal->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="paiement" data-field="x_id_ex_fiscal" data-hidden="1" name="fpaiementgrid$x<?= $Grid->RowIndex ?>_id_ex_fiscal" id="fpaiementgrid$x<?= $Grid->RowIndex ?>_id_ex_fiscal" value="<?= HtmlEncode($Grid->id_ex_fiscal->FormValue) ?>">
<input type="hidden" data-table="paiement" data-field="x_id_ex_fiscal" data-hidden="1" name="fpaiementgrid$o<?= $Grid->RowIndex ?>_id_ex_fiscal" id="fpaiementgrid$o<?= $Grid->RowIndex ?>_id_ex_fiscal" value="<?= HtmlEncode($Grid->id_ex_fiscal->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="paiement" data-field="x_id_ex_fiscal" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id_ex_fiscal" id="x<?= $Grid->RowIndex ?>_id_ex_fiscal" value="<?= HtmlEncode($Grid->id_ex_fiscal->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->montant->Visible) { // montant ?>
        <td data-name="montant"<?= $Grid->montant->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_montant" class="el_paiement_montant">
<input type="<?= $Grid->montant->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_montant" id="x<?= $Grid->RowIndex ?>_montant" data-table="paiement" data-field="x_montant" value="<?= $Grid->montant->EditValue ?>" size="15" placeholder="<?= HtmlEncode($Grid->montant->getPlaceHolder()) ?>"<?= $Grid->montant->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->montant->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="paiement" data-field="x_montant" data-hidden="1" name="o<?= $Grid->RowIndex ?>_montant" id="o<?= $Grid->RowIndex ?>_montant" value="<?= HtmlEncode($Grid->montant->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_montant" class="el_paiement_montant">
<input type="<?= $Grid->montant->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_montant" id="x<?= $Grid->RowIndex ?>_montant" data-table="paiement" data-field="x_montant" value="<?= $Grid->montant->EditValue ?>" size="15" placeholder="<?= HtmlEncode($Grid->montant->getPlaceHolder()) ?>"<?= $Grid->montant->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->montant->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_montant" class="el_paiement_montant">
<span<?= $Grid->montant->viewAttributes() ?>>
<?= $Grid->montant->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="paiement" data-field="x_montant" data-hidden="1" name="fpaiementgrid$x<?= $Grid->RowIndex ?>_montant" id="fpaiementgrid$x<?= $Grid->RowIndex ?>_montant" value="<?= HtmlEncode($Grid->montant->FormValue) ?>">
<input type="hidden" data-table="paiement" data-field="x_montant" data-hidden="1" name="fpaiementgrid$o<?= $Grid->RowIndex ?>_montant" id="fpaiementgrid$o<?= $Grid->RowIndex ?>_montant" value="<?= HtmlEncode($Grid->montant->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datepaie->Visible) { // datepaie ?>
        <td data-name="datepaie"<?= $Grid->datepaie->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_datepaie" class="el_paiement_datepaie">
<input type="<?= $Grid->datepaie->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_datepaie" id="x<?= $Grid->RowIndex ?>_datepaie" data-table="paiement" data-field="x_datepaie" value="<?= $Grid->datepaie->EditValue ?>" size="15" placeholder="<?= HtmlEncode($Grid->datepaie->getPlaceHolder()) ?>"<?= $Grid->datepaie->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->datepaie->getErrorMessage() ?></div>
<?php if (!$Grid->datepaie->ReadOnly && !$Grid->datepaie->Disabled && !isset($Grid->datepaie->EditAttrs["readonly"]) && !isset($Grid->datepaie->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpaiementgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(2) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem()
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fas fa-chevron-right" : "fas fa-chevron-left",
                    next: ew.IS_RTL ? "fas fa-chevron-left" : "fas fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i),
                    useTwentyfourHour: !!format.match(/H/)
                }
            },
            meta: {
                format
            }
        };
    ew.createDateTimePicker("fpaiementgrid", "x<?= $Grid->RowIndex ?>_datepaie", ew.deepAssign({"useCurrent":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="paiement" data-field="x_datepaie" data-hidden="1" name="o<?= $Grid->RowIndex ?>_datepaie" id="o<?= $Grid->RowIndex ?>_datepaie" value="<?= HtmlEncode($Grid->datepaie->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_datepaie" class="el_paiement_datepaie">
<input type="<?= $Grid->datepaie->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_datepaie" id="x<?= $Grid->RowIndex ?>_datepaie" data-table="paiement" data-field="x_datepaie" value="<?= $Grid->datepaie->EditValue ?>" size="15" placeholder="<?= HtmlEncode($Grid->datepaie->getPlaceHolder()) ?>"<?= $Grid->datepaie->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->datepaie->getErrorMessage() ?></div>
<?php if (!$Grid->datepaie->ReadOnly && !$Grid->datepaie->Disabled && !isset($Grid->datepaie->EditAttrs["readonly"]) && !isset($Grid->datepaie->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpaiementgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(2) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem()
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fas fa-chevron-right" : "fas fa-chevron-left",
                    next: ew.IS_RTL ? "fas fa-chevron-left" : "fas fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i),
                    useTwentyfourHour: !!format.match(/H/)
                }
            },
            meta: {
                format
            }
        };
    ew.createDateTimePicker("fpaiementgrid", "x<?= $Grid->RowIndex ?>_datepaie", ew.deepAssign({"useCurrent":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_paiement_datepaie" class="el_paiement_datepaie">
<span<?= $Grid->datepaie->viewAttributes() ?>>
<?= $Grid->datepaie->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="paiement" data-field="x_datepaie" data-hidden="1" name="fpaiementgrid$x<?= $Grid->RowIndex ?>_datepaie" id="fpaiementgrid$x<?= $Grid->RowIndex ?>_datepaie" value="<?= HtmlEncode($Grid->datepaie->FormValue) ?>">
<input type="hidden" data-table="paiement" data-field="x_datepaie" data-hidden="1" name="fpaiementgrid$o<?= $Grid->RowIndex ?>_datepaie" id="fpaiementgrid$o<?= $Grid->RowIndex ?>_datepaie" value="<?= HtmlEncode($Grid->datepaie->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == ROWTYPE_ADD || $Grid->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fpaiementgrid","load"], () => fpaiementgrid.updateLists(<?= $Grid->RowIndex ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking
    if (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy")
        if (!$Grid->Recordset->EOF) {
            $Grid->Recordset->moveNext();
        }
}
?>
<?php
if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy" || $Grid->CurrentMode == "edit") {
    $Grid->RowIndex = '$rowindex$';
    $Grid->loadRowValues();

    // Set row properties
    $Grid->resetAttributes();
    $Grid->RowAttrs->merge(["data-rowindex" => $Grid->RowIndex, "id" => "r0_paiement", "data-rowtype" => ROWTYPE_ADD]);
    $Grid->RowAttrs->appendClass("ew-template");

    // Reset previous form error if any
    $Grid->resetFormError();

    // Render row
    $Grid->RowType = ROWTYPE_ADD;
    $Grid->renderRow();

    // Render list options
    $Grid->renderListOptions();
    $Grid->StartRowCount = 0;
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowIndex);
?>
    <?php if ($Grid->id_owner->Visible) { // id_owner ?>
        <td data-name="id_owner">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_paiement_id_owner" class="el_paiement_id_owner">
<?php $Grid->id_owner->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
    <select
        id="x<?= $Grid->RowIndex ?>_id_owner"
        name="x<?= $Grid->RowIndex ?>_id_owner"
        class="form-control ew-select<?= $Grid->id_owner->isInvalidClass() ?>"
        data-select2-id="fpaiementgrid_x<?= $Grid->RowIndex ?>_id_owner"
        data-table="paiement"
        data-field="x_id_owner"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->id_owner->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->id_owner->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->id_owner->getPlaceHolder()) ?>"
        <?= $Grid->id_owner->editAttributes() ?>>
        <?= $Grid->id_owner->selectOptionListHtml("x{$Grid->RowIndex}_id_owner") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->id_owner->getErrorMessage() ?></div>
<?= $Grid->id_owner->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_id_owner") ?>
<script>
loadjs.ready("fpaiementgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_id_owner", selectId: "fpaiementgrid_x<?= $Grid->RowIndex ?>_id_owner" };
    if (fpaiementgrid.lists.id_owner.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_id_owner", form: "fpaiementgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_id_owner", form: "fpaiementgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.paiement.fields.id_owner.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_paiement_id_owner" class="el_paiement_id_owner">
<span<?= $Grid->id_owner->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->id_owner->getDisplayValue($Grid->id_owner->ViewValue) ?></span></span>
</span>
<input type="hidden" data-table="paiement" data-field="x_id_owner" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id_owner" id="x<?= $Grid->RowIndex ?>_id_owner" value="<?= HtmlEncode($Grid->id_owner->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="paiement" data-field="x_id_owner" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id_owner" id="o<?= $Grid->RowIndex ?>_id_owner" value="<?= HtmlEncode($Grid->id_owner->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->id_immeuble->Visible) { // id_immeuble ?>
        <td data-name="id_immeuble">
<?php if (!$Grid->isConfirm()) { ?>
<?php if ($Grid->id_immeuble->getSessionValue() != "") { ?>
<span id="el$rowindex$_paiement_id_immeuble" class="el_paiement_id_immeuble">
<span<?= $Grid->id_immeuble->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->id_immeuble->getDisplayValue($Grid->id_immeuble->ViewValue) ?></span></span>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_id_immeuble" name="x<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode(FormatNumber($Grid->id_immeuble->CurrentValue, $Grid->id_immeuble->formatPattern())) ?>" data-hidden="1">
<?php } else { ?>
<span id="el$rowindex$_paiement_id_immeuble" class="el_paiement_id_immeuble">
    <select
        id="x<?= $Grid->RowIndex ?>_id_immeuble"
        name="x<?= $Grid->RowIndex ?>_id_immeuble"
        class="form-control ew-select<?= $Grid->id_immeuble->isInvalidClass() ?>"
        data-select2-id="fpaiementgrid_x<?= $Grid->RowIndex ?>_id_immeuble"
        data-table="paiement"
        data-field="x_id_immeuble"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->id_immeuble->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->id_immeuble->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->id_immeuble->getPlaceHolder()) ?>"
        <?= $Grid->id_immeuble->editAttributes() ?>>
        <?= $Grid->id_immeuble->selectOptionListHtml("x{$Grid->RowIndex}_id_immeuble") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->id_immeuble->getErrorMessage() ?></div>
<?= $Grid->id_immeuble->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_id_immeuble") ?>
<script>
loadjs.ready("fpaiementgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_id_immeuble", selectId: "fpaiementgrid_x<?= $Grid->RowIndex ?>_id_immeuble" };
    if (fpaiementgrid.lists.id_immeuble.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_id_immeuble", form: "fpaiementgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_id_immeuble", form: "fpaiementgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.paiement.fields.id_immeuble.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_paiement_id_immeuble" class="el_paiement_id_immeuble">
<span<?= $Grid->id_immeuble->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->id_immeuble->getDisplayValue($Grid->id_immeuble->ViewValue) ?></span></span>
</span>
<input type="hidden" data-table="paiement" data-field="x_id_immeuble" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id_immeuble" id="x<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode($Grid->id_immeuble->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="paiement" data-field="x_id_immeuble" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id_immeuble" id="o<?= $Grid->RowIndex ?>_id_immeuble" value="<?= HtmlEncode($Grid->id_immeuble->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->id_ex_fiscal->Visible) { // id_ex_fiscal ?>
        <td data-name="id_ex_fiscal">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_paiement_id_ex_fiscal" class="el_paiement_id_ex_fiscal">
    <select
        id="x<?= $Grid->RowIndex ?>_id_ex_fiscal"
        name="x<?= $Grid->RowIndex ?>_id_ex_fiscal"
        class="form-select ew-select<?= $Grid->id_ex_fiscal->isInvalidClass() ?>"
        data-select2-id="fpaiementgrid_x<?= $Grid->RowIndex ?>_id_ex_fiscal"
        data-table="paiement"
        data-field="x_id_ex_fiscal"
        data-value-separator="<?= $Grid->id_ex_fiscal->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->id_ex_fiscal->getPlaceHolder()) ?>"
        <?= $Grid->id_ex_fiscal->editAttributes() ?>>
        <?= $Grid->id_ex_fiscal->selectOptionListHtml("x{$Grid->RowIndex}_id_ex_fiscal") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->id_ex_fiscal->getErrorMessage() ?></div>
<?= $Grid->id_ex_fiscal->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_id_ex_fiscal") ?>
<script>
loadjs.ready("fpaiementgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_id_ex_fiscal", selectId: "fpaiementgrid_x<?= $Grid->RowIndex ?>_id_ex_fiscal" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpaiementgrid.lists.id_ex_fiscal.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_id_ex_fiscal", form: "fpaiementgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_id_ex_fiscal", form: "fpaiementgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.paiement.fields.id_ex_fiscal.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_paiement_id_ex_fiscal" class="el_paiement_id_ex_fiscal">
<span<?= $Grid->id_ex_fiscal->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->id_ex_fiscal->getDisplayValue($Grid->id_ex_fiscal->ViewValue) ?></span></span>
</span>
<input type="hidden" data-table="paiement" data-field="x_id_ex_fiscal" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id_ex_fiscal" id="x<?= $Grid->RowIndex ?>_id_ex_fiscal" value="<?= HtmlEncode($Grid->id_ex_fiscal->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="paiement" data-field="x_id_ex_fiscal" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id_ex_fiscal" id="o<?= $Grid->RowIndex ?>_id_ex_fiscal" value="<?= HtmlEncode($Grid->id_ex_fiscal->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->montant->Visible) { // montant ?>
        <td data-name="montant">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_paiement_montant" class="el_paiement_montant">
<input type="<?= $Grid->montant->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_montant" id="x<?= $Grid->RowIndex ?>_montant" data-table="paiement" data-field="x_montant" value="<?= $Grid->montant->EditValue ?>" size="15" placeholder="<?= HtmlEncode($Grid->montant->getPlaceHolder()) ?>"<?= $Grid->montant->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->montant->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_paiement_montant" class="el_paiement_montant">
<span<?= $Grid->montant->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->montant->getDisplayValue($Grid->montant->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="paiement" data-field="x_montant" data-hidden="1" name="x<?= $Grid->RowIndex ?>_montant" id="x<?= $Grid->RowIndex ?>_montant" value="<?= HtmlEncode($Grid->montant->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="paiement" data-field="x_montant" data-hidden="1" name="o<?= $Grid->RowIndex ?>_montant" id="o<?= $Grid->RowIndex ?>_montant" value="<?= HtmlEncode($Grid->montant->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->datepaie->Visible) { // datepaie ?>
        <td data-name="datepaie">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_paiement_datepaie" class="el_paiement_datepaie">
<input type="<?= $Grid->datepaie->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_datepaie" id="x<?= $Grid->RowIndex ?>_datepaie" data-table="paiement" data-field="x_datepaie" value="<?= $Grid->datepaie->EditValue ?>" size="15" placeholder="<?= HtmlEncode($Grid->datepaie->getPlaceHolder()) ?>"<?= $Grid->datepaie->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->datepaie->getErrorMessage() ?></div>
<?php if (!$Grid->datepaie->ReadOnly && !$Grid->datepaie->Disabled && !isset($Grid->datepaie->EditAttrs["readonly"]) && !isset($Grid->datepaie->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpaiementgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(2) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem()
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fas fa-chevron-right" : "fas fa-chevron-left",
                    next: ew.IS_RTL ? "fas fa-chevron-left" : "fas fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i),
                    useTwentyfourHour: !!format.match(/H/)
                }
            },
            meta: {
                format
            }
        };
    ew.createDateTimePicker("fpaiementgrid", "x<?= $Grid->RowIndex ?>_datepaie", ew.deepAssign({"useCurrent":false}, options));
});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_paiement_datepaie" class="el_paiement_datepaie">
<span<?= $Grid->datepaie->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->datepaie->getDisplayValue($Grid->datepaie->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="paiement" data-field="x_datepaie" data-hidden="1" name="x<?= $Grid->RowIndex ?>_datepaie" id="x<?= $Grid->RowIndex ?>_datepaie" value="<?= HtmlEncode($Grid->datepaie->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="paiement" data-field="x_datepaie" data-hidden="1" name="o<?= $Grid->RowIndex ?>_datepaie" id="o<?= $Grid->RowIndex ?>_datepaie" value="<?= HtmlEncode($Grid->datepaie->OldValue) ?>">
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowIndex);
?>
<script>
loadjs.ready(["fpaiementgrid","load"], () => fpaiementgrid.updateLists(<?= $Grid->RowIndex ?>, true));
</script>
    </tr>
<?php
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = ROWTYPE_AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->id_owner->Visible) { // id_owner ?>
        <td data-name="id_owner" class="<?= $Grid->id_owner->footerCellClass() ?>"><span id="elf_paiement_id_owner" class="paiement_id_owner">
        </span></td>
    <?php } ?>
    <?php if ($Grid->id_immeuble->Visible) { // id_immeuble ?>
        <td data-name="id_immeuble" class="<?= $Grid->id_immeuble->footerCellClass() ?>"><span id="elf_paiement_id_immeuble" class="paiement_id_immeuble">
        </span></td>
    <?php } ?>
    <?php if ($Grid->id_ex_fiscal->Visible) { // id_ex_fiscal ?>
        <td data-name="id_ex_fiscal" class="<?= $Grid->id_ex_fiscal->footerCellClass() ?>"><span id="elf_paiement_id_ex_fiscal" class="paiement_id_ex_fiscal">
        </span></td>
    <?php } ?>
    <?php if ($Grid->montant->Visible) { // montant ?>
        <td data-name="montant" class="<?= $Grid->montant->footerCellClass() ?>"><span id="elf_paiement_montant" class="paiement_montant">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->montant->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->datepaie->Visible) { // datepaie ?>
        <td data-name="datepaie" class="<?= $Grid->datepaie->footerCellClass() ?>"><span id="elf_paiement_datepaie" class="paiement_datepaie">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpaiementgrid">
</div><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Grid->Recordset) {
    $Grid->Recordset->close();
}
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("paiement");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
