<?php

namespace PHPMaker2022\cfpb;

use Slim\App;
use Slim\Routing\RouteCollectorProxy;

// Handle Routes
return function (App $app) {
    // agent
    $app->map(["GET","POST","OPTIONS"], '/AgentList[/{id_agent}]', AgentController::class . ':list')->add(PermissionMiddleware::class)->setName('AgentList-agent-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/AgentAdd[/{id_agent}]', AgentController::class . ':add')->add(PermissionMiddleware::class)->setName('AgentAdd-agent-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/AgentView[/{id_agent}]', AgentController::class . ':view')->add(PermissionMiddleware::class)->setName('AgentView-agent-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/AgentEdit[/{id_agent}]', AgentController::class . ':edit')->add(PermissionMiddleware::class)->setName('AgentEdit-agent-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/AgentDelete[/{id_agent}]', AgentController::class . ':delete')->add(PermissionMiddleware::class)->setName('AgentDelete-agent-delete'); // delete

    // immeuble
    $app->map(["GET","POST","OPTIONS"], '/ImmeubleList[/{id_immeuble}]', ImmeubleController::class . ':list')->add(PermissionMiddleware::class)->setName('ImmeubleList-immeuble-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/ImmeubleAdd[/{id_immeuble}]', ImmeubleController::class . ':add')->add(PermissionMiddleware::class)->setName('ImmeubleAdd-immeuble-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/ImmeubleView[/{id_immeuble}]', ImmeubleController::class . ':view')->add(PermissionMiddleware::class)->setName('ImmeubleView-immeuble-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/ImmeubleEdit[/{id_immeuble}]', ImmeubleController::class . ':edit')->add(PermissionMiddleware::class)->setName('ImmeubleEdit-immeuble-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/ImmeubleDelete[/{id_immeuble}]', ImmeubleController::class . ':delete')->add(PermissionMiddleware::class)->setName('ImmeubleDelete-immeuble-delete'); // delete

    // owner
    $app->map(["GET","POST","OPTIONS"], '/OwnerList[/{id_owner}]', OwnerController::class . ':list')->add(PermissionMiddleware::class)->setName('OwnerList-owner-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/OwnerAdd[/{id_owner}]', OwnerController::class . ':add')->add(PermissionMiddleware::class)->setName('OwnerAdd-owner-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/OwnerAddopt', OwnerController::class . ':addopt')->add(PermissionMiddleware::class)->setName('OwnerAddopt-owner-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/OwnerView[/{id_owner}]', OwnerController::class . ':view')->add(PermissionMiddleware::class)->setName('OwnerView-owner-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/OwnerEdit[/{id_owner}]', OwnerController::class . ':edit')->add(PermissionMiddleware::class)->setName('OwnerEdit-owner-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/OwnerDelete[/{id_owner}]', OwnerController::class . ':delete')->add(PermissionMiddleware::class)->setName('OwnerDelete-owner-delete'); // delete

    // userlevelpermissions
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsList[/{keys:.*}]', UserlevelpermissionsController::class . ':list')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsList-userlevelpermissions-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsAdd[/{keys:.*}]', UserlevelpermissionsController::class . ':add')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsAdd-userlevelpermissions-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsView[/{keys:.*}]', UserlevelpermissionsController::class . ':view')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsView-userlevelpermissions-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsEdit[/{keys:.*}]', UserlevelpermissionsController::class . ':edit')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsEdit-userlevelpermissions-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsDelete[/{keys:.*}]', UserlevelpermissionsController::class . ':delete')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsDelete-userlevelpermissions-delete'); // delete

    // userlevels
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsList[/{userlevelid}]', UserlevelsController::class . ':list')->add(PermissionMiddleware::class)->setName('UserlevelsList-userlevels-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsAdd[/{userlevelid}]', UserlevelsController::class . ':add')->add(PermissionMiddleware::class)->setName('UserlevelsAdd-userlevels-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsView[/{userlevelid}]', UserlevelsController::class . ':view')->add(PermissionMiddleware::class)->setName('UserlevelsView-userlevels-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsEdit[/{userlevelid}]', UserlevelsController::class . ':edit')->add(PermissionMiddleware::class)->setName('UserlevelsEdit-userlevels-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsDelete[/{userlevelid}]', UserlevelsController::class . ':delete')->add(PermissionMiddleware::class)->setName('UserlevelsDelete-userlevels-delete'); // delete

    // ex_fiscal
    $app->map(["GET","POST","OPTIONS"], '/ExFiscalList[/{id_ex_fiscal}]', ExFiscalController::class . ':list')->add(PermissionMiddleware::class)->setName('ExFiscalList-ex_fiscal-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/ExFiscalAdd[/{id_ex_fiscal}]', ExFiscalController::class . ':add')->add(PermissionMiddleware::class)->setName('ExFiscalAdd-ex_fiscal-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/ExFiscalView[/{id_ex_fiscal}]', ExFiscalController::class . ':view')->add(PermissionMiddleware::class)->setName('ExFiscalView-ex_fiscal-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/ExFiscalEdit[/{id_ex_fiscal}]', ExFiscalController::class . ':edit')->add(PermissionMiddleware::class)->setName('ExFiscalEdit-ex_fiscal-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/ExFiscalDelete[/{id_ex_fiscal}]', ExFiscalController::class . ':delete')->add(PermissionMiddleware::class)->setName('ExFiscalDelete-ex_fiscal-delete'); // delete

    // paiement
    $app->map(["GET","POST","OPTIONS"], '/PaiementList[/{keys:.*}]', PaiementController::class . ':list')->add(PermissionMiddleware::class)->setName('PaiementList-paiement-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/PaiementAdd[/{keys:.*}]', PaiementController::class . ':add')->add(PermissionMiddleware::class)->setName('PaiementAdd-paiement-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/PaiementView[/{keys:.*}]', PaiementController::class . ':view')->add(PermissionMiddleware::class)->setName('PaiementView-paiement-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/PaiementEdit[/{keys:.*}]', PaiementController::class . ':edit')->add(PermissionMiddleware::class)->setName('PaiementEdit-paiement-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/PaiementDelete[/{keys:.*}]', PaiementController::class . ':delete')->add(PermissionMiddleware::class)->setName('PaiementDelete-paiement-delete'); // delete

    // error
    $app->map(["GET","POST","OPTIONS"], '/error', OthersController::class . ':error')->add(PermissionMiddleware::class)->setName('error');

    // personal_data
    $app->map(["GET","POST","OPTIONS"], '/personaldata', OthersController::class . ':personaldata')->add(PermissionMiddleware::class)->setName('personaldata');

    // login
    $app->map(["GET","POST","OPTIONS"], '/login', OthersController::class . ':login')->add(PermissionMiddleware::class)->setName('login');

    // reset_password
    $app->map(["GET","POST","OPTIONS"], '/resetpassword', OthersController::class . ':resetpassword')->add(PermissionMiddleware::class)->setName('resetpassword');

    // change_password
    $app->map(["GET","POST","OPTIONS"], '/changepassword', OthersController::class . ':changepassword')->add(PermissionMiddleware::class)->setName('changepassword');

    // register
    $app->map(["GET","POST","OPTIONS"], '/register', OthersController::class . ':register')->add(PermissionMiddleware::class)->setName('register');

    // userpriv
    $app->map(["GET","POST","OPTIONS"], '/userpriv', OthersController::class . ':userpriv')->add(PermissionMiddleware::class)->setName('userpriv');

    // logout
    $app->map(["GET","POST","OPTIONS"], '/logout', OthersController::class . ':logout')->add(PermissionMiddleware::class)->setName('logout');

    // Swagger
    $app->get('/' . Config("SWAGGER_ACTION"), OthersController::class . ':swagger')->setName(Config("SWAGGER_ACTION")); // Swagger

    // Index
    $app->get('/[index]', OthersController::class . ':index')->add(PermissionMiddleware::class)->setName('index');

    // Route Action event
    if (function_exists(PROJECT_NAMESPACE . "Route_Action")) {
        Route_Action($app);
    }

    /**
     * Catch-all route to serve a 404 Not Found page if none of the routes match
     * NOTE: Make sure this route is defined last.
     */
    $app->map(
        ['GET', 'POST', 'PUT', 'DELETE', 'PATCH'],
        '/{routes:.+}',
        function ($request, $response, $params) {
            $error = [
                "statusCode" => "404",
                "error" => [
                    "class" => "text-warning",
                    "type" => Container("language")->phrase("Error"),
                    "description" => str_replace("%p", $params["routes"], Container("language")->phrase("PageNotFound")),
                ],
            ];
            Container("flash")->addMessage("error", $error);
            return $response->withStatus(302)->withHeader("Location", GetUrl("error")); // Redirect to error page
        }
    );
};
