<?php

namespace PHPMaker2022\cfpb;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class PaiementAdd extends Paiement
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'paiement';

    // Page object name
    public $PageObjName = "PaiementAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = $route->getArguments();
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        $url = rtrim(UrlFor($route->getName(), $args), "/") . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return $this->TableVar == $CurrentForm->getValue("t");
            }
            if (Get("t") !== null) {
                return $this->TableVar == Get("t");
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (paiement)
        if (!isset($GLOBALS["paiement"]) || get_class($GLOBALS["paiement"]) == PROJECT_NAMESPACE . "paiement") {
            $GLOBALS["paiement"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'paiement');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $tbl = Container("paiement");
                $doc = new $class($tbl);
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "PaiementView") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id_owner'] . Config("COMPOSITE_KEY_SEPARATOR");
            $key .= @$ar['id_immeuble'] . Config("COMPOSITE_KEY_SEPARATOR");
            $key .= @$ar['id_ex_fiscal'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $OldRecordset;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param("layout", true));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->id_owner->setVisibility();
        $this->id_immeuble->setVisibility();
        $this->id_ex_fiscal->setVisibility();
        $this->montant->setVisibility();
        $this->datepaie->setVisibility();
        $this->hideFieldsForAddEdit();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->id_owner);
        $this->setupLookupOptions($this->id_immeuble);
        $this->setupLookupOptions($this->id_ex_fiscal);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $this->FormClassName = "ew-form ew-add-form";
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action") !== null) {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id_owner") ?? Route("id_owner")) !== null) {
                $this->id_owner->setQueryStringValue($keyValue);
            }
            if (($keyValue = Get("id_immeuble") ?? Route("id_immeuble")) !== null) {
                $this->id_immeuble->setQueryStringValue($keyValue);
            }
            if (($keyValue = Get("id_ex_fiscal") ?? Route("id_ex_fiscal")) !== null) {
                $this->id_ex_fiscal->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record / default values
        $loaded = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: must be after loadOldRecord to prevent master key values overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$loaded) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("PaiementList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($this->OldRecordset)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "PaiementList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "PaiementView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }
                    if (IsApi()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id_owner' first before field var 'x_id_owner'
        $val = $CurrentForm->hasValue("id_owner") ? $CurrentForm->getValue("id_owner") : $CurrentForm->getValue("x_id_owner");
        if (!$this->id_owner->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id_owner->Visible = false; // Disable update for API request
            } else {
                $this->id_owner->setFormValue($val);
            }
        }

        // Check field name 'id_immeuble' first before field var 'x_id_immeuble'
        $val = $CurrentForm->hasValue("id_immeuble") ? $CurrentForm->getValue("id_immeuble") : $CurrentForm->getValue("x_id_immeuble");
        if (!$this->id_immeuble->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id_immeuble->Visible = false; // Disable update for API request
            } else {
                $this->id_immeuble->setFormValue($val);
            }
        }

        // Check field name 'id_ex_fiscal' first before field var 'x_id_ex_fiscal'
        $val = $CurrentForm->hasValue("id_ex_fiscal") ? $CurrentForm->getValue("id_ex_fiscal") : $CurrentForm->getValue("x_id_ex_fiscal");
        if (!$this->id_ex_fiscal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id_ex_fiscal->Visible = false; // Disable update for API request
            } else {
                $this->id_ex_fiscal->setFormValue($val);
            }
        }

        // Check field name 'montant' first before field var 'x_montant'
        $val = $CurrentForm->hasValue("montant") ? $CurrentForm->getValue("montant") : $CurrentForm->getValue("x_montant");
        if (!$this->montant->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->montant->Visible = false; // Disable update for API request
            } else {
                $this->montant->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'datepaie' first before field var 'x_datepaie'
        $val = $CurrentForm->hasValue("datepaie") ? $CurrentForm->getValue("datepaie") : $CurrentForm->getValue("x_datepaie");
        if (!$this->datepaie->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datepaie->Visible = false; // Disable update for API request
            } else {
                $this->datepaie->setFormValue($val, true, $validate);
            }
            $this->datepaie->CurrentValue = UnFormatDateTime($this->datepaie->CurrentValue, $this->datepaie->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id_owner->CurrentValue = $this->id_owner->FormValue;
        $this->id_immeuble->CurrentValue = $this->id_immeuble->FormValue;
        $this->id_ex_fiscal->CurrentValue = $this->id_ex_fiscal->FormValue;
        $this->montant->CurrentValue = $this->montant->FormValue;
        $this->datepaie->CurrentValue = $this->datepaie->FormValue;
        $this->datepaie->CurrentValue = UnFormatDateTime($this->datepaie->CurrentValue, $this->datepaie->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id_owner->setDbValue($row['id_owner']);
        $this->id_immeuble->setDbValue($row['id_immeuble']);
        $this->id_ex_fiscal->setDbValue($row['id_ex_fiscal']);
        $this->montant->setDbValue($row['montant']);
        $this->datepaie->setDbValue($row['datepaie']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id_owner'] = $this->id_owner->DefaultValue;
        $row['id_immeuble'] = $this->id_immeuble->DefaultValue;
        $row['id_ex_fiscal'] = $this->id_ex_fiscal->DefaultValue;
        $row['montant'] = $this->montant->DefaultValue;
        $row['datepaie'] = $this->datepaie->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id_owner
        $this->id_owner->RowCssClass = "row";

        // id_immeuble
        $this->id_immeuble->RowCssClass = "row";

        // id_ex_fiscal
        $this->id_ex_fiscal->RowCssClass = "row";

        // montant
        $this->montant->RowCssClass = "row";

        // datepaie
        $this->datepaie->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // id_owner
            $curVal = strval($this->id_owner->CurrentValue);
            if ($curVal != "") {
                $this->id_owner->ViewValue = $this->id_owner->lookupCacheOption($curVal);
                if ($this->id_owner->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_owner`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_owner->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_owner->Lookup->renderViewRow($rswrk[0]);
                        $this->id_owner->ViewValue = $this->id_owner->displayValue($arwrk);
                    } else {
                        $this->id_owner->ViewValue = FormatNumber($this->id_owner->CurrentValue, $this->id_owner->formatPattern());
                    }
                }
            } else {
                $this->id_owner->ViewValue = null;
            }
            $this->id_owner->ViewCustomAttributes = "";

            // id_immeuble
            $curVal = strval($this->id_immeuble->CurrentValue);
            if ($curVal != "") {
                $this->id_immeuble->ViewValue = $this->id_immeuble->lookupCacheOption($curVal);
                if ($this->id_immeuble->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_immeuble`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_immeuble->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_immeuble->Lookup->renderViewRow($rswrk[0]);
                        $this->id_immeuble->ViewValue = $this->id_immeuble->displayValue($arwrk);
                    } else {
                        $this->id_immeuble->ViewValue = FormatNumber($this->id_immeuble->CurrentValue, $this->id_immeuble->formatPattern());
                    }
                }
            } else {
                $this->id_immeuble->ViewValue = null;
            }
            $this->id_immeuble->ViewCustomAttributes = "";

            // id_ex_fiscal
            $curVal = strval($this->id_ex_fiscal->CurrentValue);
            if ($curVal != "") {
                $this->id_ex_fiscal->ViewValue = $this->id_ex_fiscal->lookupCacheOption($curVal);
                if ($this->id_ex_fiscal->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_ex_fiscal`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_ex_fiscal->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_ex_fiscal->Lookup->renderViewRow($rswrk[0]);
                        $this->id_ex_fiscal->ViewValue = $this->id_ex_fiscal->displayValue($arwrk);
                    } else {
                        $this->id_ex_fiscal->ViewValue = $this->id_ex_fiscal->CurrentValue;
                    }
                }
            } else {
                $this->id_ex_fiscal->ViewValue = null;
            }
            $this->id_ex_fiscal->ViewCustomAttributes = "";

            // montant
            $this->montant->ViewValue = $this->montant->CurrentValue;
            $this->montant->ViewValue = FormatNumber($this->montant->ViewValue, $this->montant->formatPattern());
            $this->montant->ViewCustomAttributes = "";

            // datepaie
            $this->datepaie->ViewValue = $this->datepaie->CurrentValue;
            $this->datepaie->ViewValue = FormatDateTime($this->datepaie->ViewValue, $this->datepaie->formatPattern());
            $this->datepaie->ViewCustomAttributes = "";

            // id_owner
            $this->id_owner->LinkCustomAttributes = "";
            $this->id_owner->HrefValue = "";

            // id_immeuble
            $this->id_immeuble->LinkCustomAttributes = "";
            $this->id_immeuble->HrefValue = "";

            // id_ex_fiscal
            $this->id_ex_fiscal->LinkCustomAttributes = "";
            $this->id_ex_fiscal->HrefValue = "";

            // montant
            $this->montant->LinkCustomAttributes = "";
            $this->montant->HrefValue = "";

            // datepaie
            $this->datepaie->LinkCustomAttributes = "";
            $this->datepaie->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // id_owner
            $this->id_owner->EditCustomAttributes = "";
            $curVal = trim(strval($this->id_owner->CurrentValue));
            if ($curVal != "") {
                $this->id_owner->ViewValue = $this->id_owner->lookupCacheOption($curVal);
            } else {
                $this->id_owner->ViewValue = $this->id_owner->Lookup !== null && is_array($this->id_owner->lookupOptions()) ? $curVal : null;
            }
            if ($this->id_owner->ViewValue !== null) { // Load from cache
                $this->id_owner->EditValue = array_values($this->id_owner->lookupOptions());
                if ($this->id_owner->ViewValue == "") {
                    $this->id_owner->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id_owner`" . SearchString("=", $this->id_owner->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->id_owner->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->id_owner->Lookup->renderViewRow($rswrk[0]);
                    $this->id_owner->ViewValue = $this->id_owner->displayValue($arwrk);
                } else {
                    $this->id_owner->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->id_owner->EditValue = $arwrk;
            }
            $this->id_owner->PlaceHolder = RemoveHtml($this->id_owner->caption());

            // id_immeuble
            $this->id_immeuble->EditCustomAttributes = "";
            if ($this->id_immeuble->getSessionValue() != "") {
                $this->id_immeuble->CurrentValue = GetForeignKeyValue($this->id_immeuble->getSessionValue());
                $curVal = strval($this->id_immeuble->CurrentValue);
                if ($curVal != "") {
                    $this->id_immeuble->ViewValue = $this->id_immeuble->lookupCacheOption($curVal);
                    if ($this->id_immeuble->ViewValue === null) { // Lookup from database
                        $filterWrk = "`id_immeuble`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->id_immeuble->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->id_immeuble->Lookup->renderViewRow($rswrk[0]);
                            $this->id_immeuble->ViewValue = $this->id_immeuble->displayValue($arwrk);
                        } else {
                            $this->id_immeuble->ViewValue = FormatNumber($this->id_immeuble->CurrentValue, $this->id_immeuble->formatPattern());
                        }
                    }
                } else {
                    $this->id_immeuble->ViewValue = null;
                }
                $this->id_immeuble->ViewCustomAttributes = "";
            } else {
                $curVal = trim(strval($this->id_immeuble->CurrentValue));
                if ($curVal != "") {
                    $this->id_immeuble->ViewValue = $this->id_immeuble->lookupCacheOption($curVal);
                } else {
                    $this->id_immeuble->ViewValue = $this->id_immeuble->Lookup !== null && is_array($this->id_immeuble->lookupOptions()) ? $curVal : null;
                }
                if ($this->id_immeuble->ViewValue !== null) { // Load from cache
                    $this->id_immeuble->EditValue = array_values($this->id_immeuble->lookupOptions());
                    if ($this->id_immeuble->ViewValue == "") {
                        $this->id_immeuble->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = "`id_immeuble`" . SearchString("=", $this->id_immeuble->CurrentValue, DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->id_immeuble->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_immeuble->Lookup->renderViewRow($rswrk[0]);
                        $this->id_immeuble->ViewValue = $this->id_immeuble->displayValue($arwrk);
                    } else {
                        $this->id_immeuble->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->id_immeuble->EditValue = $arwrk;
                }
                $this->id_immeuble->PlaceHolder = RemoveHtml($this->id_immeuble->caption());
            }

            // id_ex_fiscal
            $this->id_ex_fiscal->setupEditAttributes();
            $this->id_ex_fiscal->EditCustomAttributes = "";
            $curVal = trim(strval($this->id_ex_fiscal->CurrentValue));
            if ($curVal != "") {
                $this->id_ex_fiscal->ViewValue = $this->id_ex_fiscal->lookupCacheOption($curVal);
            } else {
                $this->id_ex_fiscal->ViewValue = $this->id_ex_fiscal->Lookup !== null && is_array($this->id_ex_fiscal->lookupOptions()) ? $curVal : null;
            }
            if ($this->id_ex_fiscal->ViewValue !== null) { // Load from cache
                $this->id_ex_fiscal->EditValue = array_values($this->id_ex_fiscal->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id_ex_fiscal`" . SearchString("=", $this->id_ex_fiscal->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->id_ex_fiscal->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->id_ex_fiscal->EditValue = $arwrk;
            }
            $this->id_ex_fiscal->PlaceHolder = RemoveHtml($this->id_ex_fiscal->caption());

            // montant
            $this->montant->setupEditAttributes();
            $this->montant->EditCustomAttributes = "";
            $this->montant->EditValue = HtmlEncode($this->montant->CurrentValue);
            $this->montant->PlaceHolder = RemoveHtml($this->montant->caption());
            if (strval($this->montant->EditValue) != "" && is_numeric($this->montant->EditValue)) {
                $this->montant->EditValue = FormatNumber($this->montant->EditValue, null);
            }

            // datepaie
            $this->datepaie->setupEditAttributes();
            $this->datepaie->EditCustomAttributes = "";
            $this->datepaie->EditValue = HtmlEncode(FormatDateTime($this->datepaie->CurrentValue, $this->datepaie->formatPattern()));
            $this->datepaie->PlaceHolder = RemoveHtml($this->datepaie->caption());

            // Add refer script

            // id_owner
            $this->id_owner->LinkCustomAttributes = "";
            $this->id_owner->HrefValue = "";

            // id_immeuble
            $this->id_immeuble->LinkCustomAttributes = "";
            $this->id_immeuble->HrefValue = "";

            // id_ex_fiscal
            $this->id_ex_fiscal->LinkCustomAttributes = "";
            $this->id_ex_fiscal->HrefValue = "";

            // montant
            $this->montant->LinkCustomAttributes = "";
            $this->montant->HrefValue = "";

            // datepaie
            $this->datepaie->LinkCustomAttributes = "";
            $this->datepaie->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->id_owner->Required) {
            if (!$this->id_owner->IsDetailKey && EmptyValue($this->id_owner->FormValue)) {
                $this->id_owner->addErrorMessage(str_replace("%s", $this->id_owner->caption(), $this->id_owner->RequiredErrorMessage));
            }
        }
        if ($this->id_immeuble->Required) {
            if (!$this->id_immeuble->IsDetailKey && EmptyValue($this->id_immeuble->FormValue)) {
                $this->id_immeuble->addErrorMessage(str_replace("%s", $this->id_immeuble->caption(), $this->id_immeuble->RequiredErrorMessage));
            }
        }
        if ($this->id_ex_fiscal->Required) {
            if (!$this->id_ex_fiscal->IsDetailKey && EmptyValue($this->id_ex_fiscal->FormValue)) {
                $this->id_ex_fiscal->addErrorMessage(str_replace("%s", $this->id_ex_fiscal->caption(), $this->id_ex_fiscal->RequiredErrorMessage));
            }
        }
        if ($this->montant->Required) {
            if (!$this->montant->IsDetailKey && EmptyValue($this->montant->FormValue)) {
                $this->montant->addErrorMessage(str_replace("%s", $this->montant->caption(), $this->montant->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->montant->FormValue)) {
            $this->montant->addErrorMessage($this->montant->getErrorMessage(false));
        }
        if ($this->datepaie->Required) {
            if (!$this->datepaie->IsDetailKey && EmptyValue($this->datepaie->FormValue)) {
                $this->datepaie->addErrorMessage(str_replace("%s", $this->datepaie->caption(), $this->datepaie->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->datepaie->FormValue, $this->datepaie->formatPattern())) {
            $this->datepaie->addErrorMessage($this->datepaie->getErrorMessage(false));
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set new row
        $rsnew = [];

        // id_owner
        $this->id_owner->setDbValueDef($rsnew, $this->id_owner->CurrentValue, 0, false);

        // id_immeuble
        $this->id_immeuble->setDbValueDef($rsnew, $this->id_immeuble->CurrentValue, 0, false);

        // id_ex_fiscal
        $this->id_ex_fiscal->setDbValueDef($rsnew, $this->id_ex_fiscal->CurrentValue, 0, false);

        // montant
        $this->montant->setDbValueDef($rsnew, $this->montant->CurrentValue, null, false);

        // datepaie
        $this->datepaie->setDbValueDef($rsnew, UnFormatDateTime($this->datepaie->CurrentValue, $this->datepaie->formatPattern()), null, false);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check if valid key values for master user
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            $detailKeys = [];
            $detailKeys["id_immeuble"] = $this->id_immeuble->CurrentValue;
            $masterTable = Container("immeuble");
            $masterFilter = $this->getMasterFilter($masterTable, $detailKeys);
            if (!EmptyValue($masterFilter)) {
                $validMasterKey = true;
                if ($rsmaster = $masterTable->loadRs($masterFilter)->fetchAssociative()) {
                    $validMasterKey = $Security->isValidUserID($rsmaster['id_agent']);
                } elseif ($this->getCurrentMasterTable() == "immeuble") {
                    $validMasterKey = false;
                }
                if (!$validMasterKey) {
                    $masterUserIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedMasterUserID"));
                    $masterUserIdMsg = str_replace("%f", $masterFilter, $masterUserIdMsg);
                    $this->setFailureMessage($masterUserIdMsg);
                    return false;
                }
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        if ($rsold) {
        }

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);

        // Check if key value entered
        if ($insertRow && $this->ValidateKey && strval($rsnew['id_owner']) == "") {
            $this->setFailureMessage($Language->phrase("InvalidKeyValue"));
            $insertRow = false;
        }

        // Check if key value entered
        if ($insertRow && $this->ValidateKey && strval($rsnew['id_immeuble']) == "") {
            $this->setFailureMessage($Language->phrase("InvalidKeyValue"));
            $insertRow = false;
        }

        // Check if key value entered
        if ($insertRow && $this->ValidateKey && strval($rsnew['id_ex_fiscal']) == "") {
            $this->setFailureMessage($Language->phrase("InvalidKeyValue"));
            $insertRow = false;
        }

        // Check for duplicate key
        if ($insertRow && $this->ValidateKey) {
            $filter = $this->getRecordFilter($rsnew);
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
                $this->setFailureMessage($keyErrMsg);
                $insertRow = false;
            }
        }
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($addRow) {
        }

        // Write JSON for API request
        if (IsApi() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $addRow;
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "immeuble") {
                $validMaster = true;
                $masterTbl = Container("immeuble");
                if (($parm = Get("fk_id_immeuble", Get("id_immeuble"))) !== null) {
                    $masterTbl->id_immeuble->setQueryStringValue($parm);
                    $this->id_immeuble->setQueryStringValue($masterTbl->id_immeuble->QueryStringValue);
                    $this->id_immeuble->setSessionValue($this->id_immeuble->QueryStringValue);
                    if (!is_numeric($masterTbl->id_immeuble->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "immeuble") {
                $validMaster = true;
                $masterTbl = Container("immeuble");
                if (($parm = Post("fk_id_immeuble", Post("id_immeuble"))) !== null) {
                    $masterTbl->id_immeuble->setFormValue($parm);
                    $this->id_immeuble->setFormValue($masterTbl->id_immeuble->FormValue);
                    $this->id_immeuble->setSessionValue($this->id_immeuble->FormValue);
                    if (!is_numeric($masterTbl->id_immeuble->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "immeuble") {
                if ($this->id_immeuble->CurrentValue == "") {
                    $this->id_immeuble->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("PaiementList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_id_owner":
                    break;
                case "x_id_immeuble":
                    break;
                case "x_id_ex_fiscal":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $ar[strval($row["lf"])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
