<?php

namespace PHPMaker2022\cfpb;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for paiement
 */
class Paiement extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Export
    public $ExportDoc;

    // Fields
    public $id_owner;
    public $id_immeuble;
    public $id_ex_fiscal;
    public $montant;
    public $datepaie;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage, $CurrentLocale;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'paiement';
        $this->TableName = 'paiement';
        $this->TableType = 'TABLE';

        // Update Table
        $this->UpdateTable = "`paiement`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
        $this->ExportWordVersion = 12; // Word version (PHPWord only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // id_owner
        $this->id_owner = new DbField(
            'paiement',
            'paiement',
            'x_id_owner',
            'id_owner',
            '`id_owner`',
            '`id_owner`',
            3,
            11,
            -1,
            false,
            '`id_owner`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'SELECT'
        );
        $this->id_owner->InputTextType = "text";
        $this->id_owner->IsPrimaryKey = true; // Primary key field
        $this->id_owner->Nullable = false; // NOT NULL field
        $this->id_owner->Required = true; // Required field
        $this->id_owner->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->id_owner->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->id_owner->Lookup = new Lookup('id_owner', 'owner', false, 'id_owner', ["nom_pro","prenom_pro","nif",""], [], ["x_id_immeuble"], [], [], [], [], '', '<div><span>{{:df}} {{:df2}} <br><small class="text-muted">({{:df3}})</small></span></div>', "CONCAT(COALESCE(`nom_pro`, ''),'" . ValueSeparator(1, $this->id_owner) . "',COALESCE(`prenom_pro`,''),'" . ValueSeparator(2, $this->id_owner) . "',COALESCE(`nif`,''))");
                break;
            default:
                $this->id_owner->Lookup = new Lookup('id_owner', 'owner', false, 'id_owner', ["nom_pro","prenom_pro","nif",""], [], ["x_id_immeuble"], [], [], [], [], '', '<div><span>{{:df}} {{:df2}} <br><small class="text-muted">({{:df3}})</small></span></div>', "CONCAT(COALESCE(`nom_pro`, ''),'" . ValueSeparator(1, $this->id_owner) . "',COALESCE(`prenom_pro`,''),'" . ValueSeparator(2, $this->id_owner) . "',COALESCE(`nif`,''))");
                break;
        }
        $this->id_owner->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['id_owner'] = &$this->id_owner;

        // id_immeuble
        $this->id_immeuble = new DbField(
            'paiement',
            'paiement',
            'x_id_immeuble',
            'id_immeuble',
            '`id_immeuble`',
            '`id_immeuble`',
            3,
            11,
            -1,
            false,
            '`id_immeuble`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'SELECT'
        );
        $this->id_immeuble->InputTextType = "text";
        $this->id_immeuble->IsPrimaryKey = true; // Primary key field
        $this->id_immeuble->IsForeignKey = true; // Foreign key field
        $this->id_immeuble->Nullable = false; // NOT NULL field
        $this->id_immeuble->Required = true; // Required field
        $this->id_immeuble->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->id_immeuble->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->id_immeuble->Lookup = new Lookup('id_immeuble', 'immeuble', false, 'id_immeuble', ["codeimmeuble","","",""], ["x_id_owner"], [], ["id_owner"], ["x_id_owner"], [], [], '', '', "`codeimmeuble`");
                break;
            default:
                $this->id_immeuble->Lookup = new Lookup('id_immeuble', 'immeuble', false, 'id_immeuble', ["codeimmeuble","","",""], ["x_id_owner"], [], ["id_owner"], ["x_id_owner"], [], [], '', '', "`codeimmeuble`");
                break;
        }
        $this->id_immeuble->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['id_immeuble'] = &$this->id_immeuble;

        // id_ex_fiscal
        $this->id_ex_fiscal = new DbField(
            'paiement',
            'paiement',
            'x_id_ex_fiscal',
            'id_ex_fiscal',
            '`id_ex_fiscal`',
            '`id_ex_fiscal`',
            3,
            11,
            -1,
            false,
            '`id_ex_fiscal`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'SELECT'
        );
        $this->id_ex_fiscal->InputTextType = "text";
        $this->id_ex_fiscal->IsPrimaryKey = true; // Primary key field
        $this->id_ex_fiscal->Nullable = false; // NOT NULL field
        $this->id_ex_fiscal->Required = true; // Required field
        $this->id_ex_fiscal->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->id_ex_fiscal->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->id_ex_fiscal->Lookup = new Lookup('id_ex_fiscal', 'ex_fiscal', false, 'id_ex_fiscal', ["title","","",""], [], [], [], [], [], [], '', '', "`title`");
                break;
            default:
                $this->id_ex_fiscal->Lookup = new Lookup('id_ex_fiscal', 'ex_fiscal', false, 'id_ex_fiscal', ["title","","",""], [], [], [], [], [], [], '', '', "`title`");
                break;
        }
        $this->id_ex_fiscal->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['id_ex_fiscal'] = &$this->id_ex_fiscal;

        // montant
        $this->montant = new DbField(
            'paiement',
            'paiement',
            'x_montant',
            'montant',
            '`montant`',
            '`montant`',
            131,
            15,
            -1,
            false,
            '`montant`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->montant->InputTextType = "text";
        $this->montant->Required = true; // Required field
        $this->montant->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['montant'] = &$this->montant;

        // datepaie
        $this->datepaie = new DbField(
            'paiement',
            'paiement',
            'x_datepaie',
            'datepaie',
            '`datepaie`',
            CastDateFieldForLike("`datepaie`", 2, "DB"),
            133,
            10,
            2,
            false,
            '`datepaie`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->datepaie->InputTextType = "text";
        $this->datepaie->Required = true; // Required field
        $this->datepaie->DefaultErrorMessage = str_replace("%s", DateFormat(2), $Language->phrase("IncorrectDate"));
        $this->Fields['datepaie'] = &$this->datepaie;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "immeuble") {
            if ($this->id_immeuble->getSessionValue() != "") {
                $masterFilter .= "" . GetForeignKeySql("`id_immeuble`", $this->id_immeuble->getSessionValue(), DATATYPE_NUMBER, "DB");
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "immeuble") {
            if ($this->id_immeuble->getSessionValue() != "") {
                $detailFilter .= "" . GetForeignKeySql("`id_immeuble`", $this->id_immeuble->getSessionValue(), DATATYPE_NUMBER, "DB");
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "immeuble":
                $key = $keys["id_immeuble"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->id_immeuble->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return "`id_immeuble`=" . QuotedValue($keys["id_immeuble"], $masterTable->id_immeuble->DataType, $masterTable->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "immeuble":
                return "`id_immeuble`=" . QuotedValue($masterTable->id_immeuble->DbValue, $this->id_immeuble->DataType, $this->Dbid);
        }
        return "";
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`paiement`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            if ($this->getCurrentMasterTable() == "immeuble" || $this->getCurrentMasterTable() == "") {
                $filter = $this->addDetailUserIDFilter($filter, "immeuble"); // Add detail User ID filter
            }
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id_owner', $rs)) {
                AddFilter($where, QuotedName('id_owner', $this->Dbid) . '=' . QuotedValue($rs['id_owner'], $this->id_owner->DataType, $this->Dbid));
            }
            if (array_key_exists('id_immeuble', $rs)) {
                AddFilter($where, QuotedName('id_immeuble', $this->Dbid) . '=' . QuotedValue($rs['id_immeuble'], $this->id_immeuble->DataType, $this->Dbid));
            }
            if (array_key_exists('id_ex_fiscal', $rs)) {
                AddFilter($where, QuotedName('id_ex_fiscal', $this->Dbid) . '=' . QuotedValue($rs['id_ex_fiscal'], $this->id_ex_fiscal->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id_owner->DbValue = $row['id_owner'];
        $this->id_immeuble->DbValue = $row['id_immeuble'];
        $this->id_ex_fiscal->DbValue = $row['id_ex_fiscal'];
        $this->montant->DbValue = $row['montant'];
        $this->datepaie->DbValue = $row['datepaie'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id_owner` = @id_owner@ AND `id_immeuble` = @id_immeuble@ AND `id_ex_fiscal` = @id_ex_fiscal@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->id_owner->CurrentValue : $this->id_owner->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $val = $current ? $this->id_immeuble->CurrentValue : $this->id_immeuble->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $val = $current ? $this->id_ex_fiscal->CurrentValue : $this->id_ex_fiscal->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 3) {
            if ($current) {
                $this->id_owner->CurrentValue = $keys[0];
            } else {
                $this->id_owner->OldValue = $keys[0];
            }
            if ($current) {
                $this->id_immeuble->CurrentValue = $keys[1];
            } else {
                $this->id_immeuble->OldValue = $keys[1];
            }
            if ($current) {
                $this->id_ex_fiscal->CurrentValue = $keys[2];
            } else {
                $this->id_ex_fiscal->OldValue = $keys[2];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id_owner', $row) ? $row['id_owner'] : null;
        } else {
            $val = $this->id_owner->OldValue !== null ? $this->id_owner->OldValue : $this->id_owner->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id_owner@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        if (is_array($row)) {
            $val = array_key_exists('id_immeuble', $row) ? $row['id_immeuble'] : null;
        } else {
            $val = $this->id_immeuble->OldValue !== null ? $this->id_immeuble->OldValue : $this->id_immeuble->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id_immeuble@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        if (is_array($row)) {
            $val = array_key_exists('id_ex_fiscal', $row) ? $row['id_ex_fiscal'] : null;
        } else {
            $val = $this->id_ex_fiscal->OldValue !== null ? $this->id_ex_fiscal->OldValue : $this->id_ex_fiscal->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id_ex_fiscal@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("PaiementList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "PaiementView") {
            return $Language->phrase("View");
        } elseif ($pageName == "PaiementEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "PaiementAdd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "PaiementView";
            case Config("API_ADD_ACTION"):
                return "PaiementAdd";
            case Config("API_EDIT_ACTION"):
                return "PaiementEdit";
            case Config("API_DELETE_ACTION"):
                return "PaiementDelete";
            case Config("API_LIST_ACTION"):
                return "PaiementList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "PaiementList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("PaiementView", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("PaiementView", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "PaiementAdd?" . $this->getUrlParm($parm);
        } else {
            $url = "PaiementAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("PaiementEdit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("PaiementAdd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("PaiementDelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "immeuble" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_id_immeuble", $this->id_immeuble->CurrentValue);
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id_owner\":" . JsonEncode($this->id_owner->CurrentValue, "number");
        $json .= ",\"id_immeuble\":" . JsonEncode($this->id_immeuble->CurrentValue, "number");
        $json .= ",\"id_ex_fiscal\":" . JsonEncode($this->id_ex_fiscal->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id_owner->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id_owner->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($this->id_immeuble->CurrentValue !== null) {
            $url .= $this->RouteCompositeKeySeparator . $this->encodeKeyValue($this->id_immeuble->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($this->id_ex_fiscal->CurrentValue !== null) {
            $url .= $this->RouteCompositeKeySeparator . $this->encodeKeyValue($this->id_ex_fiscal->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
            for ($i = 0; $i < $cnt; $i++) {
                $arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
            }
        } else {
            if (($keyValue = Param("id_owner") ?? Route("id_owner")) !== null) {
                $arKey[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            if (($keyValue = Param("id_immeuble") ?? Route("id_immeuble")) !== null) {
                $arKey[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(1) ?? Route(3)) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            if (($keyValue = Param("id_ex_fiscal") ?? Route("id_ex_fiscal")) !== null) {
                $arKey[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(2) ?? Route(4)) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            if (is_array($arKeys)) {
                $arKeys[] = $arKey;
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_array($key) || count($key) != 3) {
                    continue; // Just skip so other keys will still work
                }
                if (!is_numeric($key[0])) { // id_owner
                    continue;
                }
                if (!is_numeric($key[1])) { // id_immeuble
                    continue;
                }
                if (!is_numeric($key[2])) { // id_ex_fiscal
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id_owner->CurrentValue = $key[0];
            } else {
                $this->id_owner->OldValue = $key[0];
            }
            if ($setCurrent) {
                $this->id_immeuble->CurrentValue = $key[1];
            } else {
                $this->id_immeuble->OldValue = $key[1];
            }
            if ($setCurrent) {
                $this->id_ex_fiscal->CurrentValue = $key[2];
            } else {
                $this->id_ex_fiscal->OldValue = $key[2];
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id_owner->setDbValue($row['id_owner']);
        $this->id_immeuble->setDbValue($row['id_immeuble']);
        $this->id_ex_fiscal->setDbValue($row['id_ex_fiscal']);
        $this->montant->setDbValue($row['montant']);
        $this->datepaie->setDbValue($row['datepaie']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id_owner

        // id_immeuble

        // id_ex_fiscal

        // montant

        // datepaie

        // id_owner
        $curVal = strval($this->id_owner->CurrentValue);
        if ($curVal != "") {
            $this->id_owner->ViewValue = $this->id_owner->lookupCacheOption($curVal);
            if ($this->id_owner->ViewValue === null) { // Lookup from database
                $filterWrk = "`id_owner`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->id_owner->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->id_owner->Lookup->renderViewRow($rswrk[0]);
                    $this->id_owner->ViewValue = $this->id_owner->displayValue($arwrk);
                } else {
                    $this->id_owner->ViewValue = FormatNumber($this->id_owner->CurrentValue, $this->id_owner->formatPattern());
                }
            }
        } else {
            $this->id_owner->ViewValue = null;
        }
        $this->id_owner->ViewCustomAttributes = "";

        // id_immeuble
        $curVal = strval($this->id_immeuble->CurrentValue);
        if ($curVal != "") {
            $this->id_immeuble->ViewValue = $this->id_immeuble->lookupCacheOption($curVal);
            if ($this->id_immeuble->ViewValue === null) { // Lookup from database
                $filterWrk = "`id_immeuble`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->id_immeuble->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->id_immeuble->Lookup->renderViewRow($rswrk[0]);
                    $this->id_immeuble->ViewValue = $this->id_immeuble->displayValue($arwrk);
                } else {
                    $this->id_immeuble->ViewValue = FormatNumber($this->id_immeuble->CurrentValue, $this->id_immeuble->formatPattern());
                }
            }
        } else {
            $this->id_immeuble->ViewValue = null;
        }
        $this->id_immeuble->ViewCustomAttributes = "";

        // id_ex_fiscal
        $curVal = strval($this->id_ex_fiscal->CurrentValue);
        if ($curVal != "") {
            $this->id_ex_fiscal->ViewValue = $this->id_ex_fiscal->lookupCacheOption($curVal);
            if ($this->id_ex_fiscal->ViewValue === null) { // Lookup from database
                $filterWrk = "`id_ex_fiscal`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->id_ex_fiscal->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->id_ex_fiscal->Lookup->renderViewRow($rswrk[0]);
                    $this->id_ex_fiscal->ViewValue = $this->id_ex_fiscal->displayValue($arwrk);
                } else {
                    $this->id_ex_fiscal->ViewValue = $this->id_ex_fiscal->CurrentValue;
                }
            }
        } else {
            $this->id_ex_fiscal->ViewValue = null;
        }
        $this->id_ex_fiscal->ViewCustomAttributes = "";

        // montant
        $this->montant->ViewValue = $this->montant->CurrentValue;
        $this->montant->ViewValue = FormatNumber($this->montant->ViewValue, $this->montant->formatPattern());
        $this->montant->ViewCustomAttributes = "";

        // datepaie
        $this->datepaie->ViewValue = $this->datepaie->CurrentValue;
        $this->datepaie->ViewValue = FormatDateTime($this->datepaie->ViewValue, $this->datepaie->formatPattern());
        $this->datepaie->ViewCustomAttributes = "";

        // id_owner
        $this->id_owner->LinkCustomAttributes = "";
        $this->id_owner->HrefValue = "";
        $this->id_owner->TooltipValue = "";

        // id_immeuble
        $this->id_immeuble->LinkCustomAttributes = "";
        $this->id_immeuble->HrefValue = "";
        $this->id_immeuble->TooltipValue = "";

        // id_ex_fiscal
        $this->id_ex_fiscal->LinkCustomAttributes = "";
        $this->id_ex_fiscal->HrefValue = "";
        $this->id_ex_fiscal->TooltipValue = "";

        // montant
        $this->montant->LinkCustomAttributes = "";
        $this->montant->HrefValue = "";
        $this->montant->TooltipValue = "";

        // datepaie
        $this->datepaie->LinkCustomAttributes = "";
        $this->datepaie->HrefValue = "";
        $this->datepaie->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id_owner
        $this->id_owner->setupEditAttributes();
        $this->id_owner->EditCustomAttributes = "";
        $this->id_owner->PlaceHolder = RemoveHtml($this->id_owner->caption());

        // id_immeuble
        $this->id_immeuble->setupEditAttributes();
        $this->id_immeuble->EditCustomAttributes = "";
        $this->id_immeuble->PlaceHolder = RemoveHtml($this->id_immeuble->caption());

        // id_ex_fiscal
        $this->id_ex_fiscal->setupEditAttributes();
        $this->id_ex_fiscal->EditCustomAttributes = "";
        $this->id_ex_fiscal->PlaceHolder = RemoveHtml($this->id_ex_fiscal->caption());

        // montant
        $this->montant->setupEditAttributes();
        $this->montant->EditCustomAttributes = "";
        $this->montant->EditValue = $this->montant->CurrentValue;
        $this->montant->PlaceHolder = RemoveHtml($this->montant->caption());
        if (strval($this->montant->EditValue) != "" && is_numeric($this->montant->EditValue)) {
            $this->montant->EditValue = FormatNumber($this->montant->EditValue, null);
        }

        // datepaie
        $this->datepaie->setupEditAttributes();
        $this->datepaie->EditCustomAttributes = "";
        $this->datepaie->EditValue = FormatDateTime($this->datepaie->CurrentValue, $this->datepaie->formatPattern());
        $this->datepaie->PlaceHolder = RemoveHtml($this->datepaie->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->montant->CurrentValue)) {
                $this->montant->Total += $this->montant->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->montant->CurrentValue = $this->montant->Total;
            $this->montant->ViewValue = $this->montant->CurrentValue;
            $this->montant->ViewValue = FormatNumber($this->montant->ViewValue, $this->montant->formatPattern());
            $this->montant->ViewCustomAttributes = "";
            $this->montant->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id_owner);
                    $doc->exportCaption($this->id_immeuble);
                    $doc->exportCaption($this->id_ex_fiscal);
                    $doc->exportCaption($this->montant);
                    $doc->exportCaption($this->datepaie);
                } else {
                    $doc->exportCaption($this->id_owner);
                    $doc->exportCaption($this->id_immeuble);
                    $doc->exportCaption($this->id_ex_fiscal);
                    $doc->exportCaption($this->montant);
                    $doc->exportCaption($this->datepaie);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id_owner);
                        $doc->exportField($this->id_immeuble);
                        $doc->exportField($this->id_ex_fiscal);
                        $doc->exportField($this->montant);
                        $doc->exportField($this->datepaie);
                    } else {
                        $doc->exportField($this->id_owner);
                        $doc->exportField($this->id_immeuble);
                        $doc->exportField($this->id_ex_fiscal);
                        $doc->exportField($this->montant);
                        $doc->exportField($this->datepaie);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->ExportDoc = &$doc;
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = ROWTYPE_AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id_owner, '');
                $doc->exportAggregate($this->id_immeuble, '');
                $doc->exportAggregate($this->id_ex_fiscal, '');
                $doc->exportAggregate($this->montant, 'TOTAL');
                $doc->exportAggregate($this->datepaie, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Add master User ID filter
    public function addMasterUserIDFilter($filter, $currentMasterTable)
    {
        $filterWrk = $filter;
        if ($currentMasterTable == "immeuble") {
            $filterWrk = Container("immeuble")->addUserIDFilter($filterWrk);
        }
        return $filterWrk;
    }

    // Add detail User ID filter
    public function addDetailUserIDFilter($filter, $currentMasterTable)
    {
        $filterWrk = $filter;
        if ($currentMasterTable == "immeuble") {
            $mastertable = Container("immeuble");
            if (!$mastertable->userIDAllow()) {
                $subqueryWrk = $mastertable->getUserIDSubquery($this->id_immeuble, $mastertable->id_immeuble);
                AddFilter($filterWrk, $subqueryWrk);
            }
        }
        return $filterWrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
