<?php

namespace PHPMaker2022\cfpb;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class OwnerEdit extends Owner
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'owner';

    // Page object name
    public $PageObjName = "OwnerEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = $route->getArguments();
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        $url = rtrim(UrlFor($route->getName(), $args), "/") . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return $this->TableVar == $CurrentForm->getValue("t");
            }
            if (Get("t") !== null) {
                return $this->TableVar == Get("t");
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (owner)
        if (!isset($GLOBALS["owner"]) || get_class($GLOBALS["owner"]) == PROJECT_NAMESPACE . "owner") {
            $GLOBALS["owner"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'owner');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $tbl = Container("owner");
                $doc = new $class($tbl);
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "OwnerView") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id_owner'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id_owner->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param("layout", true));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->id_owner->setVisibility();
        $this->nom_pro->setVisibility();
        $this->prenom_pro->setVisibility();
        $this->nom_jf->setVisibility();
        $this->nif->setVisibility();
        $this->cell->setVisibility();
        $this->hideFieldsForAddEdit();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $this->FormClassName = "ew-form ew-edit-form";
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id_owner") ?? Key(0) ?? Route(2)) !== null) {
                $this->id_owner->setQueryStringValue($keyValue);
                $this->id_owner->setOldValue($this->id_owner->QueryStringValue);
            } elseif (Post("id_owner") !== null) {
                $this->id_owner->setFormValue(Post("id_owner"));
                $this->id_owner->setOldValue($this->id_owner->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action") !== null) {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id_owner") ?? Route("id_owner")) !== null) {
                    $this->id_owner->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id_owner->CurrentValue = null;
                }
            }

            // Load recordset
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("OwnerList"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "OwnerList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }
                    if (IsApi()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = ROWTYPE_EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id_owner' first before field var 'x_id_owner'
        $val = $CurrentForm->hasValue("id_owner") ? $CurrentForm->getValue("id_owner") : $CurrentForm->getValue("x_id_owner");
        if (!$this->id_owner->IsDetailKey) {
            $this->id_owner->setFormValue($val);
        }

        // Check field name 'nom_pro' first before field var 'x_nom_pro'
        $val = $CurrentForm->hasValue("nom_pro") ? $CurrentForm->getValue("nom_pro") : $CurrentForm->getValue("x_nom_pro");
        if (!$this->nom_pro->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->nom_pro->Visible = false; // Disable update for API request
            } else {
                $this->nom_pro->setFormValue($val);
            }
        }

        // Check field name 'prenom_pro' first before field var 'x_prenom_pro'
        $val = $CurrentForm->hasValue("prenom_pro") ? $CurrentForm->getValue("prenom_pro") : $CurrentForm->getValue("x_prenom_pro");
        if (!$this->prenom_pro->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->prenom_pro->Visible = false; // Disable update for API request
            } else {
                $this->prenom_pro->setFormValue($val);
            }
        }

        // Check field name 'nom_jf' first before field var 'x_nom_jf'
        $val = $CurrentForm->hasValue("nom_jf") ? $CurrentForm->getValue("nom_jf") : $CurrentForm->getValue("x_nom_jf");
        if (!$this->nom_jf->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->nom_jf->Visible = false; // Disable update for API request
            } else {
                $this->nom_jf->setFormValue($val);
            }
        }

        // Check field name 'nif' first before field var 'x_nif'
        $val = $CurrentForm->hasValue("nif") ? $CurrentForm->getValue("nif") : $CurrentForm->getValue("x_nif");
        if (!$this->nif->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->nif->Visible = false; // Disable update for API request
            } else {
                $this->nif->setFormValue($val);
            }
        }

        // Check field name 'cell' first before field var 'x_cell'
        $val = $CurrentForm->hasValue("cell") ? $CurrentForm->getValue("cell") : $CurrentForm->getValue("x_cell");
        if (!$this->cell->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cell->Visible = false; // Disable update for API request
            } else {
                $this->cell->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id_owner->CurrentValue = $this->id_owner->FormValue;
        $this->nom_pro->CurrentValue = $this->nom_pro->FormValue;
        $this->prenom_pro->CurrentValue = $this->prenom_pro->FormValue;
        $this->nom_jf->CurrentValue = $this->nom_jf->FormValue;
        $this->nif->CurrentValue = $this->nif->FormValue;
        $this->cell->CurrentValue = $this->cell->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id_owner->setDbValue($row['id_owner']);
        $this->nom_pro->setDbValue($row['nom_pro']);
        $this->prenom_pro->setDbValue($row['prenom_pro']);
        $this->nom_jf->setDbValue($row['nom_jf']);
        $this->nif->setDbValue($row['nif']);
        $this->cell->setDbValue($row['cell']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id_owner'] = $this->id_owner->DefaultValue;
        $row['nom_pro'] = $this->nom_pro->DefaultValue;
        $row['prenom_pro'] = $this->prenom_pro->DefaultValue;
        $row['nom_jf'] = $this->nom_jf->DefaultValue;
        $row['nif'] = $this->nif->DefaultValue;
        $row['cell'] = $this->cell->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id_owner
        $this->id_owner->RowCssClass = "row";

        // nom_pro
        $this->nom_pro->RowCssClass = "row";

        // prenom_pro
        $this->prenom_pro->RowCssClass = "row";

        // nom_jf
        $this->nom_jf->RowCssClass = "row";

        // nif
        $this->nif->RowCssClass = "row";

        // cell
        $this->cell->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // id_owner
            $this->id_owner->ViewValue = $this->id_owner->CurrentValue;
            $this->id_owner->ViewCustomAttributes = "";

            // nom_pro
            $this->nom_pro->ViewValue = $this->nom_pro->CurrentValue;
            $this->nom_pro->ViewCustomAttributes = "";

            // prenom_pro
            $this->prenom_pro->ViewValue = $this->prenom_pro->CurrentValue;
            $this->prenom_pro->ViewCustomAttributes = "";

            // nom_jf
            $this->nom_jf->ViewValue = $this->nom_jf->CurrentValue;
            $this->nom_jf->ViewCustomAttributes = "";

            // nif
            $this->nif->ViewValue = $this->nif->CurrentValue;
            $this->nif->ViewCustomAttributes = "";

            // cell
            $this->cell->ViewValue = $this->cell->CurrentValue;
            $this->cell->ViewCustomAttributes = "";

            // id_owner
            $this->id_owner->LinkCustomAttributes = "";
            $this->id_owner->HrefValue = "";

            // nom_pro
            $this->nom_pro->LinkCustomAttributes = "";
            $this->nom_pro->HrefValue = "";

            // prenom_pro
            $this->prenom_pro->LinkCustomAttributes = "";
            $this->prenom_pro->HrefValue = "";

            // nom_jf
            $this->nom_jf->LinkCustomAttributes = "";
            $this->nom_jf->HrefValue = "";

            // nif
            $this->nif->LinkCustomAttributes = "";
            $this->nif->HrefValue = "";

            // cell
            $this->cell->LinkCustomAttributes = "";
            $this->cell->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // id_owner
            $this->id_owner->setupEditAttributes();
            $this->id_owner->EditCustomAttributes = "";
            $this->id_owner->EditValue = $this->id_owner->CurrentValue;
            $this->id_owner->ViewCustomAttributes = "";

            // nom_pro
            $this->nom_pro->setupEditAttributes();
            $this->nom_pro->EditCustomAttributes = "";
            if (!$this->nom_pro->Raw) {
                $this->nom_pro->CurrentValue = HtmlDecode($this->nom_pro->CurrentValue);
            }
            $this->nom_pro->EditValue = HtmlEncode($this->nom_pro->CurrentValue);
            $this->nom_pro->PlaceHolder = RemoveHtml($this->nom_pro->caption());

            // prenom_pro
            $this->prenom_pro->setupEditAttributes();
            $this->prenom_pro->EditCustomAttributes = "";
            if (!$this->prenom_pro->Raw) {
                $this->prenom_pro->CurrentValue = HtmlDecode($this->prenom_pro->CurrentValue);
            }
            $this->prenom_pro->EditValue = HtmlEncode($this->prenom_pro->CurrentValue);
            $this->prenom_pro->PlaceHolder = RemoveHtml($this->prenom_pro->caption());

            // nom_jf
            $this->nom_jf->setupEditAttributes();
            $this->nom_jf->EditCustomAttributes = "";
            if (!$this->nom_jf->Raw) {
                $this->nom_jf->CurrentValue = HtmlDecode($this->nom_jf->CurrentValue);
            }
            $this->nom_jf->EditValue = HtmlEncode($this->nom_jf->CurrentValue);
            $this->nom_jf->PlaceHolder = RemoveHtml($this->nom_jf->caption());

            // nif
            $this->nif->setupEditAttributes();
            $this->nif->EditCustomAttributes = "";
            if (!$this->nif->Raw) {
                $this->nif->CurrentValue = HtmlDecode($this->nif->CurrentValue);
            }
            $this->nif->EditValue = HtmlEncode($this->nif->CurrentValue);
            $this->nif->PlaceHolder = RemoveHtml($this->nif->caption());

            // cell
            $this->cell->setupEditAttributes();
            $this->cell->EditCustomAttributes = "";
            if (!$this->cell->Raw) {
                $this->cell->CurrentValue = HtmlDecode($this->cell->CurrentValue);
            }
            $this->cell->EditValue = HtmlEncode($this->cell->CurrentValue);
            $this->cell->PlaceHolder = RemoveHtml($this->cell->caption());

            // Edit refer script

            // id_owner
            $this->id_owner->LinkCustomAttributes = "";
            $this->id_owner->HrefValue = "";

            // nom_pro
            $this->nom_pro->LinkCustomAttributes = "";
            $this->nom_pro->HrefValue = "";

            // prenom_pro
            $this->prenom_pro->LinkCustomAttributes = "";
            $this->prenom_pro->HrefValue = "";

            // nom_jf
            $this->nom_jf->LinkCustomAttributes = "";
            $this->nom_jf->HrefValue = "";

            // nif
            $this->nif->LinkCustomAttributes = "";
            $this->nif->HrefValue = "";

            // cell
            $this->cell->LinkCustomAttributes = "";
            $this->cell->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->id_owner->Required) {
            if (!$this->id_owner->IsDetailKey && EmptyValue($this->id_owner->FormValue)) {
                $this->id_owner->addErrorMessage(str_replace("%s", $this->id_owner->caption(), $this->id_owner->RequiredErrorMessage));
            }
        }
        if ($this->nom_pro->Required) {
            if (!$this->nom_pro->IsDetailKey && EmptyValue($this->nom_pro->FormValue)) {
                $this->nom_pro->addErrorMessage(str_replace("%s", $this->nom_pro->caption(), $this->nom_pro->RequiredErrorMessage));
            }
        }
        if ($this->prenom_pro->Required) {
            if (!$this->prenom_pro->IsDetailKey && EmptyValue($this->prenom_pro->FormValue)) {
                $this->prenom_pro->addErrorMessage(str_replace("%s", $this->prenom_pro->caption(), $this->prenom_pro->RequiredErrorMessage));
            }
        }
        if ($this->nom_jf->Required) {
            if (!$this->nom_jf->IsDetailKey && EmptyValue($this->nom_jf->FormValue)) {
                $this->nom_jf->addErrorMessage(str_replace("%s", $this->nom_jf->caption(), $this->nom_jf->RequiredErrorMessage));
            }
        }
        if ($this->nif->Required) {
            if (!$this->nif->IsDetailKey && EmptyValue($this->nif->FormValue)) {
                $this->nif->addErrorMessage(str_replace("%s", $this->nif->caption(), $this->nif->RequiredErrorMessage));
            }
        }
        if ($this->cell->Required) {
            if (!$this->cell->IsDetailKey && EmptyValue($this->cell->FormValue)) {
                $this->cell->addErrorMessage(str_replace("%s", $this->cell->caption(), $this->cell->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
        }

        // Set new row
        $rsnew = [];

        // nom_pro
        $this->nom_pro->setDbValueDef($rsnew, $this->nom_pro->CurrentValue, "", $this->nom_pro->ReadOnly);

        // prenom_pro
        $this->prenom_pro->setDbValueDef($rsnew, $this->prenom_pro->CurrentValue, "", $this->prenom_pro->ReadOnly);

        // nom_jf
        $this->nom_jf->setDbValueDef($rsnew, $this->nom_jf->CurrentValue, null, $this->nom_jf->ReadOnly);

        // nif
        $this->nif->setDbValueDef($rsnew, $this->nif->CurrentValue, null, $this->nif->ReadOnly);

        // cell
        $this->cell->setDbValueDef($rsnew, $this->cell->CurrentValue, null, $this->cell->ReadOnly);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($editRow) {
        }

        // Write JSON for API request
        if (IsApi() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $editRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("OwnerList"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $ar[strval($row["lf"])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        if ($this->isPageRequest()) { // Validate request
            $startRec = Get(Config("TABLE_START_REC"));
            if ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
                $this->StartRecord = $startRec;
                $this->setStartRecordNumber($this->StartRecord);
            }
        }
        $this->StartRecord = $this->getStartRecordNumber();

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
            $this->setStartRecordNumber($this->StartRecord);
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
