<?php

namespace PHPMaker2022\cfpb;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class OwnerAddopt extends Owner
{
    use MessagesTrait;

    // Page ID
    public $PageID = "addopt";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'owner';

    // Page object name
    public $PageObjName = "OwnerAddopt";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = $route->getArguments();
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        $url = rtrim(UrlFor($route->getName(), $args), "/") . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return $this->TableVar == $CurrentForm->getValue("t");
            }
            if (Get("t") !== null) {
                return $this->TableVar == Get("t");
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (owner)
        if (!isset($GLOBALS["owner"]) || get_class($GLOBALS["owner"]) == PROJECT_NAMESPACE . "owner") {
            $GLOBALS["owner"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'owner');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $tbl = Container("owner");
                $doc = new $class($tbl);
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id_owner'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id_owner->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $IsModal = false;
    public $IsMobileOrModal = true; // Add option page is always modal

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param("layout", true));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->id_owner->Visible = false;
        $this->nom_pro->setVisibility();
        $this->prenom_pro->setVisibility();
        $this->nom_jf->setVisibility();
        $this->nif->setVisibility();
        $this->cell->setVisibility();
        $this->hideFieldsForAddEdit();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache

        // Load default values for add
        $this->loadDefaultValues();

        // Set up Breadcrumb
        //$this->setupBreadcrumb(); // Not used
        $this->loadRowValues(); // Load default values

        // Render row
        $this->RowType = ROWTYPE_ADD; // Render add type
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'nom_pro' first before field var 'x_nom_pro'
        $val = $CurrentForm->hasValue("nom_pro") ? $CurrentForm->getValue("nom_pro") : $CurrentForm->getValue("x_nom_pro");
        if (!$this->nom_pro->IsDetailKey) {
            $this->nom_pro->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'prenom_pro' first before field var 'x_prenom_pro'
        $val = $CurrentForm->hasValue("prenom_pro") ? $CurrentForm->getValue("prenom_pro") : $CurrentForm->getValue("x_prenom_pro");
        if (!$this->prenom_pro->IsDetailKey) {
            $this->prenom_pro->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'nom_jf' first before field var 'x_nom_jf'
        $val = $CurrentForm->hasValue("nom_jf") ? $CurrentForm->getValue("nom_jf") : $CurrentForm->getValue("x_nom_jf");
        if (!$this->nom_jf->IsDetailKey) {
            $this->nom_jf->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'nif' first before field var 'x_nif'
        $val = $CurrentForm->hasValue("nif") ? $CurrentForm->getValue("nif") : $CurrentForm->getValue("x_nif");
        if (!$this->nif->IsDetailKey) {
            $this->nif->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'cell' first before field var 'x_cell'
        $val = $CurrentForm->hasValue("cell") ? $CurrentForm->getValue("cell") : $CurrentForm->getValue("x_cell");
        if (!$this->cell->IsDetailKey) {
            $this->cell->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'id_owner' first before field var 'x_id_owner'
        $val = $CurrentForm->hasValue("id_owner") ? $CurrentForm->getValue("id_owner") : $CurrentForm->getValue("x_id_owner");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->nom_pro->CurrentValue = ConvertToUtf8($this->nom_pro->FormValue);
        $this->prenom_pro->CurrentValue = ConvertToUtf8($this->prenom_pro->FormValue);
        $this->nom_jf->CurrentValue = ConvertToUtf8($this->nom_jf->FormValue);
        $this->nif->CurrentValue = ConvertToUtf8($this->nif->FormValue);
        $this->cell->CurrentValue = ConvertToUtf8($this->cell->FormValue);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id_owner->setDbValue($row['id_owner']);
        $this->nom_pro->setDbValue($row['nom_pro']);
        $this->prenom_pro->setDbValue($row['prenom_pro']);
        $this->nom_jf->setDbValue($row['nom_jf']);
        $this->nif->setDbValue($row['nif']);
        $this->cell->setDbValue($row['cell']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id_owner'] = $this->id_owner->DefaultValue;
        $row['nom_pro'] = $this->nom_pro->DefaultValue;
        $row['prenom_pro'] = $this->prenom_pro->DefaultValue;
        $row['nom_jf'] = $this->nom_jf->DefaultValue;
        $row['nif'] = $this->nif->DefaultValue;
        $row['cell'] = $this->cell->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id_owner
        $this->id_owner->RowCssClass = "row";

        // nom_pro
        $this->nom_pro->RowCssClass = "row";

        // prenom_pro
        $this->prenom_pro->RowCssClass = "row";

        // nom_jf
        $this->nom_jf->RowCssClass = "row";

        // nif
        $this->nif->RowCssClass = "row";

        // cell
        $this->cell->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // id_owner
            $this->id_owner->ViewValue = $this->id_owner->CurrentValue;
            $this->id_owner->ViewCustomAttributes = "";

            // nom_pro
            $this->nom_pro->ViewValue = $this->nom_pro->CurrentValue;
            $this->nom_pro->ViewCustomAttributes = "";

            // prenom_pro
            $this->prenom_pro->ViewValue = $this->prenom_pro->CurrentValue;
            $this->prenom_pro->ViewCustomAttributes = "";

            // nom_jf
            $this->nom_jf->ViewValue = $this->nom_jf->CurrentValue;
            $this->nom_jf->ViewCustomAttributes = "";

            // nif
            $this->nif->ViewValue = $this->nif->CurrentValue;
            $this->nif->ViewCustomAttributes = "";

            // cell
            $this->cell->ViewValue = $this->cell->CurrentValue;
            $this->cell->ViewCustomAttributes = "";

            // nom_pro
            $this->nom_pro->LinkCustomAttributes = "";
            $this->nom_pro->HrefValue = "";
            $this->nom_pro->TooltipValue = "";

            // prenom_pro
            $this->prenom_pro->LinkCustomAttributes = "";
            $this->prenom_pro->HrefValue = "";
            $this->prenom_pro->TooltipValue = "";

            // nom_jf
            $this->nom_jf->LinkCustomAttributes = "";
            $this->nom_jf->HrefValue = "";
            $this->nom_jf->TooltipValue = "";

            // nif
            $this->nif->LinkCustomAttributes = "";
            $this->nif->HrefValue = "";
            $this->nif->TooltipValue = "";

            // cell
            $this->cell->LinkCustomAttributes = "";
            $this->cell->HrefValue = "";
            $this->cell->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // nom_pro
            $this->nom_pro->setupEditAttributes();
            $this->nom_pro->EditCustomAttributes = "";
            if (!$this->nom_pro->Raw) {
                $this->nom_pro->CurrentValue = HtmlDecode($this->nom_pro->CurrentValue);
            }
            $this->nom_pro->EditValue = HtmlEncode($this->nom_pro->CurrentValue);
            $this->nom_pro->PlaceHolder = RemoveHtml($this->nom_pro->caption());

            // prenom_pro
            $this->prenom_pro->setupEditAttributes();
            $this->prenom_pro->EditCustomAttributes = "";
            if (!$this->prenom_pro->Raw) {
                $this->prenom_pro->CurrentValue = HtmlDecode($this->prenom_pro->CurrentValue);
            }
            $this->prenom_pro->EditValue = HtmlEncode($this->prenom_pro->CurrentValue);
            $this->prenom_pro->PlaceHolder = RemoveHtml($this->prenom_pro->caption());

            // nom_jf
            $this->nom_jf->setupEditAttributes();
            $this->nom_jf->EditCustomAttributes = "";
            if (!$this->nom_jf->Raw) {
                $this->nom_jf->CurrentValue = HtmlDecode($this->nom_jf->CurrentValue);
            }
            $this->nom_jf->EditValue = HtmlEncode($this->nom_jf->CurrentValue);
            $this->nom_jf->PlaceHolder = RemoveHtml($this->nom_jf->caption());

            // nif
            $this->nif->setupEditAttributes();
            $this->nif->EditCustomAttributes = "";
            if (!$this->nif->Raw) {
                $this->nif->CurrentValue = HtmlDecode($this->nif->CurrentValue);
            }
            $this->nif->EditValue = HtmlEncode($this->nif->CurrentValue);
            $this->nif->PlaceHolder = RemoveHtml($this->nif->caption());

            // cell
            $this->cell->setupEditAttributes();
            $this->cell->EditCustomAttributes = "";
            if (!$this->cell->Raw) {
                $this->cell->CurrentValue = HtmlDecode($this->cell->CurrentValue);
            }
            $this->cell->EditValue = HtmlEncode($this->cell->CurrentValue);
            $this->cell->PlaceHolder = RemoveHtml($this->cell->caption());

            // Add refer script

            // nom_pro
            $this->nom_pro->LinkCustomAttributes = "";
            $this->nom_pro->HrefValue = "";

            // prenom_pro
            $this->prenom_pro->LinkCustomAttributes = "";
            $this->prenom_pro->HrefValue = "";

            // nom_jf
            $this->nom_jf->LinkCustomAttributes = "";
            $this->nom_jf->HrefValue = "";

            // nif
            $this->nif->LinkCustomAttributes = "";
            $this->nif->HrefValue = "";

            // cell
            $this->cell->LinkCustomAttributes = "";
            $this->cell->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->nom_pro->Required) {
            if (!$this->nom_pro->IsDetailKey && EmptyValue($this->nom_pro->FormValue)) {
                $this->nom_pro->addErrorMessage(str_replace("%s", $this->nom_pro->caption(), $this->nom_pro->RequiredErrorMessage));
            }
        }
        if ($this->prenom_pro->Required) {
            if (!$this->prenom_pro->IsDetailKey && EmptyValue($this->prenom_pro->FormValue)) {
                $this->prenom_pro->addErrorMessage(str_replace("%s", $this->prenom_pro->caption(), $this->prenom_pro->RequiredErrorMessage));
            }
        }
        if ($this->nom_jf->Required) {
            if (!$this->nom_jf->IsDetailKey && EmptyValue($this->nom_jf->FormValue)) {
                $this->nom_jf->addErrorMessage(str_replace("%s", $this->nom_jf->caption(), $this->nom_jf->RequiredErrorMessage));
            }
        }
        if ($this->nif->Required) {
            if (!$this->nif->IsDetailKey && EmptyValue($this->nif->FormValue)) {
                $this->nif->addErrorMessage(str_replace("%s", $this->nif->caption(), $this->nif->RequiredErrorMessage));
            }
        }
        if ($this->cell->Required) {
            if (!$this->cell->IsDetailKey && EmptyValue($this->cell->FormValue)) {
                $this->cell->addErrorMessage(str_replace("%s", $this->cell->caption(), $this->cell->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("OwnerList"), "", $this->TableVar, true);
        $pageId = "addopt";
        $Breadcrumb->add("addopt", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $ar[strval($row["lf"])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }
}
