<?php

namespace PHPMaker2022\cfpb;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class ImmeubleView extends Immeuble
{
    use MessagesTrait;

    // Page ID
    public $PageID = "view";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'immeuble';

    // Page object name
    public $PageObjName = "ImmeubleView";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $CopyUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = $route->getArguments();
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        $url = rtrim(UrlFor($route->getName(), $args), "/") . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return $this->TableVar == $CurrentForm->getValue("t");
            }
            if (Get("t") !== null) {
                return $this->TableVar == Get("t");
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (immeuble)
        if (!isset($GLOBALS["immeuble"]) || get_class($GLOBALS["immeuble"]) == PROJECT_NAMESPACE . "immeuble") {
            $GLOBALS["immeuble"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);
        if (($keyValue = Get("id_immeuble") ?? Route("id_immeuble")) !== null) {
            $this->RecKey["id_immeuble"] = $keyValue;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'immeuble');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(["TagClassName" => "ew-export-option"]);

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(["TagClassName" => "ew-detail-option"]);
        // Actions
        $this->OtherOptions["action"] = new ListOptions(["TagClassName" => "ew-action-option"]);
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $tbl = Container("immeuble");
                $doc = new $class($tbl);
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "ImmeubleView") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id_immeuble'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id_immeuble->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $ExportOptions; // Export options
    public $OtherOptions; // Other options
    public $DisplayRecords = 1;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecKey = [];
    public $IsModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param("layout", true));

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } elseif (IsPost()) {
            if (Post("exporttype") !== null) {
                $this->Export = Post("exporttype");
            }
            $custom = Post("custom", "");
        } elseif (Get("cmd") == "json") {
            $this->Export = Get("cmd");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportFileName = $this->TableVar; // Get export file, used in header
        if (Get("id_immeuble") !== null) {
            if ($ExportFileName != "") {
                $ExportFileName .= "_";
            }
            $ExportFileName .= Get("id_immeuble");
        }

        // Get custom export parameters
        if ($this->isExport() && $custom != "") {
            $this->CustomExport = $this->Export;
            $this->Export = "print";
        }
        $CustomExportType = $this->CustomExport;
        $ExportType = $this->Export; // Get export parameter, used in header
        $this->CurrentAction = Param("action"); // Set up current action

        // Setup export options
        $this->setupExportOptions();
        $this->id_immeuble->setVisibility();
        $this->descrip->setVisibility();
        $this->codeimmeuble->setVisibility();
        $this->daterecensement->setVisibility();
        $this->st_annee_construct->setVisibility();
        $this->st_propriete->setVisibility();
        $this->st_en_affermage->setVisibility();
        $this->st_en_location->setVisibility();
        $this->st_en_usufruit->setVisibility();
        $this->st_autre->setVisibility();
        $this->ad_rue->setVisibility();
        $this->ad_no_immeuble->setVisibility();
        $this->ad_rue_adj->setVisibility();
        $this->ad_zonequartier->setVisibility();
        $this->ad_section->setVisibility();
        $this->ev_nb_toilette->setVisibility();
        $this->ev_nb_cuisine->setVisibility();
        $this->ev_nb_garage->setVisibility();
        $this->ev_nb_m2->setVisibility();
        $this->ev_autresalle->setVisibility();
        $this->ev_toit_tole->setVisibility();
        $this->ev_toit_beton->setVisibility();
        $this->ev_toit_tullles->setVisibility();
        $this->ev_plancher_bois->setVisibility();
        $this->ev_plancher_beton->setVisibility();
        $this->ev_plancher_mosaique->setVisibility();
        $this->ev_plancher_terazo->setVisibility();
        $this->ev_plancher_ceramique->setVisibility();
        $this->est_ex_fiscal->setVisibility();
        $this->est_estimation->setVisibility();
        $this->est_montant->setVisibility();
        $this->id_owner->setVisibility();
        $this->id_agent->setVisibility();
        $this->localisation->setVisibility();
        $this->usage->setVisibility();
        $this->hideFieldsForAddEdit();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->est_ex_fiscal);
        $this->setupLookupOptions($this->id_owner);
        $this->setupLookupOptions($this->id_agent);
        $this->setupLookupOptions($this->usage);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }

        // Load current record
        $loadCurrentRecord = false;
        $returnUrl = "";
        $matchRecord = false;
        if ($this->isPageRequest()) { // Validate request
            if (Get(Config("TABLE_START_REC")) !== null) {
                $loadCurrentRecord = true;
            }
            if (($keyValue = Get("id_immeuble") ?? Route("id_immeuble")) !== null) {
                $this->id_immeuble->setQueryStringValue($keyValue);
                $this->RecKey["id_immeuble"] = $this->id_immeuble->QueryStringValue;
            } elseif (Post("id_immeuble") !== null) {
                $this->id_immeuble->setFormValue(Post("id_immeuble"));
                $this->RecKey["id_immeuble"] = $this->id_immeuble->FormValue;
            } elseif (IsApi() && ($keyValue = Key(0) ?? Route(2)) !== null) {
                $this->id_immeuble->setQueryStringValue($keyValue);
                $this->RecKey["id_immeuble"] = $this->id_immeuble->QueryStringValue;
            } elseif (!$loadCurrentRecord) {
                $returnUrl = "ImmeubleList"; // Return to list
            }

            // Get action
            $this->CurrentAction = "show"; // Display
            switch ($this->CurrentAction) {
                case "show": // Get a record to display
                    if (!$this->IsModal) { // Normal view page
                        $this->StartRecord = 1; // Initialize start position
                        if ($this->Recordset = $this->loadRecordset()) { // Load records
                            $this->TotalRecords = $this->Recordset->recordCount(); // Get record count
                        }
                        if ($this->TotalRecords <= 0) { // No record found
                            if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                            }
                            $this->terminate("ImmeubleList"); // Return to list page
                            return;
                        } elseif ($loadCurrentRecord) { // Load current record position
                            $this->setupStartRecord(); // Set up start record position
                            // Point to current record
                            if ($this->StartRecord <= $this->TotalRecords) {
                                $matchRecord = true;
                                $this->Recordset->move($this->StartRecord - 1);
                            }
                        } else { // Match key values
                            while (!$this->Recordset->EOF) {
                                if (SameString($this->id_immeuble->CurrentValue, $this->Recordset->fields['id_immeuble'])) {
                                    $this->setStartRecordNumber($this->StartRecord); // Save record position
                                    $matchRecord = true;
                                    break;
                                } else {
                                    $this->StartRecord++;
                                    $this->Recordset->moveNext();
                                }
                            }
                        }
                        if (!$matchRecord) {
                            if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                            }
                            $returnUrl = "ImmeubleList"; // No matching record, return to list
                        } else {
                            $this->loadRowValues($this->Recordset); // Load row values
                        }
                    } else {
                        // Load record based on key
                        if (IsApi()) {
                            $filter = $this->getRecordFilter();
                            $this->CurrentFilter = $filter;
                            $sql = $this->getCurrentSql();
                            $conn = $this->getConnection();
                            $this->Recordset = LoadRecordset($sql, $conn);
                            $res = $this->Recordset && !$this->Recordset->EOF;
                        } else {
                            $res = $this->loadRow();
                        }
                        if (!$res) { // Load record based on key
                            if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                            }
                            $returnUrl = "ImmeubleList"; // No matching record, return to list
                        }
                    } // End modal checking
                    break;
            }

            // Export data only
            if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
                $this->exportData();
                $this->terminate();
                return;
            }
        } else {
            $returnUrl = "ImmeubleList"; // Not page request, return to list
        }
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->RowType = ROWTYPE_VIEW;
        $this->resetAttributes();
        $this->renderRow();

        // Set up detail parameters
        $this->setupDetailParms();

        // Normal return
        if (IsApi()) {
            $rows = $this->getRecordsFromRecordset($this->Recordset, true); // Get current record only
            $this->Recordset->close();
            WriteJson(["success" => true, $this->TableVar => $rows]);
            $this->terminate(true);
            return;
        }

        // Set up pager
        if (!$this->IsModal) { // Normal view page
            $this->Pager = new PrevNextPager($this->TableVar, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", $this->RecordRange, $this->AutoHidePager, false, false);
            $this->Pager->PageNumberName = Config("TABLE_START_REC"); // Same as start record
            $this->Pager->PagePhraseId = "Record"; // Show as record
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        }
        $item->Visible = ($this->AddUrl != "" && $Security->canAdd());

        // Edit
        $item = &$option->add("edit");
        $editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        }
        $item->Visible = ($this->EditUrl != "" && $Security->canEdit() && $this->showOptionLink("edit"));

        // Copy
        $item = &$option->add("copy");
        $copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        }
        $item->Visible = ($this->CopyUrl != "" && $Security->canAdd() && $this->showOptionLink("add"));

        // Delete
        $item = &$option->add("delete");
        if ($this->IsModal) { // Handle as inline delete
            $item->Body = "<a data-ew-action=\"inline-delete\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery(GetUrl($this->DeleteUrl), "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
        }
        $item->Visible = ($this->DeleteUrl != "" && $Security->canDelete() && $this->showOptionLink("delete"));
        $option = $options["detail"];
        $detailTableLink = "";
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_paiement"
        $item = &$option->add("detail_paiement");
        $body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("paiement", "TblCaption");
        $body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode(GetUrl("PaiementList?" . Config("TABLE_SHOW_MASTER") . "=immeuble&" . GetForeignKeyUrl("fk_id_immeuble", $this->id_immeuble->CurrentValue) . "")) . "\">" . $body . "</a>";
        $links = "";
        $detailPageObj = Container("PaiementGrid");
        if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'immeuble')) {
            $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=paiement"))) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            if ($detailViewTblVar != "") {
                $detailViewTblVar .= ",";
            }
            $detailViewTblVar .= "paiement";
        }
        if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'immeuble')) {
            $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=paiement"))) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            if ($detailEditTblVar != "") {
                $detailEditTblVar .= ",";
            }
            $detailEditTblVar .= "paiement";
        }
        if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'immeuble')) {
            $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=paiement"))) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            if ($detailCopyTblVar != "") {
                $detailCopyTblVar .= ",";
            }
            $detailCopyTblVar .= "paiement";
        }
        if ($links != "") {
            $body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
            $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
        }
        $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
        $item->Body = $body;
        $item->Visible = $Security->allowList(CurrentProjectID() . 'paiement');
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "paiement";
        }
        if ($this->ShowMultipleDetails) {
            $item->Visible = false;
        }

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode(GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar))) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode(GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar))) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode(GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar))) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $item = &$option->add("details");
            $item->Body = $body;
        }

        // Set up detail default
        $option = $options["detail"];
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $ar = explode(",", $detailTableLink);
        $cnt = count($ar);
        $option->UseDropDownButton = ($cnt > 1);
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
        $option->UseDropDownButton = false;
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAll(FetchMode::ASSOCIATIVE);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id_immeuble->setDbValue($row['id_immeuble']);
        $this->descrip->setDbValue($row['descrip']);
        $this->codeimmeuble->setDbValue($row['codeimmeuble']);
        $this->daterecensement->setDbValue($row['daterecensement']);
        $this->st_annee_construct->setDbValue($row['st_annee_construct']);
        $this->st_propriete->setDbValue($row['st_propriete']);
        $this->st_en_affermage->setDbValue($row['st_en_affermage']);
        $this->st_en_location->setDbValue($row['st_en_location']);
        $this->st_en_usufruit->setDbValue($row['st_en_usufruit']);
        $this->st_autre->setDbValue($row['st_autre']);
        $this->ad_rue->setDbValue($row['ad_rue']);
        $this->ad_no_immeuble->setDbValue($row['ad_no_immeuble']);
        $this->ad_rue_adj->setDbValue($row['ad_rue_adj']);
        $this->ad_zonequartier->setDbValue($row['ad_zonequartier']);
        $this->ad_section->setDbValue($row['ad_section']);
        $this->ev_nb_toilette->setDbValue($row['ev_nb_toilette']);
        $this->ev_nb_cuisine->setDbValue($row['ev_nb_cuisine']);
        $this->ev_nb_garage->setDbValue($row['ev_nb_garage']);
        $this->ev_nb_m2->setDbValue($row['ev_nb_m2']);
        $this->ev_autresalle->setDbValue($row['ev_autresalle']);
        $this->ev_toit_tole->setDbValue($row['ev_toit_tole']);
        $this->ev_toit_beton->setDbValue($row['ev_toit_beton']);
        $this->ev_toit_tullles->setDbValue($row['ev_toit_tullles']);
        $this->ev_plancher_bois->setDbValue($row['ev_plancher_bois']);
        $this->ev_plancher_beton->setDbValue($row['ev_plancher_beton']);
        $this->ev_plancher_mosaique->setDbValue($row['ev_plancher_mosaique']);
        $this->ev_plancher_terazo->setDbValue($row['ev_plancher_terazo']);
        $this->ev_plancher_ceramique->setDbValue($row['ev_plancher_ceramique']);
        $this->est_ex_fiscal->setDbValue($row['est_ex_fiscal']);
        $this->est_estimation->setDbValue($row['est_estimation']);
        $this->est_montant->setDbValue($row['est_montant']);
        $this->id_owner->setDbValue($row['id_owner']);
        $this->id_agent->setDbValue($row['id_agent']);
        $this->localisation->setDbValue($row['localisation']);
        $this->usage->setDbValue($row['usage']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id_immeuble'] = $this->id_immeuble->DefaultValue;
        $row['descrip'] = $this->descrip->DefaultValue;
        $row['codeimmeuble'] = $this->codeimmeuble->DefaultValue;
        $row['daterecensement'] = $this->daterecensement->DefaultValue;
        $row['st_annee_construct'] = $this->st_annee_construct->DefaultValue;
        $row['st_propriete'] = $this->st_propriete->DefaultValue;
        $row['st_en_affermage'] = $this->st_en_affermage->DefaultValue;
        $row['st_en_location'] = $this->st_en_location->DefaultValue;
        $row['st_en_usufruit'] = $this->st_en_usufruit->DefaultValue;
        $row['st_autre'] = $this->st_autre->DefaultValue;
        $row['ad_rue'] = $this->ad_rue->DefaultValue;
        $row['ad_no_immeuble'] = $this->ad_no_immeuble->DefaultValue;
        $row['ad_rue_adj'] = $this->ad_rue_adj->DefaultValue;
        $row['ad_zonequartier'] = $this->ad_zonequartier->DefaultValue;
        $row['ad_section'] = $this->ad_section->DefaultValue;
        $row['ev_nb_toilette'] = $this->ev_nb_toilette->DefaultValue;
        $row['ev_nb_cuisine'] = $this->ev_nb_cuisine->DefaultValue;
        $row['ev_nb_garage'] = $this->ev_nb_garage->DefaultValue;
        $row['ev_nb_m2'] = $this->ev_nb_m2->DefaultValue;
        $row['ev_autresalle'] = $this->ev_autresalle->DefaultValue;
        $row['ev_toit_tole'] = $this->ev_toit_tole->DefaultValue;
        $row['ev_toit_beton'] = $this->ev_toit_beton->DefaultValue;
        $row['ev_toit_tullles'] = $this->ev_toit_tullles->DefaultValue;
        $row['ev_plancher_bois'] = $this->ev_plancher_bois->DefaultValue;
        $row['ev_plancher_beton'] = $this->ev_plancher_beton->DefaultValue;
        $row['ev_plancher_mosaique'] = $this->ev_plancher_mosaique->DefaultValue;
        $row['ev_plancher_terazo'] = $this->ev_plancher_terazo->DefaultValue;
        $row['ev_plancher_ceramique'] = $this->ev_plancher_ceramique->DefaultValue;
        $row['est_ex_fiscal'] = $this->est_ex_fiscal->DefaultValue;
        $row['est_estimation'] = $this->est_estimation->DefaultValue;
        $row['est_montant'] = $this->est_montant->DefaultValue;
        $row['id_owner'] = $this->id_owner->DefaultValue;
        $row['id_agent'] = $this->id_agent->DefaultValue;
        $row['localisation'] = $this->localisation->DefaultValue;
        $row['usage'] = $this->usage->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id_immeuble

        // descrip

        // codeimmeuble

        // daterecensement

        // st_annee_construct

        // st_propriete

        // st_en_affermage

        // st_en_location

        // st_en_usufruit

        // st_autre

        // ad_rue

        // ad_no_immeuble

        // ad_rue_adj

        // ad_zonequartier

        // ad_section

        // ev_nb_toilette

        // ev_nb_cuisine

        // ev_nb_garage

        // ev_nb_m2

        // ev_autresalle

        // ev_toit_tole

        // ev_toit_beton

        // ev_toit_tullles

        // ev_plancher_bois

        // ev_plancher_beton

        // ev_plancher_mosaique

        // ev_plancher_terazo

        // ev_plancher_ceramique

        // est_ex_fiscal

        // est_estimation

        // est_montant

        // id_owner

        // id_agent

        // localisation

        // usage

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // id_immeuble
            $this->id_immeuble->ViewValue = $this->id_immeuble->CurrentValue;
            $this->id_immeuble->ViewCustomAttributes = "";

            // descrip
            $this->descrip->ViewValue = $this->descrip->CurrentValue;
            $this->descrip->ViewCustomAttributes = "";

            // codeimmeuble
            $this->codeimmeuble->ViewValue = $this->codeimmeuble->CurrentValue;
            $this->codeimmeuble->ViewCustomAttributes = "";

            // daterecensement
            $this->daterecensement->ViewValue = $this->daterecensement->CurrentValue;
            $this->daterecensement->ViewValue = FormatDateTime($this->daterecensement->ViewValue, $this->daterecensement->formatPattern());
            $this->daterecensement->ViewCustomAttributes = "";

            // st_annee_construct
            $this->st_annee_construct->ViewValue = $this->st_annee_construct->CurrentValue;
            $this->st_annee_construct->ViewCustomAttributes = "";

            // st_propriete
            $this->st_propriete->ViewValue = $this->st_propriete->CurrentValue;
            $this->st_propriete->ViewCustomAttributes = "";

            // st_en_affermage
            $this->st_en_affermage->ViewValue = $this->st_en_affermage->CurrentValue;
            $this->st_en_affermage->ViewCustomAttributes = "";

            // st_en_location
            $this->st_en_location->ViewValue = $this->st_en_location->CurrentValue;
            $this->st_en_location->ViewCustomAttributes = "";

            // st_en_usufruit
            $this->st_en_usufruit->ViewValue = $this->st_en_usufruit->CurrentValue;
            $this->st_en_usufruit->ViewCustomAttributes = "";

            // st_autre
            $this->st_autre->ViewValue = $this->st_autre->CurrentValue;
            $this->st_autre->ViewCustomAttributes = "";

            // ad_rue
            $this->ad_rue->ViewValue = $this->ad_rue->CurrentValue;
            $this->ad_rue->ViewCustomAttributes = "";

            // ad_no_immeuble
            $this->ad_no_immeuble->ViewValue = $this->ad_no_immeuble->CurrentValue;
            $this->ad_no_immeuble->ViewCustomAttributes = "";

            // ad_rue_adj
            $this->ad_rue_adj->ViewValue = $this->ad_rue_adj->CurrentValue;
            $this->ad_rue_adj->ViewCustomAttributes = "";

            // ad_zonequartier
            $this->ad_zonequartier->ViewValue = $this->ad_zonequartier->CurrentValue;
            $this->ad_zonequartier->ViewCustomAttributes = "";

            // ad_section
            $this->ad_section->ViewValue = $this->ad_section->CurrentValue;
            $this->ad_section->ViewCustomAttributes = "";

            // ev_nb_toilette
            $this->ev_nb_toilette->ViewValue = $this->ev_nb_toilette->CurrentValue;
            $this->ev_nb_toilette->ViewValue = FormatNumber($this->ev_nb_toilette->ViewValue, $this->ev_nb_toilette->formatPattern());
            $this->ev_nb_toilette->ViewCustomAttributes = "";

            // ev_nb_cuisine
            $this->ev_nb_cuisine->ViewValue = $this->ev_nb_cuisine->CurrentValue;
            $this->ev_nb_cuisine->ViewValue = FormatNumber($this->ev_nb_cuisine->ViewValue, $this->ev_nb_cuisine->formatPattern());
            $this->ev_nb_cuisine->ViewCustomAttributes = "";

            // ev_nb_garage
            $this->ev_nb_garage->ViewValue = $this->ev_nb_garage->CurrentValue;
            $this->ev_nb_garage->ViewValue = FormatNumber($this->ev_nb_garage->ViewValue, $this->ev_nb_garage->formatPattern());
            $this->ev_nb_garage->ViewCustomAttributes = "";

            // ev_nb_m2
            $this->ev_nb_m2->ViewValue = $this->ev_nb_m2->CurrentValue;
            $this->ev_nb_m2->ViewValue = FormatNumber($this->ev_nb_m2->ViewValue, $this->ev_nb_m2->formatPattern());
            $this->ev_nb_m2->ViewCustomAttributes = "";

            // ev_autresalle
            $this->ev_autresalle->ViewValue = $this->ev_autresalle->CurrentValue;
            $this->ev_autresalle->ViewCustomAttributes = "";

            // ev_toit_tole
            $this->ev_toit_tole->ViewValue = $this->ev_toit_tole->CurrentValue;
            $this->ev_toit_tole->ViewCustomAttributes = "";

            // ev_toit_beton
            $this->ev_toit_beton->ViewValue = $this->ev_toit_beton->CurrentValue;
            $this->ev_toit_beton->ViewCustomAttributes = "";

            // ev_toit_tullles
            $this->ev_toit_tullles->ViewValue = $this->ev_toit_tullles->CurrentValue;
            $this->ev_toit_tullles->ViewCustomAttributes = "";

            // ev_plancher_bois
            $this->ev_plancher_bois->ViewValue = $this->ev_plancher_bois->CurrentValue;
            $this->ev_plancher_bois->ViewCustomAttributes = "";

            // ev_plancher_beton
            $this->ev_plancher_beton->ViewValue = $this->ev_plancher_beton->CurrentValue;
            $this->ev_plancher_beton->ViewCustomAttributes = "";

            // ev_plancher_mosaique
            $this->ev_plancher_mosaique->ViewValue = $this->ev_plancher_mosaique->CurrentValue;
            $this->ev_plancher_mosaique->ViewCustomAttributes = "";

            // ev_plancher_terazo
            $this->ev_plancher_terazo->ViewValue = $this->ev_plancher_terazo->CurrentValue;
            $this->ev_plancher_terazo->ViewCustomAttributes = "";

            // ev_plancher_ceramique
            $this->ev_plancher_ceramique->ViewValue = $this->ev_plancher_ceramique->CurrentValue;
            $this->ev_plancher_ceramique->ViewCustomAttributes = "";

            // est_ex_fiscal
            $curVal = strval($this->est_ex_fiscal->CurrentValue);
            if ($curVal != "") {
                $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->lookupCacheOption($curVal);
                if ($this->est_ex_fiscal->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_ex_fiscal`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->est_ex_fiscal->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->est_ex_fiscal->Lookup->renderViewRow($rswrk[0]);
                        $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->displayValue($arwrk);
                    } else {
                        $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->CurrentValue;
                    }
                }
            } else {
                $this->est_ex_fiscal->ViewValue = null;
            }
            $this->est_ex_fiscal->ViewCustomAttributes = "";

            // est_estimation
            $this->est_estimation->ViewValue = $this->est_estimation->CurrentValue;
            $this->est_estimation->ViewValue = FormatNumber($this->est_estimation->ViewValue, $this->est_estimation->formatPattern());
            $this->est_estimation->ViewCustomAttributes = "";

            // est_montant
            $this->est_montant->ViewValue = $this->est_montant->CurrentValue;
            $this->est_montant->ViewValue = FormatNumber($this->est_montant->ViewValue, $this->est_montant->formatPattern());
            $this->est_montant->ViewCustomAttributes = "";

            // id_owner
            $curVal = strval($this->id_owner->CurrentValue);
            if ($curVal != "") {
                $this->id_owner->ViewValue = $this->id_owner->lookupCacheOption($curVal);
                if ($this->id_owner->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_owner`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_owner->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_owner->Lookup->renderViewRow($rswrk[0]);
                        $this->id_owner->ViewValue = $this->id_owner->displayValue($arwrk);
                    } else {
                        $this->id_owner->ViewValue = $this->id_owner->CurrentValue;
                    }
                }
            } else {
                $this->id_owner->ViewValue = null;
            }
            $this->id_owner->ViewCustomAttributes = "";

            // id_agent
            $curVal = strval($this->id_agent->CurrentValue);
            if ($curVal != "") {
                $this->id_agent->ViewValue = $this->id_agent->lookupCacheOption($curVal);
                if ($this->id_agent->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_agent`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_agent->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_agent->Lookup->renderViewRow($rswrk[0]);
                        $this->id_agent->ViewValue = $this->id_agent->displayValue($arwrk);
                    } else {
                        $this->id_agent->ViewValue = $this->id_agent->CurrentValue;
                    }
                }
            } else {
                $this->id_agent->ViewValue = null;
            }
            $this->id_agent->ViewCustomAttributes = "";

            // localisation
            $this->localisation->ViewValue = $this->localisation->CurrentValue;
            $this->localisation->ViewCustomAttributes = "";

            // usage
            if (strval($this->usage->CurrentValue) != "") {
                $this->usage->ViewValue = $this->usage->optionCaption($this->usage->CurrentValue);
            } else {
                $this->usage->ViewValue = null;
            }
            $this->usage->ViewCustomAttributes = "";

            // id_immeuble
            $this->id_immeuble->LinkCustomAttributes = "";
            $this->id_immeuble->HrefValue = "";
            $this->id_immeuble->TooltipValue = "";

            // descrip
            $this->descrip->LinkCustomAttributes = "";
            $this->descrip->HrefValue = "";
            $this->descrip->TooltipValue = "";

            // codeimmeuble
            $this->codeimmeuble->LinkCustomAttributes = "";
            $this->codeimmeuble->HrefValue = "";
            $this->codeimmeuble->TooltipValue = "";

            // daterecensement
            $this->daterecensement->LinkCustomAttributes = "";
            $this->daterecensement->HrefValue = "";
            $this->daterecensement->TooltipValue = "";

            // st_annee_construct
            $this->st_annee_construct->LinkCustomAttributes = "";
            $this->st_annee_construct->HrefValue = "";
            $this->st_annee_construct->TooltipValue = "";

            // st_propriete
            $this->st_propriete->LinkCustomAttributes = "";
            $this->st_propriete->HrefValue = "";
            $this->st_propriete->TooltipValue = "";

            // st_en_affermage
            $this->st_en_affermage->LinkCustomAttributes = "";
            $this->st_en_affermage->HrefValue = "";
            $this->st_en_affermage->TooltipValue = "";

            // st_en_location
            $this->st_en_location->LinkCustomAttributes = "";
            $this->st_en_location->HrefValue = "";
            $this->st_en_location->TooltipValue = "";

            // st_en_usufruit
            $this->st_en_usufruit->LinkCustomAttributes = "";
            $this->st_en_usufruit->HrefValue = "";
            $this->st_en_usufruit->TooltipValue = "";

            // st_autre
            $this->st_autre->LinkCustomAttributes = "";
            $this->st_autre->HrefValue = "";
            $this->st_autre->TooltipValue = "";

            // ad_rue
            $this->ad_rue->LinkCustomAttributes = "";
            $this->ad_rue->HrefValue = "";
            $this->ad_rue->TooltipValue = "";

            // ad_no_immeuble
            $this->ad_no_immeuble->LinkCustomAttributes = "";
            $this->ad_no_immeuble->HrefValue = "";
            $this->ad_no_immeuble->TooltipValue = "";

            // ad_rue_adj
            $this->ad_rue_adj->LinkCustomAttributes = "";
            $this->ad_rue_adj->HrefValue = "";
            $this->ad_rue_adj->TooltipValue = "";

            // ad_zonequartier
            $this->ad_zonequartier->LinkCustomAttributes = "";
            $this->ad_zonequartier->HrefValue = "";
            $this->ad_zonequartier->TooltipValue = "";

            // ad_section
            $this->ad_section->LinkCustomAttributes = "";
            $this->ad_section->HrefValue = "";
            $this->ad_section->TooltipValue = "";

            // ev_nb_toilette
            $this->ev_nb_toilette->LinkCustomAttributes = "";
            $this->ev_nb_toilette->HrefValue = "";
            $this->ev_nb_toilette->TooltipValue = "";

            // ev_nb_cuisine
            $this->ev_nb_cuisine->LinkCustomAttributes = "";
            $this->ev_nb_cuisine->HrefValue = "";
            $this->ev_nb_cuisine->TooltipValue = "";

            // ev_nb_garage
            $this->ev_nb_garage->LinkCustomAttributes = "";
            $this->ev_nb_garage->HrefValue = "";
            $this->ev_nb_garage->TooltipValue = "";

            // ev_nb_m2
            $this->ev_nb_m2->LinkCustomAttributes = "";
            $this->ev_nb_m2->HrefValue = "";
            $this->ev_nb_m2->TooltipValue = "";

            // ev_autresalle
            $this->ev_autresalle->LinkCustomAttributes = "";
            $this->ev_autresalle->HrefValue = "";
            $this->ev_autresalle->TooltipValue = "";

            // ev_toit_tole
            $this->ev_toit_tole->LinkCustomAttributes = "";
            $this->ev_toit_tole->HrefValue = "";
            $this->ev_toit_tole->TooltipValue = "";

            // ev_toit_beton
            $this->ev_toit_beton->LinkCustomAttributes = "";
            $this->ev_toit_beton->HrefValue = "";
            $this->ev_toit_beton->TooltipValue = "";

            // ev_toit_tullles
            $this->ev_toit_tullles->LinkCustomAttributes = "";
            $this->ev_toit_tullles->HrefValue = "";
            $this->ev_toit_tullles->TooltipValue = "";

            // ev_plancher_bois
            $this->ev_plancher_bois->LinkCustomAttributes = "";
            $this->ev_plancher_bois->HrefValue = "";
            $this->ev_plancher_bois->TooltipValue = "";

            // ev_plancher_beton
            $this->ev_plancher_beton->LinkCustomAttributes = "";
            $this->ev_plancher_beton->HrefValue = "";
            $this->ev_plancher_beton->TooltipValue = "";

            // ev_plancher_mosaique
            $this->ev_plancher_mosaique->LinkCustomAttributes = "";
            $this->ev_plancher_mosaique->HrefValue = "";
            $this->ev_plancher_mosaique->TooltipValue = "";

            // ev_plancher_terazo
            $this->ev_plancher_terazo->LinkCustomAttributes = "";
            $this->ev_plancher_terazo->HrefValue = "";
            $this->ev_plancher_terazo->TooltipValue = "";

            // ev_plancher_ceramique
            $this->ev_plancher_ceramique->LinkCustomAttributes = "";
            $this->ev_plancher_ceramique->HrefValue = "";
            $this->ev_plancher_ceramique->TooltipValue = "";

            // est_ex_fiscal
            $this->est_ex_fiscal->LinkCustomAttributes = "";
            $this->est_ex_fiscal->HrefValue = "";
            $this->est_ex_fiscal->TooltipValue = "";

            // est_estimation
            $this->est_estimation->LinkCustomAttributes = "";
            $this->est_estimation->HrefValue = "";
            $this->est_estimation->TooltipValue = "";

            // est_montant
            $this->est_montant->LinkCustomAttributes = "";
            $this->est_montant->HrefValue = "";
            $this->est_montant->TooltipValue = "";

            // id_owner
            $this->id_owner->LinkCustomAttributes = "";
            $this->id_owner->HrefValue = "";
            $this->id_owner->TooltipValue = "";

            // id_agent
            $this->id_agent->LinkCustomAttributes = "";
            $this->id_agent->HrefValue = "";
            $this->id_agent->TooltipValue = "";

            // localisation
            $this->localisation->LinkCustomAttributes = "";
            $this->localisation->HrefValue = "";
            $this->localisation->TooltipValue = "";

            // usage
            $this->usage->LinkCustomAttributes = "";
            $this->usage->HrefValue = "";
            $this->usage->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        $pageUrl = $this->pageUrl(false);
        $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" form=\"fimmeubleview\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" form=\"fimmeubleview\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdfText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdfText")) . "\" form=\"fimmeubleview\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdfText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdfText")) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" form="fimmeubleview" data-ew-action="email" data-hdr="' . $Language->phrase("ExportToEmailText") . '" data-key="' . HtmlEncode(ArrayToJsonAttribute($this->RecKey)) . '" data-sel="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("ExportToPrintText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPrintText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = false;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = true;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide options for export
        if ($this->isExport()) {
            $this->ExportOptions->hideAllOptions();
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($return = false)
    {
        global $Language;
        $utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");

        // Load recordset
        if (!$this->Recordset) {
            $this->Recordset = $this->loadRecordset();
        }
        $rs = &$this->Recordset;
        if ($rs) {
            $this->TotalRecords = $rs->recordCount();
        }
        $this->StartRecord = 1;
        $this->setupStartRecord(); // Set up start record position

        // Set the last record to display
        if ($this->DisplayRecords <= 0) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
        }
        $this->ExportDoc = GetExportDocument($this, "v");
        $doc = &$this->ExportDoc;
        if (!$doc) {
            $this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
        }
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $this->ExportDoc->ExportCustom = !$this->pageExporting();
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "view");

        // Export detail records (paiement)
        if (Config("EXPORT_DETAIL_RECORDS") && in_array("paiement", explode(",", $this->getCurrentDetailTable()))) {
            $paiement = new PaiementList();
            $rsdetail = $paiement->loadRs($paiement->getDetailFilterFromSession()); // Load detail records
            if ($rsdetail) {
                $exportStyle = $doc->Style;
                $doc->setStyle("h"); // Change to horizontal
                if (!$this->isExport("csv") || Config("EXPORT_DETAIL_RECORDS_FOR_CSV")) {
                    $doc->exportEmptyRow();
                    $detailcnt = $rsdetail->rowCount();
                    $oldtbl = $doc->Table;
                    $doc->Table = $paiement;
                    $paiement->exportDocument($doc, new Recordset($rsdetail), 1, $detailcnt);
                    $doc->Table = $oldtbl;
                }
                $doc->setStyle($exportStyle); // Restore
            }
        }
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Close recordset
        $rs->close();

        // Call Page Exported server event
        $this->pageExported();

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Clean output buffer (without destroying output buffer)
        $buffer = ob_get_contents(); // Save the output buffer
        if (!Config("DEBUG") && $buffer) {
            ob_clean();
        }

        // Write debug message if enabled
        if (Config("DEBUG") && !$this->isExport("pdf")) {
            echo GetDebugMessage();
        }

        // Output data
        if ($this->isExport("email")) {
            // Export-to-email disabled
        } else {
            $doc->export();
            if ($return) {
                RemoveHeader("Content-Type"); // Remove header
                RemoveHeader("Content-Disposition");
                $content = ob_get_contents();
                if ($content) {
                    ob_clean();
                }
                if ($buffer) {
                    echo $buffer; // Resume the output buffer
                }
                return $content;
            }
        }
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->id_agent->CurrentValue);
        }
        return true;
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("paiement", $detailTblVar)) {
                $detailPageObj = Container("PaiementGrid");
                if ($detailPageObj->DetailView) {
                    $detailPageObj->CurrentMode = "view";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->id_immeuble->IsDetailKey = true;
                    $detailPageObj->id_immeuble->CurrentValue = $this->id_immeuble->CurrentValue;
                    $detailPageObj->id_immeuble->setSessionValue($detailPageObj->id_immeuble->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ImmeubleList"), "", $this->TableVar, true);
        $pageId = "view";
        $Breadcrumb->add("view", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_est_ex_fiscal":
                    break;
                case "x_id_owner":
                    break;
                case "x_id_agent":
                    break;
                case "x_usage":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $ar[strval($row["lf"])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        if ($this->isPageRequest()) { // Validate request
            $startRec = Get(Config("TABLE_START_REC"));
            if ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
                $this->StartRecord = $startRec;
                $this->setStartRecordNumber($this->StartRecord);
            }
        }
        $this->StartRecord = $this->getStartRecordNumber();

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
            $this->setStartRecordNumber($this->StartRecord);
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Exporting event
    // $this->ExportDoc = export document object
    public function pageExporting()
    {
        //$this->ExportDoc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $this->ExportDoc = export document object
    public function rowExport($rs)
    {
        //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $this->ExportDoc = export document object
    public function pageExported()
    {
        //$this->ExportDoc->Text .= "my footer"; // Export footer
        //Log($this->ExportDoc->Text);
    }
}
