<?php

namespace PHPMaker2022\cfpb;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class ImmeubleList extends Immeuble
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'immeuble';

    // Page object name
    public $PageObjName = "ImmeubleList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fimmeublelist";
    public $FormActionName = "k_action";
    public $FormBlankRowName = "k_blankrow";
    public $FormKeyCountName = "key_count";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $CopyUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = $route->getArguments();
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        $url = rtrim(UrlFor($route->getName(), $args), "/") . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return $this->TableVar == $CurrentForm->getValue("t");
            }
            if (Get("t") !== null) {
                return $this->TableVar == Get("t");
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (immeuble)
        if (!isset($GLOBALS["immeuble"]) || get_class($GLOBALS["immeuble"]) == PROJECT_NAMESPACE . "immeuble") {
            $GLOBALS["immeuble"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "ImmeubleAdd?" . Config("TABLE_SHOW_DETAIL") . "=";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiDeleteUrl = "ImmeubleDelete";
        $this->MultiUpdateUrl = "ImmeubleUpdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'immeuble');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(["Tag" => "td", "TableVar" => $this->TableVar]);

        // Export options
        $this->ExportOptions = new ListOptions(["TagClassName" => "ew-export-option"]);

        // Import options
        $this->ImportOptions = new ListOptions(["TagClassName" => "ew-import-option"]);

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions([
            "TagClassName" => "ew-add-edit-option",
            "UseDropDownButton" => false,
            "DropDownButtonPhrase" => $Language->phrase("ButtonAddEdit"),
            "UseButtonGroup" => true
        ]);

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(["TagClassName" => "ew-detail-option"]);
        // Actions
        $this->OtherOptions["action"] = new ListOptions(["TagClassName" => "ew-action-option"]);

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions([
            "TableVar" => $this->TableVar,
            "TagClassName" => "ew-column-option",
            "ButtonGroupClass" => "ew-column-dropdown",
            "UseDropDownButton" => true,
            "DropDownButtonPhrase" => $Language->phrase("Columns"),
            "DropDownAutoClose" => "outside",
            "UseButtonGroup" => false
        ]);

        // Filter options
        $this->FilterOptions = new ListOptions(["TagClassName" => "ew-filter-option"]);

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $tbl = Container("immeuble");
                $doc = new $class($tbl);
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id_immeuble'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id_immeuble->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->id_agent->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $EditRowCount;
    public $StartRowCount = 1;
    public $RowCount = 0;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $OldRecordset;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param("layout", true));

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } elseif (IsPost()) {
            if (Post("exporttype") !== null) {
                $this->Export = Post("exporttype");
            }
            $custom = Post("custom", "");
        } elseif (Get("cmd") == "json") {
            $this->Export = Get("cmd");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportFileName = $this->TableVar; // Get export file, used in header

        // Get custom export parameters
        if ($this->isExport() && $custom != "") {
            $this->CustomExport = $this->Export;
            $this->Export = "print";
        }
        $CustomExportType = $this->CustomExport;
        $ExportType = $this->Export; // Get export parameter, used in header
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->id_immeuble->setVisibility();
        $this->descrip->setVisibility();
        $this->codeimmeuble->setVisibility();
        $this->daterecensement->setVisibility();
        $this->st_annee_construct->Visible = false;
        $this->st_propriete->Visible = false;
        $this->st_en_affermage->Visible = false;
        $this->st_en_location->Visible = false;
        $this->st_en_usufruit->Visible = false;
        $this->st_autre->Visible = false;
        $this->ad_rue->Visible = false;
        $this->ad_no_immeuble->Visible = false;
        $this->ad_rue_adj->Visible = false;
        $this->ad_zonequartier->Visible = false;
        $this->ad_section->Visible = false;
        $this->ev_nb_toilette->Visible = false;
        $this->ev_nb_cuisine->Visible = false;
        $this->ev_nb_garage->Visible = false;
        $this->ev_nb_m2->Visible = false;
        $this->ev_autresalle->Visible = false;
        $this->ev_toit_tole->Visible = false;
        $this->ev_toit_beton->Visible = false;
        $this->ev_toit_tullles->Visible = false;
        $this->ev_plancher_bois->Visible = false;
        $this->ev_plancher_beton->Visible = false;
        $this->ev_plancher_mosaique->Visible = false;
        $this->ev_plancher_terazo->Visible = false;
        $this->ev_plancher_ceramique->Visible = false;
        $this->est_ex_fiscal->Visible = false;
        $this->est_estimation->Visible = false;
        $this->est_montant->Visible = false;
        $this->id_owner->setVisibility();
        $this->id_agent->setVisibility();
        $this->localisation->Visible = false;
        $this->usage->Visible = false;
        $this->hideFieldsForAddEdit();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up custom action (compatible with old version)
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions->add($name, $action);
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->est_ex_fiscal);
        $this->setupLookupOptions($this->id_owner);
        $this->setupLookupOptions($this->id_agent);
        $this->setupLookupOptions($this->usage);

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $filter = "";

        // Get command
        $this->Command = strtolower(Get("cmd", ""));
        if ($this->isPageRequest()) {
            // Process list action first
            if ($this->processListAction()) { // Ajax request
                $this->terminate();
                return;
            }

            // Set up records per page
            $this->setupDisplayRecords();

            // Handle reset command
            $this->resetCmd();

            // Set up Breadcrumb
            if (!$this->isExport()) {
                $this->setupBreadcrumb();
            }

            // Hide list options
            if ($this->isExport()) {
                $this->ListOptions->hideAllOptions(["sequence"]);
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            } elseif ($this->isGridAdd() || $this->isGridEdit()) {
                $this->ListOptions->hideAllOptions();
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            }

            // Hide options
            if ($this->isExport() || $this->CurrentAction) {
                $this->ExportOptions->hideAllOptions();
                $this->FilterOptions->hideAllOptions();
                $this->ImportOptions->hideAllOptions();
            }

            // Hide other options
            if ($this->isExport()) {
                $this->OtherOptions->hideAllOptions();
            }

            // Get default search criteria
            AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));

            // Get basic search values
            $this->loadBasicSearchValues();

            // Process filter list
            if ($this->processFilterList()) {
                $this->terminate();
                return;
            }

            // Restore search parms from Session if not searching / reset / export
            if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
                $this->restoreSearchParms();
            }

            // Call Recordset SearchValidated event
            $this->recordsetSearchValidated();

            // Set up sorting order
            $this->setupSortOrder();

            // Get basic search criteria
            if (!$this->hasInvalidFields()) {
                $srchBasic = $this->basicSearchWhere();
            }
        }

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms()) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere();
            }
        }

        // Build search criteria
        AddFilter($this->SearchWhere, $srchAdvanced);
        AddFilter($this->SearchWhere, $srchBasic);

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json") {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        $filter = "";
        if (!$Security->canList()) {
            $filter = "(0=1)"; // Filter all records
        }
        AddFilter($filter, $this->DbDetailFilter);
        AddFilter($filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $filter;
        } else {
            $this->setSessionWhere($filter);
            $this->CurrentFilter = "";
        }

        // Export data only
        if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
            $this->exportData();
            $this->terminate();
            return;
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if (!$this->CurrentAction && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Allow) {
                if ($listaction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listaction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Normal return
        if (IsApi()) {
            $rows = $this->getRecordsFromRecordset($this->Recordset);
            $this->Recordset->close();
            WriteJson(["success" => true, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
            $this->terminate(true);
            return;
        }

        // Set up pager
        $this->Pager = new PrevNextPager($this->TableVar, $this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server" && isset($UserProfile)) {
            $savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fimmeublesrch");
        }
        $filterList = Concat($filterList, $this->id_immeuble->AdvancedSearch->toJson(), ","); // Field id_immeuble
        $filterList = Concat($filterList, $this->descrip->AdvancedSearch->toJson(), ","); // Field descrip
        $filterList = Concat($filterList, $this->codeimmeuble->AdvancedSearch->toJson(), ","); // Field codeimmeuble
        $filterList = Concat($filterList, $this->daterecensement->AdvancedSearch->toJson(), ","); // Field daterecensement
        $filterList = Concat($filterList, $this->st_annee_construct->AdvancedSearch->toJson(), ","); // Field st_annee_construct
        $filterList = Concat($filterList, $this->st_propriete->AdvancedSearch->toJson(), ","); // Field st_propriete
        $filterList = Concat($filterList, $this->st_en_affermage->AdvancedSearch->toJson(), ","); // Field st_en_affermage
        $filterList = Concat($filterList, $this->st_en_location->AdvancedSearch->toJson(), ","); // Field st_en_location
        $filterList = Concat($filterList, $this->st_en_usufruit->AdvancedSearch->toJson(), ","); // Field st_en_usufruit
        $filterList = Concat($filterList, $this->st_autre->AdvancedSearch->toJson(), ","); // Field st_autre
        $filterList = Concat($filterList, $this->ad_rue->AdvancedSearch->toJson(), ","); // Field ad_rue
        $filterList = Concat($filterList, $this->ad_no_immeuble->AdvancedSearch->toJson(), ","); // Field ad_no_immeuble
        $filterList = Concat($filterList, $this->ad_rue_adj->AdvancedSearch->toJson(), ","); // Field ad_rue_adj
        $filterList = Concat($filterList, $this->ad_zonequartier->AdvancedSearch->toJson(), ","); // Field ad_zonequartier
        $filterList = Concat($filterList, $this->ad_section->AdvancedSearch->toJson(), ","); // Field ad_section
        $filterList = Concat($filterList, $this->ev_nb_toilette->AdvancedSearch->toJson(), ","); // Field ev_nb_toilette
        $filterList = Concat($filterList, $this->ev_nb_cuisine->AdvancedSearch->toJson(), ","); // Field ev_nb_cuisine
        $filterList = Concat($filterList, $this->ev_nb_garage->AdvancedSearch->toJson(), ","); // Field ev_nb_garage
        $filterList = Concat($filterList, $this->ev_nb_m2->AdvancedSearch->toJson(), ","); // Field ev_nb_m2
        $filterList = Concat($filterList, $this->ev_autresalle->AdvancedSearch->toJson(), ","); // Field ev_autresalle
        $filterList = Concat($filterList, $this->ev_toit_tole->AdvancedSearch->toJson(), ","); // Field ev_toit_tole
        $filterList = Concat($filterList, $this->ev_toit_beton->AdvancedSearch->toJson(), ","); // Field ev_toit_beton
        $filterList = Concat($filterList, $this->ev_toit_tullles->AdvancedSearch->toJson(), ","); // Field ev_toit_tullles
        $filterList = Concat($filterList, $this->ev_plancher_bois->AdvancedSearch->toJson(), ","); // Field ev_plancher_bois
        $filterList = Concat($filterList, $this->ev_plancher_beton->AdvancedSearch->toJson(), ","); // Field ev_plancher_beton
        $filterList = Concat($filterList, $this->ev_plancher_mosaique->AdvancedSearch->toJson(), ","); // Field ev_plancher_mosaique
        $filterList = Concat($filterList, $this->ev_plancher_terazo->AdvancedSearch->toJson(), ","); // Field ev_plancher_terazo
        $filterList = Concat($filterList, $this->ev_plancher_ceramique->AdvancedSearch->toJson(), ","); // Field ev_plancher_ceramique
        $filterList = Concat($filterList, $this->est_ex_fiscal->AdvancedSearch->toJson(), ","); // Field est_ex_fiscal
        $filterList = Concat($filterList, $this->est_estimation->AdvancedSearch->toJson(), ","); // Field est_estimation
        $filterList = Concat($filterList, $this->est_montant->AdvancedSearch->toJson(), ","); // Field est_montant
        $filterList = Concat($filterList, $this->id_owner->AdvancedSearch->toJson(), ","); // Field id_owner
        $filterList = Concat($filterList, $this->id_agent->AdvancedSearch->toJson(), ","); // Field id_agent
        $filterList = Concat($filterList, $this->localisation->AdvancedSearch->toJson(), ","); // Field localisation
        $filterList = Concat($filterList, $this->usage->AdvancedSearch->toJson(), ","); // Field usage
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fimmeublesrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id_immeuble
        $this->id_immeuble->AdvancedSearch->SearchValue = @$filter["x_id_immeuble"];
        $this->id_immeuble->AdvancedSearch->SearchOperator = @$filter["z_id_immeuble"];
        $this->id_immeuble->AdvancedSearch->SearchCondition = @$filter["v_id_immeuble"];
        $this->id_immeuble->AdvancedSearch->SearchValue2 = @$filter["y_id_immeuble"];
        $this->id_immeuble->AdvancedSearch->SearchOperator2 = @$filter["w_id_immeuble"];
        $this->id_immeuble->AdvancedSearch->save();

        // Field descrip
        $this->descrip->AdvancedSearch->SearchValue = @$filter["x_descrip"];
        $this->descrip->AdvancedSearch->SearchOperator = @$filter["z_descrip"];
        $this->descrip->AdvancedSearch->SearchCondition = @$filter["v_descrip"];
        $this->descrip->AdvancedSearch->SearchValue2 = @$filter["y_descrip"];
        $this->descrip->AdvancedSearch->SearchOperator2 = @$filter["w_descrip"];
        $this->descrip->AdvancedSearch->save();

        // Field codeimmeuble
        $this->codeimmeuble->AdvancedSearch->SearchValue = @$filter["x_codeimmeuble"];
        $this->codeimmeuble->AdvancedSearch->SearchOperator = @$filter["z_codeimmeuble"];
        $this->codeimmeuble->AdvancedSearch->SearchCondition = @$filter["v_codeimmeuble"];
        $this->codeimmeuble->AdvancedSearch->SearchValue2 = @$filter["y_codeimmeuble"];
        $this->codeimmeuble->AdvancedSearch->SearchOperator2 = @$filter["w_codeimmeuble"];
        $this->codeimmeuble->AdvancedSearch->save();

        // Field daterecensement
        $this->daterecensement->AdvancedSearch->SearchValue = @$filter["x_daterecensement"];
        $this->daterecensement->AdvancedSearch->SearchOperator = @$filter["z_daterecensement"];
        $this->daterecensement->AdvancedSearch->SearchCondition = @$filter["v_daterecensement"];
        $this->daterecensement->AdvancedSearch->SearchValue2 = @$filter["y_daterecensement"];
        $this->daterecensement->AdvancedSearch->SearchOperator2 = @$filter["w_daterecensement"];
        $this->daterecensement->AdvancedSearch->save();

        // Field st_annee_construct
        $this->st_annee_construct->AdvancedSearch->SearchValue = @$filter["x_st_annee_construct"];
        $this->st_annee_construct->AdvancedSearch->SearchOperator = @$filter["z_st_annee_construct"];
        $this->st_annee_construct->AdvancedSearch->SearchCondition = @$filter["v_st_annee_construct"];
        $this->st_annee_construct->AdvancedSearch->SearchValue2 = @$filter["y_st_annee_construct"];
        $this->st_annee_construct->AdvancedSearch->SearchOperator2 = @$filter["w_st_annee_construct"];
        $this->st_annee_construct->AdvancedSearch->save();

        // Field st_propriete
        $this->st_propriete->AdvancedSearch->SearchValue = @$filter["x_st_propriete"];
        $this->st_propriete->AdvancedSearch->SearchOperator = @$filter["z_st_propriete"];
        $this->st_propriete->AdvancedSearch->SearchCondition = @$filter["v_st_propriete"];
        $this->st_propriete->AdvancedSearch->SearchValue2 = @$filter["y_st_propriete"];
        $this->st_propriete->AdvancedSearch->SearchOperator2 = @$filter["w_st_propriete"];
        $this->st_propriete->AdvancedSearch->save();

        // Field st_en_affermage
        $this->st_en_affermage->AdvancedSearch->SearchValue = @$filter["x_st_en_affermage"];
        $this->st_en_affermage->AdvancedSearch->SearchOperator = @$filter["z_st_en_affermage"];
        $this->st_en_affermage->AdvancedSearch->SearchCondition = @$filter["v_st_en_affermage"];
        $this->st_en_affermage->AdvancedSearch->SearchValue2 = @$filter["y_st_en_affermage"];
        $this->st_en_affermage->AdvancedSearch->SearchOperator2 = @$filter["w_st_en_affermage"];
        $this->st_en_affermage->AdvancedSearch->save();

        // Field st_en_location
        $this->st_en_location->AdvancedSearch->SearchValue = @$filter["x_st_en_location"];
        $this->st_en_location->AdvancedSearch->SearchOperator = @$filter["z_st_en_location"];
        $this->st_en_location->AdvancedSearch->SearchCondition = @$filter["v_st_en_location"];
        $this->st_en_location->AdvancedSearch->SearchValue2 = @$filter["y_st_en_location"];
        $this->st_en_location->AdvancedSearch->SearchOperator2 = @$filter["w_st_en_location"];
        $this->st_en_location->AdvancedSearch->save();

        // Field st_en_usufruit
        $this->st_en_usufruit->AdvancedSearch->SearchValue = @$filter["x_st_en_usufruit"];
        $this->st_en_usufruit->AdvancedSearch->SearchOperator = @$filter["z_st_en_usufruit"];
        $this->st_en_usufruit->AdvancedSearch->SearchCondition = @$filter["v_st_en_usufruit"];
        $this->st_en_usufruit->AdvancedSearch->SearchValue2 = @$filter["y_st_en_usufruit"];
        $this->st_en_usufruit->AdvancedSearch->SearchOperator2 = @$filter["w_st_en_usufruit"];
        $this->st_en_usufruit->AdvancedSearch->save();

        // Field st_autre
        $this->st_autre->AdvancedSearch->SearchValue = @$filter["x_st_autre"];
        $this->st_autre->AdvancedSearch->SearchOperator = @$filter["z_st_autre"];
        $this->st_autre->AdvancedSearch->SearchCondition = @$filter["v_st_autre"];
        $this->st_autre->AdvancedSearch->SearchValue2 = @$filter["y_st_autre"];
        $this->st_autre->AdvancedSearch->SearchOperator2 = @$filter["w_st_autre"];
        $this->st_autre->AdvancedSearch->save();

        // Field ad_rue
        $this->ad_rue->AdvancedSearch->SearchValue = @$filter["x_ad_rue"];
        $this->ad_rue->AdvancedSearch->SearchOperator = @$filter["z_ad_rue"];
        $this->ad_rue->AdvancedSearch->SearchCondition = @$filter["v_ad_rue"];
        $this->ad_rue->AdvancedSearch->SearchValue2 = @$filter["y_ad_rue"];
        $this->ad_rue->AdvancedSearch->SearchOperator2 = @$filter["w_ad_rue"];
        $this->ad_rue->AdvancedSearch->save();

        // Field ad_no_immeuble
        $this->ad_no_immeuble->AdvancedSearch->SearchValue = @$filter["x_ad_no_immeuble"];
        $this->ad_no_immeuble->AdvancedSearch->SearchOperator = @$filter["z_ad_no_immeuble"];
        $this->ad_no_immeuble->AdvancedSearch->SearchCondition = @$filter["v_ad_no_immeuble"];
        $this->ad_no_immeuble->AdvancedSearch->SearchValue2 = @$filter["y_ad_no_immeuble"];
        $this->ad_no_immeuble->AdvancedSearch->SearchOperator2 = @$filter["w_ad_no_immeuble"];
        $this->ad_no_immeuble->AdvancedSearch->save();

        // Field ad_rue_adj
        $this->ad_rue_adj->AdvancedSearch->SearchValue = @$filter["x_ad_rue_adj"];
        $this->ad_rue_adj->AdvancedSearch->SearchOperator = @$filter["z_ad_rue_adj"];
        $this->ad_rue_adj->AdvancedSearch->SearchCondition = @$filter["v_ad_rue_adj"];
        $this->ad_rue_adj->AdvancedSearch->SearchValue2 = @$filter["y_ad_rue_adj"];
        $this->ad_rue_adj->AdvancedSearch->SearchOperator2 = @$filter["w_ad_rue_adj"];
        $this->ad_rue_adj->AdvancedSearch->save();

        // Field ad_zonequartier
        $this->ad_zonequartier->AdvancedSearch->SearchValue = @$filter["x_ad_zonequartier"];
        $this->ad_zonequartier->AdvancedSearch->SearchOperator = @$filter["z_ad_zonequartier"];
        $this->ad_zonequartier->AdvancedSearch->SearchCondition = @$filter["v_ad_zonequartier"];
        $this->ad_zonequartier->AdvancedSearch->SearchValue2 = @$filter["y_ad_zonequartier"];
        $this->ad_zonequartier->AdvancedSearch->SearchOperator2 = @$filter["w_ad_zonequartier"];
        $this->ad_zonequartier->AdvancedSearch->save();

        // Field ad_section
        $this->ad_section->AdvancedSearch->SearchValue = @$filter["x_ad_section"];
        $this->ad_section->AdvancedSearch->SearchOperator = @$filter["z_ad_section"];
        $this->ad_section->AdvancedSearch->SearchCondition = @$filter["v_ad_section"];
        $this->ad_section->AdvancedSearch->SearchValue2 = @$filter["y_ad_section"];
        $this->ad_section->AdvancedSearch->SearchOperator2 = @$filter["w_ad_section"];
        $this->ad_section->AdvancedSearch->save();

        // Field ev_nb_toilette
        $this->ev_nb_toilette->AdvancedSearch->SearchValue = @$filter["x_ev_nb_toilette"];
        $this->ev_nb_toilette->AdvancedSearch->SearchOperator = @$filter["z_ev_nb_toilette"];
        $this->ev_nb_toilette->AdvancedSearch->SearchCondition = @$filter["v_ev_nb_toilette"];
        $this->ev_nb_toilette->AdvancedSearch->SearchValue2 = @$filter["y_ev_nb_toilette"];
        $this->ev_nb_toilette->AdvancedSearch->SearchOperator2 = @$filter["w_ev_nb_toilette"];
        $this->ev_nb_toilette->AdvancedSearch->save();

        // Field ev_nb_cuisine
        $this->ev_nb_cuisine->AdvancedSearch->SearchValue = @$filter["x_ev_nb_cuisine"];
        $this->ev_nb_cuisine->AdvancedSearch->SearchOperator = @$filter["z_ev_nb_cuisine"];
        $this->ev_nb_cuisine->AdvancedSearch->SearchCondition = @$filter["v_ev_nb_cuisine"];
        $this->ev_nb_cuisine->AdvancedSearch->SearchValue2 = @$filter["y_ev_nb_cuisine"];
        $this->ev_nb_cuisine->AdvancedSearch->SearchOperator2 = @$filter["w_ev_nb_cuisine"];
        $this->ev_nb_cuisine->AdvancedSearch->save();

        // Field ev_nb_garage
        $this->ev_nb_garage->AdvancedSearch->SearchValue = @$filter["x_ev_nb_garage"];
        $this->ev_nb_garage->AdvancedSearch->SearchOperator = @$filter["z_ev_nb_garage"];
        $this->ev_nb_garage->AdvancedSearch->SearchCondition = @$filter["v_ev_nb_garage"];
        $this->ev_nb_garage->AdvancedSearch->SearchValue2 = @$filter["y_ev_nb_garage"];
        $this->ev_nb_garage->AdvancedSearch->SearchOperator2 = @$filter["w_ev_nb_garage"];
        $this->ev_nb_garage->AdvancedSearch->save();

        // Field ev_nb_m2
        $this->ev_nb_m2->AdvancedSearch->SearchValue = @$filter["x_ev_nb_m2"];
        $this->ev_nb_m2->AdvancedSearch->SearchOperator = @$filter["z_ev_nb_m2"];
        $this->ev_nb_m2->AdvancedSearch->SearchCondition = @$filter["v_ev_nb_m2"];
        $this->ev_nb_m2->AdvancedSearch->SearchValue2 = @$filter["y_ev_nb_m2"];
        $this->ev_nb_m2->AdvancedSearch->SearchOperator2 = @$filter["w_ev_nb_m2"];
        $this->ev_nb_m2->AdvancedSearch->save();

        // Field ev_autresalle
        $this->ev_autresalle->AdvancedSearch->SearchValue = @$filter["x_ev_autresalle"];
        $this->ev_autresalle->AdvancedSearch->SearchOperator = @$filter["z_ev_autresalle"];
        $this->ev_autresalle->AdvancedSearch->SearchCondition = @$filter["v_ev_autresalle"];
        $this->ev_autresalle->AdvancedSearch->SearchValue2 = @$filter["y_ev_autresalle"];
        $this->ev_autresalle->AdvancedSearch->SearchOperator2 = @$filter["w_ev_autresalle"];
        $this->ev_autresalle->AdvancedSearch->save();

        // Field ev_toit_tole
        $this->ev_toit_tole->AdvancedSearch->SearchValue = @$filter["x_ev_toit_tole"];
        $this->ev_toit_tole->AdvancedSearch->SearchOperator = @$filter["z_ev_toit_tole"];
        $this->ev_toit_tole->AdvancedSearch->SearchCondition = @$filter["v_ev_toit_tole"];
        $this->ev_toit_tole->AdvancedSearch->SearchValue2 = @$filter["y_ev_toit_tole"];
        $this->ev_toit_tole->AdvancedSearch->SearchOperator2 = @$filter["w_ev_toit_tole"];
        $this->ev_toit_tole->AdvancedSearch->save();

        // Field ev_toit_beton
        $this->ev_toit_beton->AdvancedSearch->SearchValue = @$filter["x_ev_toit_beton"];
        $this->ev_toit_beton->AdvancedSearch->SearchOperator = @$filter["z_ev_toit_beton"];
        $this->ev_toit_beton->AdvancedSearch->SearchCondition = @$filter["v_ev_toit_beton"];
        $this->ev_toit_beton->AdvancedSearch->SearchValue2 = @$filter["y_ev_toit_beton"];
        $this->ev_toit_beton->AdvancedSearch->SearchOperator2 = @$filter["w_ev_toit_beton"];
        $this->ev_toit_beton->AdvancedSearch->save();

        // Field ev_toit_tullles
        $this->ev_toit_tullles->AdvancedSearch->SearchValue = @$filter["x_ev_toit_tullles"];
        $this->ev_toit_tullles->AdvancedSearch->SearchOperator = @$filter["z_ev_toit_tullles"];
        $this->ev_toit_tullles->AdvancedSearch->SearchCondition = @$filter["v_ev_toit_tullles"];
        $this->ev_toit_tullles->AdvancedSearch->SearchValue2 = @$filter["y_ev_toit_tullles"];
        $this->ev_toit_tullles->AdvancedSearch->SearchOperator2 = @$filter["w_ev_toit_tullles"];
        $this->ev_toit_tullles->AdvancedSearch->save();

        // Field ev_plancher_bois
        $this->ev_plancher_bois->AdvancedSearch->SearchValue = @$filter["x_ev_plancher_bois"];
        $this->ev_plancher_bois->AdvancedSearch->SearchOperator = @$filter["z_ev_plancher_bois"];
        $this->ev_plancher_bois->AdvancedSearch->SearchCondition = @$filter["v_ev_plancher_bois"];
        $this->ev_plancher_bois->AdvancedSearch->SearchValue2 = @$filter["y_ev_plancher_bois"];
        $this->ev_plancher_bois->AdvancedSearch->SearchOperator2 = @$filter["w_ev_plancher_bois"];
        $this->ev_plancher_bois->AdvancedSearch->save();

        // Field ev_plancher_beton
        $this->ev_plancher_beton->AdvancedSearch->SearchValue = @$filter["x_ev_plancher_beton"];
        $this->ev_plancher_beton->AdvancedSearch->SearchOperator = @$filter["z_ev_plancher_beton"];
        $this->ev_plancher_beton->AdvancedSearch->SearchCondition = @$filter["v_ev_plancher_beton"];
        $this->ev_plancher_beton->AdvancedSearch->SearchValue2 = @$filter["y_ev_plancher_beton"];
        $this->ev_plancher_beton->AdvancedSearch->SearchOperator2 = @$filter["w_ev_plancher_beton"];
        $this->ev_plancher_beton->AdvancedSearch->save();

        // Field ev_plancher_mosaique
        $this->ev_plancher_mosaique->AdvancedSearch->SearchValue = @$filter["x_ev_plancher_mosaique"];
        $this->ev_plancher_mosaique->AdvancedSearch->SearchOperator = @$filter["z_ev_plancher_mosaique"];
        $this->ev_plancher_mosaique->AdvancedSearch->SearchCondition = @$filter["v_ev_plancher_mosaique"];
        $this->ev_plancher_mosaique->AdvancedSearch->SearchValue2 = @$filter["y_ev_plancher_mosaique"];
        $this->ev_plancher_mosaique->AdvancedSearch->SearchOperator2 = @$filter["w_ev_plancher_mosaique"];
        $this->ev_plancher_mosaique->AdvancedSearch->save();

        // Field ev_plancher_terazo
        $this->ev_plancher_terazo->AdvancedSearch->SearchValue = @$filter["x_ev_plancher_terazo"];
        $this->ev_plancher_terazo->AdvancedSearch->SearchOperator = @$filter["z_ev_plancher_terazo"];
        $this->ev_plancher_terazo->AdvancedSearch->SearchCondition = @$filter["v_ev_plancher_terazo"];
        $this->ev_plancher_terazo->AdvancedSearch->SearchValue2 = @$filter["y_ev_plancher_terazo"];
        $this->ev_plancher_terazo->AdvancedSearch->SearchOperator2 = @$filter["w_ev_plancher_terazo"];
        $this->ev_plancher_terazo->AdvancedSearch->save();

        // Field ev_plancher_ceramique
        $this->ev_plancher_ceramique->AdvancedSearch->SearchValue = @$filter["x_ev_plancher_ceramique"];
        $this->ev_plancher_ceramique->AdvancedSearch->SearchOperator = @$filter["z_ev_plancher_ceramique"];
        $this->ev_plancher_ceramique->AdvancedSearch->SearchCondition = @$filter["v_ev_plancher_ceramique"];
        $this->ev_plancher_ceramique->AdvancedSearch->SearchValue2 = @$filter["y_ev_plancher_ceramique"];
        $this->ev_plancher_ceramique->AdvancedSearch->SearchOperator2 = @$filter["w_ev_plancher_ceramique"];
        $this->ev_plancher_ceramique->AdvancedSearch->save();

        // Field est_ex_fiscal
        $this->est_ex_fiscal->AdvancedSearch->SearchValue = @$filter["x_est_ex_fiscal"];
        $this->est_ex_fiscal->AdvancedSearch->SearchOperator = @$filter["z_est_ex_fiscal"];
        $this->est_ex_fiscal->AdvancedSearch->SearchCondition = @$filter["v_est_ex_fiscal"];
        $this->est_ex_fiscal->AdvancedSearch->SearchValue2 = @$filter["y_est_ex_fiscal"];
        $this->est_ex_fiscal->AdvancedSearch->SearchOperator2 = @$filter["w_est_ex_fiscal"];
        $this->est_ex_fiscal->AdvancedSearch->save();

        // Field est_estimation
        $this->est_estimation->AdvancedSearch->SearchValue = @$filter["x_est_estimation"];
        $this->est_estimation->AdvancedSearch->SearchOperator = @$filter["z_est_estimation"];
        $this->est_estimation->AdvancedSearch->SearchCondition = @$filter["v_est_estimation"];
        $this->est_estimation->AdvancedSearch->SearchValue2 = @$filter["y_est_estimation"];
        $this->est_estimation->AdvancedSearch->SearchOperator2 = @$filter["w_est_estimation"];
        $this->est_estimation->AdvancedSearch->save();

        // Field est_montant
        $this->est_montant->AdvancedSearch->SearchValue = @$filter["x_est_montant"];
        $this->est_montant->AdvancedSearch->SearchOperator = @$filter["z_est_montant"];
        $this->est_montant->AdvancedSearch->SearchCondition = @$filter["v_est_montant"];
        $this->est_montant->AdvancedSearch->SearchValue2 = @$filter["y_est_montant"];
        $this->est_montant->AdvancedSearch->SearchOperator2 = @$filter["w_est_montant"];
        $this->est_montant->AdvancedSearch->save();

        // Field id_owner
        $this->id_owner->AdvancedSearch->SearchValue = @$filter["x_id_owner"];
        $this->id_owner->AdvancedSearch->SearchOperator = @$filter["z_id_owner"];
        $this->id_owner->AdvancedSearch->SearchCondition = @$filter["v_id_owner"];
        $this->id_owner->AdvancedSearch->SearchValue2 = @$filter["y_id_owner"];
        $this->id_owner->AdvancedSearch->SearchOperator2 = @$filter["w_id_owner"];
        $this->id_owner->AdvancedSearch->save();

        // Field id_agent
        $this->id_agent->AdvancedSearch->SearchValue = @$filter["x_id_agent"];
        $this->id_agent->AdvancedSearch->SearchOperator = @$filter["z_id_agent"];
        $this->id_agent->AdvancedSearch->SearchCondition = @$filter["v_id_agent"];
        $this->id_agent->AdvancedSearch->SearchValue2 = @$filter["y_id_agent"];
        $this->id_agent->AdvancedSearch->SearchOperator2 = @$filter["w_id_agent"];
        $this->id_agent->AdvancedSearch->save();

        // Field localisation
        $this->localisation->AdvancedSearch->SearchValue = @$filter["x_localisation"];
        $this->localisation->AdvancedSearch->SearchOperator = @$filter["z_localisation"];
        $this->localisation->AdvancedSearch->SearchCondition = @$filter["v_localisation"];
        $this->localisation->AdvancedSearch->SearchValue2 = @$filter["y_localisation"];
        $this->localisation->AdvancedSearch->SearchOperator2 = @$filter["w_localisation"];
        $this->localisation->AdvancedSearch->save();

        // Field usage
        $this->usage->AdvancedSearch->SearchValue = @$filter["x_usage"];
        $this->usage->AdvancedSearch->SearchOperator = @$filter["z_usage"];
        $this->usage->AdvancedSearch->SearchCondition = @$filter["v_usage"];
        $this->usage->AdvancedSearch->SearchValue2 = @$filter["y_usage"];
        $this->usage->AdvancedSearch->SearchOperator2 = @$filter["w_usage"];
        $this->usage->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Return basic search WHERE clause based on search keyword and type
    protected function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->descrip;
        $searchFlds[] = &$this->st_propriete;
        $searchFlds[] = &$this->st_en_affermage;
        $searchFlds[] = &$this->st_en_location;
        $searchFlds[] = &$this->st_en_usufruit;
        $searchFlds[] = &$this->st_autre;
        $searchFlds[] = &$this->ad_rue;
        $searchFlds[] = &$this->ad_no_immeuble;
        $searchFlds[] = &$this->ad_rue_adj;
        $searchFlds[] = &$this->ad_zonequartier;
        $searchFlds[] = &$this->ad_section;
        $searchFlds[] = &$this->ev_autresalle;
        $searchFlds[] = &$this->ev_toit_tole;
        $searchFlds[] = &$this->ev_toit_beton;
        $searchFlds[] = &$this->ev_toit_tullles;
        $searchFlds[] = &$this->ev_plancher_bois;
        $searchFlds[] = &$this->ev_plancher_beton;
        $searchFlds[] = &$this->ev_plancher_mosaique;
        $searchFlds[] = &$this->ev_plancher_terazo;
        $searchFlds[] = &$this->ev_plancher_ceramique;
        $searchFlds[] = &$this->est_ex_fiscal;
        $searchFlds[] = &$this->localisation;
        $searchFlds[] = &$this->usage;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id_immeuble); // id_immeuble
            $this->updateSort($this->descrip); // descrip
            $this->updateSort($this->codeimmeuble); // codeimmeuble
            $this->updateSort($this->daterecensement); // daterecensement
            $this->updateSort($this->id_owner); // id_owner
            $this->updateSort($this->id_agent); // id_agent
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id_immeuble->setSort("");
                $this->descrip->setSort("");
                $this->codeimmeuble->setSort("");
                $this->daterecensement->setSort("");
                $this->st_annee_construct->setSort("");
                $this->st_propriete->setSort("");
                $this->st_en_affermage->setSort("");
                $this->st_en_location->setSort("");
                $this->st_en_usufruit->setSort("");
                $this->st_autre->setSort("");
                $this->ad_rue->setSort("");
                $this->ad_no_immeuble->setSort("");
                $this->ad_rue_adj->setSort("");
                $this->ad_zonequartier->setSort("");
                $this->ad_section->setSort("");
                $this->ev_nb_toilette->setSort("");
                $this->ev_nb_cuisine->setSort("");
                $this->ev_nb_garage->setSort("");
                $this->ev_nb_m2->setSort("");
                $this->ev_autresalle->setSort("");
                $this->ev_toit_tole->setSort("");
                $this->ev_toit_beton->setSort("");
                $this->ev_toit_tullles->setSort("");
                $this->ev_plancher_bois->setSort("");
                $this->ev_plancher_beton->setSort("");
                $this->ev_plancher_mosaique->setSort("");
                $this->ev_plancher_terazo->setSort("");
                $this->ev_plancher_ceramique->setSort("");
                $this->est_ex_fiscal->setSort("");
                $this->est_estimation->setSort("");
                $this->est_montant->setSort("");
                $this->id_owner->setSort("");
                $this->id_agent->setSort("");
                $this->localisation->setSort("");
                $this->usage->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = false;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = false;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = false;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = false;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = false;

        // "detail_paiement"
        $item = &$this->ListOptions->add("detail_paiement");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'paiement');
        $item->OnLeft = false;
        $item->ShowInButtonGroup = false;

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$this->ListOptions->add("details");
            $item->CssClass = "text-nowrap";
            $item->Visible = $this->ShowMultipleDetails && $this->ListOptions->detailVisible();
            $item->OnLeft = false;
            $item->ShowInButtonGroup = false;
            $this->ListOptions->hideDetailItems();
        }

        // Set up detail pages
        $pages = new SubPages();
        $pages->add("paiement");
        $this->DetailPages = $pages;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = false;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = false;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
            // Set up list options (to be implemented by extensions)
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm, $UserProfile;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView() && $this->showOptionLink("view")) {
                $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit() && $this->showOptionLink("edit")) {
                $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd() && $this->showOptionLink("add")) {
                $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete() && $this->showOptionLink("delete")) {
                $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $Language->phrase("DeleteLink") . "</a>";
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions->Items as $listaction) {
                $action = $listaction->Action;
                $allowed = $listaction->Allow;
                if ($listaction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
                    $link = "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . HtmlTitle($caption) . "\" data-ew-action=\"submit\" form=\"fimmeublelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listaction->toDataAttrs() . ">" . $icon . $listaction->Caption . "</button></li>";
                    if ($link != "") {
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" data-ew-action=\"submit\" form=\"fimmeublelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listaction->toDataAttrs() . ">" . $icon . $listaction->Caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_paiement"
        $opt = $this->ListOptions["detail_paiement"];
        if ($Security->allowList(CurrentProjectID() . 'paiement') && $this->showOptionLink()) {
            $body = $Language->phrase("DetailLink") . $Language->TablePhrase("paiement", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("PaiementList?" . Config("TABLE_SHOW_MASTER") . "=immeuble&" . GetForeignKeyUrl("fk_id_immeuble", $this->id_immeuble->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("PaiementGrid");
            if ($detailPage->DetailView && $Security->canView() && $this->showOptionLink("view") && $Security->allowView(CurrentProjectID() . 'immeuble')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=paiement");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "paiement";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $this->showOptionLink("edit") && $Security->allowEdit(CurrentProjectID() . 'immeuble')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=paiement");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "paiement";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $this->showOptionLink("add") && $Security->allowAdd(CurrentProjectID() . 'immeuble')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=paiement");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "paiement";
            }
            if ($links != "") {
                $body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode($this->GetCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $opt = $this->ListOptions["details"];
            $opt->Body = $body;
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id_immeuble->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["detail"];
        $detailTableLink = "";
                $item = &$option->add("detailadd_paiement");
                $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=paiement");
                $detailPage = Container("PaiementGrid");
                $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
                $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
                $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'immeuble') && $Security->canAdd());
                if ($item->Visible) {
                    if ($detailTableLink != "") {
                        $detailTableLink .= ",";
                    }
                    $detailTableLink .= "paiement";
                }

        // Add multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$option->add("detailsadd");
            $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailTableLink);
            $caption = $Language->phrase("AddMasterDetailLink");
            $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
            $item->Visible = $detailTableLink != "" && $Security->canAdd();
            // Hide single master/detail items
            $ar = explode(",", $detailTableLink);
            $cnt = count($ar);
            for ($i = 0; $i < $cnt; $i++) {
                if ($item = $option["detailadd_" . $ar[$i]]) {
                    $item->Visible = false;
                }
            }
        }
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $option->add("id_immeuble", $this->createColumnOption("id_immeuble"));
            $option->add("descrip", $this->createColumnOption("descrip"));
            $option->add("codeimmeuble", $this->createColumnOption("codeimmeuble"));
            $option->add("daterecensement", $this->createColumnOption("daterecensement"));
            $option->add("id_owner", $this->createColumnOption("id_owner"));
            $option->add("id_agent", $this->createColumnOption("id_agent"));
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = false;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fimmeublesrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fimmeublesrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Create new column option
    public function createColumnOption($name)
    {
        $field = $this->Fields[$name] ?? false;
        if ($field && $field->Visible) {
            $item = new ListOption($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
            return $item;
        }
        return null;
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listaction->Action);
                $caption = $listaction->Caption;
                $icon = ($listaction->Icon != "") ? '<i class="' . HtmlEncode($listaction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fimmeublelist"' . $listaction->toDataAttrs() . '>' . $icon . '</button>';
                $item->Visible = $listaction->Allow;
            }
        }

        // Hide grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $userlist = "";
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("useraction", "");
        if ($filter != "" && $userAction != "") {
            // Check permission first
            $actionCaption = $userAction;
            if (array_key_exists($userAction, $this->ListActions->Items)) {
                $actionCaption = $this->ListActions[$userAction]->Caption;
                if (!$this->ListActions[$userAction]->Allow) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            }
            $this->CurrentFilter = $filter;
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            $this->UserAction = $userAction;
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($rs) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedCount = $rs->recordCount();
                $this->SelectedIndex = 0;
                while (!$rs->EOF) {
                    $this->SelectedIndex++;
                    $row = $rs->fields;
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                    $rs->moveNext();
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        $conn->commit();
                    }
                    if ($this->getSuccessMessage() == "" && !ob_get_length() && !$Response->getBody()->getSize()) { // No output
                        $this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        $conn->rollback();
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if ($rs) {
                $rs->close();
            }
            if (Post("ajax") == $userAction) { // Ajax
                if ($this->getSuccessMessage() != "") {
                    echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                    $this->clearSuccessMessage(); // Clear message
                }
                if ($this->getFailureMessage() != "") {
                    echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                    $this->clearFailureMessage(); // Clear message
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAll(FetchMode::ASSOCIATIVE);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id_immeuble->setDbValue($row['id_immeuble']);
        $this->descrip->setDbValue($row['descrip']);
        $this->codeimmeuble->setDbValue($row['codeimmeuble']);
        $this->daterecensement->setDbValue($row['daterecensement']);
        $this->st_annee_construct->setDbValue($row['st_annee_construct']);
        $this->st_propriete->setDbValue($row['st_propriete']);
        $this->st_en_affermage->setDbValue($row['st_en_affermage']);
        $this->st_en_location->setDbValue($row['st_en_location']);
        $this->st_en_usufruit->setDbValue($row['st_en_usufruit']);
        $this->st_autre->setDbValue($row['st_autre']);
        $this->ad_rue->setDbValue($row['ad_rue']);
        $this->ad_no_immeuble->setDbValue($row['ad_no_immeuble']);
        $this->ad_rue_adj->setDbValue($row['ad_rue_adj']);
        $this->ad_zonequartier->setDbValue($row['ad_zonequartier']);
        $this->ad_section->setDbValue($row['ad_section']);
        $this->ev_nb_toilette->setDbValue($row['ev_nb_toilette']);
        $this->ev_nb_cuisine->setDbValue($row['ev_nb_cuisine']);
        $this->ev_nb_garage->setDbValue($row['ev_nb_garage']);
        $this->ev_nb_m2->setDbValue($row['ev_nb_m2']);
        $this->ev_autresalle->setDbValue($row['ev_autresalle']);
        $this->ev_toit_tole->setDbValue($row['ev_toit_tole']);
        $this->ev_toit_beton->setDbValue($row['ev_toit_beton']);
        $this->ev_toit_tullles->setDbValue($row['ev_toit_tullles']);
        $this->ev_plancher_bois->setDbValue($row['ev_plancher_bois']);
        $this->ev_plancher_beton->setDbValue($row['ev_plancher_beton']);
        $this->ev_plancher_mosaique->setDbValue($row['ev_plancher_mosaique']);
        $this->ev_plancher_terazo->setDbValue($row['ev_plancher_terazo']);
        $this->ev_plancher_ceramique->setDbValue($row['ev_plancher_ceramique']);
        $this->est_ex_fiscal->setDbValue($row['est_ex_fiscal']);
        $this->est_estimation->setDbValue($row['est_estimation']);
        $this->est_montant->setDbValue($row['est_montant']);
        $this->id_owner->setDbValue($row['id_owner']);
        $this->id_agent->setDbValue($row['id_agent']);
        $this->localisation->setDbValue($row['localisation']);
        $this->usage->setDbValue($row['usage']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id_immeuble'] = $this->id_immeuble->DefaultValue;
        $row['descrip'] = $this->descrip->DefaultValue;
        $row['codeimmeuble'] = $this->codeimmeuble->DefaultValue;
        $row['daterecensement'] = $this->daterecensement->DefaultValue;
        $row['st_annee_construct'] = $this->st_annee_construct->DefaultValue;
        $row['st_propriete'] = $this->st_propriete->DefaultValue;
        $row['st_en_affermage'] = $this->st_en_affermage->DefaultValue;
        $row['st_en_location'] = $this->st_en_location->DefaultValue;
        $row['st_en_usufruit'] = $this->st_en_usufruit->DefaultValue;
        $row['st_autre'] = $this->st_autre->DefaultValue;
        $row['ad_rue'] = $this->ad_rue->DefaultValue;
        $row['ad_no_immeuble'] = $this->ad_no_immeuble->DefaultValue;
        $row['ad_rue_adj'] = $this->ad_rue_adj->DefaultValue;
        $row['ad_zonequartier'] = $this->ad_zonequartier->DefaultValue;
        $row['ad_section'] = $this->ad_section->DefaultValue;
        $row['ev_nb_toilette'] = $this->ev_nb_toilette->DefaultValue;
        $row['ev_nb_cuisine'] = $this->ev_nb_cuisine->DefaultValue;
        $row['ev_nb_garage'] = $this->ev_nb_garage->DefaultValue;
        $row['ev_nb_m2'] = $this->ev_nb_m2->DefaultValue;
        $row['ev_autresalle'] = $this->ev_autresalle->DefaultValue;
        $row['ev_toit_tole'] = $this->ev_toit_tole->DefaultValue;
        $row['ev_toit_beton'] = $this->ev_toit_beton->DefaultValue;
        $row['ev_toit_tullles'] = $this->ev_toit_tullles->DefaultValue;
        $row['ev_plancher_bois'] = $this->ev_plancher_bois->DefaultValue;
        $row['ev_plancher_beton'] = $this->ev_plancher_beton->DefaultValue;
        $row['ev_plancher_mosaique'] = $this->ev_plancher_mosaique->DefaultValue;
        $row['ev_plancher_terazo'] = $this->ev_plancher_terazo->DefaultValue;
        $row['ev_plancher_ceramique'] = $this->ev_plancher_ceramique->DefaultValue;
        $row['est_ex_fiscal'] = $this->est_ex_fiscal->DefaultValue;
        $row['est_estimation'] = $this->est_estimation->DefaultValue;
        $row['est_montant'] = $this->est_montant->DefaultValue;
        $row['id_owner'] = $this->id_owner->DefaultValue;
        $row['id_agent'] = $this->id_agent->DefaultValue;
        $row['localisation'] = $this->localisation->DefaultValue;
        $row['usage'] = $this->usage->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id_immeuble

        // descrip

        // codeimmeuble

        // daterecensement

        // st_annee_construct

        // st_propriete

        // st_en_affermage

        // st_en_location

        // st_en_usufruit

        // st_autre

        // ad_rue

        // ad_no_immeuble

        // ad_rue_adj

        // ad_zonequartier

        // ad_section

        // ev_nb_toilette

        // ev_nb_cuisine

        // ev_nb_garage

        // ev_nb_m2

        // ev_autresalle

        // ev_toit_tole

        // ev_toit_beton

        // ev_toit_tullles

        // ev_plancher_bois

        // ev_plancher_beton

        // ev_plancher_mosaique

        // ev_plancher_terazo

        // ev_plancher_ceramique

        // est_ex_fiscal

        // est_estimation

        // est_montant

        // id_owner
        $this->id_owner->CellCssStyle = "white-space: nowrap;";

        // id_agent

        // localisation

        // usage

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // id_immeuble
            $this->id_immeuble->ViewValue = $this->id_immeuble->CurrentValue;
            $this->id_immeuble->ViewCustomAttributes = "";

            // descrip
            $this->descrip->ViewValue = $this->descrip->CurrentValue;
            $this->descrip->ViewCustomAttributes = "";

            // codeimmeuble
            $this->codeimmeuble->ViewValue = $this->codeimmeuble->CurrentValue;
            $this->codeimmeuble->ViewCustomAttributes = "";

            // daterecensement
            $this->daterecensement->ViewValue = $this->daterecensement->CurrentValue;
            $this->daterecensement->ViewValue = FormatDateTime($this->daterecensement->ViewValue, $this->daterecensement->formatPattern());
            $this->daterecensement->ViewCustomAttributes = "";

            // st_annee_construct
            $this->st_annee_construct->ViewValue = $this->st_annee_construct->CurrentValue;
            $this->st_annee_construct->ViewCustomAttributes = "";

            // st_propriete
            $this->st_propriete->ViewValue = $this->st_propriete->CurrentValue;
            $this->st_propriete->ViewCustomAttributes = "";

            // st_en_affermage
            $this->st_en_affermage->ViewValue = $this->st_en_affermage->CurrentValue;
            $this->st_en_affermage->ViewCustomAttributes = "";

            // st_en_location
            $this->st_en_location->ViewValue = $this->st_en_location->CurrentValue;
            $this->st_en_location->ViewCustomAttributes = "";

            // st_en_usufruit
            $this->st_en_usufruit->ViewValue = $this->st_en_usufruit->CurrentValue;
            $this->st_en_usufruit->ViewCustomAttributes = "";

            // st_autre
            $this->st_autre->ViewValue = $this->st_autre->CurrentValue;
            $this->st_autre->ViewCustomAttributes = "";

            // ad_rue
            $this->ad_rue->ViewValue = $this->ad_rue->CurrentValue;
            $this->ad_rue->ViewCustomAttributes = "";

            // ad_no_immeuble
            $this->ad_no_immeuble->ViewValue = $this->ad_no_immeuble->CurrentValue;
            $this->ad_no_immeuble->ViewCustomAttributes = "";

            // ad_rue_adj
            $this->ad_rue_adj->ViewValue = $this->ad_rue_adj->CurrentValue;
            $this->ad_rue_adj->ViewCustomAttributes = "";

            // ad_zonequartier
            $this->ad_zonequartier->ViewValue = $this->ad_zonequartier->CurrentValue;
            $this->ad_zonequartier->ViewCustomAttributes = "";

            // ad_section
            $this->ad_section->ViewValue = $this->ad_section->CurrentValue;
            $this->ad_section->ViewCustomAttributes = "";

            // ev_nb_toilette
            $this->ev_nb_toilette->ViewValue = $this->ev_nb_toilette->CurrentValue;
            $this->ev_nb_toilette->ViewValue = FormatNumber($this->ev_nb_toilette->ViewValue, $this->ev_nb_toilette->formatPattern());
            $this->ev_nb_toilette->ViewCustomAttributes = "";

            // ev_nb_cuisine
            $this->ev_nb_cuisine->ViewValue = $this->ev_nb_cuisine->CurrentValue;
            $this->ev_nb_cuisine->ViewValue = FormatNumber($this->ev_nb_cuisine->ViewValue, $this->ev_nb_cuisine->formatPattern());
            $this->ev_nb_cuisine->ViewCustomAttributes = "";

            // ev_nb_garage
            $this->ev_nb_garage->ViewValue = $this->ev_nb_garage->CurrentValue;
            $this->ev_nb_garage->ViewValue = FormatNumber($this->ev_nb_garage->ViewValue, $this->ev_nb_garage->formatPattern());
            $this->ev_nb_garage->ViewCustomAttributes = "";

            // ev_nb_m2
            $this->ev_nb_m2->ViewValue = $this->ev_nb_m2->CurrentValue;
            $this->ev_nb_m2->ViewValue = FormatNumber($this->ev_nb_m2->ViewValue, $this->ev_nb_m2->formatPattern());
            $this->ev_nb_m2->ViewCustomAttributes = "";

            // ev_autresalle
            $this->ev_autresalle->ViewValue = $this->ev_autresalle->CurrentValue;
            $this->ev_autresalle->ViewCustomAttributes = "";

            // ev_toit_tole
            $this->ev_toit_tole->ViewValue = $this->ev_toit_tole->CurrentValue;
            $this->ev_toit_tole->ViewCustomAttributes = "";

            // ev_toit_beton
            $this->ev_toit_beton->ViewValue = $this->ev_toit_beton->CurrentValue;
            $this->ev_toit_beton->ViewCustomAttributes = "";

            // ev_toit_tullles
            $this->ev_toit_tullles->ViewValue = $this->ev_toit_tullles->CurrentValue;
            $this->ev_toit_tullles->ViewCustomAttributes = "";

            // ev_plancher_bois
            $this->ev_plancher_bois->ViewValue = $this->ev_plancher_bois->CurrentValue;
            $this->ev_plancher_bois->ViewCustomAttributes = "";

            // ev_plancher_beton
            $this->ev_plancher_beton->ViewValue = $this->ev_plancher_beton->CurrentValue;
            $this->ev_plancher_beton->ViewCustomAttributes = "";

            // ev_plancher_mosaique
            $this->ev_plancher_mosaique->ViewValue = $this->ev_plancher_mosaique->CurrentValue;
            $this->ev_plancher_mosaique->ViewCustomAttributes = "";

            // ev_plancher_terazo
            $this->ev_plancher_terazo->ViewValue = $this->ev_plancher_terazo->CurrentValue;
            $this->ev_plancher_terazo->ViewCustomAttributes = "";

            // ev_plancher_ceramique
            $this->ev_plancher_ceramique->ViewValue = $this->ev_plancher_ceramique->CurrentValue;
            $this->ev_plancher_ceramique->ViewCustomAttributes = "";

            // est_ex_fiscal
            $curVal = strval($this->est_ex_fiscal->CurrentValue);
            if ($curVal != "") {
                $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->lookupCacheOption($curVal);
                if ($this->est_ex_fiscal->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_ex_fiscal`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->est_ex_fiscal->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->est_ex_fiscal->Lookup->renderViewRow($rswrk[0]);
                        $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->displayValue($arwrk);
                    } else {
                        $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->CurrentValue;
                    }
                }
            } else {
                $this->est_ex_fiscal->ViewValue = null;
            }
            $this->est_ex_fiscal->ViewCustomAttributes = "";

            // est_estimation
            $this->est_estimation->ViewValue = $this->est_estimation->CurrentValue;
            $this->est_estimation->ViewValue = FormatNumber($this->est_estimation->ViewValue, $this->est_estimation->formatPattern());
            $this->est_estimation->ViewCustomAttributes = "";

            // est_montant
            $this->est_montant->ViewValue = $this->est_montant->CurrentValue;
            $this->est_montant->ViewValue = FormatNumber($this->est_montant->ViewValue, $this->est_montant->formatPattern());
            $this->est_montant->ViewCustomAttributes = "";

            // id_owner
            $curVal = strval($this->id_owner->CurrentValue);
            if ($curVal != "") {
                $this->id_owner->ViewValue = $this->id_owner->lookupCacheOption($curVal);
                if ($this->id_owner->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_owner`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_owner->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_owner->Lookup->renderViewRow($rswrk[0]);
                        $this->id_owner->ViewValue = $this->id_owner->displayValue($arwrk);
                    } else {
                        $this->id_owner->ViewValue = $this->id_owner->CurrentValue;
                    }
                }
            } else {
                $this->id_owner->ViewValue = null;
            }
            $this->id_owner->ViewCustomAttributes = "";

            // id_agent
            $curVal = strval($this->id_agent->CurrentValue);
            if ($curVal != "") {
                $this->id_agent->ViewValue = $this->id_agent->lookupCacheOption($curVal);
                if ($this->id_agent->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_agent`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_agent->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_agent->Lookup->renderViewRow($rswrk[0]);
                        $this->id_agent->ViewValue = $this->id_agent->displayValue($arwrk);
                    } else {
                        $this->id_agent->ViewValue = $this->id_agent->CurrentValue;
                    }
                }
            } else {
                $this->id_agent->ViewValue = null;
            }
            $this->id_agent->ViewCustomAttributes = "";

            // localisation
            $this->localisation->ViewValue = $this->localisation->CurrentValue;
            $this->localisation->ViewCustomAttributes = "";

            // usage
            if (strval($this->usage->CurrentValue) != "") {
                $this->usage->ViewValue = $this->usage->optionCaption($this->usage->CurrentValue);
            } else {
                $this->usage->ViewValue = null;
            }
            $this->usage->ViewCustomAttributes = "";

            // id_immeuble
            $this->id_immeuble->LinkCustomAttributes = "";
            $this->id_immeuble->HrefValue = "";
            $this->id_immeuble->TooltipValue = "";

            // descrip
            $this->descrip->LinkCustomAttributes = "";
            $this->descrip->HrefValue = "";
            $this->descrip->TooltipValue = "";

            // codeimmeuble
            $this->codeimmeuble->LinkCustomAttributes = "";
            $this->codeimmeuble->HrefValue = "";
            $this->codeimmeuble->TooltipValue = "";

            // daterecensement
            $this->daterecensement->LinkCustomAttributes = "";
            $this->daterecensement->HrefValue = "";
            $this->daterecensement->TooltipValue = "";

            // id_owner
            $this->id_owner->LinkCustomAttributes = "";
            $this->id_owner->HrefValue = "";
            $this->id_owner->TooltipValue = "";

            // id_agent
            $this->id_agent->LinkCustomAttributes = "";
            $this->id_agent->HrefValue = "";
            $this->id_agent->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        $pageUrl = $this->pageUrl(false);
        $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" form=\"fimmeublelist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" form=\"fimmeublelist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdfText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdfText")) . "\" form=\"fimmeublelist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdfText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdfText")) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" form="fimmeublelist" data-ew-action="email" data-hdr="' . $Language->phrase("ExportToEmailText") . '" data-sel="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("ExportToPrintText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPrintText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = false;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = true;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(["TagClassName" => "ew-search-option"]);

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fimmeublesrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        $item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction) {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($return = false)
    {
        global $Language;
        $utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");

        // Load recordset
        $this->TotalRecords = $this->listRecordCount();
        $this->StartRecord = 1;

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        $this->ExportDoc = GetExportDocument($this, "h");
        $doc = &$this->ExportDoc;
        if (!$doc) {
            $this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
        }
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $this->ExportDoc->ExportCustom = !$this->pageExporting();
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Close recordset
        $rs->close();

        // Call Page Exported server event
        $this->pageExported();

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Clean output buffer (without destroying output buffer)
        $buffer = ob_get_contents(); // Save the output buffer
        if (!Config("DEBUG") && $buffer) {
            ob_clean();
        }

        // Write debug message if enabled
        if (Config("DEBUG") && !$this->isExport("pdf")) {
            echo GetDebugMessage();
        }

        // Output data
        if ($this->isExport("email")) {
            // Export-to-email disabled
        } else {
            $doc->export();
            if ($return) {
                RemoveHeader("Content-Type"); // Remove header
                RemoveHeader("Content-Disposition");
                $content = ob_get_contents();
                if ($content) {
                    ob_clean();
                }
                if ($buffer) {
                    echo $buffer; // Resume the output buffer
                }
                return $content;
            }
        }
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->id_agent->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_est_ex_fiscal":
                    break;
                case "x_id_owner":
                    break;
                case "x_id_agent":
                    break;
                case "x_usage":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $ar[strval($row["lf"])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        if ($this->isPageRequest()) { // Validate request
            $startRec = Get(Config("TABLE_START_REC"));
            $pageNo = Get(Config("TABLE_PAGE_NO"));
            if ($pageNo !== null) { // Check for "pageno" parameter first
                $pageNo = ParseInteger($pageNo);
                if (is_numeric($pageNo)) {
                    $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                    if ($this->StartRecord <= 0) {
                        $this->StartRecord = 1;
                    } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                        $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                    }
                    $this->setStartRecordNumber($this->StartRecord);
                }
            } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
                $this->StartRecord = $startRec;
                $this->setStartRecordNumber($this->StartRecord);
            }
        }
        $this->StartRecord = $this->getStartRecordNumber();

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
            $this->setStartRecordNumber($this->StartRecord);
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    /*
        global $Language, $Security;
            $options = &$this->OtherOptions;
            $option = $options["addedit"];

            // Add
            $item = &$option->add("add");
            $addcaption = HtmlTitle($Language->phrase("AddLink"))." Add Immeuble";
            $item->Body = "<a class=\"btn-primary ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
            $item->Visible = $this->AddUrl != "" && $Security->canAdd();
      */     
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
            $sql1 = "select count(*) as `Nombre Immeuble:`  from immeuble ";
       $sql2 = "select ifnull(sum(est_estimation),0) as `Estimation Totale:`  from immeuble";
       $sql3 = "select ifnull(sum(est_montant),0) as `A payer Total:`  from immeuble";
      // Write(ExecuteHtml($sql1, ["fieldcaption" => true, "tablename" => ["immeuble"]]));
      // Write(ExecuteHtml($sql2, ["fieldcaption" => true, "tablename" => ["immeuble"]]));
      $p1=ExecuteHtml($sql1, ["fieldcaption" => true, "tablename" => ["immeuble"]]);
      $p2=ExecuteHtml($sql2, ["fieldcaption" => true, "tablename" => ["immeuble"]]);
      $p3=ExecuteHtml($sql3, ["fieldcaption" => true, "tablename" => ["immeuble"]]);
    ?>
     <div id="page-wrapper" class="card  ew-grid ">
    <div class="container mt-2 row">
      <h2>Dashbord</h2>
      <div class="card col-sm-4 bg-light" >
        <div class="card-header "></div>
        <div class="card-body bg-success"><?=$p1 ?></div> 
        <div class="card-footer"></div>
      </div>
      <div class="card col-sm-4">
        <div class="card-header"></div>
        <div class="card-body bg-info"><?=$p2 ?></div> 
        <div class="card-footer"></div>
      </div>
      <div class="card col-sm-4" >
        <div class="card-header"></div>
        <div class="card-body bg-warning"><?=$p3 ?></div> 
        <div class="card-footer"></div>
      </div>
    </div></div>
    <?php
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->Add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->MoveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $this->ExportDoc = export document object
    public function pageExporting()
    {
        //$this->ExportDoc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $this->ExportDoc = export document object
    public function rowExport($rs)
    {
        //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $this->ExportDoc = export document object
    public function pageExported()
    {
        //$this->ExportDoc->Text .= "my footer"; // Export footer
        //Log($this->ExportDoc->Text);
    }

    // Page Importing event
    public function pageImporting($reader, &$options)
    {
        //var_dump($reader); // Import data reader
        //var_dump($options); // Show all options for importing
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($reader, $results)
    {
        //var_dump($reader); // Import data reader
        //var_dump($results); // Import results
    }
}
