<?php

namespace PHPMaker2022\cfpb;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class ImmeubleDelete extends Immeuble
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'immeuble';

    // Page object name
    public $PageObjName = "ImmeubleDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = $route->getArguments();
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        $url = rtrim(UrlFor($route->getName(), $args), "/") . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return $this->TableVar == $CurrentForm->getValue("t");
            }
            if (Get("t") !== null) {
                return $this->TableVar == Get("t");
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (immeuble)
        if (!isset($GLOBALS["immeuble"]) || get_class($GLOBALS["immeuble"]) == PROJECT_NAMESPACE . "immeuble") {
            $GLOBALS["immeuble"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'immeuble');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $tbl = Container("immeuble");
                $doc = new $class($tbl);
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id_immeuble'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id_immeuble->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;
    public $RowCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param("layout", true));
        $this->CurrentAction = Param("action"); // Set up current action
        $this->id_immeuble->setVisibility();
        $this->descrip->setVisibility();
        $this->codeimmeuble->setVisibility();
        $this->daterecensement->setVisibility();
        $this->st_annee_construct->Visible = false;
        $this->st_propriete->Visible = false;
        $this->st_en_affermage->Visible = false;
        $this->st_en_location->Visible = false;
        $this->st_en_usufruit->Visible = false;
        $this->st_autre->Visible = false;
        $this->ad_rue->Visible = false;
        $this->ad_no_immeuble->Visible = false;
        $this->ad_rue_adj->Visible = false;
        $this->ad_zonequartier->Visible = false;
        $this->ad_section->Visible = false;
        $this->ev_nb_toilette->Visible = false;
        $this->ev_nb_cuisine->Visible = false;
        $this->ev_nb_garage->Visible = false;
        $this->ev_nb_m2->Visible = false;
        $this->ev_autresalle->Visible = false;
        $this->ev_toit_tole->Visible = false;
        $this->ev_toit_beton->Visible = false;
        $this->ev_toit_tullles->Visible = false;
        $this->ev_plancher_bois->Visible = false;
        $this->ev_plancher_beton->Visible = false;
        $this->ev_plancher_mosaique->Visible = false;
        $this->ev_plancher_terazo->Visible = false;
        $this->ev_plancher_ceramique->Visible = false;
        $this->est_ex_fiscal->Visible = false;
        $this->est_estimation->Visible = false;
        $this->est_montant->Visible = false;
        $this->id_owner->setVisibility();
        $this->id_agent->setVisibility();
        $this->localisation->Visible = false;
        $this->usage->Visible = false;
        $this->hideFieldsForAddEdit();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->est_ex_fiscal);
        $this->setupLookupOptions($this->id_owner);
        $this->setupLookupOptions($this->id_agent);
        $this->setupLookupOptions($this->usage);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("ImmeubleList"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Check if valid User ID
        $conn = $this->getConnection();
        $sql = $this->getSql($this->CurrentFilter);
        $rows = $conn->fetchAllAssociative($sql);
        $res = true;
        foreach ($rows as $row) {
            $this->loadRowValues($row);
            if (!$this->showOptionLink("delete")) {
                $userIdMsg = $Language->phrase("NoDeletePermission");
                $this->setFailureMessage($userIdMsg);
                $res = false;
                break;
            }
        }
        if (!$res) {
            $this->terminate("ImmeubleList"); // Return to list
            return;
        }

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Post("action") !== null) {
            $this->CurrentAction = Post("action");
        } elseif (Get("action") == "1") {
            $this->CurrentAction = "delete"; // Delete record directly
        } else {
            $this->CurrentAction = "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsApi()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsApi()) {
                    $this->terminate();
                    return;
                }
                $this->CurrentAction = "show"; // Display record
            }
        }
        if ($this->isShow()) { // Load records for display
            if ($this->Recordset = $this->loadRecordset()) {
                $this->TotalRecords = $this->Recordset->recordCount(); // Get record count
            }
            if ($this->TotalRecords <= 0) { // No record found, exit
                if ($this->Recordset) {
                    $this->Recordset->close();
                }
                $this->terminate("ImmeubleList"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAll(FetchMode::ASSOCIATIVE);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id_immeuble->setDbValue($row['id_immeuble']);
        $this->descrip->setDbValue($row['descrip']);
        $this->codeimmeuble->setDbValue($row['codeimmeuble']);
        $this->daterecensement->setDbValue($row['daterecensement']);
        $this->st_annee_construct->setDbValue($row['st_annee_construct']);
        $this->st_propriete->setDbValue($row['st_propriete']);
        $this->st_en_affermage->setDbValue($row['st_en_affermage']);
        $this->st_en_location->setDbValue($row['st_en_location']);
        $this->st_en_usufruit->setDbValue($row['st_en_usufruit']);
        $this->st_autre->setDbValue($row['st_autre']);
        $this->ad_rue->setDbValue($row['ad_rue']);
        $this->ad_no_immeuble->setDbValue($row['ad_no_immeuble']);
        $this->ad_rue_adj->setDbValue($row['ad_rue_adj']);
        $this->ad_zonequartier->setDbValue($row['ad_zonequartier']);
        $this->ad_section->setDbValue($row['ad_section']);
        $this->ev_nb_toilette->setDbValue($row['ev_nb_toilette']);
        $this->ev_nb_cuisine->setDbValue($row['ev_nb_cuisine']);
        $this->ev_nb_garage->setDbValue($row['ev_nb_garage']);
        $this->ev_nb_m2->setDbValue($row['ev_nb_m2']);
        $this->ev_autresalle->setDbValue($row['ev_autresalle']);
        $this->ev_toit_tole->setDbValue($row['ev_toit_tole']);
        $this->ev_toit_beton->setDbValue($row['ev_toit_beton']);
        $this->ev_toit_tullles->setDbValue($row['ev_toit_tullles']);
        $this->ev_plancher_bois->setDbValue($row['ev_plancher_bois']);
        $this->ev_plancher_beton->setDbValue($row['ev_plancher_beton']);
        $this->ev_plancher_mosaique->setDbValue($row['ev_plancher_mosaique']);
        $this->ev_plancher_terazo->setDbValue($row['ev_plancher_terazo']);
        $this->ev_plancher_ceramique->setDbValue($row['ev_plancher_ceramique']);
        $this->est_ex_fiscal->setDbValue($row['est_ex_fiscal']);
        $this->est_estimation->setDbValue($row['est_estimation']);
        $this->est_montant->setDbValue($row['est_montant']);
        $this->id_owner->setDbValue($row['id_owner']);
        $this->id_agent->setDbValue($row['id_agent']);
        $this->localisation->setDbValue($row['localisation']);
        $this->usage->setDbValue($row['usage']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id_immeuble'] = $this->id_immeuble->DefaultValue;
        $row['descrip'] = $this->descrip->DefaultValue;
        $row['codeimmeuble'] = $this->codeimmeuble->DefaultValue;
        $row['daterecensement'] = $this->daterecensement->DefaultValue;
        $row['st_annee_construct'] = $this->st_annee_construct->DefaultValue;
        $row['st_propriete'] = $this->st_propriete->DefaultValue;
        $row['st_en_affermage'] = $this->st_en_affermage->DefaultValue;
        $row['st_en_location'] = $this->st_en_location->DefaultValue;
        $row['st_en_usufruit'] = $this->st_en_usufruit->DefaultValue;
        $row['st_autre'] = $this->st_autre->DefaultValue;
        $row['ad_rue'] = $this->ad_rue->DefaultValue;
        $row['ad_no_immeuble'] = $this->ad_no_immeuble->DefaultValue;
        $row['ad_rue_adj'] = $this->ad_rue_adj->DefaultValue;
        $row['ad_zonequartier'] = $this->ad_zonequartier->DefaultValue;
        $row['ad_section'] = $this->ad_section->DefaultValue;
        $row['ev_nb_toilette'] = $this->ev_nb_toilette->DefaultValue;
        $row['ev_nb_cuisine'] = $this->ev_nb_cuisine->DefaultValue;
        $row['ev_nb_garage'] = $this->ev_nb_garage->DefaultValue;
        $row['ev_nb_m2'] = $this->ev_nb_m2->DefaultValue;
        $row['ev_autresalle'] = $this->ev_autresalle->DefaultValue;
        $row['ev_toit_tole'] = $this->ev_toit_tole->DefaultValue;
        $row['ev_toit_beton'] = $this->ev_toit_beton->DefaultValue;
        $row['ev_toit_tullles'] = $this->ev_toit_tullles->DefaultValue;
        $row['ev_plancher_bois'] = $this->ev_plancher_bois->DefaultValue;
        $row['ev_plancher_beton'] = $this->ev_plancher_beton->DefaultValue;
        $row['ev_plancher_mosaique'] = $this->ev_plancher_mosaique->DefaultValue;
        $row['ev_plancher_terazo'] = $this->ev_plancher_terazo->DefaultValue;
        $row['ev_plancher_ceramique'] = $this->ev_plancher_ceramique->DefaultValue;
        $row['est_ex_fiscal'] = $this->est_ex_fiscal->DefaultValue;
        $row['est_estimation'] = $this->est_estimation->DefaultValue;
        $row['est_montant'] = $this->est_montant->DefaultValue;
        $row['id_owner'] = $this->id_owner->DefaultValue;
        $row['id_agent'] = $this->id_agent->DefaultValue;
        $row['localisation'] = $this->localisation->DefaultValue;
        $row['usage'] = $this->usage->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id_immeuble

        // descrip

        // codeimmeuble

        // daterecensement

        // st_annee_construct

        // st_propriete

        // st_en_affermage

        // st_en_location

        // st_en_usufruit

        // st_autre

        // ad_rue

        // ad_no_immeuble

        // ad_rue_adj

        // ad_zonequartier

        // ad_section

        // ev_nb_toilette

        // ev_nb_cuisine

        // ev_nb_garage

        // ev_nb_m2

        // ev_autresalle

        // ev_toit_tole

        // ev_toit_beton

        // ev_toit_tullles

        // ev_plancher_bois

        // ev_plancher_beton

        // ev_plancher_mosaique

        // ev_plancher_terazo

        // ev_plancher_ceramique

        // est_ex_fiscal

        // est_estimation

        // est_montant

        // id_owner
        $this->id_owner->CellCssStyle = "white-space: nowrap;";

        // id_agent

        // localisation

        // usage

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // id_immeuble
            $this->id_immeuble->ViewValue = $this->id_immeuble->CurrentValue;
            $this->id_immeuble->ViewCustomAttributes = "";

            // descrip
            $this->descrip->ViewValue = $this->descrip->CurrentValue;
            $this->descrip->ViewCustomAttributes = "";

            // codeimmeuble
            $this->codeimmeuble->ViewValue = $this->codeimmeuble->CurrentValue;
            $this->codeimmeuble->ViewCustomAttributes = "";

            // daterecensement
            $this->daterecensement->ViewValue = $this->daterecensement->CurrentValue;
            $this->daterecensement->ViewValue = FormatDateTime($this->daterecensement->ViewValue, $this->daterecensement->formatPattern());
            $this->daterecensement->ViewCustomAttributes = "";

            // st_annee_construct
            $this->st_annee_construct->ViewValue = $this->st_annee_construct->CurrentValue;
            $this->st_annee_construct->ViewCustomAttributes = "";

            // st_propriete
            $this->st_propriete->ViewValue = $this->st_propriete->CurrentValue;
            $this->st_propriete->ViewCustomAttributes = "";

            // st_en_affermage
            $this->st_en_affermage->ViewValue = $this->st_en_affermage->CurrentValue;
            $this->st_en_affermage->ViewCustomAttributes = "";

            // st_en_location
            $this->st_en_location->ViewValue = $this->st_en_location->CurrentValue;
            $this->st_en_location->ViewCustomAttributes = "";

            // st_en_usufruit
            $this->st_en_usufruit->ViewValue = $this->st_en_usufruit->CurrentValue;
            $this->st_en_usufruit->ViewCustomAttributes = "";

            // st_autre
            $this->st_autre->ViewValue = $this->st_autre->CurrentValue;
            $this->st_autre->ViewCustomAttributes = "";

            // ad_rue
            $this->ad_rue->ViewValue = $this->ad_rue->CurrentValue;
            $this->ad_rue->ViewCustomAttributes = "";

            // ad_no_immeuble
            $this->ad_no_immeuble->ViewValue = $this->ad_no_immeuble->CurrentValue;
            $this->ad_no_immeuble->ViewCustomAttributes = "";

            // ad_rue_adj
            $this->ad_rue_adj->ViewValue = $this->ad_rue_adj->CurrentValue;
            $this->ad_rue_adj->ViewCustomAttributes = "";

            // ad_zonequartier
            $this->ad_zonequartier->ViewValue = $this->ad_zonequartier->CurrentValue;
            $this->ad_zonequartier->ViewCustomAttributes = "";

            // ad_section
            $this->ad_section->ViewValue = $this->ad_section->CurrentValue;
            $this->ad_section->ViewCustomAttributes = "";

            // ev_nb_toilette
            $this->ev_nb_toilette->ViewValue = $this->ev_nb_toilette->CurrentValue;
            $this->ev_nb_toilette->ViewValue = FormatNumber($this->ev_nb_toilette->ViewValue, $this->ev_nb_toilette->formatPattern());
            $this->ev_nb_toilette->ViewCustomAttributes = "";

            // ev_nb_cuisine
            $this->ev_nb_cuisine->ViewValue = $this->ev_nb_cuisine->CurrentValue;
            $this->ev_nb_cuisine->ViewValue = FormatNumber($this->ev_nb_cuisine->ViewValue, $this->ev_nb_cuisine->formatPattern());
            $this->ev_nb_cuisine->ViewCustomAttributes = "";

            // ev_nb_garage
            $this->ev_nb_garage->ViewValue = $this->ev_nb_garage->CurrentValue;
            $this->ev_nb_garage->ViewValue = FormatNumber($this->ev_nb_garage->ViewValue, $this->ev_nb_garage->formatPattern());
            $this->ev_nb_garage->ViewCustomAttributes = "";

            // ev_nb_m2
            $this->ev_nb_m2->ViewValue = $this->ev_nb_m2->CurrentValue;
            $this->ev_nb_m2->ViewValue = FormatNumber($this->ev_nb_m2->ViewValue, $this->ev_nb_m2->formatPattern());
            $this->ev_nb_m2->ViewCustomAttributes = "";

            // ev_autresalle
            $this->ev_autresalle->ViewValue = $this->ev_autresalle->CurrentValue;
            $this->ev_autresalle->ViewCustomAttributes = "";

            // ev_toit_tole
            $this->ev_toit_tole->ViewValue = $this->ev_toit_tole->CurrentValue;
            $this->ev_toit_tole->ViewCustomAttributes = "";

            // ev_toit_beton
            $this->ev_toit_beton->ViewValue = $this->ev_toit_beton->CurrentValue;
            $this->ev_toit_beton->ViewCustomAttributes = "";

            // ev_toit_tullles
            $this->ev_toit_tullles->ViewValue = $this->ev_toit_tullles->CurrentValue;
            $this->ev_toit_tullles->ViewCustomAttributes = "";

            // ev_plancher_bois
            $this->ev_plancher_bois->ViewValue = $this->ev_plancher_bois->CurrentValue;
            $this->ev_plancher_bois->ViewCustomAttributes = "";

            // ev_plancher_beton
            $this->ev_plancher_beton->ViewValue = $this->ev_plancher_beton->CurrentValue;
            $this->ev_plancher_beton->ViewCustomAttributes = "";

            // ev_plancher_mosaique
            $this->ev_plancher_mosaique->ViewValue = $this->ev_plancher_mosaique->CurrentValue;
            $this->ev_plancher_mosaique->ViewCustomAttributes = "";

            // ev_plancher_terazo
            $this->ev_plancher_terazo->ViewValue = $this->ev_plancher_terazo->CurrentValue;
            $this->ev_plancher_terazo->ViewCustomAttributes = "";

            // ev_plancher_ceramique
            $this->ev_plancher_ceramique->ViewValue = $this->ev_plancher_ceramique->CurrentValue;
            $this->ev_plancher_ceramique->ViewCustomAttributes = "";

            // est_ex_fiscal
            $curVal = strval($this->est_ex_fiscal->CurrentValue);
            if ($curVal != "") {
                $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->lookupCacheOption($curVal);
                if ($this->est_ex_fiscal->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_ex_fiscal`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->est_ex_fiscal->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->est_ex_fiscal->Lookup->renderViewRow($rswrk[0]);
                        $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->displayValue($arwrk);
                    } else {
                        $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->CurrentValue;
                    }
                }
            } else {
                $this->est_ex_fiscal->ViewValue = null;
            }
            $this->est_ex_fiscal->ViewCustomAttributes = "";

            // est_estimation
            $this->est_estimation->ViewValue = $this->est_estimation->CurrentValue;
            $this->est_estimation->ViewValue = FormatNumber($this->est_estimation->ViewValue, $this->est_estimation->formatPattern());
            $this->est_estimation->ViewCustomAttributes = "";

            // est_montant
            $this->est_montant->ViewValue = $this->est_montant->CurrentValue;
            $this->est_montant->ViewValue = FormatNumber($this->est_montant->ViewValue, $this->est_montant->formatPattern());
            $this->est_montant->ViewCustomAttributes = "";

            // id_owner
            $curVal = strval($this->id_owner->CurrentValue);
            if ($curVal != "") {
                $this->id_owner->ViewValue = $this->id_owner->lookupCacheOption($curVal);
                if ($this->id_owner->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_owner`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_owner->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_owner->Lookup->renderViewRow($rswrk[0]);
                        $this->id_owner->ViewValue = $this->id_owner->displayValue($arwrk);
                    } else {
                        $this->id_owner->ViewValue = $this->id_owner->CurrentValue;
                    }
                }
            } else {
                $this->id_owner->ViewValue = null;
            }
            $this->id_owner->ViewCustomAttributes = "";

            // id_agent
            $curVal = strval($this->id_agent->CurrentValue);
            if ($curVal != "") {
                $this->id_agent->ViewValue = $this->id_agent->lookupCacheOption($curVal);
                if ($this->id_agent->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_agent`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_agent->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_agent->Lookup->renderViewRow($rswrk[0]);
                        $this->id_agent->ViewValue = $this->id_agent->displayValue($arwrk);
                    } else {
                        $this->id_agent->ViewValue = $this->id_agent->CurrentValue;
                    }
                }
            } else {
                $this->id_agent->ViewValue = null;
            }
            $this->id_agent->ViewCustomAttributes = "";

            // localisation
            $this->localisation->ViewValue = $this->localisation->CurrentValue;
            $this->localisation->ViewCustomAttributes = "";

            // usage
            if (strval($this->usage->CurrentValue) != "") {
                $this->usage->ViewValue = $this->usage->optionCaption($this->usage->CurrentValue);
            } else {
                $this->usage->ViewValue = null;
            }
            $this->usage->ViewCustomAttributes = "";

            // id_immeuble
            $this->id_immeuble->LinkCustomAttributes = "";
            $this->id_immeuble->HrefValue = "";
            $this->id_immeuble->TooltipValue = "";

            // descrip
            $this->descrip->LinkCustomAttributes = "";
            $this->descrip->HrefValue = "";
            $this->descrip->TooltipValue = "";

            // codeimmeuble
            $this->codeimmeuble->LinkCustomAttributes = "";
            $this->codeimmeuble->HrefValue = "";
            $this->codeimmeuble->TooltipValue = "";

            // daterecensement
            $this->daterecensement->LinkCustomAttributes = "";
            $this->daterecensement->HrefValue = "";
            $this->daterecensement->TooltipValue = "";

            // id_owner
            $this->id_owner->LinkCustomAttributes = "";
            $this->id_owner->HrefValue = "";
            $this->id_owner->TooltipValue = "";

            // id_agent
            $this->id_agent->LinkCustomAttributes = "";
            $this->id_agent->HrefValue = "";
            $this->id_agent->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id_immeuble'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                $conn->commit();
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteSomeRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                $conn->rollback();
            }
        }

        // Write JSON for API request
        if (IsApi() && $deleteRows) {
            $row = $this->getRecordsFromRecordset($rsold);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $deleteRows;
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->id_agent->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ImmeubleList"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_est_ex_fiscal":
                    break;
                case "x_id_owner":
                    break;
                case "x_id_agent":
                    break;
                case "x_usage":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $ar[strval($row["lf"])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }
}
