<?php

namespace PHPMaker2022\cfpb;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class ImmeubleAdd extends Immeuble
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'immeuble';

    // Page object name
    public $PageObjName = "ImmeubleAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = $route->getArguments();
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        $url = rtrim(UrlFor($route->getName(), $args), "/") . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return $this->TableVar == $CurrentForm->getValue("t");
            }
            if (Get("t") !== null) {
                return $this->TableVar == Get("t");
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (immeuble)
        if (!isset($GLOBALS["immeuble"]) || get_class($GLOBALS["immeuble"]) == PROJECT_NAMESPACE . "immeuble") {
            $GLOBALS["immeuble"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'immeuble');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $tbl = Container("immeuble");
                $doc = new $class($tbl);
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "ImmeubleView") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id_immeuble'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id_immeuble->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $OldRecordset;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param("layout", true));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->id_immeuble->Visible = false;
        $this->descrip->setVisibility();
        $this->codeimmeuble->setVisibility();
        $this->daterecensement->setVisibility();
        $this->st_annee_construct->setVisibility();
        $this->st_propriete->setVisibility();
        $this->st_en_affermage->setVisibility();
        $this->st_en_location->setVisibility();
        $this->st_en_usufruit->setVisibility();
        $this->st_autre->setVisibility();
        $this->ad_rue->setVisibility();
        $this->ad_no_immeuble->setVisibility();
        $this->ad_rue_adj->setVisibility();
        $this->ad_zonequartier->setVisibility();
        $this->ad_section->setVisibility();
        $this->ev_nb_toilette->setVisibility();
        $this->ev_nb_cuisine->setVisibility();
        $this->ev_nb_garage->setVisibility();
        $this->ev_nb_m2->setVisibility();
        $this->ev_autresalle->setVisibility();
        $this->ev_toit_tole->setVisibility();
        $this->ev_toit_beton->setVisibility();
        $this->ev_toit_tullles->setVisibility();
        $this->ev_plancher_bois->setVisibility();
        $this->ev_plancher_beton->setVisibility();
        $this->ev_plancher_mosaique->setVisibility();
        $this->ev_plancher_terazo->setVisibility();
        $this->ev_plancher_ceramique->setVisibility();
        $this->est_ex_fiscal->setVisibility();
        $this->est_estimation->setVisibility();
        $this->est_montant->setVisibility();
        $this->id_owner->setVisibility();
        $this->id_agent->setVisibility();
        $this->localisation->setVisibility();
        $this->usage->setVisibility();
        $this->hideFieldsForAddEdit();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->est_ex_fiscal);
        $this->setupLookupOptions($this->id_owner);
        $this->setupLookupOptions($this->id_agent);
        $this->setupLookupOptions($this->usage);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $this->FormClassName = "ew-form ew-add-form";
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action") !== null) {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id_immeuble") ?? Route("id_immeuble")) !== null) {
                $this->id_immeuble->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record / default values
        $loaded = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$loaded) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("ImmeubleList"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($this->OldRecordset)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "ImmeubleList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "ImmeubleView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }
                    if (IsApi()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->daterecensement->DefaultValue = CurrentDateTime();
        $this->daterecensement->OldValue = $this->daterecensement->DefaultValue;
        $this->est_montant->DefaultValue = 0;
        $this->est_montant->OldValue = $this->est_montant->DefaultValue;
        $this->id_owner->DefaultValue = 0;
        $this->id_owner->OldValue = $this->id_owner->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'descrip' first before field var 'x_descrip'
        $val = $CurrentForm->hasValue("descrip") ? $CurrentForm->getValue("descrip") : $CurrentForm->getValue("x_descrip");
        if (!$this->descrip->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->descrip->Visible = false; // Disable update for API request
            } else {
                $this->descrip->setFormValue($val);
            }
        }

        // Check field name 'codeimmeuble' first before field var 'x_codeimmeuble'
        $val = $CurrentForm->hasValue("codeimmeuble") ? $CurrentForm->getValue("codeimmeuble") : $CurrentForm->getValue("x_codeimmeuble");
        if (!$this->codeimmeuble->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->codeimmeuble->Visible = false; // Disable update for API request
            } else {
                $this->codeimmeuble->setFormValue($val);
            }
        }

        // Check field name 'daterecensement' first before field var 'x_daterecensement'
        $val = $CurrentForm->hasValue("daterecensement") ? $CurrentForm->getValue("daterecensement") : $CurrentForm->getValue("x_daterecensement");
        if (!$this->daterecensement->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->daterecensement->Visible = false; // Disable update for API request
            } else {
                $this->daterecensement->setFormValue($val, true, $validate);
            }
            $this->daterecensement->CurrentValue = UnFormatDateTime($this->daterecensement->CurrentValue, $this->daterecensement->formatPattern());
        }

        // Check field name 'st_annee_construct' first before field var 'x_st_annee_construct'
        $val = $CurrentForm->hasValue("st_annee_construct") ? $CurrentForm->getValue("st_annee_construct") : $CurrentForm->getValue("x_st_annee_construct");
        if (!$this->st_annee_construct->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->st_annee_construct->Visible = false; // Disable update for API request
            } else {
                $this->st_annee_construct->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'st_propriete' first before field var 'x_st_propriete'
        $val = $CurrentForm->hasValue("st_propriete") ? $CurrentForm->getValue("st_propriete") : $CurrentForm->getValue("x_st_propriete");
        if (!$this->st_propriete->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->st_propriete->Visible = false; // Disable update for API request
            } else {
                $this->st_propriete->setFormValue($val);
            }
        }

        // Check field name 'st_en_affermage' first before field var 'x_st_en_affermage'
        $val = $CurrentForm->hasValue("st_en_affermage") ? $CurrentForm->getValue("st_en_affermage") : $CurrentForm->getValue("x_st_en_affermage");
        if (!$this->st_en_affermage->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->st_en_affermage->Visible = false; // Disable update for API request
            } else {
                $this->st_en_affermage->setFormValue($val);
            }
        }

        // Check field name 'st_en_location' first before field var 'x_st_en_location'
        $val = $CurrentForm->hasValue("st_en_location") ? $CurrentForm->getValue("st_en_location") : $CurrentForm->getValue("x_st_en_location");
        if (!$this->st_en_location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->st_en_location->Visible = false; // Disable update for API request
            } else {
                $this->st_en_location->setFormValue($val);
            }
        }

        // Check field name 'st_en_usufruit' first before field var 'x_st_en_usufruit'
        $val = $CurrentForm->hasValue("st_en_usufruit") ? $CurrentForm->getValue("st_en_usufruit") : $CurrentForm->getValue("x_st_en_usufruit");
        if (!$this->st_en_usufruit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->st_en_usufruit->Visible = false; // Disable update for API request
            } else {
                $this->st_en_usufruit->setFormValue($val);
            }
        }

        // Check field name 'st_autre' first before field var 'x_st_autre'
        $val = $CurrentForm->hasValue("st_autre") ? $CurrentForm->getValue("st_autre") : $CurrentForm->getValue("x_st_autre");
        if (!$this->st_autre->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->st_autre->Visible = false; // Disable update for API request
            } else {
                $this->st_autre->setFormValue($val);
            }
        }

        // Check field name 'ad_rue' first before field var 'x_ad_rue'
        $val = $CurrentForm->hasValue("ad_rue") ? $CurrentForm->getValue("ad_rue") : $CurrentForm->getValue("x_ad_rue");
        if (!$this->ad_rue->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ad_rue->Visible = false; // Disable update for API request
            } else {
                $this->ad_rue->setFormValue($val);
            }
        }

        // Check field name 'ad_no_immeuble' first before field var 'x_ad_no_immeuble'
        $val = $CurrentForm->hasValue("ad_no_immeuble") ? $CurrentForm->getValue("ad_no_immeuble") : $CurrentForm->getValue("x_ad_no_immeuble");
        if (!$this->ad_no_immeuble->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ad_no_immeuble->Visible = false; // Disable update for API request
            } else {
                $this->ad_no_immeuble->setFormValue($val);
            }
        }

        // Check field name 'ad_rue_adj' first before field var 'x_ad_rue_adj'
        $val = $CurrentForm->hasValue("ad_rue_adj") ? $CurrentForm->getValue("ad_rue_adj") : $CurrentForm->getValue("x_ad_rue_adj");
        if (!$this->ad_rue_adj->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ad_rue_adj->Visible = false; // Disable update for API request
            } else {
                $this->ad_rue_adj->setFormValue($val);
            }
        }

        // Check field name 'ad_zonequartier' first before field var 'x_ad_zonequartier'
        $val = $CurrentForm->hasValue("ad_zonequartier") ? $CurrentForm->getValue("ad_zonequartier") : $CurrentForm->getValue("x_ad_zonequartier");
        if (!$this->ad_zonequartier->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ad_zonequartier->Visible = false; // Disable update for API request
            } else {
                $this->ad_zonequartier->setFormValue($val);
            }
        }

        // Check field name 'ad_section' first before field var 'x_ad_section'
        $val = $CurrentForm->hasValue("ad_section") ? $CurrentForm->getValue("ad_section") : $CurrentForm->getValue("x_ad_section");
        if (!$this->ad_section->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ad_section->Visible = false; // Disable update for API request
            } else {
                $this->ad_section->setFormValue($val);
            }
        }

        // Check field name 'ev_nb_toilette' first before field var 'x_ev_nb_toilette'
        $val = $CurrentForm->hasValue("ev_nb_toilette") ? $CurrentForm->getValue("ev_nb_toilette") : $CurrentForm->getValue("x_ev_nb_toilette");
        if (!$this->ev_nb_toilette->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_nb_toilette->Visible = false; // Disable update for API request
            } else {
                $this->ev_nb_toilette->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ev_nb_cuisine' first before field var 'x_ev_nb_cuisine'
        $val = $CurrentForm->hasValue("ev_nb_cuisine") ? $CurrentForm->getValue("ev_nb_cuisine") : $CurrentForm->getValue("x_ev_nb_cuisine");
        if (!$this->ev_nb_cuisine->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_nb_cuisine->Visible = false; // Disable update for API request
            } else {
                $this->ev_nb_cuisine->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ev_nb_garage' first before field var 'x_ev_nb_garage'
        $val = $CurrentForm->hasValue("ev_nb_garage") ? $CurrentForm->getValue("ev_nb_garage") : $CurrentForm->getValue("x_ev_nb_garage");
        if (!$this->ev_nb_garage->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_nb_garage->Visible = false; // Disable update for API request
            } else {
                $this->ev_nb_garage->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ev_nb_m2' first before field var 'x_ev_nb_m2'
        $val = $CurrentForm->hasValue("ev_nb_m2") ? $CurrentForm->getValue("ev_nb_m2") : $CurrentForm->getValue("x_ev_nb_m2");
        if (!$this->ev_nb_m2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_nb_m2->Visible = false; // Disable update for API request
            } else {
                $this->ev_nb_m2->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ev_autresalle' first before field var 'x_ev_autresalle'
        $val = $CurrentForm->hasValue("ev_autresalle") ? $CurrentForm->getValue("ev_autresalle") : $CurrentForm->getValue("x_ev_autresalle");
        if (!$this->ev_autresalle->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_autresalle->Visible = false; // Disable update for API request
            } else {
                $this->ev_autresalle->setFormValue($val);
            }
        }

        // Check field name 'ev_toit_tole' first before field var 'x_ev_toit_tole'
        $val = $CurrentForm->hasValue("ev_toit_tole") ? $CurrentForm->getValue("ev_toit_tole") : $CurrentForm->getValue("x_ev_toit_tole");
        if (!$this->ev_toit_tole->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_toit_tole->Visible = false; // Disable update for API request
            } else {
                $this->ev_toit_tole->setFormValue($val);
            }
        }

        // Check field name 'ev_toit_beton' first before field var 'x_ev_toit_beton'
        $val = $CurrentForm->hasValue("ev_toit_beton") ? $CurrentForm->getValue("ev_toit_beton") : $CurrentForm->getValue("x_ev_toit_beton");
        if (!$this->ev_toit_beton->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_toit_beton->Visible = false; // Disable update for API request
            } else {
                $this->ev_toit_beton->setFormValue($val);
            }
        }

        // Check field name 'ev_toit_tullles' first before field var 'x_ev_toit_tullles'
        $val = $CurrentForm->hasValue("ev_toit_tullles") ? $CurrentForm->getValue("ev_toit_tullles") : $CurrentForm->getValue("x_ev_toit_tullles");
        if (!$this->ev_toit_tullles->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_toit_tullles->Visible = false; // Disable update for API request
            } else {
                $this->ev_toit_tullles->setFormValue($val);
            }
        }

        // Check field name 'ev_plancher_bois' first before field var 'x_ev_plancher_bois'
        $val = $CurrentForm->hasValue("ev_plancher_bois") ? $CurrentForm->getValue("ev_plancher_bois") : $CurrentForm->getValue("x_ev_plancher_bois");
        if (!$this->ev_plancher_bois->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_plancher_bois->Visible = false; // Disable update for API request
            } else {
                $this->ev_plancher_bois->setFormValue($val);
            }
        }

        // Check field name 'ev_plancher_beton' first before field var 'x_ev_plancher_beton'
        $val = $CurrentForm->hasValue("ev_plancher_beton") ? $CurrentForm->getValue("ev_plancher_beton") : $CurrentForm->getValue("x_ev_plancher_beton");
        if (!$this->ev_plancher_beton->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_plancher_beton->Visible = false; // Disable update for API request
            } else {
                $this->ev_plancher_beton->setFormValue($val);
            }
        }

        // Check field name 'ev_plancher_mosaique' first before field var 'x_ev_plancher_mosaique'
        $val = $CurrentForm->hasValue("ev_plancher_mosaique") ? $CurrentForm->getValue("ev_plancher_mosaique") : $CurrentForm->getValue("x_ev_plancher_mosaique");
        if (!$this->ev_plancher_mosaique->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_plancher_mosaique->Visible = false; // Disable update for API request
            } else {
                $this->ev_plancher_mosaique->setFormValue($val);
            }
        }

        // Check field name 'ev_plancher_terazo' first before field var 'x_ev_plancher_terazo'
        $val = $CurrentForm->hasValue("ev_plancher_terazo") ? $CurrentForm->getValue("ev_plancher_terazo") : $CurrentForm->getValue("x_ev_plancher_terazo");
        if (!$this->ev_plancher_terazo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_plancher_terazo->Visible = false; // Disable update for API request
            } else {
                $this->ev_plancher_terazo->setFormValue($val);
            }
        }

        // Check field name 'ev_plancher_ceramique' first before field var 'x_ev_plancher_ceramique'
        $val = $CurrentForm->hasValue("ev_plancher_ceramique") ? $CurrentForm->getValue("ev_plancher_ceramique") : $CurrentForm->getValue("x_ev_plancher_ceramique");
        if (!$this->ev_plancher_ceramique->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ev_plancher_ceramique->Visible = false; // Disable update for API request
            } else {
                $this->ev_plancher_ceramique->setFormValue($val);
            }
        }

        // Check field name 'est_ex_fiscal' first before field var 'x_est_ex_fiscal'
        $val = $CurrentForm->hasValue("est_ex_fiscal") ? $CurrentForm->getValue("est_ex_fiscal") : $CurrentForm->getValue("x_est_ex_fiscal");
        if (!$this->est_ex_fiscal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->est_ex_fiscal->Visible = false; // Disable update for API request
            } else {
                $this->est_ex_fiscal->setFormValue($val);
            }
        }

        // Check field name 'est_estimation' first before field var 'x_est_estimation'
        $val = $CurrentForm->hasValue("est_estimation") ? $CurrentForm->getValue("est_estimation") : $CurrentForm->getValue("x_est_estimation");
        if (!$this->est_estimation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->est_estimation->Visible = false; // Disable update for API request
            } else {
                $this->est_estimation->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'est_montant' first before field var 'x_est_montant'
        $val = $CurrentForm->hasValue("est_montant") ? $CurrentForm->getValue("est_montant") : $CurrentForm->getValue("x_est_montant");
        if (!$this->est_montant->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->est_montant->Visible = false; // Disable update for API request
            } else {
                $this->est_montant->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'id_owner' first before field var 'x_id_owner'
        $val = $CurrentForm->hasValue("id_owner") ? $CurrentForm->getValue("id_owner") : $CurrentForm->getValue("x_id_owner");
        if (!$this->id_owner->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id_owner->Visible = false; // Disable update for API request
            } else {
                $this->id_owner->setFormValue($val);
            }
        }

        // Check field name 'id_agent' first before field var 'x_id_agent'
        $val = $CurrentForm->hasValue("id_agent") ? $CurrentForm->getValue("id_agent") : $CurrentForm->getValue("x_id_agent");
        if (!$this->id_agent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id_agent->Visible = false; // Disable update for API request
            } else {
                $this->id_agent->setFormValue($val);
            }
        }

        // Check field name 'localisation' first before field var 'x_localisation'
        $val = $CurrentForm->hasValue("localisation") ? $CurrentForm->getValue("localisation") : $CurrentForm->getValue("x_localisation");
        if (!$this->localisation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->localisation->Visible = false; // Disable update for API request
            } else {
                $this->localisation->setFormValue($val);
            }
        }

        // Check field name 'usage' first before field var 'x_usage'
        $val = $CurrentForm->hasValue("usage") ? $CurrentForm->getValue("usage") : $CurrentForm->getValue("x_usage");
        if (!$this->usage->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->usage->Visible = false; // Disable update for API request
            } else {
                $this->usage->setFormValue($val);
            }
        }

        // Check field name 'id_immeuble' first before field var 'x_id_immeuble'
        $val = $CurrentForm->hasValue("id_immeuble") ? $CurrentForm->getValue("id_immeuble") : $CurrentForm->getValue("x_id_immeuble");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->descrip->CurrentValue = $this->descrip->FormValue;
        $this->codeimmeuble->CurrentValue = $this->codeimmeuble->FormValue;
        $this->daterecensement->CurrentValue = $this->daterecensement->FormValue;
        $this->daterecensement->CurrentValue = UnFormatDateTime($this->daterecensement->CurrentValue, $this->daterecensement->formatPattern());
        $this->st_annee_construct->CurrentValue = $this->st_annee_construct->FormValue;
        $this->st_propriete->CurrentValue = $this->st_propriete->FormValue;
        $this->st_en_affermage->CurrentValue = $this->st_en_affermage->FormValue;
        $this->st_en_location->CurrentValue = $this->st_en_location->FormValue;
        $this->st_en_usufruit->CurrentValue = $this->st_en_usufruit->FormValue;
        $this->st_autre->CurrentValue = $this->st_autre->FormValue;
        $this->ad_rue->CurrentValue = $this->ad_rue->FormValue;
        $this->ad_no_immeuble->CurrentValue = $this->ad_no_immeuble->FormValue;
        $this->ad_rue_adj->CurrentValue = $this->ad_rue_adj->FormValue;
        $this->ad_zonequartier->CurrentValue = $this->ad_zonequartier->FormValue;
        $this->ad_section->CurrentValue = $this->ad_section->FormValue;
        $this->ev_nb_toilette->CurrentValue = $this->ev_nb_toilette->FormValue;
        $this->ev_nb_cuisine->CurrentValue = $this->ev_nb_cuisine->FormValue;
        $this->ev_nb_garage->CurrentValue = $this->ev_nb_garage->FormValue;
        $this->ev_nb_m2->CurrentValue = $this->ev_nb_m2->FormValue;
        $this->ev_autresalle->CurrentValue = $this->ev_autresalle->FormValue;
        $this->ev_toit_tole->CurrentValue = $this->ev_toit_tole->FormValue;
        $this->ev_toit_beton->CurrentValue = $this->ev_toit_beton->FormValue;
        $this->ev_toit_tullles->CurrentValue = $this->ev_toit_tullles->FormValue;
        $this->ev_plancher_bois->CurrentValue = $this->ev_plancher_bois->FormValue;
        $this->ev_plancher_beton->CurrentValue = $this->ev_plancher_beton->FormValue;
        $this->ev_plancher_mosaique->CurrentValue = $this->ev_plancher_mosaique->FormValue;
        $this->ev_plancher_terazo->CurrentValue = $this->ev_plancher_terazo->FormValue;
        $this->ev_plancher_ceramique->CurrentValue = $this->ev_plancher_ceramique->FormValue;
        $this->est_ex_fiscal->CurrentValue = $this->est_ex_fiscal->FormValue;
        $this->est_estimation->CurrentValue = $this->est_estimation->FormValue;
        $this->est_montant->CurrentValue = $this->est_montant->FormValue;
        $this->id_owner->CurrentValue = $this->id_owner->FormValue;
        $this->id_agent->CurrentValue = $this->id_agent->FormValue;
        $this->localisation->CurrentValue = $this->localisation->FormValue;
        $this->usage->CurrentValue = $this->usage->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("add");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id_immeuble->setDbValue($row['id_immeuble']);
        $this->descrip->setDbValue($row['descrip']);
        $this->codeimmeuble->setDbValue($row['codeimmeuble']);
        $this->daterecensement->setDbValue($row['daterecensement']);
        $this->st_annee_construct->setDbValue($row['st_annee_construct']);
        $this->st_propriete->setDbValue($row['st_propriete']);
        $this->st_en_affermage->setDbValue($row['st_en_affermage']);
        $this->st_en_location->setDbValue($row['st_en_location']);
        $this->st_en_usufruit->setDbValue($row['st_en_usufruit']);
        $this->st_autre->setDbValue($row['st_autre']);
        $this->ad_rue->setDbValue($row['ad_rue']);
        $this->ad_no_immeuble->setDbValue($row['ad_no_immeuble']);
        $this->ad_rue_adj->setDbValue($row['ad_rue_adj']);
        $this->ad_zonequartier->setDbValue($row['ad_zonequartier']);
        $this->ad_section->setDbValue($row['ad_section']);
        $this->ev_nb_toilette->setDbValue($row['ev_nb_toilette']);
        $this->ev_nb_cuisine->setDbValue($row['ev_nb_cuisine']);
        $this->ev_nb_garage->setDbValue($row['ev_nb_garage']);
        $this->ev_nb_m2->setDbValue($row['ev_nb_m2']);
        $this->ev_autresalle->setDbValue($row['ev_autresalle']);
        $this->ev_toit_tole->setDbValue($row['ev_toit_tole']);
        $this->ev_toit_beton->setDbValue($row['ev_toit_beton']);
        $this->ev_toit_tullles->setDbValue($row['ev_toit_tullles']);
        $this->ev_plancher_bois->setDbValue($row['ev_plancher_bois']);
        $this->ev_plancher_beton->setDbValue($row['ev_plancher_beton']);
        $this->ev_plancher_mosaique->setDbValue($row['ev_plancher_mosaique']);
        $this->ev_plancher_terazo->setDbValue($row['ev_plancher_terazo']);
        $this->ev_plancher_ceramique->setDbValue($row['ev_plancher_ceramique']);
        $this->est_ex_fiscal->setDbValue($row['est_ex_fiscal']);
        $this->est_estimation->setDbValue($row['est_estimation']);
        $this->est_montant->setDbValue($row['est_montant']);
        $this->id_owner->setDbValue($row['id_owner']);
        $this->id_agent->setDbValue($row['id_agent']);
        $this->localisation->setDbValue($row['localisation']);
        $this->usage->setDbValue($row['usage']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id_immeuble'] = $this->id_immeuble->DefaultValue;
        $row['descrip'] = $this->descrip->DefaultValue;
        $row['codeimmeuble'] = $this->codeimmeuble->DefaultValue;
        $row['daterecensement'] = $this->daterecensement->DefaultValue;
        $row['st_annee_construct'] = $this->st_annee_construct->DefaultValue;
        $row['st_propriete'] = $this->st_propriete->DefaultValue;
        $row['st_en_affermage'] = $this->st_en_affermage->DefaultValue;
        $row['st_en_location'] = $this->st_en_location->DefaultValue;
        $row['st_en_usufruit'] = $this->st_en_usufruit->DefaultValue;
        $row['st_autre'] = $this->st_autre->DefaultValue;
        $row['ad_rue'] = $this->ad_rue->DefaultValue;
        $row['ad_no_immeuble'] = $this->ad_no_immeuble->DefaultValue;
        $row['ad_rue_adj'] = $this->ad_rue_adj->DefaultValue;
        $row['ad_zonequartier'] = $this->ad_zonequartier->DefaultValue;
        $row['ad_section'] = $this->ad_section->DefaultValue;
        $row['ev_nb_toilette'] = $this->ev_nb_toilette->DefaultValue;
        $row['ev_nb_cuisine'] = $this->ev_nb_cuisine->DefaultValue;
        $row['ev_nb_garage'] = $this->ev_nb_garage->DefaultValue;
        $row['ev_nb_m2'] = $this->ev_nb_m2->DefaultValue;
        $row['ev_autresalle'] = $this->ev_autresalle->DefaultValue;
        $row['ev_toit_tole'] = $this->ev_toit_tole->DefaultValue;
        $row['ev_toit_beton'] = $this->ev_toit_beton->DefaultValue;
        $row['ev_toit_tullles'] = $this->ev_toit_tullles->DefaultValue;
        $row['ev_plancher_bois'] = $this->ev_plancher_bois->DefaultValue;
        $row['ev_plancher_beton'] = $this->ev_plancher_beton->DefaultValue;
        $row['ev_plancher_mosaique'] = $this->ev_plancher_mosaique->DefaultValue;
        $row['ev_plancher_terazo'] = $this->ev_plancher_terazo->DefaultValue;
        $row['ev_plancher_ceramique'] = $this->ev_plancher_ceramique->DefaultValue;
        $row['est_ex_fiscal'] = $this->est_ex_fiscal->DefaultValue;
        $row['est_estimation'] = $this->est_estimation->DefaultValue;
        $row['est_montant'] = $this->est_montant->DefaultValue;
        $row['id_owner'] = $this->id_owner->DefaultValue;
        $row['id_agent'] = $this->id_agent->DefaultValue;
        $row['localisation'] = $this->localisation->DefaultValue;
        $row['usage'] = $this->usage->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id_immeuble
        $this->id_immeuble->RowCssClass = "row";

        // descrip
        $this->descrip->RowCssClass = "row";

        // codeimmeuble
        $this->codeimmeuble->RowCssClass = "row";

        // daterecensement
        $this->daterecensement->RowCssClass = "row";

        // st_annee_construct
        $this->st_annee_construct->RowCssClass = "row";

        // st_propriete
        $this->st_propriete->RowCssClass = "row";

        // st_en_affermage
        $this->st_en_affermage->RowCssClass = "row";

        // st_en_location
        $this->st_en_location->RowCssClass = "row";

        // st_en_usufruit
        $this->st_en_usufruit->RowCssClass = "row";

        // st_autre
        $this->st_autre->RowCssClass = "row";

        // ad_rue
        $this->ad_rue->RowCssClass = "row";

        // ad_no_immeuble
        $this->ad_no_immeuble->RowCssClass = "row";

        // ad_rue_adj
        $this->ad_rue_adj->RowCssClass = "row";

        // ad_zonequartier
        $this->ad_zonequartier->RowCssClass = "row";

        // ad_section
        $this->ad_section->RowCssClass = "row";

        // ev_nb_toilette
        $this->ev_nb_toilette->RowCssClass = "row";

        // ev_nb_cuisine
        $this->ev_nb_cuisine->RowCssClass = "row";

        // ev_nb_garage
        $this->ev_nb_garage->RowCssClass = "row";

        // ev_nb_m2
        $this->ev_nb_m2->RowCssClass = "row";

        // ev_autresalle
        $this->ev_autresalle->RowCssClass = "row";

        // ev_toit_tole
        $this->ev_toit_tole->RowCssClass = "row";

        // ev_toit_beton
        $this->ev_toit_beton->RowCssClass = "row";

        // ev_toit_tullles
        $this->ev_toit_tullles->RowCssClass = "row";

        // ev_plancher_bois
        $this->ev_plancher_bois->RowCssClass = "row";

        // ev_plancher_beton
        $this->ev_plancher_beton->RowCssClass = "row";

        // ev_plancher_mosaique
        $this->ev_plancher_mosaique->RowCssClass = "row";

        // ev_plancher_terazo
        $this->ev_plancher_terazo->RowCssClass = "row";

        // ev_plancher_ceramique
        $this->ev_plancher_ceramique->RowCssClass = "row";

        // est_ex_fiscal
        $this->est_ex_fiscal->RowCssClass = "row";

        // est_estimation
        $this->est_estimation->RowCssClass = "row";

        // est_montant
        $this->est_montant->RowCssClass = "row";

        // id_owner
        $this->id_owner->RowCssClass = "row";

        // id_agent
        $this->id_agent->RowCssClass = "row";

        // localisation
        $this->localisation->RowCssClass = "row";

        // usage
        $this->usage->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // id_immeuble
            $this->id_immeuble->ViewValue = $this->id_immeuble->CurrentValue;
            $this->id_immeuble->ViewCustomAttributes = "";

            // descrip
            $this->descrip->ViewValue = $this->descrip->CurrentValue;
            $this->descrip->ViewCustomAttributes = "";

            // codeimmeuble
            $this->codeimmeuble->ViewValue = $this->codeimmeuble->CurrentValue;
            $this->codeimmeuble->ViewCustomAttributes = "";

            // daterecensement
            $this->daterecensement->ViewValue = $this->daterecensement->CurrentValue;
            $this->daterecensement->ViewValue = FormatDateTime($this->daterecensement->ViewValue, $this->daterecensement->formatPattern());
            $this->daterecensement->ViewCustomAttributes = "";

            // st_annee_construct
            $this->st_annee_construct->ViewValue = $this->st_annee_construct->CurrentValue;
            $this->st_annee_construct->ViewCustomAttributes = "";

            // st_propriete
            $this->st_propriete->ViewValue = $this->st_propriete->CurrentValue;
            $this->st_propriete->ViewCustomAttributes = "";

            // st_en_affermage
            $this->st_en_affermage->ViewValue = $this->st_en_affermage->CurrentValue;
            $this->st_en_affermage->ViewCustomAttributes = "";

            // st_en_location
            $this->st_en_location->ViewValue = $this->st_en_location->CurrentValue;
            $this->st_en_location->ViewCustomAttributes = "";

            // st_en_usufruit
            $this->st_en_usufruit->ViewValue = $this->st_en_usufruit->CurrentValue;
            $this->st_en_usufruit->ViewCustomAttributes = "";

            // st_autre
            $this->st_autre->ViewValue = $this->st_autre->CurrentValue;
            $this->st_autre->ViewCustomAttributes = "";

            // ad_rue
            $this->ad_rue->ViewValue = $this->ad_rue->CurrentValue;
            $this->ad_rue->ViewCustomAttributes = "";

            // ad_no_immeuble
            $this->ad_no_immeuble->ViewValue = $this->ad_no_immeuble->CurrentValue;
            $this->ad_no_immeuble->ViewCustomAttributes = "";

            // ad_rue_adj
            $this->ad_rue_adj->ViewValue = $this->ad_rue_adj->CurrentValue;
            $this->ad_rue_adj->ViewCustomAttributes = "";

            // ad_zonequartier
            $this->ad_zonequartier->ViewValue = $this->ad_zonequartier->CurrentValue;
            $this->ad_zonequartier->ViewCustomAttributes = "";

            // ad_section
            $this->ad_section->ViewValue = $this->ad_section->CurrentValue;
            $this->ad_section->ViewCustomAttributes = "";

            // ev_nb_toilette
            $this->ev_nb_toilette->ViewValue = $this->ev_nb_toilette->CurrentValue;
            $this->ev_nb_toilette->ViewValue = FormatNumber($this->ev_nb_toilette->ViewValue, $this->ev_nb_toilette->formatPattern());
            $this->ev_nb_toilette->ViewCustomAttributes = "";

            // ev_nb_cuisine
            $this->ev_nb_cuisine->ViewValue = $this->ev_nb_cuisine->CurrentValue;
            $this->ev_nb_cuisine->ViewValue = FormatNumber($this->ev_nb_cuisine->ViewValue, $this->ev_nb_cuisine->formatPattern());
            $this->ev_nb_cuisine->ViewCustomAttributes = "";

            // ev_nb_garage
            $this->ev_nb_garage->ViewValue = $this->ev_nb_garage->CurrentValue;
            $this->ev_nb_garage->ViewValue = FormatNumber($this->ev_nb_garage->ViewValue, $this->ev_nb_garage->formatPattern());
            $this->ev_nb_garage->ViewCustomAttributes = "";

            // ev_nb_m2
            $this->ev_nb_m2->ViewValue = $this->ev_nb_m2->CurrentValue;
            $this->ev_nb_m2->ViewValue = FormatNumber($this->ev_nb_m2->ViewValue, $this->ev_nb_m2->formatPattern());
            $this->ev_nb_m2->ViewCustomAttributes = "";

            // ev_autresalle
            $this->ev_autresalle->ViewValue = $this->ev_autresalle->CurrentValue;
            $this->ev_autresalle->ViewCustomAttributes = "";

            // ev_toit_tole
            $this->ev_toit_tole->ViewValue = $this->ev_toit_tole->CurrentValue;
            $this->ev_toit_tole->ViewCustomAttributes = "";

            // ev_toit_beton
            $this->ev_toit_beton->ViewValue = $this->ev_toit_beton->CurrentValue;
            $this->ev_toit_beton->ViewCustomAttributes = "";

            // ev_toit_tullles
            $this->ev_toit_tullles->ViewValue = $this->ev_toit_tullles->CurrentValue;
            $this->ev_toit_tullles->ViewCustomAttributes = "";

            // ev_plancher_bois
            $this->ev_plancher_bois->ViewValue = $this->ev_plancher_bois->CurrentValue;
            $this->ev_plancher_bois->ViewCustomAttributes = "";

            // ev_plancher_beton
            $this->ev_plancher_beton->ViewValue = $this->ev_plancher_beton->CurrentValue;
            $this->ev_plancher_beton->ViewCustomAttributes = "";

            // ev_plancher_mosaique
            $this->ev_plancher_mosaique->ViewValue = $this->ev_plancher_mosaique->CurrentValue;
            $this->ev_plancher_mosaique->ViewCustomAttributes = "";

            // ev_plancher_terazo
            $this->ev_plancher_terazo->ViewValue = $this->ev_plancher_terazo->CurrentValue;
            $this->ev_plancher_terazo->ViewCustomAttributes = "";

            // ev_plancher_ceramique
            $this->ev_plancher_ceramique->ViewValue = $this->ev_plancher_ceramique->CurrentValue;
            $this->ev_plancher_ceramique->ViewCustomAttributes = "";

            // est_ex_fiscal
            $curVal = strval($this->est_ex_fiscal->CurrentValue);
            if ($curVal != "") {
                $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->lookupCacheOption($curVal);
                if ($this->est_ex_fiscal->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_ex_fiscal`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->est_ex_fiscal->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->est_ex_fiscal->Lookup->renderViewRow($rswrk[0]);
                        $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->displayValue($arwrk);
                    } else {
                        $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->CurrentValue;
                    }
                }
            } else {
                $this->est_ex_fiscal->ViewValue = null;
            }
            $this->est_ex_fiscal->ViewCustomAttributes = "";

            // est_estimation
            $this->est_estimation->ViewValue = $this->est_estimation->CurrentValue;
            $this->est_estimation->ViewValue = FormatNumber($this->est_estimation->ViewValue, $this->est_estimation->formatPattern());
            $this->est_estimation->ViewCustomAttributes = "";

            // est_montant
            $this->est_montant->ViewValue = $this->est_montant->CurrentValue;
            $this->est_montant->ViewValue = FormatNumber($this->est_montant->ViewValue, $this->est_montant->formatPattern());
            $this->est_montant->ViewCustomAttributes = "";

            // id_owner
            $curVal = strval($this->id_owner->CurrentValue);
            if ($curVal != "") {
                $this->id_owner->ViewValue = $this->id_owner->lookupCacheOption($curVal);
                if ($this->id_owner->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_owner`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_owner->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_owner->Lookup->renderViewRow($rswrk[0]);
                        $this->id_owner->ViewValue = $this->id_owner->displayValue($arwrk);
                    } else {
                        $this->id_owner->ViewValue = $this->id_owner->CurrentValue;
                    }
                }
            } else {
                $this->id_owner->ViewValue = null;
            }
            $this->id_owner->ViewCustomAttributes = "";

            // id_agent
            $curVal = strval($this->id_agent->CurrentValue);
            if ($curVal != "") {
                $this->id_agent->ViewValue = $this->id_agent->lookupCacheOption($curVal);
                if ($this->id_agent->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id_agent`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_agent->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_agent->Lookup->renderViewRow($rswrk[0]);
                        $this->id_agent->ViewValue = $this->id_agent->displayValue($arwrk);
                    } else {
                        $this->id_agent->ViewValue = $this->id_agent->CurrentValue;
                    }
                }
            } else {
                $this->id_agent->ViewValue = null;
            }
            $this->id_agent->ViewCustomAttributes = "";

            // localisation
            $this->localisation->ViewValue = $this->localisation->CurrentValue;
            $this->localisation->ViewCustomAttributes = "";

            // usage
            if (strval($this->usage->CurrentValue) != "") {
                $this->usage->ViewValue = $this->usage->optionCaption($this->usage->CurrentValue);
            } else {
                $this->usage->ViewValue = null;
            }
            $this->usage->ViewCustomAttributes = "";

            // descrip
            $this->descrip->LinkCustomAttributes = "";
            $this->descrip->HrefValue = "";

            // codeimmeuble
            $this->codeimmeuble->LinkCustomAttributes = "";
            $this->codeimmeuble->HrefValue = "";

            // daterecensement
            $this->daterecensement->LinkCustomAttributes = "";
            $this->daterecensement->HrefValue = "";

            // st_annee_construct
            $this->st_annee_construct->LinkCustomAttributes = "";
            $this->st_annee_construct->HrefValue = "";

            // st_propriete
            $this->st_propriete->LinkCustomAttributes = "";
            $this->st_propriete->HrefValue = "";

            // st_en_affermage
            $this->st_en_affermage->LinkCustomAttributes = "";
            $this->st_en_affermage->HrefValue = "";

            // st_en_location
            $this->st_en_location->LinkCustomAttributes = "";
            $this->st_en_location->HrefValue = "";

            // st_en_usufruit
            $this->st_en_usufruit->LinkCustomAttributes = "";
            $this->st_en_usufruit->HrefValue = "";

            // st_autre
            $this->st_autre->LinkCustomAttributes = "";
            $this->st_autre->HrefValue = "";

            // ad_rue
            $this->ad_rue->LinkCustomAttributes = "";
            $this->ad_rue->HrefValue = "";

            // ad_no_immeuble
            $this->ad_no_immeuble->LinkCustomAttributes = "";
            $this->ad_no_immeuble->HrefValue = "";

            // ad_rue_adj
            $this->ad_rue_adj->LinkCustomAttributes = "";
            $this->ad_rue_adj->HrefValue = "";

            // ad_zonequartier
            $this->ad_zonequartier->LinkCustomAttributes = "";
            $this->ad_zonequartier->HrefValue = "";

            // ad_section
            $this->ad_section->LinkCustomAttributes = "";
            $this->ad_section->HrefValue = "";

            // ev_nb_toilette
            $this->ev_nb_toilette->LinkCustomAttributes = "";
            $this->ev_nb_toilette->HrefValue = "";

            // ev_nb_cuisine
            $this->ev_nb_cuisine->LinkCustomAttributes = "";
            $this->ev_nb_cuisine->HrefValue = "";

            // ev_nb_garage
            $this->ev_nb_garage->LinkCustomAttributes = "";
            $this->ev_nb_garage->HrefValue = "";

            // ev_nb_m2
            $this->ev_nb_m2->LinkCustomAttributes = "";
            $this->ev_nb_m2->HrefValue = "";

            // ev_autresalle
            $this->ev_autresalle->LinkCustomAttributes = "";
            $this->ev_autresalle->HrefValue = "";

            // ev_toit_tole
            $this->ev_toit_tole->LinkCustomAttributes = "";
            $this->ev_toit_tole->HrefValue = "";

            // ev_toit_beton
            $this->ev_toit_beton->LinkCustomAttributes = "";
            $this->ev_toit_beton->HrefValue = "";

            // ev_toit_tullles
            $this->ev_toit_tullles->LinkCustomAttributes = "";
            $this->ev_toit_tullles->HrefValue = "";

            // ev_plancher_bois
            $this->ev_plancher_bois->LinkCustomAttributes = "";
            $this->ev_plancher_bois->HrefValue = "";

            // ev_plancher_beton
            $this->ev_plancher_beton->LinkCustomAttributes = "";
            $this->ev_plancher_beton->HrefValue = "";

            // ev_plancher_mosaique
            $this->ev_plancher_mosaique->LinkCustomAttributes = "";
            $this->ev_plancher_mosaique->HrefValue = "";

            // ev_plancher_terazo
            $this->ev_plancher_terazo->LinkCustomAttributes = "";
            $this->ev_plancher_terazo->HrefValue = "";

            // ev_plancher_ceramique
            $this->ev_plancher_ceramique->LinkCustomAttributes = "";
            $this->ev_plancher_ceramique->HrefValue = "";

            // est_ex_fiscal
            $this->est_ex_fiscal->LinkCustomAttributes = "";
            $this->est_ex_fiscal->HrefValue = "";

            // est_estimation
            $this->est_estimation->LinkCustomAttributes = "";
            $this->est_estimation->HrefValue = "";

            // est_montant
            $this->est_montant->LinkCustomAttributes = "";
            $this->est_montant->HrefValue = "";

            // id_owner
            $this->id_owner->LinkCustomAttributes = "";
            $this->id_owner->HrefValue = "";

            // id_agent
            $this->id_agent->LinkCustomAttributes = "";
            $this->id_agent->HrefValue = "";
            $this->id_agent->TooltipValue = "";

            // localisation
            $this->localisation->LinkCustomAttributes = "";
            $this->localisation->HrefValue = "";

            // usage
            $this->usage->LinkCustomAttributes = "";
            $this->usage->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // descrip
            $this->descrip->setupEditAttributes();
            $this->descrip->EditCustomAttributes = "";
            $this->descrip->EditValue = HtmlEncode($this->descrip->CurrentValue);
            $this->descrip->PlaceHolder = RemoveHtml($this->descrip->caption());

            // codeimmeuble
            $this->codeimmeuble->setupEditAttributes();
            $this->codeimmeuble->EditCustomAttributes = "";
            if (!$this->codeimmeuble->Raw) {
                $this->codeimmeuble->CurrentValue = HtmlDecode($this->codeimmeuble->CurrentValue);
            }
            $this->codeimmeuble->EditValue = HtmlEncode($this->codeimmeuble->CurrentValue);
            $this->codeimmeuble->PlaceHolder = RemoveHtml($this->codeimmeuble->caption());

            // daterecensement
            $this->daterecensement->setupEditAttributes();
            $this->daterecensement->EditCustomAttributes = "";
            $this->daterecensement->EditValue = HtmlEncode(FormatDateTime($this->daterecensement->CurrentValue, $this->daterecensement->formatPattern()));
            $this->daterecensement->PlaceHolder = RemoveHtml($this->daterecensement->caption());

            // st_annee_construct
            $this->st_annee_construct->setupEditAttributes();
            $this->st_annee_construct->EditCustomAttributes = "";
            $this->st_annee_construct->EditValue = HtmlEncode($this->st_annee_construct->CurrentValue);
            $this->st_annee_construct->PlaceHolder = RemoveHtml($this->st_annee_construct->caption());
            if (strval($this->st_annee_construct->EditValue) != "" && is_numeric($this->st_annee_construct->EditValue)) {
                $this->st_annee_construct->EditValue = $this->st_annee_construct->EditValue;
            }

            // st_propriete
            $this->st_propriete->setupEditAttributes();
            $this->st_propriete->EditCustomAttributes = "";
            if (!$this->st_propriete->Raw) {
                $this->st_propriete->CurrentValue = HtmlDecode($this->st_propriete->CurrentValue);
            }
            $this->st_propriete->EditValue = HtmlEncode($this->st_propriete->CurrentValue);
            $this->st_propriete->PlaceHolder = RemoveHtml($this->st_propriete->caption());

            // st_en_affermage
            $this->st_en_affermage->setupEditAttributes();
            $this->st_en_affermage->EditCustomAttributes = "";
            if (!$this->st_en_affermage->Raw) {
                $this->st_en_affermage->CurrentValue = HtmlDecode($this->st_en_affermage->CurrentValue);
            }
            $this->st_en_affermage->EditValue = HtmlEncode($this->st_en_affermage->CurrentValue);
            $this->st_en_affermage->PlaceHolder = RemoveHtml($this->st_en_affermage->caption());

            // st_en_location
            $this->st_en_location->setupEditAttributes();
            $this->st_en_location->EditCustomAttributes = "";
            if (!$this->st_en_location->Raw) {
                $this->st_en_location->CurrentValue = HtmlDecode($this->st_en_location->CurrentValue);
            }
            $this->st_en_location->EditValue = HtmlEncode($this->st_en_location->CurrentValue);
            $this->st_en_location->PlaceHolder = RemoveHtml($this->st_en_location->caption());

            // st_en_usufruit
            $this->st_en_usufruit->setupEditAttributes();
            $this->st_en_usufruit->EditCustomAttributes = "";
            if (!$this->st_en_usufruit->Raw) {
                $this->st_en_usufruit->CurrentValue = HtmlDecode($this->st_en_usufruit->CurrentValue);
            }
            $this->st_en_usufruit->EditValue = HtmlEncode($this->st_en_usufruit->CurrentValue);
            $this->st_en_usufruit->PlaceHolder = RemoveHtml($this->st_en_usufruit->caption());

            // st_autre
            $this->st_autre->setupEditAttributes();
            $this->st_autre->EditCustomAttributes = "";
            if (!$this->st_autre->Raw) {
                $this->st_autre->CurrentValue = HtmlDecode($this->st_autre->CurrentValue);
            }
            $this->st_autre->EditValue = HtmlEncode($this->st_autre->CurrentValue);
            $this->st_autre->PlaceHolder = RemoveHtml($this->st_autre->caption());

            // ad_rue
            $this->ad_rue->setupEditAttributes();
            $this->ad_rue->EditCustomAttributes = "";
            if (!$this->ad_rue->Raw) {
                $this->ad_rue->CurrentValue = HtmlDecode($this->ad_rue->CurrentValue);
            }
            $this->ad_rue->EditValue = HtmlEncode($this->ad_rue->CurrentValue);
            $this->ad_rue->PlaceHolder = RemoveHtml($this->ad_rue->caption());

            // ad_no_immeuble
            $this->ad_no_immeuble->setupEditAttributes();
            $this->ad_no_immeuble->EditCustomAttributes = "";
            if (!$this->ad_no_immeuble->Raw) {
                $this->ad_no_immeuble->CurrentValue = HtmlDecode($this->ad_no_immeuble->CurrentValue);
            }
            $this->ad_no_immeuble->EditValue = HtmlEncode($this->ad_no_immeuble->CurrentValue);
            $this->ad_no_immeuble->PlaceHolder = RemoveHtml($this->ad_no_immeuble->caption());

            // ad_rue_adj
            $this->ad_rue_adj->setupEditAttributes();
            $this->ad_rue_adj->EditCustomAttributes = "";
            if (!$this->ad_rue_adj->Raw) {
                $this->ad_rue_adj->CurrentValue = HtmlDecode($this->ad_rue_adj->CurrentValue);
            }
            $this->ad_rue_adj->EditValue = HtmlEncode($this->ad_rue_adj->CurrentValue);
            $this->ad_rue_adj->PlaceHolder = RemoveHtml($this->ad_rue_adj->caption());

            // ad_zonequartier
            $this->ad_zonequartier->setupEditAttributes();
            $this->ad_zonequartier->EditCustomAttributes = "";
            if (!$this->ad_zonequartier->Raw) {
                $this->ad_zonequartier->CurrentValue = HtmlDecode($this->ad_zonequartier->CurrentValue);
            }
            $this->ad_zonequartier->EditValue = HtmlEncode($this->ad_zonequartier->CurrentValue);
            $this->ad_zonequartier->PlaceHolder = RemoveHtml($this->ad_zonequartier->caption());

            // ad_section
            $this->ad_section->setupEditAttributes();
            $this->ad_section->EditCustomAttributes = "";
            if (!$this->ad_section->Raw) {
                $this->ad_section->CurrentValue = HtmlDecode($this->ad_section->CurrentValue);
            }
            $this->ad_section->EditValue = HtmlEncode($this->ad_section->CurrentValue);
            $this->ad_section->PlaceHolder = RemoveHtml($this->ad_section->caption());

            // ev_nb_toilette
            $this->ev_nb_toilette->setupEditAttributes();
            $this->ev_nb_toilette->EditCustomAttributes = "";
            $this->ev_nb_toilette->EditValue = HtmlEncode($this->ev_nb_toilette->CurrentValue);
            $this->ev_nb_toilette->PlaceHolder = RemoveHtml($this->ev_nb_toilette->caption());
            if (strval($this->ev_nb_toilette->EditValue) != "" && is_numeric($this->ev_nb_toilette->EditValue)) {
                $this->ev_nb_toilette->EditValue = FormatNumber($this->ev_nb_toilette->EditValue, null);
            }

            // ev_nb_cuisine
            $this->ev_nb_cuisine->setupEditAttributes();
            $this->ev_nb_cuisine->EditCustomAttributes = "";
            $this->ev_nb_cuisine->EditValue = HtmlEncode($this->ev_nb_cuisine->CurrentValue);
            $this->ev_nb_cuisine->PlaceHolder = RemoveHtml($this->ev_nb_cuisine->caption());
            if (strval($this->ev_nb_cuisine->EditValue) != "" && is_numeric($this->ev_nb_cuisine->EditValue)) {
                $this->ev_nb_cuisine->EditValue = FormatNumber($this->ev_nb_cuisine->EditValue, null);
            }

            // ev_nb_garage
            $this->ev_nb_garage->setupEditAttributes();
            $this->ev_nb_garage->EditCustomAttributes = "";
            $this->ev_nb_garage->EditValue = HtmlEncode($this->ev_nb_garage->CurrentValue);
            $this->ev_nb_garage->PlaceHolder = RemoveHtml($this->ev_nb_garage->caption());
            if (strval($this->ev_nb_garage->EditValue) != "" && is_numeric($this->ev_nb_garage->EditValue)) {
                $this->ev_nb_garage->EditValue = FormatNumber($this->ev_nb_garage->EditValue, null);
            }

            // ev_nb_m2
            $this->ev_nb_m2->setupEditAttributes();
            $this->ev_nb_m2->EditCustomAttributes = "";
            $this->ev_nb_m2->EditValue = HtmlEncode($this->ev_nb_m2->CurrentValue);
            $this->ev_nb_m2->PlaceHolder = RemoveHtml($this->ev_nb_m2->caption());
            if (strval($this->ev_nb_m2->EditValue) != "" && is_numeric($this->ev_nb_m2->EditValue)) {
                $this->ev_nb_m2->EditValue = FormatNumber($this->ev_nb_m2->EditValue, null);
            }

            // ev_autresalle
            $this->ev_autresalle->setupEditAttributes();
            $this->ev_autresalle->EditCustomAttributes = "";
            if (!$this->ev_autresalle->Raw) {
                $this->ev_autresalle->CurrentValue = HtmlDecode($this->ev_autresalle->CurrentValue);
            }
            $this->ev_autresalle->EditValue = HtmlEncode($this->ev_autresalle->CurrentValue);
            $this->ev_autresalle->PlaceHolder = RemoveHtml($this->ev_autresalle->caption());

            // ev_toit_tole
            $this->ev_toit_tole->setupEditAttributes();
            $this->ev_toit_tole->EditCustomAttributes = "";
            if (!$this->ev_toit_tole->Raw) {
                $this->ev_toit_tole->CurrentValue = HtmlDecode($this->ev_toit_tole->CurrentValue);
            }
            $this->ev_toit_tole->EditValue = HtmlEncode($this->ev_toit_tole->CurrentValue);
            $this->ev_toit_tole->PlaceHolder = RemoveHtml($this->ev_toit_tole->caption());

            // ev_toit_beton
            $this->ev_toit_beton->setupEditAttributes();
            $this->ev_toit_beton->EditCustomAttributes = "";
            if (!$this->ev_toit_beton->Raw) {
                $this->ev_toit_beton->CurrentValue = HtmlDecode($this->ev_toit_beton->CurrentValue);
            }
            $this->ev_toit_beton->EditValue = HtmlEncode($this->ev_toit_beton->CurrentValue);
            $this->ev_toit_beton->PlaceHolder = RemoveHtml($this->ev_toit_beton->caption());

            // ev_toit_tullles
            $this->ev_toit_tullles->setupEditAttributes();
            $this->ev_toit_tullles->EditCustomAttributes = "";
            if (!$this->ev_toit_tullles->Raw) {
                $this->ev_toit_tullles->CurrentValue = HtmlDecode($this->ev_toit_tullles->CurrentValue);
            }
            $this->ev_toit_tullles->EditValue = HtmlEncode($this->ev_toit_tullles->CurrentValue);
            $this->ev_toit_tullles->PlaceHolder = RemoveHtml($this->ev_toit_tullles->caption());

            // ev_plancher_bois
            $this->ev_plancher_bois->setupEditAttributes();
            $this->ev_plancher_bois->EditCustomAttributes = "";
            if (!$this->ev_plancher_bois->Raw) {
                $this->ev_plancher_bois->CurrentValue = HtmlDecode($this->ev_plancher_bois->CurrentValue);
            }
            $this->ev_plancher_bois->EditValue = HtmlEncode($this->ev_plancher_bois->CurrentValue);
            $this->ev_plancher_bois->PlaceHolder = RemoveHtml($this->ev_plancher_bois->caption());

            // ev_plancher_beton
            $this->ev_plancher_beton->setupEditAttributes();
            $this->ev_plancher_beton->EditCustomAttributes = "";
            if (!$this->ev_plancher_beton->Raw) {
                $this->ev_plancher_beton->CurrentValue = HtmlDecode($this->ev_plancher_beton->CurrentValue);
            }
            $this->ev_plancher_beton->EditValue = HtmlEncode($this->ev_plancher_beton->CurrentValue);
            $this->ev_plancher_beton->PlaceHolder = RemoveHtml($this->ev_plancher_beton->caption());

            // ev_plancher_mosaique
            $this->ev_plancher_mosaique->setupEditAttributes();
            $this->ev_plancher_mosaique->EditCustomAttributes = "";
            if (!$this->ev_plancher_mosaique->Raw) {
                $this->ev_plancher_mosaique->CurrentValue = HtmlDecode($this->ev_plancher_mosaique->CurrentValue);
            }
            $this->ev_plancher_mosaique->EditValue = HtmlEncode($this->ev_plancher_mosaique->CurrentValue);
            $this->ev_plancher_mosaique->PlaceHolder = RemoveHtml($this->ev_plancher_mosaique->caption());

            // ev_plancher_terazo
            $this->ev_plancher_terazo->setupEditAttributes();
            $this->ev_plancher_terazo->EditCustomAttributes = "";
            if (!$this->ev_plancher_terazo->Raw) {
                $this->ev_plancher_terazo->CurrentValue = HtmlDecode($this->ev_plancher_terazo->CurrentValue);
            }
            $this->ev_plancher_terazo->EditValue = HtmlEncode($this->ev_plancher_terazo->CurrentValue);
            $this->ev_plancher_terazo->PlaceHolder = RemoveHtml($this->ev_plancher_terazo->caption());

            // ev_plancher_ceramique
            $this->ev_plancher_ceramique->setupEditAttributes();
            $this->ev_plancher_ceramique->EditCustomAttributes = "";
            if (!$this->ev_plancher_ceramique->Raw) {
                $this->ev_plancher_ceramique->CurrentValue = HtmlDecode($this->ev_plancher_ceramique->CurrentValue);
            }
            $this->ev_plancher_ceramique->EditValue = HtmlEncode($this->ev_plancher_ceramique->CurrentValue);
            $this->ev_plancher_ceramique->PlaceHolder = RemoveHtml($this->ev_plancher_ceramique->caption());

            // est_ex_fiscal
            $this->est_ex_fiscal->setupEditAttributes();
            $this->est_ex_fiscal->EditCustomAttributes = "";
            $curVal = trim(strval($this->est_ex_fiscal->CurrentValue));
            if ($curVal != "") {
                $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->lookupCacheOption($curVal);
            } else {
                $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->Lookup !== null && is_array($this->est_ex_fiscal->lookupOptions()) ? $curVal : null;
            }
            if ($this->est_ex_fiscal->ViewValue !== null) { // Load from cache
                $this->est_ex_fiscal->EditValue = array_values($this->est_ex_fiscal->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id_ex_fiscal`" . SearchString("=", $this->est_ex_fiscal->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->est_ex_fiscal->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->est_ex_fiscal->EditValue = $arwrk;
            }
            $this->est_ex_fiscal->PlaceHolder = RemoveHtml($this->est_ex_fiscal->caption());

            // est_estimation
            $this->est_estimation->setupEditAttributes();
            $this->est_estimation->EditCustomAttributes = "";
            $this->est_estimation->EditValue = HtmlEncode($this->est_estimation->CurrentValue);
            $this->est_estimation->PlaceHolder = RemoveHtml($this->est_estimation->caption());
            if (strval($this->est_estimation->EditValue) != "" && is_numeric($this->est_estimation->EditValue)) {
                $this->est_estimation->EditValue = FormatNumber($this->est_estimation->EditValue, null);
            }

            // est_montant
            $this->est_montant->setupEditAttributes();
            $this->est_montant->EditCustomAttributes = "";
            $this->est_montant->EditValue = HtmlEncode($this->est_montant->CurrentValue);
            $this->est_montant->PlaceHolder = RemoveHtml($this->est_montant->caption());
            if (strval($this->est_montant->EditValue) != "" && is_numeric($this->est_montant->EditValue)) {
                $this->est_montant->EditValue = FormatNumber($this->est_montant->EditValue, null);
            }

            // id_owner
            $this->id_owner->EditCustomAttributes = "";
            $curVal = trim(strval($this->id_owner->CurrentValue));
            if ($curVal != "") {
                $this->id_owner->ViewValue = $this->id_owner->lookupCacheOption($curVal);
            } else {
                $this->id_owner->ViewValue = $this->id_owner->Lookup !== null && is_array($this->id_owner->lookupOptions()) ? $curVal : null;
            }
            if ($this->id_owner->ViewValue !== null) { // Load from cache
                $this->id_owner->EditValue = array_values($this->id_owner->lookupOptions());
                if ($this->id_owner->ViewValue == "") {
                    $this->id_owner->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id_owner`" . SearchString("=", $this->id_owner->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->id_owner->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->id_owner->Lookup->renderViewRow($rswrk[0]);
                    $this->id_owner->ViewValue = $this->id_owner->displayValue($arwrk);
                } else {
                    $this->id_owner->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->id_owner->EditValue = $arwrk;
            }
            $this->id_owner->PlaceHolder = RemoveHtml($this->id_owner->caption());

            // id_agent

            // localisation
            $this->localisation->setupEditAttributes();
            $this->localisation->EditCustomAttributes = "";
            if (!$this->localisation->Raw) {
                $this->localisation->CurrentValue = HtmlDecode($this->localisation->CurrentValue);
            }
            $this->localisation->EditValue = HtmlEncode($this->localisation->CurrentValue);
            $this->localisation->PlaceHolder = RemoveHtml($this->localisation->caption());

            // usage
            $this->usage->setupEditAttributes();
            $this->usage->EditCustomAttributes = "";
            $this->usage->EditValue = $this->usage->options(true);
            $this->usage->PlaceHolder = RemoveHtml($this->usage->caption());

            // Add refer script

            // descrip
            $this->descrip->LinkCustomAttributes = "";
            $this->descrip->HrefValue = "";

            // codeimmeuble
            $this->codeimmeuble->LinkCustomAttributes = "";
            $this->codeimmeuble->HrefValue = "";

            // daterecensement
            $this->daterecensement->LinkCustomAttributes = "";
            $this->daterecensement->HrefValue = "";

            // st_annee_construct
            $this->st_annee_construct->LinkCustomAttributes = "";
            $this->st_annee_construct->HrefValue = "";

            // st_propriete
            $this->st_propriete->LinkCustomAttributes = "";
            $this->st_propriete->HrefValue = "";

            // st_en_affermage
            $this->st_en_affermage->LinkCustomAttributes = "";
            $this->st_en_affermage->HrefValue = "";

            // st_en_location
            $this->st_en_location->LinkCustomAttributes = "";
            $this->st_en_location->HrefValue = "";

            // st_en_usufruit
            $this->st_en_usufruit->LinkCustomAttributes = "";
            $this->st_en_usufruit->HrefValue = "";

            // st_autre
            $this->st_autre->LinkCustomAttributes = "";
            $this->st_autre->HrefValue = "";

            // ad_rue
            $this->ad_rue->LinkCustomAttributes = "";
            $this->ad_rue->HrefValue = "";

            // ad_no_immeuble
            $this->ad_no_immeuble->LinkCustomAttributes = "";
            $this->ad_no_immeuble->HrefValue = "";

            // ad_rue_adj
            $this->ad_rue_adj->LinkCustomAttributes = "";
            $this->ad_rue_adj->HrefValue = "";

            // ad_zonequartier
            $this->ad_zonequartier->LinkCustomAttributes = "";
            $this->ad_zonequartier->HrefValue = "";

            // ad_section
            $this->ad_section->LinkCustomAttributes = "";
            $this->ad_section->HrefValue = "";

            // ev_nb_toilette
            $this->ev_nb_toilette->LinkCustomAttributes = "";
            $this->ev_nb_toilette->HrefValue = "";

            // ev_nb_cuisine
            $this->ev_nb_cuisine->LinkCustomAttributes = "";
            $this->ev_nb_cuisine->HrefValue = "";

            // ev_nb_garage
            $this->ev_nb_garage->LinkCustomAttributes = "";
            $this->ev_nb_garage->HrefValue = "";

            // ev_nb_m2
            $this->ev_nb_m2->LinkCustomAttributes = "";
            $this->ev_nb_m2->HrefValue = "";

            // ev_autresalle
            $this->ev_autresalle->LinkCustomAttributes = "";
            $this->ev_autresalle->HrefValue = "";

            // ev_toit_tole
            $this->ev_toit_tole->LinkCustomAttributes = "";
            $this->ev_toit_tole->HrefValue = "";

            // ev_toit_beton
            $this->ev_toit_beton->LinkCustomAttributes = "";
            $this->ev_toit_beton->HrefValue = "";

            // ev_toit_tullles
            $this->ev_toit_tullles->LinkCustomAttributes = "";
            $this->ev_toit_tullles->HrefValue = "";

            // ev_plancher_bois
            $this->ev_plancher_bois->LinkCustomAttributes = "";
            $this->ev_plancher_bois->HrefValue = "";

            // ev_plancher_beton
            $this->ev_plancher_beton->LinkCustomAttributes = "";
            $this->ev_plancher_beton->HrefValue = "";

            // ev_plancher_mosaique
            $this->ev_plancher_mosaique->LinkCustomAttributes = "";
            $this->ev_plancher_mosaique->HrefValue = "";

            // ev_plancher_terazo
            $this->ev_plancher_terazo->LinkCustomAttributes = "";
            $this->ev_plancher_terazo->HrefValue = "";

            // ev_plancher_ceramique
            $this->ev_plancher_ceramique->LinkCustomAttributes = "";
            $this->ev_plancher_ceramique->HrefValue = "";

            // est_ex_fiscal
            $this->est_ex_fiscal->LinkCustomAttributes = "";
            $this->est_ex_fiscal->HrefValue = "";

            // est_estimation
            $this->est_estimation->LinkCustomAttributes = "";
            $this->est_estimation->HrefValue = "";

            // est_montant
            $this->est_montant->LinkCustomAttributes = "";
            $this->est_montant->HrefValue = "";

            // id_owner
            $this->id_owner->LinkCustomAttributes = "";
            $this->id_owner->HrefValue = "";

            // id_agent
            $this->id_agent->LinkCustomAttributes = "";
            $this->id_agent->HrefValue = "";

            // localisation
            $this->localisation->LinkCustomAttributes = "";
            $this->localisation->HrefValue = "";

            // usage
            $this->usage->LinkCustomAttributes = "";
            $this->usage->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->descrip->Required) {
            if (!$this->descrip->IsDetailKey && EmptyValue($this->descrip->FormValue)) {
                $this->descrip->addErrorMessage(str_replace("%s", $this->descrip->caption(), $this->descrip->RequiredErrorMessage));
            }
        }
        if ($this->codeimmeuble->Required) {
            if (!$this->codeimmeuble->IsDetailKey && EmptyValue($this->codeimmeuble->FormValue)) {
                $this->codeimmeuble->addErrorMessage(str_replace("%s", $this->codeimmeuble->caption(), $this->codeimmeuble->RequiredErrorMessage));
            }
        }
        if ($this->daterecensement->Required) {
            if (!$this->daterecensement->IsDetailKey && EmptyValue($this->daterecensement->FormValue)) {
                $this->daterecensement->addErrorMessage(str_replace("%s", $this->daterecensement->caption(), $this->daterecensement->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->daterecensement->FormValue, $this->daterecensement->formatPattern())) {
            $this->daterecensement->addErrorMessage($this->daterecensement->getErrorMessage(false));
        }
        if ($this->st_annee_construct->Required) {
            if (!$this->st_annee_construct->IsDetailKey && EmptyValue($this->st_annee_construct->FormValue)) {
                $this->st_annee_construct->addErrorMessage(str_replace("%s", $this->st_annee_construct->caption(), $this->st_annee_construct->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->st_annee_construct->FormValue)) {
            $this->st_annee_construct->addErrorMessage($this->st_annee_construct->getErrorMessage(false));
        }
        if ($this->st_propriete->Required) {
            if (!$this->st_propriete->IsDetailKey && EmptyValue($this->st_propriete->FormValue)) {
                $this->st_propriete->addErrorMessage(str_replace("%s", $this->st_propriete->caption(), $this->st_propriete->RequiredErrorMessage));
            }
        }
        if ($this->st_en_affermage->Required) {
            if (!$this->st_en_affermage->IsDetailKey && EmptyValue($this->st_en_affermage->FormValue)) {
                $this->st_en_affermage->addErrorMessage(str_replace("%s", $this->st_en_affermage->caption(), $this->st_en_affermage->RequiredErrorMessage));
            }
        }
        if ($this->st_en_location->Required) {
            if (!$this->st_en_location->IsDetailKey && EmptyValue($this->st_en_location->FormValue)) {
                $this->st_en_location->addErrorMessage(str_replace("%s", $this->st_en_location->caption(), $this->st_en_location->RequiredErrorMessage));
            }
        }
        if ($this->st_en_usufruit->Required) {
            if (!$this->st_en_usufruit->IsDetailKey && EmptyValue($this->st_en_usufruit->FormValue)) {
                $this->st_en_usufruit->addErrorMessage(str_replace("%s", $this->st_en_usufruit->caption(), $this->st_en_usufruit->RequiredErrorMessage));
            }
        }
        if ($this->st_autre->Required) {
            if (!$this->st_autre->IsDetailKey && EmptyValue($this->st_autre->FormValue)) {
                $this->st_autre->addErrorMessage(str_replace("%s", $this->st_autre->caption(), $this->st_autre->RequiredErrorMessage));
            }
        }
        if ($this->ad_rue->Required) {
            if (!$this->ad_rue->IsDetailKey && EmptyValue($this->ad_rue->FormValue)) {
                $this->ad_rue->addErrorMessage(str_replace("%s", $this->ad_rue->caption(), $this->ad_rue->RequiredErrorMessage));
            }
        }
        if ($this->ad_no_immeuble->Required) {
            if (!$this->ad_no_immeuble->IsDetailKey && EmptyValue($this->ad_no_immeuble->FormValue)) {
                $this->ad_no_immeuble->addErrorMessage(str_replace("%s", $this->ad_no_immeuble->caption(), $this->ad_no_immeuble->RequiredErrorMessage));
            }
        }
        if ($this->ad_rue_adj->Required) {
            if (!$this->ad_rue_adj->IsDetailKey && EmptyValue($this->ad_rue_adj->FormValue)) {
                $this->ad_rue_adj->addErrorMessage(str_replace("%s", $this->ad_rue_adj->caption(), $this->ad_rue_adj->RequiredErrorMessage));
            }
        }
        if ($this->ad_zonequartier->Required) {
            if (!$this->ad_zonequartier->IsDetailKey && EmptyValue($this->ad_zonequartier->FormValue)) {
                $this->ad_zonequartier->addErrorMessage(str_replace("%s", $this->ad_zonequartier->caption(), $this->ad_zonequartier->RequiredErrorMessage));
            }
        }
        if ($this->ad_section->Required) {
            if (!$this->ad_section->IsDetailKey && EmptyValue($this->ad_section->FormValue)) {
                $this->ad_section->addErrorMessage(str_replace("%s", $this->ad_section->caption(), $this->ad_section->RequiredErrorMessage));
            }
        }
        if ($this->ev_nb_toilette->Required) {
            if (!$this->ev_nb_toilette->IsDetailKey && EmptyValue($this->ev_nb_toilette->FormValue)) {
                $this->ev_nb_toilette->addErrorMessage(str_replace("%s", $this->ev_nb_toilette->caption(), $this->ev_nb_toilette->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ev_nb_toilette->FormValue)) {
            $this->ev_nb_toilette->addErrorMessage($this->ev_nb_toilette->getErrorMessage(false));
        }
        if ($this->ev_nb_cuisine->Required) {
            if (!$this->ev_nb_cuisine->IsDetailKey && EmptyValue($this->ev_nb_cuisine->FormValue)) {
                $this->ev_nb_cuisine->addErrorMessage(str_replace("%s", $this->ev_nb_cuisine->caption(), $this->ev_nb_cuisine->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ev_nb_cuisine->FormValue)) {
            $this->ev_nb_cuisine->addErrorMessage($this->ev_nb_cuisine->getErrorMessage(false));
        }
        if ($this->ev_nb_garage->Required) {
            if (!$this->ev_nb_garage->IsDetailKey && EmptyValue($this->ev_nb_garage->FormValue)) {
                $this->ev_nb_garage->addErrorMessage(str_replace("%s", $this->ev_nb_garage->caption(), $this->ev_nb_garage->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ev_nb_garage->FormValue)) {
            $this->ev_nb_garage->addErrorMessage($this->ev_nb_garage->getErrorMessage(false));
        }
        if ($this->ev_nb_m2->Required) {
            if (!$this->ev_nb_m2->IsDetailKey && EmptyValue($this->ev_nb_m2->FormValue)) {
                $this->ev_nb_m2->addErrorMessage(str_replace("%s", $this->ev_nb_m2->caption(), $this->ev_nb_m2->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ev_nb_m2->FormValue)) {
            $this->ev_nb_m2->addErrorMessage($this->ev_nb_m2->getErrorMessage(false));
        }
        if ($this->ev_autresalle->Required) {
            if (!$this->ev_autresalle->IsDetailKey && EmptyValue($this->ev_autresalle->FormValue)) {
                $this->ev_autresalle->addErrorMessage(str_replace("%s", $this->ev_autresalle->caption(), $this->ev_autresalle->RequiredErrorMessage));
            }
        }
        if ($this->ev_toit_tole->Required) {
            if (!$this->ev_toit_tole->IsDetailKey && EmptyValue($this->ev_toit_tole->FormValue)) {
                $this->ev_toit_tole->addErrorMessage(str_replace("%s", $this->ev_toit_tole->caption(), $this->ev_toit_tole->RequiredErrorMessage));
            }
        }
        if ($this->ev_toit_beton->Required) {
            if (!$this->ev_toit_beton->IsDetailKey && EmptyValue($this->ev_toit_beton->FormValue)) {
                $this->ev_toit_beton->addErrorMessage(str_replace("%s", $this->ev_toit_beton->caption(), $this->ev_toit_beton->RequiredErrorMessage));
            }
        }
        if ($this->ev_toit_tullles->Required) {
            if (!$this->ev_toit_tullles->IsDetailKey && EmptyValue($this->ev_toit_tullles->FormValue)) {
                $this->ev_toit_tullles->addErrorMessage(str_replace("%s", $this->ev_toit_tullles->caption(), $this->ev_toit_tullles->RequiredErrorMessage));
            }
        }
        if ($this->ev_plancher_bois->Required) {
            if (!$this->ev_plancher_bois->IsDetailKey && EmptyValue($this->ev_plancher_bois->FormValue)) {
                $this->ev_plancher_bois->addErrorMessage(str_replace("%s", $this->ev_plancher_bois->caption(), $this->ev_plancher_bois->RequiredErrorMessage));
            }
        }
        if ($this->ev_plancher_beton->Required) {
            if (!$this->ev_plancher_beton->IsDetailKey && EmptyValue($this->ev_plancher_beton->FormValue)) {
                $this->ev_plancher_beton->addErrorMessage(str_replace("%s", $this->ev_plancher_beton->caption(), $this->ev_plancher_beton->RequiredErrorMessage));
            }
        }
        if ($this->ev_plancher_mosaique->Required) {
            if (!$this->ev_plancher_mosaique->IsDetailKey && EmptyValue($this->ev_plancher_mosaique->FormValue)) {
                $this->ev_plancher_mosaique->addErrorMessage(str_replace("%s", $this->ev_plancher_mosaique->caption(), $this->ev_plancher_mosaique->RequiredErrorMessage));
            }
        }
        if ($this->ev_plancher_terazo->Required) {
            if (!$this->ev_plancher_terazo->IsDetailKey && EmptyValue($this->ev_plancher_terazo->FormValue)) {
                $this->ev_plancher_terazo->addErrorMessage(str_replace("%s", $this->ev_plancher_terazo->caption(), $this->ev_plancher_terazo->RequiredErrorMessage));
            }
        }
        if ($this->ev_plancher_ceramique->Required) {
            if (!$this->ev_plancher_ceramique->IsDetailKey && EmptyValue($this->ev_plancher_ceramique->FormValue)) {
                $this->ev_plancher_ceramique->addErrorMessage(str_replace("%s", $this->ev_plancher_ceramique->caption(), $this->ev_plancher_ceramique->RequiredErrorMessage));
            }
        }
        if ($this->est_ex_fiscal->Required) {
            if (!$this->est_ex_fiscal->IsDetailKey && EmptyValue($this->est_ex_fiscal->FormValue)) {
                $this->est_ex_fiscal->addErrorMessage(str_replace("%s", $this->est_ex_fiscal->caption(), $this->est_ex_fiscal->RequiredErrorMessage));
            }
        }
        if ($this->est_estimation->Required) {
            if (!$this->est_estimation->IsDetailKey && EmptyValue($this->est_estimation->FormValue)) {
                $this->est_estimation->addErrorMessage(str_replace("%s", $this->est_estimation->caption(), $this->est_estimation->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->est_estimation->FormValue)) {
            $this->est_estimation->addErrorMessage($this->est_estimation->getErrorMessage(false));
        }
        if ($this->est_montant->Required) {
            if (!$this->est_montant->IsDetailKey && EmptyValue($this->est_montant->FormValue)) {
                $this->est_montant->addErrorMessage(str_replace("%s", $this->est_montant->caption(), $this->est_montant->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->est_montant->FormValue)) {
            $this->est_montant->addErrorMessage($this->est_montant->getErrorMessage(false));
        }
        if ($this->id_owner->Required) {
            if (!$this->id_owner->IsDetailKey && EmptyValue($this->id_owner->FormValue)) {
                $this->id_owner->addErrorMessage(str_replace("%s", $this->id_owner->caption(), $this->id_owner->RequiredErrorMessage));
            }
        }
        if ($this->id_agent->Required) {
            if (!$this->id_agent->IsDetailKey && EmptyValue($this->id_agent->FormValue)) {
                $this->id_agent->addErrorMessage(str_replace("%s", $this->id_agent->caption(), $this->id_agent->RequiredErrorMessage));
            }
        }
        if ($this->localisation->Required) {
            if (!$this->localisation->IsDetailKey && EmptyValue($this->localisation->FormValue)) {
                $this->localisation->addErrorMessage(str_replace("%s", $this->localisation->caption(), $this->localisation->RequiredErrorMessage));
            }
        }
        if ($this->usage->Required) {
            if (!$this->usage->IsDetailKey && EmptyValue($this->usage->FormValue)) {
                $this->usage->addErrorMessage(str_replace("%s", $this->usage->caption(), $this->usage->RequiredErrorMessage));
            }
        }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("PaiementGrid");
        if (in_array("paiement", $detailTblVar) && $detailPage->DetailAdd) {
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set new row
        $rsnew = [];

        // descrip
        $this->descrip->setDbValueDef($rsnew, $this->descrip->CurrentValue, null, false);

        // codeimmeuble
        $this->codeimmeuble->setDbValueDef($rsnew, $this->codeimmeuble->CurrentValue, null, false);

        // daterecensement
        $this->daterecensement->setDbValueDef($rsnew, UnFormatDateTime($this->daterecensement->CurrentValue, $this->daterecensement->formatPattern()), null, false);

        // st_annee_construct
        $this->st_annee_construct->setDbValueDef($rsnew, $this->st_annee_construct->CurrentValue, null, false);

        // st_propriete
        $this->st_propriete->setDbValueDef($rsnew, $this->st_propriete->CurrentValue, null, false);

        // st_en_affermage
        $this->st_en_affermage->setDbValueDef($rsnew, $this->st_en_affermage->CurrentValue, null, false);

        // st_en_location
        $this->st_en_location->setDbValueDef($rsnew, $this->st_en_location->CurrentValue, null, false);

        // st_en_usufruit
        $this->st_en_usufruit->setDbValueDef($rsnew, $this->st_en_usufruit->CurrentValue, null, false);

        // st_autre
        $this->st_autre->setDbValueDef($rsnew, $this->st_autre->CurrentValue, null, false);

        // ad_rue
        $this->ad_rue->setDbValueDef($rsnew, $this->ad_rue->CurrentValue, null, false);

        // ad_no_immeuble
        $this->ad_no_immeuble->setDbValueDef($rsnew, $this->ad_no_immeuble->CurrentValue, null, false);

        // ad_rue_adj
        $this->ad_rue_adj->setDbValueDef($rsnew, $this->ad_rue_adj->CurrentValue, null, false);

        // ad_zonequartier
        $this->ad_zonequartier->setDbValueDef($rsnew, $this->ad_zonequartier->CurrentValue, null, false);

        // ad_section
        $this->ad_section->setDbValueDef($rsnew, $this->ad_section->CurrentValue, null, false);

        // ev_nb_toilette
        $this->ev_nb_toilette->setDbValueDef($rsnew, $this->ev_nb_toilette->CurrentValue, null, false);

        // ev_nb_cuisine
        $this->ev_nb_cuisine->setDbValueDef($rsnew, $this->ev_nb_cuisine->CurrentValue, null, false);

        // ev_nb_garage
        $this->ev_nb_garage->setDbValueDef($rsnew, $this->ev_nb_garage->CurrentValue, null, false);

        // ev_nb_m2
        $this->ev_nb_m2->setDbValueDef($rsnew, $this->ev_nb_m2->CurrentValue, null, false);

        // ev_autresalle
        $this->ev_autresalle->setDbValueDef($rsnew, $this->ev_autresalle->CurrentValue, null, false);

        // ev_toit_tole
        $this->ev_toit_tole->setDbValueDef($rsnew, $this->ev_toit_tole->CurrentValue, null, false);

        // ev_toit_beton
        $this->ev_toit_beton->setDbValueDef($rsnew, $this->ev_toit_beton->CurrentValue, null, false);

        // ev_toit_tullles
        $this->ev_toit_tullles->setDbValueDef($rsnew, $this->ev_toit_tullles->CurrentValue, null, false);

        // ev_plancher_bois
        $this->ev_plancher_bois->setDbValueDef($rsnew, $this->ev_plancher_bois->CurrentValue, null, false);

        // ev_plancher_beton
        $this->ev_plancher_beton->setDbValueDef($rsnew, $this->ev_plancher_beton->CurrentValue, null, false);

        // ev_plancher_mosaique
        $this->ev_plancher_mosaique->setDbValueDef($rsnew, $this->ev_plancher_mosaique->CurrentValue, null, false);

        // ev_plancher_terazo
        $this->ev_plancher_terazo->setDbValueDef($rsnew, $this->ev_plancher_terazo->CurrentValue, null, false);

        // ev_plancher_ceramique
        $this->ev_plancher_ceramique->setDbValueDef($rsnew, $this->ev_plancher_ceramique->CurrentValue, null, false);

        // est_ex_fiscal
        $this->est_ex_fiscal->setDbValueDef($rsnew, $this->est_ex_fiscal->CurrentValue, null, false);

        // est_estimation
        $this->est_estimation->setDbValueDef($rsnew, $this->est_estimation->CurrentValue, null, false);

        // est_montant
        $this->est_montant->setDbValueDef($rsnew, $this->est_montant->CurrentValue, null, false);

        // id_owner
        $this->id_owner->setDbValueDef($rsnew, $this->id_owner->CurrentValue, 0, false);

        // id_agent
        $this->id_agent->CurrentValue = CurrentUserID();
        $this->id_agent->setDbValueDef($rsnew, $this->id_agent->CurrentValue, 0);

        // localisation
        $this->localisation->setDbValueDef($rsnew, $this->localisation->CurrentValue, null, false);

        // usage
        $this->usage->setDbValueDef($rsnew, $this->usage->CurrentValue, null, false);

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Load db values from old row
        $this->loadDbValues($rsold);
        if ($rsold) {
        }

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("PaiementGrid");
            if (in_array("paiement", $detailTblVar) && $detailPage->DetailAdd) {
                $detailPage->id_immeuble->setSessionValue($this->id_immeuble->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "paiement"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->id_immeuble->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                if ($this->UseTransaction) { // Commit transaction
                    $conn->commit();
                }
            } else {
                if ($this->UseTransaction) { // Rollback transaction
                    $conn->rollback();
                }
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($addRow) {
        }

        // Write JSON for API request
        if (IsApi() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $addRow;
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->id_agent->CurrentValue);
        }
        return true;
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("paiement", $detailTblVar)) {
                $detailPageObj = Container("PaiementGrid");
                if ($detailPageObj->DetailAdd) {
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->id_immeuble->IsDetailKey = true;
                    $detailPageObj->id_immeuble->CurrentValue = $this->id_immeuble->CurrentValue;
                    $detailPageObj->id_immeuble->setSessionValue($detailPageObj->id_immeuble->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ImmeubleList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_est_ex_fiscal":
                    break;
                case "x_id_owner":
                    break;
                case "x_id_agent":
                    break;
                case "x_usage":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $ar[strval($row["lf"])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
        if(CurrentUserLevel()!=2) 
                {
                    $this->est_ex_fiscal->Disabled=true;
                    $this->est_estimation->Disabled=true;
                   $this->est_montant->Disabled=true;
                }    
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
