<?php

namespace PHPMaker2022\cfpb;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for immeuble
 */
class Immeuble extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Export
    public $ExportDoc;

    // Fields
    public $id_immeuble;
    public $descrip;
    public $codeimmeuble;
    public $daterecensement;
    public $st_annee_construct;
    public $st_propriete;
    public $st_en_affermage;
    public $st_en_location;
    public $st_en_usufruit;
    public $st_autre;
    public $ad_rue;
    public $ad_no_immeuble;
    public $ad_rue_adj;
    public $ad_zonequartier;
    public $ad_section;
    public $ev_nb_toilette;
    public $ev_nb_cuisine;
    public $ev_nb_garage;
    public $ev_nb_m2;
    public $ev_autresalle;
    public $ev_toit_tole;
    public $ev_toit_beton;
    public $ev_toit_tullles;
    public $ev_plancher_bois;
    public $ev_plancher_beton;
    public $ev_plancher_mosaique;
    public $ev_plancher_terazo;
    public $ev_plancher_ceramique;
    public $est_ex_fiscal;
    public $est_estimation;
    public $est_montant;
    public $id_owner;
    public $id_agent;
    public $localisation;
    public $usage;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage, $CurrentLocale;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'immeuble';
        $this->TableName = 'immeuble';
        $this->TableType = 'TABLE';

        // Update Table
        $this->UpdateTable = "`immeuble`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "landscape"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
        $this->ExportWordVersion = 12; // Word version (PHPWord only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // id_immeuble
        $this->id_immeuble = new DbField(
            'immeuble',
            'immeuble',
            'x_id_immeuble',
            'id_immeuble',
            '`id_immeuble`',
            '`id_immeuble`',
            3,
            11,
            -1,
            false,
            '`id_immeuble`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'NO'
        );
        $this->id_immeuble->InputTextType = "text";
        $this->id_immeuble->IsAutoIncrement = true; // Autoincrement field
        $this->id_immeuble->IsPrimaryKey = true; // Primary key field
        $this->id_immeuble->IsForeignKey = true; // Foreign key field
        $this->id_immeuble->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['id_immeuble'] = &$this->id_immeuble;

        // descrip
        $this->descrip = new DbField(
            'immeuble',
            'immeuble',
            'x_descrip',
            'descrip',
            '`descrip`',
            '`descrip`',
            201,
            65535,
            -1,
            false,
            '`descrip`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXTAREA'
        );
        $this->descrip->InputTextType = "text";
        $this->Fields['descrip'] = &$this->descrip;

        // codeimmeuble
        $this->codeimmeuble = new DbField(
            'immeuble',
            'immeuble',
            'x_codeimmeuble',
            'codeimmeuble',
            '`codeimmeuble`',
            '`codeimmeuble`',
            200,
            50,
            -1,
            false,
            '`codeimmeuble`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->codeimmeuble->InputTextType = "text";
        $this->codeimmeuble->Required = true; // Required field
        $this->Fields['codeimmeuble'] = &$this->codeimmeuble;

        // daterecensement
        $this->daterecensement = new DbField(
            'immeuble',
            'immeuble',
            'x_daterecensement',
            'daterecensement',
            '`daterecensement`',
            CastDateFieldForLike("`daterecensement`", 7, "DB"),
            135,
            19,
            7,
            false,
            '`daterecensement`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->daterecensement->InputTextType = "text";
        $this->daterecensement->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->Fields['daterecensement'] = &$this->daterecensement;

        // st_annee_construct
        $this->st_annee_construct = new DbField(
            'immeuble',
            'immeuble',
            'x_st_annee_construct',
            'st_annee_construct',
            '`st_annee_construct`',
            '`st_annee_construct`',
            3,
            11,
            2,
            false,
            '`st_annee_construct`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->st_annee_construct->InputTextType = "text";
        $this->st_annee_construct->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['st_annee_construct'] = &$this->st_annee_construct;

        // st_propriete
        $this->st_propriete = new DbField(
            'immeuble',
            'immeuble',
            'x_st_propriete',
            'st_propriete',
            '`st_propriete`',
            '`st_propriete`',
            200,
            50,
            -1,
            false,
            '`st_propriete`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->st_propriete->InputTextType = "text";
        $this->Fields['st_propriete'] = &$this->st_propriete;

        // st_en_affermage
        $this->st_en_affermage = new DbField(
            'immeuble',
            'immeuble',
            'x_st_en_affermage',
            'st_en_affermage',
            '`st_en_affermage`',
            '`st_en_affermage`',
            200,
            50,
            -1,
            false,
            '`st_en_affermage`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->st_en_affermage->InputTextType = "text";
        $this->Fields['st_en_affermage'] = &$this->st_en_affermage;

        // st_en_location
        $this->st_en_location = new DbField(
            'immeuble',
            'immeuble',
            'x_st_en_location',
            'st_en_location',
            '`st_en_location`',
            '`st_en_location`',
            200,
            50,
            -1,
            false,
            '`st_en_location`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->st_en_location->InputTextType = "text";
        $this->Fields['st_en_location'] = &$this->st_en_location;

        // st_en_usufruit
        $this->st_en_usufruit = new DbField(
            'immeuble',
            'immeuble',
            'x_st_en_usufruit',
            'st_en_usufruit',
            '`st_en_usufruit`',
            '`st_en_usufruit`',
            200,
            50,
            -1,
            false,
            '`st_en_usufruit`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->st_en_usufruit->InputTextType = "text";
        $this->Fields['st_en_usufruit'] = &$this->st_en_usufruit;

        // st_autre
        $this->st_autre = new DbField(
            'immeuble',
            'immeuble',
            'x_st_autre',
            'st_autre',
            '`st_autre`',
            '`st_autre`',
            200,
            50,
            -1,
            false,
            '`st_autre`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->st_autre->InputTextType = "text";
        $this->Fields['st_autre'] = &$this->st_autre;

        // ad_rue
        $this->ad_rue = new DbField(
            'immeuble',
            'immeuble',
            'x_ad_rue',
            'ad_rue',
            '`ad_rue`',
            '`ad_rue`',
            200,
            70,
            -1,
            false,
            '`ad_rue`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ad_rue->InputTextType = "text";
        $this->Fields['ad_rue'] = &$this->ad_rue;

        // ad_no_immeuble
        $this->ad_no_immeuble = new DbField(
            'immeuble',
            'immeuble',
            'x_ad_no_immeuble',
            'ad_no_immeuble',
            '`ad_no_immeuble`',
            '`ad_no_immeuble`',
            200,
            50,
            -1,
            false,
            '`ad_no_immeuble`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ad_no_immeuble->InputTextType = "text";
        $this->Fields['ad_no_immeuble'] = &$this->ad_no_immeuble;

        // ad_rue_adj
        $this->ad_rue_adj = new DbField(
            'immeuble',
            'immeuble',
            'x_ad_rue_adj',
            'ad_rue_adj',
            '`ad_rue_adj`',
            '`ad_rue_adj`',
            200,
            70,
            -1,
            false,
            '`ad_rue_adj`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ad_rue_adj->InputTextType = "text";
        $this->Fields['ad_rue_adj'] = &$this->ad_rue_adj;

        // ad_zonequartier
        $this->ad_zonequartier = new DbField(
            'immeuble',
            'immeuble',
            'x_ad_zonequartier',
            'ad_zonequartier',
            '`ad_zonequartier`',
            '`ad_zonequartier`',
            200,
            70,
            -1,
            false,
            '`ad_zonequartier`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ad_zonequartier->InputTextType = "text";
        $this->Fields['ad_zonequartier'] = &$this->ad_zonequartier;

        // ad_section
        $this->ad_section = new DbField(
            'immeuble',
            'immeuble',
            'x_ad_section',
            'ad_section',
            '`ad_section`',
            '`ad_section`',
            200,
            70,
            -1,
            false,
            '`ad_section`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ad_section->InputTextType = "text";
        $this->Fields['ad_section'] = &$this->ad_section;

        // ev_nb_toilette
        $this->ev_nb_toilette = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_nb_toilette',
            'ev_nb_toilette',
            '`ev_nb_toilette`',
            '`ev_nb_toilette`',
            3,
            11,
            -1,
            false,
            '`ev_nb_toilette`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_nb_toilette->InputTextType = "text";
        $this->ev_nb_toilette->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['ev_nb_toilette'] = &$this->ev_nb_toilette;

        // ev_nb_cuisine
        $this->ev_nb_cuisine = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_nb_cuisine',
            'ev_nb_cuisine',
            '`ev_nb_cuisine`',
            '`ev_nb_cuisine`',
            3,
            11,
            -1,
            false,
            '`ev_nb_cuisine`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_nb_cuisine->InputTextType = "text";
        $this->ev_nb_cuisine->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['ev_nb_cuisine'] = &$this->ev_nb_cuisine;

        // ev_nb_garage
        $this->ev_nb_garage = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_nb_garage',
            'ev_nb_garage',
            '`ev_nb_garage`',
            '`ev_nb_garage`',
            3,
            11,
            -1,
            false,
            '`ev_nb_garage`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_nb_garage->InputTextType = "text";
        $this->ev_nb_garage->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['ev_nb_garage'] = &$this->ev_nb_garage;

        // ev_nb_m2
        $this->ev_nb_m2 = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_nb_m2',
            'ev_nb_m2',
            '`ev_nb_m2`',
            '`ev_nb_m2`',
            3,
            11,
            -1,
            false,
            '`ev_nb_m2`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_nb_m2->InputTextType = "text";
        $this->ev_nb_m2->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['ev_nb_m2'] = &$this->ev_nb_m2;

        // ev_autresalle
        $this->ev_autresalle = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_autresalle',
            'ev_autresalle',
            '`ev_autresalle`',
            '`ev_autresalle`',
            200,
            50,
            -1,
            false,
            '`ev_autresalle`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_autresalle->InputTextType = "text";
        $this->Fields['ev_autresalle'] = &$this->ev_autresalle;

        // ev_toit_tole
        $this->ev_toit_tole = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_toit_tole',
            'ev_toit_tole',
            '`ev_toit_tole`',
            '`ev_toit_tole`',
            200,
            50,
            -1,
            false,
            '`ev_toit_tole`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_toit_tole->InputTextType = "text";
        $this->Fields['ev_toit_tole'] = &$this->ev_toit_tole;

        // ev_toit_beton
        $this->ev_toit_beton = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_toit_beton',
            'ev_toit_beton',
            '`ev_toit_beton`',
            '`ev_toit_beton`',
            200,
            50,
            -1,
            false,
            '`ev_toit_beton`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_toit_beton->InputTextType = "text";
        $this->Fields['ev_toit_beton'] = &$this->ev_toit_beton;

        // ev_toit_tullles
        $this->ev_toit_tullles = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_toit_tullles',
            'ev_toit_tullles',
            '`ev_toit_tullles`',
            '`ev_toit_tullles`',
            200,
            50,
            -1,
            false,
            '`ev_toit_tullles`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_toit_tullles->InputTextType = "text";
        $this->Fields['ev_toit_tullles'] = &$this->ev_toit_tullles;

        // ev_plancher_bois
        $this->ev_plancher_bois = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_plancher_bois',
            'ev_plancher_bois',
            '`ev_plancher_bois`',
            '`ev_plancher_bois`',
            200,
            50,
            -1,
            false,
            '`ev_plancher_bois`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_plancher_bois->InputTextType = "text";
        $this->Fields['ev_plancher_bois'] = &$this->ev_plancher_bois;

        // ev_plancher_beton
        $this->ev_plancher_beton = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_plancher_beton',
            'ev_plancher_beton',
            '`ev_plancher_beton`',
            '`ev_plancher_beton`',
            200,
            50,
            -1,
            false,
            '`ev_plancher_beton`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_plancher_beton->InputTextType = "text";
        $this->Fields['ev_plancher_beton'] = &$this->ev_plancher_beton;

        // ev_plancher_mosaique
        $this->ev_plancher_mosaique = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_plancher_mosaique',
            'ev_plancher_mosaique',
            '`ev_plancher_mosaique`',
            '`ev_plancher_mosaique`',
            200,
            50,
            -1,
            false,
            '`ev_plancher_mosaique`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_plancher_mosaique->InputTextType = "text";
        $this->Fields['ev_plancher_mosaique'] = &$this->ev_plancher_mosaique;

        // ev_plancher_terazo
        $this->ev_plancher_terazo = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_plancher_terazo',
            'ev_plancher_terazo',
            '`ev_plancher_terazo`',
            '`ev_plancher_terazo`',
            200,
            50,
            -1,
            false,
            '`ev_plancher_terazo`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_plancher_terazo->InputTextType = "text";
        $this->Fields['ev_plancher_terazo'] = &$this->ev_plancher_terazo;

        // ev_plancher_ceramique
        $this->ev_plancher_ceramique = new DbField(
            'immeuble',
            'immeuble',
            'x_ev_plancher_ceramique',
            'ev_plancher_ceramique',
            '`ev_plancher_ceramique`',
            '`ev_plancher_ceramique`',
            200,
            50,
            -1,
            false,
            '`ev_plancher_ceramique`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->ev_plancher_ceramique->InputTextType = "text";
        $this->Fields['ev_plancher_ceramique'] = &$this->ev_plancher_ceramique;

        // est_ex_fiscal
        $this->est_ex_fiscal = new DbField(
            'immeuble',
            'immeuble',
            'x_est_ex_fiscal',
            'est_ex_fiscal',
            '`est_ex_fiscal`',
            '`est_ex_fiscal`',
            200,
            50,
            -1,
            false,
            '`est_ex_fiscal`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'SELECT'
        );
        $this->est_ex_fiscal->InputTextType = "text";
        $this->est_ex_fiscal->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->est_ex_fiscal->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->est_ex_fiscal->Lookup = new Lookup('est_ex_fiscal', 'ex_fiscal', false, 'id_ex_fiscal', ["title","","",""], [], [], [], [], [], [], '', '', "`title`");
                break;
            default:
                $this->est_ex_fiscal->Lookup = new Lookup('est_ex_fiscal', 'ex_fiscal', false, 'id_ex_fiscal', ["title","","",""], [], [], [], [], [], [], '', '', "`title`");
                break;
        }
        $this->Fields['est_ex_fiscal'] = &$this->est_ex_fiscal;

        // est_estimation
        $this->est_estimation = new DbField(
            'immeuble',
            'immeuble',
            'x_est_estimation',
            'est_estimation',
            '`est_estimation`',
            '`est_estimation`',
            131,
            15,
            -1,
            false,
            '`est_estimation`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->est_estimation->InputTextType = "text";
        $this->est_estimation->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['est_estimation'] = &$this->est_estimation;

        // est_montant
        $this->est_montant = new DbField(
            'immeuble',
            'immeuble',
            'x_est_montant',
            'est_montant',
            '`est_montant`',
            '`est_montant`',
            131,
            15,
            -1,
            false,
            '`est_montant`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->est_montant->InputTextType = "text";
        $this->est_montant->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Fields['est_montant'] = &$this->est_montant;

        // id_owner
        $this->id_owner = new DbField(
            'immeuble',
            'immeuble',
            'x_id_owner',
            'id_owner',
            '`id_owner`',
            '`id_owner`',
            3,
            11,
            -1,
            false,
            '`id_owner`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'SELECT'
        );
        $this->id_owner->InputTextType = "text";
        $this->id_owner->Nullable = false; // NOT NULL field
        $this->id_owner->Required = true; // Required field
        $this->id_owner->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->id_owner->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->id_owner->Lookup = new Lookup('id_owner', 'owner', false, 'id_owner', ["nom_pro","prenom_pro","nif",""], [], [], [], [], [], [], '', '<div><span>{{:df}} {{:df2}} <br><small class="text-muted">({{:df3}})</small></span></div>', "CONCAT(COALESCE(`nom_pro`, ''),'" . ValueSeparator(1, $this->id_owner) . "',COALESCE(`prenom_pro`,''),'" . ValueSeparator(2, $this->id_owner) . "',COALESCE(`nif`,''))");
                break;
            default:
                $this->id_owner->Lookup = new Lookup('id_owner', 'owner', false, 'id_owner', ["nom_pro","prenom_pro","nif",""], [], [], [], [], [], [], '', '<div><span>{{:df}} {{:df2}} <br><small class="text-muted">({{:df3}})</small></span></div>', "CONCAT(COALESCE(`nom_pro`, ''),'" . ValueSeparator(1, $this->id_owner) . "',COALESCE(`prenom_pro`,''),'" . ValueSeparator(2, $this->id_owner) . "',COALESCE(`nif`,''))");
                break;
        }
        $this->id_owner->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['id_owner'] = &$this->id_owner;

        // id_agent
        $this->id_agent = new DbField(
            'immeuble',
            'immeuble',
            'x_id_agent',
            'id_agent',
            '`id_agent`',
            '`id_agent`',
            3,
            11,
            -1,
            false,
            '`id_agent`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'SELECT'
        );
        $this->id_agent->InputTextType = "text";
        $this->id_agent->Nullable = false; // NOT NULL field
        $this->id_agent->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->id_agent->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->id_agent->Lookup = new Lookup('id_agent', 'agent', true, 'id_agent', ["LastName","FirstName","",""], [], [], [], [], [], [], '', '', "CONCAT(COALESCE(`LastName`, ''),'" . ValueSeparator(1, $this->id_agent) . "',COALESCE(`FirstName`,''))");
                break;
            default:
                $this->id_agent->Lookup = new Lookup('id_agent', 'agent', true, 'id_agent', ["LastName","FirstName","",""], [], [], [], [], [], [], '', '', "CONCAT(COALESCE(`LastName`, ''),'" . ValueSeparator(1, $this->id_agent) . "',COALESCE(`FirstName`,''))");
                break;
        }
        $this->id_agent->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Fields['id_agent'] = &$this->id_agent;

        // localisation
        $this->localisation = new DbField(
            'immeuble',
            'immeuble',
            'x_localisation',
            'localisation',
            '`localisation`',
            '`localisation`',
            200,
            70,
            -1,
            false,
            '`localisation`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'TEXT'
        );
        $this->localisation->InputTextType = "text";
        $this->Fields['localisation'] = &$this->localisation;

        // usage
        $this->usage = new DbField(
            'immeuble',
            'immeuble',
            'x_usage',
            'usage',
            '`usage`',
            '`usage`',
            200,
            255,
            -1,
            false,
            '`usage`',
            false,
            false,
            false,
            'FORMATTED TEXT',
            'SELECT'
        );
        $this->usage->InputTextType = "text";
        $this->usage->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->usage->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en-US":
                $this->usage->Lookup = new Lookup('usage', 'immeuble', false, '', ["","","",""], [], [], [], [], [], [], '', '', "");
                break;
            default:
                $this->usage->Lookup = new Lookup('usage', 'immeuble', false, '', ["","","",""], [], [], [], [], [], [], '', '', "");
                break;
        }
        $this->usage->OptionCount = 5;
        $this->Fields['usage'] = &$this->usage;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE"));
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "paiement") {
            $detailUrl = Container("paiement")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id_immeuble", $this->id_immeuble->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "ImmeubleList";
        }
        return $detailUrl;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`immeuble`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            $filter = $this->addUserIDFilter($filter, $id);
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
            // Get insert id if necessary
            $this->id_immeuble->setDbValue($conn->lastInsertId());
            $rs['id_immeuble'] = $this->id_immeuble->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id_immeuble', $rs)) {
                AddFilter($where, QuotedName('id_immeuble', $this->Dbid) . '=' . QuotedValue($rs['id_immeuble'], $this->id_immeuble->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id_immeuble->DbValue = $row['id_immeuble'];
        $this->descrip->DbValue = $row['descrip'];
        $this->codeimmeuble->DbValue = $row['codeimmeuble'];
        $this->daterecensement->DbValue = $row['daterecensement'];
        $this->st_annee_construct->DbValue = $row['st_annee_construct'];
        $this->st_propriete->DbValue = $row['st_propriete'];
        $this->st_en_affermage->DbValue = $row['st_en_affermage'];
        $this->st_en_location->DbValue = $row['st_en_location'];
        $this->st_en_usufruit->DbValue = $row['st_en_usufruit'];
        $this->st_autre->DbValue = $row['st_autre'];
        $this->ad_rue->DbValue = $row['ad_rue'];
        $this->ad_no_immeuble->DbValue = $row['ad_no_immeuble'];
        $this->ad_rue_adj->DbValue = $row['ad_rue_adj'];
        $this->ad_zonequartier->DbValue = $row['ad_zonequartier'];
        $this->ad_section->DbValue = $row['ad_section'];
        $this->ev_nb_toilette->DbValue = $row['ev_nb_toilette'];
        $this->ev_nb_cuisine->DbValue = $row['ev_nb_cuisine'];
        $this->ev_nb_garage->DbValue = $row['ev_nb_garage'];
        $this->ev_nb_m2->DbValue = $row['ev_nb_m2'];
        $this->ev_autresalle->DbValue = $row['ev_autresalle'];
        $this->ev_toit_tole->DbValue = $row['ev_toit_tole'];
        $this->ev_toit_beton->DbValue = $row['ev_toit_beton'];
        $this->ev_toit_tullles->DbValue = $row['ev_toit_tullles'];
        $this->ev_plancher_bois->DbValue = $row['ev_plancher_bois'];
        $this->ev_plancher_beton->DbValue = $row['ev_plancher_beton'];
        $this->ev_plancher_mosaique->DbValue = $row['ev_plancher_mosaique'];
        $this->ev_plancher_terazo->DbValue = $row['ev_plancher_terazo'];
        $this->ev_plancher_ceramique->DbValue = $row['ev_plancher_ceramique'];
        $this->est_ex_fiscal->DbValue = $row['est_ex_fiscal'];
        $this->est_estimation->DbValue = $row['est_estimation'];
        $this->est_montant->DbValue = $row['est_montant'];
        $this->id_owner->DbValue = $row['id_owner'];
        $this->id_agent->DbValue = $row['id_agent'];
        $this->localisation->DbValue = $row['localisation'];
        $this->usage->DbValue = $row['usage'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id_immeuble` = @id_immeuble@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->id_immeuble->CurrentValue : $this->id_immeuble->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id_immeuble->CurrentValue = $keys[0];
            } else {
                $this->id_immeuble->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id_immeuble', $row) ? $row['id_immeuble'] : null;
        } else {
            $val = $this->id_immeuble->OldValue !== null ? $this->id_immeuble->OldValue : $this->id_immeuble->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id_immeuble@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("ImmeubleList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "ImmeubleView") {
            return $Language->phrase("View");
        } elseif ($pageName == "ImmeubleEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "ImmeubleAdd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "ImmeubleView";
            case Config("API_ADD_ACTION"):
                return "ImmeubleAdd";
            case Config("API_EDIT_ACTION"):
                return "ImmeubleEdit";
            case Config("API_DELETE_ACTION"):
                return "ImmeubleDelete";
            case Config("API_LIST_ACTION"):
                return "ImmeubleList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "ImmeubleList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ImmeubleView", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("ImmeubleView", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "ImmeubleAdd?" . $this->getUrlParm($parm);
        } else {
            $url = "ImmeubleAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ImmeubleEdit", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("ImmeubleEdit", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ImmeubleAdd", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("ImmeubleAdd", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("ImmeubleDelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id_immeuble\":" . JsonEncode($this->id_immeuble->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id_immeuble->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id_immeuble->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("id_immeuble") ?? Route("id_immeuble")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id_immeuble->CurrentValue = $key;
            } else {
                $this->id_immeuble->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id_immeuble->setDbValue($row['id_immeuble']);
        $this->descrip->setDbValue($row['descrip']);
        $this->codeimmeuble->setDbValue($row['codeimmeuble']);
        $this->daterecensement->setDbValue($row['daterecensement']);
        $this->st_annee_construct->setDbValue($row['st_annee_construct']);
        $this->st_propriete->setDbValue($row['st_propriete']);
        $this->st_en_affermage->setDbValue($row['st_en_affermage']);
        $this->st_en_location->setDbValue($row['st_en_location']);
        $this->st_en_usufruit->setDbValue($row['st_en_usufruit']);
        $this->st_autre->setDbValue($row['st_autre']);
        $this->ad_rue->setDbValue($row['ad_rue']);
        $this->ad_no_immeuble->setDbValue($row['ad_no_immeuble']);
        $this->ad_rue_adj->setDbValue($row['ad_rue_adj']);
        $this->ad_zonequartier->setDbValue($row['ad_zonequartier']);
        $this->ad_section->setDbValue($row['ad_section']);
        $this->ev_nb_toilette->setDbValue($row['ev_nb_toilette']);
        $this->ev_nb_cuisine->setDbValue($row['ev_nb_cuisine']);
        $this->ev_nb_garage->setDbValue($row['ev_nb_garage']);
        $this->ev_nb_m2->setDbValue($row['ev_nb_m2']);
        $this->ev_autresalle->setDbValue($row['ev_autresalle']);
        $this->ev_toit_tole->setDbValue($row['ev_toit_tole']);
        $this->ev_toit_beton->setDbValue($row['ev_toit_beton']);
        $this->ev_toit_tullles->setDbValue($row['ev_toit_tullles']);
        $this->ev_plancher_bois->setDbValue($row['ev_plancher_bois']);
        $this->ev_plancher_beton->setDbValue($row['ev_plancher_beton']);
        $this->ev_plancher_mosaique->setDbValue($row['ev_plancher_mosaique']);
        $this->ev_plancher_terazo->setDbValue($row['ev_plancher_terazo']);
        $this->ev_plancher_ceramique->setDbValue($row['ev_plancher_ceramique']);
        $this->est_ex_fiscal->setDbValue($row['est_ex_fiscal']);
        $this->est_estimation->setDbValue($row['est_estimation']);
        $this->est_montant->setDbValue($row['est_montant']);
        $this->id_owner->setDbValue($row['id_owner']);
        $this->id_agent->setDbValue($row['id_agent']);
        $this->localisation->setDbValue($row['localisation']);
        $this->usage->setDbValue($row['usage']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id_immeuble

        // descrip

        // codeimmeuble

        // daterecensement

        // st_annee_construct

        // st_propriete

        // st_en_affermage

        // st_en_location

        // st_en_usufruit

        // st_autre

        // ad_rue

        // ad_no_immeuble

        // ad_rue_adj

        // ad_zonequartier

        // ad_section

        // ev_nb_toilette

        // ev_nb_cuisine

        // ev_nb_garage

        // ev_nb_m2

        // ev_autresalle

        // ev_toit_tole

        // ev_toit_beton

        // ev_toit_tullles

        // ev_plancher_bois

        // ev_plancher_beton

        // ev_plancher_mosaique

        // ev_plancher_terazo

        // ev_plancher_ceramique

        // est_ex_fiscal

        // est_estimation

        // est_montant

        // id_owner
        $this->id_owner->CellCssStyle = "white-space: nowrap;";

        // id_agent

        // localisation

        // usage

        // id_immeuble
        $this->id_immeuble->ViewValue = $this->id_immeuble->CurrentValue;
        $this->id_immeuble->ViewCustomAttributes = "";

        // descrip
        $this->descrip->ViewValue = $this->descrip->CurrentValue;
        $this->descrip->ViewCustomAttributes = "";

        // codeimmeuble
        $this->codeimmeuble->ViewValue = $this->codeimmeuble->CurrentValue;
        $this->codeimmeuble->ViewCustomAttributes = "";

        // daterecensement
        $this->daterecensement->ViewValue = $this->daterecensement->CurrentValue;
        $this->daterecensement->ViewValue = FormatDateTime($this->daterecensement->ViewValue, $this->daterecensement->formatPattern());
        $this->daterecensement->ViewCustomAttributes = "";

        // st_annee_construct
        $this->st_annee_construct->ViewValue = $this->st_annee_construct->CurrentValue;
        $this->st_annee_construct->ViewCustomAttributes = "";

        // st_propriete
        $this->st_propriete->ViewValue = $this->st_propriete->CurrentValue;
        $this->st_propriete->ViewCustomAttributes = "";

        // st_en_affermage
        $this->st_en_affermage->ViewValue = $this->st_en_affermage->CurrentValue;
        $this->st_en_affermage->ViewCustomAttributes = "";

        // st_en_location
        $this->st_en_location->ViewValue = $this->st_en_location->CurrentValue;
        $this->st_en_location->ViewCustomAttributes = "";

        // st_en_usufruit
        $this->st_en_usufruit->ViewValue = $this->st_en_usufruit->CurrentValue;
        $this->st_en_usufruit->ViewCustomAttributes = "";

        // st_autre
        $this->st_autre->ViewValue = $this->st_autre->CurrentValue;
        $this->st_autre->ViewCustomAttributes = "";

        // ad_rue
        $this->ad_rue->ViewValue = $this->ad_rue->CurrentValue;
        $this->ad_rue->ViewCustomAttributes = "";

        // ad_no_immeuble
        $this->ad_no_immeuble->ViewValue = $this->ad_no_immeuble->CurrentValue;
        $this->ad_no_immeuble->ViewCustomAttributes = "";

        // ad_rue_adj
        $this->ad_rue_adj->ViewValue = $this->ad_rue_adj->CurrentValue;
        $this->ad_rue_adj->ViewCustomAttributes = "";

        // ad_zonequartier
        $this->ad_zonequartier->ViewValue = $this->ad_zonequartier->CurrentValue;
        $this->ad_zonequartier->ViewCustomAttributes = "";

        // ad_section
        $this->ad_section->ViewValue = $this->ad_section->CurrentValue;
        $this->ad_section->ViewCustomAttributes = "";

        // ev_nb_toilette
        $this->ev_nb_toilette->ViewValue = $this->ev_nb_toilette->CurrentValue;
        $this->ev_nb_toilette->ViewValue = FormatNumber($this->ev_nb_toilette->ViewValue, $this->ev_nb_toilette->formatPattern());
        $this->ev_nb_toilette->ViewCustomAttributes = "";

        // ev_nb_cuisine
        $this->ev_nb_cuisine->ViewValue = $this->ev_nb_cuisine->CurrentValue;
        $this->ev_nb_cuisine->ViewValue = FormatNumber($this->ev_nb_cuisine->ViewValue, $this->ev_nb_cuisine->formatPattern());
        $this->ev_nb_cuisine->ViewCustomAttributes = "";

        // ev_nb_garage
        $this->ev_nb_garage->ViewValue = $this->ev_nb_garage->CurrentValue;
        $this->ev_nb_garage->ViewValue = FormatNumber($this->ev_nb_garage->ViewValue, $this->ev_nb_garage->formatPattern());
        $this->ev_nb_garage->ViewCustomAttributes = "";

        // ev_nb_m2
        $this->ev_nb_m2->ViewValue = $this->ev_nb_m2->CurrentValue;
        $this->ev_nb_m2->ViewValue = FormatNumber($this->ev_nb_m2->ViewValue, $this->ev_nb_m2->formatPattern());
        $this->ev_nb_m2->ViewCustomAttributes = "";

        // ev_autresalle
        $this->ev_autresalle->ViewValue = $this->ev_autresalle->CurrentValue;
        $this->ev_autresalle->ViewCustomAttributes = "";

        // ev_toit_tole
        $this->ev_toit_tole->ViewValue = $this->ev_toit_tole->CurrentValue;
        $this->ev_toit_tole->ViewCustomAttributes = "";

        // ev_toit_beton
        $this->ev_toit_beton->ViewValue = $this->ev_toit_beton->CurrentValue;
        $this->ev_toit_beton->ViewCustomAttributes = "";

        // ev_toit_tullles
        $this->ev_toit_tullles->ViewValue = $this->ev_toit_tullles->CurrentValue;
        $this->ev_toit_tullles->ViewCustomAttributes = "";

        // ev_plancher_bois
        $this->ev_plancher_bois->ViewValue = $this->ev_plancher_bois->CurrentValue;
        $this->ev_plancher_bois->ViewCustomAttributes = "";

        // ev_plancher_beton
        $this->ev_plancher_beton->ViewValue = $this->ev_plancher_beton->CurrentValue;
        $this->ev_plancher_beton->ViewCustomAttributes = "";

        // ev_plancher_mosaique
        $this->ev_plancher_mosaique->ViewValue = $this->ev_plancher_mosaique->CurrentValue;
        $this->ev_plancher_mosaique->ViewCustomAttributes = "";

        // ev_plancher_terazo
        $this->ev_plancher_terazo->ViewValue = $this->ev_plancher_terazo->CurrentValue;
        $this->ev_plancher_terazo->ViewCustomAttributes = "";

        // ev_plancher_ceramique
        $this->ev_plancher_ceramique->ViewValue = $this->ev_plancher_ceramique->CurrentValue;
        $this->ev_plancher_ceramique->ViewCustomAttributes = "";

        // est_ex_fiscal
        $curVal = strval($this->est_ex_fiscal->CurrentValue);
        if ($curVal != "") {
            $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->lookupCacheOption($curVal);
            if ($this->est_ex_fiscal->ViewValue === null) { // Lookup from database
                $filterWrk = "`id_ex_fiscal`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->est_ex_fiscal->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->est_ex_fiscal->Lookup->renderViewRow($rswrk[0]);
                    $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->displayValue($arwrk);
                } else {
                    $this->est_ex_fiscal->ViewValue = $this->est_ex_fiscal->CurrentValue;
                }
            }
        } else {
            $this->est_ex_fiscal->ViewValue = null;
        }
        $this->est_ex_fiscal->ViewCustomAttributes = "";

        // est_estimation
        $this->est_estimation->ViewValue = $this->est_estimation->CurrentValue;
        $this->est_estimation->ViewValue = FormatNumber($this->est_estimation->ViewValue, $this->est_estimation->formatPattern());
        $this->est_estimation->ViewCustomAttributes = "";

        // est_montant
        $this->est_montant->ViewValue = $this->est_montant->CurrentValue;
        $this->est_montant->ViewValue = FormatNumber($this->est_montant->ViewValue, $this->est_montant->formatPattern());
        $this->est_montant->ViewCustomAttributes = "";

        // id_owner
        $curVal = strval($this->id_owner->CurrentValue);
        if ($curVal != "") {
            $this->id_owner->ViewValue = $this->id_owner->lookupCacheOption($curVal);
            if ($this->id_owner->ViewValue === null) { // Lookup from database
                $filterWrk = "`id_owner`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->id_owner->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->id_owner->Lookup->renderViewRow($rswrk[0]);
                    $this->id_owner->ViewValue = $this->id_owner->displayValue($arwrk);
                } else {
                    $this->id_owner->ViewValue = $this->id_owner->CurrentValue;
                }
            }
        } else {
            $this->id_owner->ViewValue = null;
        }
        $this->id_owner->ViewCustomAttributes = "";

        // id_agent
        $curVal = strval($this->id_agent->CurrentValue);
        if ($curVal != "") {
            $this->id_agent->ViewValue = $this->id_agent->lookupCacheOption($curVal);
            if ($this->id_agent->ViewValue === null) { // Lookup from database
                $filterWrk = "`id_agent`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->id_agent->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->id_agent->Lookup->renderViewRow($rswrk[0]);
                    $this->id_agent->ViewValue = $this->id_agent->displayValue($arwrk);
                } else {
                    $this->id_agent->ViewValue = $this->id_agent->CurrentValue;
                }
            }
        } else {
            $this->id_agent->ViewValue = null;
        }
        $this->id_agent->ViewCustomAttributes = "";

        // localisation
        $this->localisation->ViewValue = $this->localisation->CurrentValue;
        $this->localisation->ViewCustomAttributes = "";

        // usage
        if (strval($this->usage->CurrentValue) != "") {
            $this->usage->ViewValue = $this->usage->optionCaption($this->usage->CurrentValue);
        } else {
            $this->usage->ViewValue = null;
        }
        $this->usage->ViewCustomAttributes = "";

        // id_immeuble
        $this->id_immeuble->LinkCustomAttributes = "";
        $this->id_immeuble->HrefValue = "";
        $this->id_immeuble->TooltipValue = "";

        // descrip
        $this->descrip->LinkCustomAttributes = "";
        $this->descrip->HrefValue = "";
        $this->descrip->TooltipValue = "";

        // codeimmeuble
        $this->codeimmeuble->LinkCustomAttributes = "";
        $this->codeimmeuble->HrefValue = "";
        $this->codeimmeuble->TooltipValue = "";

        // daterecensement
        $this->daterecensement->LinkCustomAttributes = "";
        $this->daterecensement->HrefValue = "";
        $this->daterecensement->TooltipValue = "";

        // st_annee_construct
        $this->st_annee_construct->LinkCustomAttributes = "";
        $this->st_annee_construct->HrefValue = "";
        $this->st_annee_construct->TooltipValue = "";

        // st_propriete
        $this->st_propriete->LinkCustomAttributes = "";
        $this->st_propriete->HrefValue = "";
        $this->st_propriete->TooltipValue = "";

        // st_en_affermage
        $this->st_en_affermage->LinkCustomAttributes = "";
        $this->st_en_affermage->HrefValue = "";
        $this->st_en_affermage->TooltipValue = "";

        // st_en_location
        $this->st_en_location->LinkCustomAttributes = "";
        $this->st_en_location->HrefValue = "";
        $this->st_en_location->TooltipValue = "";

        // st_en_usufruit
        $this->st_en_usufruit->LinkCustomAttributes = "";
        $this->st_en_usufruit->HrefValue = "";
        $this->st_en_usufruit->TooltipValue = "";

        // st_autre
        $this->st_autre->LinkCustomAttributes = "";
        $this->st_autre->HrefValue = "";
        $this->st_autre->TooltipValue = "";

        // ad_rue
        $this->ad_rue->LinkCustomAttributes = "";
        $this->ad_rue->HrefValue = "";
        $this->ad_rue->TooltipValue = "";

        // ad_no_immeuble
        $this->ad_no_immeuble->LinkCustomAttributes = "";
        $this->ad_no_immeuble->HrefValue = "";
        $this->ad_no_immeuble->TooltipValue = "";

        // ad_rue_adj
        $this->ad_rue_adj->LinkCustomAttributes = "";
        $this->ad_rue_adj->HrefValue = "";
        $this->ad_rue_adj->TooltipValue = "";

        // ad_zonequartier
        $this->ad_zonequartier->LinkCustomAttributes = "";
        $this->ad_zonequartier->HrefValue = "";
        $this->ad_zonequartier->TooltipValue = "";

        // ad_section
        $this->ad_section->LinkCustomAttributes = "";
        $this->ad_section->HrefValue = "";
        $this->ad_section->TooltipValue = "";

        // ev_nb_toilette
        $this->ev_nb_toilette->LinkCustomAttributes = "";
        $this->ev_nb_toilette->HrefValue = "";
        $this->ev_nb_toilette->TooltipValue = "";

        // ev_nb_cuisine
        $this->ev_nb_cuisine->LinkCustomAttributes = "";
        $this->ev_nb_cuisine->HrefValue = "";
        $this->ev_nb_cuisine->TooltipValue = "";

        // ev_nb_garage
        $this->ev_nb_garage->LinkCustomAttributes = "";
        $this->ev_nb_garage->HrefValue = "";
        $this->ev_nb_garage->TooltipValue = "";

        // ev_nb_m2
        $this->ev_nb_m2->LinkCustomAttributes = "";
        $this->ev_nb_m2->HrefValue = "";
        $this->ev_nb_m2->TooltipValue = "";

        // ev_autresalle
        $this->ev_autresalle->LinkCustomAttributes = "";
        $this->ev_autresalle->HrefValue = "";
        $this->ev_autresalle->TooltipValue = "";

        // ev_toit_tole
        $this->ev_toit_tole->LinkCustomAttributes = "";
        $this->ev_toit_tole->HrefValue = "";
        $this->ev_toit_tole->TooltipValue = "";

        // ev_toit_beton
        $this->ev_toit_beton->LinkCustomAttributes = "";
        $this->ev_toit_beton->HrefValue = "";
        $this->ev_toit_beton->TooltipValue = "";

        // ev_toit_tullles
        $this->ev_toit_tullles->LinkCustomAttributes = "";
        $this->ev_toit_tullles->HrefValue = "";
        $this->ev_toit_tullles->TooltipValue = "";

        // ev_plancher_bois
        $this->ev_plancher_bois->LinkCustomAttributes = "";
        $this->ev_plancher_bois->HrefValue = "";
        $this->ev_plancher_bois->TooltipValue = "";

        // ev_plancher_beton
        $this->ev_plancher_beton->LinkCustomAttributes = "";
        $this->ev_plancher_beton->HrefValue = "";
        $this->ev_plancher_beton->TooltipValue = "";

        // ev_plancher_mosaique
        $this->ev_plancher_mosaique->LinkCustomAttributes = "";
        $this->ev_plancher_mosaique->HrefValue = "";
        $this->ev_plancher_mosaique->TooltipValue = "";

        // ev_plancher_terazo
        $this->ev_plancher_terazo->LinkCustomAttributes = "";
        $this->ev_plancher_terazo->HrefValue = "";
        $this->ev_plancher_terazo->TooltipValue = "";

        // ev_plancher_ceramique
        $this->ev_plancher_ceramique->LinkCustomAttributes = "";
        $this->ev_plancher_ceramique->HrefValue = "";
        $this->ev_plancher_ceramique->TooltipValue = "";

        // est_ex_fiscal
        $this->est_ex_fiscal->LinkCustomAttributes = "";
        $this->est_ex_fiscal->HrefValue = "";
        $this->est_ex_fiscal->TooltipValue = "";

        // est_estimation
        $this->est_estimation->LinkCustomAttributes = "";
        $this->est_estimation->HrefValue = "";
        $this->est_estimation->TooltipValue = "";

        // est_montant
        $this->est_montant->LinkCustomAttributes = "";
        $this->est_montant->HrefValue = "";
        $this->est_montant->TooltipValue = "";

        // id_owner
        $this->id_owner->LinkCustomAttributes = "";
        $this->id_owner->HrefValue = "";
        $this->id_owner->TooltipValue = "";

        // id_agent
        $this->id_agent->LinkCustomAttributes = "";
        $this->id_agent->HrefValue = "";
        $this->id_agent->TooltipValue = "";

        // localisation
        $this->localisation->LinkCustomAttributes = "";
        $this->localisation->HrefValue = "";
        $this->localisation->TooltipValue = "";

        // usage
        $this->usage->LinkCustomAttributes = "";
        $this->usage->HrefValue = "";
        $this->usage->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id_immeuble
        $this->id_immeuble->setupEditAttributes();
        $this->id_immeuble->EditCustomAttributes = "";
        $this->id_immeuble->EditValue = $this->id_immeuble->CurrentValue;
        $this->id_immeuble->ViewCustomAttributes = "";

        // descrip
        $this->descrip->setupEditAttributes();
        $this->descrip->EditCustomAttributes = "";
        $this->descrip->EditValue = $this->descrip->CurrentValue;
        $this->descrip->PlaceHolder = RemoveHtml($this->descrip->caption());

        // codeimmeuble
        $this->codeimmeuble->setupEditAttributes();
        $this->codeimmeuble->EditCustomAttributes = "";
        if (!$this->codeimmeuble->Raw) {
            $this->codeimmeuble->CurrentValue = HtmlDecode($this->codeimmeuble->CurrentValue);
        }
        $this->codeimmeuble->EditValue = $this->codeimmeuble->CurrentValue;
        $this->codeimmeuble->PlaceHolder = RemoveHtml($this->codeimmeuble->caption());

        // daterecensement
        $this->daterecensement->setupEditAttributes();
        $this->daterecensement->EditCustomAttributes = "";
        $this->daterecensement->EditValue = FormatDateTime($this->daterecensement->CurrentValue, $this->daterecensement->formatPattern());
        $this->daterecensement->PlaceHolder = RemoveHtml($this->daterecensement->caption());

        // st_annee_construct
        $this->st_annee_construct->setupEditAttributes();
        $this->st_annee_construct->EditCustomAttributes = "";
        $this->st_annee_construct->EditValue = $this->st_annee_construct->CurrentValue;
        $this->st_annee_construct->PlaceHolder = RemoveHtml($this->st_annee_construct->caption());
        if (strval($this->st_annee_construct->EditValue) != "" && is_numeric($this->st_annee_construct->EditValue)) {
            $this->st_annee_construct->EditValue = $this->st_annee_construct->EditValue;
        }

        // st_propriete
        $this->st_propriete->setupEditAttributes();
        $this->st_propriete->EditCustomAttributes = "";
        if (!$this->st_propriete->Raw) {
            $this->st_propriete->CurrentValue = HtmlDecode($this->st_propriete->CurrentValue);
        }
        $this->st_propriete->EditValue = $this->st_propriete->CurrentValue;
        $this->st_propriete->PlaceHolder = RemoveHtml($this->st_propriete->caption());

        // st_en_affermage
        $this->st_en_affermage->setupEditAttributes();
        $this->st_en_affermage->EditCustomAttributes = "";
        if (!$this->st_en_affermage->Raw) {
            $this->st_en_affermage->CurrentValue = HtmlDecode($this->st_en_affermage->CurrentValue);
        }
        $this->st_en_affermage->EditValue = $this->st_en_affermage->CurrentValue;
        $this->st_en_affermage->PlaceHolder = RemoveHtml($this->st_en_affermage->caption());

        // st_en_location
        $this->st_en_location->setupEditAttributes();
        $this->st_en_location->EditCustomAttributes = "";
        if (!$this->st_en_location->Raw) {
            $this->st_en_location->CurrentValue = HtmlDecode($this->st_en_location->CurrentValue);
        }
        $this->st_en_location->EditValue = $this->st_en_location->CurrentValue;
        $this->st_en_location->PlaceHolder = RemoveHtml($this->st_en_location->caption());

        // st_en_usufruit
        $this->st_en_usufruit->setupEditAttributes();
        $this->st_en_usufruit->EditCustomAttributes = "";
        if (!$this->st_en_usufruit->Raw) {
            $this->st_en_usufruit->CurrentValue = HtmlDecode($this->st_en_usufruit->CurrentValue);
        }
        $this->st_en_usufruit->EditValue = $this->st_en_usufruit->CurrentValue;
        $this->st_en_usufruit->PlaceHolder = RemoveHtml($this->st_en_usufruit->caption());

        // st_autre
        $this->st_autre->setupEditAttributes();
        $this->st_autre->EditCustomAttributes = "";
        if (!$this->st_autre->Raw) {
            $this->st_autre->CurrentValue = HtmlDecode($this->st_autre->CurrentValue);
        }
        $this->st_autre->EditValue = $this->st_autre->CurrentValue;
        $this->st_autre->PlaceHolder = RemoveHtml($this->st_autre->caption());

        // ad_rue
        $this->ad_rue->setupEditAttributes();
        $this->ad_rue->EditCustomAttributes = "";
        if (!$this->ad_rue->Raw) {
            $this->ad_rue->CurrentValue = HtmlDecode($this->ad_rue->CurrentValue);
        }
        $this->ad_rue->EditValue = $this->ad_rue->CurrentValue;
        $this->ad_rue->PlaceHolder = RemoveHtml($this->ad_rue->caption());

        // ad_no_immeuble
        $this->ad_no_immeuble->setupEditAttributes();
        $this->ad_no_immeuble->EditCustomAttributes = "";
        if (!$this->ad_no_immeuble->Raw) {
            $this->ad_no_immeuble->CurrentValue = HtmlDecode($this->ad_no_immeuble->CurrentValue);
        }
        $this->ad_no_immeuble->EditValue = $this->ad_no_immeuble->CurrentValue;
        $this->ad_no_immeuble->PlaceHolder = RemoveHtml($this->ad_no_immeuble->caption());

        // ad_rue_adj
        $this->ad_rue_adj->setupEditAttributes();
        $this->ad_rue_adj->EditCustomAttributes = "";
        if (!$this->ad_rue_adj->Raw) {
            $this->ad_rue_adj->CurrentValue = HtmlDecode($this->ad_rue_adj->CurrentValue);
        }
        $this->ad_rue_adj->EditValue = $this->ad_rue_adj->CurrentValue;
        $this->ad_rue_adj->PlaceHolder = RemoveHtml($this->ad_rue_adj->caption());

        // ad_zonequartier
        $this->ad_zonequartier->setupEditAttributes();
        $this->ad_zonequartier->EditCustomAttributes = "";
        if (!$this->ad_zonequartier->Raw) {
            $this->ad_zonequartier->CurrentValue = HtmlDecode($this->ad_zonequartier->CurrentValue);
        }
        $this->ad_zonequartier->EditValue = $this->ad_zonequartier->CurrentValue;
        $this->ad_zonequartier->PlaceHolder = RemoveHtml($this->ad_zonequartier->caption());

        // ad_section
        $this->ad_section->setupEditAttributes();
        $this->ad_section->EditCustomAttributes = "";
        if (!$this->ad_section->Raw) {
            $this->ad_section->CurrentValue = HtmlDecode($this->ad_section->CurrentValue);
        }
        $this->ad_section->EditValue = $this->ad_section->CurrentValue;
        $this->ad_section->PlaceHolder = RemoveHtml($this->ad_section->caption());

        // ev_nb_toilette
        $this->ev_nb_toilette->setupEditAttributes();
        $this->ev_nb_toilette->EditCustomAttributes = "";
        $this->ev_nb_toilette->EditValue = $this->ev_nb_toilette->CurrentValue;
        $this->ev_nb_toilette->PlaceHolder = RemoveHtml($this->ev_nb_toilette->caption());
        if (strval($this->ev_nb_toilette->EditValue) != "" && is_numeric($this->ev_nb_toilette->EditValue)) {
            $this->ev_nb_toilette->EditValue = FormatNumber($this->ev_nb_toilette->EditValue, null);
        }

        // ev_nb_cuisine
        $this->ev_nb_cuisine->setupEditAttributes();
        $this->ev_nb_cuisine->EditCustomAttributes = "";
        $this->ev_nb_cuisine->EditValue = $this->ev_nb_cuisine->CurrentValue;
        $this->ev_nb_cuisine->PlaceHolder = RemoveHtml($this->ev_nb_cuisine->caption());
        if (strval($this->ev_nb_cuisine->EditValue) != "" && is_numeric($this->ev_nb_cuisine->EditValue)) {
            $this->ev_nb_cuisine->EditValue = FormatNumber($this->ev_nb_cuisine->EditValue, null);
        }

        // ev_nb_garage
        $this->ev_nb_garage->setupEditAttributes();
        $this->ev_nb_garage->EditCustomAttributes = "";
        $this->ev_nb_garage->EditValue = $this->ev_nb_garage->CurrentValue;
        $this->ev_nb_garage->PlaceHolder = RemoveHtml($this->ev_nb_garage->caption());
        if (strval($this->ev_nb_garage->EditValue) != "" && is_numeric($this->ev_nb_garage->EditValue)) {
            $this->ev_nb_garage->EditValue = FormatNumber($this->ev_nb_garage->EditValue, null);
        }

        // ev_nb_m2
        $this->ev_nb_m2->setupEditAttributes();
        $this->ev_nb_m2->EditCustomAttributes = "";
        $this->ev_nb_m2->EditValue = $this->ev_nb_m2->CurrentValue;
        $this->ev_nb_m2->PlaceHolder = RemoveHtml($this->ev_nb_m2->caption());
        if (strval($this->ev_nb_m2->EditValue) != "" && is_numeric($this->ev_nb_m2->EditValue)) {
            $this->ev_nb_m2->EditValue = FormatNumber($this->ev_nb_m2->EditValue, null);
        }

        // ev_autresalle
        $this->ev_autresalle->setupEditAttributes();
        $this->ev_autresalle->EditCustomAttributes = "";
        if (!$this->ev_autresalle->Raw) {
            $this->ev_autresalle->CurrentValue = HtmlDecode($this->ev_autresalle->CurrentValue);
        }
        $this->ev_autresalle->EditValue = $this->ev_autresalle->CurrentValue;
        $this->ev_autresalle->PlaceHolder = RemoveHtml($this->ev_autresalle->caption());

        // ev_toit_tole
        $this->ev_toit_tole->setupEditAttributes();
        $this->ev_toit_tole->EditCustomAttributes = "";
        if (!$this->ev_toit_tole->Raw) {
            $this->ev_toit_tole->CurrentValue = HtmlDecode($this->ev_toit_tole->CurrentValue);
        }
        $this->ev_toit_tole->EditValue = $this->ev_toit_tole->CurrentValue;
        $this->ev_toit_tole->PlaceHolder = RemoveHtml($this->ev_toit_tole->caption());

        // ev_toit_beton
        $this->ev_toit_beton->setupEditAttributes();
        $this->ev_toit_beton->EditCustomAttributes = "";
        if (!$this->ev_toit_beton->Raw) {
            $this->ev_toit_beton->CurrentValue = HtmlDecode($this->ev_toit_beton->CurrentValue);
        }
        $this->ev_toit_beton->EditValue = $this->ev_toit_beton->CurrentValue;
        $this->ev_toit_beton->PlaceHolder = RemoveHtml($this->ev_toit_beton->caption());

        // ev_toit_tullles
        $this->ev_toit_tullles->setupEditAttributes();
        $this->ev_toit_tullles->EditCustomAttributes = "";
        if (!$this->ev_toit_tullles->Raw) {
            $this->ev_toit_tullles->CurrentValue = HtmlDecode($this->ev_toit_tullles->CurrentValue);
        }
        $this->ev_toit_tullles->EditValue = $this->ev_toit_tullles->CurrentValue;
        $this->ev_toit_tullles->PlaceHolder = RemoveHtml($this->ev_toit_tullles->caption());

        // ev_plancher_bois
        $this->ev_plancher_bois->setupEditAttributes();
        $this->ev_plancher_bois->EditCustomAttributes = "";
        if (!$this->ev_plancher_bois->Raw) {
            $this->ev_plancher_bois->CurrentValue = HtmlDecode($this->ev_plancher_bois->CurrentValue);
        }
        $this->ev_plancher_bois->EditValue = $this->ev_plancher_bois->CurrentValue;
        $this->ev_plancher_bois->PlaceHolder = RemoveHtml($this->ev_plancher_bois->caption());

        // ev_plancher_beton
        $this->ev_plancher_beton->setupEditAttributes();
        $this->ev_plancher_beton->EditCustomAttributes = "";
        if (!$this->ev_plancher_beton->Raw) {
            $this->ev_plancher_beton->CurrentValue = HtmlDecode($this->ev_plancher_beton->CurrentValue);
        }
        $this->ev_plancher_beton->EditValue = $this->ev_plancher_beton->CurrentValue;
        $this->ev_plancher_beton->PlaceHolder = RemoveHtml($this->ev_plancher_beton->caption());

        // ev_plancher_mosaique
        $this->ev_plancher_mosaique->setupEditAttributes();
        $this->ev_plancher_mosaique->EditCustomAttributes = "";
        if (!$this->ev_plancher_mosaique->Raw) {
            $this->ev_plancher_mosaique->CurrentValue = HtmlDecode($this->ev_plancher_mosaique->CurrentValue);
        }
        $this->ev_plancher_mosaique->EditValue = $this->ev_plancher_mosaique->CurrentValue;
        $this->ev_plancher_mosaique->PlaceHolder = RemoveHtml($this->ev_plancher_mosaique->caption());

        // ev_plancher_terazo
        $this->ev_plancher_terazo->setupEditAttributes();
        $this->ev_plancher_terazo->EditCustomAttributes = "";
        if (!$this->ev_plancher_terazo->Raw) {
            $this->ev_plancher_terazo->CurrentValue = HtmlDecode($this->ev_plancher_terazo->CurrentValue);
        }
        $this->ev_plancher_terazo->EditValue = $this->ev_plancher_terazo->CurrentValue;
        $this->ev_plancher_terazo->PlaceHolder = RemoveHtml($this->ev_plancher_terazo->caption());

        // ev_plancher_ceramique
        $this->ev_plancher_ceramique->setupEditAttributes();
        $this->ev_plancher_ceramique->EditCustomAttributes = "";
        if (!$this->ev_plancher_ceramique->Raw) {
            $this->ev_plancher_ceramique->CurrentValue = HtmlDecode($this->ev_plancher_ceramique->CurrentValue);
        }
        $this->ev_plancher_ceramique->EditValue = $this->ev_plancher_ceramique->CurrentValue;
        $this->ev_plancher_ceramique->PlaceHolder = RemoveHtml($this->ev_plancher_ceramique->caption());

        // est_ex_fiscal
        $this->est_ex_fiscal->setupEditAttributes();
        $this->est_ex_fiscal->EditCustomAttributes = "";
        $this->est_ex_fiscal->PlaceHolder = RemoveHtml($this->est_ex_fiscal->caption());

        // est_estimation
        $this->est_estimation->setupEditAttributes();
        $this->est_estimation->EditCustomAttributes = "";
        $this->est_estimation->EditValue = $this->est_estimation->CurrentValue;
        $this->est_estimation->PlaceHolder = RemoveHtml($this->est_estimation->caption());
        if (strval($this->est_estimation->EditValue) != "" && is_numeric($this->est_estimation->EditValue)) {
            $this->est_estimation->EditValue = FormatNumber($this->est_estimation->EditValue, null);
        }

        // est_montant
        $this->est_montant->setupEditAttributes();
        $this->est_montant->EditCustomAttributes = "";
        $this->est_montant->EditValue = $this->est_montant->CurrentValue;
        $this->est_montant->PlaceHolder = RemoveHtml($this->est_montant->caption());
        if (strval($this->est_montant->EditValue) != "" && is_numeric($this->est_montant->EditValue)) {
            $this->est_montant->EditValue = FormatNumber($this->est_montant->EditValue, null);
        }

        // id_owner
        $this->id_owner->setupEditAttributes();
        $this->id_owner->EditCustomAttributes = "";
        $this->id_owner->PlaceHolder = RemoveHtml($this->id_owner->caption());

        // id_agent

        // localisation
        $this->localisation->setupEditAttributes();
        $this->localisation->EditCustomAttributes = "";
        if (!$this->localisation->Raw) {
            $this->localisation->CurrentValue = HtmlDecode($this->localisation->CurrentValue);
        }
        $this->localisation->EditValue = $this->localisation->CurrentValue;
        $this->localisation->PlaceHolder = RemoveHtml($this->localisation->caption());

        // usage
        $this->usage->setupEditAttributes();
        $this->usage->EditCustomAttributes = "";
        $this->usage->EditValue = $this->usage->options(true);
        $this->usage->PlaceHolder = RemoveHtml($this->usage->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id_immeuble);
                    $doc->exportCaption($this->descrip);
                    $doc->exportCaption($this->codeimmeuble);
                    $doc->exportCaption($this->daterecensement);
                    $doc->exportCaption($this->st_annee_construct);
                    $doc->exportCaption($this->st_propriete);
                    $doc->exportCaption($this->st_en_affermage);
                    $doc->exportCaption($this->st_en_location);
                    $doc->exportCaption($this->st_en_usufruit);
                    $doc->exportCaption($this->st_autre);
                    $doc->exportCaption($this->ad_rue);
                    $doc->exportCaption($this->ad_no_immeuble);
                    $doc->exportCaption($this->ad_rue_adj);
                    $doc->exportCaption($this->ad_zonequartier);
                    $doc->exportCaption($this->ad_section);
                    $doc->exportCaption($this->ev_nb_toilette);
                    $doc->exportCaption($this->ev_nb_cuisine);
                    $doc->exportCaption($this->ev_nb_garage);
                    $doc->exportCaption($this->ev_nb_m2);
                    $doc->exportCaption($this->ev_autresalle);
                    $doc->exportCaption($this->ev_toit_tole);
                    $doc->exportCaption($this->ev_toit_beton);
                    $doc->exportCaption($this->ev_toit_tullles);
                    $doc->exportCaption($this->ev_plancher_bois);
                    $doc->exportCaption($this->ev_plancher_beton);
                    $doc->exportCaption($this->ev_plancher_mosaique);
                    $doc->exportCaption($this->ev_plancher_terazo);
                    $doc->exportCaption($this->ev_plancher_ceramique);
                    $doc->exportCaption($this->est_ex_fiscal);
                    $doc->exportCaption($this->est_estimation);
                    $doc->exportCaption($this->est_montant);
                    $doc->exportCaption($this->id_owner);
                    $doc->exportCaption($this->id_agent);
                    $doc->exportCaption($this->localisation);
                    $doc->exportCaption($this->usage);
                } else {
                    $doc->exportCaption($this->id_immeuble);
                    $doc->exportCaption($this->codeimmeuble);
                    $doc->exportCaption($this->daterecensement);
                    $doc->exportCaption($this->st_annee_construct);
                    $doc->exportCaption($this->st_propriete);
                    $doc->exportCaption($this->st_en_affermage);
                    $doc->exportCaption($this->st_en_location);
                    $doc->exportCaption($this->st_en_usufruit);
                    $doc->exportCaption($this->st_autre);
                    $doc->exportCaption($this->ad_rue);
                    $doc->exportCaption($this->ad_no_immeuble);
                    $doc->exportCaption($this->ad_rue_adj);
                    $doc->exportCaption($this->ad_zonequartier);
                    $doc->exportCaption($this->ad_section);
                    $doc->exportCaption($this->ev_nb_toilette);
                    $doc->exportCaption($this->ev_nb_cuisine);
                    $doc->exportCaption($this->ev_nb_garage);
                    $doc->exportCaption($this->ev_nb_m2);
                    $doc->exportCaption($this->ev_autresalle);
                    $doc->exportCaption($this->ev_toit_tole);
                    $doc->exportCaption($this->ev_toit_beton);
                    $doc->exportCaption($this->ev_toit_tullles);
                    $doc->exportCaption($this->ev_plancher_bois);
                    $doc->exportCaption($this->ev_plancher_beton);
                    $doc->exportCaption($this->ev_plancher_mosaique);
                    $doc->exportCaption($this->ev_plancher_terazo);
                    $doc->exportCaption($this->ev_plancher_ceramique);
                    $doc->exportCaption($this->est_ex_fiscal);
                    $doc->exportCaption($this->est_estimation);
                    $doc->exportCaption($this->est_montant);
                    $doc->exportCaption($this->id_owner);
                    $doc->exportCaption($this->id_agent);
                    $doc->exportCaption($this->localisation);
                    $doc->exportCaption($this->usage);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id_immeuble);
                        $doc->exportField($this->descrip);
                        $doc->exportField($this->codeimmeuble);
                        $doc->exportField($this->daterecensement);
                        $doc->exportField($this->st_annee_construct);
                        $doc->exportField($this->st_propriete);
                        $doc->exportField($this->st_en_affermage);
                        $doc->exportField($this->st_en_location);
                        $doc->exportField($this->st_en_usufruit);
                        $doc->exportField($this->st_autre);
                        $doc->exportField($this->ad_rue);
                        $doc->exportField($this->ad_no_immeuble);
                        $doc->exportField($this->ad_rue_adj);
                        $doc->exportField($this->ad_zonequartier);
                        $doc->exportField($this->ad_section);
                        $doc->exportField($this->ev_nb_toilette);
                        $doc->exportField($this->ev_nb_cuisine);
                        $doc->exportField($this->ev_nb_garage);
                        $doc->exportField($this->ev_nb_m2);
                        $doc->exportField($this->ev_autresalle);
                        $doc->exportField($this->ev_toit_tole);
                        $doc->exportField($this->ev_toit_beton);
                        $doc->exportField($this->ev_toit_tullles);
                        $doc->exportField($this->ev_plancher_bois);
                        $doc->exportField($this->ev_plancher_beton);
                        $doc->exportField($this->ev_plancher_mosaique);
                        $doc->exportField($this->ev_plancher_terazo);
                        $doc->exportField($this->ev_plancher_ceramique);
                        $doc->exportField($this->est_ex_fiscal);
                        $doc->exportField($this->est_estimation);
                        $doc->exportField($this->est_montant);
                        $doc->exportField($this->id_owner);
                        $doc->exportField($this->id_agent);
                        $doc->exportField($this->localisation);
                        $doc->exportField($this->usage);
                    } else {
                        $doc->exportField($this->id_immeuble);
                        $doc->exportField($this->codeimmeuble);
                        $doc->exportField($this->daterecensement);
                        $doc->exportField($this->st_annee_construct);
                        $doc->exportField($this->st_propriete);
                        $doc->exportField($this->st_en_affermage);
                        $doc->exportField($this->st_en_location);
                        $doc->exportField($this->st_en_usufruit);
                        $doc->exportField($this->st_autre);
                        $doc->exportField($this->ad_rue);
                        $doc->exportField($this->ad_no_immeuble);
                        $doc->exportField($this->ad_rue_adj);
                        $doc->exportField($this->ad_zonequartier);
                        $doc->exportField($this->ad_section);
                        $doc->exportField($this->ev_nb_toilette);
                        $doc->exportField($this->ev_nb_cuisine);
                        $doc->exportField($this->ev_nb_garage);
                        $doc->exportField($this->ev_nb_m2);
                        $doc->exportField($this->ev_autresalle);
                        $doc->exportField($this->ev_toit_tole);
                        $doc->exportField($this->ev_toit_beton);
                        $doc->exportField($this->ev_toit_tullles);
                        $doc->exportField($this->ev_plancher_bois);
                        $doc->exportField($this->ev_plancher_beton);
                        $doc->exportField($this->ev_plancher_mosaique);
                        $doc->exportField($this->ev_plancher_terazo);
                        $doc->exportField($this->ev_plancher_ceramique);
                        $doc->exportField($this->est_ex_fiscal);
                        $doc->exportField($this->est_estimation);
                        $doc->exportField($this->est_montant);
                        $doc->exportField($this->id_owner);
                        $doc->exportField($this->id_agent);
                        $doc->exportField($this->localisation);
                        $doc->exportField($this->usage);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->ExportDoc = &$doc;
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Add User ID filter
    public function addUserIDFilter($filter = "", $id = "")
    {
        global $Security;
        $filterWrk = "";
        if ($id == "")
            $id = (CurrentPageID() == "list") ? $this->CurrentAction : CurrentPageID();
        if (!$this->userIDAllow($id) && !$Security->isAdmin()) {
            $filterWrk = $Security->userIdList();
            if ($filterWrk != "") {
                $filterWrk = '`id_agent` IN (' . $filterWrk . ')';
            }
        }

        // Call User ID Filtering event
        $this->userIdFiltering($filterWrk);
        AddFilter($filter, $filterWrk);
        return $filter;
    }

    // User ID subquery
    public function getUserIDSubquery(&$fld, &$masterfld)
    {
        global $UserTable;
        $wrk = "";
        $sql = "SELECT " . $masterfld->Expression . " FROM `immeuble`";
        $filter = $this->addUserIDFilter("");
        if ($filter != "") {
            $sql .= " WHERE " . $filter;
        }

        // List all values
        $conn = Conn($UserTable->Dbid);
        $config = $conn->getConfiguration();
        $config->setResultCacheImpl($this->Cache);
        if ($rs = $conn->executeCacheQuery($sql, [], [], $this->CacheProfile)->fetchAllNumeric()) {
            foreach ($rs as $row) {
                if ($wrk != "") {
                    $wrk .= ",";
                }
                $wrk .= QuotedValue($row[0], $masterfld->DataType, Config("USER_TABLE_DBID"));
            }
        }
        if ($wrk != "") {
            $wrk = $fld->Expression . " IN (" . $wrk . ")";
        } else { // No User ID value found
            $wrk = "0=1";
        }
        return $wrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);

        // $this->RowAttrs["class"] = "alert alert-info";
        if ($this->PageID == "add" || $this->PageID == "edit") 
            {
             //   $this->id_owner->CellAttrs["style"] = "height:100px";
            }
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
