<?php

// ------------------------------------------------------
// -
// -    List of common currencies
// -
// -    Original source: https://gist.github.com/Fluidbyte/2973986
// -
// ------------------------------------------------------

return [
    // ------------------------------------------------------
    // -
    // -    Francophones
    // -
    // ------------------------------------------------------

    'EUR' => [
        'symbol'         => '€',
        'name'           => 'Euro',
        'iso'            => 'EUR',
        'symbol_intl'    => '€',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'CHF' => [
        'symbol'         => 'CHF',
        'name'           => 'Franc Suisse',
        'iso'            => 'CHF',
        'symbol_intl'    => 'CHF',
        'decimal_digits' => 2,
        'rounding'       => 0.05,
    ],
    'CAD' => [
        'symbol'         => '$',
        'name'           => 'Dollar Canadien',
        'iso'            => 'CAD',
        'symbol_intl'    => 'CA$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BIF' => [
        'symbol'         => 'FBu',
        'name'           => 'Franc Burundien',
        'iso'            => 'BIF',
        'symbol_intl'    => 'FBu',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'CDF' => [
        'symbol'         => 'FrCD',
        'name'           => 'Franc Congolais',
        'iso'            => 'CDF',
        'symbol_intl'    => 'CDF',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'DJF' => [
        'symbol'         => 'Fdj',
        'name'           => 'Franc Djiboutien',
        'iso'            => 'DJF',
        'symbol_intl'    => 'Fdj',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'DZD' => [
        'symbol'         => 'د.ج.‏',
        'name'           => 'Dinar Algérien',
        'iso'            => 'DZD',
        'symbol_intl'    => 'DA',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'GNF' => [
        'symbol'         => 'FG',
        'name'           => 'Franc Guinéen',
        'iso'            => 'GNF',
        'symbol_intl'    => 'FG',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'KMF' => [
        'symbol'         => 'FC',
        'name'           => 'Franc Comorien',
        'iso'            => 'KMF',
        'symbol_intl'    => 'CF',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'MAD' => [
        'symbol'         => 'د.م.‏',
        'name'           => 'Dirham Marocain',
        'iso'            => 'MAD',
        'symbol_intl'    => 'MAD',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'RWF' => [
        'symbol'         => 'FR',
        'name'           => 'Franc Rwandais',
        'iso'            => 'RWF',
        'symbol_intl'    => 'RWF',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'TND' => [
        'symbol'         => 'د.ت.‏',
        'name'           => 'Dinar Tunisien',
        'iso'            => 'TND',
        'symbol_intl'    => 'DT',
        'decimal_digits' => 3,
        'rounding'       => 0,
    ],
    'XAF' => [
        'symbol'         => 'FCFA',
        'name'           => 'Franc CFA (BEAC)',
        'iso'            => 'XAF',
        'symbol_intl'    => 'FCFA',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'XOF' => [
        'symbol'         => 'FCFA',
        'name'           => 'Franc CFA (BCEAO)',
        'iso'            => 'XOF',
        'symbol_intl'    => 'CFA',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'XPF' => [
        'symbol'         => 'CFP',
        'name'           => 'Franc Pacifique',
        'iso'            => 'XPF',
        'symbol_intl'    => 'CFP',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],

    // ------------------------------------------------------
    // -
    // -    Non francophones
    // -
    // ------------------------------------------------------

    'USD' => [
        'symbol'         => '$',
        'name'           => 'US Dollar',
        'iso'            => 'USD',
        'symbol_intl'    => '$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'AED' => [
        'symbol'         => 'د.إ.‏',
        'name'           => 'United Arab Emirates Dirham',
        'iso'            => 'AED',
        'symbol_intl'    => 'AED',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'AFN' => [
        'symbol'         => '؋',
        'name'           => 'Afghan Afghani',
        'iso'            => 'AFN',
        'symbol_intl'    => 'Af',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'ALL' => [
        'symbol'         => 'Lek',
        'name'           => 'Albanian Lek',
        'iso'            => 'ALL',
        'symbol_intl'    => 'ALL',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'AMD' => [
        'symbol'         => 'դր.',
        'name'           => 'Armenian Dram',
        'iso'            => 'AMD',
        'symbol_intl'    => 'AMD',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'ARS' => [
        'symbol'         => '$',
        'name'           => 'Argentine Peso',
        'iso'            => 'ARS',
        'symbol_intl'    => 'AR$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'AUD' => [
        'symbol'         => '$',
        'name'           => 'Australian Dollar',
        'iso'            => 'AUD',
        'symbol_intl'    => 'AU$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'AZN' => [
        'symbol'         => 'ман.',
        'name'           => 'Azerbaijani Manat',
        'iso'            => 'AZN',
        'symbol_intl'    => 'man.',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BAM' => [
        'symbol'         => 'KM',
        'name'           => 'Bosnia-Herzegovina Convertible Mark',
        'iso'            => 'BAM',
        'symbol_intl'    => 'KM',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BDT' => [
        'symbol'         => '৳',
        'name'           => 'Bangladeshi Taka',
        'iso'            => 'BDT',
        'symbol_intl'    => 'Tk',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BGN' => [
        'symbol'         => 'лв.',
        'name'           => 'Bulgarian Lev',
        'iso'            => 'BGN',
        'symbol_intl'    => 'BGN',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BHD' => [
        'symbol'         => 'د.ب.‏',
        'name'           => 'Bahraini Dinar',
        'iso'            => 'BHD',
        'symbol_intl'    => 'BD',
        'decimal_digits' => 3,
        'rounding'       => 0,
    ],
    'BND' => [
        'symbol'         => '$',
        'name'           => 'Brunei Dollar',
        'iso'            => 'BND',
        'symbol_intl'    => 'BN$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BOB' => [
        'symbol'         => 'Bs',
        'name'           => 'Bolivian Boliviano',
        'iso'            => 'BOB',
        'symbol_intl'    => 'Bs',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BRL' => [
        'symbol'         => 'R$',
        'name'           => 'Brazilian Real',
        'iso'            => 'BRL',
        'symbol_intl'    => 'R$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BWP' => [
        'symbol'         => 'P',
        'name'           => 'Botswanan Pula',
        'iso'            => 'BWP',
        'symbol_intl'    => 'BWP',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BYN' => [
        'symbol'         => 'руб.',
        'name'           => 'Belarusian Ruble',
        'iso'            => 'BYN',
        'symbol_intl'    => 'Br',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'BZD' => [
        'symbol'         => '$',
        'name'           => 'Belize Dollar',
        'iso'            => 'BZD',
        'symbol_intl'    => 'BZ$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'CLP' => [
        'symbol'         => '$',
        'name'           => 'Chilean Peso',
        'iso'            => 'CLP',
        'symbol_intl'    => 'CL$',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'CNY' => [
        'symbol'         => 'CN¥',
        'name'           => 'Chinese Yuan',
        'iso'            => 'CNY',
        'symbol_intl'    => 'CN¥',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'COP' => [
        'symbol'         => '$',
        'name'           => 'Colombian Peso',
        'iso'            => 'COP',
        'symbol_intl'    => 'CO$',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'CRC' => [
        'symbol'         => '₡',
        'name'           => 'Costa Rican Colón',
        'iso'            => 'CRC',
        'symbol_intl'    => '₡',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'CVE' => [
        'symbol'         => 'CV$',
        'name'           => 'Cape Verdean Escudo',
        'iso'            => 'CVE',
        'symbol_intl'    => 'CV$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'CZK' => [
        'symbol'         => 'Kč',
        'name'           => 'Czech Republic Koruna',
        'iso'            => 'CZK',
        'symbol_intl'    => 'Kč',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'DKK' => [
        'symbol'         => 'kr',
        'name'           => 'Danish Krone',
        'iso'            => 'DKK',
        'symbol_intl'    => 'Dkr',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'DOP' => [
        'symbol'         => 'RD$',
        'name'           => 'Dominican Peso',
        'iso'            => 'DOP',
        'symbol_intl'    => 'RD$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'EEK' => [
        'symbol'         => 'kr',
        'name'           => 'Estonian Kroon',
        'iso'            => 'EEK',
        'symbol_intl'    => 'Ekr',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'EGP' => [
        'symbol'         => 'ج.م.‏',
        'name'           => 'Egyptian Pound',
        'iso'            => 'EGP',
        'symbol_intl'    => 'EGP',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'ERN' => [
        'symbol'         => 'Nfk',
        'name'           => 'Eritrean Nakfa',
        'iso'            => 'ERN',
        'symbol_intl'    => 'Nfk',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'ETB' => [
        'symbol'         => 'Br',
        'name'           => 'Ethiopian Birr',
        'iso'            => 'ETB',
        'symbol_intl'    => 'Br',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'GBP' => [
        'symbol'         => '£',
        'name'           => 'British Pound Sterling',
        'iso'            => 'GBP',
        'symbol_intl'    => '£',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'GEL' => [
        'symbol'         => 'GEL',
        'name'           => 'Georgian Lari',
        'iso'            => 'GEL',
        'symbol_intl'    => 'GEL',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'GHS' => [
        'symbol'         => 'GH₵',
        'name'           => 'Ghanaian Cedi',
        'iso'            => 'GHS',
        'symbol_intl'    => 'GH₵',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'GTQ' => [
        'symbol'         => 'Q',
        'name'           => 'Guatemalan Quetzal',
        'iso'            => 'GTQ',
        'symbol_intl'    => 'GTQ',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'HKD' => [
        'symbol'         => '$',
        'name'           => 'Hong Kong Dollar',
        'iso'            => 'HKD',
        'symbol_intl'    => 'HK$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'HNL' => [
        'symbol'         => 'L',
        'name'           => 'Honduran Lempira',
        'iso'            => 'HNL',
        'symbol_intl'    => 'HNL',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'HRK' => [
        'symbol'         => 'kn',
        'name'           => 'Croatian Kuna',
        'iso'            => 'HRK',
        'symbol_intl'    => 'kn',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'HUF' => [
        'symbol'         => 'Ft',
        'name'           => 'Hungarian Forint',
        'iso'            => 'HUF',
        'symbol_intl'    => 'Ft',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'IDR' => [
        'symbol'         => 'Rp',
        'name'           => 'Indonesian Rupiah',
        'iso'            => 'IDR',
        'symbol_intl'    => 'Rp',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'ILS' => [
        'symbol'         => '₪',
        'name'           => 'Israeli New Sheqel',
        'iso'            => 'ILS',
        'symbol_intl'    => '₪',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'INR' => [
        'symbol'         => 'টকা',
        'name'           => 'Indian Rupee',
        'iso'            => 'INR',
        'symbol_intl'    => 'Rs',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'IQD' => [
        'symbol'         => 'د.ع.‏',
        'name'           => 'Iraqi Dinar',
        'iso'            => 'IQD',
        'symbol_intl'    => 'IQD',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'IRR' => [
        'symbol'         => '﷼',
        'name'           => 'Iranian Rial',
        'iso'            => 'IRR',
        'symbol_intl'    => 'IRR',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'ISK' => [
        'symbol'         => 'kr',
        'name'           => 'Icelandic Króna',
        'iso'            => 'ISK',
        'symbol_intl'    => 'Ikr',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'JMD' => [
        'symbol'         => '$',
        'name'           => 'Jamaican Dollar',
        'iso'            => 'JMD',
        'symbol_intl'    => 'J$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'JOD' => [
        'symbol'         => 'د.أ.‏',
        'name'           => 'Jordanian Dinar',
        'iso'            => 'JOD',
        'symbol_intl'    => 'JD',
        'decimal_digits' => 3,
        'rounding'       => 0,
    ],
    'JPY' => [
        'symbol'         => '￥',
        'name'           => 'Japanese Yen',
        'iso'            => 'JPY',
        'symbol_intl'    => '¥',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'KES' => [
        'symbol'         => 'Ksh',
        'name'           => 'Kenyan Shilling',
        'iso'            => 'KES',
        'symbol_intl'    => 'Ksh',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'KHR' => [
        'symbol'         => '៛',
        'name'           => 'Cambodian Riel',
        'iso'            => 'KHR',
        'symbol_intl'    => 'KHR',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'KRW' => [
        'symbol'         => '₩',
        'name'           => 'South Korean Won',
        'iso'            => 'KRW',
        'symbol_intl'    => '₩',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'KWD' => [
        'symbol'         => 'د.ك.‏',
        'name'           => 'Kuwaiti Dinar',
        'iso'            => 'KWD',
        'symbol_intl'    => 'KD',
        'decimal_digits' => 3,
        'rounding'       => 0,
    ],
    'KZT' => [
        'symbol'         => 'тңг.',
        'name'           => 'Kazakhstani Tenge',
        'iso'            => 'KZT',
        'symbol_intl'    => 'KZT',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'LBP' => [
        'symbol'         => 'ل.ل.‏',
        'name'           => 'Lebanese Pound',
        'iso'            => 'LBP',
        'symbol_intl'    => 'LB£',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'LKR' => [
        'symbol'         => 'SL Re',
        'name'           => 'Sri Lankan Rupee',
        'iso'            => 'LKR',
        'symbol_intl'    => 'SLRs',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'LTL' => [
        'symbol'         => 'Lt',
        'name'           => 'Lithuanian Litas',
        'iso'            => 'LTL',
        'symbol_intl'    => 'Lt',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'LVL' => [
        'symbol'         => 'Ls',
        'name'           => 'Latvian Lats',
        'iso'            => 'LVL',
        'symbol_intl'    => 'Ls',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'LYD' => [
        'symbol'         => 'د.ل.‏',
        'name'           => 'Libyan Dinar',
        'iso'            => 'LYD',
        'symbol_intl'    => 'LD',
        'decimal_digits' => 3,
        'rounding'       => 0,
    ],
    'MDL' => [
        'symbol'         => 'MDL',
        'name'           => 'Moldovan Leu',
        'iso'            => 'MDL',
        'symbol_intl'    => 'MDL',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'MGA' => [
        'symbol'         => 'MGA',
        'name'           => 'Malagasy Ariary',
        'iso'            => 'MGA',
        'symbol_intl'    => 'MGA',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'MKD' => [
        'symbol'         => 'MKD',
        'name'           => 'Macedonian Denar',
        'iso'            => 'MKD',
        'symbol_intl'    => 'MKD',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'MMK' => [
        'symbol'         => 'K',
        'name'           => 'Myanma Kyat',
        'iso'            => 'MMK',
        'symbol_intl'    => 'MMK',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'MOP' => [
        'symbol'         => 'MOP$',
        'name'           => 'Macanese Pataca',
        'iso'            => 'MOP',
        'symbol_intl'    => 'MOP$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'MUR' => [
        'symbol'         => 'MURs',
        'name'           => 'Mauritian Rupee',
        'iso'            => 'MUR',
        'symbol_intl'    => 'MURs',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'MXN' => [
        'symbol'         => '$',
        'name'           => 'Mexican Peso',
        'iso'            => 'MXN',
        'symbol_intl'    => 'MX$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'MYR' => [
        'symbol'         => 'RM',
        'name'           => 'Malaysian Ringgit',
        'iso'            => 'MYR',
        'symbol_intl'    => 'RM',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'MZN' => [
        'symbol'         => 'MTn',
        'name'           => 'Mozambican Metical',
        'iso'            => 'MZN',
        'symbol_intl'    => 'MTn',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'NAD' => [
        'symbol'         => 'N$',
        'name'           => 'Namibian Dollar',
        'iso'            => 'NAD',
        'symbol_intl'    => 'N$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'NGN' => [
        'symbol'         => '₦',
        'name'           => 'Nigerian Naira',
        'iso'            => 'NGN',
        'symbol_intl'    => '₦',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'NIO' => [
        'symbol'         => 'C$',
        'name'           => 'Nicaraguan Córdoba',
        'iso'            => 'NIO',
        'symbol_intl'    => 'C$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'NOK' => [
        'symbol'         => 'kr',
        'name'           => 'Norwegian Krone',
        'iso'            => 'NOK',
        'symbol_intl'    => 'Nkr',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'NPR' => [
        'symbol'         => 'नेरू',
        'name'           => 'Nepalese Rupee',
        'iso'            => 'NPR',
        'symbol_intl'    => 'NPRs',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'NZD' => [
        'symbol'         => '$',
        'name'           => 'New Zealand Dollar',
        'iso'            => 'NZD',
        'symbol_intl'    => 'NZ$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'OMR' => [
        'symbol'         => 'ر.ع.‏',
        'name'           => 'Omani Rial',
        'iso'            => 'OMR',
        'symbol_intl'    => 'OMR',
        'decimal_digits' => 3,
        'rounding'       => 0,
    ],
    'PAB' => [
        'symbol'         => 'B/.',
        'name'           => 'Panamanian Balboa',
        'iso'            => 'PAB',
        'symbol_intl'    => 'B/.',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'PEN' => [
        'symbol'         => 'S/.',
        'name'           => 'Peruvian Nuevo Sol',
        'iso'            => 'PEN',
        'symbol_intl'    => 'S/.',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'PHP' => [
        'symbol'         => '₱',
        'name'           => 'Philippine Peso',
        'iso'            => 'PHP',
        'symbol_intl'    => '₱',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'PKR' => [
        'symbol'         => '₨',
        'name'           => 'Pakistani Rupee',
        'iso'            => 'PKR',
        'symbol_intl'    => 'PKRs',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'PLN' => [
        'symbol'         => 'zł',
        'name'           => 'Polish Zloty',
        'iso'            => 'PLN',
        'symbol_intl'    => 'zł',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'PYG' => [
        'symbol'         => '₲',
        'name'           => 'Paraguayan Guarani',
        'iso'            => 'PYG',
        'symbol_intl'    => '₲',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'QAR' => [
        'symbol'         => 'ر.ق.‏',
        'name'           => 'Qatari Rial',
        'iso'            => 'QAR',
        'symbol_intl'    => 'QR',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'RON' => [
        'symbol'         => 'RON',
        'name'           => 'Romanian Leu',
        'iso'            => 'RON',
        'symbol_intl'    => 'RON',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'RSD' => [
        'symbol'         => 'дин.',
        'name'           => 'Serbian Dinar',
        'iso'            => 'RSD',
        'symbol_intl'    => 'din.',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'RUB' => [
        'symbol'         => '₽.',
        'name'           => 'Russian Ruble',
        'iso'            => 'RUB',
        'symbol_intl'    => 'RUB',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'SAR' => [
        'symbol'         => 'ر.س.‏',
        'name'           => 'Saudi Riyal',
        'iso'            => 'SAR',
        'symbol_intl'    => 'SR',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'SDG' => [
        'symbol'         => 'SDG',
        'name'           => 'Sudanese Pound',
        'iso'            => 'SDG',
        'symbol_intl'    => 'SDG',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'SEK' => [
        'symbol'         => 'kr',
        'name'           => 'Swedish Krona',
        'iso'            => 'SEK',
        'symbol_intl'    => 'Skr',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'SGD' => [
        'symbol'         => '$',
        'name'           => 'Singapore Dollar',
        'iso'            => 'SGD',
        'symbol_intl'    => 'S$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'SOS' => [
        'symbol'         => 'Ssh',
        'name'           => 'Somali Shilling',
        'iso'            => 'SOS',
        'symbol_intl'    => 'Ssh',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'SYP' => [
        'symbol'         => 'ل.س.‏',
        'name'           => 'Syrian Pound',
        'iso'            => 'SYP',
        'symbol_intl'    => 'SY£',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'THB' => [
        'symbol'         => '฿',
        'name'           => 'Thai Baht',
        'iso'            => 'THB',
        'symbol_intl'    => '฿',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'TOP' => [
        'symbol'         => 'T$',
        'name'           => 'Tongan Paʻanga',
        'iso'            => 'TOP',
        'symbol_intl'    => 'T$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'TRY' => [
        'symbol'         => 'TL',
        'name'           => 'Turkish Lira',
        'iso'            => 'TRY',
        'symbol_intl'    => 'TL',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'TTD' => [
        'symbol'         => '$',
        'name'           => 'Trinidad and Tobago Dollar',
        'iso'            => 'TTD',
        'symbol_intl'    => 'TT$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'TWD' => [
        'symbol'         => 'NT$',
        'name'           => 'New Taiwan Dollar',
        'iso'            => 'TWD',
        'symbol_intl'    => 'NT$',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'TZS' => [
        'symbol'         => 'TSh',
        'name'           => 'Tanzanian Shilling',
        'iso'            => 'TZS',
        'symbol_intl'    => 'TSh',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'UAH' => [
        'symbol'         => '₴',
        'name'           => 'Ukrainian Hryvnia',
        'iso'            => 'UAH',
        'symbol_intl'    => '₴',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'UGX' => [
        'symbol'         => 'USh',
        'name'           => 'Ugandan Shilling',
        'iso'            => 'UGX',
        'symbol_intl'    => 'USh',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'UYU' => [
        'symbol'         => '$',
        'name'           => 'Uruguayan Peso',
        'iso'            => 'UYU',
        'symbol_intl'    => '$U',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'UZS' => [
        'symbol'         => 'UZS',
        'name'           => 'Uzbekistan Som',
        'iso'            => 'UZS',
        'symbol_intl'    => 'UZS',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'VEF' => [
        'symbol'         => 'Bs.F.',
        'name'           => 'Venezuelan Bolívar',
        'iso'            => 'VEF',
        'symbol_intl'    => 'Bs.F.',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'VND' => [
        'symbol'         => '₫',
        'name'           => 'Vietnamese Dong',
        'iso'            => 'VND',
        'symbol_intl'    => '₫',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'YER' => [
        'symbol'         => 'ر.ي.‏',
        'name'           => 'Yemeni Rial',
        'iso'            => 'YER',
        'symbol_intl'    => 'YR',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'ZAR' => [
        'symbol'         => 'R',
        'name'           => 'South African Rand',
        'iso'            => 'ZAR',
        'symbol_intl'    => 'R',
        'decimal_digits' => 2,
        'rounding'       => 0,
    ],
    'ZMK' => [
        'symbol'         => 'ZK',
        'name'           => 'Zambian Kwacha',
        'iso'            => 'ZMK',
        'symbol_intl'    => 'ZK',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
    'ZWL' => [
        'symbol'         => 'ZWL$',
        'name'           => 'Zimbabwean Dollar',
        'iso'            => 'ZWL',
        'symbol_intl'    => 'ZWL$',
        'decimal_digits' => 0,
        'rounding'       => 0,
    ],
];
